/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListSupportedAssetsResponseItem {
    /// Defines the unique ID of the specific asset.
    #[serde(rename = "assetId")]
    pub asset_id: String,
    /// Specifies the name of the asset in question.
    #[serde(rename = "assetName")]
    pub asset_name: String,
    /// Specifies the asset's unique symbol in the Crypto APIs listings.
    #[serde(rename = "assetSymbol")]
    pub asset_symbol: String,
    /// Defines the type of the supported asset. This could be either \"crypto\" or \"fiat\".
    #[serde(rename = "assetType")]
    pub asset_type: AssetType,
    /// Specifies the asset's original symbol as introduced by its founders.
    #[serde(rename = "originalSymbol")]
    pub original_symbol: String,
}

impl ListSupportedAssetsResponseItem {
    pub fn new(asset_id: String, asset_name: String, asset_symbol: String, asset_type: AssetType, original_symbol: String) -> ListSupportedAssetsResponseItem {
        ListSupportedAssetsResponseItem {
            asset_id,
            asset_name,
            asset_symbol,
            asset_type,
            original_symbol,
        }
    }
}

/// Defines the type of the supported asset. This could be either \"crypto\" or \"fiat\".
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum AssetType {
    #[serde(rename = "fiat")]
    Fiat,
    #[serde(rename = "crypto")]
    Crypto,
}

