/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */

/// ListAssetsDetailsResponseItemSpecificData : Represents a specific asset's data depending on its type (whether it is \"crypto\" or \"fiat\").



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ListAssetsDetailsResponseItemSpecificData {
    /// Represents the percentage of the asset's current price against the its price from 1 hour ago.
    #[serde(rename = "1HourPriceChangeInPercentage")]
    pub var_1_hour_price_change_in_percentage: String,
    /// Represents the percentage of the asset's current price against the its price from 1 week ago.
    #[serde(rename = "1WeekPriceChangeInPercentage")]
    pub var_1_week_price_change_in_percentage: String,
    /// Represents the percentage of the asset's current price against the its price from 24 hours ago.
    #[serde(rename = "24HoursPriceChangeInPercentage")]
    pub var_24_hours_price_change_in_percentage: String,
    /// Represents the trading volume of the asset for the time frame of 24 hours.
    #[serde(rename = "24HoursTradingVolume")]
    pub var_24_hours_trading_volume: String,
    /// Represents the amount of the asset that is circulating on the market and in public hands.
    #[serde(rename = "circulatingSupply")]
    pub circulating_supply: String,
    /// Defines the total market value of the asset's circulating supply in USD.
    #[serde(rename = "marketCapInUSD")]
    pub market_cap_in_usd: String,
    /// Represents the maximum amount of all coins of a specific asset that will ever exist in its lifetime.
    #[serde(rename = "maxSupply")]
    pub max_supply: String,
}

impl ListAssetsDetailsResponseItemSpecificData {
    /// Represents a specific asset's data depending on its type (whether it is \"crypto\" or \"fiat\").
    pub fn new(var_1_hour_price_change_in_percentage: String, var_1_week_price_change_in_percentage: String, var_24_hours_price_change_in_percentage: String, var_24_hours_trading_volume: String, circulating_supply: String, market_cap_in_usd: String, max_supply: String) -> ListAssetsDetailsResponseItemSpecificData {
        ListAssetsDetailsResponseItemSpecificData {
            var_1_hour_price_change_in_percentage,
            var_1_week_price_change_in_percentage,
            var_24_hours_price_change_in_percentage,
            var_24_hours_trading_volume,
            circulating_supply,
            market_cap_in_usd,
            max_supply,
        }
    }
}


