/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItem {
    /// Defines the amount of the sent tokens.
    #[serde(rename = "amount")]
    pub amount: String,
    /// Defines whether the attribute can be divisible or not, as boolean. E.g., if it is \"true\", the attribute is divisible.
    #[serde(rename = "divisible")]
    pub divisible: bool,
    /// Defines whether the transaction has been mined or not, as boolean. E.g. if set to \"true\", it means the transaction is mined.
    #[serde(rename = "mined")]
    pub mined: bool,
    /// Represents the identifier of the tokens to send.
    #[serde(rename = "propertyId")]
    pub property_id: i32,
    /// Represents an object of addresses that receive the transactions.
    #[serde(rename = "recipients")]
    pub recipients: Vec<crate::models::GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItemRecipients>,
    /// Represents an object of addresses that provide the funds.
    #[serde(rename = "senders")]
    pub senders: Vec<crate::models::GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItemSenders>,
    /// Defines whether the transaction has been sent or not, as boolean. E.g. if set to \"true\", it means the transaction is sent.
    #[serde(rename = "sent")]
    pub sent: bool,
    /// Defines the exact date/time in Unix Timestamp when this transaction was mined, confirmed or first seen in Mempool, if it is unconfirmed.
    #[serde(rename = "timestamp")]
    pub timestamp: i32,
    /// String representation of the transaction identifier (txid)
    #[serde(rename = "transactionId")]
    pub transaction_id: String,
    /// Defines the type of the transaction as a string.
    #[serde(rename = "type")]
    pub _type: String,
    /// Defines the type of the transaction as a number.
    #[serde(rename = "typeInt")]
    pub type_int: i32,
    /// Defines the specific version.
    #[serde(rename = "version")]
    pub version: i32,
    #[serde(rename = "fee")]
    pub fee: Box<crate::models::ListUnconfirmedOmniTransactionsByAddressResponseItemFee>,
}

impl GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItem {
    pub fn new(amount: String, divisible: bool, mined: bool, property_id: i32, recipients: Vec<crate::models::GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItemRecipients>, senders: Vec<crate::models::GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItemSenders>, sent: bool, timestamp: i32, transaction_id: String, _type: String, type_int: i32, version: i32, fee: crate::models::ListUnconfirmedOmniTransactionsByAddressResponseItemFee) -> GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItem {
        GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItem {
            amount,
            divisible,
            mined,
            property_id,
            recipients,
            senders,
            sent,
            timestamp,
            transaction_id,
            _type,
            type_int,
            version,
            fee: Box::new(fee),
        }
    }
}


