/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetFeeRecommendationsResponseItem {
    /// Defines the unit of the fee, e.g. BTC.
    #[serde(rename = "unit")]
    pub unit: String,
    /// Defines the fee priority as \"FAST\". It works per byte, for UTXO-based protocols like Bitcoin, or per gas price, for account-based protocols like Ethereum. These are calculated based on Mempool.
    #[serde(rename = "fast")]
    pub fast: String,
    /// Defines the fee priority as \"SLOW\". It works per byte, for UTXO-based protocols like Bitcoin, or per gas price, for account-based protocols like Ethereum. These are calculated based on Mempool.
    #[serde(rename = "slow")]
    pub slow: String,
    /// Defines the fee priority as \"STANDARD\". It works per byte, for UTXO-based protocols like Bitcoin, or per gas price, for account-based protocols like Ethereum. These are calculated based on Mempool.
    #[serde(rename = "standard")]
    pub standard: String,
}

impl GetFeeRecommendationsResponseItem {
    pub fn new(unit: String, fast: String, slow: String, standard: String) -> GetFeeRecommendationsResponseItem {
        GetFeeRecommendationsResponseItem {
            unit,
            fast,
            slow,
            standard,
        }
    }
}


