/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetExchangeRateByAssetsIdsResponseItem {
    /// Defines the time of the market data used to calculate the exchange rate in UNIX Timestamp.
    #[serde(rename = "calculationTimestamp")]
    pub calculation_timestamp: i32,
    /// Defines the base asset Reference ID to get a rate for.
    #[serde(rename = "fromAssetId")]
    pub from_asset_id: String,
    /// Defines the base asset symbol to get a rate for.
    #[serde(rename = "fromAssetSymbol")]
    pub from_asset_symbol: String,
    /// Defines the exchange rate between assets calculated by weighted average of the last trades in every exchange for the last 24 hours by giving more weight to exchanges with higher volume.
    #[serde(rename = "rate")]
    pub rate: String,
    /// Defines the relation asset Reference ID in which the base asset rate will be displayed.
    #[serde(rename = "toAssetId")]
    pub to_asset_id: String,
    /// Defines the relation asset symbol in which the base asset rate will be displayed.
    #[serde(rename = "toAssetSymbol")]
    pub to_asset_symbol: String,
}

impl GetExchangeRateByAssetsIdsResponseItem {
    pub fn new(calculation_timestamp: i32, from_asset_id: String, from_asset_symbol: String, rate: String, to_asset_id: String, to_asset_symbol: String) -> GetExchangeRateByAssetsIdsResponseItem {
        GetExchangeRateByAssetsIdsResponseItem {
            calculation_timestamp,
            from_asset_id,
            from_asset_symbol,
            rate,
            to_asset_id,
            to_asset_symbol,
        }
    }
}


