/*
 * CryptoAPIs
 *
 * Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: developers@cryptoapis.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GetContractDetailsByAddressResponseItem {
    /// Token balance
    #[serde(rename = "confirmedBalance")]
    pub confirmed_balance: String,
    /// Token creator
    #[serde(rename = "creatorAddress")]
    pub creator_address: String,
    /// Number of decimals
    #[serde(rename = "tokenDecimals", skip_serializing_if = "Option::is_none")]
    pub token_decimals: Option<String>,
    /// Token name
    #[serde(rename = "tokenName", skip_serializing_if = "Option::is_none")]
    pub token_name: Option<String>,
    /// Token symbol
    #[serde(rename = "tokenSymbol", skip_serializing_if = "Option::is_none")]
    pub token_symbol: Option<String>,
    /// Token type
    #[serde(rename = "tokenType", skip_serializing_if = "Option::is_none")]
    pub token_type: Option<String>,
    /// Token balance
    #[serde(rename = "tokensBalance")]
    pub tokens_balance: String,
    /// Token total supply
    #[serde(rename = "totalSupply")]
    pub total_supply: String,
}

impl GetContractDetailsByAddressResponseItem {
    pub fn new(confirmed_balance: String, creator_address: String, tokens_balance: String, total_supply: String) -> GetContractDetailsByAddressResponseItem {
        GetContractDetailsByAddressResponseItem {
            confirmed_balance,
            creator_address,
            token_decimals: None,
            token_name: None,
            token_symbol: None,
            token_type: None,
            tokens_balance,
            total_supply,
        }
    }
}


