# Rust API client for cryptoapis

Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 2.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.RustClientCodegen
For more information, please visit [https://cryptoapis.io](https://cryptoapis.io)

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *https://rest.cryptoapis.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AssetsApi* | [**list_assets_details**](docs/AssetsApi.md#list_assets_details) | **get** /market-data/assets/details | List Assets Details
*AutomaticCoinsForwardingApi* | [**create_automatic_coins_forwarding**](docs/AutomaticCoinsForwardingApi.md#create_automatic_coins_forwarding) | **post** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations | Create Automatic Coins Forwarding
*AutomaticCoinsForwardingApi* | [**delete_automatic_coins_forwarding**](docs/AutomaticCoinsForwardingApi.md#delete_automatic_coins_forwarding) | **delete** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations/{referenceId} | Delete Automatic Coins Forwarding
*AutomaticCoinsForwardingApi* | [**list_coins_forwarding_automations**](docs/AutomaticCoinsForwardingApi.md#list_coins_forwarding_automations) | **get** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations | List Coins Forwarding Automations
*AutomaticTokensForwardingApi* | [**add_tokens_to_existing_from_address**](docs/AutomaticTokensForwardingApi.md#add_tokens_to_existing_from_address) | **post** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations/add-token | Add Tokens To Existing fromAddress
*AutomaticTokensForwardingApi* | [**create_automatic_tokens_forwarding**](docs/AutomaticTokensForwardingApi.md#create_automatic_tokens_forwarding) | **post** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations | Create Automatic Tokens Forwarding
*AutomaticTokensForwardingApi* | [**delete_automatic_tokens_forwarding**](docs/AutomaticTokensForwardingApi.md#delete_automatic_tokens_forwarding) | **delete** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations/{referenceId} | Delete Automatic Tokens Forwarding
*AutomaticTokensForwardingApi* | [**get_fee_address_details**](docs/AutomaticTokensForwardingApi.md#get_fee_address_details) | **get** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/fee-addresses | Get Fee Address Details
*AutomaticTokensForwardingApi* | [**list_tokens_forwarding_automations**](docs/AutomaticTokensForwardingApi.md#list_tokens_forwarding_automations) | **get** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations | List Tokens Forwarding Automations
*CreateSubscriptionsForApi* | [**mined_transaction**](docs/CreateSubscriptionsForApi.md#mined_transaction) | **post** /blockchain-events/{blockchain}/{network}/subscriptions/transaction-mined | Mined transaction
*CreateSubscriptionsForApi* | [**new_block**](docs/CreateSubscriptionsForApi.md#new_block) | **post** /blockchain-events/{blockchain}/{network}/subscriptions/block-mined | New Block
*CreateSubscriptionsForApi* | [**new_confirmed_coins_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_coins_transactions) | **post** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-confirmed | New confirmed coins transactions
*CreateSubscriptionsForApi* | [**new_confirmed_coins_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_coins_transactions_and_each_confirmation) | **post** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-confirmed-each-confirmation | New confirmed coins transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_confirmed_tokens_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_tokens_transactions) | **post** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-confirmed | New confirmed tokens transactions
*CreateSubscriptionsForApi* | [**new_confirmed_tokens_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_tokens_transactions_and_each_confirmation) | **post** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-confirmed-each-confirmation | New confirmed tokens transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_unconfirmed_coins_transactions**](docs/CreateSubscriptionsForApi.md#new_unconfirmed_coins_transactions) | **post** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-unconfirmed | New unconfirmed coins transactions
*CreateSubscriptionsForApi* | [**new_unconfirmed_tokens_transactions**](docs/CreateSubscriptionsForApi.md#new_unconfirmed_tokens_transactions) | **post** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-unconfirmed | New unconfirmed tokens transactions
*DefaultApi* | [**get_contract_details_by_address**](docs/DefaultApi.md#get_contract_details_by_address) | **get** /blockchain-data/{blockchain}/{network}/addresses/{contractAddress}/contract | Get Contract Details by Address
*ExchangeRatesApi* | [**get_exchange_rate_by_asset_symbols**](docs/ExchangeRatesApi.md#get_exchange_rate_by_asset_symbols) | **get** /market-data/exchange-rates/by-symbols/{fromAssetSymbol}/{toAssetSymbol} | Get Exchange Rate By Asset Symbols
*ExchangeRatesApi* | [**get_exchange_rate_by_assets_ids**](docs/ExchangeRatesApi.md#get_exchange_rate_by_assets_ids) | **get** /market-data/exchange-rates/by-asset-ids/{fromAssetId}/{toAssetId} | Get Exchange Rate By Assets IDs
*ManageSubscriptionsApi* | [**delete_blockchain_event_subscription**](docs/ManageSubscriptionsApi.md#delete_blockchain_event_subscription) | **delete** /blockchain-events/{blockchain}/{network}/subscriptions/{referenceId} | Delete Blockchain Event Subscription
*ManageSubscriptionsApi* | [**list_blockchain_events_subscriptions**](docs/ManageSubscriptionsApi.md#list_blockchain_events_subscriptions) | **get** /blockchain-events/{blockchain}/{network}/subscriptions | List Blockchain Events Subscriptions
*MetadataApi* | [**list_supported_assets**](docs/MetadataApi.md#list_supported_assets) | **get** /market-data/assets/supported | List Supported Assets
*OmniLayerApi* | [**get_omni_transaction_details_by_transaction_id__txid**](docs/OmniLayerApi.md#get_omni_transaction_details_by_transaction_id__txid) | **get** /blockchain-data/{blockchain}/{network}/omni/transactions/{transactionId} | Get Omni Transaction Details By Transaction ID (Txid)
*OmniLayerApi* | [**get_unconfirmed_omni_transaction_by_transaction_id__txid**](docs/OmniLayerApi.md#get_unconfirmed_omni_transaction_by_transaction_id__txid) | **get** /blockchain-data/{blockchain}/{network}/omni/transactions-unconfirmed/{transactionId} | Get Unconfirmed Omni Transaction By Transaction ID (Txid)
*OmniLayerApi* | [**list_omni_tokens_by_address**](docs/OmniLayerApi.md#list_omni_tokens_by_address) | **get** /blockchain-data/{blockchain}/{network}/omni/addresses/{address} | List Omni Tokens By Address
*OmniLayerApi* | [**list_omni_transactions_by_address**](docs/OmniLayerApi.md#list_omni_transactions_by_address) | **get** /blockchain-data/{blockchain}/{network}/omni/addresses/{address}/transactions | List Omni Transactions By Address
*OmniLayerApi* | [**list_omni_transactions_by_block_hash**](docs/OmniLayerApi.md#list_omni_transactions_by_block_hash) | **get** /blockchain-data/{blockchain}/{network}/omni/blocks/hash/{blockHash}/transactions | List Omni Transactions By Block Hash
*OmniLayerApi* | [**list_omni_transactions_by_block_height**](docs/OmniLayerApi.md#list_omni_transactions_by_block_height) | **get** /blockchain-data/{blockchain}/{network}/omni/blocks/height/{blockHeight}/transactions | List Omni Transactions By Block Height
*OmniLayerApi* | [**list_unconfirmed_omni_transactions_by_address**](docs/OmniLayerApi.md#list_unconfirmed_omni_transactions_by_address) | **get** /blockchain-data/{blockchain}/{network}/omni/address-transactions-unconfirmed/{address} | List Unconfirmed Omni Transactions By Address
*OmniLayerApi* | [**list_unconfirmed_omni_transactions_by_property_id**](docs/OmniLayerApi.md#list_unconfirmed_omni_transactions_by_property_id) | **get** /blockchain-data/{blockchain}/{network}/omni/properties/{propertyId}/transactions | List Unconfirmed Omni Transactions By Property ID
*TokensApi* | [**list_tokens_by_address**](docs/TokensApi.md#list_tokens_by_address) | **get** /blockchain-data/{blockchain}/{network}/addresses/{address}/tokens | List Tokens By Address
*TokensApi* | [**list_tokens_transfers_by_address**](docs/TokensApi.md#list_tokens_transfers_by_address) | **get** /blockchain-data/{blockchain}/{network}/addresses/{address}/tokens-transfers | List Tokens Transfers By Address
*TokensApi* | [**list_tokens_transfers_by_transaction_hash**](docs/TokensApi.md#list_tokens_transfers_by_transaction_hash) | **get** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/tokens-transfers | List Tokens Transfers By Transaction Hash
*UTXOBasedApi* | [**get_hd_wallet__x_pub_y_pub_z_pub_details**](docs/UTXOBasedApi.md#get_hd_wallet__x_pub_y_pub_z_pub_details) | **get** /blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/details | Get HD Wallet (xPub, yPub, zPub) Details
*UTXOBasedApi* | [**list_hd_wallet__x_pub_y_pub_z_pub_transactions**](docs/UTXOBasedApi.md#list_hd_wallet__x_pub_y_pub_z_pub_transactions) | **get** /blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/transactions | List HD Wallet (xPub, yPub, zPub) Transactions
*UTXOBasedApi* | [**sync_hd_wallet__x_pub_y_pub_z_pub**](docs/UTXOBasedApi.md#sync_hd_wallet__x_pub_y_pub_z_pub) | **post** /blockchain-data/{blockchain}/{network}/hd/sync | Sync HD Wallet (xPub, yPub, zPub)
*UnifiedEndpointsApi* | [**get_address_details**](docs/UnifiedEndpointsApi.md#get_address_details) | **get** /blockchain-data/{blockchain}/{network}/addresses/{address} | Get Address Details
*UnifiedEndpointsApi* | [**get_block_details_by_block_hash**](docs/UnifiedEndpointsApi.md#get_block_details_by_block_hash) | **get** /blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash} | Get Block Details By Block Hash
*UnifiedEndpointsApi* | [**get_block_details_by_block_height**](docs/UnifiedEndpointsApi.md#get_block_details_by_block_height) | **get** /blockchain-data/{blockchain}/{network}/blocks/height/{height} | Get Block Details By Block Height
*UnifiedEndpointsApi* | [**get_fee_recommendations**](docs/UnifiedEndpointsApi.md#get_fee_recommendations) | **get** /blockchain-data/{blockchain}/{network}/mempool/fees | Get Fee Recommendations
*UnifiedEndpointsApi* | [**get_latest_mined_block**](docs/UnifiedEndpointsApi.md#get_latest_mined_block) | **get** /blockchain-data/{blockchain}/{network}/blocks/last | Get Latest Mined Block
*UnifiedEndpointsApi* | [**get_transaction_details_by_transaction_id**](docs/UnifiedEndpointsApi.md#get_transaction_details_by_transaction_id) | **get** /blockchain-data/{blockchain}/{network}/transactions/{transactionId} | Get Transaction Details By Transaction ID
*UnifiedEndpointsApi* | [**list_transactions_by_address**](docs/UnifiedEndpointsApi.md#list_transactions_by_address) | **get** /blockchain-data/{blockchain}/{network}/addresses/{address}/transactions | List Transactions By Address
*UnifiedEndpointsApi* | [**list_transactions_by_block_hash**](docs/UnifiedEndpointsApi.md#list_transactions_by_block_hash) | **get** /blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash}/transactions | List Transactions by Block Hash
*UnifiedEndpointsApi* | [**list_transactions_by_block_height**](docs/UnifiedEndpointsApi.md#list_transactions_by_block_height) | **get** /blockchain-data/{blockchain}/{network}/blocks/height/{height}/transactions | List Transactions by Block Height
*ValidatingApi* | [**validate_address**](docs/ValidatingApi.md#validate_address) | **post** /blockchain-tools/{blockchain}/{network}/addresses/validate | Validate Address
*XRPRippleApi* | [**get_latest_mined_xrp__ripple_block**](docs/XRPRippleApi.md#get_latest_mined_xrp__ripple_block) | **get** /blockchain-data/xrp/{network}/blocks/last | Get Latest Mined XRP (Ripple) Block
*XRPRippleApi* | [**get_xrp__ripple_address_details**](docs/XRPRippleApi.md#get_xrp__ripple_address_details) | **get** /blockchain-data/xrp/{network}/addresses/{address} | Get XRP (Ripple) Address Details
*XRPRippleApi* | [**get_xrp__ripple_block_details_by_block_hash**](docs/XRPRippleApi.md#get_xrp__ripple_block_details_by_block_hash) | **get** /blockchain-data/xrp/{network}/blocks/hash/{blockHash} | Get XRP (Ripple) Block Details By Block Hash
*XRPRippleApi* | [**get_xrp__ripple_block_details_by_block_height**](docs/XRPRippleApi.md#get_xrp__ripple_block_details_by_block_height) | **get** /blockchain-data/xrp/{network}/blocks/height/{height} | Get XRP (Ripple) Block Details By Block Height
*XRPRippleApi* | [**get_xrp__ripple_transaction_details_by_transaction_id**](docs/XRPRippleApi.md#get_xrp__ripple_transaction_details_by_transaction_id) | **get** /blockchain-data/xrp/{network}/transactions/{transactionHash} | Get XRP (Ripple) Transaction Details By Transaction ID
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_address**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_address) | **get** /blockchain-data/xrp/{network}/addresses/{address}/transactions | List XRP (Ripple) Transactions by Address
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_block_hash**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_block_hash) | **get** /blockchain-data/xrp/{network}/blocks/hash/{blockHash}/transactions | List XRP (Ripple) Transactions By Block Hash


## Documentation For Models

 - [AddTokensToExistingFromAddressRequestBody](docs/AddTokensToExistingFromAddressRequestBody.md)
 - [AddTokensToExistingFromAddressRequestBodyData](docs/AddTokensToExistingFromAddressRequestBodyData.md)
 - [AddTokensToExistingFromAddressRequestBodyDataItem](docs/AddTokensToExistingFromAddressRequestBodyDataItem.md)
 - [AddTokensToExistingFromAddressRequestBodyTokenData](docs/AddTokensToExistingFromAddressRequestBodyTokenData.md)
 - [AddTokensToExistingFromAddressRequestBodyTokenDataBitcoinOmniToken](docs/AddTokensToExistingFromAddressRequestBodyTokenDataBitcoinOmniToken.md)
 - [AddTokensToExistingFromAddressRequestBodyTokenDataEthereumErc20Token](docs/AddTokensToExistingFromAddressRequestBodyTokenDataEthereumErc20Token.md)
 - [AddTokensToExistingFromAddressResponse](docs/AddTokensToExistingFromAddressResponse.md)
 - [AddTokensToExistingFromAddressResponseData](docs/AddTokensToExistingFromAddressResponseData.md)
 - [AddTokensToExistingFromAddressResponseItem](docs/AddTokensToExistingFromAddressResponseItem.md)
 - [AddTokensToExistingFromAddressResponseItemTokenData](docs/AddTokensToExistingFromAddressResponseItemTokenData.md)
 - [AddTokensToExistingFromAddressResponseItemTokenDataBitcoinOmniToken](docs/AddTokensToExistingFromAddressResponseItemTokenDataBitcoinOmniToken.md)
 - [AddTokensToExistingFromAddressResponseItemTokenDataEthereumErc20Token](docs/AddTokensToExistingFromAddressResponseItemTokenDataEthereumErc20Token.md)
 - [AddressCoinsTransactionConfirmed](docs/AddressCoinsTransactionConfirmed.md)
 - [AddressCoinsTransactionConfirmedData](docs/AddressCoinsTransactionConfirmedData.md)
 - [AddressCoinsTransactionConfirmedDataItem](docs/AddressCoinsTransactionConfirmedDataItem.md)
 - [AddressCoinsTransactionConfirmedDataItemMinedInBlock](docs/AddressCoinsTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressCoinsTransactionConfirmedEachConfirmation](docs/AddressCoinsTransactionConfirmedEachConfirmation.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationData](docs/AddressCoinsTransactionConfirmedEachConfirmationData.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationDataItem](docs/AddressCoinsTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock](docs/AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock.md)
 - [AddressCoinsTransactionUnconfirmed](docs/AddressCoinsTransactionUnconfirmed.md)
 - [AddressCoinsTransactionUnconfirmedData](docs/AddressCoinsTransactionUnconfirmedData.md)
 - [AddressCoinsTransactionUnconfirmedDataItem](docs/AddressCoinsTransactionUnconfirmedDataItem.md)
 - [AddressTokensTransactionConfirmed](docs/AddressTokensTransactionConfirmed.md)
 - [AddressTokensTransactionConfirmedData](docs/AddressTokensTransactionConfirmedData.md)
 - [AddressTokensTransactionConfirmedDataItem](docs/AddressTokensTransactionConfirmedDataItem.md)
 - [AddressTokensTransactionConfirmedDataItemMinedInBlock](docs/AddressTokensTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressTokensTransactionConfirmedEachConfirmation](docs/AddressTokensTransactionConfirmedEachConfirmation.md)
 - [AddressTokensTransactionConfirmedEachConfirmationData](docs/AddressTokensTransactionConfirmedEachConfirmationData.md)
 - [AddressTokensTransactionConfirmedEachConfirmationDataItem](docs/AddressTokensTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock](docs/AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock.md)
 - [AddressTokensTransactionConfirmedEachConfirmationEthereumerc20token](docs/AddressTokensTransactionConfirmedEachConfirmationEthereumerc20token.md)
 - [AddressTokensTransactionConfirmedEachConfirmationEthereumerc721token](docs/AddressTokensTransactionConfirmedEachConfirmationEthereumerc721token.md)
 - [AddressTokensTransactionConfirmedEachConfirmationOmnilayertoken](docs/AddressTokensTransactionConfirmedEachConfirmationOmnilayertoken.md)
 - [AddressTokensTransactionConfirmedEachConfirmationToken](docs/AddressTokensTransactionConfirmedEachConfirmationToken.md)
 - [AddressTokensTransactionConfirmedEthereumerc20token](docs/AddressTokensTransactionConfirmedEthereumerc20token.md)
 - [AddressTokensTransactionConfirmedEthereumerc721token](docs/AddressTokensTransactionConfirmedEthereumerc721token.md)
 - [AddressTokensTransactionConfirmedOmnilayertoken](docs/AddressTokensTransactionConfirmedOmnilayertoken.md)
 - [AddressTokensTransactionConfirmedToken](docs/AddressTokensTransactionConfirmedToken.md)
 - [AddressTokensTransactionUnconfirmed](docs/AddressTokensTransactionUnconfirmed.md)
 - [AddressTokensTransactionUnconfirmedData](docs/AddressTokensTransactionUnconfirmedData.md)
 - [AddressTokensTransactionUnconfirmedDataItem](docs/AddressTokensTransactionUnconfirmedDataItem.md)
 - [AddressTokensTransactionUnconfirmedEthereumerc20token](docs/AddressTokensTransactionUnconfirmedEthereumerc20token.md)
 - [AddressTokensTransactionUnconfirmedEthereumerc721token](docs/AddressTokensTransactionUnconfirmedEthereumerc721token.md)
 - [AddressTokensTransactionUnconfirmedOmnilayertoken](docs/AddressTokensTransactionUnconfirmedOmnilayertoken.md)
 - [AddressTokensTransactionUnconfirmedToken](docs/AddressTokensTransactionUnconfirmedToken.md)
 - [AlreadyExists](docs/AlreadyExists.md)
 - [AlreadyExistsError](docs/AlreadyExistsError.md)
 - [BannedIpAddress](docs/BannedIpAddress.md)
 - [BannedIpAddressError](docs/BannedIpAddressError.md)
 - [BannedIpAddressErrorDetails](docs/BannedIpAddressErrorDetails.md)
 - [BlockMined](docs/BlockMined.md)
 - [BlockMinedData](docs/BlockMinedData.md)
 - [BlockMinedDataItem](docs/BlockMinedDataItem.md)
 - [BlockchainDataBlockNotFound](docs/BlockchainDataBlockNotFound.md)
 - [BlockchainDataBlockNotFoundError](docs/BlockchainDataBlockNotFoundError.md)
 - [BlockchainDataTransactionNotFound](docs/BlockchainDataTransactionNotFound.md)
 - [BlockchainDataTransactionNotFoundError](docs/BlockchainDataTransactionNotFoundError.md)
 - [BlockchainEventsCallbacksLimitReached](docs/BlockchainEventsCallbacksLimitReached.md)
 - [BlockchainEventsCallbacksLimitReachedError](docs/BlockchainEventsCallbacksLimitReachedError.md)
 - [CoinsForwardingAutomationsLimitReached](docs/CoinsForwardingAutomationsLimitReached.md)
 - [CoinsForwardingAutomationsLimitReachedError](docs/CoinsForwardingAutomationsLimitReachedError.md)
 - [CoinsForwardingFail](docs/CoinsForwardingFail.md)
 - [CoinsForwardingFailData](docs/CoinsForwardingFailData.md)
 - [CoinsForwardingFailDataItem](docs/CoinsForwardingFailDataItem.md)
 - [CoinsForwardingSuccess](docs/CoinsForwardingSuccess.md)
 - [CoinsForwardingSuccessData](docs/CoinsForwardingSuccessData.md)
 - [CoinsForwardingSuccessDataItem](docs/CoinsForwardingSuccessDataItem.md)
 - [CouldNotCalculateRateForPair](docs/CouldNotCalculateRateForPair.md)
 - [CouldNotCalculateRateForPairError](docs/CouldNotCalculateRateForPairError.md)
 - [CreateAutomaticCoinsForwardingRequestBody](docs/CreateAutomaticCoinsForwardingRequestBody.md)
 - [CreateAutomaticCoinsForwardingRequestBodyData](docs/CreateAutomaticCoinsForwardingRequestBodyData.md)
 - [CreateAutomaticCoinsForwardingRequestBodyDataItem](docs/CreateAutomaticCoinsForwardingRequestBodyDataItem.md)
 - [CreateAutomaticCoinsForwardingResponse](docs/CreateAutomaticCoinsForwardingResponse.md)
 - [CreateAutomaticCoinsForwardingResponseData](docs/CreateAutomaticCoinsForwardingResponseData.md)
 - [CreateAutomaticCoinsForwardingResponseItem](docs/CreateAutomaticCoinsForwardingResponseItem.md)
 - [CreateAutomaticTokensForwardingRequestBody](docs/CreateAutomaticTokensForwardingRequestBody.md)
 - [CreateAutomaticTokensForwardingRequestBodyData](docs/CreateAutomaticTokensForwardingRequestBodyData.md)
 - [CreateAutomaticTokensForwardingRequestBodyDataItem](docs/CreateAutomaticTokensForwardingRequestBodyDataItem.md)
 - [CreateAutomaticTokensForwardingRequestBodyTokenData](docs/CreateAutomaticTokensForwardingRequestBodyTokenData.md)
 - [CreateAutomaticTokensForwardingRequestBodyTokenDataBitcoinOmniToken](docs/CreateAutomaticTokensForwardingRequestBodyTokenDataBitcoinOmniToken.md)
 - [CreateAutomaticTokensForwardingRequestBodyTokenDataEthereumToken](docs/CreateAutomaticTokensForwardingRequestBodyTokenDataEthereumToken.md)
 - [CreateAutomaticTokensForwardingResponse](docs/CreateAutomaticTokensForwardingResponse.md)
 - [CreateAutomaticTokensForwardingResponseData](docs/CreateAutomaticTokensForwardingResponseData.md)
 - [CreateAutomaticTokensForwardingResponseItem](docs/CreateAutomaticTokensForwardingResponseItem.md)
 - [CreateAutomaticTokensForwardingResponseItemTokenData](docs/CreateAutomaticTokensForwardingResponseItemTokenData.md)
 - [CreateAutomaticTokensForwardingResponseItemTokenDataBitcoinOmniToken](docs/CreateAutomaticTokensForwardingResponseItemTokenDataBitcoinOmniToken.md)
 - [CreateAutomaticTokensForwardingResponseItemTokenDataEthereumToken](docs/CreateAutomaticTokensForwardingResponseItemTokenDataEthereumToken.md)
 - [DeleteAutomaticCoinsForwardingResponse](docs/DeleteAutomaticCoinsForwardingResponse.md)
 - [DeleteAutomaticCoinsForwardingResponseData](docs/DeleteAutomaticCoinsForwardingResponseData.md)
 - [DeleteAutomaticCoinsForwardingResponseItem](docs/DeleteAutomaticCoinsForwardingResponseItem.md)
 - [DeleteAutomaticTokensForwardingResponse](docs/DeleteAutomaticTokensForwardingResponse.md)
 - [DeleteAutomaticTokensForwardingResponseData](docs/DeleteAutomaticTokensForwardingResponseData.md)
 - [DeleteAutomaticTokensForwardingResponseItem](docs/DeleteAutomaticTokensForwardingResponseItem.md)
 - [DeleteAutomaticTokensForwardingResponseItemTokenData](docs/DeleteAutomaticTokensForwardingResponseItemTokenData.md)
 - [DeleteAutomaticTokensForwardingResponseItemTokenDataBitcoinOmniToken](docs/DeleteAutomaticTokensForwardingResponseItemTokenDataBitcoinOmniToken.md)
 - [DeleteAutomaticTokensForwardingResponseItemTokenDataEthereumToken](docs/DeleteAutomaticTokensForwardingResponseItemTokenDataEthereumToken.md)
 - [DeleteBlockchainEventSubscriptionResponse](docs/DeleteBlockchainEventSubscriptionResponse.md)
 - [DeleteBlockchainEventSubscriptionResponseData](docs/DeleteBlockchainEventSubscriptionResponseData.md)
 - [DeleteBlockchainEventSubscriptionResponseItem](docs/DeleteBlockchainEventSubscriptionResponseItem.md)
 - [EndpointNotAllowedForApiKey](docs/EndpointNotAllowedForApiKey.md)
 - [EndpointNotAllowedForApiKeyError](docs/EndpointNotAllowedForApiKeyError.md)
 - [EndpointNotAllowedForPlan](docs/EndpointNotAllowedForPlan.md)
 - [EndpointNotAllowedForPlanError](docs/EndpointNotAllowedForPlanError.md)
 - [FeatureMainnetsNotAllowedForPlan](docs/FeatureMainnetsNotAllowedForPlan.md)
 - [FeatureMainnetsNotAllowedForPlanError](docs/FeatureMainnetsNotAllowedForPlanError.md)
 - [GetAddressDetailsResponse](docs/GetAddressDetailsResponse.md)
 - [GetAddressDetailsResponseData](docs/GetAddressDetailsResponseData.md)
 - [GetAddressDetailsResponseItem](docs/GetAddressDetailsResponseItem.md)
 - [GetAddressDetailsResponseItemConfirmedBalance](docs/GetAddressDetailsResponseItemConfirmedBalance.md)
 - [GetAddressDetailsResponseItemTotalReceived](docs/GetAddressDetailsResponseItemTotalReceived.md)
 - [GetAddressDetailsResponseItemTotalSpent](docs/GetAddressDetailsResponseItemTotalSpent.md)
 - [GetBlockDetailsByBlockHashResponse](docs/GetBlockDetailsByBlockHashResponse.md)
 - [GetBlockDetailsByBlockHashResponseData](docs/GetBlockDetailsByBlockHashResponseData.md)
 - [GetBlockDetailsByBlockHashResponseItem](docs/GetBlockDetailsByBlockHashResponseItem.md)
 - [GetBlockDetailsByBlockHashResponseItemBlockchainSpecific](docs/GetBlockDetailsByBlockHashResponseItemBlockchainSpecific.md)
 - [GetBlockDetailsByBlockHashResponseItemBlockchainSpecificBitcoin](docs/GetBlockDetailsByBlockHashResponseItemBlockchainSpecificBitcoin.md)
 - [GetBlockDetailsByBlockHashResponseItemBlockchainSpecificBitcoinCash](docs/GetBlockDetailsByBlockHashResponseItemBlockchainSpecificBitcoinCash.md)
 - [GetBlockDetailsByBlockHashResponseItemBlockchainSpecificDash](docs/GetBlockDetailsByBlockHashResponseItemBlockchainSpecificDash.md)
 - [GetBlockDetailsByBlockHashResponseItemBlockchainSpecificDogecoin](docs/GetBlockDetailsByBlockHashResponseItemBlockchainSpecificDogecoin.md)
 - [GetBlockDetailsByBlockHashResponseItemBlockchainSpecificEthereum](docs/GetBlockDetailsByBlockHashResponseItemBlockchainSpecificEthereum.md)
 - [GetBlockDetailsByBlockHashResponseItemBlockchainSpecificEthereumClassic](docs/GetBlockDetailsByBlockHashResponseItemBlockchainSpecificEthereumClassic.md)
 - [GetBlockDetailsByBlockHashResponseItemBlockchainSpecificLitecoin](docs/GetBlockDetailsByBlockHashResponseItemBlockchainSpecificLitecoin.md)
 - [GetBlockDetailsByBlockHeightResponse](docs/GetBlockDetailsByBlockHeightResponse.md)
 - [GetBlockDetailsByBlockHeightResponseData](docs/GetBlockDetailsByBlockHeightResponseData.md)
 - [GetBlockDetailsByBlockHeightResponseItem](docs/GetBlockDetailsByBlockHeightResponseItem.md)
 - [GetBlockDetailsByBlockHeightResponseItemBlockchainSpecific](docs/GetBlockDetailsByBlockHeightResponseItemBlockchainSpecific.md)
 - [GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificBitcoin](docs/GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificBitcoin.md)
 - [GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificBitcoinCash](docs/GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificBitcoinCash.md)
 - [GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificDash](docs/GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificDash.md)
 - [GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificDogecoin](docs/GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificDogecoin.md)
 - [GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificEthereum](docs/GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificEthereum.md)
 - [GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificEthereumClassic](docs/GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificEthereumClassic.md)
 - [GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificLitecoin](docs/GetBlockDetailsByBlockHeightResponseItemBlockchainSpecificLitecoin.md)
 - [GetContractDetailsByAddressResponse](docs/GetContractDetailsByAddressResponse.md)
 - [GetContractDetailsByAddressResponseData](docs/GetContractDetailsByAddressResponseData.md)
 - [GetContractDetailsByAddressResponseItem](docs/GetContractDetailsByAddressResponseItem.md)
 - [GetExchangeRateByAssetSymbolsResponse](docs/GetExchangeRateByAssetSymbolsResponse.md)
 - [GetExchangeRateByAssetSymbolsResponseData](docs/GetExchangeRateByAssetSymbolsResponseData.md)
 - [GetExchangeRateByAssetSymbolsResponseItem](docs/GetExchangeRateByAssetSymbolsResponseItem.md)
 - [GetExchangeRateByAssetsIdsResponse](docs/GetExchangeRateByAssetsIdsResponse.md)
 - [GetExchangeRateByAssetsIdsResponseData](docs/GetExchangeRateByAssetsIdsResponseData.md)
 - [GetExchangeRateByAssetsIdsResponseItem](docs/GetExchangeRateByAssetsIdsResponseItem.md)
 - [GetFeeAddressDetailsResponse](docs/GetFeeAddressDetailsResponse.md)
 - [GetFeeAddressDetailsResponseData](docs/GetFeeAddressDetailsResponseData.md)
 - [GetFeeAddressDetailsResponseItem](docs/GetFeeAddressDetailsResponseItem.md)
 - [GetFeeAddressDetailsResponseItemBalance](docs/GetFeeAddressDetailsResponseItemBalance.md)
 - [GetFeeRecommendationsResponse](docs/GetFeeRecommendationsResponse.md)
 - [GetFeeRecommendationsResponseData](docs/GetFeeRecommendationsResponseData.md)
 - [GetFeeRecommendationsResponseItem](docs/GetFeeRecommendationsResponseItem.md)
 - [GetHdWalletxPubYPubZPubDetailsResponse](docs/GetHdWalletxPubYPubZPubDetailsResponse.md)
 - [GetHdWalletxPubYPubZPubDetailsResponseData](docs/GetHdWalletxPubYPubZPubDetailsResponseData.md)
 - [GetHdWalletxPubYPubZPubDetailsResponseItem](docs/GetHdWalletxPubYPubZPubDetailsResponseItem.md)
 - [GetLatestMinedBlockResponse](docs/GetLatestMinedBlockResponse.md)
 - [GetLatestMinedBlockResponseData](docs/GetLatestMinedBlockResponseData.md)
 - [GetLatestMinedBlockResponseItem](docs/GetLatestMinedBlockResponseItem.md)
 - [GetLatestMinedBlockResponseItemBlockchainSpecific](docs/GetLatestMinedBlockResponseItemBlockchainSpecific.md)
 - [GetLatestMinedBlockResponseItemBlockchainSpecificBitcoin](docs/GetLatestMinedBlockResponseItemBlockchainSpecificBitcoin.md)
 - [GetLatestMinedBlockResponseItemBlockchainSpecificBitcoinCash](docs/GetLatestMinedBlockResponseItemBlockchainSpecificBitcoinCash.md)
 - [GetLatestMinedBlockResponseItemBlockchainSpecificDash](docs/GetLatestMinedBlockResponseItemBlockchainSpecificDash.md)
 - [GetLatestMinedBlockResponseItemBlockchainSpecificDogecoin](docs/GetLatestMinedBlockResponseItemBlockchainSpecificDogecoin.md)
 - [GetLatestMinedBlockResponseItemBlockchainSpecificEthereum](docs/GetLatestMinedBlockResponseItemBlockchainSpecificEthereum.md)
 - [GetLatestMinedBlockResponseItemBlockchainSpecificEthereumClassic](docs/GetLatestMinedBlockResponseItemBlockchainSpecificEthereumClassic.md)
 - [GetLatestMinedBlockResponseItemBlockchainSpecificLitecoin](docs/GetLatestMinedBlockResponseItemBlockchainSpecificLitecoin.md)
 - [GetLatestMinedXrpRippleBlockResponse](docs/GetLatestMinedXrpRippleBlockResponse.md)
 - [GetLatestMinedXrpRippleBlockResponseData](docs/GetLatestMinedXrpRippleBlockResponseData.md)
 - [GetLatestMinedXrpRippleBlockResponseItem](docs/GetLatestMinedXrpRippleBlockResponseItem.md)
 - [GetLatestMinedXrpRippleBlockResponseItemTotalCoins](docs/GetLatestMinedXrpRippleBlockResponseItemTotalCoins.md)
 - [GetLatestMinedXrpRippleBlockResponseItemTotalFees](docs/GetLatestMinedXrpRippleBlockResponseItemTotalFees.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidResponse](docs/GetOmniTransactionDetailsByTransactionIdTxidResponse.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidResponseData](docs/GetOmniTransactionDetailsByTransactionIdTxidResponseData.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidResponseItem](docs/GetOmniTransactionDetailsByTransactionIdTxidResponseItem.md)
 - [GetOmniTransactionDetailsByTransactionIdTxidResponseItemSenders](docs/GetOmniTransactionDetailsByTransactionIdTxidResponseItemSenders.md)
 - [GetTransactionDetailsByTransactionIdResponse](docs/GetTransactionDetailsByTransactionIdResponse.md)
 - [GetTransactionDetailsByTransactionIdResponseData](docs/GetTransactionDetailsByTransactionIdResponseData.md)
 - [GetTransactionDetailsByTransactionIdResponseItem](docs/GetTransactionDetailsByTransactionIdResponseItem.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecific](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecific.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoin](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoin.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinCash](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinCash.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinCashScriptPubKey](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinCashScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinCashVin](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinCashVin.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinCashVout](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinCashVout.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinScriptPubKey](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinScriptSig](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinScriptSig.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinVin](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinVin.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinVout](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificBitcoinVout.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDash](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDash.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDashScriptPubKey](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDashScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDashScriptSig](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDashScriptSig.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDashVin](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDashVin.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDashVout](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDashVout.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDogecoin](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDogecoin.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDogecoinScriptPubKey](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDogecoinScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDogecoinScriptSig](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDogecoinScriptSig.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDogecoinVin](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDogecoinVin.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDogecoinVout](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificDogecoinVout.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificEthereum](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificEthereum.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificEthereumClassic](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificEthereumClassic.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificEthereumClassicGasPrice](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificEthereumClassicGasPrice.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificEthereumGasPrice](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificEthereumGasPrice.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificLitecoin](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificLitecoin.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificLitecoinScriptPubKey](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificLitecoinScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificLitecoinScriptSig](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificLitecoinScriptSig.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificLitecoinVin](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificLitecoinVin.md)
 - [GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificLitecoinVout](docs/GetTransactionDetailsByTransactionIdResponseItemBlockchainSpecificLitecoinVout.md)
 - [GetTransactionDetailsByTransactionIdResponseItemFee](docs/GetTransactionDetailsByTransactionIdResponseItemFee.md)
 - [GetTransactionDetailsByTransactionIdResponseItemRecipients](docs/GetTransactionDetailsByTransactionIdResponseItemRecipients.md)
 - [GetTransactionDetailsByTransactionIdResponseItemSenders](docs/GetTransactionDetailsByTransactionIdResponseItemSenders.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidResponse](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidResponse.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidResponseData](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidResponseData.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItem](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItem.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItemRecipients](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItemRecipients.md)
 - [GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItemSenders](docs/GetUnconfirmedOmniTransactionByTransactionIdTxidResponseItemSenders.md)
 - [GetXrpRippleAddressDetailsResponse](docs/GetXrpRippleAddressDetailsResponse.md)
 - [GetXrpRippleAddressDetailsResponseData](docs/GetXrpRippleAddressDetailsResponseData.md)
 - [GetXrpRippleAddressDetailsResponseItem](docs/GetXrpRippleAddressDetailsResponseItem.md)
 - [GetXrpRippleAddressDetailsResponseItemBalance](docs/GetXrpRippleAddressDetailsResponseItemBalance.md)
 - [GetXrpRippleBlockDetailsByBlockHashResponse](docs/GetXrpRippleBlockDetailsByBlockHashResponse.md)
 - [GetXrpRippleBlockDetailsByBlockHashResponseData](docs/GetXrpRippleBlockDetailsByBlockHashResponseData.md)
 - [GetXrpRippleBlockDetailsByBlockHashResponseItem](docs/GetXrpRippleBlockDetailsByBlockHashResponseItem.md)
 - [GetXrpRippleBlockDetailsByBlockHashResponseItemTotalCoins](docs/GetXrpRippleBlockDetailsByBlockHashResponseItemTotalCoins.md)
 - [GetXrpRippleBlockDetailsByBlockHeightResponse](docs/GetXrpRippleBlockDetailsByBlockHeightResponse.md)
 - [GetXrpRippleBlockDetailsByBlockHeightResponseData](docs/GetXrpRippleBlockDetailsByBlockHeightResponseData.md)
 - [GetXrpRippleBlockDetailsByBlockHeightResponseItem](docs/GetXrpRippleBlockDetailsByBlockHeightResponseItem.md)
 - [GetXrpRippleBlockDetailsByBlockHeightResponseItemTotalCoins](docs/GetXrpRippleBlockDetailsByBlockHeightResponseItemTotalCoins.md)
 - [GetXrpRippleBlockDetailsByBlockHeightResponseItemTotalFees](docs/GetXrpRippleBlockDetailsByBlockHeightResponseItemTotalFees.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdResponse](docs/GetXrpRippleTransactionDetailsByTransactionIdResponse.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdResponseData](docs/GetXrpRippleTransactionDetailsByTransactionIdResponseData.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdResponseItem](docs/GetXrpRippleTransactionDetailsByTransactionIdResponseItem.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdResponseItemFee](docs/GetXrpRippleTransactionDetailsByTransactionIdResponseItemFee.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdResponseItemOffer](docs/GetXrpRippleTransactionDetailsByTransactionIdResponseItemOffer.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdResponseItemReceive](docs/GetXrpRippleTransactionDetailsByTransactionIdResponseItemReceive.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdResponseItemRecipients](docs/GetXrpRippleTransactionDetailsByTransactionIdResponseItemRecipients.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdResponseItemSenders](docs/GetXrpRippleTransactionDetailsByTransactionIdResponseItemSenders.md)
 - [GetXrpRippleTransactionDetailsByTransactionIdResponseItemValue](docs/GetXrpRippleTransactionDetailsByTransactionIdResponseItemValue.md)
 - [InsufficientCredits](docs/InsufficientCredits.md)
 - [InsufficientCreditsError](docs/InsufficientCreditsError.md)
 - [InvalidApiKey](docs/InvalidApiKey.md)
 - [InvalidApiKeyError](docs/InvalidApiKeyError.md)
 - [InvalidBlockchain](docs/InvalidBlockchain.md)
 - [InvalidBlockchainError](docs/InvalidBlockchainError.md)
 - [InvalidData](docs/InvalidData.md)
 - [InvalidDataError](docs/InvalidDataError.md)
 - [InvalidNetwork](docs/InvalidNetwork.md)
 - [InvalidNetworkError](docs/InvalidNetworkError.md)
 - [InvalidPagination](docs/InvalidPagination.md)
 - [InvalidPaginationError](docs/InvalidPaginationError.md)
 - [InvalidRequestBodyStructure](docs/InvalidRequestBodyStructure.md)
 - [InvalidRequestBodyStructureError](docs/InvalidRequestBodyStructureError.md)
 - [InvalidXpub](docs/InvalidXpub.md)
 - [InvalidXpubError](docs/InvalidXpubError.md)
 - [LimitGreaterThanAllowed](docs/LimitGreaterThanAllowed.md)
 - [LimitGreaterThanAllowedError](docs/LimitGreaterThanAllowedError.md)
 - [ListAssetsDetailsResponse](docs/ListAssetsDetailsResponse.md)
 - [ListAssetsDetailsResponseData](docs/ListAssetsDetailsResponseData.md)
 - [ListAssetsDetailsResponseItem](docs/ListAssetsDetailsResponseItem.md)
 - [ListAssetsDetailsResponseItemAssetLogo](docs/ListAssetsDetailsResponseItemAssetLogo.md)
 - [ListAssetsDetailsResponseItemLatestRate](docs/ListAssetsDetailsResponseItemLatestRate.md)
 - [ListAssetsDetailsResponseItemSpecificData](docs/ListAssetsDetailsResponseItemSpecificData.md)
 - [ListAssetsDetailsResponseItemSpecificDataCryptoTypeData](docs/ListAssetsDetailsResponseItemSpecificDataCryptoTypeData.md)
 - [ListBlockchainEventsSubscriptionsResponse](docs/ListBlockchainEventsSubscriptionsResponse.md)
 - [ListBlockchainEventsSubscriptionsResponseData](docs/ListBlockchainEventsSubscriptionsResponseData.md)
 - [ListBlockchainEventsSubscriptionsResponseItem](docs/ListBlockchainEventsSubscriptionsResponseItem.md)
 - [ListCoinsForwardingAutomationsResponse](docs/ListCoinsForwardingAutomationsResponse.md)
 - [ListCoinsForwardingAutomationsResponseData](docs/ListCoinsForwardingAutomationsResponseData.md)
 - [ListCoinsForwardingAutomationsResponseItem](docs/ListCoinsForwardingAutomationsResponseItem.md)
 - [ListHdWalletxPubYPubZPubTransactionsResponse](docs/ListHdWalletxPubYPubZPubTransactionsResponse.md)
 - [ListHdWalletxPubYPubZPubTransactionsResponseData](docs/ListHdWalletxPubYPubZPubTransactionsResponseData.md)
 - [ListHdWalletxPubYPubZPubTransactionsResponseItem](docs/ListHdWalletxPubYPubZPubTransactionsResponseItem.md)
 - [ListHdWalletxPubYPubZPubTransactionsResponseItemFee](docs/ListHdWalletxPubYPubZPubTransactionsResponseItemFee.md)
 - [ListHdWalletxPubYPubZPubTransactionsResponseItemRecipients](docs/ListHdWalletxPubYPubZPubTransactionsResponseItemRecipients.md)
 - [ListHdWalletxPubYPubZPubTransactionsResponseItemSenders](docs/ListHdWalletxPubYPubZPubTransactionsResponseItemSenders.md)
 - [ListOmniTokensByAddressResponse](docs/ListOmniTokensByAddressResponse.md)
 - [ListOmniTokensByAddressResponseData](docs/ListOmniTokensByAddressResponseData.md)
 - [ListOmniTokensByAddressResponseItem](docs/ListOmniTokensByAddressResponseItem.md)
 - [ListOmniTransactionsByAddressResponse](docs/ListOmniTransactionsByAddressResponse.md)
 - [ListOmniTransactionsByAddressResponseData](docs/ListOmniTransactionsByAddressResponseData.md)
 - [ListOmniTransactionsByAddressResponseItem](docs/ListOmniTransactionsByAddressResponseItem.md)
 - [ListOmniTransactionsByAddressResponseItemFee](docs/ListOmniTransactionsByAddressResponseItemFee.md)
 - [ListOmniTransactionsByAddressResponseItemRecipients](docs/ListOmniTransactionsByAddressResponseItemRecipients.md)
 - [ListOmniTransactionsByAddressResponseItemSenders](docs/ListOmniTransactionsByAddressResponseItemSenders.md)
 - [ListOmniTransactionsByBlockHashResponse](docs/ListOmniTransactionsByBlockHashResponse.md)
 - [ListOmniTransactionsByBlockHashResponseData](docs/ListOmniTransactionsByBlockHashResponseData.md)
 - [ListOmniTransactionsByBlockHashResponseItem](docs/ListOmniTransactionsByBlockHashResponseItem.md)
 - [ListOmniTransactionsByBlockHashResponseItemFee](docs/ListOmniTransactionsByBlockHashResponseItemFee.md)
 - [ListOmniTransactionsByBlockHeightResponse](docs/ListOmniTransactionsByBlockHeightResponse.md)
 - [ListOmniTransactionsByBlockHeightResponseData](docs/ListOmniTransactionsByBlockHeightResponseData.md)
 - [ListOmniTransactionsByBlockHeightResponseItem](docs/ListOmniTransactionsByBlockHeightResponseItem.md)
 - [ListOmniTransactionsByBlockHeightResponseItemFee](docs/ListOmniTransactionsByBlockHeightResponseItemFee.md)
 - [ListOmniTransactionsByBlockHeightResponseItemRecipients](docs/ListOmniTransactionsByBlockHeightResponseItemRecipients.md)
 - [ListOmniTransactionsByBlockHeightResponseItemSenders](docs/ListOmniTransactionsByBlockHeightResponseItemSenders.md)
 - [ListSupportedAssetsResponse](docs/ListSupportedAssetsResponse.md)
 - [ListSupportedAssetsResponseData](docs/ListSupportedAssetsResponseData.md)
 - [ListSupportedAssetsResponseItem](docs/ListSupportedAssetsResponseItem.md)
 - [ListTokensByAddressResponse](docs/ListTokensByAddressResponse.md)
 - [ListTokensByAddressResponseData](docs/ListTokensByAddressResponseData.md)
 - [ListTokensByAddressResponseItem](docs/ListTokensByAddressResponseItem.md)
 - [ListTokensForwardingAutomationsResponse](docs/ListTokensForwardingAutomationsResponse.md)
 - [ListTokensForwardingAutomationsResponseData](docs/ListTokensForwardingAutomationsResponseData.md)
 - [ListTokensForwardingAutomationsResponseItem](docs/ListTokensForwardingAutomationsResponseItem.md)
 - [ListTokensForwardingAutomationsResponseItemTokenData](docs/ListTokensForwardingAutomationsResponseItemTokenData.md)
 - [ListTokensForwardingAutomationsResponseItemTokenDataBitcoinOmniToken](docs/ListTokensForwardingAutomationsResponseItemTokenDataBitcoinOmniToken.md)
 - [ListTokensForwardingAutomationsResponseItemTokenDataEthereumToken](docs/ListTokensForwardingAutomationsResponseItemTokenDataEthereumToken.md)
 - [ListTokensTransfersByAddressResponse](docs/ListTokensTransfersByAddressResponse.md)
 - [ListTokensTransfersByAddressResponseData](docs/ListTokensTransfersByAddressResponseData.md)
 - [ListTokensTransfersByAddressResponseItem](docs/ListTokensTransfersByAddressResponseItem.md)
 - [ListTokensTransfersByTransactionHashResponse](docs/ListTokensTransfersByTransactionHashResponse.md)
 - [ListTokensTransfersByTransactionHashResponseData](docs/ListTokensTransfersByTransactionHashResponseData.md)
 - [ListTokensTransfersByTransactionHashResponseItem](docs/ListTokensTransfersByTransactionHashResponseItem.md)
 - [ListTransactionsByAddressResponse](docs/ListTransactionsByAddressResponse.md)
 - [ListTransactionsByAddressResponseData](docs/ListTransactionsByAddressResponseData.md)
 - [ListTransactionsByAddressResponseItem](docs/ListTransactionsByAddressResponseItem.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecific](docs/ListTransactionsByAddressResponseItemBlockchainSpecific.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificBitcoin](docs/ListTransactionsByAddressResponseItemBlockchainSpecificBitcoin.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificBitcoinCash](docs/ListTransactionsByAddressResponseItemBlockchainSpecificBitcoinCash.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificBitcoinCashVin](docs/ListTransactionsByAddressResponseItemBlockchainSpecificBitcoinCashVin.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificBitcoinScriptPubKey](docs/ListTransactionsByAddressResponseItemBlockchainSpecificBitcoinScriptPubKey.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificBitcoinVin](docs/ListTransactionsByAddressResponseItemBlockchainSpecificBitcoinVin.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificBitcoinVout](docs/ListTransactionsByAddressResponseItemBlockchainSpecificBitcoinVout.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificDash](docs/ListTransactionsByAddressResponseItemBlockchainSpecificDash.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificDashScriptPubKey](docs/ListTransactionsByAddressResponseItemBlockchainSpecificDashScriptPubKey.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificDashScriptSig](docs/ListTransactionsByAddressResponseItemBlockchainSpecificDashScriptSig.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificDashVin](docs/ListTransactionsByAddressResponseItemBlockchainSpecificDashVin.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificDashVout](docs/ListTransactionsByAddressResponseItemBlockchainSpecificDashVout.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificDogecoin](docs/ListTransactionsByAddressResponseItemBlockchainSpecificDogecoin.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificDogecoinScriptSig](docs/ListTransactionsByAddressResponseItemBlockchainSpecificDogecoinScriptSig.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificDogecoinVin](docs/ListTransactionsByAddressResponseItemBlockchainSpecificDogecoinVin.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificEthereum](docs/ListTransactionsByAddressResponseItemBlockchainSpecificEthereum.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificEthereumClassic](docs/ListTransactionsByAddressResponseItemBlockchainSpecificEthereumClassic.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificEthereumClassicGasPrice](docs/ListTransactionsByAddressResponseItemBlockchainSpecificEthereumClassicGasPrice.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificEthereumGasPrice](docs/ListTransactionsByAddressResponseItemBlockchainSpecificEthereumGasPrice.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificLitecoin](docs/ListTransactionsByAddressResponseItemBlockchainSpecificLitecoin.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificLitecoinScriptSig](docs/ListTransactionsByAddressResponseItemBlockchainSpecificLitecoinScriptSig.md)
 - [ListTransactionsByAddressResponseItemBlockchainSpecificLitecoinVin](docs/ListTransactionsByAddressResponseItemBlockchainSpecificLitecoinVin.md)
 - [ListTransactionsByBlockHashResponse](docs/ListTransactionsByBlockHashResponse.md)
 - [ListTransactionsByBlockHashResponseData](docs/ListTransactionsByBlockHashResponseData.md)
 - [ListTransactionsByBlockHashResponseItem](docs/ListTransactionsByBlockHashResponseItem.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecific](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecific.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoin](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoin.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoinCash](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoinCash.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoinCashScriptPubKey](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoinCashScriptPubKey.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoinCashVin](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoinCashVin.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoinCashVout](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoinCashVout.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoinVin](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificBitcoinVin.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificDash](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificDash.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificDashScriptPubKey](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificDashScriptPubKey.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificDashScriptSig](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificDashScriptSig.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificDashVin](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificDashVin.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificDashVout](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificDashVout.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificDogecoin](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificDogecoin.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificDogecoinScriptPubKey](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificDogecoinScriptPubKey.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificDogecoinVin](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificDogecoinVin.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificDogecoinVout](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificDogecoinVout.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificEthereum](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificEthereum.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificEthereumClassic](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificEthereumClassic.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificEthereumGasPrice](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificEthereumGasPrice.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificLitecoin](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificLitecoin.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificLitecoinScriptPubKey](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificLitecoinScriptPubKey.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificLitecoinVin](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificLitecoinVin.md)
 - [ListTransactionsByBlockHashResponseItemBlockchainSpecificLitecoinVout](docs/ListTransactionsByBlockHashResponseItemBlockchainSpecificLitecoinVout.md)
 - [ListTransactionsByBlockHashResponseItemFee](docs/ListTransactionsByBlockHashResponseItemFee.md)
 - [ListTransactionsByBlockHashResponseItemRecipients](docs/ListTransactionsByBlockHashResponseItemRecipients.md)
 - [ListTransactionsByBlockHashResponseItemSenders](docs/ListTransactionsByBlockHashResponseItemSenders.md)
 - [ListTransactionsByBlockHeightResponse](docs/ListTransactionsByBlockHeightResponse.md)
 - [ListTransactionsByBlockHeightResponseData](docs/ListTransactionsByBlockHeightResponseData.md)
 - [ListTransactionsByBlockHeightResponseItem](docs/ListTransactionsByBlockHeightResponseItem.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecific](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecific.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificBitcoin](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificBitcoin.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificBitcoinCash](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificBitcoinCash.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificBitcoinScriptPubKey](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificBitcoinScriptPubKey.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificBitcoinVout](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificBitcoinVout.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificDash](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificDash.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificDashScriptPubKey](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificDashScriptPubKey.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificDashScriptSig](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificDashScriptSig.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificDashVin](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificDashVin.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificDashVout](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificDashVout.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificDogecoin](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificDogecoin.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificDogecoinVin](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificDogecoinVin.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificEthereum](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificEthereum.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificEthereumClassic](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificEthereumClassic.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificEthereumClassicGasPrice](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificEthereumClassicGasPrice.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificLitecoin](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificLitecoin.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificLitecoinScriptPubKey](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificLitecoinScriptPubKey.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificLitecoinScriptSig](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificLitecoinScriptSig.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificLitecoinVin](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificLitecoinVin.md)
 - [ListTransactionsByBlockHeightResponseItemBlockchainSpecificLitecoinVout](docs/ListTransactionsByBlockHeightResponseItemBlockchainSpecificLitecoinVout.md)
 - [ListTransactionsByBlockHeightResponseItemFee](docs/ListTransactionsByBlockHeightResponseItemFee.md)
 - [ListUnconfirmedOmniTransactionsByAddressResponse](docs/ListUnconfirmedOmniTransactionsByAddressResponse.md)
 - [ListUnconfirmedOmniTransactionsByAddressResponseData](docs/ListUnconfirmedOmniTransactionsByAddressResponseData.md)
 - [ListUnconfirmedOmniTransactionsByAddressResponseItem](docs/ListUnconfirmedOmniTransactionsByAddressResponseItem.md)
 - [ListUnconfirmedOmniTransactionsByAddressResponseItemFee](docs/ListUnconfirmedOmniTransactionsByAddressResponseItemFee.md)
 - [ListUnconfirmedOmniTransactionsByAddressResponseItemSenders](docs/ListUnconfirmedOmniTransactionsByAddressResponseItemSenders.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdResponse](docs/ListUnconfirmedOmniTransactionsByPropertyIdResponse.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdResponseData](docs/ListUnconfirmedOmniTransactionsByPropertyIdResponseData.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIdResponseItem](docs/ListUnconfirmedOmniTransactionsByPropertyIdResponseItem.md)
 - [ListXrpRippleTransactionsByAddressResponse](docs/ListXrpRippleTransactionsByAddressResponse.md)
 - [ListXrpRippleTransactionsByAddressResponseData](docs/ListXrpRippleTransactionsByAddressResponseData.md)
 - [ListXrpRippleTransactionsByAddressResponseItem](docs/ListXrpRippleTransactionsByAddressResponseItem.md)
 - [ListXrpRippleTransactionsByAddressResponseItemFee](docs/ListXrpRippleTransactionsByAddressResponseItemFee.md)
 - [ListXrpRippleTransactionsByAddressResponseItemOffer](docs/ListXrpRippleTransactionsByAddressResponseItemOffer.md)
 - [ListXrpRippleTransactionsByAddressResponseItemReceive](docs/ListXrpRippleTransactionsByAddressResponseItemReceive.md)
 - [ListXrpRippleTransactionsByAddressResponseItemValue](docs/ListXrpRippleTransactionsByAddressResponseItemValue.md)
 - [ListXrpRippleTransactionsByBlockHashResponse](docs/ListXrpRippleTransactionsByBlockHashResponse.md)
 - [ListXrpRippleTransactionsByBlockHashResponseData](docs/ListXrpRippleTransactionsByBlockHashResponseData.md)
 - [ListXrpRippleTransactionsByBlockHashResponseItem](docs/ListXrpRippleTransactionsByBlockHashResponseItem.md)
 - [ListXrpRippleTransactionsByBlockHashResponseItemFee](docs/ListXrpRippleTransactionsByBlockHashResponseItemFee.md)
 - [ListXrpRippleTransactionsByBlockHashResponseItemOffer](docs/ListXrpRippleTransactionsByBlockHashResponseItemOffer.md)
 - [ListXrpRippleTransactionsByBlockHashResponseItemReceive](docs/ListXrpRippleTransactionsByBlockHashResponseItemReceive.md)
 - [ListXrpRippleTransactionsByBlockHashResponseItemRecipients](docs/ListXrpRippleTransactionsByBlockHashResponseItemRecipients.md)
 - [ListXrpRippleTransactionsByBlockHashResponseItemSenders](docs/ListXrpRippleTransactionsByBlockHashResponseItemSenders.md)
 - [ListXrpRippleTransactionsByBlockHashResponseItemValue](docs/ListXrpRippleTransactionsByBlockHashResponseItemValue.md)
 - [MinedTransactionRequestBody](docs/MinedTransactionRequestBody.md)
 - [MinedTransactionRequestBodyData](docs/MinedTransactionRequestBodyData.md)
 - [MinedTransactionRequestBodyDataItem](docs/MinedTransactionRequestBodyDataItem.md)
 - [MinedTransactionResponse](docs/MinedTransactionResponse.md)
 - [MinedTransactionResponseData](docs/MinedTransactionResponseData.md)
 - [MinedTransactionResponseItem](docs/MinedTransactionResponseItem.md)
 - [MissingApiKey](docs/MissingApiKey.md)
 - [MissingApiKeyError](docs/MissingApiKeyError.md)
 - [NewBlockRequestBody](docs/NewBlockRequestBody.md)
 - [NewBlockRequestBodyData](docs/NewBlockRequestBodyData.md)
 - [NewBlockRequestBodyDataItem](docs/NewBlockRequestBodyDataItem.md)
 - [NewBlockResponse](docs/NewBlockResponse.md)
 - [NewBlockResponseData](docs/NewBlockResponseData.md)
 - [NewBlockResponseItem](docs/NewBlockResponseItem.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRequestBody](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRequestBody.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRequestBodyData](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRequestBodyData.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRequestBodyDataItem](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRequestBodyDataItem.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationResponse](docs/NewConfirmedCoinsTransactionsAndEachConfirmationResponse.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationResponseData](docs/NewConfirmedCoinsTransactionsAndEachConfirmationResponseData.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationResponseItem](docs/NewConfirmedCoinsTransactionsAndEachConfirmationResponseItem.md)
 - [NewConfirmedCoinsTransactionsRequestBody](docs/NewConfirmedCoinsTransactionsRequestBody.md)
 - [NewConfirmedCoinsTransactionsRequestBodyData](docs/NewConfirmedCoinsTransactionsRequestBodyData.md)
 - [NewConfirmedCoinsTransactionsRequestBodyDataItem](docs/NewConfirmedCoinsTransactionsRequestBodyDataItem.md)
 - [NewConfirmedCoinsTransactionsResponse](docs/NewConfirmedCoinsTransactionsResponse.md)
 - [NewConfirmedCoinsTransactionsResponseData](docs/NewConfirmedCoinsTransactionsResponseData.md)
 - [NewConfirmedCoinsTransactionsResponseItem](docs/NewConfirmedCoinsTransactionsResponseItem.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRequestBody](docs/NewConfirmedTokensTransactionsAndEachConfirmationRequestBody.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRequestBodyData](docs/NewConfirmedTokensTransactionsAndEachConfirmationRequestBodyData.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRequestBodyDataItem](docs/NewConfirmedTokensTransactionsAndEachConfirmationRequestBodyDataItem.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationResponse](docs/NewConfirmedTokensTransactionsAndEachConfirmationResponse.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationResponseData](docs/NewConfirmedTokensTransactionsAndEachConfirmationResponseData.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationResponseItem](docs/NewConfirmedTokensTransactionsAndEachConfirmationResponseItem.md)
 - [NewConfirmedTokensTransactionsRequestBody](docs/NewConfirmedTokensTransactionsRequestBody.md)
 - [NewConfirmedTokensTransactionsResponse](docs/NewConfirmedTokensTransactionsResponse.md)
 - [NewConfirmedTokensTransactionsResponseData](docs/NewConfirmedTokensTransactionsResponseData.md)
 - [NewConfirmedTokensTransactionsResponseItem](docs/NewConfirmedTokensTransactionsResponseItem.md)
 - [NewUnconfirmedCoinsTransactionsRequestBody](docs/NewUnconfirmedCoinsTransactionsRequestBody.md)
 - [NewUnconfirmedCoinsTransactionsRequestBodyData](docs/NewUnconfirmedCoinsTransactionsRequestBodyData.md)
 - [NewUnconfirmedCoinsTransactionsRequestBodyDataItem](docs/NewUnconfirmedCoinsTransactionsRequestBodyDataItem.md)
 - [NewUnconfirmedCoinsTransactionsResponse](docs/NewUnconfirmedCoinsTransactionsResponse.md)
 - [NewUnconfirmedCoinsTransactionsResponseData](docs/NewUnconfirmedCoinsTransactionsResponseData.md)
 - [NewUnconfirmedCoinsTransactionsResponseItem](docs/NewUnconfirmedCoinsTransactionsResponseItem.md)
 - [NewUnconfirmedTokensTransactionsRequestBody](docs/NewUnconfirmedTokensTransactionsRequestBody.md)
 - [NewUnconfirmedTokensTransactionsRequestBodyData](docs/NewUnconfirmedTokensTransactionsRequestBodyData.md)
 - [NewUnconfirmedTokensTransactionsRequestBodyDataItem](docs/NewUnconfirmedTokensTransactionsRequestBodyDataItem.md)
 - [NewUnconfirmedTokensTransactionsResponse](docs/NewUnconfirmedTokensTransactionsResponse.md)
 - [NewUnconfirmedTokensTransactionsResponseData](docs/NewUnconfirmedTokensTransactionsResponseData.md)
 - [NewUnconfirmedTokensTransactionsResponseItem](docs/NewUnconfirmedTokensTransactionsResponseItem.md)
 - [RequestLimitReached](docs/RequestLimitReached.md)
 - [RequestLimitReachedError](docs/RequestLimitReachedError.md)
 - [ResourceNotFound](docs/ResourceNotFound.md)
 - [ResourceNotFoundError](docs/ResourceNotFoundError.md)
 - [SyncHdWalletxPubYPubZPubRequestBody](docs/SyncHdWalletxPubYPubZPubRequestBody.md)
 - [SyncHdWalletxPubYPubZPubRequestBodyData](docs/SyncHdWalletxPubYPubZPubRequestBodyData.md)
 - [SyncHdWalletxPubYPubZPubRequestBodyDataItem](docs/SyncHdWalletxPubYPubZPubRequestBodyDataItem.md)
 - [SyncHdWalletxPubYPubZPubResponse](docs/SyncHdWalletxPubYPubZPubResponse.md)
 - [SyncHdWalletxPubYPubZPubResponseData](docs/SyncHdWalletxPubYPubZPubResponseData.md)
 - [SyncHdWalletxPubYPubZPubResponseItem](docs/SyncHdWalletxPubYPubZPubResponseItem.md)
 - [TokensForwardingAutomationsLimitReached](docs/TokensForwardingAutomationsLimitReached.md)
 - [TokensForwardingAutomationsLimitReachedError](docs/TokensForwardingAutomationsLimitReachedError.md)
 - [TokensForwardingFail](docs/TokensForwardingFail.md)
 - [TokensForwardingFailData](docs/TokensForwardingFailData.md)
 - [TokensForwardingFailDataItem](docs/TokensForwardingFailDataItem.md)
 - [TokensForwardingSuccess](docs/TokensForwardingSuccess.md)
 - [TokensForwardingSuccessData](docs/TokensForwardingSuccessData.md)
 - [TokensForwardingSuccessDataItem](docs/TokensForwardingSuccessDataItem.md)
 - [TokensForwardingSuccessEthereumerc20token](docs/TokensForwardingSuccessEthereumerc20token.md)
 - [TokensForwardingSuccessEthereumerc721token](docs/TokensForwardingSuccessEthereumerc721token.md)
 - [TokensForwardingSuccessOmnilayertoken](docs/TokensForwardingSuccessOmnilayertoken.md)
 - [TokensForwardingSuccessToken](docs/TokensForwardingSuccessToken.md)
 - [TransactionMined](docs/TransactionMined.md)
 - [TransactionMinedData](docs/TransactionMinedData.md)
 - [TransactionMinedDataItem](docs/TransactionMinedDataItem.md)
 - [TransactionMinedDataItemMinedInBlock](docs/TransactionMinedDataItemMinedInBlock.md)
 - [UnexpectedServerError](docs/UnexpectedServerError.md)
 - [UnexpectedServerErrorError](docs/UnexpectedServerErrorError.md)
 - [UnsupportedMediaType](docs/UnsupportedMediaType.md)
 - [UnsupportedMediaTypeError](docs/UnsupportedMediaTypeError.md)
 - [UriNotFound](docs/UriNotFound.md)
 - [UriNotFoundError](docs/UriNotFoundError.md)
 - [ValidateAddressRequestBody](docs/ValidateAddressRequestBody.md)
 - [ValidateAddressRequestBodyData](docs/ValidateAddressRequestBodyData.md)
 - [ValidateAddressRequestBodyDataItem](docs/ValidateAddressRequestBodyDataItem.md)
 - [ValidateAddressResponse](docs/ValidateAddressResponse.md)
 - [ValidateAddressResponseData](docs/ValidateAddressResponseData.md)
 - [ValidateAddressResponseItem](docs/ValidateAddressResponseItem.md)
 - [XpubNotSynced](docs/XpubNotSynced.md)
 - [XpubNotSyncedError](docs/XpubNotSyncedError.md)
 - [XpubSyncInProgress](docs/XpubSyncInProgress.md)
 - [XpubSyncInProgressError](docs/XpubSyncInProgressError.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

developers@cryptoapis.io

