//! Errors generated by this crate.

use core::fmt::{self, Display};

/// Given object is of an unexpected length.
#[derive(Debug)]
pub struct InvalidLength {
    expected: usize,
    got: usize,
}

impl InvalidLength {
    /// Build the error.
    ///
    /// Panic if the value is actually what we got.
    pub(super) fn new(expected: usize, got: usize) -> Self {
        assert!(expected != got);

        Self { expected, got }
    }
}

impl Display for InvalidLength {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_fmt(format_args!(
            "invalid length: expected {} but got {}",
            self.expected, self.got,
        ))
    }
}
