#[macro_use]
mod utils;

#[cfg(test)]
mod bybit_inverse_future {
    use crypto_ws_client::{BybitInverseWSClient, WSClient};
    use std::sync::mpsc::{Receiver, Sender};

    #[test]
    fn subscribe() {
        gen_test_code!(
            BybitInverseWSClient,
            subscribe,
            &vec!["trade.BTCUSDM22".to_string()]
        );
    }

    #[test]
    fn subscribe_raw_json() {
        gen_test_code!(
            BybitInverseWSClient,
            subscribe,
            &vec![r#"{"op":"subscribe","args":["trade.BTCUSDM22"]}"#.to_string()]
        );
    }

    #[test]
    fn subscribe_trade() {
        gen_test_code!(
            BybitInverseWSClient,
            subscribe_trade,
            &vec!["BTCUSDM22".to_string()]
        );
    }

    #[test]
    fn subscribe_orderbook() {
        gen_test_code!(
            BybitInverseWSClient,
            subscribe_orderbook,
            &vec!["BTCUSDM22".to_string()]
        );
    }

    #[test]
    fn subscribe_ticker() {
        gen_test_code!(
            BybitInverseWSClient,
            subscribe_ticker,
            &vec!["BTCUSDM22".to_string()]
        );
    }

    #[test]
    fn subscribe_candlestick() {
        gen_test_subscribe_candlestick!(BybitInverseWSClient, &vec![("BTCUSDM22".to_string(), 60)]);
        gen_test_subscribe_candlestick!(
            BybitInverseWSClient,
            &vec![("BTCUSDM22".to_string(), 2592000)]
        );
    }
}

#[cfg(test)]
mod bybit_inverse_swap {
    use crypto_ws_client::{BybitInverseWSClient, WSClient};
    use std::sync::mpsc::{Receiver, Sender};

    #[test]
    fn subscribe() {
        gen_test_code!(
            BybitInverseWSClient,
            subscribe,
            &vec!["trade.BTCUSD".to_string()]
        );
    }

    #[test]
    fn subscribe_raw_json() {
        gen_test_code!(
            BybitInverseWSClient,
            subscribe,
            &vec![r#"{"op":"subscribe","args":["trade.BTCUSD"]}"#.to_string()]
        );
    }

    #[test]
    fn subscribe_trade() {
        gen_test_code!(
            BybitInverseWSClient,
            subscribe_trade,
            &vec!["BTCUSD".to_string()]
        );
    }

    #[test]
    fn subscribe_orderbook() {
        gen_test_code!(
            BybitInverseWSClient,
            subscribe_orderbook,
            &vec!["BTCUSD".to_string()]
        );
    }

    #[test]
    fn subscribe_ticker() {
        gen_test_code!(
            BybitInverseWSClient,
            subscribe_ticker,
            &vec!["BTCUSD".to_string()]
        );
    }

    #[test]
    fn subscribe_candlestick() {
        gen_test_subscribe_candlestick!(BybitInverseWSClient, &vec![("BTCUSD".to_string(), 60)]);
        gen_test_subscribe_candlestick!(
            BybitInverseWSClient,
            &vec![("BTCUSD".to_string(), 2592000)]
        );
    }
}

#[cfg(test)]
mod bybit_linear_swap {
    use crypto_ws_client::{BybitLinearSwapWSClient, WSClient};
    use std::sync::mpsc::{Receiver, Sender};

    #[test]
    fn subscribe_trade() {
        gen_test_code!(
            BybitLinearSwapWSClient,
            subscribe_trade,
            &vec!["BTCUSDT".to_string()]
        );
    }

    #[test]
    fn subscribe_orderbook() {
        gen_test_code!(
            BybitLinearSwapWSClient,
            subscribe_orderbook,
            &vec!["BTCUSDT".to_string()]
        );
    }

    #[test]
    fn subscribe_ticker() {
        gen_test_code!(
            BybitLinearSwapWSClient,
            subscribe_ticker,
            &vec!["BTCUSDT".to_string()]
        );
    }

    #[test]
    fn subscribe_candlestick() {
        gen_test_subscribe_candlestick!(
            BybitLinearSwapWSClient,
            &vec![("BTCUSDT".to_string(), 60)]
        );
        gen_test_subscribe_candlestick!(
            BybitLinearSwapWSClient,
            &vec![("BTCUSDT".to_string(), 2592000)]
        );
    }
}
