use crypto_market_type::MarketType;

pub(crate) fn get_market_type(symbol: &str) -> MarketType {
    if symbol.ends_with("_USD") {
        MarketType::InverseSwap
    } else if symbol.ends_with("_USDT") {
        MarketType::LinearSwap
    } else if symbol.contains('_') {
        MarketType::Spot
    } else {
        MarketType::Unknown
    }
}
