Object.assign(window.search, {"doc_urls":["0_intro.html#crypt4gh-utility","0_intro.html#introduction","0_intro.html#basic-example","1_installation.html#installation","1_installation.html#requirements","1_installation.html#linux-macos-or-another-unix-like-os","1_installation.html#windows","1_installation.html#other-ways-to-install-rust","1_installation.html#building-from-source-recommended","1_installation.html#standalone-binaries","1_installation.html#issues","2_encryption.html#encryption-algorithm---crypt4gh","2_encryption.html#encryption-format","2_encryption.html#features","3_key_format.html#crypt4gh-key-format","3_key_format.html#keys","3_key_format.html#public-key-data","3_key_format.html#private-key-data","3_key_format.html#examples","3_key_format.html#crypt4gh-key-generation","3_key_format.html#openssh-key-generation","4_usage_and_examples.html#usage--examples","4_usage_and_examples.html#keygen","4_usage_and_examples.html#encrypt","4_usage_and_examples.html#decrypt","4_usage_and_examples.html#reencrypt","4_usage_and_examples.html#rearrange","5_rust_library.html#rust-library"],"index":{"documentStore":{"docInfo":{"0":{"body":0,"breadcrumbs":3,"title":2},"1":{"body":34,"breadcrumbs":2,"title":1},"10":{"body":6,"breadcrumbs":2,"title":1},"11":{"body":0,"breadcrumbs":4,"title":3},"12":{"body":69,"breadcrumbs":3,"title":2},"13":{"body":41,"breadcrumbs":2,"title":1},"14":{"body":23,"breadcrumbs":5,"title":3},"15":{"body":19,"breadcrumbs":3,"title":1},"16":{"body":9,"breadcrumbs":5,"title":3},"17":{"body":143,"breadcrumbs":5,"title":3},"18":{"body":0,"breadcrumbs":3,"title":1},"19":{"body":6,"breadcrumbs":5,"title":3},"2":{"body":40,"breadcrumbs":3,"title":2},"20":{"body":8,"breadcrumbs":5,"title":3},"21":{"body":90,"breadcrumbs":4,"title":2},"22":{"body":84,"breadcrumbs":3,"title":1},"23":{"body":72,"breadcrumbs":3,"title":1},"24":{"body":87,"breadcrumbs":3,"title":1},"25":{"body":70,"breadcrumbs":3,"title":1},"26":{"body":66,"breadcrumbs":3,"title":1},"27":{"body":5,"breadcrumbs":4,"title":2},"3":{"body":0,"breadcrumbs":2,"title":1},"4":{"body":15,"breadcrumbs":2,"title":1},"5":{"body":17,"breadcrumbs":6,"title":5},"6":{"body":6,"breadcrumbs":2,"title":1},"7":{"body":11,"breadcrumbs":4,"title":3},"8":{"body":10,"breadcrumbs":4,"title":3},"9":{"body":20,"breadcrumbs":3,"title":2}},"docs":{"0":{"body":"","breadcrumbs":"Introduction » Crypt4GH utility","id":"0","title":"Crypt4GH utility"},"1":{"body":"Bob wants to send a message to Alice, containing sensitive data. Bob uses Crypt4GH, the Global Alliance approved secure method for sharing human genetic data crypt4gh, a Rust tool to encrypt, decrypt or re-encrypt files, according to the GA4GH encryption file format . How Crypt4GH works","breadcrumbs":"Introduction » Introduction","id":"1","title":"Introduction"},"10":{"body":"If you have any issue with the installation please create an issue on Github .","breadcrumbs":"Installation » Issues","id":"10","title":"Issues"},"11":{"body":"","breadcrumbs":"Encryption » Encryption Algorithm - Crypt4GH","id":"11","title":"Encryption Algorithm - Crypt4GH"},"12":{"body":"A random session key (of 256 bits) is generated to seed a ChaCha20 engine, with Poly1305 authentication mode. For each segment of at most 64kB of data, a nonce is randomly generated and prepended to the segment. Using the two latters, the original file is segmented and each segment is encrypted. The header is prepended to the encrypted data. Informally, the header contains, the word crypt4gh, the format version (currently 1), the number of header packets, and the sequence of header packets. A header packet is a length followed by its content. The content can be a data encryption packet or an edit list packet. All packets are encrypted using a Curve25519-based encryption. Encryption process","breadcrumbs":"Encryption » Encryption Format","id":"12","title":"Encryption Format"},"13":{"body":"The advantages of the format are, among others: Re-encrypting the file for another user requires only to decrypt the header and encrypt it with the user’s public key. Header packets can be encrypted for multiple recipients. Re-arranging the file to chunk a portion requires only to decrypt the header, re-encrypt with an edit list, and select the cipher segments surrounding the portion. The file itself is not decrypted and reencrypted.","breadcrumbs":"Encryption » Features","id":"13","title":"Features"},"14":{"body":"This utility supports OpenSSH key-format (version 6.5 or above) if the key was generated with type ed25519 (i.e. with ssh-keygen -t ed25519 ...). Otherwise, this utility can generate keys in the following format:","breadcrumbs":"Key Format » Crypt4GH Key Format","id":"14","title":"Crypt4GH Key Format"},"15":{"body":"A key is stored in the following PEM format: -----BEGIN CRYPT4GH <type> KEY-----\nBASE64-ENCODED DATA\n-----END CRYPT4GH <type> KEY----- where <type> is either PUBLIC or PRIVATE.","breadcrumbs":"Key Format » Keys","id":"15","title":"Keys"},"16":{"body":"For a public key, the key data is the byte representation of the plaintext key material.","breadcrumbs":"Key Format » Public key data","id":"16","title":"Public key data"},"17":{"body":"For a private key, we use the following encoding format. byte[] MAGIC_WORD\nstring kdfname\nstring (rounds || salt) # included if kdfname is not \"none\"\nstring ciphername\nstring private blob # Key material encrypted or not\nstring comment # Optional The MAGIC_WORD is the byte-representation of the ASCII word \"c4gh-v1\". Everything string consists of a length n (encoded as 2 big-endian bytes) and a sequence of n bytes (i.e. the string \"hello\", is encoded as \\x00\\x05hello). The kdfname is the name of the Key Derivation Function. We support either \"scrypt\", \"pbkdf2_hmac_sha256\", \"bcrypt\", or \"none\". The Rust implementation uses scrypt when available, and defaults to bcrypt for generating keys. The rounds is a 4 big-endian bytes representation of the number of iterations used in the KDF. The ciphername describes which symmetric algorithm is used to generate the encrypted data, as follows. The only supported cipher is \"chacha20_poly1305\" (so far), or \"none\". When kdfname is none, so should the ciphername be (and vice-versa), and the (rounds || salt) string is not included. This is used when the key material is not encrypted. In case the key material is encrypted, the KDF is used to derive a secret from a user-supplied passphrase. A nonce is randomly generated, and used in conjunction with the secret to encrypt the private key, using Chacha20 and authenticated with Poly1305. The nonce is prepended to the encrypted data . Finally, an optional comment can be used at the end of the encoded format.","breadcrumbs":"Key Format » Private key data","id":"17","title":"Private key data"},"18":{"body":"","breadcrumbs":"Key Format » Examples","id":"18","title":"Examples"},"19":{"body":"crypt4gh keygen --sk user.sec --pk user.pub","breadcrumbs":"Key Format » Crypt4GH Key generation","id":"19","title":"Crypt4GH Key generation"},"2":{"body":"Alice and Bob generate both a pair of public/private keys. crypt4gh keygen --sk alice.sec --pk alice.pub\ncrypt4gh keygen --sk bob.sec --pk bob.pub Bob encrypts a file for Alice: crypt4gh encrypt --sk bob.sec --recipient_pk alice.pub < file > file.c4gh Alice decrypts the encrypted file: crypt4gh decrypt --sk alice.sec < file.c4gh","breadcrumbs":"Introduction » Basic example","id":"2","title":"Basic example"},"20":{"body":"ssh-keygen -t ed25519 -f <output_filepath> -N <passphrase>","breadcrumbs":"Key Format » OpenSSH Key generation","id":"20","title":"OpenSSH Key generation"},"21":{"body":"The usual --help flag shows you the different options that the tool accepts. $ crypt4gh --help Utility for the cryptographic GA4GH standard, reading from stdin and outputting to stdout. USAGE: crypt4gh [FLAGS] [SUBCOMMAND] FLAGS: -h, --help Prints help information -v, --verbose Sets the level of verbosity -V, --version Prints version information SUBCOMMANDS: decrypt Decrypts the input using your secret key and the (optional) public key of the sender. encrypt Encrypts the input using your (optional) secret key and the public key of the recipient. help Prints this message or the help of the given subcommand(s) keygen Utility to create Crypt4GH-formatted keys. rearrange Rearranges the input according to the edit list packet. reencrypt Decrypts the input using your (optional) secret key and then it reencrypts it using the public key of the recipient.","breadcrumbs":"Usage & Examples » Usage & Examples","id":"21","title":"Usage & Examples"},"22":{"body":"$ crypt4gh keygen --help crypt4gh-keygen\nUtility to create Crypt4GH-formatted keys. USAGE: crypt4gh keygen [FLAGS] [OPTIONS] FLAGS: -f Overwrite the destination files -h, --help Prints help information --nocrypt Do not encrypt the private key. Otherwise it is encrypted in the Crypt4GH key format (See https://crypt4gh.readthedocs.io/en/latest/keys.html) -V, --version Prints version information OPTIONS: -C, --comment <comment> Key's Comment --pk <keyfile> Curve25519-based Public key [env: C4GH_PUBLIC_KEY] [default: ~/.c4gh/key.pub] --sk <keyfile> Curve25519-based Private key [env: C4GH_SECRET_KEY] [default: ~/.c4gh/key] Generate a Crypt4GH Key for Alice and Bob. crypt4gh keygen --sk alice.sec --pk alice.pub crypt4gh keygen --sk bob.sec --pk bob.pub","breadcrumbs":"Usage & Examples » Keygen","id":"22","title":"Keygen"},"23":{"body":"$ crypt4gh encrypt --help crypt4gh-encrypt\nEncrypts the input using your (optional) secret key and the public key of the recipient. USAGE: crypt4gh encrypt [OPTIONS] --recipient_pk <path>... FLAGS: -h, --help Prints help information -V, --version Prints version information OPTIONS: --range <start-end> Byte-range either as <start-end> or just <start> (Start included, End excluded) --recipient_pk <path>... Recipient's Curve25519-based Public key --sk <path> Curve25519-based Private key [env: C4GH_SECRET_KEY] Alice encrypts a file file.txt for Bob: crypt4gh encrypt --sk alice.sec --recipient_pk bob.pub < original_file.txt > encrypted_file.c4gh","breadcrumbs":"Usage & Examples » Encrypt","id":"23","title":"Encrypt"},"24":{"body":"$ crypt4gh decrypt --help crypt4gh-decrypt\nDecrypts the input using your secret key and the (optional) public key of the sender. USAGE: crypt4gh decrypt [OPTIONS] FLAGS: -h, --help Prints help information -V, --version Prints version information OPTIONS: --sender_pk <path> Peer's Curve25519-based Public key to verify provenance (akin to signature) --sk <path> Curve25519-based Private key. [env: C4GH_SECRET_KEY] Bob decrypts an encrypted file: crypt4gh decrypt --sk bob.sec < encrypted_file.c4gh > decrypted_file.txt If Bob wants to, optionally, verify that the message indeed comes from Alice, he needs to fetch Alice's public key via another trusted channel. He can then decrypt and check the provenance of the file with: crypt4gh decrypt --sk bob.sec --sender_pk alice.pub < encrypted_file.c4gh > decrypted_file.txt","breadcrumbs":"Usage & Examples » Decrypt","id":"24","title":"Decrypt"},"25":{"body":"$ crypt4gh reencrypt --help crypt4gh-reencrypt\nDecrypts the input using your (optional) secret key and then it reencrypts it using the public key\nof the recipient. USAGE: crypt4gh reencrypt [FLAGS] [OPTIONS] --recipient_pk <path>... FLAGS: -h, --help Prints help information -t, --trim Keep only header packets that you can decrypt -V, --version Prints version information OPTIONS: --recipient_pk <path>... Recipient's Curve25519-based Public key --sk <path> Curve25519-based Private key [env: C4GH_SECRET_KEY] Bob reencrypts a file for alice and for himself: crypt4gh reencrypt --sk bob.sec --recipient_pk alice.pub bob.pub < encrypted_file.c4gh > reencrypted_file.c4gh","breadcrumbs":"Usage & Examples » Reencrypt","id":"25","title":"Reencrypt"},"26":{"body":"$ crypt4gh rearrange --help crypt4gh-rearrange\nRearranges the input according to the edit list packet. USAGE: crypt4gh rearrange [OPTIONS] --range <start-end> FLAGS: -h, --help Prints help information -V, --version Prints version information OPTIONS: --range <start-end> Byte-range either as <start-end> or just <start> (Start included, End excluded) --sk <path> Curve25519-based Private key [env: C4GH_SECRET_KEY] Bob rearranges an encrypted file with the bytes from 65535 to 131074: crypt4gh rearrange --sk bob.sec --range 65535-131074 < encrypted_file.c4gh > rearranged_file.c4gh","breadcrumbs":"Usage & Examples » Rearrange","id":"26","title":"Rearrange"},"27":{"body":"You can check the documentation of the Rust library on docs.rs .","breadcrumbs":"Rust Library » Rust Library","id":"27","title":"Rust Library"},"3":{"body":"","breadcrumbs":"Installation » Installation","id":"3","title":"Installation"},"4":{"body":"You need to install Rust in order to compile the source code. To build from source on Windows , you should first have installed the MSVC Build Tools .","breadcrumbs":"Installation » Requirements","id":"4","title":"Requirements"},"5":{"body":"To download Rustup and install Rust, run the following in your terminal, then follow the on-screen instructions. curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh","breadcrumbs":"Installation » Linux, MacOS or another Unix-like OS","id":"5","title":"Linux, MacOS or another Unix-like OS"},"6":{"body":"Download and run the following executable: rustup-init.exe","breadcrumbs":"Installation » Windows","id":"6","title":"Windows"},"7":{"body":"If you prefer not to use the shell script, you may directly download rustup-init for the platform of your choice here .","breadcrumbs":"Installation » Other ways to install Rust","id":"7","title":"Other ways to install Rust"},"8":{"body":"Once installed, you can install crypt4gh executing the following in your terminal: cargo install crypt4gh","breadcrumbs":"Installation » Building from source (recommended)","id":"8","title":"Building from source (recommended)"},"9":{"body":"In the releases page , You can find compiled binaries for: Linux (x86_64-unknown-linux-gnu) OS X (x86_64-apple-darwin) Windows (x86_64-pc-windows-msvc)","breadcrumbs":"Installation » Standalone binaries","id":"9","title":"Standalone binaries"}},"length":28,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"1":{"3":{"1":{"0":{"7":{"4":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"2":{"5":{"6":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}},"4":{"df":1,"docs":{"17":{"tf":1.0}}},"6":{".":{"5":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"4":{"df":0,"docs":{},"k":{"b":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"5":{"5":{"3":{"5":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.0}}}}}}}}},"i":{"c":{"df":6,"docs":{"1":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"24":{"tf":1.0}}},".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":4,"docs":{"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"5":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"6":{"4":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":6,"docs":{"12":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"b":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":4,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":5,"docs":{"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":7,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":2.23606797749979},"23":{"tf":1.0},"26":{"tf":1.4142135623730951}}}}}},"c":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"22":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":5,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"17":{"tf":1.0}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":1,"docs":{"22":{"tf":1.0}},"h":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"2":{"0":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"1":{"3":{"0":{"5":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"24":{"tf":1.0},"27":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"24":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"12":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":15,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":2.0},"21":{"tf":1.7320508075688772},"22":{"tf":2.8284271247461903},"23":{"tf":2.0},"24":{"tf":2.23606797749979},"25":{"tf":2.0},"26":{"tf":2.0},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"2":{"5":{"5":{"1":{"9":{"df":6,"docs":{"12":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"t":{"a":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"13":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"24":{"tf":3.0},"25":{"tf":1.4142135623730951}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"22":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"d":{"2":{"5":{"5":{"1":{"9":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":2.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":11,"docs":{"1":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":2.6457513110645907},"13":{"tf":2.0},"17":{"tf":2.449489742783178},"2":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":2.6457513110645907},"24":{"tf":1.0},"26":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":4,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.7320508075688772},"26":{"tf":2.0}},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"v":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"18":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":2,"docs":{"20":{"tf":1.0},"22":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":9,"docs":{"1":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"21":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"a":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"21":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"12":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}}}}},"h":{"df":6,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}},"p":{"df":6,"docs":{"21":{"tf":2.449489742783178},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"5":{"tf":1.0}},"s":{":":{"/":{"/":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{".":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"23":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":7,"docs":{"12":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":1,"docs":{"7":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"21":{"tf":2.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"k":{"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"17":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":2.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.0}}}},"y":{"'":{"df":1,"docs":{"22":{"tf":1.0}}},"df":15,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":2.0},"15":{"tf":2.0},"16":{"tf":2.0},"17":{"tf":2.8284271247461903},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":2.6457513110645907},"22":{"tf":2.449489742783178},"23":{"tf":2.0},"24":{"tf":2.23606797749979},"25":{"tf":2.0},"26":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":2.449489742783178}}}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"5":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"v":{"c":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"24":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":2.0}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"20":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":2.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"12":{"tf":1.0}}}}}}},"s":{"df":2,"docs":{"5":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"14":{"tf":1.0},"22":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"21":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":2.449489742783178},"13":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"f":{"2":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"2":{"5":{"6":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":1,"docs":{"15":{"tf":1.0}}}},"k":{"df":3,"docs":{"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"1":{"3":{"0":{"5":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"21":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"15":{"tf":1.0},"17":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"df":8,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"26":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"26":{"tf":2.6457513110645907}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"23":{"tf":1.0},"25":{"tf":1.0}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":3,"docs":{"2":{"tf":1.0},"23":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"1":{"tf":1.0},"13":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":2.6457513110645907}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":1,"docs":{"22":{"tf":1.0}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":2.0},"13":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"21":{"tf":1.0},"24":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":1,"docs":{"5":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"k":{"df":7,"docs":{"19":{"tf":1.0},"2":{"tf":2.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"5":{"tf":1.0}}},"h":{"df":2,"docs":{"14":{"tf":1.0},"20":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"r":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":2.0},"26":{"tf":2.23606797749979}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":2.8284271247461903}}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"(":{"df":1,"docs":{"21":{"tf":1.0}}},"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"t":{"df":3,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"1":{".":{"2":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"o":{"df":1,"docs":{"12":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"5":{"tf":1.0}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}},"df":8,"docs":{"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":3.0},"21":{"tf":2.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}},"’":{"df":1,"docs":{"13":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.0},"14":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}}},"v":{"1":{"df":1,"docs":{"17":{"tf":1.0}}},"df":6,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"s":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}}}}}},"i":{"a":{"df":1,"docs":{"24":{"tf":1.0}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"4":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"x":{"0":{"0":{"\\":{"df":0,"docs":{},"x":{"0":{"5":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}}}}},"breadcrumbs":{"root":{"1":{"3":{"1":{"0":{"7":{"4":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"2":{"5":{"6":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}},"4":{"df":1,"docs":{"17":{"tf":1.0}}},"6":{".":{"5":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"4":{"df":0,"docs":{},"k":{"b":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"5":{"5":{"3":{"5":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"17":{"tf":1.0}}}}}}}}},"i":{"c":{"df":6,"docs":{"1":{"tf":1.0},"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"24":{"tf":1.0}}},".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":4,"docs":{"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"6":{"4":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":6,"docs":{"12":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"b":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":4,"docs":{"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":5,"docs":{"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":7,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":2.23606797749979},"23":{"tf":1.0},"26":{"tf":1.4142135623730951}}}}}},"c":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"22":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":5,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"17":{"tf":1.0}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":1,"docs":{"22":{"tf":1.0}},"h":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"2":{"0":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"1":{"3":{"0":{"5":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"24":{"tf":1.0},"27":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"24":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"12":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":15,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"2":{"tf":2.0},"21":{"tf":1.7320508075688772},"22":{"tf":2.8284271247461903},"23":{"tf":2.0},"24":{"tf":2.23606797749979},"25":{"tf":2.0},"26":{"tf":2.0},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"2":{"5":{"5":{"1":{"9":{"df":6,"docs":{"12":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"t":{"a":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"13":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"24":{"tf":3.1622776601683795},"25":{"tf":1.4142135623730951}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"22":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"d":{"2":{"5":{"5":{"1":{"9":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":2.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":11,"docs":{"1":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"12":{"tf":3.0},"13":{"tf":2.23606797749979},"17":{"tf":2.449489742783178},"2":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":2.8284271247461903},"24":{"tf":1.0},"26":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":4,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.7320508075688772},"26":{"tf":2.0}},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"v":{"df":5,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":8,"docs":{"18":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"23":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":2,"docs":{"20":{"tf":1.0},"22":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":9,"docs":{"1":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"21":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"26":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":7,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":12,"docs":{"1":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":2.23606797749979},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"a":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"21":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"12":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}}}}},"h":{"df":6,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}},"p":{"df":6,"docs":{"21":{"tf":2.449489742783178},"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"26":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"25":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"5":{"tf":1.0}},"s":{":":{"/":{"/":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{".":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"23":{"tf":1.0},"26":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":7,"docs":{"12":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":1,"docs":{"7":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"21":{"tf":2.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":2.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"2":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":2.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"k":{"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"17":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":2.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"25":{"tf":1.0}}}},"y":{"'":{"df":1,"docs":{"22":{"tf":1.0}}},"df":16,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":2.449489742783178},"15":{"tf":2.449489742783178},"16":{"tf":2.449489742783178},"17":{"tf":3.1622776601683795},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"2":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":2.6457513110645907},"22":{"tf":2.449489742783178},"23":{"tf":2.0},"24":{"tf":2.23606797749979},"25":{"tf":2.0},"26":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":2.6457513110645907}}}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"v":{"c":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"24":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":2.0}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"20":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":2.0},"25":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"12":{"tf":1.0}}}}}}},"s":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"14":{"tf":1.0},"22":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"21":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":2.449489742783178},"13":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"f":{"2":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"2":{"5":{"6":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":1,"docs":{"15":{"tf":1.0}}}},"k":{"df":3,"docs":{"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"1":{"3":{"0":{"5":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"21":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"15":{"tf":1.0},"17":{"tf":2.23606797749979},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"df":8,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"26":{"tf":2.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"26":{"tf":2.8284271247461903}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"25":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"23":{"tf":1.0},"25":{"tf":1.0}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":3,"docs":{"2":{"tf":1.0},"23":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"1":{"tf":1.0},"13":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":2.8284271247461903}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":2.0},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":1,"docs":{"22":{"tf":1.0}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":2.0},"13":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"1":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"21":{"tf":1.0},"24":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":1,"docs":{"5":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"k":{"df":7,"docs":{"19":{"tf":1.0},"2":{"tf":2.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"24":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"f":{"df":1,"docs":{"5":{"tf":1.0}}},"h":{"df":2,"docs":{"14":{"tf":1.0},"20":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"r":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"23":{"tf":2.0},"26":{"tf":2.23606797749979}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":2.8284271247461903}}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"(":{"df":1,"docs":{"21":{"tf":1.0}}},"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"t":{"df":3,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"25":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"1":{".":{"2":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"25":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"o":{"df":1,"docs":{"12":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}},"df":8,"docs":{"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":3.0},"21":{"tf":2.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}},"’":{"df":1,"docs":{"13":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}}}}},"v":{"1":{"df":1,"docs":{"17":{"tf":1.0}}},"df":6,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"s":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951}}}}}}}},"i":{"a":{"df":1,"docs":{"24":{"tf":1.0}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"4":{"tf":1.0},"6":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"x":{"0":{"0":{"\\":{"df":0,"docs":{},"x":{"0":{"5":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}}}}},"title":{"root":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"4":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"23":{"tf":1.0}}}}}}},"df":0,"docs":{}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"18":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"14":{"tf":1.0}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":6,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"s":{"df":1,"docs":{"5":{"tf":1.0}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"7":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"5":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});