//! Cryiorust derive macro crate
//!
//! Usage example:
//! ```rust
//! use cryiorust::frame::{Array, Frame};
//!
//! #[derive(Frame)]
//! struct MyFrame {
//!     header: Header,
//!     array: Array,
//! }
//! ```
//!
extern crate proc_macro;
use proc_macro::TokenStream;
use quote::quote;
use syn;

/// Main derive macro to be used for structures which contain fields ```Array``` and ```Frame```
#[proc_macro_derive(Frame)]
pub fn frame_derive(input: TokenStream) -> TokenStream {
    let ast = syn::parse(input).unwrap();
    impl_frame(&ast)
}

fn impl_frame(ast: &syn::DeriveInput) -> TokenStream {
    let name = &ast.ident;
    let gen = quote! {
        impl Frame for #name {
            fn array(&self) -> &Array {
                &self.array
            }

            fn header(&self) -> &Header {
                &self.header
            }

            fn header_mut(&mut self) -> &mut Header {
                &mut self.header
            }

            fn array_mut(&mut self) -> &mut Array {
                &mut self.array
            }

            fn set_array(&mut self, array: Array) {
                self.array = array;
            }

            fn consume_array(self: Box<Self>) -> Array {
                self.array
            }

            fn take_array(&mut self) -> Array {
                std::mem::take(&mut self.array)
            }
        }
    };
    gen.into()
}
