#include "test.h"
#include <cry/dh.h>

#define P\
    "19327210897467885519624495407304217845488409100133554803661172025039322784872775172789521895444178690740428588185031695453815386756662619555849446656794905221115788002016245291768283472480460523777510973085032471711187806590185987219179345022033106753600355795626394426859896564719805266547324204357196851217"

#define G\
    "2008851267811649301382055697326002225321501629224616043097959307844472637339783779480891271906681929732776937543331689329117914118665148580824850572191418544875109802154341862162654424065963144063936607375606796563706389362731767772194368576684632589065496658911743756860379357301492526015846031839304359976"

#define E1_STR "443154410456340133792289316319263982636340525614"

#define Y1_STR\
    "19214527844626903057876819500198193169641589347178408096123216510760347079712191313032299648983096329723695855109908254140955786116528541418541362827071586390177634912480649233043139477929903259189433530002441382680657615102217954388034130335905388651243538583579147122642435281102052849841738314682543989601"

#define E2_STR "708552627548105121354432083524985769585714694203"

#define Y2_STR\
    "3937080188154677493259235717003923170452040251322722383998191539290402689287507004151691833350902076026964761378570941292367186512432962797136953267476511207359495619723797706367761128646507069825337308608466957966848381476382337976511415036913259368572438791510731359101113653373912723872286563003569148155"

#define Z_STR\
    "3319378743040852066281248525554807677790302702508026945509475209822628115979919072086113870913560507774856945133392136183003690776440178796381579221428966587264253537339828969490182101527493009109323901449731640941391012218303971614835307873129064601312291695971038344663201164529792929266992327467270782207"

void dh_test(void)
{
    cry_dh_ctx dh1, dh2;
    cry_mpi Y1, Y2, Z;

    ASSERT_EQ(cry_mpi_init_str(&Y1, 10, Y1_STR), 0);
    ASSERT_EQ(cry_mpi_init_str(&Y2, 10, Y2_STR), 0);

    /* First actor */

    cry_dh_init(&dh1);
    ASSERT_EQ(cry_mpi_init_str(&dh1.g, 10, G), 0);
    ASSERT_EQ(cry_mpi_init_str(&dh1.p, 10, P), 0);
    ASSERT_EQ(cry_mpi_init_str(&dh1.e, 10, E1_STR), 0);
    ASSERT_EQ(cry_dh_agree(&dh1), 0);
    PRINT_MPI("Y1", &dh1.Y, 16);
    ASSERT_EQ(cry_mpi_cmp(&dh1.Y, &Y1), 0);
    /* Assume that we've received Y2... set in the context */
    ASSERT_EQ(cry_mpi_load_str(&dh1.Y, 10, Y2_STR), 0);
    ASSERT_EQ(cry_mpi_cmp(&dh1.Y, &Y2), 0);
    ASSERT_EQ(cry_dh_finalize(&dh1), 0);
    PRINT_MPI("Z1", &dh1.Z, 16);

    /* Second actor */


    cry_dh_init(&dh2);
    ASSERT_EQ(cry_mpi_init_str(&dh2.g, 10, G), 0);
    ASSERT_EQ(cry_mpi_init_str(&dh2.p, 10, P), 0);
    ASSERT_EQ(cry_mpi_init_str(&dh2.e, 10, E2_STR), 0);
    ASSERT_EQ(cry_dh_agree(&dh2), 0);
    PRINT_MPI("Y2", &dh2.Y, 16);
    ASSERT_EQ(cry_mpi_cmp(&dh2.Y, &Y2), 0);
    /* Assume that we've received Y1... set in the context */
    ASSERT_EQ(cry_mpi_load_str(&dh2.Y, 10, Y1_STR), 0);
    ASSERT_EQ(cry_mpi_cmp(&dh2.Y, &Y1), 0);
    ASSERT_EQ(cry_dh_finalize(&dh2), 0);

    /* Final checks */

    ASSERT_EQ(cry_mpi_init_str(&Z, 10, Z_STR), 0);
    ASSERT_EQ(cry_mpi_cmp(&dh1.Z, &dh2.Z), 0);
    ASSERT_EQ(cry_mpi_cmp(&dh1.Z, &Z), 0);

    cry_dh_clear(&dh1);
    cry_dh_clear(&dh2);
    cry_mpi_clear_list(&Y1, &Y2, &Z, NULL);
}
