/**
 * @file    cry.h
 *
 * @brief   CRY library all-in-one include file.
 */

#ifndef CRY_H_
#define CRY_H_

#include <cry/version.h>

#include <cry/base64.h>
#include <cry/memxor.h>
#include <cry/prng.h>
#include <cry/utils.h>

#include <cry/mpi.h>
#include <cry/ecp.h>

#include <cry/ciph.h>
#include <cry/hash.h>

#include <cry/aes.h>
#include <cry/des.h>

#include <cry/arc4.h>
#include <cry/trivium.h>

#include <cry/rsa.h>

#include <cry/cbc.h>
#include <cry/cfb.h>
#include <cry/gcm.h>

#include <cry/md5.h>
#include <cry/sha1.h>
#include <cry/sha256.h>
#include <cry/sha512.h>

#include <cry/cmac.h>
#include <cry/hmac.h>

#include <cry/dsa.h>
#include <cry/ecdsa.h>
#include <cry/elgamal.h>

#include <cry/dh.h>
#include <cry/ecdh.h>

#include <cry/crc.h>

#include <cry/affine.h>
#include <cry/hill.h>

#endif /* CRY_H_ */
