/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUevent_st {
    _unused: [u8; 0],
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct float2 {
    pub x: f32,
    pub y: f32,
}
#[test]
fn bindgen_test_layout_float2() {
    assert_eq!(
        ::std::mem::size_of::<float2>(),
        8usize,
        concat!("Size of: ", stringify!(float2))
    );
    assert_eq!(
        ::std::mem::align_of::<float2>(),
        8usize,
        concat!("Alignment of ", stringify!(float2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<float2>())).x as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(float2), "::", stringify!(x))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<float2>())).y as *const _ as usize },
        4usize,
        concat!("Offset of field: ", stringify!(float2), "::", stringify!(y))
    );
}
#[doc = " The API call returned with no errors. In the case of query calls, this"]
#[doc = " also means that the operation being queried is complete (see"]
#[doc = " ::cudaEventQuery() and ::cudaStreamQuery())."]
pub const cudaError_cudaSuccess: cudaError = 0;
#[doc = " This indicates that one or more of the parameters passed to the API call"]
#[doc = " is not within an acceptable range of values."]
pub const cudaError_cudaErrorInvalidValue: cudaError = 1;
#[doc = " The API call failed because it was unable to allocate enough memory to"]
#[doc = " perform the requested operation."]
pub const cudaError_cudaErrorMemoryAllocation: cudaError = 2;
#[doc = " The API call failed because the CUDA driver and runtime could not be"]
#[doc = " initialized."]
pub const cudaError_cudaErrorInitializationError: cudaError = 3;
#[doc = " This indicates that a CUDA Runtime API call cannot be executed because"]
#[doc = " it is being called during process shut down, at a point in time after"]
#[doc = " CUDA driver has been unloaded."]
pub const cudaError_cudaErrorCudartUnloading: cudaError = 4;
#[doc = " This indicates profiler is not initialized for this run. This can"]
#[doc = " happen when the application is running with external profiling tools"]
#[doc = " like visual profiler."]
pub const cudaError_cudaErrorProfilerDisabled: cudaError = 5;
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 5.0. It is no longer an error"]
#[doc = " to attempt to enable/disable the profiling via ::cudaProfilerStart or"]
#[doc = " ::cudaProfilerStop without initialization."]
pub const cudaError_cudaErrorProfilerNotInitialized: cudaError = 6;
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 5.0. It is no longer an error"]
#[doc = " to call cudaProfilerStart() when profiling is already enabled."]
pub const cudaError_cudaErrorProfilerAlreadyStarted: cudaError = 7;
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 5.0. It is no longer an error"]
#[doc = " to call cudaProfilerStop() when profiling is already disabled."]
pub const cudaError_cudaErrorProfilerAlreadyStopped: cudaError = 8;
#[doc = " This indicates that a kernel launch is requesting resources that can"]
#[doc = " never be satisfied by the current device. Requesting more shared memory"]
#[doc = " per block than the device supports will trigger this error, as will"]
#[doc = " requesting too many threads or blocks. See ::cudaDeviceProp for more"]
#[doc = " device limitations."]
pub const cudaError_cudaErrorInvalidConfiguration: cudaError = 9;
#[doc = " This indicates that one or more of the pitch-related parameters passed"]
#[doc = " to the API call is not within the acceptable range for pitch."]
pub const cudaError_cudaErrorInvalidPitchValue: cudaError = 12;
#[doc = " This indicates that the symbol name/identifier passed to the API call"]
#[doc = " is not a valid name or identifier."]
pub const cudaError_cudaErrorInvalidSymbol: cudaError = 13;
#[doc = " This indicates that at least one host pointer passed to the API call is"]
#[doc = " not a valid host pointer."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 10.1."]
pub const cudaError_cudaErrorInvalidHostPointer: cudaError = 16;
#[doc = " This indicates that at least one device pointer passed to the API call is"]
#[doc = " not a valid device pointer."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 10.1."]
pub const cudaError_cudaErrorInvalidDevicePointer: cudaError = 17;
#[doc = " This indicates that the texture passed to the API call is not a valid"]
#[doc = " texture."]
pub const cudaError_cudaErrorInvalidTexture: cudaError = 18;
#[doc = " This indicates that the texture binding is not valid. This occurs if you"]
#[doc = " call ::cudaGetTextureAlignmentOffset() with an unbound texture."]
pub const cudaError_cudaErrorInvalidTextureBinding: cudaError = 19;
#[doc = " This indicates that the channel descriptor passed to the API call is not"]
#[doc = " valid. This occurs if the format is not one of the formats specified by"]
#[doc = " ::cudaChannelFormatKind, or if one of the dimensions is invalid."]
pub const cudaError_cudaErrorInvalidChannelDescriptor: cudaError = 20;
#[doc = " This indicates that the direction of the memcpy passed to the API call is"]
#[doc = " not one of the types specified by ::cudaMemcpyKind."]
pub const cudaError_cudaErrorInvalidMemcpyDirection: cudaError = 21;
#[doc = " This indicated that the user has taken the address of a constant variable,"]
#[doc = " which was forbidden up until the CUDA 3.1 release."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 3.1. Variables in constant"]
#[doc = " memory may now have their address taken by the runtime via"]
#[doc = " ::cudaGetSymbolAddress()."]
pub const cudaError_cudaErrorAddressOfConstant: cudaError = 22;
#[doc = " This indicated that a texture fetch was not able to be performed."]
#[doc = " This was previously used for device emulation of texture operations."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
#[doc = " removed with the CUDA 3.1 release."]
pub const cudaError_cudaErrorTextureFetchFailed: cudaError = 23;
#[doc = " This indicated that a texture was not bound for access."]
#[doc = " This was previously used for device emulation of texture operations."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
#[doc = " removed with the CUDA 3.1 release."]
pub const cudaError_cudaErrorTextureNotBound: cudaError = 24;
#[doc = " This indicated that a synchronization operation had failed."]
#[doc = " This was previously used for some device emulation functions."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
#[doc = " removed with the CUDA 3.1 release."]
pub const cudaError_cudaErrorSynchronizationError: cudaError = 25;
#[doc = " This indicates that a non-float texture was being accessed with linear"]
#[doc = " filtering. This is not supported by CUDA."]
pub const cudaError_cudaErrorInvalidFilterSetting: cudaError = 26;
#[doc = " This indicates that an attempt was made to read a non-float texture as a"]
#[doc = " normalized float. This is not supported by CUDA."]
pub const cudaError_cudaErrorInvalidNormSetting: cudaError = 27;
#[doc = " Mixing of device and device emulation code was not allowed."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
#[doc = " removed with the CUDA 3.1 release."]
pub const cudaError_cudaErrorMixedDeviceExecution: cudaError = 28;
#[doc = " This indicates that the API call is not yet implemented. Production"]
#[doc = " releases of CUDA will never return this error."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 4.1."]
pub const cudaError_cudaErrorNotYetImplemented: cudaError = 31;
#[doc = " This indicated that an emulated device pointer exceeded the 32-bit address"]
#[doc = " range."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
#[doc = " removed with the CUDA 3.1 release."]
pub const cudaError_cudaErrorMemoryValueTooLarge: cudaError = 32;
#[doc = " This indicates that the installed NVIDIA CUDA driver is older than the"]
#[doc = " CUDA runtime library. This is not a supported configuration. Users should"]
#[doc = " install an updated NVIDIA display driver to allow the application to run."]
pub const cudaError_cudaErrorInsufficientDriver: cudaError = 35;
#[doc = " This indicates that the surface passed to the API call is not a valid"]
#[doc = " surface."]
pub const cudaError_cudaErrorInvalidSurface: cudaError = 37;
#[doc = " This indicates that multiple global or constant variables (across separate"]
#[doc = " CUDA source files in the application) share the same string name."]
pub const cudaError_cudaErrorDuplicateVariableName: cudaError = 43;
#[doc = " This indicates that multiple textures (across separate CUDA source"]
#[doc = " files in the application) share the same string name."]
pub const cudaError_cudaErrorDuplicateTextureName: cudaError = 44;
#[doc = " This indicates that multiple surfaces (across separate CUDA source"]
#[doc = " files in the application) share the same string name."]
pub const cudaError_cudaErrorDuplicateSurfaceName: cudaError = 45;
#[doc = " This indicates that all CUDA devices are busy or unavailable at the current"]
#[doc = " time. Devices are often busy/unavailable due to use of"]
#[doc = " ::cudaComputeModeExclusive, ::cudaComputeModeProhibited or when long"]
#[doc = " running CUDA kernels have filled up the GPU and are blocking new work"]
#[doc = " from starting. They can also be unavailable due to memory constraints"]
#[doc = " on a device that already has active CUDA work being performed."]
pub const cudaError_cudaErrorDevicesUnavailable: cudaError = 46;
#[doc = " This indicates that the current context is not compatible with this"]
#[doc = " the CUDA Runtime. This can only occur if you are using CUDA"]
#[doc = " Runtime/Driver interoperability and have created an existing Driver"]
#[doc = " context using the driver API. The Driver context may be incompatible"]
#[doc = " either because the Driver context was created using an older version"]
#[doc = " of the API, because the Runtime API call expects a primary driver"]
#[doc = " context and the Driver context is not primary, or because the Driver"]
#[doc = " context has been destroyed. Please see \\ref CUDART_DRIVER \"Interactions"]
#[doc = " with the CUDA Driver API\" for more information."]
pub const cudaError_cudaErrorIncompatibleDriverContext: cudaError = 49;
#[doc = " The device function being invoked (usually via ::cudaLaunchKernel()) was not"]
#[doc = " previously configured via the ::cudaConfigureCall() function."]
pub const cudaError_cudaErrorMissingConfiguration: cudaError = 52;
#[doc = " This indicated that a previous kernel launch failed. This was previously"]
#[doc = " used for device emulation of kernel launches."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 3.1. Device emulation mode was"]
#[doc = " removed with the CUDA 3.1 release."]
pub const cudaError_cudaErrorPriorLaunchFailure: cudaError = 53;
#[doc = " This error indicates that a device runtime grid launch did not occur"]
#[doc = " because the depth of the child grid would exceed the maximum supported"]
#[doc = " number of nested grid launches."]
pub const cudaError_cudaErrorLaunchMaxDepthExceeded: cudaError = 65;
#[doc = " This error indicates that a grid launch did not occur because the kernel"]
#[doc = " uses file-scoped textures which are unsupported by the device runtime."]
#[doc = " Kernels launched via the device runtime only support textures created with"]
#[doc = " the Texture Object API's."]
pub const cudaError_cudaErrorLaunchFileScopedTex: cudaError = 66;
#[doc = " This error indicates that a grid launch did not occur because the kernel"]
#[doc = " uses file-scoped surfaces which are unsupported by the device runtime."]
#[doc = " Kernels launched via the device runtime only support surfaces created with"]
#[doc = " the Surface Object API's."]
pub const cudaError_cudaErrorLaunchFileScopedSurf: cudaError = 67;
#[doc = " This error indicates that a call to ::cudaDeviceSynchronize made from"]
#[doc = " the device runtime failed because the call was made at grid depth greater"]
#[doc = " than than either the default (2 levels of grids) or user specified device"]
#[doc = " limit ::cudaLimitDevRuntimeSyncDepth. To be able to synchronize on"]
#[doc = " launched grids at a greater depth successfully, the maximum nested"]
#[doc = " depth at which ::cudaDeviceSynchronize will be called must be specified"]
#[doc = " with the ::cudaLimitDevRuntimeSyncDepth limit to the ::cudaDeviceSetLimit"]
#[doc = " api before the host-side launch of a kernel using the device runtime."]
#[doc = " Keep in mind that additional levels of sync depth require the runtime"]
#[doc = " to reserve large amounts of device memory that cannot be used for"]
#[doc = " user allocations."]
pub const cudaError_cudaErrorSyncDepthExceeded: cudaError = 68;
#[doc = " This error indicates that a device runtime grid launch failed because"]
#[doc = " the launch would exceed the limit ::cudaLimitDevRuntimePendingLaunchCount."]
#[doc = " For this launch to proceed successfully, ::cudaDeviceSetLimit must be"]
#[doc = " called to set the ::cudaLimitDevRuntimePendingLaunchCount to be higher"]
#[doc = " than the upper bound of outstanding launches that can be issued to the"]
#[doc = " device runtime. Keep in mind that raising the limit of pending device"]
#[doc = " runtime launches will require the runtime to reserve device memory that"]
#[doc = " cannot be used for user allocations."]
pub const cudaError_cudaErrorLaunchPendingCountExceeded: cudaError = 69;
#[doc = " The requested device function does not exist or is not compiled for the"]
#[doc = " proper device architecture."]
pub const cudaError_cudaErrorInvalidDeviceFunction: cudaError = 98;
#[doc = " This indicates that no CUDA-capable devices were detected by the installed"]
#[doc = " CUDA driver."]
pub const cudaError_cudaErrorNoDevice: cudaError = 100;
#[doc = " This indicates that the device ordinal supplied by the user does not"]
#[doc = " correspond to a valid CUDA device."]
pub const cudaError_cudaErrorInvalidDevice: cudaError = 101;
#[doc = " This indicates an internal startup failure in the CUDA runtime."]
pub const cudaError_cudaErrorStartupFailure: cudaError = 127;
#[doc = " This indicates that the device kernel image is invalid."]
pub const cudaError_cudaErrorInvalidKernelImage: cudaError = 200;
#[doc = " This most frequently indicates that there is no context bound to the"]
#[doc = " current thread. This can also be returned if the context passed to an"]
#[doc = " API call is not a valid handle (such as a context that has had"]
#[doc = " ::cuCtxDestroy() invoked on it). This can also be returned if a user"]
#[doc = " mixes different API versions (i.e. 3010 context with 3020 API calls)."]
#[doc = " See ::cuCtxGetApiVersion() for more details."]
pub const cudaError_cudaErrorDeviceUninitilialized: cudaError = 201;
#[doc = " This indicates that the buffer object could not be mapped."]
pub const cudaError_cudaErrorMapBufferObjectFailed: cudaError = 205;
#[doc = " This indicates that the buffer object could not be unmapped."]
pub const cudaError_cudaErrorUnmapBufferObjectFailed: cudaError = 206;
#[doc = " This indicates that the specified array is currently mapped and thus"]
#[doc = " cannot be destroyed."]
pub const cudaError_cudaErrorArrayIsMapped: cudaError = 207;
#[doc = " This indicates that the resource is already mapped."]
pub const cudaError_cudaErrorAlreadyMapped: cudaError = 208;
#[doc = " This indicates that there is no kernel image available that is suitable"]
#[doc = " for the device. This can occur when a user specifies code generation"]
#[doc = " options for a particular CUDA source file that do not include the"]
#[doc = " corresponding device configuration."]
pub const cudaError_cudaErrorNoKernelImageForDevice: cudaError = 209;
#[doc = " This indicates that a resource has already been acquired."]
pub const cudaError_cudaErrorAlreadyAcquired: cudaError = 210;
#[doc = " This indicates that a resource is not mapped."]
pub const cudaError_cudaErrorNotMapped: cudaError = 211;
#[doc = " This indicates that a mapped resource is not available for access as an"]
#[doc = " array."]
pub const cudaError_cudaErrorNotMappedAsArray: cudaError = 212;
#[doc = " This indicates that a mapped resource is not available for access as a"]
#[doc = " pointer."]
pub const cudaError_cudaErrorNotMappedAsPointer: cudaError = 213;
#[doc = " This indicates that an uncorrectable ECC error was detected during"]
#[doc = " execution."]
pub const cudaError_cudaErrorECCUncorrectable: cudaError = 214;
#[doc = " This indicates that the ::cudaLimit passed to the API call is not"]
#[doc = " supported by the active device."]
pub const cudaError_cudaErrorUnsupportedLimit: cudaError = 215;
#[doc = " This indicates that a call tried to access an exclusive-thread device that"]
#[doc = " is already in use by a different thread."]
pub const cudaError_cudaErrorDeviceAlreadyInUse: cudaError = 216;
#[doc = " This error indicates that P2P access is not supported across the given"]
#[doc = " devices."]
pub const cudaError_cudaErrorPeerAccessUnsupported: cudaError = 217;
#[doc = " A PTX compilation failed. The runtime may fall back to compiling PTX if"]
#[doc = " an application does not contain a suitable binary for the current device."]
pub const cudaError_cudaErrorInvalidPtx: cudaError = 218;
#[doc = " This indicates an error with the OpenGL or DirectX context."]
pub const cudaError_cudaErrorInvalidGraphicsContext: cudaError = 219;
#[doc = " This indicates that an uncorrectable NVLink error was detected during the"]
#[doc = " execution."]
pub const cudaError_cudaErrorNvlinkUncorrectable: cudaError = 220;
#[doc = " This indicates that the PTX JIT compiler library was not found. The JIT Compiler"]
#[doc = " library is used for PTX compilation. The runtime may fall back to compiling PTX"]
#[doc = " if an application does not contain a suitable binary for the current device."]
pub const cudaError_cudaErrorJitCompilerNotFound: cudaError = 221;
#[doc = " This indicates that the device kernel source is invalid."]
pub const cudaError_cudaErrorInvalidSource: cudaError = 300;
#[doc = " This indicates that the file specified was not found."]
pub const cudaError_cudaErrorFileNotFound: cudaError = 301;
#[doc = " This indicates that a link to a shared object failed to resolve."]
pub const cudaError_cudaErrorSharedObjectSymbolNotFound: cudaError = 302;
#[doc = " This indicates that initialization of a shared object failed."]
pub const cudaError_cudaErrorSharedObjectInitFailed: cudaError = 303;
#[doc = " This error indicates that an OS call failed."]
pub const cudaError_cudaErrorOperatingSystem: cudaError = 304;
#[doc = " This indicates that a resource handle passed to the API call was not"]
#[doc = " valid. Resource handles are opaque types like ::cudaStream_t and"]
#[doc = " ::cudaEvent_t."]
pub const cudaError_cudaErrorInvalidResourceHandle: cudaError = 400;
#[doc = " This indicates that a resource required by the API call is not in a"]
#[doc = " valid state to perform the requested operation."]
pub const cudaError_cudaErrorIllegalState: cudaError = 401;
#[doc = " This indicates that a named symbol was not found. Examples of symbols"]
#[doc = " are global/constant variable names, texture names, and surface names."]
pub const cudaError_cudaErrorSymbolNotFound: cudaError = 500;
#[doc = " This indicates that asynchronous operations issued previously have not"]
#[doc = " completed yet. This result is not actually an error, but must be indicated"]
#[doc = " differently than ::cudaSuccess (which indicates completion). Calls that"]
#[doc = " may return this value include ::cudaEventQuery() and ::cudaStreamQuery()."]
pub const cudaError_cudaErrorNotReady: cudaError = 600;
#[doc = " The device encountered a load or store instruction on an invalid memory address."]
#[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
#[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
#[doc = " and relaunched."]
pub const cudaError_cudaErrorIllegalAddress: cudaError = 700;
#[doc = " This indicates that a launch did not occur because it did not have"]
#[doc = " appropriate resources. Although this error is similar to"]
#[doc = " ::cudaErrorInvalidConfiguration, this error usually indicates that the"]
#[doc = " user has attempted to pass too many arguments to the device kernel, or the"]
#[doc = " kernel launch specifies too many threads for the kernel's register count."]
pub const cudaError_cudaErrorLaunchOutOfResources: cudaError = 701;
#[doc = " This indicates that the device kernel took too long to execute. This can"]
#[doc = " only occur if timeouts are enabled - see the device property"]
#[doc = " \\ref ::cudaDeviceProp::kernelExecTimeoutEnabled \"kernelExecTimeoutEnabled\""]
#[doc = " for more information."]
#[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
#[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
#[doc = " and relaunched."]
pub const cudaError_cudaErrorLaunchTimeout: cudaError = 702;
#[doc = " This error indicates a kernel launch that uses an incompatible texturing"]
#[doc = " mode."]
pub const cudaError_cudaErrorLaunchIncompatibleTexturing: cudaError = 703;
#[doc = " This error indicates that a call to ::cudaDeviceEnablePeerAccess() is"]
#[doc = " trying to re-enable peer addressing on from a context which has already"]
#[doc = " had peer addressing enabled."]
pub const cudaError_cudaErrorPeerAccessAlreadyEnabled: cudaError = 704;
#[doc = " This error indicates that ::cudaDeviceDisablePeerAccess() is trying to"]
#[doc = " disable peer addressing which has not been enabled yet via"]
#[doc = " ::cudaDeviceEnablePeerAccess()."]
pub const cudaError_cudaErrorPeerAccessNotEnabled: cudaError = 705;
#[doc = " This indicates that the user has called ::cudaSetValidDevices(),"]
#[doc = " ::cudaSetDeviceFlags(), ::cudaD3D9SetDirect3DDevice(),"]
#[doc = " ::cudaD3D10SetDirect3DDevice, ::cudaD3D11SetDirect3DDevice(), or"]
#[doc = " ::cudaVDPAUSetVDPAUDevice() after initializing the CUDA runtime by"]
#[doc = " calling non-device management operations (allocating memory and"]
#[doc = " launching kernels are examples of non-device management operations)."]
#[doc = " This error can also be returned if using runtime/driver"]
#[doc = " interoperability and there is an existing ::CUcontext active on the"]
#[doc = " host thread."]
pub const cudaError_cudaErrorSetOnActiveProcess: cudaError = 708;
#[doc = " This error indicates that the context current to the calling thread"]
#[doc = " has been destroyed using ::cuCtxDestroy, or is a primary context which"]
#[doc = " has not yet been initialized."]
pub const cudaError_cudaErrorContextIsDestroyed: cudaError = 709;
#[doc = " An assert triggered in device code during kernel execution. The device"]
#[doc = " cannot be used again. All existing allocations are invalid. To continue"]
#[doc = " using CUDA, the process must be terminated and relaunched."]
pub const cudaError_cudaErrorAssert: cudaError = 710;
#[doc = " This error indicates that the hardware resources required to enable"]
#[doc = " peer access have been exhausted for one or more of the devices"]
#[doc = " passed to ::cudaEnablePeerAccess()."]
pub const cudaError_cudaErrorTooManyPeers: cudaError = 711;
#[doc = " This error indicates that the memory range passed to ::cudaHostRegister()"]
#[doc = " has already been registered."]
pub const cudaError_cudaErrorHostMemoryAlreadyRegistered: cudaError = 712;
#[doc = " This error indicates that the pointer passed to ::cudaHostUnregister()"]
#[doc = " does not correspond to any currently registered memory region."]
pub const cudaError_cudaErrorHostMemoryNotRegistered: cudaError = 713;
#[doc = " Device encountered an error in the call stack during kernel execution,"]
#[doc = " possibly due to stack corruption or exceeding the stack size limit."]
#[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
#[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
#[doc = " and relaunched."]
pub const cudaError_cudaErrorHardwareStackError: cudaError = 714;
#[doc = " The device encountered an illegal instruction during kernel execution"]
#[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
#[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
#[doc = " and relaunched."]
pub const cudaError_cudaErrorIllegalInstruction: cudaError = 715;
#[doc = " The device encountered a load or store instruction"]
#[doc = " on a memory address which is not aligned."]
#[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
#[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
#[doc = " and relaunched."]
pub const cudaError_cudaErrorMisalignedAddress: cudaError = 716;
#[doc = " While executing a kernel, the device encountered an instruction"]
#[doc = " which can only operate on memory locations in certain address spaces"]
#[doc = " (global, shared, or local), but was supplied a memory address not"]
#[doc = " belonging to an allowed address space."]
#[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
#[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
#[doc = " and relaunched."]
pub const cudaError_cudaErrorInvalidAddressSpace: cudaError = 717;
#[doc = " The device encountered an invalid program counter."]
#[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
#[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
#[doc = " and relaunched."]
pub const cudaError_cudaErrorInvalidPc: cudaError = 718;
#[doc = " An exception occurred on the device while executing a kernel. Common"]
#[doc = " causes include dereferencing an invalid device pointer and accessing"]
#[doc = " out of bounds shared memory. Less common cases can be system specific - more"]
#[doc = " information about these cases can be found in the system specific user guide."]
#[doc = " This leaves the process in an inconsistent state and any further CUDA work"]
#[doc = " will return the same error. To continue using CUDA, the process must be terminated"]
#[doc = " and relaunched."]
pub const cudaError_cudaErrorLaunchFailure: cudaError = 719;
#[doc = " This error indicates that the number of blocks launched per grid for a kernel that was"]
#[doc = " launched via either ::cudaLaunchCooperativeKernel or ::cudaLaunchCooperativeKernelMultiDevice"]
#[doc = " exceeds the maximum number of blocks as allowed by ::cudaOccupancyMaxActiveBlocksPerMultiprocessor"]
#[doc = " or ::cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags times the number of multiprocessors"]
#[doc = " as specified by the device attribute ::cudaDevAttrMultiProcessorCount."]
pub const cudaError_cudaErrorCooperativeLaunchTooLarge: cudaError = 720;
#[doc = " This error indicates the attempted operation is not permitted."]
pub const cudaError_cudaErrorNotPermitted: cudaError = 800;
#[doc = " This error indicates the attempted operation is not supported"]
#[doc = " on the current system or device."]
pub const cudaError_cudaErrorNotSupported: cudaError = 801;
#[doc = " This error indicates that the system is not yet ready to start any CUDA"]
#[doc = " work.  To continue using CUDA, verify the system configuration is in a"]
#[doc = " valid state and all required driver daemons are actively running."]
#[doc = " More information about this error can be found in the system specific"]
#[doc = " user guide."]
pub const cudaError_cudaErrorSystemNotReady: cudaError = 802;
#[doc = " This error indicates that there is a mismatch between the versions of"]
#[doc = " the display driver and the CUDA driver. Refer to the compatibility documentation"]
#[doc = " for supported versions."]
pub const cudaError_cudaErrorSystemDriverMismatch: cudaError = 803;
#[doc = " This error indicates that the system was upgraded to run with forward compatibility"]
#[doc = " but the visible hardware detected by CUDA does not support this configuration."]
#[doc = " Refer to the compatibility documentation for the supported hardware matrix or ensure"]
#[doc = " that only supported hardware is visible during initialization via the CUDA_VISIBLE_DEVICES"]
#[doc = " environment variable."]
pub const cudaError_cudaErrorCompatNotSupportedOnDevice: cudaError = 804;
#[doc = " The operation is not permitted when the stream is capturing."]
pub const cudaError_cudaErrorStreamCaptureUnsupported: cudaError = 900;
#[doc = " The current capture sequence on the stream has been invalidated due to"]
#[doc = " a previous error."]
pub const cudaError_cudaErrorStreamCaptureInvalidated: cudaError = 901;
#[doc = " The operation would have resulted in a merge of two independent capture"]
#[doc = " sequences."]
pub const cudaError_cudaErrorStreamCaptureMerge: cudaError = 902;
#[doc = " The capture was not initiated in this stream."]
pub const cudaError_cudaErrorStreamCaptureUnmatched: cudaError = 903;
#[doc = " The capture sequence contains a fork that was not joined to the primary"]
#[doc = " stream."]
pub const cudaError_cudaErrorStreamCaptureUnjoined: cudaError = 904;
#[doc = " A dependency would have been created which crosses the capture sequence"]
#[doc = " boundary. Only implicit in-stream ordering dependencies are allowed to"]
#[doc = " cross the boundary."]
pub const cudaError_cudaErrorStreamCaptureIsolation: cudaError = 905;
#[doc = " The operation would have resulted in a disallowed implicit dependency on"]
#[doc = " a current capture sequence from cudaStreamLegacy."]
pub const cudaError_cudaErrorStreamCaptureImplicit: cudaError = 906;
#[doc = " The operation is not permitted on an event which was last recorded in a"]
#[doc = " capturing stream."]
pub const cudaError_cudaErrorCapturedEvent: cudaError = 907;
#[doc = " A stream capture sequence not initiated with the ::cudaStreamCaptureModeRelaxed"]
#[doc = " argument to ::cudaStreamBeginCapture was passed to ::cudaStreamEndCapture in a"]
#[doc = " different thread."]
pub const cudaError_cudaErrorStreamCaptureWrongThread: cudaError = 908;
#[doc = " This indicates that an unknown internal error has occurred."]
pub const cudaError_cudaErrorUnknown: cudaError = 999;
#[doc = " Any unhandled CUDA driver error is added to this value and returned via"]
#[doc = " the runtime. Production releases of CUDA should not return such errors."]
#[doc = " \\deprecated"]
#[doc = " This error return is deprecated as of CUDA 4.1."]
pub const cudaError_cudaErrorApiFailureBase: cudaError = 10000;
#[doc = " CUDA error types"]
pub type cudaError = u32;
#[doc = " CUDA Error types"]
pub use self::cudaError as cudaError_t;
#[doc = " CUDA event types"]
pub type cudaEvent_t = *mut CUevent_st;
#[doc = " CURAND XORWOW state"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct curandStateXORWOW {
    pub d: ::std::os::raw::c_uint,
    pub v: [::std::os::raw::c_uint; 5usize],
    pub boxmuller_flag: ::std::os::raw::c_int,
    pub boxmuller_flag_double: ::std::os::raw::c_int,
    pub boxmuller_extra: f32,
    pub boxmuller_extra_double: f64,
}
#[test]
fn bindgen_test_layout_curandStateXORWOW() {
    assert_eq!(
        ::std::mem::size_of::<curandStateXORWOW>(),
        48usize,
        concat!("Size of: ", stringify!(curandStateXORWOW))
    );
    assert_eq!(
        ::std::mem::align_of::<curandStateXORWOW>(),
        8usize,
        concat!("Alignment of ", stringify!(curandStateXORWOW))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<curandStateXORWOW>())).d as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(curandStateXORWOW),
            "::",
            stringify!(d)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<curandStateXORWOW>())).v as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(curandStateXORWOW),
            "::",
            stringify!(v)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<curandStateXORWOW>())).boxmuller_flag as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(curandStateXORWOW),
            "::",
            stringify!(boxmuller_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<curandStateXORWOW>())).boxmuller_flag_double as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(curandStateXORWOW),
            "::",
            stringify!(boxmuller_flag_double)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<curandStateXORWOW>())).boxmuller_extra as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(curandStateXORWOW),
            "::",
            stringify!(boxmuller_extra)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<curandStateXORWOW>())).boxmuller_extra_double as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(curandStateXORWOW),
            "::",
            stringify!(boxmuller_extra_double)
        )
    );
}
pub type curandState = curandStateXORWOW;
pub type cufftHandle = ::std::os::raw::c_int;
pub const cublasStatus_t_CUBLAS_STATUS_SUCCESS: cublasStatus_t = 0;
pub const cublasStatus_t_CUBLAS_STATUS_NOT_INITIALIZED: cublasStatus_t = 1;
pub const cublasStatus_t_CUBLAS_STATUS_ALLOC_FAILED: cublasStatus_t = 3;
pub const cublasStatus_t_CUBLAS_STATUS_INVALID_VALUE: cublasStatus_t = 7;
pub const cublasStatus_t_CUBLAS_STATUS_ARCH_MISMATCH: cublasStatus_t = 8;
pub const cublasStatus_t_CUBLAS_STATUS_MAPPING_ERROR: cublasStatus_t = 11;
pub const cublasStatus_t_CUBLAS_STATUS_EXECUTION_FAILED: cublasStatus_t = 13;
pub const cublasStatus_t_CUBLAS_STATUS_INTERNAL_ERROR: cublasStatus_t = 14;
pub const cublasStatus_t_CUBLAS_STATUS_NOT_SUPPORTED: cublasStatus_t = 15;
pub const cublasStatus_t_CUBLAS_STATUS_LICENSE_ERROR: cublasStatus_t = 16;
pub type cublasStatus_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cublasContext {
    _unused: [u8; 0],
}
pub type cublasHandle_t = *mut cublasContext;
pub const cusparseStatus_t_CUSPARSE_STATUS_SUCCESS: cusparseStatus_t = 0;
pub const cusparseStatus_t_CUSPARSE_STATUS_NOT_INITIALIZED: cusparseStatus_t = 1;
pub const cusparseStatus_t_CUSPARSE_STATUS_ALLOC_FAILED: cusparseStatus_t = 2;
pub const cusparseStatus_t_CUSPARSE_STATUS_INVALID_VALUE: cusparseStatus_t = 3;
pub const cusparseStatus_t_CUSPARSE_STATUS_ARCH_MISMATCH: cusparseStatus_t = 4;
pub const cusparseStatus_t_CUSPARSE_STATUS_MAPPING_ERROR: cusparseStatus_t = 5;
pub const cusparseStatus_t_CUSPARSE_STATUS_EXECUTION_FAILED: cusparseStatus_t = 6;
pub const cusparseStatus_t_CUSPARSE_STATUS_INTERNAL_ERROR: cusparseStatus_t = 7;
pub const cusparseStatus_t_CUSPARSE_STATUS_MATRIX_TYPE_NOT_SUPPORTED: cusparseStatus_t = 8;
pub const cusparseStatus_t_CUSPARSE_STATUS_ZERO_PIVOT: cusparseStatus_t = 9;
pub type cusparseStatus_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseContext {
    _unused: [u8; 0],
}
pub type cusparseHandle_t = *mut cusparseContext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusparseMatDescr {
    _unused: [u8; 0],
}
pub type cusparseMatDescr_t = *mut cusparseMatDescr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cusolverDnContext {
    _unused: [u8; 0],
}
pub type cusolverDnHandle_t = *mut cusolverDnContext;
extern "C" {
    #[link_name = "\u{1}_Z10set_devicei"]
    pub fn set_device(id: ::std::os::raw::c_int);
}
pub type rtd = f64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vector {
    pub x: rtd,
    pub y: rtd,
    pub z: rtd,
}
#[test]
fn bindgen_test_layout_vector() {
    assert_eq!(
        ::std::mem::size_of::<vector>(),
        24usize,
        concat!("Size of: ", stringify!(vector))
    );
    assert_eq!(
        ::std::mem::align_of::<vector>(),
        8usize,
        concat!("Alignment of ", stringify!(vector))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vector>())).x as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(vector), "::", stringify!(x))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vector>())).y as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(vector), "::", stringify!(y))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vector>())).z as *const _ as usize },
        16usize,
        concat!("Offset of field: ", stringify!(vector), "::", stringify!(z))
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6vector4rho2Ev"]
    pub fn vector_rho2(this: *mut vector) -> rtd;
}
extern "C" {
    #[link_name = "\u{1}_ZN6vector10rho2_shiftEdd"]
    pub fn vector_rho2_shift(this: *mut vector, x0: rtd, y0: rtd) -> rtd;
}
extern "C" {
    #[link_name = "\u{1}_ZN6vector3magEv"]
    pub fn vector_mag(this: *mut vector) -> rtd;
}
extern "C" {
    #[link_name = "\u{1}_ZN6vector3magEd"]
    pub fn vector_mag1(this: *mut vector, R: rtd) -> rtd;
}
extern "C" {
    #[link_name = "\u{1}_ZN6vector5angleEv"]
    pub fn vector_angle(this: *mut vector) -> rtd;
}
extern "C" {
    #[link_name = "\u{1}_ZN6vector4normEv"]
    pub fn vector_norm(this: *mut vector) -> rtd;
}
extern "C" {
    #[link_name = "\u{1}_ZN6vector3dotEPS_"]
    pub fn vector_dot(this: *mut vector, u: *mut vector) -> rtd;
}
extern "C" {
    #[link_name = "\u{1}_ZN6vector4unitEv"]
    pub fn vector_unit(this: *mut vector);
}
extern "C" {
    #[link_name = "\u{1}_ZN6vector10left_crossEPS_S0_"]
    pub fn vector_left_cross(this: *mut vector, w: *mut vector, u: *mut vector);
}
extern "C" {
    #[link_name = "\u{1}_ZN6vector11right_crossEPS_S0_"]
    pub fn vector_right_cross(this: *mut vector, w: *mut vector, u: *mut vector);
}
impl vector {
    #[inline]
    pub unsafe fn rho2(&mut self) -> rtd {
        vector_rho2(self)
    }
    #[inline]
    pub unsafe fn rho2_shift(&mut self, x0: rtd, y0: rtd) -> rtd {
        vector_rho2_shift(self, x0, y0)
    }
    #[inline]
    pub unsafe fn mag(&mut self) -> rtd {
        vector_mag(self)
    }
    #[inline]
    pub unsafe fn mag1(&mut self, R: rtd) -> rtd {
        vector_mag1(self, R)
    }
    #[inline]
    pub unsafe fn angle(&mut self) -> rtd {
        vector_angle(self)
    }
    #[inline]
    pub unsafe fn norm(&mut self) -> rtd {
        vector_norm(self)
    }
    #[inline]
    pub unsafe fn dot(&mut self, u: *mut vector) -> rtd {
        vector_dot(self, u)
    }
    #[inline]
    pub unsafe fn unit(&mut self) {
        vector_unit(self)
    }
    #[inline]
    pub unsafe fn left_cross(&mut self, w: *mut vector, u: *mut vector) {
        vector_left_cross(self, w, u)
    }
    #[inline]
    pub unsafe fn right_cross(&mut self, w: *mut vector, u: *mut vector) {
        vector_right_cross(self, w, u)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stopwatch {
    pub elapsedTime: f32,
    pub start: cudaEvent_t,
    pub stop: cudaEvent_t,
}
#[test]
fn bindgen_test_layout_stopwatch() {
    assert_eq!(
        ::std::mem::size_of::<stopwatch>(),
        24usize,
        concat!("Size of: ", stringify!(stopwatch))
    );
    assert_eq!(
        ::std::mem::align_of::<stopwatch>(),
        8usize,
        concat!("Alignment of ", stringify!(stopwatch))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stopwatch>())).elapsedTime as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stopwatch),
            "::",
            stringify!(elapsedTime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stopwatch>())).start as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stopwatch),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stopwatch>())).stop as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(stopwatch),
            "::",
            stringify!(stop)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mask {
    pub m: *mut ::std::os::raw::c_char,
    pub f: *mut f32,
    pub idx: *mut ::std::os::raw::c_int,
    pub size_px: [::std::os::raw::c_int; 2usize],
    pub nel: ::std::os::raw::c_int,
    pub nnz: f32,
    pub size_m: [f32; 2usize],
    pub area: f32,
    pub delta: [f32; 2usize],
    pub handle: cublasHandle_t,
    pub d__piston_mask: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_mask() {
    assert_eq!(
        ::std::mem::size_of::<mask>(),
        80usize,
        concat!("Size of: ", stringify!(mask))
    );
    assert_eq!(
        ::std::mem::align_of::<mask>(),
        8usize,
        concat!("Alignment of ", stringify!(mask))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).m as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(mask), "::", stringify!(m))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).f as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(mask), "::", stringify!(f))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).idx as *const _ as usize },
        16usize,
        concat!("Offset of field: ", stringify!(mask), "::", stringify!(idx))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).size_px as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mask),
            "::",
            stringify!(size_px)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).nel as *const _ as usize },
        32usize,
        concat!("Offset of field: ", stringify!(mask), "::", stringify!(nel))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).nnz as *const _ as usize },
        36usize,
        concat!("Offset of field: ", stringify!(mask), "::", stringify!(nnz))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).size_m as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(mask),
            "::",
            stringify!(size_m)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).area as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(mask),
            "::",
            stringify!(area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).delta as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(mask),
            "::",
            stringify!(delta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).handle as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(mask),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mask>())).d__piston_mask as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(mask),
            "::",
            stringify!(d__piston_mask)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask5setupEi"]
    pub fn mask_setup(this: *mut mask, n: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask5setupEif"]
    pub fn mask_setup1(this: *mut mask, n: ::std::os::raw::c_int, L: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask5setupEifiii"]
    pub fn mask_setup2(
        this: *mut mask,
        n: ::std::os::raw::c_int,
        L: f32,
        i_s: ::std::os::raw::c_int,
        j_s: ::std::os::raw::c_int,
        n_out: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask5setupEfffffffi"]
    pub fn mask_setup3(
        this: *mut mask,
        n: f32,
        L: f32,
        i_0: f32,
        j_0: f32,
        theta: f32,
        i_s: f32,
        j_s: f32,
        n_out: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask14setup_circularEi"]
    pub fn mask_setup_circular(this: *mut mask, n: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask14setup_circularEif"]
    pub fn mask_setup_circular1(this: *mut mask, n: ::std::os::raw::c_int, D: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask14setup_circularEiff"]
    pub fn mask_setup_circular2(this: *mut mask, n: ::std::os::raw::c_int, D: f32, scale: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask9setup_GMTEif"]
    pub fn mask_setup_GMT(this: *mut mask, n: ::std::os::raw::c_int, S: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask10set_filterEv"]
    pub fn mask_set_filter(this: *mut mask);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask16set_filter_quietEv"]
    pub fn mask_set_filter_quiet(this: *mut mask);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask9set_indexEv"]
    pub fn mask_set_index(this: *mut mask);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask14set_gmt_pistonEPfS0_"]
    pub fn mask_set_gmt_piston(this: *mut mask, phase: *mut f32, d__p: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask5alterEPf"]
    pub fn mask_alter(this: *mut mask, filter: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask3addEPS_"]
    pub fn mask_add(this: *mut mask, other: *mut mask);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask3addEPci"]
    pub fn mask_add1(
        this: *mut mask,
        other: *mut ::std::os::raw::c_char,
        other_nel: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask3addEPS_i"]
    pub fn mask_add2(this: *mut mask, other: *mut mask, offset: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask3addEPcii"]
    pub fn mask_add3(
        this: *mut mask,
        other: *mut ::std::os::raw::c_char,
        other_nel: ::std::os::raw::c_int,
        offset: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask5resetEv"]
    pub fn mask_reset(this: *mut mask);
}
extern "C" {
    #[link_name = "\u{1}_ZN4mask7cleanupEv"]
    pub fn mask_cleanup(this: *mut mask);
}
impl mask {
    #[inline]
    pub unsafe fn setup(&mut self, n: ::std::os::raw::c_int) {
        mask_setup(self, n)
    }
    #[inline]
    pub unsafe fn setup1(&mut self, n: ::std::os::raw::c_int, L: f32) {
        mask_setup1(self, n, L)
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        n: ::std::os::raw::c_int,
        L: f32,
        i_s: ::std::os::raw::c_int,
        j_s: ::std::os::raw::c_int,
        n_out: ::std::os::raw::c_int,
    ) {
        mask_setup2(self, n, L, i_s, j_s, n_out)
    }
    #[inline]
    pub unsafe fn setup3(
        &mut self,
        n: f32,
        L: f32,
        i_0: f32,
        j_0: f32,
        theta: f32,
        i_s: f32,
        j_s: f32,
        n_out: ::std::os::raw::c_int,
    ) {
        mask_setup3(self, n, L, i_0, j_0, theta, i_s, j_s, n_out)
    }
    #[inline]
    pub unsafe fn setup_circular(&mut self, n: ::std::os::raw::c_int) {
        mask_setup_circular(self, n)
    }
    #[inline]
    pub unsafe fn setup_circular1(&mut self, n: ::std::os::raw::c_int, D: f32) {
        mask_setup_circular1(self, n, D)
    }
    #[inline]
    pub unsafe fn setup_circular2(&mut self, n: ::std::os::raw::c_int, D: f32, scale: f32) {
        mask_setup_circular2(self, n, D, scale)
    }
    #[inline]
    pub unsafe fn setup_GMT(&mut self, n: ::std::os::raw::c_int, S: f32) {
        mask_setup_GMT(self, n, S)
    }
    #[inline]
    pub unsafe fn set_filter(&mut self) {
        mask_set_filter(self)
    }
    #[inline]
    pub unsafe fn set_filter_quiet(&mut self) {
        mask_set_filter_quiet(self)
    }
    #[inline]
    pub unsafe fn set_index(&mut self) {
        mask_set_index(self)
    }
    #[inline]
    pub unsafe fn set_gmt_piston(&mut self, phase: *mut f32, d__p: *mut f32) {
        mask_set_gmt_piston(self, phase, d__p)
    }
    #[inline]
    pub unsafe fn alter(&mut self, filter: *mut f32) {
        mask_alter(self, filter)
    }
    #[inline]
    pub unsafe fn add(&mut self, other: *mut mask) {
        mask_add(self, other)
    }
    #[inline]
    pub unsafe fn add1(
        &mut self,
        other: *mut ::std::os::raw::c_char,
        other_nel: ::std::os::raw::c_int,
    ) {
        mask_add1(self, other, other_nel)
    }
    #[inline]
    pub unsafe fn add2(&mut self, other: *mut mask, offset: ::std::os::raw::c_int) {
        mask_add2(self, other, offset)
    }
    #[inline]
    pub unsafe fn add3(
        &mut self,
        other: *mut ::std::os::raw::c_char,
        other_nel: ::std::os::raw::c_int,
        offset: ::std::os::raw::c_int,
    ) {
        mask_add3(self, other, other_nel, offset)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        mask_reset(self)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        mask_cleanup(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stats {
    pub handle: cublasHandle_t,
    pub status: cublasStatus_t,
}
#[test]
fn bindgen_test_layout_stats() {
    assert_eq!(
        ::std::mem::size_of::<stats>(),
        16usize,
        concat!("Size of: ", stringify!(stats))
    );
    assert_eq!(
        ::std::mem::align_of::<stats>(),
        8usize,
        concat!("Alignment of ", stringify!(stats))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stats>())).handle as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stats),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stats>())).status as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stats),
            "::",
            stringify!(status)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats5setupEv"]
    pub fn stats_setup(this: *mut stats);
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats7cleanupEv"]
    pub fn stats_cleanup(this: *mut stats);
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats4meanEPKfi"]
    pub fn stats_mean(this: *mut stats, data: *const f32, n_data: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats4meanEPKfP4maski"]
    pub fn stats_mean1(
        this: *mut stats,
        data: *const f32,
        M: *mut mask,
        n_data: ::std::os::raw::c_int,
    ) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats3varEPKfi"]
    pub fn stats_var(this: *mut stats, data: *const f32, n_data: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats3stdEPKfi"]
    pub fn stats_std(this: *mut stats, data: *const f32, n_data: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats8diff_varEPKfS1_i"]
    pub fn stats_diff_var(
        this: *mut stats,
        data_1: *const f32,
        data_2: *const f32,
        n_data: ::std::os::raw::c_int,
    ) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats8diff_stdEPKfS1_i"]
    pub fn stats_diff_std(
        this: *mut stats,
        data_1: *const f32,
        data_2: *const f32,
        n_data: ::std::os::raw::c_int,
    ) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats3varEPKfP4maski"]
    pub fn stats_var1(
        this: *mut stats,
        data1: *const f32,
        M: *mut mask,
        n_data: ::std::os::raw::c_int,
    ) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats3stdEPKfP4maski"]
    pub fn stats_std1(
        this: *mut stats,
        data1: *const f32,
        M: *mut mask,
        n_data: ::std::os::raw::c_int,
    ) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats8diff_varEPKfS1_P4maski"]
    pub fn stats_diff_var1(
        this: *mut stats,
        data1: *const f32,
        data2: *const f32,
        M: *mut mask,
        n_data: ::std::os::raw::c_int,
    ) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN5stats8diff_stdEPKfS1_P4maski"]
    pub fn stats_diff_std1(
        this: *mut stats,
        data1: *const f32,
        data2: *const f32,
        M: *mut mask,
        n_data: ::std::os::raw::c_int,
    ) -> f32;
}
impl stats {
    #[inline]
    pub unsafe fn setup(&mut self) {
        stats_setup(self)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        stats_cleanup(self)
    }
    #[inline]
    pub unsafe fn mean(&mut self, data: *const f32, n_data: ::std::os::raw::c_int) -> f32 {
        stats_mean(self, data, n_data)
    }
    #[inline]
    pub unsafe fn mean1(
        &mut self,
        data: *const f32,
        M: *mut mask,
        n_data: ::std::os::raw::c_int,
    ) -> f32 {
        stats_mean1(self, data, M, n_data)
    }
    #[inline]
    pub unsafe fn var(&mut self, data: *const f32, n_data: ::std::os::raw::c_int) -> f32 {
        stats_var(self, data, n_data)
    }
    #[inline]
    pub unsafe fn std(&mut self, data: *const f32, n_data: ::std::os::raw::c_int) -> f32 {
        stats_std(self, data, n_data)
    }
    #[inline]
    pub unsafe fn diff_var(
        &mut self,
        data_1: *const f32,
        data_2: *const f32,
        n_data: ::std::os::raw::c_int,
    ) -> f32 {
        stats_diff_var(self, data_1, data_2, n_data)
    }
    #[inline]
    pub unsafe fn diff_std(
        &mut self,
        data_1: *const f32,
        data_2: *const f32,
        n_data: ::std::os::raw::c_int,
    ) -> f32 {
        stats_diff_std(self, data_1, data_2, n_data)
    }
    #[inline]
    pub unsafe fn var1(
        &mut self,
        data1: *const f32,
        M: *mut mask,
        n_data: ::std::os::raw::c_int,
    ) -> f32 {
        stats_var1(self, data1, M, n_data)
    }
    #[inline]
    pub unsafe fn std1(
        &mut self,
        data1: *const f32,
        M: *mut mask,
        n_data: ::std::os::raw::c_int,
    ) -> f32 {
        stats_std1(self, data1, M, n_data)
    }
    #[inline]
    pub unsafe fn diff_var1(
        &mut self,
        data1: *const f32,
        data2: *const f32,
        M: *mut mask,
        n_data: ::std::os::raw::c_int,
    ) -> f32 {
        stats_diff_var1(self, data1, data2, M, n_data)
    }
    #[inline]
    pub unsafe fn diff_std1(
        &mut self,
        data1: *const f32,
        data2: *const f32,
        M: *mut mask,
        n_data: ::std::os::raw::c_int,
    ) -> f32 {
        stats_diff_std1(self, data1, data2, M, n_data)
    }
}
extern "C" {
    #[link_name = "\u{1}_Z8dev2hostPfS_i"]
    pub fn dev2host(host_data: *mut f32, dev_data: *mut f32, N: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_Z12dev2host_intPiS_i"]
    pub fn dev2host_int(
        host_data: *mut ::std::os::raw::c_int,
        dev_data: *mut ::std::os::raw::c_int,
        N: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_Z8host2devPfS_i"]
    pub fn host2dev(dev_data: *mut f32, host_data: *mut f32, N: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_Z13host2dev_charPcS_i"]
    pub fn host2dev_char(
        dev_data: *mut ::std::os::raw::c_char,
        host_data: *mut ::std::os::raw::c_char,
        N: ::std::os::raw::c_int,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_float {
    pub dev_data: *mut f32,
    pub host_data: *mut f32,
    pub d_tau: *mut f32,
    pub N: ::std::os::raw::c_int,
    pub nb: ::std::os::raw::c_int,
    pub S: stats,
    pub stat: cublasStatus_t,
    pub handle: cublasHandle_t,
    pub cusolverH: cusolverDnHandle_t,
}
#[test]
fn bindgen_test_layout_gpu_float() {
    assert_eq!(
        ::std::mem::size_of::<gpu_float>(),
        72usize,
        concat!("Size of: ", stringify!(gpu_float))
    );
    assert_eq!(
        ::std::mem::align_of::<gpu_float>(),
        8usize,
        concat!("Alignment of ", stringify!(gpu_float))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_float>())).dev_data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_float),
            "::",
            stringify!(dev_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_float>())).host_data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_float),
            "::",
            stringify!(host_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_float>())).d_tau as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_float),
            "::",
            stringify!(d_tau)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_float>())).N as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_float),
            "::",
            stringify!(N)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_float>())).nb as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_float),
            "::",
            stringify!(nb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_float>())).S as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_float),
            "::",
            stringify!(S)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_float>())).stat as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_float),
            "::",
            stringify!(stat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_float>())).handle as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_float),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_float>())).cusolverH as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_float),
            "::",
            stringify!(cusolverH)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float5setupEv"]
    pub fn gpu_float_setup(this: *mut gpu_float);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float5setupEi"]
    pub fn gpu_float_setup1(this: *mut gpu_float, N_T: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float10dev_mallocEv"]
    pub fn gpu_float_dev_malloc(this: *mut gpu_float);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float8free_devEv"]
    pub fn gpu_float_free_dev(this: *mut gpu_float);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float8dev2hostEv"]
    pub fn gpu_float_dev2host(this: *mut gpu_float);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float8host2devEv"]
    pub fn gpu_float_host2dev(this: *mut gpu_float);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float5resetEv"]
    pub fn gpu_float_reset(this: *mut gpu_float);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float2qrEi"]
    pub fn gpu_float_qr(this: *mut gpu_float, m: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float7dev2devEPS_"]
    pub fn gpu_float_dev2dev(this: *mut gpu_float, other: *mut gpu_float);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float4axpyEPKS_f"]
    pub fn gpu_float_axpy(this: *mut gpu_float, x: *const gpu_float, alpha: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float5scaleEf"]
    pub fn gpu_float_scale(this: *mut gpu_float, alpha: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float2mvEPS_PKS_"]
    pub fn gpu_float_mv(this: *mut gpu_float, y: *mut gpu_float, x: *const gpu_float);
}
extern "C" {
    #[link_name = "\u{1}_ZN9gpu_float8qr_solveEPS_S0_"]
    pub fn gpu_float_qr_solve(this: *mut gpu_float, x: *mut gpu_float, b: *mut gpu_float);
}
impl gpu_float {
    #[inline]
    pub unsafe fn setup(&mut self) {
        gpu_float_setup(self)
    }
    #[inline]
    pub unsafe fn setup1(&mut self, N_T: ::std::os::raw::c_int) {
        gpu_float_setup1(self, N_T)
    }
    #[inline]
    pub unsafe fn dev_malloc(&mut self) {
        gpu_float_dev_malloc(self)
    }
    #[inline]
    pub unsafe fn free_dev(&mut self) {
        gpu_float_free_dev(self)
    }
    #[inline]
    pub unsafe fn dev2host(&mut self) {
        gpu_float_dev2host(self)
    }
    #[inline]
    pub unsafe fn host2dev(&mut self) {
        gpu_float_host2dev(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        gpu_float_reset(self)
    }
    #[inline]
    pub unsafe fn qr(&mut self, m: ::std::os::raw::c_int) {
        gpu_float_qr(self, m)
    }
    #[inline]
    pub unsafe fn dev2dev(&mut self, other: *mut gpu_float) {
        gpu_float_dev2dev(self, other)
    }
    #[inline]
    pub unsafe fn axpy(&mut self, x: *const gpu_float, alpha: f32) {
        gpu_float_axpy(self, x, alpha)
    }
    #[inline]
    pub unsafe fn scale(&mut self, alpha: f32) {
        gpu_float_scale(self, alpha)
    }
    #[inline]
    pub unsafe fn mv(&mut self, y: *mut gpu_float, x: *const gpu_float) {
        gpu_float_mv(self, y, x)
    }
    #[inline]
    pub unsafe fn qr_solve(&mut self, x: *mut gpu_float, b: *mut gpu_float) {
        gpu_float_qr_solve(self, x, b)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_double {
    pub dev_data: *mut f64,
    pub host_data: *mut f64,
    pub N: ::std::os::raw::c_int,
    pub nb: ::std::os::raw::c_int,
    pub S: stats,
    pub stat: cublasStatus_t,
    pub handle: cublasHandle_t,
    pub cusolverH: cusolverDnHandle_t,
}
#[test]
fn bindgen_test_layout_gpu_double() {
    assert_eq!(
        ::std::mem::size_of::<gpu_double>(),
        64usize,
        concat!("Size of: ", stringify!(gpu_double))
    );
    assert_eq!(
        ::std::mem::align_of::<gpu_double>(),
        8usize,
        concat!("Alignment of ", stringify!(gpu_double))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_double>())).dev_data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_double),
            "::",
            stringify!(dev_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_double>())).host_data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_double),
            "::",
            stringify!(host_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_double>())).N as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_double),
            "::",
            stringify!(N)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_double>())).nb as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_double),
            "::",
            stringify!(nb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_double>())).S as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_double),
            "::",
            stringify!(S)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_double>())).stat as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_double),
            "::",
            stringify!(stat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_double>())).handle as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_double),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpu_double>())).cusolverH as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_double),
            "::",
            stringify!(cusolverH)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10gpu_double5setupEv"]
    pub fn gpu_double_setup(this: *mut gpu_double);
}
extern "C" {
    #[link_name = "\u{1}_ZN10gpu_double5setupEi"]
    pub fn gpu_double_setup1(this: *mut gpu_double, N_T: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN10gpu_double10dev_mallocEv"]
    pub fn gpu_double_dev_malloc(this: *mut gpu_double);
}
extern "C" {
    #[link_name = "\u{1}_ZN10gpu_double8free_devEv"]
    pub fn gpu_double_free_dev(this: *mut gpu_double);
}
extern "C" {
    #[link_name = "\u{1}_ZN10gpu_double8dev2hostEv"]
    pub fn gpu_double_dev2host(this: *mut gpu_double);
}
extern "C" {
    #[link_name = "\u{1}_ZN10gpu_double8host2devEv"]
    pub fn gpu_double_host2dev(this: *mut gpu_double);
}
extern "C" {
    #[link_name = "\u{1}_ZN10gpu_double5resetEv"]
    pub fn gpu_double_reset(this: *mut gpu_double);
}
extern "C" {
    #[link_name = "\u{1}_ZN10gpu_double2qrEi"]
    pub fn gpu_double_qr(this: *mut gpu_double, m: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN10gpu_double2mvEP9gpu_floatPKS0_"]
    pub fn gpu_double_mv(this: *mut gpu_double, y: *mut gpu_float, x: *const gpu_float);
}
impl gpu_double {
    #[inline]
    pub unsafe fn setup(&mut self) {
        gpu_double_setup(self)
    }
    #[inline]
    pub unsafe fn setup1(&mut self, N_T: ::std::os::raw::c_int) {
        gpu_double_setup1(self, N_T)
    }
    #[inline]
    pub unsafe fn dev_malloc(&mut self) {
        gpu_double_dev_malloc(self)
    }
    #[inline]
    pub unsafe fn free_dev(&mut self) {
        gpu_double_free_dev(self)
    }
    #[inline]
    pub unsafe fn dev2host(&mut self) {
        gpu_double_dev2host(self)
    }
    #[inline]
    pub unsafe fn host2dev(&mut self) {
        gpu_double_host2dev(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        gpu_double_reset(self)
    }
    #[inline]
    pub unsafe fn qr(&mut self, m: ::std::os::raw::c_int) {
        gpu_double_qr(self, m)
    }
    #[inline]
    pub unsafe fn mv(&mut self, y: *mut gpu_float, x: *const gpu_float) {
        gpu_double_mv(self, y, x)
    }
}
extern "C" {
    #[link_name = "\u{1}_Z5geqrfPfS_ii"]
    pub fn geqrf(d_tau: *mut f32, a: *mut f32, m: ::std::os::raw::c_int, n: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_Z5ormqrPfiS_S_i"]
    pub fn ormqr(
        b: *mut f32,
        m: ::std::os::raw::c_int,
        q: *mut f32,
        tau: *mut f32,
        n: ::std::os::raw::c_int,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ray {
    pub coordinates: vector,
    pub directions: vector,
    pub surface_normal: vector,
    pub optical_path_length: rtd,
    pub optical_path_difference: rtd,
    pub v: ::std::os::raw::c_char,
    pub n_iteration: ::std::os::raw::c_int,
    pub throughput: rtd,
}
#[test]
fn bindgen_test_layout_ray() {
    assert_eq!(
        ::std::mem::size_of::<ray>(),
        104usize,
        concat!("Size of: ", stringify!(ray))
    );
    assert_eq!(
        ::std::mem::align_of::<ray>(),
        8usize,
        concat!("Alignment of ", stringify!(ray))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ray>())).coordinates as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ray),
            "::",
            stringify!(coordinates)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ray>())).directions as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ray),
            "::",
            stringify!(directions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ray>())).surface_normal as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ray),
            "::",
            stringify!(surface_normal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ray>())).optical_path_length as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(ray),
            "::",
            stringify!(optical_path_length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ray>())).optical_path_difference as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(ray),
            "::",
            stringify!(optical_path_difference)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ray>())).v as *const _ as usize },
        88usize,
        concat!("Offset of field: ", stringify!(ray), "::", stringify!(v))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ray>())).n_iteration as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(ray),
            "::",
            stringify!(n_iteration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ray>())).throughput as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(ray),
            "::",
            stringify!(throughput)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bundle {
    pub N_RAY: ::std::os::raw::c_int,
    pub d__ray: *mut ray,
    pub N_BUNDLE: ::std::os::raw::c_int,
    pub N_RAY_TOTAL: ::std::os::raw::c_int,
    pub d__origin: *mut vector,
    pub rot_angle: f64,
    pub d__chief_ray: *mut ray,
    pub d__chief_origin: *mut vector,
    pub V: mask,
    pub geom: [::std::os::raw::c_char; 8usize],
    pub N_RADIUS: ::std::os::raw::c_int,
    pub N_THETA: ::std::os::raw::c_int,
    pub N_L: ::std::os::raw::c_int,
    pub L: rtd,
    pub d__sphere_distance: *mut rtd,
    pub d__sphere_radius: *mut rtd,
    pub d__sphere_origin: *mut vector,
    pub d__piston_mask: *mut ::std::os::raw::c_int,
    pub refractive_index: rtd,
    pub d__Vx: *mut f64,
    pub d__Vy: *mut f64,
}
#[test]
fn bindgen_test_layout_bundle() {
    assert_eq!(
        ::std::mem::size_of::<bundle>(),
        224usize,
        concat!("Size of: ", stringify!(bundle))
    );
    assert_eq!(
        ::std::mem::align_of::<bundle>(),
        8usize,
        concat!("Alignment of ", stringify!(bundle))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).N_RAY as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(N_RAY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).d__ray as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(d__ray)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).N_BUNDLE as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(N_BUNDLE)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).N_RAY_TOTAL as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(N_RAY_TOTAL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).d__origin as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(d__origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).rot_angle as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(rot_angle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).d__chief_ray as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(d__chief_ray)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).d__chief_origin as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(d__chief_origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).V as *const _ as usize },
        56usize,
        concat!("Offset of field: ", stringify!(bundle), "::", stringify!(V))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).geom as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(geom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).N_RADIUS as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(N_RADIUS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).N_THETA as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(N_THETA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).N_L as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(N_L)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).L as *const _ as usize },
        160usize,
        concat!("Offset of field: ", stringify!(bundle), "::", stringify!(L))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).d__sphere_distance as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(d__sphere_distance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).d__sphere_radius as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(d__sphere_radius)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).d__sphere_origin as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(d__sphere_origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).d__piston_mask as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(d__piston_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).refractive_index as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(refractive_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).d__Vx as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(d__Vx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<bundle>())).d__Vy as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(bundle),
            "::",
            stringify!(d__Vy)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle5setupEdii6vectori"]
    pub fn bundle_setup(
        this: *mut bundle,
        RADIUS: rtd,
        N_RADIUS: ::std::os::raw::c_int,
        N_THETA: ::std::os::raw::c_int,
        origin: vector,
        N_SRC: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle5setupEdi6vectori"]
    pub fn bundle_setup1(
        this: *mut bundle,
        L: rtd,
        N_L: ::std::os::raw::c_int,
        origin: vector,
        N_SRC: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle5setupEdi6vectorS0_i"]
    pub fn bundle_setup2(
        this: *mut bundle,
        L: rtd,
        N_L: ::std::os::raw::c_int,
        origin: vector,
        chief_origin: vector,
        N_SRC: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle10setup_freeEiPdS0_6vector"]
    pub fn bundle_setup_free(
        this: *mut bundle,
        _N_RAY_: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        origin: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle10setup_freeEddiPdS0_6vector"]
    pub fn bundle_setup_free1(
        this: *mut bundle,
        zenith: f64,
        azimuth: f64,
        _N_RAY_: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        origin: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle7cleanupEv"]
    pub fn bundle_cleanup(this: *mut bundle);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle10to_z_planeEd"]
    pub fn bundle_to_z_plane(this: *mut bundle, z_in: rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle14to_focal_planeEdd"]
    pub fn bundle_to_focal_plane(this: *mut bundle, z_chief_on_axis: rtd, rho_focal_plane: rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle9to_sphereE6vector"]
    pub fn bundle_to_sphere(this: *mut bundle, sphere_origin: vector);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle9to_sphereEdd"]
    pub fn bundle_to_sphere1(this: *mut bundle, z_chief_on_axis: rtd, rho_focal_plane: rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle15get_coordinatesEPd"]
    pub fn bundle_get_coordinates(this: *mut bundle, d__coord: *mut f64);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle21get_chief_coordinatesEPd"]
    pub fn bundle_get_chief_coordinates(this: *mut bundle, d__coord: *mut f64);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle18get_sphere_originsEPd"]
    pub fn bundle_get_sphere_origins(this: *mut bundle, d__coord: *mut f64);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle14get_directionsEPd"]
    pub fn bundle_get_directions(this: *mut bundle, d__dir: *mut f64);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle20get_chief_directionsEPd"]
    pub fn bundle_get_chief_directions(this: *mut bundle, d__dir: *mut f64);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle29get_chief_optical_path_lengthEPd"]
    pub fn bundle_get_chief_optical_path_length(this: *mut bundle, d__opl: *mut f64);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle23get_optical_path_lengthEPd"]
    pub fn bundle_get_optical_path_length(this: *mut bundle, d__opl: *mut f64);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle27get_optical_path_differenceEPd"]
    pub fn bundle_get_optical_path_difference(this: *mut bundle, d__opd: *mut f64);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle27get_optical_path_differenceEPdfifi"]
    pub fn bundle_get_optical_path_difference1(
        this: *mut bundle,
        d__opd: *mut f64,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle14get_vignettingEPd"]
    pub fn bundle_get_vignetting(this: *mut bundle, d__v: *mut f64);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle15get_n_iterationEPi"]
    pub fn bundle_get_n_iteration(this: *mut bundle, n_iteration: *mut ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle16gmt_truss_onaxisEv"]
    pub fn bundle_gmt_truss_onaxis(this: *mut bundle);
}
extern "C" {
    #[link_name = "\u{1}_ZN6bundle13gmt_m2_baffleEv"]
    pub fn bundle_gmt_m2_baffle(this: *mut bundle);
}
impl bundle {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        RADIUS: rtd,
        N_RADIUS: ::std::os::raw::c_int,
        N_THETA: ::std::os::raw::c_int,
        origin: vector,
        N_SRC: ::std::os::raw::c_int,
    ) {
        bundle_setup(self, RADIUS, N_RADIUS, N_THETA, origin, N_SRC)
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        L: rtd,
        N_L: ::std::os::raw::c_int,
        origin: vector,
        N_SRC: ::std::os::raw::c_int,
    ) {
        bundle_setup1(self, L, N_L, origin, N_SRC)
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        L: rtd,
        N_L: ::std::os::raw::c_int,
        origin: vector,
        chief_origin: vector,
        N_SRC: ::std::os::raw::c_int,
    ) {
        bundle_setup2(self, L, N_L, origin, chief_origin, N_SRC)
    }
    #[inline]
    pub unsafe fn setup_free(
        &mut self,
        _N_RAY_: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        origin: vector,
    ) {
        bundle_setup_free(self, _N_RAY_, x, y, origin)
    }
    #[inline]
    pub unsafe fn setup_free1(
        &mut self,
        zenith: f64,
        azimuth: f64,
        _N_RAY_: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        origin: vector,
    ) {
        bundle_setup_free1(self, zenith, azimuth, _N_RAY_, x, y, origin)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        bundle_cleanup(self)
    }
    #[inline]
    pub unsafe fn to_z_plane(&mut self, z_in: rtd) {
        bundle_to_z_plane(self, z_in)
    }
    #[inline]
    pub unsafe fn to_focal_plane(&mut self, z_chief_on_axis: rtd, rho_focal_plane: rtd) {
        bundle_to_focal_plane(self, z_chief_on_axis, rho_focal_plane)
    }
    #[inline]
    pub unsafe fn to_sphere(&mut self, sphere_origin: vector) {
        bundle_to_sphere(self, sphere_origin)
    }
    #[inline]
    pub unsafe fn to_sphere1(&mut self, z_chief_on_axis: rtd, rho_focal_plane: rtd) {
        bundle_to_sphere1(self, z_chief_on_axis, rho_focal_plane)
    }
    #[inline]
    pub unsafe fn get_coordinates(&mut self, d__coord: *mut f64) {
        bundle_get_coordinates(self, d__coord)
    }
    #[inline]
    pub unsafe fn get_chief_coordinates(&mut self, d__coord: *mut f64) {
        bundle_get_chief_coordinates(self, d__coord)
    }
    #[inline]
    pub unsafe fn get_sphere_origins(&mut self, d__coord: *mut f64) {
        bundle_get_sphere_origins(self, d__coord)
    }
    #[inline]
    pub unsafe fn get_directions(&mut self, d__dir: *mut f64) {
        bundle_get_directions(self, d__dir)
    }
    #[inline]
    pub unsafe fn get_chief_directions(&mut self, d__dir: *mut f64) {
        bundle_get_chief_directions(self, d__dir)
    }
    #[inline]
    pub unsafe fn get_chief_optical_path_length(&mut self, d__opl: *mut f64) {
        bundle_get_chief_optical_path_length(self, d__opl)
    }
    #[inline]
    pub unsafe fn get_optical_path_length(&mut self, d__opl: *mut f64) {
        bundle_get_optical_path_length(self, d__opl)
    }
    #[inline]
    pub unsafe fn get_optical_path_difference(&mut self, d__opd: *mut f64) {
        bundle_get_optical_path_difference(self, d__opd)
    }
    #[inline]
    pub unsafe fn get_optical_path_difference1(
        &mut self,
        d__opd: *mut f64,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
    ) {
        bundle_get_optical_path_difference1(self, d__opd, delta_x, N_x, delta_y, N_y)
    }
    #[inline]
    pub unsafe fn get_vignetting(&mut self, d__v: *mut f64) {
        bundle_get_vignetting(self, d__v)
    }
    #[inline]
    pub unsafe fn get_n_iteration(&mut self, n_iteration: *mut ::std::os::raw::c_int) {
        bundle_get_n_iteration(self, n_iteration)
    }
    #[inline]
    pub unsafe fn gmt_truss_onaxis(&mut self) {
        bundle_gmt_truss_onaxis(self)
    }
    #[inline]
    pub unsafe fn gmt_m2_baffle(&mut self) {
        bundle_gmt_m2_baffle(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct complex_amplitude {
    pub N_PX: ::std::os::raw::c_int,
    pub N: ::std::os::raw::c_int,
    pub amplitude: *mut f32,
    pub phase: *mut f32,
    pub M: *mut mask,
    pub handle: cublasHandle_t,
    pub buffer: *mut f32,
}
#[test]
fn bindgen_test_layout_complex_amplitude() {
    assert_eq!(
        ::std::mem::size_of::<complex_amplitude>(),
        48usize,
        concat!("Size of: ", stringify!(complex_amplitude))
    );
    assert_eq!(
        ::std::mem::align_of::<complex_amplitude>(),
        8usize,
        concat!("Alignment of ", stringify!(complex_amplitude))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<complex_amplitude>())).N_PX as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(complex_amplitude),
            "::",
            stringify!(N_PX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<complex_amplitude>())).N as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(complex_amplitude),
            "::",
            stringify!(N)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<complex_amplitude>())).amplitude as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(complex_amplitude),
            "::",
            stringify!(amplitude)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<complex_amplitude>())).phase as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(complex_amplitude),
            "::",
            stringify!(phase)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<complex_amplitude>())).M as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(complex_amplitude),
            "::",
            stringify!(M)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<complex_amplitude>())).handle as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(complex_amplitude),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<complex_amplitude>())).buffer as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(complex_amplitude),
            "::",
            stringify!(buffer)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude5setupEi"]
    pub fn complex_amplitude_setup(this: *mut complex_amplitude, n_pixel: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude5setupEii"]
    pub fn complex_amplitude_setup1(
        this: *mut complex_amplitude,
        n_pixel: ::std::os::raw::c_int,
        n_src: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude7cleanupEv"]
    pub fn complex_amplitude_cleanup(this: *mut complex_amplitude);
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude5resetEv"]
    pub fn complex_amplitude_reset(this: *mut complex_amplitude);
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude5resetEPS_"]
    pub fn complex_amplitude_reset1(
        this: *mut complex_amplitude,
        wavefront: *mut complex_amplitude,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude15reset_amplitudeEv"]
    pub fn complex_amplitude_reset_amplitude(this: *mut complex_amplitude);
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude11reset_phaseEv"]
    pub fn complex_amplitude_reset_phase(this: *mut complex_amplitude);
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude11reset_phaseEPS_"]
    pub fn complex_amplitude_reset_phase1(
        this: *mut complex_amplitude,
        wavefront_prime: *mut complex_amplitude,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude9add_phaseEfPf"]
    pub fn complex_amplitude_add_phase(
        this: *mut complex_amplitude,
        alpha: f32,
        phase_prime: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude14add_same_phaseEfPf"]
    pub fn complex_amplitude_add_same_phase(
        this: *mut complex_amplitude,
        alpha: f32,
        phase_prime: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude6maskedEv"]
    pub fn complex_amplitude_masked(this: *mut complex_amplitude);
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude6maskedEP4mask"]
    pub fn complex_amplitude_masked1(this: *mut complex_amplitude, M_in: *mut mask);
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude3rmsEPf"]
    pub fn complex_amplitude_rms(this: *mut complex_amplitude, rms: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude17finite_differenceEPfS0_if"]
    pub fn complex_amplitude_finite_difference(
        this: *mut complex_amplitude,
        sx: *mut f32,
        sy: *mut f32,
        NL: ::std::os::raw::c_int,
        d: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude17finite_differenceEPfS0_ifP4mask"]
    pub fn complex_amplitude_finite_difference1(
        this: *mut complex_amplitude,
        sx: *mut f32,
        sy: *mut f32,
        NL: ::std::os::raw::c_int,
        d: f32,
        valid_lenslet: *mut mask,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude16gradient_averageEPfS0_if"]
    pub fn complex_amplitude_gradient_average(
        this: *mut complex_amplitude,
        sx: *mut f32,
        sy: *mut f32,
        NL: ::std::os::raw::c_int,
        d: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude16gradient_averageEPfS0_f"]
    pub fn complex_amplitude_gradient_average1(
        this: *mut complex_amplitude,
        sx: *mut f32,
        sy: *mut f32,
        d: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude25segments_gradient_averageEPfS0_fPi"]
    pub fn complex_amplitude_segments_gradient_average(
        this: *mut complex_amplitude,
        sx: *mut f32,
        sy: *mut f32,
        D: f32,
        segment_markers: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude29segments_gradient_averageFastEPfS0_fPi"]
    pub fn complex_amplitude_segments_gradient_averageFast(
        this: *mut complex_amplitude,
        sx: *mut f32,
        sy: *mut f32,
        D: f32,
        segment_markers: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude10show_phaseEPc"]
    pub fn complex_amplitude_show_phase(
        this: *mut complex_amplitude,
        filename: *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude10show_phaseEPci"]
    pub fn complex_amplitude_show_phase1(
        this: *mut complex_amplitude,
        filename: *mut ::std::os::raw::c_char,
        N_SRC: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude14show_amplitudeEPc"]
    pub fn complex_amplitude_show_amplitude(
        this: *mut complex_amplitude,
        filename: *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17complex_amplitude14show_amplitudeEPcii"]
    pub fn complex_amplitude_show_amplitude1(
        this: *mut complex_amplitude,
        filename: *mut ::std::os::raw::c_char,
        N: ::std::os::raw::c_int,
        M: ::std::os::raw::c_int,
    );
}
impl complex_amplitude {
    #[inline]
    pub unsafe fn setup(&mut self, n_pixel: ::std::os::raw::c_int) {
        complex_amplitude_setup(self, n_pixel)
    }
    #[inline]
    pub unsafe fn setup1(&mut self, n_pixel: ::std::os::raw::c_int, n_src: ::std::os::raw::c_int) {
        complex_amplitude_setup1(self, n_pixel, n_src)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        complex_amplitude_cleanup(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        complex_amplitude_reset(self)
    }
    #[inline]
    pub unsafe fn reset1(&mut self, wavefront: *mut complex_amplitude) {
        complex_amplitude_reset1(self, wavefront)
    }
    #[inline]
    pub unsafe fn reset_amplitude(&mut self) {
        complex_amplitude_reset_amplitude(self)
    }
    #[inline]
    pub unsafe fn reset_phase(&mut self) {
        complex_amplitude_reset_phase(self)
    }
    #[inline]
    pub unsafe fn reset_phase1(&mut self, wavefront_prime: *mut complex_amplitude) {
        complex_amplitude_reset_phase1(self, wavefront_prime)
    }
    #[inline]
    pub unsafe fn add_phase(&mut self, alpha: f32, phase_prime: *mut f32) {
        complex_amplitude_add_phase(self, alpha, phase_prime)
    }
    #[inline]
    pub unsafe fn add_same_phase(&mut self, alpha: f32, phase_prime: *mut f32) {
        complex_amplitude_add_same_phase(self, alpha, phase_prime)
    }
    #[inline]
    pub unsafe fn masked(&mut self) {
        complex_amplitude_masked(self)
    }
    #[inline]
    pub unsafe fn masked1(&mut self, M_in: *mut mask) {
        complex_amplitude_masked1(self, M_in)
    }
    #[inline]
    pub unsafe fn rms(&mut self, rms: *mut f32) {
        complex_amplitude_rms(self, rms)
    }
    #[inline]
    pub unsafe fn finite_difference(
        &mut self,
        sx: *mut f32,
        sy: *mut f32,
        NL: ::std::os::raw::c_int,
        d: f32,
    ) {
        complex_amplitude_finite_difference(self, sx, sy, NL, d)
    }
    #[inline]
    pub unsafe fn finite_difference1(
        &mut self,
        sx: *mut f32,
        sy: *mut f32,
        NL: ::std::os::raw::c_int,
        d: f32,
        valid_lenslet: *mut mask,
    ) {
        complex_amplitude_finite_difference1(self, sx, sy, NL, d, valid_lenslet)
    }
    #[inline]
    pub unsafe fn gradient_average(
        &mut self,
        sx: *mut f32,
        sy: *mut f32,
        NL: ::std::os::raw::c_int,
        d: f32,
    ) {
        complex_amplitude_gradient_average(self, sx, sy, NL, d)
    }
    #[inline]
    pub unsafe fn gradient_average1(&mut self, sx: *mut f32, sy: *mut f32, d: f32) {
        complex_amplitude_gradient_average1(self, sx, sy, d)
    }
    #[inline]
    pub unsafe fn segments_gradient_average(
        &mut self,
        sx: *mut f32,
        sy: *mut f32,
        D: f32,
        segment_markers: *mut ::std::os::raw::c_int,
    ) {
        complex_amplitude_segments_gradient_average(self, sx, sy, D, segment_markers)
    }
    #[inline]
    pub unsafe fn segments_gradient_averageFast(
        &mut self,
        sx: *mut f32,
        sy: *mut f32,
        D: f32,
        segment_markers: *mut ::std::os::raw::c_int,
    ) {
        complex_amplitude_segments_gradient_averageFast(self, sx, sy, D, segment_markers)
    }
    #[inline]
    pub unsafe fn show_phase(&mut self, filename: *mut ::std::os::raw::c_char) {
        complex_amplitude_show_phase(self, filename)
    }
    #[inline]
    pub unsafe fn show_phase1(
        &mut self,
        filename: *mut ::std::os::raw::c_char,
        N_SRC: ::std::os::raw::c_int,
    ) {
        complex_amplitude_show_phase1(self, filename, N_SRC)
    }
    #[inline]
    pub unsafe fn show_amplitude(&mut self, filename: *mut ::std::os::raw::c_char) {
        complex_amplitude_show_amplitude(self, filename)
    }
    #[inline]
    pub unsafe fn show_amplitude1(
        &mut self,
        filename: *mut ::std::os::raw::c_char,
        N: ::std::os::raw::c_int,
        M: ::std::os::raw::c_int,
    ) {
        complex_amplitude_show_amplitude1(self, filename, N, M)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct source {
    pub N_SRC: ::std::os::raw::c_int,
    pub zenith: f32,
    pub azimuth: f32,
    pub height: f32,
    pub theta_x: f32,
    pub theta_y: f32,
    pub _zenith_64_: rtd,
    pub _azimuth_64_: rtd,
    pub _height_64_: rtd,
    pub _theta_x_64_: rtd,
    pub _theta_y_64_: rtd,
    pub photometric_band: *const ::std::os::raw::c_char,
    pub magnitude: f32,
    pub N_PHOTON: f32,
    pub fwhm: f32,
    pub wavefront: complex_amplitude,
    pub dev_ptr: *mut source,
    pub tag: [::std::os::raw::c_char; 8usize],
    pub rays_exist: ::std::os::raw::c_char,
    pub rays: bundle,
}
#[test]
fn bindgen_test_layout_source() {
    assert_eq!(
        ::std::mem::size_of::<source>(),
        384usize,
        concat!("Size of: ", stringify!(source))
    );
    assert_eq!(
        ::std::mem::align_of::<source>(),
        8usize,
        concat!("Alignment of ", stringify!(source))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).N_SRC as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(N_SRC)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).zenith as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(zenith)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).azimuth as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(azimuth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).height as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).theta_x as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(theta_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).theta_y as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(theta_y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>()))._zenith_64_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(_zenith_64_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>()))._azimuth_64_ as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(_azimuth_64_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>()))._height_64_ as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(_height_64_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>()))._theta_x_64_ as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(_theta_x_64_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>()))._theta_y_64_ as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(_theta_y_64_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).photometric_band as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(photometric_band)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).magnitude as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(magnitude)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).N_PHOTON as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(N_PHOTON)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).fwhm as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(fwhm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).wavefront as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(wavefront)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).dev_ptr as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(dev_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).tag as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).rays_exist as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(rays_exist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<source>())).rays as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(source),
            "::",
            stringify!(rays)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source5setupEPKcfff"]
    pub fn source_setup(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        zenith: f32,
        azimuth: f32,
        height: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source5setupEPKcfffi"]
    pub fn source_setup1(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        zenith: f32,
        azimuth: f32,
        height: f32,
        resolution: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source5setupEPKcfffS1_"]
    pub fn source_setup2(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        zenith: f32,
        azimuth: f32,
        height: f32,
        tag_in: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source5setupEPKcfffiS1_"]
    pub fn source_setup3(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        zenith: f32,
        azimuth: f32,
        height: f32,
        resolution: ::std::os::raw::c_int,
        tag_in: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source5setupEPKcPfS2_fi"]
    pub fn source_setup4(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        _zenith: *mut f32,
        _azimuth: *mut f32,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source5setupEPKcPfS2_fii"]
    pub fn source_setup5(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        _zenith: *mut f32,
        _azimuth: *mut f32,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        resolution: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source5setupEPKcPfS2_fidi6vector"]
    pub fn source_setup6(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        _zenith: *mut f32,
        _azimuth: *mut f32,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        _L_: rtd,
        _N_L_: ::std::os::raw::c_int,
        origin: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source5setupEPKcPfS2_S2_fidi6vector"]
    pub fn source_setup7(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        magnitude: *mut f32,
        _zenith: *mut f32,
        _azimuth: *mut f32,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        _L_: rtd,
        _N_L_: ::std::os::raw::c_int,
        origin: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source5setupEPKcPfPdS3_fidi6vector"]
    pub fn source_setup8(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        magnitude: *mut f32,
        _zenith: *mut rtd,
        _azimuth: *mut rtd,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        _L_: rtd,
        _N_L_: ::std::os::raw::c_int,
        origin: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source11setup_chiefEPKcPfPdS3_fidi6vectorS4_"]
    pub fn source_setup_chief(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        magnitude: *mut f32,
        _zenith: *mut rtd,
        _azimuth: *mut rtd,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        _L_: rtd,
        _N_L_: ::std::os::raw::c_int,
        origin: vector,
        chief_origin: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source5setupEPKcPfPdS3_fiiS3_S3_6vector"]
    pub fn source_setup9(
        this: *mut source,
        _photometric_band: *const ::std::os::raw::c_char,
        _magnitude: *mut f32,
        _zenith: *mut rtd,
        _azimuth: *mut rtd,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        _N_RAY_: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        origin: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source7cleanupEv"]
    pub fn source_cleanup(this: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN6source10reset_raysEv"]
    pub fn source_reset_rays(this: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN6source10reset_raysEi"]
    pub fn source_reset_rays1(this: *mut source, RESET_RAYS_MASK: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN6source9opd2phaseEv"]
    pub fn source_opd2phase(this: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN6source9opd2phaseEi"]
    pub fn source_opd2phase1(this: *mut source, RESET_RAYS_MASK: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN6source4infoEv"]
    pub fn source_info(this: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN6source10phase2fileEPKc"]
    pub fn source_phase2file(this: *mut source, filename: *const ::std::os::raw::c_char);
}
extern "C" {
    #[link_name = "\u{1}_ZN6source10wavelengthEv"]
    pub fn source_wavelength(this: *mut source) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN6source17wavelength_micronEv"]
    pub fn source_wavelength_micron(this: *mut source) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN6source18spectral_bandwidthEv"]
    pub fn source_spectral_bandwidth(this: *mut source) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN6source8n_photonEv"]
    pub fn source_n_photon(this: *mut source) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN6source8n_photonEf"]
    pub fn source_n_photon1(this: *mut source, _magnitude_: f32) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN6source19n_background_photonEf"]
    pub fn source_n_background_photon(this: *mut source, backgroundMagnitude: f32) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN6source10wavenumberEv"]
    pub fn source_wavenumber(this: *mut source) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN6source17update_directionsEPdS0_i"]
    pub fn source_update_directions(
        this: *mut source,
        zenith: *mut f64,
        azimuth: *mut f64,
        N_DIR: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source16update_magnitudeEPfi"]
    pub fn source_update_magnitude(
        this: *mut source,
        magnitude: *mut f32,
        N_MAG: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6source14copy_magnitudeEPS_"]
    pub fn source_copy_magnitude(this: *mut source, other_src: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN6source25optical_transfer_functionEP6float2"]
    pub fn source_optical_transfer_function(this: *mut source, d__otf: *mut float2);
}
impl source {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        zenith: f32,
        azimuth: f32,
        height: f32,
    ) {
        source_setup(self, _photometric_band, zenith, azimuth, height)
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        zenith: f32,
        azimuth: f32,
        height: f32,
        resolution: ::std::os::raw::c_int,
    ) {
        source_setup1(self, _photometric_band, zenith, azimuth, height, resolution)
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        zenith: f32,
        azimuth: f32,
        height: f32,
        tag_in: *const ::std::os::raw::c_char,
    ) {
        source_setup2(self, _photometric_band, zenith, azimuth, height, tag_in)
    }
    #[inline]
    pub unsafe fn setup3(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        zenith: f32,
        azimuth: f32,
        height: f32,
        resolution: ::std::os::raw::c_int,
        tag_in: *const ::std::os::raw::c_char,
    ) {
        source_setup3(
            self,
            _photometric_band,
            zenith,
            azimuth,
            height,
            resolution,
            tag_in,
        )
    }
    #[inline]
    pub unsafe fn setup4(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        _zenith: *mut f32,
        _azimuth: *mut f32,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
    ) {
        source_setup4(self, _photometric_band, _zenith, _azimuth, _height, _N_SRC)
    }
    #[inline]
    pub unsafe fn setup5(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        _zenith: *mut f32,
        _azimuth: *mut f32,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        resolution: ::std::os::raw::c_int,
    ) {
        source_setup5(
            self,
            _photometric_band,
            _zenith,
            _azimuth,
            _height,
            _N_SRC,
            resolution,
        )
    }
    #[inline]
    pub unsafe fn setup6(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        _zenith: *mut f32,
        _azimuth: *mut f32,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        _L_: rtd,
        _N_L_: ::std::os::raw::c_int,
        origin: vector,
    ) {
        source_setup6(
            self,
            _photometric_band,
            _zenith,
            _azimuth,
            _height,
            _N_SRC,
            _L_,
            _N_L_,
            origin,
        )
    }
    #[inline]
    pub unsafe fn setup7(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        magnitude: *mut f32,
        _zenith: *mut f32,
        _azimuth: *mut f32,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        _L_: rtd,
        _N_L_: ::std::os::raw::c_int,
        origin: vector,
    ) {
        source_setup7(
            self,
            _photometric_band,
            magnitude,
            _zenith,
            _azimuth,
            _height,
            _N_SRC,
            _L_,
            _N_L_,
            origin,
        )
    }
    #[inline]
    pub unsafe fn setup8(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        magnitude: *mut f32,
        _zenith: *mut rtd,
        _azimuth: *mut rtd,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        _L_: rtd,
        _N_L_: ::std::os::raw::c_int,
        origin: vector,
    ) {
        source_setup8(
            self,
            _photometric_band,
            magnitude,
            _zenith,
            _azimuth,
            _height,
            _N_SRC,
            _L_,
            _N_L_,
            origin,
        )
    }
    #[inline]
    pub unsafe fn setup_chief(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        magnitude: *mut f32,
        _zenith: *mut rtd,
        _azimuth: *mut rtd,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        _L_: rtd,
        _N_L_: ::std::os::raw::c_int,
        origin: vector,
        chief_origin: vector,
    ) {
        source_setup_chief(
            self,
            _photometric_band,
            magnitude,
            _zenith,
            _azimuth,
            _height,
            _N_SRC,
            _L_,
            _N_L_,
            origin,
            chief_origin,
        )
    }
    #[inline]
    pub unsafe fn setup9(
        &mut self,
        _photometric_band: *const ::std::os::raw::c_char,
        _magnitude: *mut f32,
        _zenith: *mut rtd,
        _azimuth: *mut rtd,
        _height: f32,
        _N_SRC: ::std::os::raw::c_int,
        _N_RAY_: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        origin: vector,
    ) {
        source_setup9(
            self,
            _photometric_band,
            _magnitude,
            _zenith,
            _azimuth,
            _height,
            _N_SRC,
            _N_RAY_,
            x,
            y,
            origin,
        )
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        source_cleanup(self)
    }
    #[inline]
    pub unsafe fn reset_rays(&mut self) {
        source_reset_rays(self)
    }
    #[inline]
    pub unsafe fn reset_rays1(&mut self, RESET_RAYS_MASK: ::std::os::raw::c_int) {
        source_reset_rays1(self, RESET_RAYS_MASK)
    }
    #[inline]
    pub unsafe fn opd2phase(&mut self) {
        source_opd2phase(self)
    }
    #[inline]
    pub unsafe fn opd2phase1(&mut self, RESET_RAYS_MASK: ::std::os::raw::c_int) {
        source_opd2phase1(self, RESET_RAYS_MASK)
    }
    #[inline]
    pub unsafe fn info(&mut self) {
        source_info(self)
    }
    #[inline]
    pub unsafe fn phase2file(&mut self, filename: *const ::std::os::raw::c_char) {
        source_phase2file(self, filename)
    }
    #[inline]
    pub unsafe fn wavelength(&mut self) -> f32 {
        source_wavelength(self)
    }
    #[inline]
    pub unsafe fn wavelength_micron(&mut self) -> f32 {
        source_wavelength_micron(self)
    }
    #[inline]
    pub unsafe fn spectral_bandwidth(&mut self) -> f32 {
        source_spectral_bandwidth(self)
    }
    #[inline]
    pub unsafe fn n_photon(&mut self) -> f32 {
        source_n_photon(self)
    }
    #[inline]
    pub unsafe fn n_photon1(&mut self, _magnitude_: f32) -> f32 {
        source_n_photon1(self, _magnitude_)
    }
    #[inline]
    pub unsafe fn n_background_photon(&mut self, backgroundMagnitude: f32) -> f32 {
        source_n_background_photon(self, backgroundMagnitude)
    }
    #[inline]
    pub unsafe fn wavenumber(&mut self) -> f32 {
        source_wavenumber(self)
    }
    #[inline]
    pub unsafe fn update_directions(
        &mut self,
        zenith: *mut f64,
        azimuth: *mut f64,
        N_DIR: ::std::os::raw::c_int,
    ) {
        source_update_directions(self, zenith, azimuth, N_DIR)
    }
    #[inline]
    pub unsafe fn update_magnitude(&mut self, magnitude: *mut f32, N_MAG: ::std::os::raw::c_int) {
        source_update_magnitude(self, magnitude, N_MAG)
    }
    #[inline]
    pub unsafe fn copy_magnitude(&mut self, other_src: *mut source) {
        source_copy_magnitude(self, other_src)
    }
    #[inline]
    pub unsafe fn optical_transfer_function(&mut self, d__otf: *mut float2) {
        source_optical_transfer_function(self, d__otf)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pssn {
    pub N_O: ::std::os::raw::c_int,
    pub N_O0: ::std::os::raw::c_int,
    pub n_byte: ::std::os::raw::c_int,
    pub d__O: *mut float2,
    pub d__O0: *mut float2,
    pub buffer: *mut float2,
    pub d__C: *mut float2,
    pub N_PX: ::std::os::raw::c_int,
    pub N: ::std::os::raw::c_int,
    pub d__W: *mut float2,
    pub N_OTF: ::std::os::raw::c_int,
    pub N_OTF2: ::std::os::raw::c_int,
    pub NN: ::std::os::raw::c_int,
    pub plan: cufftHandle,
    pub handle: cublasHandle_t,
    pub num: f32,
    pub denom: *mut f32,
}
#[test]
fn bindgen_test_layout_pssn() {
    assert_eq!(
        ::std::mem::size_of::<pssn>(),
        104usize,
        concat!("Size of: ", stringify!(pssn))
    );
    assert_eq!(
        ::std::mem::align_of::<pssn>(),
        8usize,
        concat!("Alignment of ", stringify!(pssn))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).N_O as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pssn), "::", stringify!(N_O))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).N_O0 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(N_O0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).n_byte as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(n_byte)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).d__O as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(d__O)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).d__O0 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(d__O0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).buffer as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).d__C as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(d__C)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).N_PX as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(N_PX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).N as *const _ as usize },
        52usize,
        concat!("Offset of field: ", stringify!(pssn), "::", stringify!(N))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).d__W as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(d__W)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).N_OTF as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(N_OTF)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).N_OTF2 as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(N_OTF2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).NN as *const _ as usize },
        72usize,
        concat!("Offset of field: ", stringify!(pssn), "::", stringify!(NN))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).plan as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(plan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).handle as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).num as *const _ as usize },
        88usize,
        concat!("Offset of field: ", stringify!(pssn), "::", stringify!(num))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pssn>())).denom as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(pssn),
            "::",
            stringify!(denom)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn5setupEP6sourceff"]
    pub fn pssn_setup(this: *mut pssn, src: *mut source, r0: f32, L0: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn7cleanupEv"]
    pub fn pssn_cleanup(this: *mut pssn);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn7__otf__EP6sourceP6float2"]
    pub fn pssn___otf__(this: *mut pssn, src: *mut source, _d__O_: *mut float2);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn3otfEP6source"]
    pub fn pssn_otf(this: *mut pssn, src: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn7atm_otfEfff"]
    pub fn pssn_atm_otf(this: *mut pssn, d: f32, r0: f32, L0: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn4evalEv"]
    pub fn pssn_eval(this: *mut pssn) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn5oevalEv"]
    pub fn pssn_oeval(this: *mut pssn) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn4evalEPf"]
    pub fn pssn_eval1(this: *mut pssn, results: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn5oevalEPf"]
    pub fn pssn_oeval1(this: *mut pssn, results: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn4xotfEPf"]
    pub fn pssn_xotf(this: *mut pssn, buffer: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn1OEPf"]
    pub fn pssn_O(this: *mut pssn, buffer: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn2O0EPf"]
    pub fn pssn_O0(this: *mut pssn, buffer: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn1CEPf"]
    pub fn pssn_C(this: *mut pssn, buffer: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4pssn1BEPf"]
    pub fn pssn_B(this: *mut pssn, buffer: *mut f32);
}
impl pssn {
    #[inline]
    pub unsafe fn setup(&mut self, src: *mut source, r0: f32, L0: f32) {
        pssn_setup(self, src, r0, L0)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        pssn_cleanup(self)
    }
    #[inline]
    pub unsafe fn __otf__(&mut self, src: *mut source, _d__O_: *mut float2) {
        pssn___otf__(self, src, _d__O_)
    }
    #[inline]
    pub unsafe fn otf(&mut self, src: *mut source) {
        pssn_otf(self, src)
    }
    #[inline]
    pub unsafe fn atm_otf(&mut self, d: f32, r0: f32, L0: f32) {
        pssn_atm_otf(self, d, r0, L0)
    }
    #[inline]
    pub unsafe fn eval(&mut self) -> f32 {
        pssn_eval(self)
    }
    #[inline]
    pub unsafe fn oeval(&mut self) -> f32 {
        pssn_oeval(self)
    }
    #[inline]
    pub unsafe fn eval1(&mut self, results: *mut f32) {
        pssn_eval1(self, results)
    }
    #[inline]
    pub unsafe fn oeval1(&mut self, results: *mut f32) {
        pssn_oeval1(self, results)
    }
    #[inline]
    pub unsafe fn xotf(&mut self, buffer: *mut f32) {
        pssn_xotf(self, buffer)
    }
    #[inline]
    pub unsafe fn O(&mut self, buffer: *mut f32) {
        pssn_O(self, buffer)
    }
    #[inline]
    pub unsafe fn O0(&mut self, buffer: *mut f32) {
        pssn_O0(self, buffer)
    }
    #[inline]
    pub unsafe fn C(&mut self, buffer: *mut f32) {
        pssn_C(self, buffer)
    }
    #[inline]
    pub unsafe fn B(&mut self, buffer: *mut f32) {
        pssn_B(self, buffer)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct coordinate_system {
    pub origin: *mut vector,
    pub euler_angles: *mut vector,
    pub N: ::std::os::raw::c_int,
    pub R: *mut rtd,
    pub d__R: *mut rtd,
    pub float_R: *mut f32,
    pub d__origin: *mut vector,
    pub tag: [::std::os::raw::c_char; 32usize],
}
#[test]
fn bindgen_test_layout_coordinate_system() {
    assert_eq!(
        ::std::mem::size_of::<coordinate_system>(),
        88usize,
        concat!("Size of: ", stringify!(coordinate_system))
    );
    assert_eq!(
        ::std::mem::align_of::<coordinate_system>(),
        8usize,
        concat!("Alignment of ", stringify!(coordinate_system))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<coordinate_system>())).origin as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(coordinate_system),
            "::",
            stringify!(origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<coordinate_system>())).euler_angles as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(coordinate_system),
            "::",
            stringify!(euler_angles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<coordinate_system>())).N as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(coordinate_system),
            "::",
            stringify!(N)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<coordinate_system>())).R as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(coordinate_system),
            "::",
            stringify!(R)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<coordinate_system>())).d__R as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(coordinate_system),
            "::",
            stringify!(d__R)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<coordinate_system>())).float_R as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(coordinate_system),
            "::",
            stringify!(float_R)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<coordinate_system>())).d__origin as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(coordinate_system),
            "::",
            stringify!(d__origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<coordinate_system>())).tag as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(coordinate_system),
            "::",
            stringify!(tag)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17coordinate_system5setupEv"]
    pub fn coordinate_system_setup(this: *mut coordinate_system);
}
extern "C" {
    #[link_name = "\u{1}_ZN17coordinate_system5setupE6vectorS0_"]
    pub fn coordinate_system_setup1(
        this: *mut coordinate_system,
        _origin_: vector,
        _euler_angles_: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17coordinate_system5setupEP6vectorS1_i"]
    pub fn coordinate_system_setup2(
        this: *mut coordinate_system,
        _origin_: *mut vector,
        _euler_angles_: *mut vector,
        _N_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17coordinate_system5setupEP6vectorS1_iPc"]
    pub fn coordinate_system_setup3(
        this: *mut coordinate_system,
        _origin_: *mut vector,
        _euler_angles_: *mut vector,
        _N_: ::std::os::raw::c_int,
        _tag_: *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN17coordinate_system7cleanupEv"]
    pub fn coordinate_system_cleanup(this: *mut coordinate_system);
}
extern "C" {
    #[link_name = "\u{1}_ZN17coordinate_system4infoEv"]
    pub fn coordinate_system_info(this: *mut coordinate_system);
}
extern "C" {
    #[link_name = "\u{1}_ZN17coordinate_system12info_detailsEv"]
    pub fn coordinate_system_info_details(this: *mut coordinate_system);
}
extern "C" {
    #[link_name = "\u{1}_ZN17coordinate_system6updateEv"]
    pub fn coordinate_system_update(this: *mut coordinate_system);
}
extern "C" {
    #[link_name = "\u{1}_ZN17coordinate_system6updateE6vectorS0_i"]
    pub fn coordinate_system_update1(
        this: *mut coordinate_system,
        _origin_: vector,
        _euler_angles_: vector,
        idx: ::std::os::raw::c_int,
    );
}
impl coordinate_system {
    #[inline]
    pub unsafe fn setup(&mut self) {
        coordinate_system_setup(self)
    }
    #[inline]
    pub unsafe fn setup1(&mut self, _origin_: vector, _euler_angles_: vector) {
        coordinate_system_setup1(self, _origin_, _euler_angles_)
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        _origin_: *mut vector,
        _euler_angles_: *mut vector,
        _N_: ::std::os::raw::c_int,
    ) {
        coordinate_system_setup2(self, _origin_, _euler_angles_, _N_)
    }
    #[inline]
    pub unsafe fn setup3(
        &mut self,
        _origin_: *mut vector,
        _euler_angles_: *mut vector,
        _N_: ::std::os::raw::c_int,
        _tag_: *mut ::std::os::raw::c_char,
    ) {
        coordinate_system_setup3(self, _origin_, _euler_angles_, _N_, _tag_)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        coordinate_system_cleanup(self)
    }
    #[inline]
    pub unsafe fn info(&mut self) {
        coordinate_system_info(self)
    }
    #[inline]
    pub unsafe fn info_details(&mut self) {
        coordinate_system_info_details(self)
    }
    #[inline]
    pub unsafe fn update(&mut self) {
        coordinate_system_update(self)
    }
    #[inline]
    pub unsafe fn update1(
        &mut self,
        _origin_: vector,
        _euler_angles_: vector,
        idx: ::std::os::raw::c_int,
    ) {
        coordinate_system_update1(self, _origin_, _euler_angles_, idx)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct conic {
    pub ref_frame: coordinate_system,
    pub origin: vector,
    pub d__origin: *mut vector,
    pub c: rtd,
    pub k: rtd,
    pub refractive_index: rtd,
    pub even_asphere_N: ::std::os::raw::c_int,
    pub d__even_asphere_a: *mut rtd,
}
#[test]
fn bindgen_test_layout_conic() {
    assert_eq!(
        ::std::mem::size_of::<conic>(),
        160usize,
        concat!("Size of: ", stringify!(conic))
    );
    assert_eq!(
        ::std::mem::align_of::<conic>(),
        8usize,
        concat!("Alignment of ", stringify!(conic))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<conic>())).ref_frame as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(conic),
            "::",
            stringify!(ref_frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<conic>())).origin as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(conic),
            "::",
            stringify!(origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<conic>())).d__origin as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(conic),
            "::",
            stringify!(d__origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<conic>())).c as *const _ as usize },
        120usize,
        concat!("Offset of field: ", stringify!(conic), "::", stringify!(c))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<conic>())).k as *const _ as usize },
        128usize,
        concat!("Offset of field: ", stringify!(conic), "::", stringify!(k))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<conic>())).refractive_index as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(conic),
            "::",
            stringify!(refractive_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<conic>())).even_asphere_N as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(conic),
            "::",
            stringify!(even_asphere_N)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<conic>())).d__even_asphere_a as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(conic),
            "::",
            stringify!(d__even_asphere_a)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5conic5setupEdd"]
    pub fn conic_setup(this: *mut conic, _c_: rtd, _k_: rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN5conic5setupEdd6vectorS0_"]
    pub fn conic_setup1(
        this: *mut conic,
        _c_: rtd,
        _k_: rtd,
        _origin_: vector,
        _euler_angles_: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5conic5setupEdd6vectorS0_S0_"]
    pub fn conic_setup2(
        this: *mut conic,
        _c_: rtd,
        _k_: rtd,
        _origin_: vector,
        _euler_angles_: vector,
        conic_origin: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5conic5setupEdd6vectorS0_S0_d"]
    pub fn conic_setup3(
        this: *mut conic,
        _c_: rtd,
        _k_: rtd,
        _origin_: vector,
        _euler_angles_: vector,
        conic_origin: vector,
        _refractive_index_: rtd,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5conic5setupEdd6vectorS0_S0_diPd"]
    pub fn conic_setup4(
        this: *mut conic,
        _c_: rtd,
        _k_: rtd,
        _origin_: vector,
        _euler_angles_: vector,
        conic_origin: vector,
        _refractive_index_: rtd,
        asphere_N: ::std::os::raw::c_int,
        asphere_a: *mut rtd,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5conic7cleanupEv"]
    pub fn conic_cleanup(this: *mut conic);
}
extern "C" {
    #[link_name = "\u{1}_ZN5conic5traceEP6bundle"]
    pub fn conic_trace(this: *mut conic, src: *mut bundle);
}
extern "C" {
    #[link_name = "\u{1}_ZN5conic4infoEv"]
    pub fn conic_info(this: *mut conic);
}
impl conic {
    #[inline]
    pub unsafe fn setup(&mut self, _c_: rtd, _k_: rtd) {
        conic_setup(self, _c_, _k_)
    }
    #[inline]
    pub unsafe fn setup1(&mut self, _c_: rtd, _k_: rtd, _origin_: vector, _euler_angles_: vector) {
        conic_setup1(self, _c_, _k_, _origin_, _euler_angles_)
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        _c_: rtd,
        _k_: rtd,
        _origin_: vector,
        _euler_angles_: vector,
        conic_origin: vector,
    ) {
        conic_setup2(self, _c_, _k_, _origin_, _euler_angles_, conic_origin)
    }
    #[inline]
    pub unsafe fn setup3(
        &mut self,
        _c_: rtd,
        _k_: rtd,
        _origin_: vector,
        _euler_angles_: vector,
        conic_origin: vector,
        _refractive_index_: rtd,
    ) {
        conic_setup3(
            self,
            _c_,
            _k_,
            _origin_,
            _euler_angles_,
            conic_origin,
            _refractive_index_,
        )
    }
    #[inline]
    pub unsafe fn setup4(
        &mut self,
        _c_: rtd,
        _k_: rtd,
        _origin_: vector,
        _euler_angles_: vector,
        conic_origin: vector,
        _refractive_index_: rtd,
        asphere_N: ::std::os::raw::c_int,
        asphere_a: *mut rtd,
    ) {
        conic_setup4(
            self,
            _c_,
            _k_,
            _origin_,
            _euler_angles_,
            conic_origin,
            _refractive_index_,
            asphere_N,
            asphere_a,
        )
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        conic_cleanup(self)
    }
    #[inline]
    pub unsafe fn trace(&mut self, src: *mut bundle) {
        conic_trace(self, src)
    }
    #[inline]
    pub unsafe fn info(&mut self) {
        conic_info(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct zernikeS {
    pub max_n: ::std::os::raw::c_int,
    pub j: ::std::os::raw::c_uint,
    pub n: ::std::os::raw::c_uint,
    pub m: ::std::os::raw::c_uint,
    pub n_mode: ::std::os::raw::c_uint,
    pub a: *mut rtd,
    pub d__a: *mut rtd,
    pub bx: *mut rtd,
    pub by: *mut rtd,
    pub d__bx: *mut rtd,
    pub d__by: *mut rtd,
    pub bx_row_idx: *mut ::std::os::raw::c_uint,
    pub bx_col_ptr: *mut ::std::os::raw::c_uint,
    pub by_row_idx: *mut ::std::os::raw::c_uint,
    pub by_col_ptr: *mut ::std::os::raw::c_uint,
    pub bx_nnz: ::std::os::raw::c_uint,
    pub by_nnz: ::std::os::raw::c_uint,
    pub cx: *mut rtd,
    pub d__cx: *mut rtd,
    pub cy: *mut rtd,
    pub d__cy: *mut rtd,
    pub N: ::std::os::raw::c_int,
    pub ref_frame: coordinate_system,
}
#[test]
fn bindgen_test_layout_zernikeS() {
    assert_eq!(
        ::std::mem::size_of::<zernikeS>(),
        240usize,
        concat!("Size of: ", stringify!(zernikeS))
    );
    assert_eq!(
        ::std::mem::align_of::<zernikeS>(),
        8usize,
        concat!("Alignment of ", stringify!(zernikeS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).max_n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(max_n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).j as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(j)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).n as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).m as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(m)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).n_mode as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(n_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).a as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).d__a as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(d__a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).bx as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(bx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).by as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(by)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).d__bx as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(d__bx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).d__by as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(d__by)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).bx_row_idx as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(bx_row_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).bx_col_ptr as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(bx_col_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).by_row_idx as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(by_row_idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).by_col_ptr as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(by_col_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).bx_nnz as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(bx_nnz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).by_nnz as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(by_nnz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).cx as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(cx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).d__cx as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(d__cx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).cy as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(cy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).d__cy as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(d__cy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).N as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(N)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<zernikeS>())).ref_frame as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(zernikeS),
            "::",
            stringify!(ref_frame)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS5setupEiPd"]
    pub fn zernikeS_setup(this: *mut zernikeS, max_n: ::std::os::raw::c_int, a: *mut rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS5setupEiPdi"]
    pub fn zernikeS_setup1(
        this: *mut zernikeS,
        _max_n_: ::std::os::raw::c_int,
        _a_: *mut rtd,
        _N_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS5setupEiPd6vectorS1_"]
    pub fn zernikeS_setup2(
        this: *mut zernikeS,
        max_n: ::std::os::raw::c_int,
        a: *mut rtd,
        _origin_: vector,
        _euler_angles_: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS5setupEiPd6vectorS1_i"]
    pub fn zernikeS_setup3(
        this: *mut zernikeS,
        max_n: ::std::os::raw::c_int,
        a: *mut rtd,
        _origin_: vector,
        _euler_angles_: vector,
        _N_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS7cleanupEv"]
    pub fn zernikeS_cleanup(this: *mut zernikeS);
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS7surfaceEPdS0_S0_i"]
    pub fn zernikeS_surface(
        this: *mut zernikeS,
        S: *mut rtd,
        r: *mut rtd,
        o: *mut rtd,
        N: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS7surfaceEPdS0_S0_ii"]
    pub fn zernikeS_surface1(
        this: *mut zernikeS,
        S: *mut rtd,
        r: *mut rtd,
        o: *mut rtd,
        N: ::std::os::raw::c_int,
        surf_id: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS6updateEPd"]
    pub fn zernikeS_update(this: *mut zernikeS, a: *mut rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS24surface_derivative_coefsEv"]
    pub fn zernikeS_surface_derivative_coefs(this: *mut zernikeS);
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS19surface_derivativesEPdS0_S0_S0_i"]
    pub fn zernikeS_surface_derivatives(
        this: *mut zernikeS,
        d__dSdx: *mut rtd,
        d__dSdy: *mut rtd,
        d__r: *mut rtd,
        d__o: *mut rtd,
        N: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS23surface_and_derivativesEPdS0_S0_S0_S0_i"]
    pub fn zernikeS_surface_and_derivatives(
        this: *mut zernikeS,
        d__S: *mut rtd,
        d__dSdx: *mut rtd,
        d__dSdy: *mut rtd,
        d__r: *mut rtd,
        d__o: *mut rtd,
        N: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS23surface_and_derivativesEPdS0_S0_S0_S0_ii"]
    pub fn zernikeS_surface_and_derivatives1(
        this: *mut zernikeS,
        d__S: *mut rtd,
        d__dSdx: *mut rtd,
        d__dSdy: *mut rtd,
        d__r: *mut rtd,
        d__o: *mut rtd,
        N: ::std::os::raw::c_int,
        surf_id: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8zernikeS10projectionEPfPdS1_i"]
    pub fn zernikeS_projection(
        this: *mut zernikeS,
        d__phase: *mut f32,
        d__r: *mut rtd,
        d__o: *mut rtd,
        N: ::std::os::raw::c_int,
    );
}
impl zernikeS {
    #[inline]
    pub unsafe fn setup(&mut self, max_n: ::std::os::raw::c_int, a: *mut rtd) {
        zernikeS_setup(self, max_n, a)
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        _max_n_: ::std::os::raw::c_int,
        _a_: *mut rtd,
        _N_: ::std::os::raw::c_int,
    ) {
        zernikeS_setup1(self, _max_n_, _a_, _N_)
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        max_n: ::std::os::raw::c_int,
        a: *mut rtd,
        _origin_: vector,
        _euler_angles_: vector,
    ) {
        zernikeS_setup2(self, max_n, a, _origin_, _euler_angles_)
    }
    #[inline]
    pub unsafe fn setup3(
        &mut self,
        max_n: ::std::os::raw::c_int,
        a: *mut rtd,
        _origin_: vector,
        _euler_angles_: vector,
        _N_: ::std::os::raw::c_int,
    ) {
        zernikeS_setup3(self, max_n, a, _origin_, _euler_angles_, _N_)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        zernikeS_cleanup(self)
    }
    #[inline]
    pub unsafe fn surface(
        &mut self,
        S: *mut rtd,
        r: *mut rtd,
        o: *mut rtd,
        N: ::std::os::raw::c_int,
    ) {
        zernikeS_surface(self, S, r, o, N)
    }
    #[inline]
    pub unsafe fn surface1(
        &mut self,
        S: *mut rtd,
        r: *mut rtd,
        o: *mut rtd,
        N: ::std::os::raw::c_int,
        surf_id: ::std::os::raw::c_int,
    ) {
        zernikeS_surface1(self, S, r, o, N, surf_id)
    }
    #[inline]
    pub unsafe fn update(&mut self, a: *mut rtd) {
        zernikeS_update(self, a)
    }
    #[inline]
    pub unsafe fn surface_derivative_coefs(&mut self) {
        zernikeS_surface_derivative_coefs(self)
    }
    #[inline]
    pub unsafe fn surface_derivatives(
        &mut self,
        d__dSdx: *mut rtd,
        d__dSdy: *mut rtd,
        d__r: *mut rtd,
        d__o: *mut rtd,
        N: ::std::os::raw::c_int,
    ) {
        zernikeS_surface_derivatives(self, d__dSdx, d__dSdy, d__r, d__o, N)
    }
    #[inline]
    pub unsafe fn surface_and_derivatives(
        &mut self,
        d__S: *mut rtd,
        d__dSdx: *mut rtd,
        d__dSdy: *mut rtd,
        d__r: *mut rtd,
        d__o: *mut rtd,
        N: ::std::os::raw::c_int,
    ) {
        zernikeS_surface_and_derivatives(self, d__S, d__dSdx, d__dSdy, d__r, d__o, N)
    }
    #[inline]
    pub unsafe fn surface_and_derivatives1(
        &mut self,
        d__S: *mut rtd,
        d__dSdx: *mut rtd,
        d__dSdy: *mut rtd,
        d__r: *mut rtd,
        d__o: *mut rtd,
        N: ::std::os::raw::c_int,
        surf_id: ::std::os::raw::c_int,
    ) {
        zernikeS_surface_and_derivatives1(self, d__S, d__dSdx, d__dSdy, d__r, d__o, N, surf_id)
    }
    #[inline]
    pub unsafe fn projection(
        &mut self,
        d__phase: *mut f32,
        d__r: *mut rtd,
        d__o: *mut rtd,
        N: ::std::os::raw::c_int,
    ) {
        zernikeS_projection(self, d__phase, d__r, d__o, N)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aperture {
    pub D_px: ::std::os::raw::c_int,
    pub D: rtd,
    pub ri: rtd,
    pub D_seg: rtd,
    pub N: ::std::os::raw::c_int,
    pub V: mask,
    pub ref_frame: coordinate_system,
}
#[test]
fn bindgen_test_layout_aperture() {
    assert_eq!(
        ::std::mem::size_of::<aperture>(),
        208usize,
        concat!("Size of: ", stringify!(aperture))
    );
    assert_eq!(
        ::std::mem::align_of::<aperture>(),
        8usize,
        concat!("Alignment of ", stringify!(aperture))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aperture>())).D_px as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(aperture),
            "::",
            stringify!(D_px)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aperture>())).D as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(aperture),
            "::",
            stringify!(D)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aperture>())).ri as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(aperture),
            "::",
            stringify!(ri)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aperture>())).D_seg as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(aperture),
            "::",
            stringify!(D_seg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aperture>())).N as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(aperture),
            "::",
            stringify!(N)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aperture>())).V as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(aperture),
            "::",
            stringify!(V)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aperture>())).ref_frame as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(aperture),
            "::",
            stringify!(ref_frame)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8aperture5setupEdi6vectorS0_"]
    pub fn aperture_setup(
        this: *mut aperture,
        _D_: rtd,
        _D_px_: ::std::os::raw::c_int,
        _origin_: vector,
        _euler_angles_: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8aperture5setupEddi6vectorS0_"]
    pub fn aperture_setup1(
        this: *mut aperture,
        _D_: rtd,
        _ri_: rtd,
        _D_px_: ::std::os::raw::c_int,
        _origin_: vector,
        _euler_angles_: vector,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8aperture5setupEdddiP6vectorS1_i"]
    pub fn aperture_setup2(
        this: *mut aperture,
        _D_: rtd,
        _ri_: rtd,
        _D_seg_: rtd,
        _D_px_: ::std::os::raw::c_int,
        _origin_: *mut vector,
        _euler_angles_: *mut vector,
        N_segment: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN8aperture12setup_GMT_M1Edi"]
    pub fn aperture_setup_GMT_M1(this: *mut aperture, _D_: rtd, _D_px_: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN8aperture7cleanupEv"]
    pub fn aperture_cleanup(this: *mut aperture);
}
extern "C" {
    #[link_name = "\u{1}_ZN8aperture10vignettingEP6bundle"]
    pub fn aperture_vignetting(this: *mut aperture, rays: *mut bundle);
}
impl aperture {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        _D_: rtd,
        _D_px_: ::std::os::raw::c_int,
        _origin_: vector,
        _euler_angles_: vector,
    ) {
        aperture_setup(self, _D_, _D_px_, _origin_, _euler_angles_)
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        _D_: rtd,
        _ri_: rtd,
        _D_px_: ::std::os::raw::c_int,
        _origin_: vector,
        _euler_angles_: vector,
    ) {
        aperture_setup1(self, _D_, _ri_, _D_px_, _origin_, _euler_angles_)
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        _D_: rtd,
        _ri_: rtd,
        _D_seg_: rtd,
        _D_px_: ::std::os::raw::c_int,
        _origin_: *mut vector,
        _euler_angles_: *mut vector,
        N_segment: ::std::os::raw::c_int,
    ) {
        aperture_setup2(
            self,
            _D_,
            _ri_,
            _D_seg_,
            _D_px_,
            _origin_,
            _euler_angles_,
            N_segment,
        )
    }
    #[inline]
    pub unsafe fn setup_GMT_M1(&mut self, _D_: rtd, _D_px_: ::std::os::raw::c_int) {
        aperture_setup_GMT_M1(self, _D_, _D_px_)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        aperture_cleanup(self)
    }
    #[inline]
    pub unsafe fn vignetting(&mut self, rays: *mut bundle) {
        aperture_vignetting(self, rays)
    }
}
extern "C" {
    #[link_name = "\u{1}_Z14transform_to_SP6bundleP5conic"]
    pub fn transform_to_S(rays: *mut bundle, F: *mut conic);
}
extern "C" {
    #[link_name = "\u{1}_Z14transform_to_SP6bundleP8aperture"]
    pub fn transform_to_S1(rays: *mut bundle, A: *mut aperture);
}
extern "C" {
    #[link_name = "\u{1}_Z14transform_to_RP6bundleP5conic"]
    pub fn transform_to_R(rays: *mut bundle, F: *mut conic);
}
extern "C" {
    #[link_name = "\u{1}_Z14transform_to_RP6bundleP8aperture"]
    pub fn transform_to_R1(rays: *mut bundle, A: *mut aperture);
}
extern "C" {
    #[link_name = "\u{1}_Z9intersectP6bundleP5conic"]
    pub fn intersect(rays: *mut bundle, F: *mut conic);
}
extern "C" {
    #[link_name = "\u{1}_Z7reflectP6bundle"]
    pub fn reflect(rays: *mut bundle);
}
extern "C" {
    #[link_name = "\u{1}_Z7refractP6bundled"]
    pub fn refract(rays: *mut bundle, mu: rtd);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct imaging {
    pub N_PX_PUPIL: ::std::os::raw::c_int,
    pub N_DFT: ::std::os::raw::c_int,
    pub N_SIDE_LENSLET: ::std::os::raw::c_int,
    pub N_LENSLET: ::std::os::raw::c_int,
    pub N_SOURCE: ::std::os::raw::c_int,
    pub N_PX_IMAGE: ::std::os::raw::c_int,
    pub N_PX_CAMERA: ::std::os::raw::c_int,
    pub N_FRAME: ::std::os::raw::c_int,
    pub BIN_IMAGE: ::std::os::raw::c_int,
    pub LOCAL_RAND_SEED: ::std::os::raw::c_int,
    pub plan: cufftHandle,
    pub N_PHOTON_PER_SECOND_PER_FRAME: f32,
    pub N_PHOTON_PER_FRAME: f32,
    pub d__wave_PUPIL: *mut float2,
    pub d__frame: *mut f32,
    pub zenith: f32,
    pub azimuth: f32,
    pub theta_x: f32,
    pub theta_y: f32,
    pub d__zenith: *mut f32,
    pub d__azimuth: *mut f32,
    pub d__theta_x: *mut f32,
    pub d__theta_y: *mut f32,
    pub pixel_scale: f32,
    pub photoelectron_gain: f32,
    pub absolute_pointing: ::std::os::raw::c_char,
    pub devStates: *mut curandState,
}
#[test]
fn bindgen_test_layout_imaging() {
    assert_eq!(
        ::std::mem::size_of::<imaging>(),
        144usize,
        concat!("Size of: ", stringify!(imaging))
    );
    assert_eq!(
        ::std::mem::align_of::<imaging>(),
        8usize,
        concat!("Alignment of ", stringify!(imaging))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).N_PX_PUPIL as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(N_PX_PUPIL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).N_DFT as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(N_DFT)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).N_SIDE_LENSLET as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(N_SIDE_LENSLET)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).N_LENSLET as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(N_LENSLET)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).N_SOURCE as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(N_SOURCE)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).N_PX_IMAGE as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(N_PX_IMAGE)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).N_PX_CAMERA as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(N_PX_CAMERA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).N_FRAME as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(N_FRAME)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).BIN_IMAGE as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(BIN_IMAGE)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).LOCAL_RAND_SEED as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(LOCAL_RAND_SEED)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).plan as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(plan)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<imaging>())).N_PHOTON_PER_SECOND_PER_FRAME as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(N_PHOTON_PER_SECOND_PER_FRAME)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).N_PHOTON_PER_FRAME as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(N_PHOTON_PER_FRAME)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).d__wave_PUPIL as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(d__wave_PUPIL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).d__frame as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(d__frame)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).zenith as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(zenith)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).azimuth as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(azimuth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).theta_x as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(theta_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).theta_y as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(theta_y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).d__zenith as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(d__zenith)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).d__azimuth as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(d__azimuth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).d__theta_x as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(d__theta_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).d__theta_y as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(d__theta_y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).pixel_scale as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(pixel_scale)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).photoelectron_gain as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(photoelectron_gain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).absolute_pointing as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(absolute_pointing)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaging>())).devStates as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(imaging),
            "::",
            stringify!(devStates)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging5setupEiiiff"]
    pub fn imaging_setup(
        this: *mut imaging,
        __N_PX_PUPIL: ::std::os::raw::c_int,
        __N_SIDE_LENSLET: ::std::os::raw::c_int,
        DFT_osf: ::std::os::raw::c_int,
        IMAGE_osf: f32,
        CAMERA_osf: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging5setupEiiiffi"]
    pub fn imaging_setup1(
        this: *mut imaging,
        __N_PX_PUPIL: ::std::os::raw::c_int,
        __N_SIDE_LENSLET: ::std::os::raw::c_int,
        DFT_osf: ::std::os::raw::c_int,
        IMAGE_osf: f32,
        CAMERA_osf: f32,
        __N_SOURCE: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging5setupEiiiifi"]
    pub fn imaging_setup2(
        this: *mut imaging,
        __N_PX_PUPIL: ::std::os::raw::c_int,
        __N_SIDE_LENSLET: ::std::os::raw::c_int,
        DFT_osf: ::std::os::raw::c_int,
        N_PX_IMAGE_: ::std::os::raw::c_int,
        CAMERA_osf: f32,
        __N_SOURCE: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging5setupEiiiiii"]
    pub fn imaging_setup3(
        this: *mut imaging,
        __N_PX_PUPIL: ::std::os::raw::c_int,
        __N_SIDE_LENSLET: ::std::os::raw::c_int,
        DFT_osf: ::std::os::raw::c_int,
        N_PX_IMAGE_: ::std::os::raw::c_int,
        BIN_IMAGE: ::std::os::raw::c_int,
        __N_SOURCE: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging24setupSegmentPistonSensorEiiiiii"]
    pub fn imaging_setupSegmentPistonSensor(
        this: *mut imaging,
        __N_PX_PUPIL: ::std::os::raw::c_int,
        __N_SIDE_LENSLET: ::std::os::raw::c_int,
        _N_DFT_: ::std::os::raw::c_int,
        N_PX_IMAGE_: ::std::os::raw::c_int,
        _BIN_IMAGE_: ::std::os::raw::c_int,
        __N_SOURCE: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging7cleanupEv"]
    pub fn imaging_cleanup(this: *mut imaging);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging26cleanupSegmentPistonSensorEv"]
    pub fn imaging_cleanupSegmentPistonSensor(this: *mut imaging);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging22set_pointing_directionEPfS0_"]
    pub fn imaging_set_pointing_direction(this: *mut imaging, zen: *mut f32, azim: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging5resetEv"]
    pub fn imaging_reset(this: *mut imaging);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging9reset_rngEi"]
    pub fn imaging_reset_rng(this: *mut imaging, SEED: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging9propagateEP6source"]
    pub fn imaging_propagate(this: *mut imaging, src: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging13propagate_cpxEP6source"]
    pub fn imaging_propagate_cpx(this: *mut imaging, src: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging18propagateNoOverlapEP6source"]
    pub fn imaging_propagateNoOverlap(this: *mut imaging, src: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging22propagateNoOverlapBareEP6source"]
    pub fn imaging_propagateNoOverlapBare(this: *mut imaging, src: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging21propagateNoOverlapSPSEP6sourceff"]
    pub fn imaging_propagateNoOverlapSPS(
        this: *mut imaging,
        src: *mut source,
        d: f32,
        wavenumber: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging12propagateTT7EP6source"]
    pub fn imaging_propagateTT7(this: *mut imaging, src: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging12propagateTT7EP6sourcePi"]
    pub fn imaging_propagateTT71(
        this: *mut imaging,
        src: *mut source,
        d__piston_mask: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging25propagateThroughFieldStopEP6sourcef"]
    pub fn imaging_propagateThroughFieldStop(
        this: *mut imaging,
        src: *mut source,
        field_stop_diam: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging23propagateThroughPyramidEP6sourcef"]
    pub fn imaging_propagateThroughPyramid(this: *mut imaging, src: *mut source, alpha: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging32propagateThroughModulatedPyramidEP6sourcefif"]
    pub fn imaging_propagateThroughModulatedPyramid(
        this: *mut imaging,
        src: *mut source,
        modulation: f32,
        modulation_sampling: ::std::os::raw::c_int,
        alpha: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging7readoutEff"]
    pub fn imaging_readout(this: *mut imaging, exposureTime: f32, readOutNoiseRms: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging17noiseless_readoutEf"]
    pub fn imaging_noiseless_readout(this: *mut imaging, exposureTime: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging7readoutEffff"]
    pub fn imaging_readout1(
        this: *mut imaging,
        exposureTime: f32,
        readOutNoiseRms: f32,
        nBackgroundPhoton: f32,
        noiseFactor: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging12strehl_ratioEPS_"]
    pub fn imaging_strehl_ratio(this: *mut imaging, ref_: *mut imaging) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging4infoEv"]
    pub fn imaging_info(this: *mut imaging);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging10frame2fileEPKc"]
    pub fn imaging_frame2file(this: *mut imaging, filename: *const ::std::os::raw::c_char);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging10show_frameEPc"]
    pub fn imaging_show_frame(this: *mut imaging, filename: *mut ::std::os::raw::c_char);
}
extern "C" {
    #[link_name = "\u{1}_ZN7imaging10show_frameEPcPS_"]
    pub fn imaging_show_frame1(
        this: *mut imaging,
        filename: *mut ::std::os::raw::c_char,
        ref_: *mut imaging,
    );
}
impl imaging {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        __N_PX_PUPIL: ::std::os::raw::c_int,
        __N_SIDE_LENSLET: ::std::os::raw::c_int,
        DFT_osf: ::std::os::raw::c_int,
        IMAGE_osf: f32,
        CAMERA_osf: f32,
    ) {
        imaging_setup(
            self,
            __N_PX_PUPIL,
            __N_SIDE_LENSLET,
            DFT_osf,
            IMAGE_osf,
            CAMERA_osf,
        )
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        __N_PX_PUPIL: ::std::os::raw::c_int,
        __N_SIDE_LENSLET: ::std::os::raw::c_int,
        DFT_osf: ::std::os::raw::c_int,
        IMAGE_osf: f32,
        CAMERA_osf: f32,
        __N_SOURCE: ::std::os::raw::c_int,
    ) {
        imaging_setup1(
            self,
            __N_PX_PUPIL,
            __N_SIDE_LENSLET,
            DFT_osf,
            IMAGE_osf,
            CAMERA_osf,
            __N_SOURCE,
        )
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        __N_PX_PUPIL: ::std::os::raw::c_int,
        __N_SIDE_LENSLET: ::std::os::raw::c_int,
        DFT_osf: ::std::os::raw::c_int,
        N_PX_IMAGE_: ::std::os::raw::c_int,
        CAMERA_osf: f32,
        __N_SOURCE: ::std::os::raw::c_int,
    ) {
        imaging_setup2(
            self,
            __N_PX_PUPIL,
            __N_SIDE_LENSLET,
            DFT_osf,
            N_PX_IMAGE_,
            CAMERA_osf,
            __N_SOURCE,
        )
    }
    #[inline]
    pub unsafe fn setup3(
        &mut self,
        __N_PX_PUPIL: ::std::os::raw::c_int,
        __N_SIDE_LENSLET: ::std::os::raw::c_int,
        DFT_osf: ::std::os::raw::c_int,
        N_PX_IMAGE_: ::std::os::raw::c_int,
        BIN_IMAGE: ::std::os::raw::c_int,
        __N_SOURCE: ::std::os::raw::c_int,
    ) {
        imaging_setup3(
            self,
            __N_PX_PUPIL,
            __N_SIDE_LENSLET,
            DFT_osf,
            N_PX_IMAGE_,
            BIN_IMAGE,
            __N_SOURCE,
        )
    }
    #[inline]
    pub unsafe fn setupSegmentPistonSensor(
        &mut self,
        __N_PX_PUPIL: ::std::os::raw::c_int,
        __N_SIDE_LENSLET: ::std::os::raw::c_int,
        _N_DFT_: ::std::os::raw::c_int,
        N_PX_IMAGE_: ::std::os::raw::c_int,
        _BIN_IMAGE_: ::std::os::raw::c_int,
        __N_SOURCE: ::std::os::raw::c_int,
    ) {
        imaging_setupSegmentPistonSensor(
            self,
            __N_PX_PUPIL,
            __N_SIDE_LENSLET,
            _N_DFT_,
            N_PX_IMAGE_,
            _BIN_IMAGE_,
            __N_SOURCE,
        )
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        imaging_cleanup(self)
    }
    #[inline]
    pub unsafe fn cleanupSegmentPistonSensor(&mut self) {
        imaging_cleanupSegmentPistonSensor(self)
    }
    #[inline]
    pub unsafe fn set_pointing_direction(&mut self, zen: *mut f32, azim: *mut f32) {
        imaging_set_pointing_direction(self, zen, azim)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        imaging_reset(self)
    }
    #[inline]
    pub unsafe fn reset_rng(&mut self, SEED: ::std::os::raw::c_int) {
        imaging_reset_rng(self, SEED)
    }
    #[inline]
    pub unsafe fn propagate(&mut self, src: *mut source) {
        imaging_propagate(self, src)
    }
    #[inline]
    pub unsafe fn propagate_cpx(&mut self, src: *mut source) {
        imaging_propagate_cpx(self, src)
    }
    #[inline]
    pub unsafe fn propagateNoOverlap(&mut self, src: *mut source) {
        imaging_propagateNoOverlap(self, src)
    }
    #[inline]
    pub unsafe fn propagateNoOverlapBare(&mut self, src: *mut source) {
        imaging_propagateNoOverlapBare(self, src)
    }
    #[inline]
    pub unsafe fn propagateNoOverlapSPS(&mut self, src: *mut source, d: f32, wavenumber: f32) {
        imaging_propagateNoOverlapSPS(self, src, d, wavenumber)
    }
    #[inline]
    pub unsafe fn propagateTT7(&mut self, src: *mut source) {
        imaging_propagateTT7(self, src)
    }
    #[inline]
    pub unsafe fn propagateTT71(
        &mut self,
        src: *mut source,
        d__piston_mask: *mut ::std::os::raw::c_int,
    ) {
        imaging_propagateTT71(self, src, d__piston_mask)
    }
    #[inline]
    pub unsafe fn propagateThroughFieldStop(&mut self, src: *mut source, field_stop_diam: f32) {
        imaging_propagateThroughFieldStop(self, src, field_stop_diam)
    }
    #[inline]
    pub unsafe fn propagateThroughPyramid(&mut self, src: *mut source, alpha: f32) {
        imaging_propagateThroughPyramid(self, src, alpha)
    }
    #[inline]
    pub unsafe fn propagateThroughModulatedPyramid(
        &mut self,
        src: *mut source,
        modulation: f32,
        modulation_sampling: ::std::os::raw::c_int,
        alpha: f32,
    ) {
        imaging_propagateThroughModulatedPyramid(self, src, modulation, modulation_sampling, alpha)
    }
    #[inline]
    pub unsafe fn readout(&mut self, exposureTime: f32, readOutNoiseRms: f32) {
        imaging_readout(self, exposureTime, readOutNoiseRms)
    }
    #[inline]
    pub unsafe fn noiseless_readout(&mut self, exposureTime: f32) {
        imaging_noiseless_readout(self, exposureTime)
    }
    #[inline]
    pub unsafe fn readout1(
        &mut self,
        exposureTime: f32,
        readOutNoiseRms: f32,
        nBackgroundPhoton: f32,
        noiseFactor: f32,
    ) {
        imaging_readout1(
            self,
            exposureTime,
            readOutNoiseRms,
            nBackgroundPhoton,
            noiseFactor,
        )
    }
    #[inline]
    pub unsafe fn strehl_ratio(&mut self, ref_: *mut imaging) -> f32 {
        imaging_strehl_ratio(self, ref_)
    }
    #[inline]
    pub unsafe fn info(&mut self) {
        imaging_info(self)
    }
    #[inline]
    pub unsafe fn frame2file(&mut self, filename: *const ::std::os::raw::c_char) {
        imaging_frame2file(self, filename)
    }
    #[inline]
    pub unsafe fn show_frame(&mut self, filename: *mut ::std::os::raw::c_char) {
        imaging_show_frame(self, filename)
    }
    #[inline]
    pub unsafe fn show_frame1(
        &mut self,
        filename: *mut ::std::os::raw::c_char,
        ref_: *mut imaging,
    ) {
        imaging_show_frame1(self, filename, ref_)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct centroiding {
    pub _N_SIDE_LENSLET_: ::std::os::raw::c_int,
    pub N_LENSLET: ::std::os::raw::c_int,
    pub N_SOURCE: ::std::os::raw::c_int,
    pub d__c: *mut f32,
    pub d__cx: *mut f32,
    pub d__cy: *mut f32,
    pub d__mass: *mut f32,
    pub lenslet_mask: *mut ::std::os::raw::c_char,
    pub MASK_SET: ::std::os::raw::c_char,
    pub n_data: ::std::os::raw::c_int,
    pub DEV_SHARED_MEM: ::std::os::raw::c_int,
    pub DEV_MAX_THREADS: ::std::os::raw::c_int,
    pub handle: cublasHandle_t,
    pub status: cublasStatus_t,
}
#[test]
fn bindgen_test_layout_centroiding() {
    assert_eq!(
        ::std::mem::size_of::<centroiding>(),
        88usize,
        concat!("Size of: ", stringify!(centroiding))
    );
    assert_eq!(
        ::std::mem::align_of::<centroiding>(),
        8usize,
        concat!("Alignment of ", stringify!(centroiding))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>()))._N_SIDE_LENSLET_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(_N_SIDE_LENSLET_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).N_LENSLET as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(N_LENSLET)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).N_SOURCE as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(N_SOURCE)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).d__c as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(d__c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).d__cx as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(d__cx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).d__cy as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(d__cy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).d__mass as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(d__mass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).lenslet_mask as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(lenslet_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).MASK_SET as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(MASK_SET)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).n_data as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(n_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).DEV_SHARED_MEM as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(DEV_SHARED_MEM)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).DEV_MAX_THREADS as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(DEV_MAX_THREADS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).handle as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<centroiding>())).status as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(centroiding),
            "::",
            stringify!(status)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding5setupEii"]
    pub fn centroiding_setup(
        this: *mut centroiding,
        _N_SIDE_LENSLET: ::std::os::raw::c_int,
        _N_SOURCE: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding7cleanupEv"]
    pub fn centroiding_cleanup(this: *mut centroiding);
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding8get_dataEP7imaging"]
    pub fn centroiding_get_data(this: *mut centroiding, wfs: *mut imaging);
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding8get_dataEPfi"]
    pub fn centroiding_get_data1(this: *mut centroiding, frame: *mut f32, N: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding8get_dataEPfifff"]
    pub fn centroiding_get_data2(
        this: *mut centroiding,
        frame: *mut f32,
        N: ::std::os::raw::c_int,
        cx0: f32,
        cy0: f32,
        units: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding8get_dataEPfiS0_S0_fPc"]
    pub fn centroiding_get_data3(
        this: *mut centroiding,
        frame: *mut f32,
        N: ::std::os::raw::c_int,
        cx0: *mut f32,
        cy0: *mut f32,
        units: f32,
        valid_lenset: *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding14show_centroidsEPc"]
    pub fn centroiding_show_centroids(
        this: *mut centroiding,
        filename: *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding9show_fluxEPc"]
    pub fn centroiding_show_flux(this: *mut centroiding, filename: *mut ::std::os::raw::c_char);
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding14fried_geometryEP4maskS1_if"]
    pub fn centroiding_fried_geometry(
        this: *mut centroiding,
        dm: *mut mask,
        pupil: *mut mask,
        n: ::std::os::raw::c_int,
        threshold: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding6filterEPf"]
    pub fn centroiding_filter(this: *mut centroiding, F: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding7noisifyEf"]
    pub fn centroiding_noisify(this: *mut centroiding, stddev: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN11centroiding5resetEv"]
    pub fn centroiding_reset(this: *mut centroiding);
}
impl centroiding {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        _N_SIDE_LENSLET: ::std::os::raw::c_int,
        _N_SOURCE: ::std::os::raw::c_int,
    ) {
        centroiding_setup(self, _N_SIDE_LENSLET, _N_SOURCE)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        centroiding_cleanup(self)
    }
    #[inline]
    pub unsafe fn get_data(&mut self, wfs: *mut imaging) {
        centroiding_get_data(self, wfs)
    }
    #[inline]
    pub unsafe fn get_data1(&mut self, frame: *mut f32, N: ::std::os::raw::c_int) {
        centroiding_get_data1(self, frame, N)
    }
    #[inline]
    pub unsafe fn get_data2(
        &mut self,
        frame: *mut f32,
        N: ::std::os::raw::c_int,
        cx0: f32,
        cy0: f32,
        units: f32,
    ) {
        centroiding_get_data2(self, frame, N, cx0, cy0, units)
    }
    #[inline]
    pub unsafe fn get_data3(
        &mut self,
        frame: *mut f32,
        N: ::std::os::raw::c_int,
        cx0: *mut f32,
        cy0: *mut f32,
        units: f32,
        valid_lenset: *mut ::std::os::raw::c_char,
    ) {
        centroiding_get_data3(self, frame, N, cx0, cy0, units, valid_lenset)
    }
    #[inline]
    pub unsafe fn show_centroids(&mut self, filename: *mut ::std::os::raw::c_char) {
        centroiding_show_centroids(self, filename)
    }
    #[inline]
    pub unsafe fn show_flux(&mut self, filename: *mut ::std::os::raw::c_char) {
        centroiding_show_flux(self, filename)
    }
    #[inline]
    pub unsafe fn fried_geometry(
        &mut self,
        dm: *mut mask,
        pupil: *mut mask,
        n: ::std::os::raw::c_int,
        threshold: f32,
    ) {
        centroiding_fried_geometry(self, dm, pupil, n, threshold)
    }
    #[inline]
    pub unsafe fn filter(&mut self, F: *mut f32) {
        centroiding_filter(self, F)
    }
    #[inline]
    pub unsafe fn noisify(&mut self, stddev: f32) {
        centroiding_noisify(self, stddev)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        centroiding_reset(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shackHartmann {
    pub N_WFS: ::std::os::raw::c_int,
    pub N_SIDE_LENSLET: ::std::os::raw::c_int,
    pub N_LENSLET: ::std::os::raw::c_int,
    pub N_ACTUATOR: ::std::os::raw::c_int,
    pub N_SLOPE: ::std::os::raw::c_int,
    pub d__c0: *mut f32,
    pub d__cx0: *mut f32,
    pub d__cy0: *mut f32,
    pub valid_lenslet: mask,
    pub valid_actuator: mask,
    pub camera: imaging,
    pub data_proc: centroiding,
    pub DFT_osf: ::std::os::raw::c_int,
    pub lenslet_pitch: f32,
    pub pixel_scale: f32,
    pub intensity_threshold: f32,
    pub slopes_gain: f32,
}
#[test]
fn bindgen_test_layout_shackHartmann() {
    assert_eq!(
        ::std::mem::size_of::<shackHartmann>(),
        464usize,
        concat!("Size of: ", stringify!(shackHartmann))
    );
    assert_eq!(
        ::std::mem::align_of::<shackHartmann>(),
        8usize,
        concat!("Alignment of ", stringify!(shackHartmann))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).N_WFS as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(N_WFS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).N_SIDE_LENSLET as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(N_SIDE_LENSLET)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).N_LENSLET as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(N_LENSLET)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).N_ACTUATOR as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(N_ACTUATOR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).N_SLOPE as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(N_SLOPE)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).d__c0 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(d__c0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).d__cx0 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(d__cx0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).d__cy0 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(d__cy0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).valid_lenslet as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(valid_lenslet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).valid_actuator as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(valid_actuator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).camera as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(camera)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).data_proc as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(data_proc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).DFT_osf as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(DFT_osf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).lenslet_pitch as *const _ as usize },
        444usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(lenslet_pitch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).pixel_scale as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(pixel_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<shackHartmann>())).intensity_threshold as *const _ as usize
        },
        452usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(intensity_threshold)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shackHartmann>())).slopes_gain as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(shackHartmann),
            "::",
            stringify!(slopes_gain)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann5setupEiifiiii"]
    pub fn shackHartmann_setup(
        this: *mut shackHartmann,
        N_SIDE_LENSLET: ::std::os::raw::c_int,
        N_PX_LENSLET: ::std::os::raw::c_int,
        d: f32,
        DFT_osf_: ::std::os::raw::c_int,
        N_PX_IMAGE: ::std::os::raw::c_int,
        BIN_IMAGE: ::std::os::raw::c_int,
        N_GS: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann7cleanupEv"]
    pub fn shackHartmann_cleanup(this: *mut shackHartmann);
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann22identify_valid_lensletEP6sourcef"]
    pub fn shackHartmann_identify_valid_lenslet(
        this: *mut shackHartmann,
        src: *mut source,
        threshold: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann20set_reference_slopesEP6source"]
    pub fn shackHartmann_set_reference_slopes(this: *mut shackHartmann, src: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann9calibrateEP6sourcef"]
    pub fn shackHartmann_calibrate(this: *mut shackHartmann, src: *mut source, threshold: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann9propagateEP6source"]
    pub fn shackHartmann_propagate(this: *mut shackHartmann, gs: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann9propagateEP6sourcePi"]
    pub fn shackHartmann_propagate1(
        this: *mut shackHartmann,
        gs: *mut source,
        maks: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann7processEv"]
    pub fn shackHartmann_process(this: *mut shackHartmann);
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann7analyzeEP6source"]
    pub fn shackHartmann_analyze(this: *mut shackHartmann, gs: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann26get_valid_reference_slopesEPf"]
    pub fn shackHartmann_get_valid_reference_slopes(
        this: *mut shackHartmann,
        d__valid_slopes: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann16get_valid_slopesEPf"]
    pub fn shackHartmann_get_valid_slopes(this: *mut shackHartmann, d__valid_slopes: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann13masked_slopesEPfP4mask"]
    pub fn shackHartmann_masked_slopes(
        this: *mut shackHartmann,
        d__valid_slopes: *mut f32,
        lenslet_mask: *mut mask,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann21get_valid_slopes_normEPf"]
    pub fn shackHartmann_get_valid_slopes_norm(
        this: *mut shackHartmann,
        d__valid_slopes_norm: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann17get_frame_dev_ptrEv"]
    pub fn shackHartmann_get_frame_dev_ptr(this: *mut shackHartmann) -> *mut f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN13shackHartmann14update_lensletEPf"]
    pub fn shackHartmann_update_lenslet(this: *mut shackHartmann, filter: *mut f32);
}
impl shackHartmann {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        N_SIDE_LENSLET: ::std::os::raw::c_int,
        N_PX_LENSLET: ::std::os::raw::c_int,
        d: f32,
        DFT_osf_: ::std::os::raw::c_int,
        N_PX_IMAGE: ::std::os::raw::c_int,
        BIN_IMAGE: ::std::os::raw::c_int,
        N_GS: ::std::os::raw::c_int,
    ) {
        shackHartmann_setup(
            self,
            N_SIDE_LENSLET,
            N_PX_LENSLET,
            d,
            DFT_osf_,
            N_PX_IMAGE,
            BIN_IMAGE,
            N_GS,
        )
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        shackHartmann_cleanup(self)
    }
    #[inline]
    pub unsafe fn identify_valid_lenslet(&mut self, src: *mut source, threshold: f32) {
        shackHartmann_identify_valid_lenslet(self, src, threshold)
    }
    #[inline]
    pub unsafe fn set_reference_slopes(&mut self, src: *mut source) {
        shackHartmann_set_reference_slopes(self, src)
    }
    #[inline]
    pub unsafe fn calibrate(&mut self, src: *mut source, threshold: f32) {
        shackHartmann_calibrate(self, src, threshold)
    }
    #[inline]
    pub unsafe fn propagate(&mut self, gs: *mut source) {
        shackHartmann_propagate(self, gs)
    }
    #[inline]
    pub unsafe fn propagate1(&mut self, gs: *mut source, maks: *mut ::std::os::raw::c_int) {
        shackHartmann_propagate1(self, gs, maks)
    }
    #[inline]
    pub unsafe fn process(&mut self) {
        shackHartmann_process(self)
    }
    #[inline]
    pub unsafe fn analyze(&mut self, gs: *mut source) {
        shackHartmann_analyze(self, gs)
    }
    #[inline]
    pub unsafe fn get_valid_reference_slopes(&mut self, d__valid_slopes: *mut f32) {
        shackHartmann_get_valid_reference_slopes(self, d__valid_slopes)
    }
    #[inline]
    pub unsafe fn get_valid_slopes(&mut self, d__valid_slopes: *mut f32) {
        shackHartmann_get_valid_slopes(self, d__valid_slopes)
    }
    #[inline]
    pub unsafe fn masked_slopes(&mut self, d__valid_slopes: *mut f32, lenslet_mask: *mut mask) {
        shackHartmann_masked_slopes(self, d__valid_slopes, lenslet_mask)
    }
    #[inline]
    pub unsafe fn get_valid_slopes_norm(&mut self, d__valid_slopes_norm: *mut f32) {
        shackHartmann_get_valid_slopes_norm(self, d__valid_slopes_norm)
    }
    #[inline]
    pub unsafe fn get_frame_dev_ptr(&mut self) -> *mut f32 {
        shackHartmann_get_frame_dev_ptr(self)
    }
    #[inline]
    pub unsafe fn update_lenslet(&mut self, filter: *mut f32) {
        shackHartmann_update_lenslet(self, filter)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct geometricShackHartmann {
    pub N_WFS: ::std::os::raw::c_int,
    pub N_SIDE_LENSLET: ::std::os::raw::c_int,
    pub N_LENSLET: ::std::os::raw::c_int,
    pub N_ACTUATOR: ::std::os::raw::c_int,
    pub N_SLOPE: ::std::os::raw::c_int,
    pub d__c0: *mut f32,
    pub d__cx0: *mut f32,
    pub d__cy0: *mut f32,
    pub valid_lenslet: mask,
    pub valid_actuator: mask,
    pub camera: imaging,
    pub data_proc: centroiding,
    pub DFT_osf: ::std::os::raw::c_int,
    pub lenslet_pitch: f32,
    pub pixel_scale: f32,
    pub intensity_threshold: f32,
    pub slopes_gain: f32,
    pub _d__c_: *mut f32,
    pub _d__cx_: *mut f32,
    pub _d__cy_: *mut f32,
    pub N_FRAME: ::std::os::raw::c_int,
    pub handle: cublasHandle_t,
}
#[test]
fn bindgen_test_layout_geometricShackHartmann() {
    assert_eq!(
        ::std::mem::size_of::<geometricShackHartmann>(),
        504usize,
        concat!("Size of: ", stringify!(geometricShackHartmann))
    );
    assert_eq!(
        ::std::mem::align_of::<geometricShackHartmann>(),
        8usize,
        concat!("Alignment of ", stringify!(geometricShackHartmann))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>())).N_WFS as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(N_WFS)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<geometricShackHartmann>())).N_SIDE_LENSLET as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(N_SIDE_LENSLET)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<geometricShackHartmann>())).N_LENSLET as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(N_LENSLET)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<geometricShackHartmann>())).N_ACTUATOR as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(N_ACTUATOR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>())).N_SLOPE as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(N_SLOPE)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>())).d__c0 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(d__c0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>())).d__cx0 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(d__cx0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>())).d__cy0 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(d__cy0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<geometricShackHartmann>())).valid_lenslet as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(valid_lenslet)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<geometricShackHartmann>())).valid_actuator as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(valid_actuator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>())).camera as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(camera)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<geometricShackHartmann>())).data_proc as *const _ as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(data_proc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>())).DFT_osf as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(DFT_osf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<geometricShackHartmann>())).lenslet_pitch as *const _ as usize
        },
        444usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(lenslet_pitch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<geometricShackHartmann>())).pixel_scale as *const _ as usize
        },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(pixel_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<geometricShackHartmann>())).intensity_threshold as *const _
                as usize
        },
        452usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(intensity_threshold)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<geometricShackHartmann>())).slopes_gain as *const _ as usize
        },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(slopes_gain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>()))._d__c_ as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(_d__c_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>()))._d__cx_ as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(_d__cx_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>()))._d__cy_ as *const _ as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(_d__cy_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>())).N_FRAME as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(N_FRAME)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<geometricShackHartmann>())).handle as *const _ as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(geometricShackHartmann),
            "::",
            stringify!(handle)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann5setupEifi"]
    pub fn geometricShackHartmann_setup(
        this: *mut geometricShackHartmann,
        N_SIDE_LENSLET: ::std::os::raw::c_int,
        d: f32,
        N_GS: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann7cleanupEv"]
    pub fn geometricShackHartmann_cleanup(this: *mut geometricShackHartmann);
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann22identify_valid_lensletEP6sourcef"]
    pub fn geometricShackHartmann_identify_valid_lenslet(
        this: *mut geometricShackHartmann,
        src: *mut source,
        threshold: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann20set_reference_slopesEP6source"]
    pub fn geometricShackHartmann_set_reference_slopes(
        this: *mut geometricShackHartmann,
        src: *mut source,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann9calibrateEP6sourcef"]
    pub fn geometricShackHartmann_calibrate(
        this: *mut geometricShackHartmann,
        src: *mut source,
        threshold: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann9propagateEP6source"]
    pub fn geometricShackHartmann_propagate(this: *mut geometricShackHartmann, gs: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann9propagateEP6sourcePi"]
    pub fn geometricShackHartmann_propagate1(
        this: *mut geometricShackHartmann,
        gs: *mut source,
        maks: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann7processEv"]
    pub fn geometricShackHartmann_process(this: *mut geometricShackHartmann);
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann7analyzeEP6source"]
    pub fn geometricShackHartmann_analyze(this: *mut geometricShackHartmann, gs: *mut source);
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann26get_valid_reference_slopesEPf"]
    pub fn geometricShackHartmann_get_valid_reference_slopes(
        this: *mut geometricShackHartmann,
        d__valid_slopes: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann16get_valid_slopesEPf"]
    pub fn geometricShackHartmann_get_valid_slopes(
        this: *mut geometricShackHartmann,
        d__valid_slopes: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann13masked_slopesEPfP4mask"]
    pub fn geometricShackHartmann_masked_slopes(
        this: *mut geometricShackHartmann,
        d__valid_slopes: *mut f32,
        lenslet_mask: *mut mask,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann21get_valid_slopes_normEPf"]
    pub fn geometricShackHartmann_get_valid_slopes_norm(
        this: *mut geometricShackHartmann,
        d__valid_slopes_norm: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann13folded_slopesEPfP4mask"]
    pub fn geometricShackHartmann_folded_slopes(
        this: *mut geometricShackHartmann,
        d__valid_slopes: *mut f32,
        lenslet_mask: *mut mask,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN22geometricShackHartmann5resetEv"]
    pub fn geometricShackHartmann_reset(this: *mut geometricShackHartmann);
}
impl geometricShackHartmann {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        N_SIDE_LENSLET: ::std::os::raw::c_int,
        d: f32,
        N_GS: ::std::os::raw::c_int,
    ) {
        geometricShackHartmann_setup(self, N_SIDE_LENSLET, d, N_GS)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        geometricShackHartmann_cleanup(self)
    }
    #[inline]
    pub unsafe fn identify_valid_lenslet(&mut self, src: *mut source, threshold: f32) {
        geometricShackHartmann_identify_valid_lenslet(self, src, threshold)
    }
    #[inline]
    pub unsafe fn set_reference_slopes(&mut self, src: *mut source) {
        geometricShackHartmann_set_reference_slopes(self, src)
    }
    #[inline]
    pub unsafe fn calibrate(&mut self, src: *mut source, threshold: f32) {
        geometricShackHartmann_calibrate(self, src, threshold)
    }
    #[inline]
    pub unsafe fn propagate(&mut self, gs: *mut source) {
        geometricShackHartmann_propagate(self, gs)
    }
    #[inline]
    pub unsafe fn propagate1(&mut self, gs: *mut source, maks: *mut ::std::os::raw::c_int) {
        geometricShackHartmann_propagate1(self, gs, maks)
    }
    #[inline]
    pub unsafe fn process(&mut self) {
        geometricShackHartmann_process(self)
    }
    #[inline]
    pub unsafe fn analyze(&mut self, gs: *mut source) {
        geometricShackHartmann_analyze(self, gs)
    }
    #[inline]
    pub unsafe fn get_valid_reference_slopes(&mut self, d__valid_slopes: *mut f32) {
        geometricShackHartmann_get_valid_reference_slopes(self, d__valid_slopes)
    }
    #[inline]
    pub unsafe fn get_valid_slopes(&mut self, d__valid_slopes: *mut f32) {
        geometricShackHartmann_get_valid_slopes(self, d__valid_slopes)
    }
    #[inline]
    pub unsafe fn masked_slopes(&mut self, d__valid_slopes: *mut f32, lenslet_mask: *mut mask) {
        geometricShackHartmann_masked_slopes(self, d__valid_slopes, lenslet_mask)
    }
    #[inline]
    pub unsafe fn get_valid_slopes_norm(&mut self, d__valid_slopes_norm: *mut f32) {
        geometricShackHartmann_get_valid_slopes_norm(self, d__valid_slopes_norm)
    }
    #[inline]
    pub unsafe fn folded_slopes(&mut self, d__valid_slopes: *mut f32, lenslet_mask: *mut mask) {
        geometricShackHartmann_folded_slopes(self, d__valid_slopes, lenslet_mask)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        geometricShackHartmann_reset(self)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct modes {
    pub d__x_BM: *mut f64,
    pub d__y_BM: *mut f64,
    pub d__BM: *mut f64,
    pub d__BMS: *mut f64,
    pub BM_radius: f64,
    pub BM_N_SAMPLE: ::std::os::raw::c_int,
    pub d__BM_buffer: *mut f64,
    pub n_mode: ::std::os::raw::c_int,
    pub b: *mut rtd,
    pub d__b: *mut rtd,
    pub N: ::std::os::raw::c_int,
    pub filename: [::std::os::raw::c_char; 256usize],
    pub N_SET: ::std::os::raw::c_int,
    pub N_MODE: ::std::os::raw::c_int,
    pub d__s2b: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_modes() {
    assert_eq!(
        ::std::mem::size_of::<modes>(),
        360usize,
        concat!("Size of: ", stringify!(modes))
    );
    assert_eq!(
        ::std::mem::align_of::<modes>(),
        8usize,
        concat!("Alignment of ", stringify!(modes))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).d__x_BM as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(d__x_BM)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).d__y_BM as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(d__y_BM)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).d__BM as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(d__BM)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).d__BMS as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(d__BMS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).BM_radius as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(BM_radius)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).BM_N_SAMPLE as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(BM_N_SAMPLE)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).d__BM_buffer as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(d__BM_buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).n_mode as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(n_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).b as *const _ as usize },
        64usize,
        concat!("Offset of field: ", stringify!(modes), "::", stringify!(b))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).d__b as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(d__b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).N as *const _ as usize },
        80usize,
        concat!("Offset of field: ", stringify!(modes), "::", stringify!(N))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).filename as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(filename)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).N_SET as *const _ as usize },
        340usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(N_SET)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).N_MODE as *const _ as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(N_MODE)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<modes>())).d__s2b as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(modes),
            "::",
            stringify!(d__s2b)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5modes5setupEPcii"]
    pub fn modes_setup(
        this: *mut modes,
        filename: *mut ::std::os::raw::c_char,
        N: ::std::os::raw::c_int,
        n_mode: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5modes5setupEidiiPiPdii"]
    pub fn modes_setup1(
        this: *mut modes,
        _BM_N_SAMPLE_: ::std::os::raw::c_int,
        _BM_radius_: f64,
        _N_SET_: ::std::os::raw::c_int,
        _N_MODE_: ::std::os::raw::c_int,
        s2b: *mut ::std::os::raw::c_int,
        buffer: *mut f64,
        _N_: ::std::os::raw::c_int,
        _n_mode_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5modes7cleanupEv"]
    pub fn modes_cleanup(this: *mut modes);
}
extern "C" {
    #[link_name = "\u{1}_ZN5modes4loadEv"]
    pub fn modes_load(this: *mut modes);
}
extern "C" {
    #[link_name = "\u{1}_ZN5modes4loadEidiiPiPd"]
    pub fn modes_load1(
        this: *mut modes,
        _BM_N_SAMPLE_: ::std::os::raw::c_int,
        _BM_radius_: f64,
        _N_SET_: ::std::os::raw::c_int,
        _N_MODE_: ::std::os::raw::c_int,
        s2b: *mut ::std::os::raw::c_int,
        buffer: *mut f64,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5modes11reset_modesEPd"]
    pub fn modes_reset_modes(this: *mut modes, buffer: *mut f64);
}
extern "C" {
    #[link_name = "\u{1}_ZN5modes6updateEPd"]
    pub fn modes_update(this: *mut modes, b: *mut rtd);
}
impl modes {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        filename: *mut ::std::os::raw::c_char,
        N: ::std::os::raw::c_int,
        n_mode: ::std::os::raw::c_int,
    ) {
        modes_setup(self, filename, N, n_mode)
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        _BM_N_SAMPLE_: ::std::os::raw::c_int,
        _BM_radius_: f64,
        _N_SET_: ::std::os::raw::c_int,
        _N_MODE_: ::std::os::raw::c_int,
        s2b: *mut ::std::os::raw::c_int,
        buffer: *mut f64,
        _N_: ::std::os::raw::c_int,
        _n_mode_: ::std::os::raw::c_int,
    ) {
        modes_setup1(
            self,
            _BM_N_SAMPLE_,
            _BM_radius_,
            _N_SET_,
            _N_MODE_,
            s2b,
            buffer,
            _N_,
            _n_mode_,
        )
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        modes_cleanup(self)
    }
    #[inline]
    pub unsafe fn load(&mut self) {
        modes_load(self)
    }
    #[inline]
    pub unsafe fn load1(
        &mut self,
        _BM_N_SAMPLE_: ::std::os::raw::c_int,
        _BM_radius_: f64,
        _N_SET_: ::std::os::raw::c_int,
        _N_MODE_: ::std::os::raw::c_int,
        s2b: *mut ::std::os::raw::c_int,
        buffer: *mut f64,
    ) {
        modes_load1(
            self,
            _BM_N_SAMPLE_,
            _BM_radius_,
            _N_SET_,
            _N_MODE_,
            s2b,
            buffer,
        )
    }
    #[inline]
    pub unsafe fn reset_modes(&mut self, buffer: *mut f64) {
        modes_reset_modes(self, buffer)
    }
    #[inline]
    pub unsafe fn update(&mut self, b: *mut rtd) {
        modes_update(self, b)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct gmt_m1 {
    pub M_ID: ::std::os::raw::c_int,
    pub D_assembly: rtd,
    pub D_clear: rtd,
    pub D_full: rtd,
    pub ri: rtd,
    pub beta: rtd,
    pub L: rtd,
    pub area0: rtd,
    pub area_fraction: rtd,
    pub area0_px: f32,
    pub area: rtd,
    pub N: ::std::os::raw::c_int,
    pub depth: rtd,
    pub aperture_CS: coordinate_system,
    pub conic_CS: coordinate_system,
    pub conic_origin: [vector; 7usize],
    pub d__conic_origin: *mut vector,
    pub conic_c: rtd,
    pub conic_k: rtd,
    pub d__conic_c: *mut rtd,
    pub d__conic_k: *mut rtd,
    pub rigid_body_CS: coordinate_system,
    pub motion_CS: coordinate_system,
    pub height: rtd,
    pub V: *mut mask,
    pub idx_offset: ::std::os::raw::c_int,
    pub ZS: *mut zernikeS,
    pub d__piston_mask: *mut ::std::os::raw::c_int,
    pub TT_CS: coordinate_system,
    pub d__C: *mut f64,
    pub d__D: *mut f64,
    pub handle: cublasHandle_t,
    pub d__valid_segments: *mut ::std::os::raw::c_char,
    pub BS: modes,
    pub d__segment_reflectivity: *mut f32,
}
#[test]
fn bindgen_test_layout_gmt_m1() {
    assert_eq!(
        ::std::mem::size_of::<gmt_m1>(),
        1192usize,
        concat!("Size of: ", stringify!(gmt_m1))
    );
    assert_eq!(
        ::std::mem::align_of::<gmt_m1>(),
        8usize,
        concat!("Alignment of ", stringify!(gmt_m1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).M_ID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(M_ID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).D_assembly as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(D_assembly)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).D_clear as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(D_clear)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).D_full as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(D_full)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).ri as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(ri)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).beta as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(beta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).L as *const _ as usize },
        48usize,
        concat!("Offset of field: ", stringify!(gmt_m1), "::", stringify!(L))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).area0 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(area0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).area_fraction as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(area_fraction)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).area0_px as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(area0_px)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).area as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).N as *const _ as usize },
        88usize,
        concat!("Offset of field: ", stringify!(gmt_m1), "::", stringify!(N))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).depth as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).aperture_CS as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(aperture_CS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).conic_CS as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(conic_CS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).conic_origin as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(conic_origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).d__conic_origin as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(d__conic_origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).conic_c as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(conic_c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).conic_k as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(conic_k)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).d__conic_c as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(d__conic_c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).d__conic_k as *const _ as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(d__conic_k)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).rigid_body_CS as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(rigid_body_CS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).motion_CS as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(motion_CS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).height as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).V as *const _ as usize },
        672usize,
        concat!("Offset of field: ", stringify!(gmt_m1), "::", stringify!(V))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).idx_offset as *const _ as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(idx_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).ZS as *const _ as usize },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(ZS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).d__piston_mask as *const _ as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(d__piston_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).TT_CS as *const _ as usize },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(TT_CS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).d__C as *const _ as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(d__C)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).d__D as *const _ as usize },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(d__D)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).handle as *const _ as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).d__valid_segments as *const _ as usize },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(d__valid_segments)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).BS as *const _ as usize },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(BS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m1>())).d__segment_reflectivity as *const _ as usize },
        1184usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m1),
            "::",
            stringify!(d__segment_reflectivity)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m15setupEv"]
    pub fn gmt_m1_setup(this: *mut gmt_m1);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m15setupEPcii"]
    pub fn gmt_m1_setup1(
        this: *mut gmt_m1,
        _filename_: *mut ::std::os::raw::c_char,
        _N_: ::std::os::raw::c_int,
        _n_mode_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m15setupEP8zernikeS"]
    pub fn gmt_m1_setup2(this: *mut gmt_m1, ZS: *mut zernikeS);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m17cleanupEv"]
    pub fn gmt_m1_cleanup(this: *mut gmt_m1);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m16updateE6vectorS0_i"]
    pub fn gmt_m1_update(
        this: *mut gmt_m1,
        _origin_: vector,
        _euler_angles_: vector,
        idx: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m15resetEv"]
    pub fn gmt_m1_reset(this: *mut gmt_m1);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m15traceEP6bundle"]
    pub fn gmt_m1_trace(this: *mut gmt_m1, rays: *mut bundle);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m18traceallEP6bundle"]
    pub fn gmt_m1_traceall(this: *mut gmt_m1, rays: *mut bundle);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m18blockingEP6bundle"]
    pub fn gmt_m1_blocking(this: *mut gmt_m1, rays: *mut bundle);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m114global_tiptiltEff"]
    pub fn gmt_m1_global_tiptilt(this: *mut gmt_m1, tip: f32, tilt: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m116test_ray_tracingEv"]
    pub fn gmt_m1_test_ray_tracing(this: *mut gmt_m1);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m15trackEPfS0_S0_ii"]
    pub fn gmt_m1_track(
        this: *mut gmt_m1,
        x: *mut f32,
        y: *mut f32,
        z: *mut f32,
        N: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m16locateEPfS0_S0_ii"]
    pub fn gmt_m1_locate(
        this: *mut gmt_m1,
        x: *mut f32,
        y: *mut f32,
        z: *mut f32,
        N: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m16removeEPii"]
    pub fn gmt_m1_remove(
        this: *mut gmt_m1,
        seg_ID: *mut ::std::os::raw::c_int,
        N_ID: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m14keepEPii"]
    pub fn gmt_m1_keep(
        this: *mut gmt_m1,
        seg_ID: *mut ::std::os::raw::c_int,
        N_ID: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m114update_conic_cEPd"]
    pub fn gmt_m1_update_conic_c(this: *mut gmt_m1, _conic_c_: *mut rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m114update_conic_kEPd"]
    pub fn gmt_m1_update_conic_k(this: *mut gmt_m1, _conic_k_: *mut rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m116set_reflectivityEPf"]
    pub fn gmt_m1_set_reflectivity(this: *mut gmt_m1, reflectivity: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m16presetEP6bundled"]
    pub fn gmt_m1_preset(this: *mut gmt_m1, rays: *mut bundle, margin: rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m117edge_sensors_dataEv"]
    pub fn gmt_m1_edge_sensors_data(this: *mut gmt_m1);
}
impl gmt_m1 {
    #[inline]
    pub unsafe fn setup(&mut self) {
        gmt_m1_setup(self)
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        _filename_: *mut ::std::os::raw::c_char,
        _N_: ::std::os::raw::c_int,
        _n_mode_: ::std::os::raw::c_int,
    ) {
        gmt_m1_setup1(self, _filename_, _N_, _n_mode_)
    }
    #[inline]
    pub unsafe fn setup2(&mut self, ZS: *mut zernikeS) {
        gmt_m1_setup2(self, ZS)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        gmt_m1_cleanup(self)
    }
    #[inline]
    pub unsafe fn update(
        &mut self,
        _origin_: vector,
        _euler_angles_: vector,
        idx: ::std::os::raw::c_int,
    ) {
        gmt_m1_update(self, _origin_, _euler_angles_, idx)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        gmt_m1_reset(self)
    }
    #[inline]
    pub unsafe fn trace(&mut self, rays: *mut bundle) {
        gmt_m1_trace(self, rays)
    }
    #[inline]
    pub unsafe fn traceall(&mut self, rays: *mut bundle) {
        gmt_m1_traceall(self, rays)
    }
    #[inline]
    pub unsafe fn blocking(&mut self, rays: *mut bundle) {
        gmt_m1_blocking(self, rays)
    }
    #[inline]
    pub unsafe fn global_tiptilt(&mut self, tip: f32, tilt: f32) {
        gmt_m1_global_tiptilt(self, tip, tilt)
    }
    #[inline]
    pub unsafe fn test_ray_tracing(&mut self) {
        gmt_m1_test_ray_tracing(self)
    }
    #[inline]
    pub unsafe fn track(
        &mut self,
        x: *mut f32,
        y: *mut f32,
        z: *mut f32,
        N: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
    ) {
        gmt_m1_track(self, x, y, z, N, idx)
    }
    #[inline]
    pub unsafe fn locate(
        &mut self,
        x: *mut f32,
        y: *mut f32,
        z: *mut f32,
        N: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
    ) {
        gmt_m1_locate(self, x, y, z, N, idx)
    }
    #[inline]
    pub unsafe fn remove(
        &mut self,
        seg_ID: *mut ::std::os::raw::c_int,
        N_ID: ::std::os::raw::c_int,
    ) {
        gmt_m1_remove(self, seg_ID, N_ID)
    }
    #[inline]
    pub unsafe fn keep(&mut self, seg_ID: *mut ::std::os::raw::c_int, N_ID: ::std::os::raw::c_int) {
        gmt_m1_keep(self, seg_ID, N_ID)
    }
    #[inline]
    pub unsafe fn update_conic_c(&mut self, _conic_c_: *mut rtd) {
        gmt_m1_update_conic_c(self, _conic_c_)
    }
    #[inline]
    pub unsafe fn update_conic_k(&mut self, _conic_k_: *mut rtd) {
        gmt_m1_update_conic_k(self, _conic_k_)
    }
    #[inline]
    pub unsafe fn set_reflectivity(&mut self, reflectivity: *mut f32) {
        gmt_m1_set_reflectivity(self, reflectivity)
    }
    #[inline]
    pub unsafe fn preset(&mut self, rays: *mut bundle, margin: rtd) {
        gmt_m1_preset(self, rays, margin)
    }
    #[inline]
    pub unsafe fn edge_sensors_data(&mut self) {
        gmt_m1_edge_sensors_data(self)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct gmt_m2 {
    pub M_ID: ::std::os::raw::c_int,
    pub D_assembly: rtd,
    pub D_clear: rtd,
    pub D_full: rtd,
    pub ri: rtd,
    pub beta: rtd,
    pub L: rtd,
    pub area0: rtd,
    pub area_fraction: rtd,
    pub area0_px: f32,
    pub area: rtd,
    pub N: ::std::os::raw::c_int,
    pub depth: rtd,
    pub aperture_CS: coordinate_system,
    pub conic_CS: coordinate_system,
    pub conic_origin: [vector; 7usize],
    pub d__conic_origin: *mut vector,
    pub conic_c: rtd,
    pub conic_k: rtd,
    pub d__conic_c: *mut rtd,
    pub d__conic_k: *mut rtd,
    pub rigid_body_CS: coordinate_system,
    pub motion_CS: coordinate_system,
    pub height: rtd,
    pub V: *mut mask,
    pub idx_offset: ::std::os::raw::c_int,
    pub ZS: *mut zernikeS,
    pub d__piston_mask: *mut ::std::os::raw::c_int,
    pub TT_CS: coordinate_system,
    pub d__C: *mut f64,
    pub d__D: *mut f64,
    pub handle: cublasHandle_t,
    pub d__valid_segments: *mut ::std::os::raw::c_char,
    pub BS: modes,
    pub d__segment_reflectivity: *mut f32,
}
#[test]
fn bindgen_test_layout_gmt_m2() {
    assert_eq!(
        ::std::mem::size_of::<gmt_m2>(),
        1192usize,
        concat!("Size of: ", stringify!(gmt_m2))
    );
    assert_eq!(
        ::std::mem::align_of::<gmt_m2>(),
        8usize,
        concat!("Alignment of ", stringify!(gmt_m2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).M_ID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(M_ID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).D_assembly as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(D_assembly)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).D_clear as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(D_clear)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).D_full as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(D_full)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).ri as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(ri)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).beta as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(beta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).L as *const _ as usize },
        48usize,
        concat!("Offset of field: ", stringify!(gmt_m2), "::", stringify!(L))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).area0 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(area0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).area_fraction as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(area_fraction)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).area0_px as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(area0_px)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).area as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).N as *const _ as usize },
        88usize,
        concat!("Offset of field: ", stringify!(gmt_m2), "::", stringify!(N))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).depth as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).aperture_CS as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(aperture_CS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).conic_CS as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(conic_CS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).conic_origin as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(conic_origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).d__conic_origin as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(d__conic_origin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).conic_c as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(conic_c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).conic_k as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(conic_k)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).d__conic_c as *const _ as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(d__conic_c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).d__conic_k as *const _ as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(d__conic_k)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).rigid_body_CS as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(rigid_body_CS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).motion_CS as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(motion_CS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).height as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).V as *const _ as usize },
        672usize,
        concat!("Offset of field: ", stringify!(gmt_m2), "::", stringify!(V))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).idx_offset as *const _ as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(idx_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).ZS as *const _ as usize },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(ZS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).d__piston_mask as *const _ as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(d__piston_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).TT_CS as *const _ as usize },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(TT_CS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).d__C as *const _ as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(d__C)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).d__D as *const _ as usize },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(d__D)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).handle as *const _ as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).d__valid_segments as *const _ as usize },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(d__valid_segments)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).BS as *const _ as usize },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(BS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gmt_m2>())).d__segment_reflectivity as *const _ as usize },
        1184usize,
        concat!(
            "Offset of field: ",
            stringify!(gmt_m2),
            "::",
            stringify!(d__segment_reflectivity)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m25setupEv"]
    pub fn gmt_m2_setup(this: *mut gmt_m2);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m25setupEPcii"]
    pub fn gmt_m2_setup1(
        this: *mut gmt_m2,
        _filename_: *mut ::std::os::raw::c_char,
        _N_: ::std::os::raw::c_int,
        _n_mode_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m25setupEP8zernikeS"]
    pub fn gmt_m2_setup2(this: *mut gmt_m2, ZS: *mut zernikeS);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m27cleanupEv"]
    pub fn gmt_m2_cleanup(this: *mut gmt_m2);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m26updateE6vectorS0_i"]
    pub fn gmt_m2_update(
        this: *mut gmt_m2,
        _origin_: vector,
        _euler_angles_: vector,
        idx: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m25resetEv"]
    pub fn gmt_m2_reset(this: *mut gmt_m2);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m25traceEP6bundle"]
    pub fn gmt_m2_trace(this: *mut gmt_m2, rays: *mut bundle);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m28traceallEP6bundle"]
    pub fn gmt_m2_traceall(this: *mut gmt_m2, rays: *mut bundle);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m28blockingEP6bundle"]
    pub fn gmt_m2_blocking(this: *mut gmt_m2, rays: *mut bundle);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m214global_tiptiltEff"]
    pub fn gmt_m2_global_tiptilt(this: *mut gmt_m2, tip: f32, tilt: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m216test_ray_tracingEv"]
    pub fn gmt_m2_test_ray_tracing(this: *mut gmt_m2);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m25trackEPfS0_S0_ii"]
    pub fn gmt_m2_track(
        this: *mut gmt_m2,
        x: *mut f32,
        y: *mut f32,
        z: *mut f32,
        N: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m26locateEPfS0_S0_ii"]
    pub fn gmt_m2_locate(
        this: *mut gmt_m2,
        x: *mut f32,
        y: *mut f32,
        z: *mut f32,
        N: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m26removeEPii"]
    pub fn gmt_m2_remove(
        this: *mut gmt_m2,
        seg_ID: *mut ::std::os::raw::c_int,
        N_ID: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m24keepEPii"]
    pub fn gmt_m2_keep(
        this: *mut gmt_m2,
        seg_ID: *mut ::std::os::raw::c_int,
        N_ID: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m214update_conic_cEPd"]
    pub fn gmt_m2_update_conic_c(this: *mut gmt_m2, _conic_c_: *mut rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m214update_conic_kEPd"]
    pub fn gmt_m2_update_conic_k(this: *mut gmt_m2, _conic_k_: *mut rtd);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m216set_reflectivityEPf"]
    pub fn gmt_m2_set_reflectivity(this: *mut gmt_m2, reflectivity: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m216pointing_neutralEff"]
    pub fn gmt_m2_pointing_neutral(this: *mut gmt_m2, tip: f32, tilt: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN6gmt_m212coma_neutralEff"]
    pub fn gmt_m2_coma_neutral(this: *mut gmt_m2, tip: f32, tilt: f32);
}
impl gmt_m2 {
    #[inline]
    pub unsafe fn setup(&mut self) {
        gmt_m2_setup(self)
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        _filename_: *mut ::std::os::raw::c_char,
        _N_: ::std::os::raw::c_int,
        _n_mode_: ::std::os::raw::c_int,
    ) {
        gmt_m2_setup1(self, _filename_, _N_, _n_mode_)
    }
    #[inline]
    pub unsafe fn setup2(&mut self, ZS: *mut zernikeS) {
        gmt_m2_setup2(self, ZS)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        gmt_m2_cleanup(self)
    }
    #[inline]
    pub unsafe fn update(
        &mut self,
        _origin_: vector,
        _euler_angles_: vector,
        idx: ::std::os::raw::c_int,
    ) {
        gmt_m2_update(self, _origin_, _euler_angles_, idx)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        gmt_m2_reset(self)
    }
    #[inline]
    pub unsafe fn trace(&mut self, rays: *mut bundle) {
        gmt_m2_trace(self, rays)
    }
    #[inline]
    pub unsafe fn traceall(&mut self, rays: *mut bundle) {
        gmt_m2_traceall(self, rays)
    }
    #[inline]
    pub unsafe fn blocking(&mut self, rays: *mut bundle) {
        gmt_m2_blocking(self, rays)
    }
    #[inline]
    pub unsafe fn global_tiptilt(&mut self, tip: f32, tilt: f32) {
        gmt_m2_global_tiptilt(self, tip, tilt)
    }
    #[inline]
    pub unsafe fn test_ray_tracing(&mut self) {
        gmt_m2_test_ray_tracing(self)
    }
    #[inline]
    pub unsafe fn track(
        &mut self,
        x: *mut f32,
        y: *mut f32,
        z: *mut f32,
        N: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
    ) {
        gmt_m2_track(self, x, y, z, N, idx)
    }
    #[inline]
    pub unsafe fn locate(
        &mut self,
        x: *mut f32,
        y: *mut f32,
        z: *mut f32,
        N: ::std::os::raw::c_int,
        idx: ::std::os::raw::c_int,
    ) {
        gmt_m2_locate(self, x, y, z, N, idx)
    }
    #[inline]
    pub unsafe fn remove(
        &mut self,
        seg_ID: *mut ::std::os::raw::c_int,
        N_ID: ::std::os::raw::c_int,
    ) {
        gmt_m2_remove(self, seg_ID, N_ID)
    }
    #[inline]
    pub unsafe fn keep(&mut self, seg_ID: *mut ::std::os::raw::c_int, N_ID: ::std::os::raw::c_int) {
        gmt_m2_keep(self, seg_ID, N_ID)
    }
    #[inline]
    pub unsafe fn update_conic_c(&mut self, _conic_c_: *mut rtd) {
        gmt_m2_update_conic_c(self, _conic_c_)
    }
    #[inline]
    pub unsafe fn update_conic_k(&mut self, _conic_k_: *mut rtd) {
        gmt_m2_update_conic_k(self, _conic_k_)
    }
    #[inline]
    pub unsafe fn set_reflectivity(&mut self, reflectivity: *mut f32) {
        gmt_m2_set_reflectivity(self, reflectivity)
    }
    #[inline]
    pub unsafe fn pointing_neutral(&mut self, tip: f32, tilt: f32) {
        gmt_m2_pointing_neutral(self, tip, tilt)
    }
    #[inline]
    pub unsafe fn coma_neutral(&mut self, tip: f32, tilt: f32) {
        gmt_m2_coma_neutral(self, tip, tilt)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct layer {
    pub altitude: f32,
    pub xi0: f32,
    pub wind_speed: f32,
    pub wind_direction: f32,
    pub vx: f32,
    pub vy: f32,
    pub WIDTH_LAYER: f32,
    pub LENGTH_LAYER: f32,
    pub N_WIDTH_LAYER: ::std::os::raw::c_int,
    pub N_LENGTH_LAYER: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_layer() {
    assert_eq!(
        ::std::mem::size_of::<layer>(),
        40usize,
        concat!("Size of: ", stringify!(layer))
    );
    assert_eq!(
        ::std::mem::align_of::<layer>(),
        4usize,
        concat!("Alignment of ", stringify!(layer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<layer>())).altitude as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(layer),
            "::",
            stringify!(altitude)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<layer>())).xi0 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(layer),
            "::",
            stringify!(xi0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<layer>())).wind_speed as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(layer),
            "::",
            stringify!(wind_speed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<layer>())).wind_direction as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(layer),
            "::",
            stringify!(wind_direction)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<layer>())).vx as *const _ as usize },
        16usize,
        concat!("Offset of field: ", stringify!(layer), "::", stringify!(vx))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<layer>())).vy as *const _ as usize },
        20usize,
        concat!("Offset of field: ", stringify!(layer), "::", stringify!(vy))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<layer>())).WIDTH_LAYER as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(layer),
            "::",
            stringify!(WIDTH_LAYER)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<layer>())).LENGTH_LAYER as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(layer),
            "::",
            stringify!(LENGTH_LAYER)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<layer>())).N_WIDTH_LAYER as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(layer),
            "::",
            stringify!(N_WIDTH_LAYER)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<layer>())).N_LENGTH_LAYER as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(layer),
            "::",
            stringify!(N_LENGTH_LAYER)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5layer5setupEfffffifif"]
    pub fn layer_setup(
        this: *mut layer,
        _altitude: f32,
        _xi0: f32,
        _wind_speed_: f32,
        _wind_direction: f32,
        W: f32,
        N_W: ::std::os::raw::c_int,
        field_size: f32,
        OSF: ::std::os::raw::c_int,
        duration: f32,
    ) -> ::std::os::raw::c_int;
}
impl layer {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        _altitude: f32,
        _xi0: f32,
        _wind_speed_: f32,
        _wind_direction: f32,
        W: f32,
        N_W: ::std::os::raw::c_int,
        field_size: f32,
        OSF: ::std::os::raw::c_int,
        duration: f32,
    ) -> ::std::os::raw::c_int {
        layer_setup(
            self,
            _altitude,
            _xi0,
            _wind_speed_,
            _wind_direction,
            W,
            N_W,
            field_size,
            OSF,
            duration,
        )
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct profile {
    pub L0: f32,
    pub l0: f32,
    pub L: f32,
    pub f: f32,
    pub delta: f32,
    pub N_k: f32,
    pub N_a: f32,
    pub kmin: f32,
    pub altitude: *mut f32,
    pub xi0: *mut f32,
    pub wind_speed: *mut f32,
    pub wind_direction: *mut f32,
}
#[test]
fn bindgen_test_layout_profile() {
    assert_eq!(
        ::std::mem::size_of::<profile>(),
        64usize,
        concat!("Size of: ", stringify!(profile))
    );
    assert_eq!(
        ::std::mem::align_of::<profile>(),
        8usize,
        concat!("Alignment of ", stringify!(profile))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).L0 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(L0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).l0 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(l0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).L as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(L)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).f as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(f)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).delta as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(delta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).N_k as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(N_k)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).N_a as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(N_a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).kmin as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(kmin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).altitude as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(altitude)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).xi0 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(xi0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).wind_speed as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(wind_speed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<profile>())).wind_direction as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(profile),
            "::",
            stringify!(wind_direction)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7profile5setupEPfS0_S0_S0_i"]
    pub fn profile_setup(
        this: *mut profile,
        altitude: *mut f32,
        xi0: *mut f32,
        wind_speed: *mut f32,
        wind_direction: *mut f32,
        N_LAYER: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7profile7cleanupEv"]
    pub fn profile_cleanup(this: *mut profile);
}
impl profile {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        altitude: *mut f32,
        xi0: *mut f32,
        wind_speed: *mut f32,
        wind_direction: *mut f32,
        N_LAYER: ::std::os::raw::c_int,
    ) {
        profile_setup(self, altitude, xi0, wind_speed, wind_direction, N_LAYER)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        profile_cleanup(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atmosphere {
    pub photometric_band: *mut ::std::os::raw::c_char,
    pub wavelength: f32,
    pub r0: f32,
    pub wavenumber: f32,
    pub N_LAYER: ::std::os::raw::c_int,
    pub field_size: f32,
    pub layers_OSF: ::std::os::raw::c_int,
    pub layers_duration: f32,
    pub layers_tau0: f32,
    pub W: f32,
    pub N_W: ::std::os::raw::c_int,
    pub phase_screen_LAYER: *mut f32,
    pub N_DURATION: ::std::os::raw::c_int,
    pub LOCAL_RAND_SEED: ::std::os::raw::c_int,
    pub ID: ::std::os::raw::c_int,
    pub EPH: f32,
    pub d__phase_screen_LAYER: *mut f32,
    pub N_PHASE_LAYER: ::std::os::raw::c_ulong,
    pub mmap_size: usize,
    pub zeta1: *mut f32,
    pub eta1: *mut f32,
    pub zeta2: *mut f32,
    pub eta2: *mut f32,
    pub devStates: *mut curandState,
    pub turbulence: profile,
    pub d__turbulence: *mut profile,
    pub layers: *mut layer,
    pub d__layers: *mut layer,
}
#[test]
fn bindgen_test_layout_atmosphere() {
    assert_eq!(
        ::std::mem::size_of::<atmosphere>(),
        224usize,
        concat!("Size of: ", stringify!(atmosphere))
    );
    assert_eq!(
        ::std::mem::align_of::<atmosphere>(),
        8usize,
        concat!("Alignment of ", stringify!(atmosphere))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).photometric_band as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(photometric_band)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).wavelength as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(wavelength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).r0 as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(r0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).wavenumber as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(wavenumber)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).N_LAYER as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(N_LAYER)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).field_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(field_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).layers_OSF as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(layers_OSF)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).layers_duration as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(layers_duration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).layers_tau0 as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(layers_tau0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).W as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(W)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).N_W as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(N_W)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).phase_screen_LAYER as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(phase_screen_LAYER)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).N_DURATION as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(N_DURATION)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).LOCAL_RAND_SEED as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(LOCAL_RAND_SEED)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).ID as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(ID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).EPH as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(EPH)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<atmosphere>())).d__phase_screen_LAYER as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(d__phase_screen_LAYER)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).N_PHASE_LAYER as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(N_PHASE_LAYER)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).mmap_size as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(mmap_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).zeta1 as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(zeta1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).eta1 as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(eta1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).zeta2 as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(zeta2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).eta2 as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(eta2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).devStates as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(devStates)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).turbulence as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(turbulence)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).d__turbulence as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(d__turbulence)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).layers as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(layers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<atmosphere>())).d__layers as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(atmosphere),
            "::",
            stringify!(d__layers)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere5setupEffiPfS0_S0_S0_"]
    pub fn atmosphere_setup(
        this: *mut atmosphere,
        r0_: f32,
        L0: f32,
        N_LAYER: ::std::os::raw::c_int,
        altitude: *mut f32,
        xi0: *mut f32,
        wind_speed: *mut f32,
        wind_direction: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere5setupEffiPfS0_S0_S0_fiff"]
    pub fn atmosphere_setup1(
        this: *mut atmosphere,
        r0_: f32,
        L0: f32,
        N_LAYER: ::std::os::raw::c_int,
        altitude: *mut f32,
        xi0: *mut f32,
        wind_speed: *mut f32,
        wind_direction: *mut f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere5setupEffiPfS0_S0_S0_fiffPKci"]
    pub fn atmosphere_setup2(
        this: *mut atmosphere,
        r0_: f32,
        L0: f32,
        _NLAYER: ::std::os::raw::c_int,
        altitude: *mut f32,
        xi0: *mut f32,
        wind_speed: *mut f32,
        wind_direction: *mut f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
        fullpath_to_phasescreens: *const ::std::os::raw::c_char,
        _N_DURATION: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere9gmt_setupEv"]
    pub fn atmosphere_gmt_setup(this: *mut atmosphere);
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere9gmt_setupEff"]
    pub fn atmosphere_gmt_setup1(this: *mut atmosphere, r0_: f32, L0: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere9gmt_setupEfffiff"]
    pub fn atmosphere_gmt_setup2(
        this: *mut atmosphere,
        r0_: f32,
        L0: f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere9gmt_setupEfffiffPKci"]
    pub fn atmosphere_gmt_setup3(
        this: *mut atmosphere,
        r0_: f32,
        L0: f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
        fullpath_to_phasescreens: *const ::std::os::raw::c_char,
        _N_DURATION: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere9gmt_setupEffi"]
    pub fn atmosphere_gmt_setup4(
        this: *mut atmosphere,
        r0_: f32,
        L0: f32,
        _RAND_SEED_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere9gmt_setupEfffiffi"]
    pub fn atmosphere_gmt_setup5(
        this: *mut atmosphere,
        r0_: f32,
        L0: f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
        _RAND_SEED_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere9gmt_setupEfffiffPKcii"]
    pub fn atmosphere_gmt_setup6(
        this: *mut atmosphere,
        r0_: f32,
        L0: f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
        fullpath_to_phasescreens: *const ::std::os::raw::c_char,
        _N_DURATION: ::std::os::raw::c_int,
        _RAND_SEED_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere10gmt_set_idEi"]
    pub fn atmosphere_gmt_set_id(this: *mut atmosphere, _ID_: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere11gmt_set_ephEf"]
    pub fn atmosphere_gmt_set_eph(this: *mut atmosphere, _EPH_: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere7cleanupEv"]
    pub fn atmosphere_cleanup(this: *mut atmosphere);
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere4infoEv"]
    pub fn atmosphere_info(this: *mut atmosphere);
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere5resetEv"]
    pub fn atmosphere_reset(this: *mut atmosphere);
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere23save_layer_phasescreensEPKci"]
    pub fn atmosphere_save_layer_phasescreens(
        this: *mut atmosphere,
        fullpath_to_phasescreens: *const ::std::os::raw::c_char,
        _N_DURATION: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere16get_phase_screenEPfPKfS2_iP6sourcef"]
    pub fn atmosphere_get_phase_screen(
        this: *mut atmosphere,
        phase_screen: *mut f32,
        x: *const f32,
        y: *const f32,
        N_xy: ::std::os::raw::c_int,
        src: *mut source,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere16get_phase_screenEPKfS1_iP6sourcef"]
    pub fn atmosphere_get_phase_screen1(
        this: *mut atmosphere,
        x: *const f32,
        y: *const f32,
        N_xy: ::std::os::raw::c_int,
        src: *mut source,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere16get_phase_screenEfifiP6sourcef"]
    pub fn atmosphere_get_phase_screen2(
        this: *mut atmosphere,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
        src: *mut source,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere16get_phase_screenEPffifiP6sourcef"]
    pub fn atmosphere_get_phase_screen3(
        this: *mut atmosphere,
        phase_screen: *mut f32,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
        src: *mut source,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere16get_phase_screenEP6sourcefifif"]
    pub fn atmosphere_get_phase_screen4(
        this: *mut atmosphere,
        src: *mut source,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere16get_phase_screenEP6sourcefififf"]
    pub fn atmosphere_get_phase_screen5(
        this: *mut atmosphere,
        src: *mut source,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
        time: f32,
        exponent: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere16get_phase_screenEP6sourceififif"]
    pub fn atmosphere_get_phase_screen6(
        this: *mut atmosphere,
        src: *mut source,
        N_SRC: ::std::os::raw::c_int,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere16get_phase_screenEP6sourcef"]
    pub fn atmosphere_get_phase_screen7(this: *mut atmosphere, src: *mut source, time: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere25get_phase_screen_gradientEPfS0_S0_S0_iP6sourcef"]
    pub fn atmosphere_get_phase_screen_gradient(
        this: *mut atmosphere,
        sx: *mut f32,
        sy: *mut f32,
        x: *mut f32,
        y: *mut f32,
        Nxy: ::std::os::raw::c_int,
        src: *mut source,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere25get_phase_screen_gradientEPfS0_ifP6sourcef"]
    pub fn atmosphere_get_phase_screen_gradient1(
        this: *mut atmosphere,
        sx: *mut f32,
        sy: *mut f32,
        NL: ::std::os::raw::c_int,
        d: f32,
        src: *mut source,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere25get_phase_screen_gradientEPfS0_iPcfP6sourcef"]
    pub fn atmosphere_get_phase_screen_gradient2(
        this: *mut atmosphere,
        sx: *mut f32,
        sy: *mut f32,
        NL: ::std::os::raw::c_int,
        valid_lenslet: *mut ::std::os::raw::c_char,
        d: f32,
        src: *mut source,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere25get_phase_screen_gradientEP11centroidingifP6sourcef"]
    pub fn atmosphere_get_phase_screen_gradient3(
        this: *mut atmosphere,
        cog: *mut centroiding,
        NL: ::std::os::raw::c_int,
        d: f32,
        src: *mut source,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere41get_phase_screen_gradient_rolling_shutterEP11centroidingifP6sourceff"]
    pub fn atmosphere_get_phase_screen_gradient_rolling_shutter(
        this: *mut atmosphere,
        cog: *mut centroiding,
        NL: ::std::os::raw::c_int,
        d: f32,
        src: *mut source,
        time: f32,
        delay: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere25get_phase_screen_gradientEP11centroidingifP6sourceif"]
    pub fn atmosphere_get_phase_screen_gradient4(
        this: *mut atmosphere,
        cog: *mut centroiding,
        NL: ::std::os::raw::c_int,
        d: f32,
        src: *mut source,
        N_SRC: ::std::os::raw::c_int,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere25get_phase_screen_gradientEP11centroidingiPcfP6sourceif"]
    pub fn atmosphere_get_phase_screen_gradient5(
        this: *mut atmosphere,
        cog: *mut centroiding,
        NL: ::std::os::raw::c_int,
        valid_lenslet: *mut ::std::os::raw::c_char,
        d: f32,
        src: *mut source,
        N_SRC: ::std::os::raw::c_int,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere31get_phase_screen_circ_centroidsEP11centroidingfP6sourceif"]
    pub fn atmosphere_get_phase_screen_circ_centroids(
        this: *mut atmosphere,
        cog: *mut centroiding,
        R: f32,
        src: *mut source,
        N_SRC: ::std::os::raw::c_int,
        time: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere38get_phase_screen_circ_uplink_centroidsEP11centroidingfP6sourceifc"]
    pub fn atmosphere_get_phase_screen_circ_uplink_centroids(
        this: *mut atmosphere,
        cog: *mut centroiding,
        R: f32,
        src: *mut source,
        N_SRC: ::std::os::raw::c_int,
        time: f32,
        focused: ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere10rayTracingEPKfS1_PfiPK6sourcef"]
    pub fn atmosphere_rayTracing(
        this: *mut atmosphere,
        x_PUPIL: *const f32,
        y_PUPIL: *const f32,
        phase_screen_PUPIL: *mut f32,
        NXY_PUPIL: ::std::os::raw::c_int,
        src: *const source,
        tau: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10atmosphere10rayTracingEP6sourcefifif"]
    pub fn atmosphere_rayTracing1(
        this: *mut atmosphere,
        src: *mut source,
        delta_x: f32,
        N_X: ::std::os::raw::c_int,
        delta_y: f32,
        N_Y: ::std::os::raw::c_int,
        tau: f32,
    );
}
impl atmosphere {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        r0_: f32,
        L0: f32,
        N_LAYER: ::std::os::raw::c_int,
        altitude: *mut f32,
        xi0: *mut f32,
        wind_speed: *mut f32,
        wind_direction: *mut f32,
    ) {
        atmosphere_setup(
            self,
            r0_,
            L0,
            N_LAYER,
            altitude,
            xi0,
            wind_speed,
            wind_direction,
        )
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        r0_: f32,
        L0: f32,
        N_LAYER: ::std::os::raw::c_int,
        altitude: *mut f32,
        xi0: *mut f32,
        wind_speed: *mut f32,
        wind_direction: *mut f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
    ) {
        atmosphere_setup1(
            self,
            r0_,
            L0,
            N_LAYER,
            altitude,
            xi0,
            wind_speed,
            wind_direction,
            _L_,
            _NXY_PUPIL_,
            field_size,
            duration,
        )
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        r0_: f32,
        L0: f32,
        _NLAYER: ::std::os::raw::c_int,
        altitude: *mut f32,
        xi0: *mut f32,
        wind_speed: *mut f32,
        wind_direction: *mut f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
        fullpath_to_phasescreens: *const ::std::os::raw::c_char,
        _N_DURATION: ::std::os::raw::c_int,
    ) {
        atmosphere_setup2(
            self,
            r0_,
            L0,
            _NLAYER,
            altitude,
            xi0,
            wind_speed,
            wind_direction,
            _L_,
            _NXY_PUPIL_,
            field_size,
            duration,
            fullpath_to_phasescreens,
            _N_DURATION,
        )
    }
    #[inline]
    pub unsafe fn gmt_setup(&mut self) {
        atmosphere_gmt_setup(self)
    }
    #[inline]
    pub unsafe fn gmt_setup1(&mut self, r0_: f32, L0: f32) {
        atmosphere_gmt_setup1(self, r0_, L0)
    }
    #[inline]
    pub unsafe fn gmt_setup2(
        &mut self,
        r0_: f32,
        L0: f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
    ) {
        atmosphere_gmt_setup2(self, r0_, L0, _L_, _NXY_PUPIL_, field_size, duration)
    }
    #[inline]
    pub unsafe fn gmt_setup3(
        &mut self,
        r0_: f32,
        L0: f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
        fullpath_to_phasescreens: *const ::std::os::raw::c_char,
        _N_DURATION: ::std::os::raw::c_int,
    ) {
        atmosphere_gmt_setup3(
            self,
            r0_,
            L0,
            _L_,
            _NXY_PUPIL_,
            field_size,
            duration,
            fullpath_to_phasescreens,
            _N_DURATION,
        )
    }
    #[inline]
    pub unsafe fn gmt_setup4(&mut self, r0_: f32, L0: f32, _RAND_SEED_: ::std::os::raw::c_int) {
        atmosphere_gmt_setup4(self, r0_, L0, _RAND_SEED_)
    }
    #[inline]
    pub unsafe fn gmt_setup5(
        &mut self,
        r0_: f32,
        L0: f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
        _RAND_SEED_: ::std::os::raw::c_int,
    ) {
        atmosphere_gmt_setup5(
            self,
            r0_,
            L0,
            _L_,
            _NXY_PUPIL_,
            field_size,
            duration,
            _RAND_SEED_,
        )
    }
    #[inline]
    pub unsafe fn gmt_setup6(
        &mut self,
        r0_: f32,
        L0: f32,
        _L_: f32,
        _NXY_PUPIL_: ::std::os::raw::c_int,
        field_size: f32,
        duration: f32,
        fullpath_to_phasescreens: *const ::std::os::raw::c_char,
        _N_DURATION: ::std::os::raw::c_int,
        _RAND_SEED_: ::std::os::raw::c_int,
    ) {
        atmosphere_gmt_setup6(
            self,
            r0_,
            L0,
            _L_,
            _NXY_PUPIL_,
            field_size,
            duration,
            fullpath_to_phasescreens,
            _N_DURATION,
            _RAND_SEED_,
        )
    }
    #[inline]
    pub unsafe fn gmt_set_id(&mut self, _ID_: ::std::os::raw::c_int) {
        atmosphere_gmt_set_id(self, _ID_)
    }
    #[inline]
    pub unsafe fn gmt_set_eph(&mut self, _EPH_: f32) {
        atmosphere_gmt_set_eph(self, _EPH_)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        atmosphere_cleanup(self)
    }
    #[inline]
    pub unsafe fn info(&mut self) {
        atmosphere_info(self)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        atmosphere_reset(self)
    }
    #[inline]
    pub unsafe fn save_layer_phasescreens(
        &mut self,
        fullpath_to_phasescreens: *const ::std::os::raw::c_char,
        _N_DURATION: ::std::os::raw::c_int,
    ) {
        atmosphere_save_layer_phasescreens(self, fullpath_to_phasescreens, _N_DURATION)
    }
    #[inline]
    pub unsafe fn get_phase_screen(
        &mut self,
        phase_screen: *mut f32,
        x: *const f32,
        y: *const f32,
        N_xy: ::std::os::raw::c_int,
        src: *mut source,
        time: f32,
    ) {
        atmosphere_get_phase_screen(self, phase_screen, x, y, N_xy, src, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen1(
        &mut self,
        x: *const f32,
        y: *const f32,
        N_xy: ::std::os::raw::c_int,
        src: *mut source,
        time: f32,
    ) {
        atmosphere_get_phase_screen1(self, x, y, N_xy, src, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen2(
        &mut self,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
        src: *mut source,
        time: f32,
    ) {
        atmosphere_get_phase_screen2(self, delta_x, N_x, delta_y, N_y, src, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen3(
        &mut self,
        phase_screen: *mut f32,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
        src: *mut source,
        time: f32,
    ) {
        atmosphere_get_phase_screen3(self, phase_screen, delta_x, N_x, delta_y, N_y, src, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen4(
        &mut self,
        src: *mut source,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
        time: f32,
    ) {
        atmosphere_get_phase_screen4(self, src, delta_x, N_x, delta_y, N_y, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen5(
        &mut self,
        src: *mut source,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
        time: f32,
        exponent: f32,
    ) {
        atmosphere_get_phase_screen5(self, src, delta_x, N_x, delta_y, N_y, time, exponent)
    }
    #[inline]
    pub unsafe fn get_phase_screen6(
        &mut self,
        src: *mut source,
        N_SRC: ::std::os::raw::c_int,
        delta_x: f32,
        N_x: ::std::os::raw::c_int,
        delta_y: f32,
        N_y: ::std::os::raw::c_int,
        time: f32,
    ) {
        atmosphere_get_phase_screen6(self, src, N_SRC, delta_x, N_x, delta_y, N_y, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen7(&mut self, src: *mut source, time: f32) {
        atmosphere_get_phase_screen7(self, src, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen_gradient(
        &mut self,
        sx: *mut f32,
        sy: *mut f32,
        x: *mut f32,
        y: *mut f32,
        Nxy: ::std::os::raw::c_int,
        src: *mut source,
        time: f32,
    ) {
        atmosphere_get_phase_screen_gradient(self, sx, sy, x, y, Nxy, src, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen_gradient1(
        &mut self,
        sx: *mut f32,
        sy: *mut f32,
        NL: ::std::os::raw::c_int,
        d: f32,
        src: *mut source,
        time: f32,
    ) {
        atmosphere_get_phase_screen_gradient1(self, sx, sy, NL, d, src, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen_gradient2(
        &mut self,
        sx: *mut f32,
        sy: *mut f32,
        NL: ::std::os::raw::c_int,
        valid_lenslet: *mut ::std::os::raw::c_char,
        d: f32,
        src: *mut source,
        time: f32,
    ) {
        atmosphere_get_phase_screen_gradient2(self, sx, sy, NL, valid_lenslet, d, src, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen_gradient3(
        &mut self,
        cog: *mut centroiding,
        NL: ::std::os::raw::c_int,
        d: f32,
        src: *mut source,
        time: f32,
    ) {
        atmosphere_get_phase_screen_gradient3(self, cog, NL, d, src, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen_gradient_rolling_shutter(
        &mut self,
        cog: *mut centroiding,
        NL: ::std::os::raw::c_int,
        d: f32,
        src: *mut source,
        time: f32,
        delay: f32,
    ) {
        atmosphere_get_phase_screen_gradient_rolling_shutter(self, cog, NL, d, src, time, delay)
    }
    #[inline]
    pub unsafe fn get_phase_screen_gradient4(
        &mut self,
        cog: *mut centroiding,
        NL: ::std::os::raw::c_int,
        d: f32,
        src: *mut source,
        N_SRC: ::std::os::raw::c_int,
        time: f32,
    ) {
        atmosphere_get_phase_screen_gradient4(self, cog, NL, d, src, N_SRC, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen_gradient5(
        &mut self,
        cog: *mut centroiding,
        NL: ::std::os::raw::c_int,
        valid_lenslet: *mut ::std::os::raw::c_char,
        d: f32,
        src: *mut source,
        N_SRC: ::std::os::raw::c_int,
        time: f32,
    ) {
        atmosphere_get_phase_screen_gradient5(self, cog, NL, valid_lenslet, d, src, N_SRC, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen_circ_centroids(
        &mut self,
        cog: *mut centroiding,
        R: f32,
        src: *mut source,
        N_SRC: ::std::os::raw::c_int,
        time: f32,
    ) {
        atmosphere_get_phase_screen_circ_centroids(self, cog, R, src, N_SRC, time)
    }
    #[inline]
    pub unsafe fn get_phase_screen_circ_uplink_centroids(
        &mut self,
        cog: *mut centroiding,
        R: f32,
        src: *mut source,
        N_SRC: ::std::os::raw::c_int,
        time: f32,
        focused: ::std::os::raw::c_char,
    ) {
        atmosphere_get_phase_screen_circ_uplink_centroids(self, cog, R, src, N_SRC, time, focused)
    }
    #[inline]
    pub unsafe fn rayTracing(
        &mut self,
        x_PUPIL: *const f32,
        y_PUPIL: *const f32,
        phase_screen_PUPIL: *mut f32,
        NXY_PUPIL: ::std::os::raw::c_int,
        src: *const source,
        tau: f32,
    ) {
        atmosphere_rayTracing(
            self,
            x_PUPIL,
            y_PUPIL,
            phase_screen_PUPIL,
            NXY_PUPIL,
            src,
            tau,
        )
    }
    #[inline]
    pub unsafe fn rayTracing1(
        &mut self,
        src: *mut source,
        delta_x: f32,
        N_X: ::std::os::raw::c_int,
        delta_y: f32,
        N_Y: ::std::os::raw::c_int,
        tau: f32,
    ) {
        atmosphere_rayTracing1(self, src, delta_x, N_X, delta_y, N_Y, tau)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aaStats {
    pub N: ::std::os::raw::c_int,
    pub N2: ::std::os::raw::c_int,
    pub NU: ::std::os::raw::c_int,
    pub NU2: ::std::os::raw::c_int,
    pub NF: ::std::os::raw::c_int,
    pub NF2: ::std::os::raw::c_int,
    pub psd_size: ::std::os::raw::c_int,
    pub cov_size: ::std::os::raw::c_int,
    pub ind_size: ::std::os::raw::c_int,
    pub d__psd: *mut float2,
    pub d__cov: *mut f32,
    pub d__alpha: *mut f32,
    pub d__beta: *mut f32,
    pub n_full: f32,
    pub n_comp: f32,
    pub b_full: f32,
    pub b_comp: f32,
    pub cov_eval_et: f32,
    pub sampling: f32,
    pub plan: cufftHandle,
    pub N_SRC2: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_aaStats() {
    assert_eq!(
        ::std::mem::size_of::<aaStats>(),
        104usize,
        concat!("Size of: ", stringify!(aaStats))
    );
    assert_eq!(
        ::std::mem::align_of::<aaStats>(),
        8usize,
        concat!("Alignment of ", stringify!(aaStats))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).N as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(N)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).N2 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(N2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).NU as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(NU)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).NU2 as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(NU2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).NF as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(NF)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).NF2 as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(NF2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).psd_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(psd_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).cov_size as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(cov_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).ind_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(ind_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).d__psd as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(d__psd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).d__cov as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(d__cov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).d__alpha as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(d__alpha)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).d__beta as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(d__beta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).n_full as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(n_full)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).n_comp as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(n_comp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).b_full as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(b_full)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).b_comp as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(b_comp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).cov_eval_et as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(cov_eval_et)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).sampling as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(sampling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).plan as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(plan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<aaStats>())).N_SRC2 as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(aaStats),
            "::",
            stringify!(N_SRC2)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7aaStats5setupEiPK10atmospherefPK6sourcei"]
    pub fn aaStats_setup(
        this: *mut aaStats,
        N: ::std::os::raw::c_int,
        atm: *const atmosphere,
        lenslet_pitch: f32,
        src: *const source,
        N_SRC: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7aaStats7cleanupEv"]
    pub fn aaStats_cleanup(this: *mut aaStats);
}
extern "C" {
    #[link_name = "\u{1}_ZN7aaStats4infoEif"]
    pub fn aaStats_info(this: *mut aaStats, kappa: ::std::os::raw::c_int, d: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN7aaStats8varianceEv"]
    pub fn aaStats_variance(this: *mut aaStats) -> f32;
}
extern "C" {
    #[link_name = "\u{1}_ZN7aaStats6toFileEPc"]
    pub fn aaStats_toFile(this: *mut aaStats, filename: *mut ::std::os::raw::c_char);
}
impl aaStats {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        N: ::std::os::raw::c_int,
        atm: *const atmosphere,
        lenslet_pitch: f32,
        src: *const source,
        N_SRC: ::std::os::raw::c_int,
    ) {
        aaStats_setup(self, N, atm, lenslet_pitch, src, N_SRC)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        aaStats_cleanup(self)
    }
    #[inline]
    pub unsafe fn info(&mut self, kappa: ::std::os::raw::c_int, d: f32) {
        aaStats_info(self, kappa, d)
    }
    #[inline]
    pub unsafe fn variance(&mut self) -> f32 {
        aaStats_variance(self)
    }
    #[inline]
    pub unsafe fn toFile(&mut self, filename: *mut ::std::os::raw::c_char) {
        aaStats_toFile(self, filename)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct paStats {
    pub osf: ::std::os::raw::c_int,
    pub M: ::std::os::raw::c_int,
    pub shift: ::std::os::raw::c_int,
    pub M_LAYER: *mut ::std::os::raw::c_int,
    pub N: ::std::os::raw::c_int,
    pub N2: ::std::os::raw::c_int,
    pub NU: ::std::os::raw::c_int,
    pub NU2: ::std::os::raw::c_int,
    pub NF: ::std::os::raw::c_int,
    pub NF2: ::std::os::raw::c_int,
    pub psd_size: ::std::os::raw::c_int,
    pub cov_size: ::std::os::raw::c_int,
    pub ind_size: ::std::os::raw::c_int,
    pub d__psd: *mut float2,
    pub d__cov: *mut f32,
    pub d__alpha: *mut f32,
    pub d__beta: *mut f32,
    pub n_full: f32,
    pub n_comp: f32,
    pub b_full: f32,
    pub b_comp: f32,
    pub cov_eval_et: f32,
    pub sampling: f32,
    pub plan: cufftHandle,
    pub N_SRC2: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_paStats() {
    assert_eq!(
        ::std::mem::size_of::<paStats>(),
        128usize,
        concat!("Size of: ", stringify!(paStats))
    );
    assert_eq!(
        ::std::mem::align_of::<paStats>(),
        8usize,
        concat!("Alignment of ", stringify!(paStats))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).osf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(osf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).M as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(M)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).shift as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(shift)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).M_LAYER as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(M_LAYER)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).N as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(N)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).N2 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(N2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).NU as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(NU)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).NU2 as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(NU2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).NF as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(NF)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).NF2 as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(NF2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).psd_size as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(psd_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).cov_size as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(cov_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).ind_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(ind_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).d__psd as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(d__psd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).d__cov as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(d__cov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).d__alpha as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(d__alpha)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).d__beta as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(d__beta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).n_full as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(n_full)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).n_comp as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(n_comp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).b_full as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(b_full)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).b_comp as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(b_comp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).cov_eval_et as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(cov_eval_et)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).sampling as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(sampling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).plan as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(plan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<paStats>())).N_SRC2 as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(paStats),
            "::",
            stringify!(N_SRC2)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7paStats5setupEiiiPK10atmospherefP6sourceiPKS3_i"]
    pub fn paStats_setup(
        this: *mut paStats,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        osf_: ::std::os::raw::c_int,
        atm: *const atmosphere,
        lenslet_pitch: f32,
        phase_src: *mut source,
        N_P_SRC: ::std::os::raw::c_int,
        slopes_src: *const source,
        N_S_SRC: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7paStats5setupEiiiPK10atmospherefPK6sourceif"]
    pub fn paStats_setup1(
        this: *mut paStats,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        osf_: ::std::os::raw::c_int,
        atm: *const atmosphere,
        lenslet_pitch: f32,
        slopes_src: *const source,
        N_S_SRC: ::std::os::raw::c_int,
        z_radius: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7paStats7cleanupEv"]
    pub fn paStats_cleanup(this: *mut paStats);
}
extern "C" {
    #[link_name = "\u{1}_ZN7paStats4infoEif"]
    pub fn paStats_info(this: *mut paStats, kappa: ::std::os::raw::c_int, d: f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN7paStats3MVMEPfS0_ffifiP10atmosphereP6sourceiS4_i"]
    pub fn paStats_MVM(
        this: *mut paStats,
        out_vector: *mut f32,
        in_vector: *mut f32,
        d1: f32,
        g1: f32,
        N1: ::std::os::raw::c_int,
        d2: f32,
        N2: ::std::os::raw::c_int,
        atm: *mut atmosphere,
        phase_src: *mut source,
        N_P_SRC: ::std::os::raw::c_int,
        slopes_src: *mut source,
        N_S_SRC: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7paStats6toFileEPc"]
    pub fn paStats_toFile(this: *mut paStats, filename: *mut ::std::os::raw::c_char);
}
extern "C" {
    #[link_name = "\u{1}_ZN7paStats8varianceEv"]
    pub fn paStats_variance(this: *mut paStats);
}
impl paStats {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        osf_: ::std::os::raw::c_int,
        atm: *const atmosphere,
        lenslet_pitch: f32,
        phase_src: *mut source,
        N_P_SRC: ::std::os::raw::c_int,
        slopes_src: *const source,
        N_S_SRC: ::std::os::raw::c_int,
    ) {
        paStats_setup(
            self,
            M_,
            N_,
            osf_,
            atm,
            lenslet_pitch,
            phase_src,
            N_P_SRC,
            slopes_src,
            N_S_SRC,
        )
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        osf_: ::std::os::raw::c_int,
        atm: *const atmosphere,
        lenslet_pitch: f32,
        slopes_src: *const source,
        N_S_SRC: ::std::os::raw::c_int,
        z_radius: f32,
    ) {
        paStats_setup1(
            self,
            M_,
            N_,
            osf_,
            atm,
            lenslet_pitch,
            slopes_src,
            N_S_SRC,
            z_radius,
        )
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        paStats_cleanup(self)
    }
    #[inline]
    pub unsafe fn info(&mut self, kappa: ::std::os::raw::c_int, d: f32) {
        paStats_info(self, kappa, d)
    }
    #[inline]
    pub unsafe fn MVM(
        &mut self,
        out_vector: *mut f32,
        in_vector: *mut f32,
        d1: f32,
        g1: f32,
        N1: ::std::os::raw::c_int,
        d2: f32,
        N2: ::std::os::raw::c_int,
        atm: *mut atmosphere,
        phase_src: *mut source,
        N_P_SRC: ::std::os::raw::c_int,
        slopes_src: *mut source,
        N_S_SRC: ::std::os::raw::c_int,
    ) {
        paStats_MVM(
            self, out_vector, in_vector, d1, g1, N1, d2, N2, atm, phase_src, N_P_SRC, slopes_src,
            N_S_SRC,
        )
    }
    #[inline]
    pub unsafe fn toFile(&mut self, filename: *mut ::std::os::raw::c_char) {
        paStats_toFile(self, filename)
    }
    #[inline]
    pub unsafe fn variance(&mut self) {
        paStats_variance(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BTBT {
    pub M: ::std::os::raw::c_int,
    pub N: ::std::os::raw::c_int,
    pub MT: ::std::os::raw::c_int,
    pub MT2: ::std::os::raw::c_int,
    pub NT: ::std::os::raw::c_int,
    pub NT2: ::std::os::raw::c_int,
    pub NU: ::std::os::raw::c_int,
    pub NU2: ::std::os::raw::c_int,
    pub NDFT: ::std::os::raw::c_int,
    pub HALF_NDFT: ::std::os::raw::c_int,
    pub NU_TOTAL: ::std::os::raw::c_int,
    pub NF: ::std::os::raw::c_int,
    pub NF2: ::std::os::raw::c_int,
    pub ind_size: ::std::os::raw::c_int,
    pub cov_size: ::std::os::raw::c_int,
    pub mask: *mut ::std::os::raw::c_char,
    pub d__cov: *mut float2,
    pub d__b: *mut float2,
    pub d__c: *mut float2,
    pub d__alpha: *mut f32,
    pub d__beta: *mut f32,
    pub n_full: f32,
    pub n_comp: f32,
    pub b_full: f32,
    pub b_comp: f32,
    pub cov_eval_et: f32,
    pub d__mu: *mut ::std::os::raw::c_uint,
    pub d__xi: *mut ::std::os::raw::c_uint,
    pub raster_plan: cufftHandle,
    pub MVM_input_plan: cufftHandle,
    pub MVM_output_plan: cufftHandle,
}
#[test]
fn bindgen_test_layout_BTBT() {
    assert_eq!(
        ::std::mem::size_of::<BTBT>(),
        168usize,
        concat!("Size of: ", stringify!(BTBT))
    );
    assert_eq!(
        ::std::mem::align_of::<BTBT>(),
        8usize,
        concat!("Alignment of ", stringify!(BTBT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).M as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(BTBT), "::", stringify!(M))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).N as *const _ as usize },
        4usize,
        concat!("Offset of field: ", stringify!(BTBT), "::", stringify!(N))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).MT as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(BTBT), "::", stringify!(MT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).MT2 as *const _ as usize },
        12usize,
        concat!("Offset of field: ", stringify!(BTBT), "::", stringify!(MT2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).NT as *const _ as usize },
        16usize,
        concat!("Offset of field: ", stringify!(BTBT), "::", stringify!(NT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).NT2 as *const _ as usize },
        20usize,
        concat!("Offset of field: ", stringify!(BTBT), "::", stringify!(NT2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).NU as *const _ as usize },
        24usize,
        concat!("Offset of field: ", stringify!(BTBT), "::", stringify!(NU))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).NU2 as *const _ as usize },
        28usize,
        concat!("Offset of field: ", stringify!(BTBT), "::", stringify!(NU2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).NDFT as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(NDFT)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).HALF_NDFT as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(HALF_NDFT)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).NU_TOTAL as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(NU_TOTAL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).NF as *const _ as usize },
        44usize,
        concat!("Offset of field: ", stringify!(BTBT), "::", stringify!(NF))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).NF2 as *const _ as usize },
        48usize,
        concat!("Offset of field: ", stringify!(BTBT), "::", stringify!(NF2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).ind_size as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(ind_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).cov_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(cov_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).mask as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).d__cov as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(d__cov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).d__b as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(d__b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).d__c as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(d__c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).d__alpha as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(d__alpha)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).d__beta as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(d__beta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).n_full as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(n_full)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).n_comp as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(n_comp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).b_full as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(b_full)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).b_comp as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(b_comp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).cov_eval_et as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(cov_eval_et)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).d__mu as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(d__mu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).d__xi as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(d__xi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).raster_plan as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(raster_plan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).MVM_input_plan as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(MVM_input_plan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BTBT>())).MVM_output_plan as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(BTBT),
            "::",
            stringify!(MVM_output_plan)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT5setupEi"]
    pub fn BTBT_setup(this: *mut BTBT, n_x: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT5setupEiiiPf"]
    pub fn BTBT_setup1(
        this: *mut BTBT,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        NT_: ::std::os::raw::c_int,
        d__cov_: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT5setupEiiiiPf"]
    pub fn BTBT_setup2(
        this: *mut BTBT,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        MT_: ::std::os::raw::c_int,
        NT_: ::std::os::raw::c_int,
        d__cov_: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT7cleanupEv"]
    pub fn BTBT_cleanup(this: *mut BTBT);
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT4infoEv"]
    pub fn BTBT_info(this: *mut BTBT);
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT3MVMEPfS0_"]
    pub fn BTBT_MVM(this: *mut BTBT, y: *mut f32, x: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT5MVM_iEPfS0_"]
    pub fn BTBT_MVM_i(this: *mut BTBT, y: *mut f32, x: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT6MVM_iiEPfS0_"]
    pub fn BTBT_MVM_ii(this: *mut BTBT, y: *mut f32, x: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT7MVM_iiiEPfS0_"]
    pub fn BTBT_MVM_iii(this: *mut BTBT, y: *mut f32, x: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT6MVM_ivEPfS0_"]
    pub fn BTBT_MVM_iv(this: *mut BTBT, y: *mut f32, x: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN4BTBT5MVM_vEPfS0_"]
    pub fn BTBT_MVM_v(this: *mut BTBT, y: *mut f32, x: *mut f32);
}
impl BTBT {
    #[inline]
    pub unsafe fn setup(&mut self, n_x: ::std::os::raw::c_int) {
        BTBT_setup(self, n_x)
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        NT_: ::std::os::raw::c_int,
        d__cov_: *mut f32,
    ) {
        BTBT_setup1(self, M_, N_, NT_, d__cov_)
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        MT_: ::std::os::raw::c_int,
        NT_: ::std::os::raw::c_int,
        d__cov_: *mut f32,
    ) {
        BTBT_setup2(self, M_, N_, MT_, NT_, d__cov_)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        BTBT_cleanup(self)
    }
    #[inline]
    pub unsafe fn info(&mut self) {
        BTBT_info(self)
    }
    #[inline]
    pub unsafe fn MVM(&mut self, y: *mut f32, x: *mut f32) {
        BTBT_MVM(self, y, x)
    }
    #[inline]
    pub unsafe fn MVM_i(&mut self, y: *mut f32, x: *mut f32) {
        BTBT_MVM_i(self, y, x)
    }
    #[inline]
    pub unsafe fn MVM_ii(&mut self, y: *mut f32, x: *mut f32) {
        BTBT_MVM_ii(self, y, x)
    }
    #[inline]
    pub unsafe fn MVM_iii(&mut self, y: *mut f32, x: *mut f32) {
        BTBT_MVM_iii(self, y, x)
    }
    #[inline]
    pub unsafe fn MVM_iv(&mut self, y: *mut f32, x: *mut f32) {
        BTBT_MVM_iv(self, y, x)
    }
    #[inline]
    pub unsafe fn MVM_v(&mut self, y: *mut f32, x: *mut f32) {
        BTBT_MVM_v(self, y, x)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GBTBT {
    pub M: ::std::os::raw::c_int,
    pub N: ::std::os::raw::c_int,
    pub NT: ::std::os::raw::c_int,
    pub NT2: ::std::os::raw::c_int,
    pub NDFT: ::std::os::raw::c_int,
    pub HALF_NDFT: ::std::os::raw::c_int,
    pub NU_TOTAL: ::std::os::raw::c_int,
    pub NF: ::std::os::raw::c_int,
    pub NF2: ::std::os::raw::c_int,
    pub ind_size: ::std::os::raw::c_int,
    pub cov_size: ::std::os::raw::c_int,
    pub MT2_TOTAL: ::std::os::raw::c_int,
    pub MT_size: ::std::os::raw::c_int,
    pub MAX_MT: ::std::os::raw::c_int,
    pub MT: *mut ::std::os::raw::c_int,
    pub MT2: *mut ::std::os::raw::c_int,
    pub NU: *mut ::std::os::raw::c_int,
    pub NU2: *mut ::std::os::raw::c_int,
    pub CS_MT2: *mut ::std::os::raw::c_int,
    pub d__MT: *mut ::std::os::raw::c_int,
    pub d__MT2: *mut ::std::os::raw::c_int,
    pub d__NU: *mut ::std::os::raw::c_int,
    pub d__NU2: *mut ::std::os::raw::c_int,
    pub d__CS_MT2: *mut ::std::os::raw::c_int,
    pub mask: *mut ::std::os::raw::c_char,
    pub d__cov: *mut float2,
    pub d__b: *mut float2,
    pub d__c: *mut float2,
    pub d__alpha: *mut f32,
    pub d__beta: *mut f32,
    pub n_full: f32,
    pub n_comp: f32,
    pub b_full: f32,
    pub b_comp: f32,
    pub cov_eval_et: f32,
    pub d__mu: *mut ::std::os::raw::c_uint,
    pub d__xi: *mut ::std::os::raw::c_uint,
    pub raster_plan: cufftHandle,
    pub MVM_input_plan: cufftHandle,
    pub MVM_output_plan: cufftHandle,
}
#[test]
fn bindgen_test_layout_GBTBT() {
    assert_eq!(
        ::std::mem::size_of::<GBTBT>(),
        240usize,
        concat!("Size of: ", stringify!(GBTBT))
    );
    assert_eq!(
        ::std::mem::align_of::<GBTBT>(),
        8usize,
        concat!("Alignment of ", stringify!(GBTBT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).M as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(GBTBT), "::", stringify!(M))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).N as *const _ as usize },
        4usize,
        concat!("Offset of field: ", stringify!(GBTBT), "::", stringify!(N))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).NT as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(GBTBT), "::", stringify!(NT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).NT2 as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(NT2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).NDFT as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(NDFT)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).HALF_NDFT as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(HALF_NDFT)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).NU_TOTAL as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(NU_TOTAL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).NF as *const _ as usize },
        28usize,
        concat!("Offset of field: ", stringify!(GBTBT), "::", stringify!(NF))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).NF2 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(NF2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).ind_size as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(ind_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).cov_size as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(cov_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).MT2_TOTAL as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(MT2_TOTAL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).MT_size as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(MT_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).MAX_MT as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(MAX_MT)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).MT as *const _ as usize },
        56usize,
        concat!("Offset of field: ", stringify!(GBTBT), "::", stringify!(MT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).MT2 as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(MT2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).NU as *const _ as usize },
        72usize,
        concat!("Offset of field: ", stringify!(GBTBT), "::", stringify!(NU))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).NU2 as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(NU2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).CS_MT2 as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(CS_MT2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__MT as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__MT)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__MT2 as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__MT2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__NU as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__NU)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__NU2 as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__NU2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__CS_MT2 as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__CS_MT2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).mask as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__cov as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__cov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__b as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__c as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__alpha as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__alpha)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__beta as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__beta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).n_full as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(n_full)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).n_comp as *const _ as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(n_comp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).b_full as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(b_full)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).b_comp as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(b_comp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).cov_eval_et as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(cov_eval_et)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__mu as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__mu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).d__xi as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(d__xi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).raster_plan as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(raster_plan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).MVM_input_plan as *const _ as usize },
        228usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(MVM_input_plan)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GBTBT>())).MVM_output_plan as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(GBTBT),
            "::",
            stringify!(MVM_output_plan)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5GBTBT5setupEi"]
    pub fn GBTBT_setup(this: *mut GBTBT, n_x: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN5GBTBT5setupEiiiPKf"]
    pub fn GBTBT_setup1(
        this: *mut GBTBT,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        NT_: ::std::os::raw::c_int,
        d__cov_: *const f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5GBTBT5setupEiiiiPKf"]
    pub fn GBTBT_setup2(
        this: *mut GBTBT,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        MT_: ::std::os::raw::c_int,
        NT_: ::std::os::raw::c_int,
        d__cov_: *const f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5GBTBT5setupEiiPiiPKf"]
    pub fn GBTBT_setup3(
        this: *mut GBTBT,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        MT_: *mut ::std::os::raw::c_int,
        NT_: ::std::os::raw::c_int,
        d__cov_: *const f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5GBTBT7cleanupEv"]
    pub fn GBTBT_cleanup(this: *mut GBTBT);
}
extern "C" {
    #[link_name = "\u{1}_ZN5GBTBT4infoEv"]
    pub fn GBTBT_info(this: *mut GBTBT);
}
extern "C" {
    #[link_name = "\u{1}_ZN5GBTBT3MVMEPfS0_"]
    pub fn GBTBT_MVM(this: *mut GBTBT, y: *mut f32, x: *mut f32);
}
impl GBTBT {
    #[inline]
    pub unsafe fn setup(&mut self, n_x: ::std::os::raw::c_int) {
        GBTBT_setup(self, n_x)
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        NT_: ::std::os::raw::c_int,
        d__cov_: *const f32,
    ) {
        GBTBT_setup1(self, M_, N_, NT_, d__cov_)
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        MT_: ::std::os::raw::c_int,
        NT_: ::std::os::raw::c_int,
        d__cov_: *const f32,
    ) {
        GBTBT_setup2(self, M_, N_, MT_, NT_, d__cov_)
    }
    #[inline]
    pub unsafe fn setup3(
        &mut self,
        M_: ::std::os::raw::c_int,
        N_: ::std::os::raw::c_int,
        MT_: *mut ::std::os::raw::c_int,
        NT_: ::std::os::raw::c_int,
        d__cov_: *const f32,
    ) {
        GBTBT_setup3(self, M_, N_, MT_, NT_, d__cov_)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        GBTBT_cleanup(self)
    }
    #[inline]
    pub unsafe fn info(&mut self) {
        GBTBT_info(self)
    }
    #[inline]
    pub unsafe fn MVM(&mut self, y: *mut f32, x: *mut f32) {
        GBTBT_MVM(self, y, x)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iterativeSolvers {
    pub d__vectors: *mut f32,
    pub q: *mut f32,
    pub x: *mut f32,
    pub r: *mut f32,
    pub p: *mut f32,
    pub z: *mut f32,
    pub nu_i: *mut f32,
    pub nu_im1: *mut f32,
    pub nu_ip1: *mut f32,
    pub w_i: *mut f32,
    pub w_im1: *mut f32,
    pub w_im2: *mut f32,
    pub rnorm: f32,
    pub rel_rnorm: f32,
    pub mean_time_per_iteration: f32,
    pub RTOL: f32,
    pub ATOL: f32,
    pub N: ::std::os::raw::c_int,
    pub N_ITERATION: ::std::os::raw::c_int,
    pub cvgce_iteration: ::std::os::raw::c_int,
    pub tid: stopwatch,
    pub handle: cublasHandle_t,
    pub status: cublasStatus_t,
    pub VERBOSE: ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_iterativeSolvers() {
    assert_eq!(
        ::std::mem::size_of::<iterativeSolvers>(),
        168usize,
        concat!("Size of: ", stringify!(iterativeSolvers))
    );
    assert_eq!(
        ::std::mem::align_of::<iterativeSolvers>(),
        8usize,
        concat!("Alignment of ", stringify!(iterativeSolvers))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).d__vectors as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(d__vectors)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).q as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(q)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).x as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).r as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).p as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).z as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(z)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).nu_i as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(nu_i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).nu_im1 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(nu_im1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).nu_ip1 as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(nu_ip1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).w_i as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(w_i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).w_im1 as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(w_im1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).w_im2 as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(w_im2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).rnorm as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(rnorm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).rel_rnorm as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(rel_rnorm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iterativeSolvers>())).mean_time_per_iteration as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(mean_time_per_iteration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).RTOL as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(RTOL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).ATOL as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(ATOL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).N as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(N)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).N_ITERATION as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(N_ITERATION)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<iterativeSolvers>())).cvgce_iteration as *const _ as usize
        },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(cvgce_iteration)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).tid as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).handle as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).status as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iterativeSolvers>())).VERBOSE as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(iterativeSolvers),
            "::",
            stringify!(VERBOSE)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers8cg_setupEi"]
    pub fn iterativeSolvers_cg_setup(this: *mut iterativeSolvers, n_vector: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers9pcg_setupEi"]
    pub fn iterativeSolvers_pcg_setup(this: *mut iterativeSolvers, n_vector: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers12minres_setupEi"]
    pub fn iterativeSolvers_minres_setup(
        this: *mut iterativeSolvers,
        n_vector: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers7cleanupEv"]
    pub fn iterativeSolvers_cleanup(this: *mut iterativeSolvers);
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers2cgEPfP4BTBTS0_iS0_"]
    pub fn iterativeSolvers_cg(
        this: *mut iterativeSolvers,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers3pcgEPfP4BTBTS0_iS0_f"]
    pub fn iterativeSolvers_pcg(
        this: *mut iterativeSolvers,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
        ip: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers9sym_orthoEPfS0_S0_S0_S0_"]
    pub fn iterativeSolvers_sym_ortho(
        this: *mut iterativeSolvers,
        c: *mut f32,
        s: *mut f32,
        r: *mut f32,
        a: *mut f32,
        b: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers12lanczos_stepEPfS0_S0_P4BTBTS0_S0_f"]
    pub fn iterativeSolvers_lanczos_step(
        this: *mut iterativeSolvers,
        alpha: *mut f32,
        beta: *mut f32,
        nu_kp1: *mut f32,
        A: *mut BTBT,
        nu_k: *mut f32,
        nu_km1: *mut f32,
        sigma: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers12minres_vorstEPfP4BTBTS0_S0_"]
    pub fn iterativeSolvers_minres_vorst(
        this: *mut iterativeSolvers,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        x0: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers12minres_vorstEPfP4BTBTS0_iS0_"]
    pub fn iterativeSolvers_minres_vorst1(
        this: *mut iterativeSolvers,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers12minres_vorstEPfP4BTBTS0_fS0_"]
    pub fn iterativeSolvers_minres_vorst2(
        this: *mut iterativeSolvers,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        rtol: f32,
        x0: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers13pminres_vorstEPfP4BTBTS0_iS0_f"]
    pub fn iterativeSolvers_pminres_vorst(
        this: *mut iterativeSolvers,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
        ip: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers12minres_vorstEPfS0_P4BTBTS0_iS0_"]
    pub fn iterativeSolvers_minres_vorst3(
        this: *mut iterativeSolvers,
        x: *mut f32,
        res: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN16iterativeSolvers11minres_choiEPfP4BTBTS0_iS0_"]
    pub fn iterativeSolvers_minres_choi(
        this: *mut iterativeSolvers,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
    );
}
impl iterativeSolvers {
    #[inline]
    pub unsafe fn cg_setup(&mut self, n_vector: ::std::os::raw::c_int) {
        iterativeSolvers_cg_setup(self, n_vector)
    }
    #[inline]
    pub unsafe fn pcg_setup(&mut self, n_vector: ::std::os::raw::c_int) {
        iterativeSolvers_pcg_setup(self, n_vector)
    }
    #[inline]
    pub unsafe fn minres_setup(&mut self, n_vector: ::std::os::raw::c_int) {
        iterativeSolvers_minres_setup(self, n_vector)
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        iterativeSolvers_cleanup(self)
    }
    #[inline]
    pub unsafe fn cg(
        &mut self,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
    ) {
        iterativeSolvers_cg(self, x, A, b, max_it, x0)
    }
    #[inline]
    pub unsafe fn pcg(
        &mut self,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
        ip: f32,
    ) {
        iterativeSolvers_pcg(self, x, A, b, max_it, x0, ip)
    }
    #[inline]
    pub unsafe fn sym_ortho(
        &mut self,
        c: *mut f32,
        s: *mut f32,
        r: *mut f32,
        a: *mut f32,
        b: *mut f32,
    ) {
        iterativeSolvers_sym_ortho(self, c, s, r, a, b)
    }
    #[inline]
    pub unsafe fn lanczos_step(
        &mut self,
        alpha: *mut f32,
        beta: *mut f32,
        nu_kp1: *mut f32,
        A: *mut BTBT,
        nu_k: *mut f32,
        nu_km1: *mut f32,
        sigma: f32,
    ) {
        iterativeSolvers_lanczos_step(self, alpha, beta, nu_kp1, A, nu_k, nu_km1, sigma)
    }
    #[inline]
    pub unsafe fn minres_vorst(&mut self, x: *mut f32, A: *mut BTBT, b: *mut f32, x0: *mut f32) {
        iterativeSolvers_minres_vorst(self, x, A, b, x0)
    }
    #[inline]
    pub unsafe fn minres_vorst1(
        &mut self,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
    ) {
        iterativeSolvers_minres_vorst1(self, x, A, b, max_it, x0)
    }
    #[inline]
    pub unsafe fn minres_vorst2(
        &mut self,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        rtol: f32,
        x0: *mut f32,
    ) {
        iterativeSolvers_minres_vorst2(self, x, A, b, rtol, x0)
    }
    #[inline]
    pub unsafe fn pminres_vorst(
        &mut self,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
        ip: f32,
    ) {
        iterativeSolvers_pminres_vorst(self, x, A, b, max_it, x0, ip)
    }
    #[inline]
    pub unsafe fn minres_vorst3(
        &mut self,
        x: *mut f32,
        res: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
    ) {
        iterativeSolvers_minres_vorst3(self, x, res, A, b, max_it, x0)
    }
    #[inline]
    pub unsafe fn minres_choi(
        &mut self,
        x: *mut f32,
        A: *mut BTBT,
        b: *mut f32,
        max_it: ::std::os::raw::c_int,
        x0: *mut f32,
    ) {
        iterativeSolvers_minres_choi(self, x, A, b, max_it, x0)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LMMSE {
    pub d__idx: *mut ::std::os::raw::c_int,
    pub PS_E_N_PX: ::std::os::raw::c_int,
    pub N_guide_star: ::std::os::raw::c_int,
    pub N_mmse_star: ::std::os::raw::c_int,
    pub offset: ::std::os::raw::c_int,
    pub N_SIDE_LENSLET_: ::std::os::raw::c_int,
    pub NP: ::std::os::raw::c_int,
    pub NS: ::std::os::raw::c_int,
    pub osf: ::std::os::raw::c_int,
    pub d__ce: *mut f32,
    pub d__phase_est: *mut f32,
    pub d__phase_est_c: *mut f32,
    pub d__phase_est_i: *mut f32,
    pub d__x: *mut f32,
    pub d__zp_x: *mut f32,
    pub aa: aaStats,
    pub aaCov: BTBT,
    pub pa: paStats,
    pub paCov: GBTBT,
    pub iSolve: iterativeSolvers,
    pub tid: stopwatch,
    pub nnz: ::std::os::raw::c_int,
    pub NI: ::std::os::raw::c_int,
    pub csrValH: *mut f32,
    pub csrColIndH: *mut ::std::os::raw::c_int,
    pub csrRowPtrH: *mut ::std::os::raw::c_int,
    pub alpha: f32,
    pub beta: f32,
    pub elapsed_time: f32,
    pub cudaStat: cudaError_t,
    pub status: cusparseStatus_t,
    pub handle: cusparseHandle_t,
    pub descr: cusparseMatDescr_t,
    pub start: cudaEvent_t,
    pub stop: cudaEvent_t,
}
#[test]
fn bindgen_test_layout_LMMSE() {
    assert_eq!(
        ::std::mem::size_of::<LMMSE>(),
        1008usize,
        concat!("Size of: ", stringify!(LMMSE))
    );
    assert_eq!(
        ::std::mem::align_of::<LMMSE>(),
        8usize,
        concat!("Alignment of ", stringify!(LMMSE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).d__idx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(d__idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).PS_E_N_PX as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(PS_E_N_PX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).N_guide_star as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(N_guide_star)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).N_mmse_star as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(N_mmse_star)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).offset as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).N_SIDE_LENSLET_ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(N_SIDE_LENSLET_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).NP as *const _ as usize },
        28usize,
        concat!("Offset of field: ", stringify!(LMMSE), "::", stringify!(NP))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).NS as *const _ as usize },
        32usize,
        concat!("Offset of field: ", stringify!(LMMSE), "::", stringify!(NS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).osf as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(osf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).d__ce as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(d__ce)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).d__phase_est as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(d__phase_est)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).d__phase_est_c as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(d__phase_est_c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).d__phase_est_i as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(d__phase_est_i)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).d__x as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(d__x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).d__zp_x as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(d__zp_x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).aa as *const _ as usize },
        88usize,
        concat!("Offset of field: ", stringify!(LMMSE), "::", stringify!(aa))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).aaCov as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(aaCov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).pa as *const _ as usize },
        360usize,
        concat!("Offset of field: ", stringify!(LMMSE), "::", stringify!(pa))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).paCov as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(paCov)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).iSolve as *const _ as usize },
        728usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(iSolve)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).tid as *const _ as usize },
        896usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).nnz as *const _ as usize },
        920usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(nnz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).NI as *const _ as usize },
        924usize,
        concat!("Offset of field: ", stringify!(LMMSE), "::", stringify!(NI))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).csrValH as *const _ as usize },
        928usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(csrValH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).csrColIndH as *const _ as usize },
        936usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(csrColIndH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).csrRowPtrH as *const _ as usize },
        944usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(csrRowPtrH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).alpha as *const _ as usize },
        952usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(alpha)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).beta as *const _ as usize },
        956usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(beta)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).elapsed_time as *const _ as usize },
        960usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(elapsed_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).cudaStat as *const _ as usize },
        964usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(cudaStat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).status as *const _ as usize },
        968usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).handle as *const _ as usize },
        976usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).descr as *const _ as usize },
        984usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(descr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).start as *const _ as usize },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LMMSE>())).stop as *const _ as usize },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(LMMSE),
            "::",
            stringify!(stop)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE5setupEP10atmosphereP6sourceS3_fiPc"]
    pub fn LMMSE_setup(
        this: *mut LMMSE,
        atm: *mut atmosphere,
        guide_star: *mut source,
        mmse_star: *mut source,
        sampling: f32,
        N: ::std::os::raw::c_int,
        solver_id: *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE5setupEP10atmosphereP6sourceS3_fiP4maskPc"]
    pub fn LMMSE_setup1(
        this: *mut LMMSE,
        atm: *mut atmosphere,
        guide_star: *mut source,
        mmse_star: *mut source,
        sampling: f32,
        N: ::std::os::raw::c_int,
        pupil: *mut mask,
        solver_id: *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE5setupEP10atmosphereP6sourceS3_fiP4maskPci"]
    pub fn LMMSE_setup2(
        this: *mut LMMSE,
        atm: *mut atmosphere,
        guide_star: *mut source,
        mmse_star: *mut source,
        sampling: f32,
        N: ::std::os::raw::c_int,
        pupil: *mut mask,
        solver_id: *mut ::std::os::raw::c_char,
        wavefront_osf: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE5setupEP10atmosphereP6sourcefiP4maskPcif"]
    pub fn LMMSE_setup3(
        this: *mut LMMSE,
        atm: *mut atmosphere,
        guide_star: *mut source,
        sampling: f32,
        _N_SIDE_LENSLET_: ::std::os::raw::c_int,
        pupil: *mut mask,
        solver_id: *mut ::std::os::raw::c_char,
        wavefront_osf: ::std::os::raw::c_int,
        z_radius: f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE5setupEP10atmosphereP6sourceS3_P13shackHartmannPc"]
    pub fn LMMSE_setup4(
        this: *mut LMMSE,
        atm: *mut atmosphere,
        guide_star: *mut source,
        mmse_star: *mut source,
        wfs: *mut shackHartmann,
        solver_id: *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE5setupEP10atmosphereP6sourceS3_P13shackHartmannPciP4mask"]
    pub fn LMMSE_setup5(
        this: *mut LMMSE,
        atm: *mut atmosphere,
        guide_star: *mut source,
        mmse_star: *mut source,
        wfs: *mut shackHartmann,
        solver_id: *mut ::std::os::raw::c_char,
        osf_: ::std::os::raw::c_int,
        pupil_: *mut mask,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE7cleanupEv"]
    pub fn LMMSE_cleanup(this: *mut LMMSE);
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE14estimation_oldEPfiS0_"]
    pub fn LMMSE_estimation_old(
        this: *mut LMMSE,
        d__c: *mut f32,
        nMaxIteration: ::std::os::raw::c_int,
        d__x0: *mut f32,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE14estimation_oldEPfi"]
    pub fn LMMSE_estimation_old1(
        this: *mut LMMSE,
        d__c: *mut f32,
        nMaxIteration: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE10estimationEPK11centroiding"]
    pub fn LMMSE_estimation(this: *mut LMMSE, cog: *const centroiding);
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE10estimationEP13shackHartmann"]
    pub fn LMMSE_estimation1(this: *mut LMMSE, wfs: *mut shackHartmann);
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE5resetEv"]
    pub fn LMMSE_reset(this: *mut LMMSE);
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE17set_phase_est_ptrEPf"]
    pub fn LMMSE_set_phase_est_ptr(this: *mut LMMSE, data_ptr: *mut f32);
}
extern "C" {
    #[link_name = "\u{1}_ZN5LMMSE6toFileEPKc"]
    pub fn LMMSE_toFile(this: *mut LMMSE, filename: *const ::std::os::raw::c_char);
}
impl LMMSE {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        atm: *mut atmosphere,
        guide_star: *mut source,
        mmse_star: *mut source,
        sampling: f32,
        N: ::std::os::raw::c_int,
        solver_id: *mut ::std::os::raw::c_char,
    ) {
        LMMSE_setup(self, atm, guide_star, mmse_star, sampling, N, solver_id)
    }
    #[inline]
    pub unsafe fn setup1(
        &mut self,
        atm: *mut atmosphere,
        guide_star: *mut source,
        mmse_star: *mut source,
        sampling: f32,
        N: ::std::os::raw::c_int,
        pupil: *mut mask,
        solver_id: *mut ::std::os::raw::c_char,
    ) {
        LMMSE_setup1(
            self, atm, guide_star, mmse_star, sampling, N, pupil, solver_id,
        )
    }
    #[inline]
    pub unsafe fn setup2(
        &mut self,
        atm: *mut atmosphere,
        guide_star: *mut source,
        mmse_star: *mut source,
        sampling: f32,
        N: ::std::os::raw::c_int,
        pupil: *mut mask,
        solver_id: *mut ::std::os::raw::c_char,
        wavefront_osf: ::std::os::raw::c_int,
    ) {
        LMMSE_setup2(
            self,
            atm,
            guide_star,
            mmse_star,
            sampling,
            N,
            pupil,
            solver_id,
            wavefront_osf,
        )
    }
    #[inline]
    pub unsafe fn setup3(
        &mut self,
        atm: *mut atmosphere,
        guide_star: *mut source,
        sampling: f32,
        _N_SIDE_LENSLET_: ::std::os::raw::c_int,
        pupil: *mut mask,
        solver_id: *mut ::std::os::raw::c_char,
        wavefront_osf: ::std::os::raw::c_int,
        z_radius: f32,
    ) {
        LMMSE_setup3(
            self,
            atm,
            guide_star,
            sampling,
            _N_SIDE_LENSLET_,
            pupil,
            solver_id,
            wavefront_osf,
            z_radius,
        )
    }
    #[inline]
    pub unsafe fn setup4(
        &mut self,
        atm: *mut atmosphere,
        guide_star: *mut source,
        mmse_star: *mut source,
        wfs: *mut shackHartmann,
        solver_id: *mut ::std::os::raw::c_char,
    ) {
        LMMSE_setup4(self, atm, guide_star, mmse_star, wfs, solver_id)
    }
    #[inline]
    pub unsafe fn setup5(
        &mut self,
        atm: *mut atmosphere,
        guide_star: *mut source,
        mmse_star: *mut source,
        wfs: *mut shackHartmann,
        solver_id: *mut ::std::os::raw::c_char,
        osf_: ::std::os::raw::c_int,
        pupil_: *mut mask,
    ) {
        LMMSE_setup5(
            self, atm, guide_star, mmse_star, wfs, solver_id, osf_, pupil_,
        )
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        LMMSE_cleanup(self)
    }
    #[inline]
    pub unsafe fn estimation_old(
        &mut self,
        d__c: *mut f32,
        nMaxIteration: ::std::os::raw::c_int,
        d__x0: *mut f32,
    ) {
        LMMSE_estimation_old(self, d__c, nMaxIteration, d__x0)
    }
    #[inline]
    pub unsafe fn estimation_old1(&mut self, d__c: *mut f32, nMaxIteration: ::std::os::raw::c_int) {
        LMMSE_estimation_old1(self, d__c, nMaxIteration)
    }
    #[inline]
    pub unsafe fn estimation(&mut self, cog: *const centroiding) {
        LMMSE_estimation(self, cog)
    }
    #[inline]
    pub unsafe fn estimation1(&mut self, wfs: *mut shackHartmann) {
        LMMSE_estimation1(self, wfs)
    }
    #[inline]
    pub unsafe fn reset(&mut self) {
        LMMSE_reset(self)
    }
    #[inline]
    pub unsafe fn set_phase_est_ptr(&mut self, data_ptr: *mut f32) {
        LMMSE_set_phase_est_ptr(self, data_ptr)
    }
    #[inline]
    pub unsafe fn toFile(&mut self, filename: *const ::std::os::raw::c_char) {
        LMMSE_toFile(self, filename)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pyramid {
    pub N_PX_LENSLET: ::std::os::raw::c_int,
    pub N_SIDE_LENSLET: ::std::os::raw::c_int,
    pub modulation: f32,
    pub modulation_sampling: ::std::os::raw::c_int,
    pub camera: imaging,
    pub alpha: f32,
}
#[test]
fn bindgen_test_layout_pyramid() {
    assert_eq!(
        ::std::mem::size_of::<pyramid>(),
        168usize,
        concat!("Size of: ", stringify!(pyramid))
    );
    assert_eq!(
        ::std::mem::align_of::<pyramid>(),
        8usize,
        concat!("Alignment of ", stringify!(pyramid))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pyramid>())).N_PX_LENSLET as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pyramid),
            "::",
            stringify!(N_PX_LENSLET)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pyramid>())).N_SIDE_LENSLET as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pyramid),
            "::",
            stringify!(N_SIDE_LENSLET)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pyramid>())).modulation as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pyramid),
            "::",
            stringify!(modulation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pyramid>())).modulation_sampling as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pyramid),
            "::",
            stringify!(modulation_sampling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pyramid>())).camera as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pyramid),
            "::",
            stringify!(camera)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pyramid>())).alpha as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(pyramid),
            "::",
            stringify!(alpha)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7pyramid5setupEiififi"]
    pub fn pyramid_setup(
        this: *mut pyramid,
        N_PX_PUPIL: ::std::os::raw::c_int,
        _N_PUPIL_SAMPLING_: ::std::os::raw::c_int,
        _modulation_: f32,
        _modulation_sampling_: ::std::os::raw::c_int,
        _alpha_: f32,
        N_GS: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN7pyramid7cleanupEv"]
    pub fn pyramid_cleanup(this: *mut pyramid);
}
impl pyramid {
    #[inline]
    pub unsafe fn setup(
        &mut self,
        N_PX_PUPIL: ::std::os::raw::c_int,
        _N_PUPIL_SAMPLING_: ::std::os::raw::c_int,
        _modulation_: f32,
        _modulation_sampling_: ::std::os::raw::c_int,
        _alpha_: f32,
        N_GS: ::std::os::raw::c_int,
    ) {
        pyramid_setup(
            self,
            N_PX_PUPIL,
            _N_PUPIL_SAMPLING_,
            _modulation_,
            _modulation_sampling_,
            _alpha_,
            N_GS,
        )
    }
    #[inline]
    pub unsafe fn cleanup(&mut self) {
        pyramid_cleanup(self)
    }
}
