use crate::pda::PDA;

use anchor_lang::prelude::*;
use anchor_lang::AccountDeserialize;
use std::convert::TryFrom;

pub const SEED_CONFIG: &[u8] = b"config";

#[account]
#[derive(Debug)]
pub struct Config {
    pub admin: Pubkey,
    pub min_recurr: i64,
    pub program_fee: u64,
    pub worker_fee: u64,
    pub bump: u8,
}

impl std::fmt::Display for Config {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "{{
    admin: {},
    min_recurr: {},
    program_fee: {},
    worker_fee: {}
}}",
            self.admin, self.min_recurr, self.program_fee, self.worker_fee
        )
    }
}

impl TryFrom<Vec<u8>> for Config {
    type Error = ProgramError;
    fn try_from(data: Vec<u8>) -> Result<Self, Self::Error> {
        Config::try_deserialize(&mut data.as_slice())
    }
}

impl Config {
    pub fn find_pda() -> PDA {
        Pubkey::find_program_address(&[SEED_CONFIG], &crate::ID)
    }
}
