use std::collections::HashMap;

#[derive(Debug, Clone)]
pub struct MapElems {
    pub count: u32,
    pub m0: f64,
    pub m1: f64,
}

#[derive(Debug, Clone)]
pub struct DistributionMap {
    pub frequency: HashMap<u32, u32>,
    pub weights: HashMap<u32, MapElems>,
}

impl DistributionMap {
    //	fn default(self) -> DistributionMap {
    //		   self.inventions
    //        .entry(0)
    //        .or_default()
    //        .push(1);
    //	}
    pub fn init(&mut self) -> () {
        self.frequency.insert(0, 1);
    }

    pub fn add(&mut self, key: u32) -> () {
        *self.frequency.entry(key).or_insert(0) += 1;
    }

    pub fn get(&self, key: u32) -> u32 {
        match &self.frequency.get(&key) {
            Some(&x) => x,
            None => 0,
        }
    }

    pub fn print_all(&self) -> () {
        // Print all the values from the HashMap
        for (invention, count) in &self.frequency {
            println!("{:?} is invented in {:?}.", invention, count);
        }
        for (invention, elem) in &self.weights {
            println!("{:?} is invented in {:?}.", invention, elem);
        }
    }

    pub fn init_elems(&mut self, n: i32) -> () {
        for (k, v) in &self.frequency {
            let fk = *k as f64;
            let fnn = n as f64;
            let el = MapElems {
                count: *v,
                m0: 1.0,
                m1: fnn - 2.0 * fk,
            };
            &self.weights.insert(*k, el);
        }
    }

    pub fn recalculate_elems(&mut self, n: i32, d: i32) {
        for (_, mut el) in self.weights.iter_mut() {
            let temp = el.m1;
            let fc = el.count as f64;
            let ffn = n as f64;
            let fd = d as f64;
            let res = ((ffn - 2.0 * fc) * el.m1 - ((ffn - fd + 1.0) * el.m0)) / (fd + 1.0);
            el.m0 = temp;
            el.m1 = res;
            //let el = MapElems{count: el.count, m0: temp, m1: res};

            //*self.weights.get_mut(&k).unwrap() = el;
        }
    }

    pub fn calc_bi(&self) -> f64 {
        let mut res = 0.0 as f64;
        for (_, el) in &self.weights {
            res += (el.count as f64) * el.m1;
        }
        res
    }
}
