//! Compute any CRC.
//!
//! Given a set of parameters describing a CRC, compute
//! CRCs or generate code to do so.
//!
//! ### Examples
//!
//! ### Procedural macro
//!
//! ```
//! use crcany::impl_crc;
//!
//! impl_crc!("CRC-3/GSM");
//!
//! let mut crc = crc3gsm::bitwise::Crc3Gsm::new();
//! crc.add_bytes(b"123456789");
//! assert_eq!(4, crc.into_inner());
//! ```
//!
//! #### Evaluate a model
//!
//! ```
//! use crcany::crc::Computer;
//! use crcany::model::BitwiseModel;
//!
//! let spec = "w=3 p=3 r=t c=2 res=3 n=POOH".parse().unwrap();
//! let bitwise = BitwiseModel::from_spec(spec);
//! let crc = Computer::crc(bitwise, b"123456789");
//! ```

pub use crcany_core::*;
pub use crcany_macro::*;
