use crcany::impl_all;

impl_all!();

fn main() {
    let mut crc = crc3gsm::bitwise::Crc3Gsm::new();

    crc.add_bytes(b"123456789");

    let res = crc.into_inner();
    if res != 4 {
        println!("Error on GSM-3, expected {}, got {}", 4, res);
    }

    let mut crc = crc12umts::bitwise::Crc12Umts::new();

    crc.add_bytes(b"123456789");

    let res = crc.into_inner();
    if res != 3503 {
        println!(
            "Error on UMTS-12, expected {}, got {}",
            3503,
            res
        );
    }

    let mut crc = crc16kermit::bitwise::Crc16Kermit::new();

    crc.add_bytes(b"123456789");

    let res = crc.into_inner();
    if res != 8585 {
        println!(
            "Error on KERMIT-16, expected {}, got {}",
            8585,
            res
        );
    }
}
