use quote::quote;

use crcany::gen::gen_bitwise;
use crcany::spec::Spec;

const ALL_CRCS: &str = include_str!(concat!(env!("CARGO_MANIFEST_DIR"), "/allcrcs.txt"));

fn main() {
    const KERMIT_ABBR: &str = "w=16 p=4129 r=t c=8585 n=KERMIT";
    let spec: Spec = KERMIT_ABBR.parse().unwrap();
    let tokens1 = gen_bitwise(&spec);

    const GSM3_ABBR: &str = "w=3 p=3 r=f x=7 c=4 res=2 n=CRC-3/GSM";
    let spec: Spec = GSM3_ABBR.parse().unwrap();
    let tokens2 = gen_bitwise(&spec);

    const UMTS12_ABBR: &str = "w=12 p=2063 r=f refo=t c=3503 n=CRC-12/UMTS";
    let spec: Spec = UMTS12_ABBR.parse().unwrap();
    let tokens3 = gen_bitwise(&spec);

    let tokens = quote! {
        #tokens1
        #tokens2
        #tokens3
    };

    println!("{}", tokens);

    let all_specs: Vec<Spec> = ALL_CRCS
        .lines()
        .map(|line| line.parse())
        .collect::<Result<Vec<_>, _>>()
        .unwrap();

    for spec in all_specs {
        println!("{}", gen_bitwise(&spec));
    }
}
