crcany-rs
=========

A port of Mark Adler's _crcany_ package to Rust.

Compute any CRC given the set of parameters that describe it. For more
information, see [crcany](https://github.com/madler/crcany), Gary Cook's
[catalog of CRC parameters](https://reveng.sourceforge.io/crc-catalogue/all.htm)
(the data source for these implementations), or Ross Williams's original
[tutorial](http://zlib.net/crc_v3.txt), which first specified the parameters.

The library includes two ways to compute CRCs: either the parameter model is
directly evaluated, or a procedural macro is used to generate code to
handle a specific CRC.  In either case, the CRCs can be calculated directly,
in a bitwise fashion, or bytewise or wordwise with the use of precalculated
tables.

Examples
--------

### Procedural macro

```
use crcany::crc::v2::Crc;
use crcany::impl_crc;

impl_crc!("CRC-3/GSM");

let mut crc = crc3gsm::bitwise::Crc3Gsm::new();
crc.add_bytes(b"123456789");
assert_eq!(4, crc.to_inner());
```

### Evaluating a model

```
use crcany::crc::{Crc, FromSpec};
use crcany::model::BitwiseModel;

let spec = "w=3 p=3 r=t c=2 res=3 n=POOH".parse().unwrap();
let bitwise = BitwiseModel::from_spec(spec);
let init = bitwise.crc(0, [].iter().cloned());
let crc = bitwise.crc(init, b"123456789".iter().cloned());
assert_eq!(2, crc);
```
