mod bitwise;
pub use bitwise::*;
mod bytewise;
pub use bytewise::*;
mod wordwise;
pub use wordwise::*;
mod combining;
pub use combining::*;

#[cfg(test)]
mod test {
    use super::*;
    use crate::crc::Computer;
    use crate::spec::Spec;

    fn kermit() -> Spec {
        Spec {
            width: 16,
            poly: 0x1021,
            init: 0,
            refin: true,
            refout: true,
            xorout: 0,
            check: 0x2189,
            residue: 0,
            name: "KERMIT".into(),
        }
    }

    #[test]
    fn kermit_bitwise() {
        let model = BitwiseModel::from_spec(kermit());

        let input = b"123456789";

        let output = Computer::crc(model, &input[..]);

        assert_eq!(0x2189, output);
    }

    #[test]
    fn kermit_bytewise() {
        let model = BytewiseModel::from_spec(kermit());

        let input = b"123456789";

        let output = Computer::crc(model, &input[..]);

        assert_eq!(0x2189, output);
    }

    #[test]
    fn kermit_wordwise_nativeendian() {
        let model =
            WordwiseModel::<byteorder::NativeEndian, { usize::BITS as _ }>::from_spec(kermit());

        let input = b"123456789";

        let output = Computer::crc(model, &input[..]);

        assert_eq!(0x2189, output);
    }
}
