pub trait Crc {
    type Int;

    fn init(&self) -> Self::Int;
    fn add_bytes(&self, previous: Self::Int, data: &[u8]) -> Self::Int;
}

pub struct Computer<Algorithm: Crc> {
    crc: Algorithm,
    val: Algorithm::Int,
}

impl<'a, Algorithm: Crc> Computer<Algorithm> {
    pub fn new(crc: Algorithm) -> Self {
        let val = crc.init();
        Computer { crc, val }
    }

    pub fn add_bytes(&mut self, data: &[u8]) {
        let mut other = self.crc.init();
        std::mem::swap(&mut other, &mut self.val);
        self.val = self.crc.add_bytes(other, data);
    }

    pub fn into_inner(self) -> Algorithm::Int {
        self.val
    }

    pub fn crc(crc: Algorithm, data: &[u8]) -> Algorithm::Int {
        let mut state = Self::new(crc);
        state.add_bytes(data);
        state.into_inner()
    }
}

impl<T: Crc> Crc for &T {
    type Int = T::Int;
    fn init(&self) -> Self::Int {
        (*self).init()
    }
    fn add_bytes(&self, previous: Self::Int, data: &[u8]) -> Self::Int {
        (*self).add_bytes(previous, data)
    }
}
