pub trait Spec {
    /// number of bits in the CRC (the degree of the polynomial)
    const WIDTH: u16;
    /// polynomial representation (sans x^width)
    const POLY: u128;
    /// register initial value before first message bit
    const INIT: u128;
    /// if true, reflect input (read bits LSB first)
    const REFIN: bool;
    /// if true, reflect output
    const REFOUT: bool;
    /// final CRC is exclusive-or'ed with this
    const XOROUT: u128;
    /// CRC of the nine ASCII bytes "123456789"
    const CHECK: u128;
    /// residue of the CRC
    const RESIDUE: u128;
    /// text description of this CRC
    const NAME: &'static str;
}
