use crate::spec::Spec;

pub trait FromSpec {
    fn from_spec(spec: Spec) -> Self;
}

pub trait Crc: FromSpec {
    fn crc<I: Iterator<Item = u8>>(&self, crc: u128, dat: I) -> u128;
}

pub trait CrcSlice {
    type Crc;
    fn crc(&self, crc: Self::Crc, data: [u8]) -> Self::Crc;
}

pub mod v2 {
    pub trait Crc {
        type Int;
        fn new() -> Self;
        fn add_bytes(&mut self, data: &[u8]);
        fn to_inner(&self) -> Self::Int;
    }
}
