// To regenerate this bindings module: `cargo run --features=generate`

#![allow(deref_nullptr)]

/* automatically generated by rust-bindgen 0.59.2 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
  storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
  #[inline]
  pub const fn new(storage: Storage) -> Self {
    Self { storage }
  }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
  Storage: AsRef<[u8]> + AsMut<[u8]>,
{
  #[inline]
  pub fn get_bit(&self, index: usize) -> bool {
    debug_assert!(index / 8 < self.storage.as_ref().len());
    let byte_index = index / 8;
    let byte = self.storage.as_ref()[byte_index];
    let bit_index = if cfg!(target_endian = "big") {
      7 - (index % 8)
    } else {
      index % 8
    };
    let mask = 1 << bit_index;
    byte & mask == mask
  }
  #[inline]
  pub fn set_bit(&mut self, index: usize, val: bool) {
    debug_assert!(index / 8 < self.storage.as_ref().len());
    let byte_index = index / 8;
    let byte = &mut self.storage.as_mut()[byte_index];
    let bit_index = if cfg!(target_endian = "big") {
      7 - (index % 8)
    } else {
      index % 8
    };
    let mask = 1 << bit_index;
    if val {
      *byte |= mask;
    } else {
      *byte &= !mask;
    }
  }
  #[inline]
  pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
    debug_assert!(bit_width <= 64);
    debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
    debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
    let mut val = 0;
    for i in 0..(bit_width as usize) {
      if self.get_bit(i + bit_offset) {
        let index = if cfg!(target_endian = "big") {
          bit_width as usize - 1 - i
        } else {
          i
        };
        val |= 1 << index;
      }
    }
    val
  }
  #[inline]
  pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
    debug_assert!(bit_width <= 64);
    debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
    debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
    for i in 0..(bit_width as usize) {
      let mask = 1 << i;
      let val_bit_is_set = val & mask == mask;
      let index = if cfg!(target_endian = "big") {
        bit_width as usize - 1 - i
      } else {
        i
      };
      self.set_bit(index + bit_offset, val_bit_is_set);
    }
  }
}
pub const LCD_COLUMNS: u32 = 400;
pub const LCD_ROWS: u32 = 240;
pub const LCD_ROWSIZE: u32 = 52;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub type size_t = super::ctypes::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LCDRect {
  pub left: super::ctypes::c_int,
  pub right: super::ctypes::c_int,
  pub top: super::ctypes::c_int,
  pub bottom: super::ctypes::c_int,
}
#[test]
fn bindgen_test_layout_LCDRect() {
  assert_eq!(
    ::core::mem::size_of::<LCDRect>(),
    16usize,
    concat!("Size of: ", stringify!(LCDRect))
  );
  assert_eq!(
    ::core::mem::align_of::<LCDRect>(),
    4usize,
    concat!("Alignment of ", stringify!(LCDRect))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<LCDRect>())).left as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(LCDRect),
      "::",
      stringify!(left)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<LCDRect>())).right as *const _ as usize },
    4usize,
    concat!(
      "Offset of field: ",
      stringify!(LCDRect),
      "::",
      stringify!(right)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<LCDRect>())).top as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(LCDRect),
      "::",
      stringify!(top)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<LCDRect>())).bottom as *const _ as usize },
    12usize,
    concat!(
      "Offset of field: ",
      stringify!(LCDRect),
      "::",
      stringify!(bottom)
    )
  );
}
impl LCDBitmapDrawMode {
  pub const kDrawModeCopy: LCDBitmapDrawMode = LCDBitmapDrawMode(0);
}
impl LCDBitmapDrawMode {
  pub const kDrawModeWhiteTransparent: LCDBitmapDrawMode = LCDBitmapDrawMode(1);
}
impl LCDBitmapDrawMode {
  pub const kDrawModeBlackTransparent: LCDBitmapDrawMode = LCDBitmapDrawMode(2);
}
impl LCDBitmapDrawMode {
  pub const kDrawModeFillWhite: LCDBitmapDrawMode = LCDBitmapDrawMode(3);
}
impl LCDBitmapDrawMode {
  pub const kDrawModeFillBlack: LCDBitmapDrawMode = LCDBitmapDrawMode(4);
}
impl LCDBitmapDrawMode {
  pub const kDrawModeXOR: LCDBitmapDrawMode = LCDBitmapDrawMode(5);
}
impl LCDBitmapDrawMode {
  pub const kDrawModeNXOR: LCDBitmapDrawMode = LCDBitmapDrawMode(6);
}
impl LCDBitmapDrawMode {
  pub const kDrawModeInverted: LCDBitmapDrawMode = LCDBitmapDrawMode(7);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct LCDBitmapDrawMode(pub super::ctypes::c_int);
impl LCDBitmapFlip {
  pub const kBitmapUnflipped: LCDBitmapFlip = LCDBitmapFlip(0);
}
impl LCDBitmapFlip {
  pub const kBitmapFlippedX: LCDBitmapFlip = LCDBitmapFlip(1);
}
impl LCDBitmapFlip {
  pub const kBitmapFlippedY: LCDBitmapFlip = LCDBitmapFlip(2);
}
impl LCDBitmapFlip {
  pub const kBitmapFlippedXY: LCDBitmapFlip = LCDBitmapFlip(3);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct LCDBitmapFlip(pub super::ctypes::c_int);
impl LCDSolidColor {
  pub const kColorBlack: LCDSolidColor = LCDSolidColor(0);
}
impl LCDSolidColor {
  pub const kColorWhite: LCDSolidColor = LCDSolidColor(1);
}
impl LCDSolidColor {
  pub const kColorClear: LCDSolidColor = LCDSolidColor(2);
}
impl LCDSolidColor {
  pub const kColorXOR: LCDSolidColor = LCDSolidColor(3);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct LCDSolidColor(pub super::ctypes::c_int);
impl LCDLineCapStyle {
  pub const kLineCapStyleButt: LCDLineCapStyle = LCDLineCapStyle(0);
}
impl LCDLineCapStyle {
  pub const kLineCapStyleSquare: LCDLineCapStyle = LCDLineCapStyle(1);
}
impl LCDLineCapStyle {
  pub const kLineCapStyleRound: LCDLineCapStyle = LCDLineCapStyle(2);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct LCDLineCapStyle(pub super::ctypes::c_int);
impl PDStringEncoding {
  pub const kASCIIEncoding: PDStringEncoding = PDStringEncoding(0);
}
impl PDStringEncoding {
  pub const kUTF8Encoding: PDStringEncoding = PDStringEncoding(1);
}
impl PDStringEncoding {
  pub const k16BitLEEncoding: PDStringEncoding = PDStringEncoding(2);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct PDStringEncoding(pub super::ctypes::c_int);
pub type LCDPattern = [u8; 16usize];
pub type LCDColor = usize;
impl LCDPolygonFillRule {
  pub const kPolygonFillNonZero: LCDPolygonFillRule = LCDPolygonFillRule(0);
}
impl LCDPolygonFillRule {
  pub const kPolygonFillEvenOdd: LCDPolygonFillRule = LCDPolygonFillRule(1);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct LCDPolygonFillRule(pub super::ctypes::c_int);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LCDBitmap {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LCDBitmapTable {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LCDFont {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LCDFontPage {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LCDFontGlyph {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LCDVideoPlayer {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_video {
  pub loadVideo: ::core::option::Option<
    unsafe extern "C" fn(path: *const super::ctypes::c_char) -> *mut LCDVideoPlayer,
  >,
  pub freePlayer: ::core::option::Option<unsafe extern "C" fn(p: *mut LCDVideoPlayer)>,
  pub setContext: ::core::option::Option<
    unsafe extern "C" fn(p: *mut LCDVideoPlayer, context: *mut LCDBitmap) -> super::ctypes::c_int,
  >,
  pub useScreenContext: ::core::option::Option<unsafe extern "C" fn(p: *mut LCDVideoPlayer)>,
  pub renderFrame: ::core::option::Option<
    unsafe extern "C" fn(p: *mut LCDVideoPlayer, n: super::ctypes::c_int) -> super::ctypes::c_int,
  >,
  pub getError: ::core::option::Option<
    unsafe extern "C" fn(p: *mut LCDVideoPlayer) -> *const super::ctypes::c_char,
  >,
  pub getInfo: ::core::option::Option<
    unsafe extern "C" fn(
      p: *mut LCDVideoPlayer,
      outWidth: *mut super::ctypes::c_int,
      outHeight: *mut super::ctypes::c_int,
      outFrameRate: *mut f32,
      outFrameCount: *mut super::ctypes::c_int,
      outCurrentFrame: *mut super::ctypes::c_int,
    ),
  >,
  pub getContext:
    ::core::option::Option<unsafe extern "C" fn(p: *mut LCDVideoPlayer) -> *mut LCDBitmap>,
}
#[test]
fn bindgen_test_layout_playdate_video() {
  assert_eq!(
    ::core::mem::size_of::<playdate_video>(),
    64usize,
    concat!("Size of: ", stringify!(playdate_video))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_video>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_video))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_video>())).loadVideo as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_video),
      "::",
      stringify!(loadVideo)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_video>())).freePlayer as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_video),
      "::",
      stringify!(freePlayer)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_video>())).setContext as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_video),
      "::",
      stringify!(setContext)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_video>())).useScreenContext as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_video),
      "::",
      stringify!(useScreenContext)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_video>())).renderFrame as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_video),
      "::",
      stringify!(renderFrame)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_video>())).getError as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_video),
      "::",
      stringify!(getError)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_video>())).getInfo as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_video),
      "::",
      stringify!(getInfo)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_video>())).getContext as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_video),
      "::",
      stringify!(getContext)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_graphics {
  pub video: *const playdate_video,
  pub clear: ::core::option::Option<unsafe extern "C" fn(color: LCDColor)>,
  pub setBackgroundColor: ::core::option::Option<unsafe extern "C" fn(color: LCDSolidColor)>,
  pub setStencil: ::core::option::Option<unsafe extern "C" fn(stencil: *mut LCDBitmap)>,
  pub setDrawMode: ::core::option::Option<unsafe extern "C" fn(mode: LCDBitmapDrawMode)>,
  pub setDrawOffset: ::core::option::Option<
    unsafe extern "C" fn(dx: super::ctypes::c_int, dy: super::ctypes::c_int),
  >,
  pub setClipRect: ::core::option::Option<
    unsafe extern "C" fn(
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
      width: super::ctypes::c_int,
      height: super::ctypes::c_int,
    ),
  >,
  pub clearClipRect: ::core::option::Option<unsafe extern "C" fn()>,
  pub setLineCapStyle: ::core::option::Option<unsafe extern "C" fn(endCapStyle: LCDLineCapStyle)>,
  pub setFont: ::core::option::Option<unsafe extern "C" fn(font: *mut LCDFont)>,
  pub setTextTracking: ::core::option::Option<unsafe extern "C" fn(tracking: super::ctypes::c_int)>,
  pub pushContext: ::core::option::Option<unsafe extern "C" fn(target: *mut LCDBitmap)>,
  pub popContext: ::core::option::Option<unsafe extern "C" fn()>,
  pub drawBitmap: ::core::option::Option<
    unsafe extern "C" fn(
      bitmap: *mut LCDBitmap,
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
      flip: LCDBitmapFlip,
    ),
  >,
  pub tileBitmap: ::core::option::Option<
    unsafe extern "C" fn(
      bitmap: *mut LCDBitmap,
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
      width: super::ctypes::c_int,
      height: super::ctypes::c_int,
      flip: LCDBitmapFlip,
    ),
  >,
  pub drawLine: ::core::option::Option<
    unsafe extern "C" fn(
      x1: super::ctypes::c_int,
      y1: super::ctypes::c_int,
      x2: super::ctypes::c_int,
      y2: super::ctypes::c_int,
      width: super::ctypes::c_int,
      color: LCDColor,
    ),
  >,
  pub fillTriangle: ::core::option::Option<
    unsafe extern "C" fn(
      x1: super::ctypes::c_int,
      y1: super::ctypes::c_int,
      x2: super::ctypes::c_int,
      y2: super::ctypes::c_int,
      x3: super::ctypes::c_int,
      y3: super::ctypes::c_int,
      color: LCDColor,
    ),
  >,
  pub drawRect: ::core::option::Option<
    unsafe extern "C" fn(
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
      width: super::ctypes::c_int,
      height: super::ctypes::c_int,
      color: LCDColor,
    ),
  >,
  pub fillRect: ::core::option::Option<
    unsafe extern "C" fn(
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
      width: super::ctypes::c_int,
      height: super::ctypes::c_int,
      color: LCDColor,
    ),
  >,
  pub drawEllipse: ::core::option::Option<
    unsafe extern "C" fn(
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
      width: super::ctypes::c_int,
      height: super::ctypes::c_int,
      lineWidth: super::ctypes::c_int,
      startAngle: f32,
      endAngle: f32,
      color: LCDColor,
    ),
  >,
  pub fillEllipse: ::core::option::Option<
    unsafe extern "C" fn(
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
      width: super::ctypes::c_int,
      height: super::ctypes::c_int,
      startAngle: f32,
      endAngle: f32,
      color: LCDColor,
    ),
  >,
  pub drawScaledBitmap: ::core::option::Option<
    unsafe extern "C" fn(
      bitmap: *mut LCDBitmap,
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
      xscale: f32,
      yscale: f32,
    ),
  >,
  pub drawText: ::core::option::Option<
    unsafe extern "C" fn(
      text: *const super::ctypes::c_void,
      len: size_t,
      encoding: PDStringEncoding,
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
    ) -> super::ctypes::c_int,
  >,
  pub newBitmap: ::core::option::Option<
    unsafe extern "C" fn(
      width: super::ctypes::c_int,
      height: super::ctypes::c_int,
      bgcolor: LCDColor,
    ) -> *mut LCDBitmap,
  >,
  pub freeBitmap: ::core::option::Option<unsafe extern "C" fn(arg1: *mut LCDBitmap)>,
  pub loadBitmap: ::core::option::Option<
    unsafe extern "C" fn(
      path: *const super::ctypes::c_char,
      outerr: *mut *const super::ctypes::c_char,
    ) -> *mut LCDBitmap,
  >,
  pub copyBitmap:
    ::core::option::Option<unsafe extern "C" fn(bitmap: *mut LCDBitmap) -> *mut LCDBitmap>,
  pub loadIntoBitmap: ::core::option::Option<
    unsafe extern "C" fn(
      path: *const super::ctypes::c_char,
      bitmap: *mut LCDBitmap,
      outerr: *mut *const super::ctypes::c_char,
    ),
  >,
  pub getBitmapData: ::core::option::Option<
    unsafe extern "C" fn(
      bitmap: *mut LCDBitmap,
      width: *mut super::ctypes::c_int,
      height: *mut super::ctypes::c_int,
      rowbytes: *mut super::ctypes::c_int,
      hasmask: *mut super::ctypes::c_int,
      data: *mut *mut u8,
    ),
  >,
  pub clearBitmap:
    ::core::option::Option<unsafe extern "C" fn(bitmap: *mut LCDBitmap, bgcolor: LCDColor)>,
  pub rotatedBitmap: ::core::option::Option<
    unsafe extern "C" fn(
      bitmap: *mut LCDBitmap,
      rotation: f32,
      xscale: f32,
      yscale: f32,
      allocedSize: *mut super::ctypes::c_int,
    ) -> *mut LCDBitmap,
  >,
  pub newBitmapTable: ::core::option::Option<
    unsafe extern "C" fn(
      count: super::ctypes::c_int,
      width: super::ctypes::c_int,
      height: super::ctypes::c_int,
    ) -> *mut LCDBitmapTable,
  >,
  pub freeBitmapTable: ::core::option::Option<unsafe extern "C" fn(table: *mut LCDBitmapTable)>,
  pub loadBitmapTable: ::core::option::Option<
    unsafe extern "C" fn(
      path: *const super::ctypes::c_char,
      outerr: *mut *const super::ctypes::c_char,
    ) -> *mut LCDBitmapTable,
  >,
  pub loadIntoBitmapTable: ::core::option::Option<
    unsafe extern "C" fn(
      path: *const super::ctypes::c_char,
      table: *mut LCDBitmapTable,
      outerr: *mut *const super::ctypes::c_char,
    ),
  >,
  pub getTableBitmap: ::core::option::Option<
    unsafe extern "C" fn(table: *mut LCDBitmapTable, idx: super::ctypes::c_int) -> *mut LCDBitmap,
  >,
  pub loadFont: ::core::option::Option<
    unsafe extern "C" fn(
      path: *const super::ctypes::c_char,
      outErr: *mut *const super::ctypes::c_char,
    ) -> *mut LCDFont,
  >,
  pub getFontPage:
    ::core::option::Option<unsafe extern "C" fn(font: *mut LCDFont, c: u32) -> *mut LCDFontPage>,
  pub getPageGlyph: ::core::option::Option<
    unsafe extern "C" fn(
      page: *mut LCDFontPage,
      c: u32,
      bitmap: *mut *mut LCDBitmap,
      advance: *mut super::ctypes::c_int,
    ) -> *mut LCDFontGlyph,
  >,
  pub getGlyphKerning: ::core::option::Option<
    unsafe extern "C" fn(
      glyph: *mut LCDFontGlyph,
      glyphcode: u32,
      nextcode: u32,
    ) -> super::ctypes::c_int,
  >,
  pub getTextWidth: ::core::option::Option<
    unsafe extern "C" fn(
      font: *mut LCDFont,
      text: *const super::ctypes::c_void,
      len: size_t,
      encoding: PDStringEncoding,
      tracking: super::ctypes::c_int,
    ) -> super::ctypes::c_int,
  >,
  pub getFrame: ::core::option::Option<unsafe extern "C" fn() -> *mut u8>,
  pub getDisplayFrame: ::core::option::Option<unsafe extern "C" fn() -> *mut u8>,
  pub getDebugBitmap: ::core::option::Option<unsafe extern "C" fn() -> *mut LCDBitmap>,
  pub copyFrameBufferBitmap: ::core::option::Option<unsafe extern "C" fn() -> *mut LCDBitmap>,
  pub markUpdatedRows: ::core::option::Option<
    unsafe extern "C" fn(start: super::ctypes::c_int, end: super::ctypes::c_int),
  >,
  pub display: ::core::option::Option<unsafe extern "C" fn()>,
  pub setColorToPattern: ::core::option::Option<
    unsafe extern "C" fn(
      color: *mut LCDColor,
      bitmap: *mut LCDBitmap,
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
    ),
  >,
  pub checkMaskCollision: ::core::option::Option<
    unsafe extern "C" fn(
      bitmap1: *mut LCDBitmap,
      x1: super::ctypes::c_int,
      y1: super::ctypes::c_int,
      flip1: LCDBitmapFlip,
      bitmap2: *mut LCDBitmap,
      x2: super::ctypes::c_int,
      y2: super::ctypes::c_int,
      flip2: LCDBitmapFlip,
      rect: LCDRect,
    ) -> super::ctypes::c_int,
  >,
  pub setScreenClipRect: ::core::option::Option<
    unsafe extern "C" fn(
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
      width: super::ctypes::c_int,
      height: super::ctypes::c_int,
    ),
  >,
  pub fillPolygon: ::core::option::Option<
    unsafe extern "C" fn(
      nPoints: super::ctypes::c_int,
      coords: *mut super::ctypes::c_int,
      color: LCDColor,
      fillrule: LCDPolygonFillRule,
    ),
  >,
  pub getFontHeight: ::core::option::Option<unsafe extern "C" fn(font: *mut LCDFont) -> u8>,
  pub getDisplayBufferBitmap: ::core::option::Option<unsafe extern "C" fn() -> *mut LCDBitmap>,
  pub drawRotatedBitmap: ::core::option::Option<
    unsafe extern "C" fn(
      bitmap: *mut LCDBitmap,
      x: super::ctypes::c_int,
      y: super::ctypes::c_int,
      rotation: f32,
      centerx: f32,
      centery: f32,
      xscale: f32,
      yscale: f32,
    ),
  >,
  pub setTextLeading:
    ::core::option::Option<unsafe extern "C" fn(lineHeightAdustment: super::ctypes::c_int)>,
  pub setBitmapMask: ::core::option::Option<
    unsafe extern "C" fn(bitmap: *mut LCDBitmap, mask: *mut LCDBitmap) -> super::ctypes::c_int,
  >,
  pub getBitmapMask:
    ::core::option::Option<unsafe extern "C" fn(bitmap: *mut LCDBitmap) -> *mut LCDBitmap>,
  pub setStencilImage: ::core::option::Option<
    unsafe extern "C" fn(stencil: *mut LCDBitmap, tile: super::ctypes::c_int),
  >,
}
#[test]
fn bindgen_test_layout_playdate_graphics() {
  assert_eq!(
    ::core::mem::size_of::<playdate_graphics>(),
    464usize,
    concat!("Size of: ", stringify!(playdate_graphics))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_graphics>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_graphics))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).video as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(video)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).clear as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(clear)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_graphics>())).setBackgroundColor as *const _ as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setBackgroundColor)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).setStencil as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setStencil)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).setDrawMode as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setDrawMode)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).setDrawOffset as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setDrawOffset)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).setClipRect as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setClipRect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).clearClipRect as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(clearClipRect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).setLineCapStyle as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setLineCapStyle)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).setFont as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setFont)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).setTextTracking as *const _ as usize },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setTextTracking)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).pushContext as *const _ as usize },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(pushContext)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).popContext as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(popContext)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).drawBitmap as *const _ as usize },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(drawBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).tileBitmap as *const _ as usize },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(tileBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).drawLine as *const _ as usize },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(drawLine)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).fillTriangle as *const _ as usize },
    128usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(fillTriangle)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).drawRect as *const _ as usize },
    136usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(drawRect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).fillRect as *const _ as usize },
    144usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(fillRect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).drawEllipse as *const _ as usize },
    152usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(drawEllipse)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).fillEllipse as *const _ as usize },
    160usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(fillEllipse)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).drawScaledBitmap as *const _ as usize },
    168usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(drawScaledBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).drawText as *const _ as usize },
    176usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(drawText)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).newBitmap as *const _ as usize },
    184usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(newBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).freeBitmap as *const _ as usize },
    192usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(freeBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).loadBitmap as *const _ as usize },
    200usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(loadBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).copyBitmap as *const _ as usize },
    208usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(copyBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).loadIntoBitmap as *const _ as usize },
    216usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(loadIntoBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getBitmapData as *const _ as usize },
    224usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getBitmapData)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).clearBitmap as *const _ as usize },
    232usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(clearBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).rotatedBitmap as *const _ as usize },
    240usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(rotatedBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).newBitmapTable as *const _ as usize },
    248usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(newBitmapTable)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).freeBitmapTable as *const _ as usize },
    256usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(freeBitmapTable)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).loadBitmapTable as *const _ as usize },
    264usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(loadBitmapTable)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_graphics>())).loadIntoBitmapTable as *const _ as usize
    },
    272usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(loadIntoBitmapTable)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getTableBitmap as *const _ as usize },
    280usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getTableBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).loadFont as *const _ as usize },
    288usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(loadFont)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getFontPage as *const _ as usize },
    296usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getFontPage)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getPageGlyph as *const _ as usize },
    304usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getPageGlyph)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getGlyphKerning as *const _ as usize },
    312usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getGlyphKerning)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getTextWidth as *const _ as usize },
    320usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getTextWidth)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getFrame as *const _ as usize },
    328usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getFrame)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getDisplayFrame as *const _ as usize },
    336usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getDisplayFrame)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getDebugBitmap as *const _ as usize },
    344usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getDebugBitmap)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_graphics>())).copyFrameBufferBitmap as *const _ as usize
    },
    352usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(copyFrameBufferBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).markUpdatedRows as *const _ as usize },
    360usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(markUpdatedRows)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).display as *const _ as usize },
    368usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(display)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_graphics>())).setColorToPattern as *const _ as usize
    },
    376usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setColorToPattern)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_graphics>())).checkMaskCollision as *const _ as usize
    },
    384usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(checkMaskCollision)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_graphics>())).setScreenClipRect as *const _ as usize
    },
    392usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setScreenClipRect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).fillPolygon as *const _ as usize },
    400usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(fillPolygon)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getFontHeight as *const _ as usize },
    408usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getFontHeight)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_graphics>())).getDisplayBufferBitmap as *const _ as usize
    },
    416usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getDisplayBufferBitmap)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_graphics>())).drawRotatedBitmap as *const _ as usize
    },
    424usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(drawRotatedBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).setTextLeading as *const _ as usize },
    432usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setTextLeading)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).setBitmapMask as *const _ as usize },
    440usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setBitmapMask)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).getBitmapMask as *const _ as usize },
    448usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(getBitmapMask)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_graphics>())).setStencilImage as *const _ as usize },
    456usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_graphics),
      "::",
      stringify!(setStencilImage)
    )
  );
}
impl PDButtons {
  pub const kButtonLeft: PDButtons = PDButtons(1);
}
impl PDButtons {
  pub const kButtonRight: PDButtons = PDButtons(2);
}
impl PDButtons {
  pub const kButtonUp: PDButtons = PDButtons(4);
}
impl PDButtons {
  pub const kButtonDown: PDButtons = PDButtons(8);
}
impl PDButtons {
  pub const kButtonB: PDButtons = PDButtons(16);
}
impl PDButtons {
  pub const kButtonA: PDButtons = PDButtons(32);
}
impl ::core::ops::BitOr<PDButtons> for PDButtons {
  type Output = Self;
  #[inline]
  fn bitor(self, other: Self) -> Self {
    PDButtons(self.0 | other.0)
  }
}
impl ::core::ops::BitOrAssign for PDButtons {
  #[inline]
  fn bitor_assign(&mut self, rhs: PDButtons) {
    self.0 |= rhs.0;
  }
}
impl ::core::ops::BitAnd<PDButtons> for PDButtons {
  type Output = Self;
  #[inline]
  fn bitand(self, other: Self) -> Self {
    PDButtons(self.0 & other.0)
  }
}
impl ::core::ops::BitAndAssign for PDButtons {
  #[inline]
  fn bitand_assign(&mut self, rhs: PDButtons) {
    self.0 &= rhs.0;
  }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct PDButtons(pub super::ctypes::c_int);
impl PDLanguage {
  pub const kPDLanguageEnglish: PDLanguage = PDLanguage(0);
}
impl PDLanguage {
  pub const kPDLanguageJapanese: PDLanguage = PDLanguage(1);
}
impl PDLanguage {
  pub const kPDLanguageUnknown: PDLanguage = PDLanguage(2);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct PDLanguage(pub super::ctypes::c_int);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDMenuItem {
  _unused: [u8; 0],
}
impl PDPeripherals {
  pub const kNone: PDPeripherals = PDPeripherals(0);
}
impl PDPeripherals {
  pub const kAccelerometer: PDPeripherals = PDPeripherals(1);
}
impl PDPeripherals {
  pub const kAllPeripherals: PDPeripherals = PDPeripherals(65535);
}
impl ::core::ops::BitOr<PDPeripherals> for PDPeripherals {
  type Output = Self;
  #[inline]
  fn bitor(self, other: Self) -> Self {
    PDPeripherals(self.0 | other.0)
  }
}
impl ::core::ops::BitOrAssign for PDPeripherals {
  #[inline]
  fn bitor_assign(&mut self, rhs: PDPeripherals) {
    self.0 |= rhs.0;
  }
}
impl ::core::ops::BitAnd<PDPeripherals> for PDPeripherals {
  type Output = Self;
  #[inline]
  fn bitand(self, other: Self) -> Self {
    PDPeripherals(self.0 & other.0)
  }
}
impl ::core::ops::BitAndAssign for PDPeripherals {
  #[inline]
  fn bitand_assign(&mut self, rhs: PDPeripherals) {
    self.0 &= rhs.0;
  }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct PDPeripherals(pub super::ctypes::c_int);
pub type PDCallbackFunction = ::core::option::Option<
  unsafe extern "C" fn(userdata: *mut super::ctypes::c_void) -> super::ctypes::c_int,
>;
pub type PDMenuItemCallbackFunction =
  ::core::option::Option<unsafe extern "C" fn(userdata: *mut super::ctypes::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sys {
  pub realloc: ::core::option::Option<
    unsafe extern "C" fn(
      ptr: *mut super::ctypes::c_void,
      size: size_t,
    ) -> *mut super::ctypes::c_void,
  >,
  pub formatString: ::core::option::Option<
    unsafe extern "C" fn(
      ret: *mut *mut super::ctypes::c_char,
      fmt: *const super::ctypes::c_char,
      ...
    ) -> super::ctypes::c_int,
  >,
  pub logToConsole:
    ::core::option::Option<unsafe extern "C" fn(fmt: *const super::ctypes::c_char, ...)>,
  pub error: ::core::option::Option<unsafe extern "C" fn(fmt: *const super::ctypes::c_char, ...)>,
  pub getLanguage: ::core::option::Option<unsafe extern "C" fn() -> PDLanguage>,
  pub getCurrentTimeMilliseconds:
    ::core::option::Option<unsafe extern "C" fn() -> super::ctypes::c_uint>,
  pub getSecondsSinceEpoch: ::core::option::Option<
    unsafe extern "C" fn(milliseconds: *mut super::ctypes::c_uint) -> super::ctypes::c_uint,
  >,
  pub drawFPS:
    ::core::option::Option<unsafe extern "C" fn(x: super::ctypes::c_int, y: super::ctypes::c_int)>,
  pub setUpdateCallback: ::core::option::Option<
    unsafe extern "C" fn(update: PDCallbackFunction, userdata: *mut super::ctypes::c_void),
  >,
  pub getButtonState: ::core::option::Option<
    unsafe extern "C" fn(current: *mut PDButtons, pushed: *mut PDButtons, released: *mut PDButtons),
  >,
  pub setPeripheralsEnabled: ::core::option::Option<unsafe extern "C" fn(mask: PDPeripherals)>,
  pub getAccelerometer:
    ::core::option::Option<unsafe extern "C" fn(outx: *mut f32, outy: *mut f32, outz: *mut f32)>,
  pub getCrankChange: ::core::option::Option<unsafe extern "C" fn() -> f32>,
  pub getCrankAngle: ::core::option::Option<unsafe extern "C" fn() -> f32>,
  pub isCrankDocked: ::core::option::Option<unsafe extern "C" fn() -> super::ctypes::c_int>,
  pub setCrankSoundsDisabled: ::core::option::Option<
    unsafe extern "C" fn(flag: super::ctypes::c_int) -> super::ctypes::c_int,
  >,
  pub getFlipped: ::core::option::Option<unsafe extern "C" fn() -> super::ctypes::c_int>,
  pub setAutoLockDisabled:
    ::core::option::Option<unsafe extern "C" fn(disable: super::ctypes::c_int)>,
  pub setMenuImage: ::core::option::Option<
    unsafe extern "C" fn(bitmap: *mut LCDBitmap, xOffset: super::ctypes::c_int),
  >,
  pub addMenuItem: ::core::option::Option<
    unsafe extern "C" fn(
      title: *const super::ctypes::c_char,
      callback: PDMenuItemCallbackFunction,
      userdata: *mut super::ctypes::c_void,
    ) -> *mut PDMenuItem,
  >,
  pub addCheckmarkMenuItem: ::core::option::Option<
    unsafe extern "C" fn(
      title: *const super::ctypes::c_char,
      value: super::ctypes::c_int,
      callback: PDMenuItemCallbackFunction,
      userdata: *mut super::ctypes::c_void,
    ) -> *mut PDMenuItem,
  >,
  pub addOptionsMenuItem: ::core::option::Option<
    unsafe extern "C" fn(
      title: *const super::ctypes::c_char,
      optionTitles: *mut *const super::ctypes::c_char,
      optionsCount: super::ctypes::c_int,
      f: PDMenuItemCallbackFunction,
      userdata: *mut super::ctypes::c_void,
    ) -> *mut PDMenuItem,
  >,
  pub removeAllMenuItems: ::core::option::Option<unsafe extern "C" fn()>,
  pub removeMenuItem: ::core::option::Option<unsafe extern "C" fn(menuItem: *mut PDMenuItem)>,
  pub getMenuItemValue:
    ::core::option::Option<unsafe extern "C" fn(menuItem: *mut PDMenuItem) -> super::ctypes::c_int>,
  pub setMenuItemValue: ::core::option::Option<
    unsafe extern "C" fn(menuItem: *mut PDMenuItem, value: super::ctypes::c_int),
  >,
  pub getMenuItemTitle: ::core::option::Option<
    unsafe extern "C" fn(menuItem: *mut PDMenuItem) -> *const super::ctypes::c_char,
  >,
  pub setMenuItemTitle: ::core::option::Option<
    unsafe extern "C" fn(menuItem: *mut PDMenuItem, title: *const super::ctypes::c_char),
  >,
  pub getMenuItemUserdata: ::core::option::Option<
    unsafe extern "C" fn(menuItem: *mut PDMenuItem) -> *mut super::ctypes::c_void,
  >,
  pub setMenuItemUserdata: ::core::option::Option<
    unsafe extern "C" fn(menuItem: *mut PDMenuItem, ud: *mut super::ctypes::c_void),
  >,
  pub getReduceFlashing: ::core::option::Option<unsafe extern "C" fn() -> super::ctypes::c_int>,
  pub getElapsedTime: ::core::option::Option<unsafe extern "C" fn() -> f32>,
  pub resetElapsedTime: ::core::option::Option<unsafe extern "C" fn()>,
  pub getBatteryPercentage: ::core::option::Option<unsafe extern "C" fn() -> f32>,
  pub getBatteryVoltage: ::core::option::Option<unsafe extern "C" fn() -> f32>,
}
#[test]
fn bindgen_test_layout_playdate_sys() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sys>(),
    280usize,
    concat!("Size of: ", stringify!(playdate_sys))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sys>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sys))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).realloc as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(realloc)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).formatString as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(formatString)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).logToConsole as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(logToConsole)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).error as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(error)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getLanguage as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getLanguage)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sys>())).getCurrentTimeMilliseconds as *const _ as usize
    },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getCurrentTimeMilliseconds)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getSecondsSinceEpoch as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getSecondsSinceEpoch)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).drawFPS as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(drawFPS)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).setUpdateCallback as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(setUpdateCallback)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getButtonState as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getButtonState)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).setPeripheralsEnabled as *const _ as usize },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(setPeripheralsEnabled)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getAccelerometer as *const _ as usize },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getAccelerometer)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getCrankChange as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getCrankChange)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getCrankAngle as *const _ as usize },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getCrankAngle)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).isCrankDocked as *const _ as usize },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(isCrankDocked)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sys>())).setCrankSoundsDisabled as *const _ as usize
    },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(setCrankSoundsDisabled)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getFlipped as *const _ as usize },
    128usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getFlipped)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).setAutoLockDisabled as *const _ as usize },
    136usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(setAutoLockDisabled)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).setMenuImage as *const _ as usize },
    144usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(setMenuImage)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).addMenuItem as *const _ as usize },
    152usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(addMenuItem)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).addCheckmarkMenuItem as *const _ as usize },
    160usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(addCheckmarkMenuItem)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).addOptionsMenuItem as *const _ as usize },
    168usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(addOptionsMenuItem)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).removeAllMenuItems as *const _ as usize },
    176usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(removeAllMenuItems)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).removeMenuItem as *const _ as usize },
    184usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(removeMenuItem)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getMenuItemValue as *const _ as usize },
    192usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getMenuItemValue)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).setMenuItemValue as *const _ as usize },
    200usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(setMenuItemValue)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getMenuItemTitle as *const _ as usize },
    208usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getMenuItemTitle)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).setMenuItemTitle as *const _ as usize },
    216usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(setMenuItemTitle)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getMenuItemUserdata as *const _ as usize },
    224usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getMenuItemUserdata)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).setMenuItemUserdata as *const _ as usize },
    232usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(setMenuItemUserdata)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getReduceFlashing as *const _ as usize },
    240usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getReduceFlashing)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getElapsedTime as *const _ as usize },
    248usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getElapsedTime)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).resetElapsedTime as *const _ as usize },
    256usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(resetElapsedTime)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getBatteryPercentage as *const _ as usize },
    264usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getBatteryPercentage)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sys>())).getBatteryVoltage as *const _ as usize },
    272usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sys),
      "::",
      stringify!(getBatteryVoltage)
    )
  );
}
pub type lua_State = *mut super::ctypes::c_void;
pub type lua_CFunction =
  ::core::option::Option<unsafe extern "C" fn(L: *mut lua_State) -> super::ctypes::c_int>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct luaL_Val {
  pub name: *const super::ctypes::c_char,
  pub type_: luaL_Val__bindgen_ty_1,
  pub v: luaL_Val__bindgen_ty_2,
}
pub const luaL_Val_kInt: super::ctypes::c_int = 0;
pub const luaL_Val_kFloat: super::ctypes::c_int = 1;
pub const luaL_Val_kStr: super::ctypes::c_int = 2;
pub type luaL_Val__bindgen_ty_1 = super::ctypes::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union luaL_Val__bindgen_ty_2 {
  pub intval: super::ctypes::c_uint,
  pub floatval: f32,
  pub strval: *const super::ctypes::c_char,
}
#[test]
fn bindgen_test_layout_luaL_Val__bindgen_ty_2() {
  assert_eq!(
    ::core::mem::size_of::<luaL_Val__bindgen_ty_2>(),
    8usize,
    concat!("Size of: ", stringify!(luaL_Val__bindgen_ty_2))
  );
  assert_eq!(
    ::core::mem::align_of::<luaL_Val__bindgen_ty_2>(),
    8usize,
    concat!("Alignment of ", stringify!(luaL_Val__bindgen_ty_2))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<luaL_Val__bindgen_ty_2>())).intval as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(luaL_Val__bindgen_ty_2),
      "::",
      stringify!(intval)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<luaL_Val__bindgen_ty_2>())).floatval as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(luaL_Val__bindgen_ty_2),
      "::",
      stringify!(floatval)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<luaL_Val__bindgen_ty_2>())).strval as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(luaL_Val__bindgen_ty_2),
      "::",
      stringify!(strval)
    )
  );
}
#[test]
fn bindgen_test_layout_luaL_Val() {
  assert_eq!(
    ::core::mem::size_of::<luaL_Val>(),
    24usize,
    concat!("Size of: ", stringify!(luaL_Val))
  );
  assert_eq!(
    ::core::mem::align_of::<luaL_Val>(),
    8usize,
    concat!("Alignment of ", stringify!(luaL_Val))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<luaL_Val>())).name as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(luaL_Val),
      "::",
      stringify!(name)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<luaL_Val>())).type_ as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(luaL_Val),
      "::",
      stringify!(type_)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<luaL_Val>())).v as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(luaL_Val),
      "::",
      stringify!(v)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LuaUDObject {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LCDSprite {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lua_reg {
  pub name: *const super::ctypes::c_char,
  pub func: lua_CFunction,
}
#[test]
fn bindgen_test_layout_lua_reg() {
  assert_eq!(
    ::core::mem::size_of::<lua_reg>(),
    16usize,
    concat!("Size of: ", stringify!(lua_reg))
  );
  assert_eq!(
    ::core::mem::align_of::<lua_reg>(),
    8usize,
    concat!("Alignment of ", stringify!(lua_reg))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<lua_reg>())).name as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(lua_reg),
      "::",
      stringify!(name)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<lua_reg>())).func as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(lua_reg),
      "::",
      stringify!(func)
    )
  );
}
pub const LuaType_kTypeNil: LuaType = 0;
pub const LuaType_kTypeBool: LuaType = 1;
pub const LuaType_kTypeInt: LuaType = 2;
pub const LuaType_kTypeFloat: LuaType = 3;
pub const LuaType_kTypeString: LuaType = 4;
pub const LuaType_kTypeTable: LuaType = 5;
pub const LuaType_kTypeFunction: LuaType = 6;
pub const LuaType_kTypeThread: LuaType = 7;
pub const LuaType_kTypeObject: LuaType = 8;
pub type LuaType = super::ctypes::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_lua {
  pub addFunction: ::core::option::Option<
    unsafe extern "C" fn(
      f: lua_CFunction,
      name: *const super::ctypes::c_char,
      outErr: *mut *const super::ctypes::c_char,
    ) -> super::ctypes::c_int,
  >,
  pub registerClass: ::core::option::Option<
    unsafe extern "C" fn(
      name: *const super::ctypes::c_char,
      reg: *const lua_reg,
      vals: *const luaL_Val,
      isstatic: super::ctypes::c_int,
      outErr: *mut *const super::ctypes::c_char,
    ) -> super::ctypes::c_int,
  >,
  pub pushFunction: ::core::option::Option<unsafe extern "C" fn(f: lua_CFunction)>,
  pub indexMetatable: ::core::option::Option<unsafe extern "C" fn() -> super::ctypes::c_int>,
  pub stop: ::core::option::Option<unsafe extern "C" fn()>,
  pub start: ::core::option::Option<unsafe extern "C" fn()>,
  pub getArgCount: ::core::option::Option<unsafe extern "C" fn() -> super::ctypes::c_int>,
  pub getArgType: ::core::option::Option<
    unsafe extern "C" fn(
      pos: super::ctypes::c_int,
      outClass: *mut *const super::ctypes::c_char,
    ) -> LuaType,
  >,
  pub argIsNil:
    ::core::option::Option<unsafe extern "C" fn(pos: super::ctypes::c_int) -> super::ctypes::c_int>,
  pub getArgBool:
    ::core::option::Option<unsafe extern "C" fn(pos: super::ctypes::c_int) -> super::ctypes::c_int>,
  pub getArgInt:
    ::core::option::Option<unsafe extern "C" fn(pos: super::ctypes::c_int) -> super::ctypes::c_int>,
  pub getArgFloat: ::core::option::Option<unsafe extern "C" fn(pos: super::ctypes::c_int) -> f32>,
  pub getArgString: ::core::option::Option<
    unsafe extern "C" fn(pos: super::ctypes::c_int) -> *const super::ctypes::c_char,
  >,
  pub getArgBytes: ::core::option::Option<
    unsafe extern "C" fn(
      pos: super::ctypes::c_int,
      outlen: *mut size_t,
    ) -> *const super::ctypes::c_char,
  >,
  pub getArgObject: ::core::option::Option<
    unsafe extern "C" fn(
      pos: super::ctypes::c_int,
      type_: *mut super::ctypes::c_char,
      outud: *mut *mut LuaUDObject,
    ) -> *mut super::ctypes::c_void,
  >,
  pub getBitmap:
    ::core::option::Option<unsafe extern "C" fn(pos: super::ctypes::c_int) -> *mut LCDBitmap>,
  pub getSprite:
    ::core::option::Option<unsafe extern "C" fn(pos: super::ctypes::c_int) -> *mut LCDSprite>,
  pub pushNil: ::core::option::Option<unsafe extern "C" fn()>,
  pub pushBool: ::core::option::Option<unsafe extern "C" fn(val: super::ctypes::c_int)>,
  pub pushInt: ::core::option::Option<unsafe extern "C" fn(val: super::ctypes::c_int)>,
  pub pushFloat: ::core::option::Option<unsafe extern "C" fn(val: f32)>,
  pub pushString: ::core::option::Option<unsafe extern "C" fn(str_: *const super::ctypes::c_char)>,
  pub pushBytes:
    ::core::option::Option<unsafe extern "C" fn(str_: *const super::ctypes::c_char, len: size_t)>,
  pub pushBitmap: ::core::option::Option<unsafe extern "C" fn(bitmap: *mut LCDBitmap)>,
  pub pushSprite: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite)>,
  pub pushObject: ::core::option::Option<
    unsafe extern "C" fn(
      obj: *mut super::ctypes::c_void,
      type_: *mut super::ctypes::c_char,
      nValues: super::ctypes::c_int,
    ) -> *mut LuaUDObject,
  >,
  pub retainObject:
    ::core::option::Option<unsafe extern "C" fn(obj: *mut LuaUDObject) -> *mut LuaUDObject>,
  pub releaseObject: ::core::option::Option<unsafe extern "C" fn(obj: *mut LuaUDObject)>,
  pub setObjectValue:
    ::core::option::Option<unsafe extern "C" fn(obj: *mut LuaUDObject, slot: super::ctypes::c_int)>,
  pub getObjectValue: ::core::option::Option<
    unsafe extern "C" fn(obj: *mut LuaUDObject, slot: super::ctypes::c_int) -> super::ctypes::c_int,
  >,
  pub callFunction_deprecated: ::core::option::Option<
    unsafe extern "C" fn(name: *const super::ctypes::c_char, nargs: super::ctypes::c_int),
  >,
  pub callFunction: ::core::option::Option<
    unsafe extern "C" fn(
      name: *const super::ctypes::c_char,
      nargs: super::ctypes::c_int,
      outerr: *mut *const super::ctypes::c_char,
    ) -> super::ctypes::c_int,
  >,
}
#[test]
fn bindgen_test_layout_playdate_lua() {
  assert_eq!(
    ::core::mem::size_of::<playdate_lua>(),
    256usize,
    concat!("Size of: ", stringify!(playdate_lua))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_lua>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_lua))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).addFunction as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(addFunction)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).registerClass as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(registerClass)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).pushFunction as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(pushFunction)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).indexMetatable as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(indexMetatable)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).stop as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(stop)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).start as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(start)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getArgCount as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getArgCount)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getArgType as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getArgType)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).argIsNil as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(argIsNil)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getArgBool as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getArgBool)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getArgInt as *const _ as usize },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getArgInt)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getArgFloat as *const _ as usize },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getArgFloat)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getArgString as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getArgString)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getArgBytes as *const _ as usize },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getArgBytes)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getArgObject as *const _ as usize },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getArgObject)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getBitmap as *const _ as usize },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getSprite as *const _ as usize },
    128usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getSprite)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).pushNil as *const _ as usize },
    136usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(pushNil)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).pushBool as *const _ as usize },
    144usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(pushBool)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).pushInt as *const _ as usize },
    152usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(pushInt)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).pushFloat as *const _ as usize },
    160usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(pushFloat)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).pushString as *const _ as usize },
    168usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(pushString)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).pushBytes as *const _ as usize },
    176usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(pushBytes)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).pushBitmap as *const _ as usize },
    184usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(pushBitmap)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).pushSprite as *const _ as usize },
    192usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(pushSprite)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).pushObject as *const _ as usize },
    200usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(pushObject)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).retainObject as *const _ as usize },
    208usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(retainObject)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).releaseObject as *const _ as usize },
    216usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(releaseObject)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).setObjectValue as *const _ as usize },
    224usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(setObjectValue)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).getObjectValue as *const _ as usize },
    232usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(getObjectValue)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_lua>())).callFunction_deprecated as *const _ as usize
    },
    240usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(callFunction_deprecated)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_lua>())).callFunction as *const _ as usize },
    248usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_lua),
      "::",
      stringify!(callFunction)
    )
  );
}
pub const json_value_type_kJSONNull: json_value_type = 0;
pub const json_value_type_kJSONTrue: json_value_type = 1;
pub const json_value_type_kJSONFalse: json_value_type = 2;
pub const json_value_type_kJSONInteger: json_value_type = 3;
pub const json_value_type_kJSONFloat: json_value_type = 4;
pub const json_value_type_kJSONString: json_value_type = 5;
pub const json_value_type_kJSONArray: json_value_type = 6;
pub const json_value_type_kJSONTable: json_value_type = 7;
pub type json_value_type = super::ctypes::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct json_value {
  pub type_: super::ctypes::c_char,
  pub data: json_value__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union json_value__bindgen_ty_1 {
  pub intval: super::ctypes::c_int,
  pub floatval: f32,
  pub stringval: *mut super::ctypes::c_char,
  pub arrayval: *mut super::ctypes::c_void,
  pub tableval: *mut super::ctypes::c_void,
}
#[test]
fn bindgen_test_layout_json_value__bindgen_ty_1() {
  assert_eq!(
    ::core::mem::size_of::<json_value__bindgen_ty_1>(),
    8usize,
    concat!("Size of: ", stringify!(json_value__bindgen_ty_1))
  );
  assert_eq!(
    ::core::mem::align_of::<json_value__bindgen_ty_1>(),
    8usize,
    concat!("Alignment of ", stringify!(json_value__bindgen_ty_1))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_value__bindgen_ty_1>())).intval as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(json_value__bindgen_ty_1),
      "::",
      stringify!(intval)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_value__bindgen_ty_1>())).floatval as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(json_value__bindgen_ty_1),
      "::",
      stringify!(floatval)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_value__bindgen_ty_1>())).stringval as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(json_value__bindgen_ty_1),
      "::",
      stringify!(stringval)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_value__bindgen_ty_1>())).arrayval as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(json_value__bindgen_ty_1),
      "::",
      stringify!(arrayval)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_value__bindgen_ty_1>())).tableval as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(json_value__bindgen_ty_1),
      "::",
      stringify!(tableval)
    )
  );
}
#[test]
fn bindgen_test_layout_json_value() {
  assert_eq!(
    ::core::mem::size_of::<json_value>(),
    16usize,
    concat!("Size of: ", stringify!(json_value))
  );
  assert_eq!(
    ::core::mem::align_of::<json_value>(),
    8usize,
    concat!("Alignment of ", stringify!(json_value))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_value>())).type_ as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(json_value),
      "::",
      stringify!(type_)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_value>())).data as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(json_value),
      "::",
      stringify!(data)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct json_decoder {
  pub decodeError: ::core::option::Option<
    unsafe extern "C" fn(
      decoder: *mut json_decoder,
      error: *const super::ctypes::c_char,
      linenum: super::ctypes::c_int,
    ),
  >,
  pub willDecodeSublist: ::core::option::Option<
    unsafe extern "C" fn(
      decoder: *mut json_decoder,
      name: *const super::ctypes::c_char,
      type_: json_value_type,
    ),
  >,
  pub shouldDecodeTableValueForKey: ::core::option::Option<
    unsafe extern "C" fn(
      decoder: *mut json_decoder,
      key: *const super::ctypes::c_char,
    ) -> super::ctypes::c_int,
  >,
  pub didDecodeTableValue: ::core::option::Option<
    unsafe extern "C" fn(
      decoder: *mut json_decoder,
      key: *const super::ctypes::c_char,
      value: json_value,
    ),
  >,
  pub shouldDecodeArrayValueAtIndex: ::core::option::Option<
    unsafe extern "C" fn(
      decoder: *mut json_decoder,
      pos: super::ctypes::c_int,
    ) -> super::ctypes::c_int,
  >,
  pub didDecodeArrayValue: ::core::option::Option<
    unsafe extern "C" fn(decoder: *mut json_decoder, pos: super::ctypes::c_int, value: json_value),
  >,
  pub didDecodeSublist: ::core::option::Option<
    unsafe extern "C" fn(
      decoder: *mut json_decoder,
      name: *const super::ctypes::c_char,
      type_: json_value_type,
    ) -> *mut super::ctypes::c_void,
  >,
  pub userdata: *mut super::ctypes::c_void,
  pub returnString: super::ctypes::c_int,
  pub path: *const super::ctypes::c_char,
}
#[test]
fn bindgen_test_layout_json_decoder() {
  assert_eq!(
    ::core::mem::size_of::<json_decoder>(),
    80usize,
    concat!("Size of: ", stringify!(json_decoder))
  );
  assert_eq!(
    ::core::mem::align_of::<json_decoder>(),
    8usize,
    concat!("Alignment of ", stringify!(json_decoder))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_decoder>())).decodeError as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(json_decoder),
      "::",
      stringify!(decodeError)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_decoder>())).willDecodeSublist as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(json_decoder),
      "::",
      stringify!(willDecodeSublist)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<json_decoder>())).shouldDecodeTableValueForKey as *const _ as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(json_decoder),
      "::",
      stringify!(shouldDecodeTableValueForKey)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_decoder>())).didDecodeTableValue as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(json_decoder),
      "::",
      stringify!(didDecodeTableValue)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<json_decoder>())).shouldDecodeArrayValueAtIndex as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(json_decoder),
      "::",
      stringify!(shouldDecodeArrayValueAtIndex)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_decoder>())).didDecodeArrayValue as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(json_decoder),
      "::",
      stringify!(didDecodeArrayValue)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_decoder>())).didDecodeSublist as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(json_decoder),
      "::",
      stringify!(didDecodeSublist)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_decoder>())).userdata as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(json_decoder),
      "::",
      stringify!(userdata)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_decoder>())).returnString as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(json_decoder),
      "::",
      stringify!(returnString)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_decoder>())).path as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(json_decoder),
      "::",
      stringify!(path)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct json_reader {
  pub read: ::core::option::Option<
    unsafe extern "C" fn(
      userdata: *mut super::ctypes::c_void,
      buf: *mut u8,
      bufsize: super::ctypes::c_int,
    ) -> super::ctypes::c_int,
  >,
  pub userdata: *mut super::ctypes::c_void,
}
#[test]
fn bindgen_test_layout_json_reader() {
  assert_eq!(
    ::core::mem::size_of::<json_reader>(),
    16usize,
    concat!("Size of: ", stringify!(json_reader))
  );
  assert_eq!(
    ::core::mem::align_of::<json_reader>(),
    8usize,
    concat!("Alignment of ", stringify!(json_reader))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_reader>())).read as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(json_reader),
      "::",
      stringify!(read)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_reader>())).userdata as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(json_reader),
      "::",
      stringify!(userdata)
    )
  );
}
pub type writeFunc = ::core::option::Option<
  unsafe extern "C" fn(
    userdata: *mut super::ctypes::c_void,
    str_: *const super::ctypes::c_char,
    len: super::ctypes::c_int,
  ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct json_encoder {
  pub writeStringFunc: writeFunc,
  pub userdata: *mut super::ctypes::c_void,
  pub _bitfield_align_1: [u32; 0],
  pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
  pub startArray: ::core::option::Option<unsafe extern "C" fn(encoder: *mut json_encoder)>,
  pub addArrayMember: ::core::option::Option<unsafe extern "C" fn(encoder: *mut json_encoder)>,
  pub endArray: ::core::option::Option<unsafe extern "C" fn(encoder: *mut json_encoder)>,
  pub startTable: ::core::option::Option<unsafe extern "C" fn(encoder: *mut json_encoder)>,
  pub addTableMember: ::core::option::Option<
    unsafe extern "C" fn(
      encoder: *mut json_encoder,
      name: *const super::ctypes::c_char,
      len: super::ctypes::c_int,
    ),
  >,
  pub endTable: ::core::option::Option<unsafe extern "C" fn(encoder: *mut json_encoder)>,
  pub writeNull: ::core::option::Option<unsafe extern "C" fn(encoder: *mut json_encoder)>,
  pub writeFalse: ::core::option::Option<unsafe extern "C" fn(encoder: *mut json_encoder)>,
  pub writeTrue: ::core::option::Option<unsafe extern "C" fn(encoder: *mut json_encoder)>,
  pub writeInt: ::core::option::Option<
    unsafe extern "C" fn(encoder: *mut json_encoder, num: super::ctypes::c_int),
  >,
  pub writeDouble:
    ::core::option::Option<unsafe extern "C" fn(encoder: *mut json_encoder, num: f64)>,
  pub writeString: ::core::option::Option<
    unsafe extern "C" fn(
      encoder: *mut json_encoder,
      str_: *const super::ctypes::c_char,
      len: super::ctypes::c_int,
    ),
  >,
}
#[test]
fn bindgen_test_layout_json_encoder() {
  assert_eq!(
    ::core::mem::size_of::<json_encoder>(),
    120usize,
    concat!("Size of: ", stringify!(json_encoder))
  );
  assert_eq!(
    ::core::mem::align_of::<json_encoder>(),
    8usize,
    concat!("Alignment of ", stringify!(json_encoder))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).writeStringFunc as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(writeStringFunc)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).userdata as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(userdata)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).startArray as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(startArray)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).addArrayMember as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(addArrayMember)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).endArray as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(endArray)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).startTable as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(startTable)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).addTableMember as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(addTableMember)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).endTable as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(endTable)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).writeNull as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(writeNull)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).writeFalse as *const _ as usize },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(writeFalse)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).writeTrue as *const _ as usize },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(writeTrue)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).writeInt as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(writeInt)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).writeDouble as *const _ as usize },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(writeDouble)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<json_encoder>())).writeString as *const _ as usize },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(json_encoder),
      "::",
      stringify!(writeString)
    )
  );
}
impl json_encoder {
  #[inline]
  pub fn pretty(&self) -> super::ctypes::c_int {
    unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
  }
  #[inline]
  pub fn set_pretty(&mut self, val: super::ctypes::c_int) {
    unsafe {
      let val: u32 = ::core::mem::transmute(val);
      self._bitfield_1.set(0usize, 1u8, val as u64)
    }
  }
  #[inline]
  pub fn startedTable(&self) -> super::ctypes::c_int {
    unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
  }
  #[inline]
  pub fn set_startedTable(&mut self, val: super::ctypes::c_int) {
    unsafe {
      let val: u32 = ::core::mem::transmute(val);
      self._bitfield_1.set(1usize, 1u8, val as u64)
    }
  }
  #[inline]
  pub fn startedArray(&self) -> super::ctypes::c_int {
    unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
  }
  #[inline]
  pub fn set_startedArray(&mut self, val: super::ctypes::c_int) {
    unsafe {
      let val: u32 = ::core::mem::transmute(val);
      self._bitfield_1.set(2usize, 1u8, val as u64)
    }
  }
  #[inline]
  pub fn depth(&self) -> super::ctypes::c_int {
    unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 29u8) as u32) }
  }
  #[inline]
  pub fn set_depth(&mut self, val: super::ctypes::c_int) {
    unsafe {
      let val: u32 = ::core::mem::transmute(val);
      self._bitfield_1.set(3usize, 29u8, val as u64)
    }
  }
  #[inline]
  pub fn new_bitfield_1(
    pretty: super::ctypes::c_int,
    startedTable: super::ctypes::c_int,
    startedArray: super::ctypes::c_int,
    depth: super::ctypes::c_int,
  ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
    let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
    __bindgen_bitfield_unit.set(0usize, 1u8, {
      let pretty: u32 = unsafe { ::core::mem::transmute(pretty) };
      pretty as u64
    });
    __bindgen_bitfield_unit.set(1usize, 1u8, {
      let startedTable: u32 = unsafe { ::core::mem::transmute(startedTable) };
      startedTable as u64
    });
    __bindgen_bitfield_unit.set(2usize, 1u8, {
      let startedArray: u32 = unsafe { ::core::mem::transmute(startedArray) };
      startedArray as u64
    });
    __bindgen_bitfield_unit.set(3usize, 29u8, {
      let depth: u32 = unsafe { ::core::mem::transmute(depth) };
      depth as u64
    });
    __bindgen_bitfield_unit
  }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_json {
  pub initEncoder: ::core::option::Option<
    unsafe extern "C" fn(
      encoder: *mut json_encoder,
      write: writeFunc,
      userdata: *mut super::ctypes::c_void,
      pretty: super::ctypes::c_int,
    ),
  >,
  pub decode: ::core::option::Option<
    unsafe extern "C" fn(
      functions: *mut json_decoder,
      reader: json_reader,
      outval: *mut json_value,
    ) -> super::ctypes::c_int,
  >,
  pub decodeString: ::core::option::Option<
    unsafe extern "C" fn(
      functions: *mut json_decoder,
      jsonString: *const super::ctypes::c_char,
      outval: *mut json_value,
    ) -> super::ctypes::c_int,
  >,
}
#[test]
fn bindgen_test_layout_playdate_json() {
  assert_eq!(
    ::core::mem::size_of::<playdate_json>(),
    24usize,
    concat!("Size of: ", stringify!(playdate_json))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_json>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_json))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_json>())).initEncoder as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_json),
      "::",
      stringify!(initEncoder)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_json>())).decode as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_json),
      "::",
      stringify!(decode)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_json>())).decodeString as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_json),
      "::",
      stringify!(decodeString)
    )
  );
}
pub type SDFile = super::ctypes::c_void;
impl FileOptions {
  pub const kFileRead: FileOptions = FileOptions(1);
}
impl FileOptions {
  pub const kFileReadData: FileOptions = FileOptions(2);
}
impl FileOptions {
  pub const kFileWrite: FileOptions = FileOptions(4);
}
impl FileOptions {
  pub const kFileAppend: FileOptions = FileOptions(8);
}
impl ::core::ops::BitOr<FileOptions> for FileOptions {
  type Output = Self;
  #[inline]
  fn bitor(self, other: Self) -> Self {
    FileOptions(self.0 | other.0)
  }
}
impl ::core::ops::BitOrAssign for FileOptions {
  #[inline]
  fn bitor_assign(&mut self, rhs: FileOptions) {
    self.0 |= rhs.0;
  }
}
impl ::core::ops::BitAnd<FileOptions> for FileOptions {
  type Output = Self;
  #[inline]
  fn bitand(self, other: Self) -> Self {
    FileOptions(self.0 & other.0)
  }
}
impl ::core::ops::BitAndAssign for FileOptions {
  #[inline]
  fn bitand_assign(&mut self, rhs: FileOptions) {
    self.0 &= rhs.0;
  }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct FileOptions(pub super::ctypes::c_int);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FileStat {
  pub isdir: super::ctypes::c_int,
  pub size: super::ctypes::c_uint,
  pub m_year: super::ctypes::c_int,
  pub m_month: super::ctypes::c_int,
  pub m_day: super::ctypes::c_int,
  pub m_hour: super::ctypes::c_int,
  pub m_minute: super::ctypes::c_int,
  pub m_second: super::ctypes::c_int,
}
#[test]
fn bindgen_test_layout_FileStat() {
  assert_eq!(
    ::core::mem::size_of::<FileStat>(),
    32usize,
    concat!("Size of: ", stringify!(FileStat))
  );
  assert_eq!(
    ::core::mem::align_of::<FileStat>(),
    4usize,
    concat!("Alignment of ", stringify!(FileStat))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<FileStat>())).isdir as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(FileStat),
      "::",
      stringify!(isdir)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<FileStat>())).size as *const _ as usize },
    4usize,
    concat!(
      "Offset of field: ",
      stringify!(FileStat),
      "::",
      stringify!(size)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<FileStat>())).m_year as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(FileStat),
      "::",
      stringify!(m_year)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<FileStat>())).m_month as *const _ as usize },
    12usize,
    concat!(
      "Offset of field: ",
      stringify!(FileStat),
      "::",
      stringify!(m_month)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<FileStat>())).m_day as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(FileStat),
      "::",
      stringify!(m_day)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<FileStat>())).m_hour as *const _ as usize },
    20usize,
    concat!(
      "Offset of field: ",
      stringify!(FileStat),
      "::",
      stringify!(m_hour)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<FileStat>())).m_minute as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(FileStat),
      "::",
      stringify!(m_minute)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<FileStat>())).m_second as *const _ as usize },
    28usize,
    concat!(
      "Offset of field: ",
      stringify!(FileStat),
      "::",
      stringify!(m_second)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_file {
  pub geterr: ::core::option::Option<unsafe extern "C" fn() -> *const super::ctypes::c_char>,
  pub listfiles: ::core::option::Option<
    unsafe extern "C" fn(
      path: *const super::ctypes::c_char,
      callback: ::core::option::Option<
        unsafe extern "C" fn(
          path: *const super::ctypes::c_char,
          userdata: *mut super::ctypes::c_void,
        ),
      >,
      userdata: *mut super::ctypes::c_void,
    ) -> super::ctypes::c_int,
  >,
  pub stat: ::core::option::Option<
    unsafe extern "C" fn(
      path: *const super::ctypes::c_char,
      stat: *mut FileStat,
    ) -> super::ctypes::c_int,
  >,
  pub mkdir: ::core::option::Option<
    unsafe extern "C" fn(path: *const super::ctypes::c_char) -> super::ctypes::c_int,
  >,
  pub unlink: ::core::option::Option<
    unsafe extern "C" fn(
      name: *const super::ctypes::c_char,
      recursive: super::ctypes::c_int,
    ) -> super::ctypes::c_int,
  >,
  pub rename: ::core::option::Option<
    unsafe extern "C" fn(
      from: *const super::ctypes::c_char,
      to: *const super::ctypes::c_char,
    ) -> super::ctypes::c_int,
  >,
  pub open: ::core::option::Option<
    unsafe extern "C" fn(name: *const super::ctypes::c_char, mode: FileOptions) -> *mut SDFile,
  >,
  pub close:
    ::core::option::Option<unsafe extern "C" fn(file: *mut SDFile) -> super::ctypes::c_int>,
  pub read: ::core::option::Option<
    unsafe extern "C" fn(
      file: *mut SDFile,
      buf: *mut super::ctypes::c_void,
      len: super::ctypes::c_uint,
    ) -> super::ctypes::c_int,
  >,
  pub write: ::core::option::Option<
    unsafe extern "C" fn(
      file: *mut SDFile,
      buf: *const super::ctypes::c_void,
      len: super::ctypes::c_uint,
    ) -> super::ctypes::c_int,
  >,
  pub flush:
    ::core::option::Option<unsafe extern "C" fn(file: *mut SDFile) -> super::ctypes::c_int>,
  pub tell: ::core::option::Option<unsafe extern "C" fn(file: *mut SDFile) -> super::ctypes::c_int>,
  pub seek: ::core::option::Option<
    unsafe extern "C" fn(
      file: *mut SDFile,
      pos: super::ctypes::c_int,
      whence: super::ctypes::c_int,
    ) -> super::ctypes::c_int,
  >,
}
#[test]
fn bindgen_test_layout_playdate_file() {
  assert_eq!(
    ::core::mem::size_of::<playdate_file>(),
    104usize,
    concat!("Size of: ", stringify!(playdate_file))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_file>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_file))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).geterr as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(geterr)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).listfiles as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(listfiles)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).stat as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(stat)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).mkdir as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(mkdir)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).unlink as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(unlink)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).rename as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(rename)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).open as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(open)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).close as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(close)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).read as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(read)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).write as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(write)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).flush as *const _ as usize },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(flush)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).tell as *const _ as usize },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(tell)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_file>())).seek as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_file),
      "::",
      stringify!(seek)
    )
  );
}
impl SpriteCollisionResponseType {
  pub const kCollisionTypeSlide: SpriteCollisionResponseType = SpriteCollisionResponseType(0);
}
impl SpriteCollisionResponseType {
  pub const kCollisionTypeFreeze: SpriteCollisionResponseType = SpriteCollisionResponseType(1);
}
impl SpriteCollisionResponseType {
  pub const kCollisionTypeOverlap: SpriteCollisionResponseType = SpriteCollisionResponseType(2);
}
impl SpriteCollisionResponseType {
  pub const kCollisionTypeBounce: SpriteCollisionResponseType = SpriteCollisionResponseType(3);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct SpriteCollisionResponseType(pub super::ctypes::c_int);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDRect {
  pub x: f32,
  pub y: f32,
  pub width: f32,
  pub height: f32,
}
#[test]
fn bindgen_test_layout_PDRect() {
  assert_eq!(
    ::core::mem::size_of::<PDRect>(),
    16usize,
    concat!("Size of: ", stringify!(PDRect))
  );
  assert_eq!(
    ::core::mem::align_of::<PDRect>(),
    4usize,
    concat!("Alignment of ", stringify!(PDRect))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDRect>())).x as *const _ as usize },
    0usize,
    concat!("Offset of field: ", stringify!(PDRect), "::", stringify!(x))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDRect>())).y as *const _ as usize },
    4usize,
    concat!("Offset of field: ", stringify!(PDRect), "::", stringify!(y))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDRect>())).width as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(PDRect),
      "::",
      stringify!(width)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDRect>())).height as *const _ as usize },
    12usize,
    concat!(
      "Offset of field: ",
      stringify!(PDRect),
      "::",
      stringify!(height)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollisionPoint {
  pub x: f32,
  pub y: f32,
}
#[test]
fn bindgen_test_layout_CollisionPoint() {
  assert_eq!(
    ::core::mem::size_of::<CollisionPoint>(),
    8usize,
    concat!("Size of: ", stringify!(CollisionPoint))
  );
  assert_eq!(
    ::core::mem::align_of::<CollisionPoint>(),
    4usize,
    concat!("Alignment of ", stringify!(CollisionPoint))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<CollisionPoint>())).x as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(CollisionPoint),
      "::",
      stringify!(x)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<CollisionPoint>())).y as *const _ as usize },
    4usize,
    concat!(
      "Offset of field: ",
      stringify!(CollisionPoint),
      "::",
      stringify!(y)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollisionVector {
  pub x: super::ctypes::c_int,
  pub y: super::ctypes::c_int,
}
#[test]
fn bindgen_test_layout_CollisionVector() {
  assert_eq!(
    ::core::mem::size_of::<CollisionVector>(),
    8usize,
    concat!("Size of: ", stringify!(CollisionVector))
  );
  assert_eq!(
    ::core::mem::align_of::<CollisionVector>(),
    4usize,
    concat!("Alignment of ", stringify!(CollisionVector))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<CollisionVector>())).x as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(CollisionVector),
      "::",
      stringify!(x)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<CollisionVector>())).y as *const _ as usize },
    4usize,
    concat!(
      "Offset of field: ",
      stringify!(CollisionVector),
      "::",
      stringify!(y)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpriteCollisionInfo {
  pub sprite: *mut LCDSprite,
  pub other: *mut LCDSprite,
  pub responseType: SpriteCollisionResponseType,
  pub overlaps: u8,
  pub ti: f32,
  pub move_: CollisionPoint,
  pub normal: CollisionVector,
  pub touch: CollisionPoint,
  pub spriteRect: PDRect,
  pub otherRect: PDRect,
}
#[test]
fn bindgen_test_layout_SpriteCollisionInfo() {
  assert_eq!(
    ::core::mem::size_of::<SpriteCollisionInfo>(),
    88usize,
    concat!("Size of: ", stringify!(SpriteCollisionInfo))
  );
  assert_eq!(
    ::core::mem::align_of::<SpriteCollisionInfo>(),
    8usize,
    concat!("Alignment of ", stringify!(SpriteCollisionInfo))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteCollisionInfo>())).sprite as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteCollisionInfo),
      "::",
      stringify!(sprite)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteCollisionInfo>())).other as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteCollisionInfo),
      "::",
      stringify!(other)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteCollisionInfo>())).responseType as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteCollisionInfo),
      "::",
      stringify!(responseType)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteCollisionInfo>())).overlaps as *const _ as usize },
    20usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteCollisionInfo),
      "::",
      stringify!(overlaps)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteCollisionInfo>())).ti as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteCollisionInfo),
      "::",
      stringify!(ti)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteCollisionInfo>())).move_ as *const _ as usize },
    28usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteCollisionInfo),
      "::",
      stringify!(move_)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteCollisionInfo>())).normal as *const _ as usize },
    36usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteCollisionInfo),
      "::",
      stringify!(normal)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteCollisionInfo>())).touch as *const _ as usize },
    44usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteCollisionInfo),
      "::",
      stringify!(touch)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteCollisionInfo>())).spriteRect as *const _ as usize },
    52usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteCollisionInfo),
      "::",
      stringify!(spriteRect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteCollisionInfo>())).otherRect as *const _ as usize },
    68usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteCollisionInfo),
      "::",
      stringify!(otherRect)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpriteQueryInfo {
  pub sprite: *mut LCDSprite,
  pub ti1: f32,
  pub ti2: f32,
  pub entryPoint: CollisionPoint,
  pub exitPoint: CollisionPoint,
}
#[test]
fn bindgen_test_layout_SpriteQueryInfo() {
  assert_eq!(
    ::core::mem::size_of::<SpriteQueryInfo>(),
    32usize,
    concat!("Size of: ", stringify!(SpriteQueryInfo))
  );
  assert_eq!(
    ::core::mem::align_of::<SpriteQueryInfo>(),
    8usize,
    concat!("Alignment of ", stringify!(SpriteQueryInfo))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteQueryInfo>())).sprite as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteQueryInfo),
      "::",
      stringify!(sprite)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteQueryInfo>())).ti1 as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteQueryInfo),
      "::",
      stringify!(ti1)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteQueryInfo>())).ti2 as *const _ as usize },
    12usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteQueryInfo),
      "::",
      stringify!(ti2)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteQueryInfo>())).entryPoint as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteQueryInfo),
      "::",
      stringify!(entryPoint)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<SpriteQueryInfo>())).exitPoint as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(SpriteQueryInfo),
      "::",
      stringify!(exitPoint)
    )
  );
}
pub type LCDSpriteDrawFunction = ::core::option::Option<
  unsafe extern "C" fn(sprite: *mut LCDSprite, bounds: PDRect, drawrect: PDRect),
>;
pub type LCDSpriteUpdateFunction =
  ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite)>;
pub type LCDSpriteCollisionFilterProc = ::core::option::Option<
  unsafe extern "C" fn(
    sprite: *mut LCDSprite,
    other: *mut LCDSprite,
  ) -> SpriteCollisionResponseType,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sprite {
  pub setAlwaysRedraw: ::core::option::Option<unsafe extern "C" fn(flag: super::ctypes::c_int)>,
  pub addDirtyRect: ::core::option::Option<unsafe extern "C" fn(dirtyRect: LCDRect)>,
  pub drawSprites: ::core::option::Option<unsafe extern "C" fn()>,
  pub updateAndDrawSprites: ::core::option::Option<unsafe extern "C" fn()>,
  pub newSprite: ::core::option::Option<unsafe extern "C" fn() -> *mut LCDSprite>,
  pub freeSprite: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite)>,
  pub copy: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite) -> *mut LCDSprite>,
  pub addSprite: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite)>,
  pub removeSprite: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite)>,
  pub removeSprites: ::core::option::Option<
    unsafe extern "C" fn(sprites: *mut *mut LCDSprite, count: super::ctypes::c_int),
  >,
  pub removeAllSprites: ::core::option::Option<unsafe extern "C" fn()>,
  pub getSpriteCount: ::core::option::Option<unsafe extern "C" fn() -> super::ctypes::c_int>,
  pub setBounds:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, bounds: PDRect)>,
  pub getBounds: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite) -> PDRect>,
  pub moveTo: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, x: f32, y: f32)>,
  pub moveBy:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, dx: f32, dy: f32)>,
  pub setImage: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite, image: *mut LCDBitmap, flip: LCDBitmapFlip),
  >,
  pub getImage:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite) -> *mut LCDBitmap>,
  pub setSize:
    ::core::option::Option<unsafe extern "C" fn(s: *mut LCDSprite, width: f32, height: f32)>,
  pub setZIndex: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, zIndex: i16)>,
  pub getZIndex: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite) -> i16>,
  pub setDrawMode:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, mode: LCDBitmapDrawMode)>,
  pub setImageFlip:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, flip: LCDBitmapFlip)>,
  pub getImageFlip:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite) -> LCDBitmapFlip>,
  pub setStencil:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, stencil: *mut LCDBitmap)>,
  pub setClipRect:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, clipRect: LCDRect)>,
  pub clearClipRect: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite)>,
  pub setClipRectsInRange: ::core::option::Option<
    unsafe extern "C" fn(
      clipRect: LCDRect,
      startZ: super::ctypes::c_int,
      endZ: super::ctypes::c_int,
    ),
  >,
  pub clearClipRectsInRange: ::core::option::Option<
    unsafe extern "C" fn(startZ: super::ctypes::c_int, endZ: super::ctypes::c_int),
  >,
  pub setUpdatesEnabled: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite, flag: super::ctypes::c_int),
  >,
  pub updatesEnabled:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite) -> super::ctypes::c_int>,
  pub setCollisionsEnabled: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite, flag: super::ctypes::c_int),
  >,
  pub collisionsEnabled:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite) -> super::ctypes::c_int>,
  pub setVisible: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite, flag: super::ctypes::c_int),
  >,
  pub isVisible:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite) -> super::ctypes::c_int>,
  pub setOpaque: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite, flag: super::ctypes::c_int),
  >,
  pub markDirty: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite)>,
  pub setTag: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, tag: u8)>,
  pub getTag: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite) -> u8>,
  pub setIgnoresDrawOffset: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite, flag: super::ctypes::c_int),
  >,
  pub setUpdateFunction: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite, func: LCDSpriteUpdateFunction),
  >,
  pub setDrawFunction: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite, func: LCDSpriteDrawFunction),
  >,
  pub getPosition:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, x: *mut f32, y: *mut f32)>,
  pub resetCollisionWorld: ::core::option::Option<unsafe extern "C" fn()>,
  pub setCollideRect:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, collideRect: PDRect)>,
  pub getCollideRect:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite) -> PDRect>,
  pub clearCollideRect: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite)>,
  pub setCollisionResponseFunction: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite, func: LCDSpriteCollisionFilterProc),
  >,
  pub checkCollisions: ::core::option::Option<
    unsafe extern "C" fn(
      sprite: *mut LCDSprite,
      goalX: f32,
      goalY: f32,
      actualX: *mut f32,
      actualY: *mut f32,
      len: *mut super::ctypes::c_int,
    ) -> *mut SpriteCollisionInfo,
  >,
  pub moveWithCollisions: ::core::option::Option<
    unsafe extern "C" fn(
      sprite: *mut LCDSprite,
      goalX: f32,
      goalY: f32,
      actualX: *mut f32,
      actualY: *mut f32,
      len: *mut super::ctypes::c_int,
    ) -> *mut SpriteCollisionInfo,
  >,
  pub querySpritesAtPoint: ::core::option::Option<
    unsafe extern "C" fn(x: f32, y: f32, len: *mut super::ctypes::c_int) -> *mut *mut LCDSprite,
  >,
  pub querySpritesInRect: ::core::option::Option<
    unsafe extern "C" fn(
      x: f32,
      y: f32,
      width: f32,
      height: f32,
      len: *mut super::ctypes::c_int,
    ) -> *mut *mut LCDSprite,
  >,
  pub querySpritesAlongLine: ::core::option::Option<
    unsafe extern "C" fn(
      x1: f32,
      y1: f32,
      x2: f32,
      y2: f32,
      len: *mut super::ctypes::c_int,
    ) -> *mut *mut LCDSprite,
  >,
  pub querySpriteInfoAlongLine: ::core::option::Option<
    unsafe extern "C" fn(
      x1: f32,
      y1: f32,
      x2: f32,
      y2: f32,
      len: *mut super::ctypes::c_int,
    ) -> *mut SpriteQueryInfo,
  >,
  pub overlappingSprites: ::core::option::Option<
    unsafe extern "C" fn(
      sprite: *mut LCDSprite,
      len: *mut super::ctypes::c_int,
    ) -> *mut *mut LCDSprite,
  >,
  pub allOverlappingSprites: ::core::option::Option<
    unsafe extern "C" fn(len: *mut super::ctypes::c_int) -> *mut *mut LCDSprite,
  >,
  pub setStencilPattern:
    ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite, pattern: *mut u8)>,
  pub clearStencil: ::core::option::Option<unsafe extern "C" fn(sprite: *mut LCDSprite)>,
  pub setUserdata: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite, userdata: *mut super::ctypes::c_void),
  >,
  pub getUserdata: ::core::option::Option<
    unsafe extern "C" fn(sprite: *mut LCDSprite) -> *mut super::ctypes::c_void,
  >,
  pub setStencilImage: ::core::option::Option<
    unsafe extern "C" fn(
      sprite: *mut LCDSprite,
      stencil: *mut LCDBitmap,
      tile: super::ctypes::c_int,
    ),
  >,
}
#[test]
fn bindgen_test_layout_playdate_sprite() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sprite>(),
    488usize,
    concat!("Size of: ", stringify!(playdate_sprite))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sprite>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sprite))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setAlwaysRedraw as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setAlwaysRedraw)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).addDirtyRect as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(addDirtyRect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).drawSprites as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(drawSprites)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).updateAndDrawSprites as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(updateAndDrawSprites)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).newSprite as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(newSprite)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).freeSprite as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(freeSprite)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).copy as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(copy)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).addSprite as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(addSprite)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).removeSprite as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(removeSprite)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).removeSprites as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(removeSprites)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).removeAllSprites as *const _ as usize },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(removeAllSprites)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).getSpriteCount as *const _ as usize },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(getSpriteCount)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setBounds as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setBounds)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).getBounds as *const _ as usize },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(getBounds)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).moveTo as *const _ as usize },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(moveTo)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).moveBy as *const _ as usize },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(moveBy)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setImage as *const _ as usize },
    128usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setImage)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).getImage as *const _ as usize },
    136usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(getImage)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setSize as *const _ as usize },
    144usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setSize)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setZIndex as *const _ as usize },
    152usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setZIndex)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).getZIndex as *const _ as usize },
    160usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(getZIndex)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setDrawMode as *const _ as usize },
    168usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setDrawMode)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setImageFlip as *const _ as usize },
    176usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setImageFlip)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).getImageFlip as *const _ as usize },
    184usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(getImageFlip)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setStencil as *const _ as usize },
    192usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setStencil)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setClipRect as *const _ as usize },
    200usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setClipRect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).clearClipRect as *const _ as usize },
    208usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(clearClipRect)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).setClipRectsInRange as *const _ as usize
    },
    216usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setClipRectsInRange)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).clearClipRectsInRange as *const _ as usize
    },
    224usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(clearClipRectsInRange)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setUpdatesEnabled as *const _ as usize },
    232usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setUpdatesEnabled)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).updatesEnabled as *const _ as usize },
    240usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(updatesEnabled)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).setCollisionsEnabled as *const _ as usize
    },
    248usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setCollisionsEnabled)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).collisionsEnabled as *const _ as usize },
    256usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(collisionsEnabled)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setVisible as *const _ as usize },
    264usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setVisible)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).isVisible as *const _ as usize },
    272usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(isVisible)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setOpaque as *const _ as usize },
    280usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setOpaque)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).markDirty as *const _ as usize },
    288usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(markDirty)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setTag as *const _ as usize },
    296usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setTag)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).getTag as *const _ as usize },
    304usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(getTag)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).setIgnoresDrawOffset as *const _ as usize
    },
    312usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setIgnoresDrawOffset)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setUpdateFunction as *const _ as usize },
    320usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setUpdateFunction)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setDrawFunction as *const _ as usize },
    328usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setDrawFunction)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).getPosition as *const _ as usize },
    336usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(getPosition)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).resetCollisionWorld as *const _ as usize
    },
    344usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(resetCollisionWorld)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setCollideRect as *const _ as usize },
    352usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setCollideRect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).getCollideRect as *const _ as usize },
    360usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(getCollideRect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).clearCollideRect as *const _ as usize },
    368usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(clearCollideRect)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).setCollisionResponseFunction as *const _ as usize
    },
    376usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setCollisionResponseFunction)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).checkCollisions as *const _ as usize },
    384usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(checkCollisions)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).moveWithCollisions as *const _ as usize },
    392usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(moveWithCollisions)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).querySpritesAtPoint as *const _ as usize
    },
    400usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(querySpritesAtPoint)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).querySpritesInRect as *const _ as usize },
    408usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(querySpritesInRect)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).querySpritesAlongLine as *const _ as usize
    },
    416usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(querySpritesAlongLine)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).querySpriteInfoAlongLine as *const _ as usize
    },
    424usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(querySpriteInfoAlongLine)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).overlappingSprites as *const _ as usize },
    432usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(overlappingSprites)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sprite>())).allOverlappingSprites as *const _ as usize
    },
    440usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(allOverlappingSprites)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setStencilPattern as *const _ as usize },
    448usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setStencilPattern)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).clearStencil as *const _ as usize },
    456usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(clearStencil)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setUserdata as *const _ as usize },
    464usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setUserdata)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).getUserdata as *const _ as usize },
    472usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(getUserdata)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sprite>())).setStencilImage as *const _ as usize },
    480usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sprite),
      "::",
      stringify!(setStencilImage)
    )
  );
}
impl SoundFormat {
  pub const kSound8bitMono: SoundFormat = SoundFormat(0);
}
impl SoundFormat {
  pub const kSound8bitStereo: SoundFormat = SoundFormat(1);
}
impl SoundFormat {
  pub const kSound16bitMono: SoundFormat = SoundFormat(2);
}
impl SoundFormat {
  pub const kSound16bitStereo: SoundFormat = SoundFormat(3);
}
impl SoundFormat {
  pub const kSoundADPCMMono: SoundFormat = SoundFormat(4);
}
impl SoundFormat {
  pub const kSoundADPCMStereo: SoundFormat = SoundFormat(5);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct SoundFormat(pub super::ctypes::c_int);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SoundSource {
  _unused: [u8; 0],
}
pub type sndCallbackProc = ::core::option::Option<unsafe extern "C" fn(c: *mut SoundSource)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_source {
  pub setVolume:
    ::core::option::Option<unsafe extern "C" fn(c: *mut SoundSource, lvol: f32, rvol: f32)>,
  pub getVolume: ::core::option::Option<
    unsafe extern "C" fn(c: *mut SoundSource, outl: *mut f32, outr: *mut f32),
  >,
  pub isPlaying:
    ::core::option::Option<unsafe extern "C" fn(c: *mut SoundSource) -> super::ctypes::c_int>,
  pub setFinishCallback:
    ::core::option::Option<unsafe extern "C" fn(c: *mut SoundSource, callback: sndCallbackProc)>,
}
#[test]
fn bindgen_test_layout_playdate_sound_source() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_source>(),
    32usize,
    concat!("Size of: ", stringify!(playdate_sound_source))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_source>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_source))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_source>())).setVolume as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_source),
      "::",
      stringify!(setVolume)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_source>())).getVolume as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_source),
      "::",
      stringify!(getVolume)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_source>())).isPlaying as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_source),
      "::",
      stringify!(isPlaying)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_source>())).setFinishCallback as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_source),
      "::",
      stringify!(setFinishCallback)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FilePlayer {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_fileplayer {
  pub newPlayer: ::core::option::Option<unsafe extern "C" fn() -> *mut FilePlayer>,
  pub freePlayer: ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer)>,
  pub loadIntoPlayer: ::core::option::Option<
    unsafe extern "C" fn(
      player: *mut FilePlayer,
      path: *const super::ctypes::c_char,
    ) -> super::ctypes::c_int,
  >,
  pub setBufferLength:
    ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer, bufferLen: f32)>,
  pub play: ::core::option::Option<
    unsafe extern "C" fn(
      player: *mut FilePlayer,
      repeat: super::ctypes::c_int,
    ) -> super::ctypes::c_int,
  >,
  pub isPlaying:
    ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer) -> super::ctypes::c_int>,
  pub pause: ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer)>,
  pub stop: ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer)>,
  pub setVolume:
    ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer, left: f32, right: f32)>,
  pub getVolume: ::core::option::Option<
    unsafe extern "C" fn(player: *mut FilePlayer, left: *mut f32, right: *mut f32),
  >,
  pub getLength: ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer) -> f32>,
  pub setOffset: ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer, offset: f32)>,
  pub setRate: ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer, rate: f32)>,
  pub setLoopRange:
    ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer, start: f32, end: f32)>,
  pub didUnderrun:
    ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer) -> super::ctypes::c_int>,
  pub setFinishCallback: ::core::option::Option<
    unsafe extern "C" fn(player: *mut FilePlayer, callback: sndCallbackProc),
  >,
  pub setLoopCallback: ::core::option::Option<
    unsafe extern "C" fn(player: *mut FilePlayer, callback: sndCallbackProc),
  >,
  pub getOffset: ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer) -> f32>,
  pub getRate: ::core::option::Option<unsafe extern "C" fn(player: *mut FilePlayer) -> f32>,
  pub setStopOnUnderrun: ::core::option::Option<
    unsafe extern "C" fn(player: *mut FilePlayer, flag: super::ctypes::c_int),
  >,
  pub fadeVolume: ::core::option::Option<
    unsafe extern "C" fn(
      player: *mut FilePlayer,
      left: f32,
      right: f32,
      len: i32,
      finishCallback: sndCallbackProc,
    ),
  >,
  pub setMP3StreamSource: ::core::option::Option<
    unsafe extern "C" fn(
      player: *mut FilePlayer,
      dataSource: ::core::option::Option<
        unsafe extern "C" fn(
          data: *mut u8,
          bytes: super::ctypes::c_int,
          userdata: *mut super::ctypes::c_void,
        ) -> super::ctypes::c_int,
      >,
      userdata: *mut super::ctypes::c_void,
      bufferLen: f32,
    ),
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_fileplayer() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_fileplayer>(),
    176usize,
    concat!("Size of: ", stringify!(playdate_sound_fileplayer))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_fileplayer>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_fileplayer))
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).newPlayer as *const _ as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(newPlayer)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).freePlayer as *const _ as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(freePlayer)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).loadIntoPlayer as *const _ as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(loadIntoPlayer)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).setBufferLength as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(setBufferLength)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_fileplayer>())).play as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(play)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).isPlaying as *const _ as usize
    },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(isPlaying)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_fileplayer>())).pause as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(pause)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_fileplayer>())).stop as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(stop)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).setVolume as *const _ as usize
    },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(setVolume)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).getVolume as *const _ as usize
    },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(getVolume)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).getLength as *const _ as usize
    },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(getLength)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).setOffset as *const _ as usize
    },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(setOffset)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_fileplayer>())).setRate as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(setRate)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).setLoopRange as *const _ as usize
    },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(setLoopRange)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).didUnderrun as *const _ as usize
    },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(didUnderrun)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).setFinishCallback as *const _ as usize
    },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(setFinishCallback)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).setLoopCallback as *const _ as usize
    },
    128usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(setLoopCallback)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).getOffset as *const _ as usize
    },
    136usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(getOffset)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_fileplayer>())).getRate as *const _ as usize },
    144usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(getRate)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).setStopOnUnderrun as *const _ as usize
    },
    152usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(setStopOnUnderrun)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).fadeVolume as *const _ as usize
    },
    160usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(fadeVolume)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_fileplayer>())).setMP3StreamSource as *const _ as usize
    },
    168usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_fileplayer),
      "::",
      stringify!(setMP3StreamSource)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AudioSample {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SamplePlayer {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_sample {
  pub newSampleBuffer: ::core::option::Option<
    unsafe extern "C" fn(byteCount: super::ctypes::c_int) -> *mut AudioSample,
  >,
  pub loadIntoSample: ::core::option::Option<
    unsafe extern "C" fn(
      sample: *mut AudioSample,
      path: *const super::ctypes::c_char,
    ) -> super::ctypes::c_int,
  >,
  pub load: ::core::option::Option<
    unsafe extern "C" fn(path: *const super::ctypes::c_char) -> *mut AudioSample,
  >,
  pub newSampleFromData: ::core::option::Option<
    unsafe extern "C" fn(
      data: *mut u8,
      format: SoundFormat,
      sampleRate: u32,
      byteCount: super::ctypes::c_int,
    ) -> *mut AudioSample,
  >,
  pub getData: ::core::option::Option<
    unsafe extern "C" fn(
      sample: *mut AudioSample,
      data: *mut *mut u8,
      format: *mut SoundFormat,
      sampleRate: *mut u32,
      bytelength: *mut u32,
    ),
  >,
  pub freeSample: ::core::option::Option<unsafe extern "C" fn(sample: *mut AudioSample)>,
  pub getLength: ::core::option::Option<unsafe extern "C" fn(sample: *mut AudioSample) -> f32>,
}
#[test]
fn bindgen_test_layout_playdate_sound_sample() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_sample>(),
    56usize,
    concat!("Size of: ", stringify!(playdate_sound_sample))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_sample>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_sample))
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sample>())).newSampleBuffer as *const _ as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sample),
      "::",
      stringify!(newSampleBuffer)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sample>())).loadIntoSample as *const _ as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sample),
      "::",
      stringify!(loadIntoSample)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sample>())).load as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sample),
      "::",
      stringify!(load)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sample>())).newSampleFromData as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sample),
      "::",
      stringify!(newSampleFromData)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sample>())).getData as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sample),
      "::",
      stringify!(getData)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sample>())).freeSample as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sample),
      "::",
      stringify!(freeSample)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sample>())).getLength as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sample),
      "::",
      stringify!(getLength)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_sampleplayer {
  pub newPlayer: ::core::option::Option<unsafe extern "C" fn() -> *mut SamplePlayer>,
  pub freePlayer: ::core::option::Option<unsafe extern "C" fn(player: *mut SamplePlayer)>,
  pub setSample: ::core::option::Option<
    unsafe extern "C" fn(player: *mut SamplePlayer, sample: *mut AudioSample),
  >,
  pub play: ::core::option::Option<
    unsafe extern "C" fn(
      player: *mut SamplePlayer,
      repeat: super::ctypes::c_int,
      rate: f32,
    ) -> super::ctypes::c_int,
  >,
  pub isPlaying:
    ::core::option::Option<unsafe extern "C" fn(player: *mut SamplePlayer) -> super::ctypes::c_int>,
  pub stop: ::core::option::Option<unsafe extern "C" fn(player: *mut SamplePlayer)>,
  pub setVolume:
    ::core::option::Option<unsafe extern "C" fn(player: *mut SamplePlayer, left: f32, right: f32)>,
  pub getVolume: ::core::option::Option<
    unsafe extern "C" fn(player: *mut SamplePlayer, left: *mut f32, right: *mut f32),
  >,
  pub getLength: ::core::option::Option<unsafe extern "C" fn(player: *mut SamplePlayer) -> f32>,
  pub setOffset:
    ::core::option::Option<unsafe extern "C" fn(player: *mut SamplePlayer, offset: f32)>,
  pub setRate: ::core::option::Option<unsafe extern "C" fn(player: *mut SamplePlayer, rate: f32)>,
  pub setPlayRange: ::core::option::Option<
    unsafe extern "C" fn(
      player: *mut SamplePlayer,
      start: super::ctypes::c_int,
      end: super::ctypes::c_int,
    ),
  >,
  pub setFinishCallback: ::core::option::Option<
    unsafe extern "C" fn(player: *mut SamplePlayer, callback: sndCallbackProc),
  >,
  pub setLoopCallback: ::core::option::Option<
    unsafe extern "C" fn(player: *mut SamplePlayer, callback: sndCallbackProc),
  >,
  pub getOffset: ::core::option::Option<unsafe extern "C" fn(player: *mut SamplePlayer) -> f32>,
  pub getRate: ::core::option::Option<unsafe extern "C" fn(player: *mut SamplePlayer) -> f32>,
  pub setPaused: ::core::option::Option<
    unsafe extern "C" fn(player: *mut SamplePlayer, flag: super::ctypes::c_int),
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_sampleplayer() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_sampleplayer>(),
    136usize,
    concat!("Size of: ", stringify!(playdate_sound_sampleplayer))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_sampleplayer>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_sampleplayer))
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).newPlayer as *const _ as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(newPlayer)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).freePlayer as *const _ as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(freePlayer)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).setSample as *const _ as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(setSample)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).play as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(play)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).isPlaying as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(isPlaying)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).stop as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(stop)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).setVolume as *const _ as usize
    },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(setVolume)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).getVolume as *const _ as usize
    },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(getVolume)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).getLength as *const _ as usize
    },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(getLength)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).setOffset as *const _ as usize
    },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(setOffset)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).setRate as *const _ as usize
    },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(setRate)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).setPlayRange as *const _ as usize
    },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(setPlayRange)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).setFinishCallback as *const _
        as usize
    },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(setFinishCallback)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).setLoopCallback as *const _ as usize
    },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(setLoopCallback)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).getOffset as *const _ as usize
    },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(getOffset)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).getRate as *const _ as usize
    },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(getRate)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sampleplayer>())).setPaused as *const _ as usize
    },
    128usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sampleplayer),
      "::",
      stringify!(setPaused)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDSynthSignalValue {
  _unused: [u8; 0],
}
impl LFOType {
  pub const kLFOTypeSquare: LFOType = LFOType(0);
}
impl LFOType {
  pub const kLFOTypeTriangle: LFOType = LFOType(1);
}
impl LFOType {
  pub const kLFOTypeSine: LFOType = LFOType(2);
}
impl LFOType {
  pub const kLFOTypeSampleAndHold: LFOType = LFOType(3);
}
impl LFOType {
  pub const kLFOTypeSawtoothUp: LFOType = LFOType(4);
}
impl LFOType {
  pub const kLFOTypeSawtoothDown: LFOType = LFOType(5);
}
impl LFOType {
  pub const kLFOTypeArpeggiator: LFOType = LFOType(6);
}
impl LFOType {
  pub const kLFOTypeFunction: LFOType = LFOType(7);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct LFOType(pub super::ctypes::c_int);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDSynthLFO {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_lfo {
  pub newLFO: ::core::option::Option<unsafe extern "C" fn(type_: LFOType) -> *mut PDSynthLFO>,
  pub freeLFO: ::core::option::Option<unsafe extern "C" fn(lfo: *mut PDSynthLFO)>,
  pub setType: ::core::option::Option<unsafe extern "C" fn(lfo: *mut PDSynthLFO, type_: LFOType)>,
  pub setRate: ::core::option::Option<unsafe extern "C" fn(lfo: *mut PDSynthLFO, rate: f32)>,
  pub setPhase: ::core::option::Option<unsafe extern "C" fn(lfo: *mut PDSynthLFO, phase: f32)>,
  pub setCenter: ::core::option::Option<unsafe extern "C" fn(lfo: *mut PDSynthLFO, center: f32)>,
  pub setDepth: ::core::option::Option<unsafe extern "C" fn(lfo: *mut PDSynthLFO, depth: f32)>,
  pub setArpeggiation: ::core::option::Option<
    unsafe extern "C" fn(lfo: *mut PDSynthLFO, nSteps: super::ctypes::c_int, steps: *mut f32),
  >,
  pub setFunction: ::core::option::Option<
    unsafe extern "C" fn(
      lfo: *mut PDSynthLFO,
      lfoFunc: ::core::option::Option<
        unsafe extern "C" fn(lfo: *mut PDSynthLFO, userdata: *mut super::ctypes::c_void) -> f32,
      >,
      userdata: *mut super::ctypes::c_void,
      interpolate: super::ctypes::c_int,
    ),
  >,
  pub setDelay:
    ::core::option::Option<unsafe extern "C" fn(lfo: *mut PDSynthLFO, holdoff: f32, ramptime: f32)>,
  pub setRetrigger:
    ::core::option::Option<unsafe extern "C" fn(lfo: *mut PDSynthLFO, flag: super::ctypes::c_int)>,
  pub getValue: ::core::option::Option<unsafe extern "C" fn(lfo: *mut PDSynthLFO) -> f32>,
  pub setGlobal: ::core::option::Option<
    unsafe extern "C" fn(lfo: *mut PDSynthLFO, global: super::ctypes::c_int),
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_lfo() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_lfo>(),
    104usize,
    concat!("Size of: ", stringify!(playdate_sound_lfo))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_lfo>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_lfo))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).newLFO as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(newLFO)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).freeLFO as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(freeLFO)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).setType as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(setType)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).setRate as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(setRate)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).setPhase as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(setPhase)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).setCenter as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(setCenter)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).setDepth as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(setDepth)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).setArpeggiation as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(setArpeggiation)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).setFunction as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(setFunction)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).setDelay as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(setDelay)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).setRetrigger as *const _ as usize },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(setRetrigger)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).getValue as *const _ as usize },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(getValue)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_lfo>())).setGlobal as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_lfo),
      "::",
      stringify!(setGlobal)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDSynthEnvelope {
  _unused: [u8; 0],
}
pub type MIDINote = f32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_envelope {
  pub newEnvelope: ::core::option::Option<
    unsafe extern "C" fn(
      attack: f32,
      decay: f32,
      sustain: f32,
      release: f32,
    ) -> *mut PDSynthEnvelope,
  >,
  pub freeEnvelope: ::core::option::Option<unsafe extern "C" fn(env: *mut PDSynthEnvelope)>,
  pub setAttack:
    ::core::option::Option<unsafe extern "C" fn(env: *mut PDSynthEnvelope, attack: f32)>,
  pub setDecay: ::core::option::Option<unsafe extern "C" fn(env: *mut PDSynthEnvelope, decay: f32)>,
  pub setSustain:
    ::core::option::Option<unsafe extern "C" fn(env: *mut PDSynthEnvelope, sustain: f32)>,
  pub setRelease:
    ::core::option::Option<unsafe extern "C" fn(env: *mut PDSynthEnvelope, release: f32)>,
  pub setLegato: ::core::option::Option<
    unsafe extern "C" fn(env: *mut PDSynthEnvelope, flag: super::ctypes::c_int),
  >,
  pub setRetrigger: ::core::option::Option<
    unsafe extern "C" fn(lfo: *mut PDSynthEnvelope, flag: super::ctypes::c_int),
  >,
  pub getValue: ::core::option::Option<unsafe extern "C" fn(env: *mut PDSynthEnvelope) -> f32>,
}
#[test]
fn bindgen_test_layout_playdate_sound_envelope() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_envelope>(),
    72usize,
    concat!("Size of: ", stringify!(playdate_sound_envelope))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_envelope>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_envelope))
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_envelope>())).newEnvelope as *const _ as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_envelope),
      "::",
      stringify!(newEnvelope)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_envelope>())).freeEnvelope as *const _ as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_envelope),
      "::",
      stringify!(freeEnvelope)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_envelope>())).setAttack as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_envelope),
      "::",
      stringify!(setAttack)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_envelope>())).setDecay as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_envelope),
      "::",
      stringify!(setDecay)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_envelope>())).setSustain as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_envelope),
      "::",
      stringify!(setSustain)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_envelope>())).setRelease as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_envelope),
      "::",
      stringify!(setRelease)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_envelope>())).setLegato as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_envelope),
      "::",
      stringify!(setLegato)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_envelope>())).setRetrigger as *const _ as usize
    },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_envelope),
      "::",
      stringify!(setRetrigger)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_envelope>())).getValue as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_envelope),
      "::",
      stringify!(getValue)
    )
  );
}
impl SoundWaveform {
  pub const kWaveformSquare: SoundWaveform = SoundWaveform(0);
}
impl SoundWaveform {
  pub const kWaveformTriangle: SoundWaveform = SoundWaveform(1);
}
impl SoundWaveform {
  pub const kWaveformSine: SoundWaveform = SoundWaveform(2);
}
impl SoundWaveform {
  pub const kWaveformNoise: SoundWaveform = SoundWaveform(3);
}
impl SoundWaveform {
  pub const kWaveformSawtooth: SoundWaveform = SoundWaveform(4);
}
impl SoundWaveform {
  pub const kWaveformPOPhase: SoundWaveform = SoundWaveform(5);
}
impl SoundWaveform {
  pub const kWaveformPODigital: SoundWaveform = SoundWaveform(6);
}
impl SoundWaveform {
  pub const kWaveformPOVosim: SoundWaveform = SoundWaveform(7);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct SoundWaveform(pub super::ctypes::c_int);
pub type synthRenderFunc = ::core::option::Option<
  unsafe extern "C" fn(
    userdata: *mut super::ctypes::c_void,
    left: *mut i32,
    right: *mut i32,
    nsamples: super::ctypes::c_int,
    rate: u32,
    drate: i32,
    l: i32,
    dl: i32,
    r: i32,
    dr: i32,
  ) -> super::ctypes::c_int,
>;
pub type synthNoteOnFunc = ::core::option::Option<
  unsafe extern "C" fn(
    userdata: *mut super::ctypes::c_void,
    note: MIDINote,
    velocity: f32,
    len: f32,
  ),
>;
pub type synthReleaseFunc = ::core::option::Option<
  unsafe extern "C" fn(userdata: *mut super::ctypes::c_void, stop: super::ctypes::c_int),
>;
pub type synthSetParameterFunc = ::core::option::Option<
  unsafe extern "C" fn(
    userdata: *mut super::ctypes::c_void,
    parameter: u8,
    value: f32,
  ) -> super::ctypes::c_int,
>;
pub type synthDeallocFunc =
  ::core::option::Option<unsafe extern "C" fn(userdata: *mut super::ctypes::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDSynth {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_synth {
  pub newSynth: ::core::option::Option<unsafe extern "C" fn() -> *mut PDSynth>,
  pub freeSynth: ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth)>,
  pub setWaveform:
    ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth, wave: SoundWaveform)>,
  pub setGenerator: ::core::option::Option<
    unsafe extern "C" fn(
      synth: *mut PDSynth,
      render: *mut synthRenderFunc,
      noteOn: *mut synthNoteOnFunc,
      release: *mut synthReleaseFunc,
      setparam: *mut synthSetParameterFunc,
      dealloc: *mut synthDeallocFunc,
      userdata: *mut super::ctypes::c_void,
    ),
  >,
  pub setSample: ::core::option::Option<
    unsafe extern "C" fn(
      synth: *mut PDSynth,
      sample: *mut AudioSample,
      sustainStart: u32,
      sustainEnd: u32,
    ),
  >,
  pub setAttackTime: ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth, attack: f32)>,
  pub setDecayTime: ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth, decay: f32)>,
  pub setSustainLevel:
    ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth, sustain: f32)>,
  pub setReleaseTime:
    ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth, release: f32)>,
  pub setTranspose:
    ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth, halfSteps: f32)>,
  pub setFrequencyModulator: ::core::option::Option<
    unsafe extern "C" fn(synth: *mut PDSynth, mod_: *mut PDSynthSignalValue),
  >,
  pub getFrequencyModulator:
    ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth) -> *mut PDSynthSignalValue>,
  pub setAmplitudeModulator: ::core::option::Option<
    unsafe extern "C" fn(synth: *mut PDSynth, mod_: *mut PDSynthSignalValue),
  >,
  pub getAmplitudeModulator:
    ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth) -> *mut PDSynthSignalValue>,
  pub getParameterCount:
    ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth) -> super::ctypes::c_int>,
  pub setParameter: ::core::option::Option<
    unsafe extern "C" fn(
      synth: *mut PDSynth,
      parameter: super::ctypes::c_int,
      value: f32,
    ) -> super::ctypes::c_int,
  >,
  pub setParameterModulator: ::core::option::Option<
    unsafe extern "C" fn(
      synth: *mut PDSynth,
      parameter: super::ctypes::c_int,
      mod_: *mut PDSynthSignalValue,
    ),
  >,
  pub getParameterModulator: ::core::option::Option<
    unsafe extern "C" fn(
      synth: *mut PDSynth,
      parameter: super::ctypes::c_int,
    ) -> *mut PDSynthSignalValue,
  >,
  pub playNote: ::core::option::Option<
    unsafe extern "C" fn(synth: *mut PDSynth, freq: f32, vel: f32, len: f32, when: u32),
  >,
  pub playMIDINote: ::core::option::Option<
    unsafe extern "C" fn(synth: *mut PDSynth, note: MIDINote, vel: f32, len: f32, when: u32),
  >,
  pub noteOff: ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth, when: u32)>,
  pub stop: ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth)>,
  pub setVolume:
    ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth, left: f32, right: f32)>,
  pub getVolume: ::core::option::Option<
    unsafe extern "C" fn(synth: *mut PDSynth, left: *mut f32, right: *mut f32),
  >,
  pub isPlaying:
    ::core::option::Option<unsafe extern "C" fn(synth: *mut PDSynth) -> super::ctypes::c_int>,
}
#[test]
fn bindgen_test_layout_playdate_sound_synth() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_synth>(),
    200usize,
    concat!("Size of: ", stringify!(playdate_sound_synth))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_synth>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_synth))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).newSynth as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(newSynth)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).freeSynth as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(freeSynth)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).setWaveform as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setWaveform)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).setGenerator as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setGenerator)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).setSample as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setSample)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).setAttackTime as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setAttackTime)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).setDecayTime as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setDecayTime)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_synth>())).setSustainLevel as *const _ as usize
    },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setSustainLevel)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_synth>())).setReleaseTime as *const _ as usize
    },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setReleaseTime)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).setTranspose as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setTranspose)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_synth>())).setFrequencyModulator as *const _ as usize
    },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setFrequencyModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_synth>())).getFrequencyModulator as *const _ as usize
    },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(getFrequencyModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_synth>())).setAmplitudeModulator as *const _ as usize
    },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setAmplitudeModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_synth>())).getAmplitudeModulator as *const _ as usize
    },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(getAmplitudeModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_synth>())).getParameterCount as *const _ as usize
    },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(getParameterCount)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).setParameter as *const _ as usize },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setParameter)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_synth>())).setParameterModulator as *const _ as usize
    },
    128usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setParameterModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_synth>())).getParameterModulator as *const _ as usize
    },
    136usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(getParameterModulator)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).playNote as *const _ as usize },
    144usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(playNote)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).playMIDINote as *const _ as usize },
    152usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(playMIDINote)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).noteOff as *const _ as usize },
    160usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(noteOff)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).stop as *const _ as usize },
    168usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(stop)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).setVolume as *const _ as usize },
    176usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(setVolume)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).getVolume as *const _ as usize },
    184usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(getVolume)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_synth>())).isPlaying as *const _ as usize },
    192usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_synth),
      "::",
      stringify!(isPlaying)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ControlSignal {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_control_signal {
  pub newSignal: ::core::option::Option<unsafe extern "C" fn() -> *mut ControlSignal>,
  pub freeSignal: ::core::option::Option<unsafe extern "C" fn(signal: *mut ControlSignal)>,
  pub clearEvents: ::core::option::Option<unsafe extern "C" fn(control: *mut ControlSignal)>,
  pub addEvent: ::core::option::Option<
    unsafe extern "C" fn(
      control: *mut ControlSignal,
      step: super::ctypes::c_int,
      value: f32,
      interpolate: super::ctypes::c_int,
    ),
  >,
  pub removeEvent: ::core::option::Option<
    unsafe extern "C" fn(control: *mut ControlSignal, step: super::ctypes::c_int),
  >,
  pub getMIDIControllerNumber: ::core::option::Option<
    unsafe extern "C" fn(control: *mut ControlSignal) -> super::ctypes::c_int,
  >,
}
#[test]
fn bindgen_test_layout_playdate_control_signal() {
  assert_eq!(
    ::core::mem::size_of::<playdate_control_signal>(),
    48usize,
    concat!("Size of: ", stringify!(playdate_control_signal))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_control_signal>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_control_signal))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_control_signal>())).newSignal as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_control_signal),
      "::",
      stringify!(newSignal)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_control_signal>())).freeSignal as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_control_signal),
      "::",
      stringify!(freeSignal)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_control_signal>())).clearEvents as *const _ as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_control_signal),
      "::",
      stringify!(clearEvents)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_control_signal>())).addEvent as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_control_signal),
      "::",
      stringify!(addEvent)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_control_signal>())).removeEvent as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_control_signal),
      "::",
      stringify!(removeEvent)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_control_signal>())).getMIDIControllerNumber as *const _
        as usize
    },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_control_signal),
      "::",
      stringify!(getMIDIControllerNumber)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDSynthInstrument {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_instrument {
  pub newInstrument: ::core::option::Option<unsafe extern "C" fn() -> *mut PDSynthInstrument>,
  pub freeInstrument: ::core::option::Option<unsafe extern "C" fn(inst: *mut PDSynthInstrument)>,
  pub addVoice: ::core::option::Option<
    unsafe extern "C" fn(
      inst: *mut PDSynthInstrument,
      synth: *mut PDSynth,
      rangeStart: MIDINote,
      rangeEnd: MIDINote,
      transpose: f32,
    ) -> super::ctypes::c_int,
  >,
  pub playNote: ::core::option::Option<
    unsafe extern "C" fn(
      inst: *mut PDSynthInstrument,
      frequency: f32,
      vel: f32,
      len: f32,
      when: u32,
    ) -> *mut PDSynth,
  >,
  pub playMIDINote: ::core::option::Option<
    unsafe extern "C" fn(
      inst: *mut PDSynthInstrument,
      note: MIDINote,
      vel: f32,
      len: f32,
      when: u32,
    ) -> *mut PDSynth,
  >,
  pub setPitchBend:
    ::core::option::Option<unsafe extern "C" fn(inst: *mut PDSynthInstrument, bend: f32)>,
  pub setPitchBendRange:
    ::core::option::Option<unsafe extern "C" fn(inst: *mut PDSynthInstrument, halfSteps: f32)>,
  pub setTranspose:
    ::core::option::Option<unsafe extern "C" fn(inst: *mut PDSynthInstrument, halfSteps: f32)>,
  pub noteOff: ::core::option::Option<
    unsafe extern "C" fn(inst: *mut PDSynthInstrument, note: MIDINote, when: u32),
  >,
  pub allNotesOff:
    ::core::option::Option<unsafe extern "C" fn(inst: *mut PDSynthInstrument, when: u32)>,
  pub setVolume: ::core::option::Option<
    unsafe extern "C" fn(inst: *mut PDSynthInstrument, left: f32, right: f32),
  >,
  pub getVolume: ::core::option::Option<
    unsafe extern "C" fn(inst: *mut PDSynthInstrument, left: *mut f32, right: *mut f32),
  >,
  pub activeVoiceCount: ::core::option::Option<
    unsafe extern "C" fn(inst: *mut PDSynthInstrument) -> super::ctypes::c_int,
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_instrument() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_instrument>(),
    104usize,
    concat!("Size of: ", stringify!(playdate_sound_instrument))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_instrument>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_instrument))
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_instrument>())).newInstrument as *const _ as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(newInstrument)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_instrument>())).freeInstrument as *const _ as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(freeInstrument)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_instrument>())).addVoice as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(addVoice)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_instrument>())).playNote as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(playNote)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_instrument>())).playMIDINote as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(playMIDINote)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_instrument>())).setPitchBend as *const _ as usize
    },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(setPitchBend)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_instrument>())).setPitchBendRange as *const _ as usize
    },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(setPitchBendRange)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_instrument>())).setTranspose as *const _ as usize
    },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(setTranspose)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_instrument>())).noteOff as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(noteOff)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_instrument>())).allNotesOff as *const _ as usize
    },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(allNotesOff)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_instrument>())).setVolume as *const _ as usize
    },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(setVolume)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_instrument>())).getVolume as *const _ as usize
    },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(getVolume)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_instrument>())).activeVoiceCount as *const _ as usize
    },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_instrument),
      "::",
      stringify!(activeVoiceCount)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SequenceTrack {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_track {
  pub newTrack: ::core::option::Option<unsafe extern "C" fn() -> *mut SequenceTrack>,
  pub freeTrack: ::core::option::Option<unsafe extern "C" fn(track: *mut SequenceTrack)>,
  pub setInstrument: ::core::option::Option<
    unsafe extern "C" fn(track: *mut SequenceTrack, inst: *mut PDSynthInstrument),
  >,
  pub getInstrument: ::core::option::Option<
    unsafe extern "C" fn(track: *mut SequenceTrack) -> *mut PDSynthInstrument,
  >,
  pub addNoteEvent: ::core::option::Option<
    unsafe extern "C" fn(
      track: *mut SequenceTrack,
      step: u32,
      len: u32,
      note: MIDINote,
      velocity: f32,
    ),
  >,
  pub removeNoteEvent: ::core::option::Option<
    unsafe extern "C" fn(track: *mut SequenceTrack, step: u32, note: MIDINote),
  >,
  pub clearNotes: ::core::option::Option<unsafe extern "C" fn(track: *mut SequenceTrack)>,
  pub getControlSignalCount:
    ::core::option::Option<unsafe extern "C" fn(track: *mut SequenceTrack) -> super::ctypes::c_int>,
  pub getControlSignal: ::core::option::Option<
    unsafe extern "C" fn(
      track: *mut SequenceTrack,
      idx: super::ctypes::c_int,
    ) -> *mut ControlSignal,
  >,
  pub clearControlEvents: ::core::option::Option<unsafe extern "C" fn(track: *mut SequenceTrack)>,
  pub getPolyphony:
    ::core::option::Option<unsafe extern "C" fn(track: *mut SequenceTrack) -> super::ctypes::c_int>,
  pub activeVoiceCount:
    ::core::option::Option<unsafe extern "C" fn(track: *mut SequenceTrack) -> super::ctypes::c_int>,
  pub setMuted: ::core::option::Option<
    unsafe extern "C" fn(track: *mut SequenceTrack, mute: super::ctypes::c_int),
  >,
  pub getLength: ::core::option::Option<unsafe extern "C" fn(track: *mut SequenceTrack) -> u32>,
  pub getIndexForStep: ::core::option::Option<
    unsafe extern "C" fn(track: *mut SequenceTrack, step: u32) -> super::ctypes::c_int,
  >,
  pub getNoteAtIndex: ::core::option::Option<
    unsafe extern "C" fn(
      track: *mut SequenceTrack,
      index: super::ctypes::c_int,
      outStep: *mut u32,
      outLen: *mut u32,
      outNote: *mut MIDINote,
      outVelocity: *mut f32,
    ) -> super::ctypes::c_int,
  >,
  pub getSignalForController: ::core::option::Option<
    unsafe extern "C" fn(
      track: *mut SequenceTrack,
      controller: super::ctypes::c_int,
      create: super::ctypes::c_int,
    ) -> *mut ControlSignal,
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_track() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_track>(),
    136usize,
    concat!("Size of: ", stringify!(playdate_sound_track))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_track>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_track))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_track>())).newTrack as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(newTrack)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_track>())).freeTrack as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(freeTrack)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_track>())).setInstrument as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(setInstrument)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_track>())).getInstrument as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(getInstrument)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_track>())).addNoteEvent as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(addNoteEvent)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_track>())).removeNoteEvent as *const _ as usize
    },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(removeNoteEvent)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_track>())).clearNotes as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(clearNotes)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_track>())).getControlSignalCount as *const _ as usize
    },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(getControlSignalCount)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_track>())).getControlSignal as *const _ as usize
    },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(getControlSignal)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_track>())).clearControlEvents as *const _ as usize
    },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(clearControlEvents)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_track>())).getPolyphony as *const _ as usize },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(getPolyphony)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_track>())).activeVoiceCount as *const _ as usize
    },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(activeVoiceCount)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_track>())).setMuted as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(setMuted)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_track>())).getLength as *const _ as usize },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(getLength)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_track>())).getIndexForStep as *const _ as usize
    },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(getIndexForStep)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_track>())).getNoteAtIndex as *const _ as usize
    },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(getNoteAtIndex)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_track>())).getSignalForController as *const _ as usize
    },
    128usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_track),
      "::",
      stringify!(getSignalForController)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SoundSequence {
  _unused: [u8; 0],
}
pub type SequenceFinishedCallback = ::core::option::Option<
  unsafe extern "C" fn(seq: *mut SoundSequence, userdata: *mut super::ctypes::c_void),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_sequence {
  pub newSequence: ::core::option::Option<unsafe extern "C" fn() -> *mut SoundSequence>,
  pub freeSequence: ::core::option::Option<unsafe extern "C" fn(sequence: *mut SoundSequence)>,
  pub loadMidiFile: ::core::option::Option<
    unsafe extern "C" fn(
      seq: *mut SoundSequence,
      path: *const super::ctypes::c_char,
    ) -> super::ctypes::c_int,
  >,
  pub getTime: ::core::option::Option<unsafe extern "C" fn(seq: *mut SoundSequence) -> u32>,
  pub setTime: ::core::option::Option<unsafe extern "C" fn(seq: *mut SoundSequence, time: u32)>,
  pub setLoops: ::core::option::Option<
    unsafe extern "C" fn(
      seq: *mut SoundSequence,
      loopstart: super::ctypes::c_int,
      loopend: super::ctypes::c_int,
      loops: super::ctypes::c_int,
    ),
  >,
  pub getTempo:
    ::core::option::Option<unsafe extern "C" fn(seq: *mut SoundSequence) -> super::ctypes::c_int>,
  pub setTempo: ::core::option::Option<
    unsafe extern "C" fn(seq: *mut SoundSequence, stepsPerSecond: super::ctypes::c_int),
  >,
  pub getTrackCount:
    ::core::option::Option<unsafe extern "C" fn(seq: *mut SoundSequence) -> super::ctypes::c_int>,
  pub addTrack:
    ::core::option::Option<unsafe extern "C" fn(seq: *mut SoundSequence) -> *mut SequenceTrack>,
  pub getTrackAtIndex: ::core::option::Option<
    unsafe extern "C" fn(
      seq: *mut SoundSequence,
      track: super::ctypes::c_uint,
    ) -> *mut SequenceTrack,
  >,
  pub setTrackAtIndex: ::core::option::Option<
    unsafe extern "C" fn(
      seq: *mut SoundSequence,
      track: *mut SequenceTrack,
      idx: super::ctypes::c_uint,
    ),
  >,
  pub allNotesOff: ::core::option::Option<unsafe extern "C" fn(seq: *mut SoundSequence)>,
  pub isPlaying:
    ::core::option::Option<unsafe extern "C" fn(seq: *mut SoundSequence) -> super::ctypes::c_int>,
  pub getLength: ::core::option::Option<unsafe extern "C" fn(seq: *mut SoundSequence) -> u32>,
  pub play: ::core::option::Option<
    unsafe extern "C" fn(
      seq: *mut SoundSequence,
      finishCallback: SequenceFinishedCallback,
      userdata: *mut super::ctypes::c_void,
    ),
  >,
  pub stop: ::core::option::Option<unsafe extern "C" fn(seq: *mut SoundSequence)>,
  pub getCurrentStep: ::core::option::Option<
    unsafe extern "C" fn(
      seq: *mut SoundSequence,
      timeOffset: *mut super::ctypes::c_int,
    ) -> super::ctypes::c_int,
  >,
  pub setCurrentStep: ::core::option::Option<
    unsafe extern "C" fn(
      seq: *mut SoundSequence,
      step: super::ctypes::c_int,
      timeOffset: super::ctypes::c_int,
      playNotes: super::ctypes::c_int,
    ),
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_sequence() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_sequence>(),
    152usize,
    concat!("Size of: ", stringify!(playdate_sound_sequence))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_sequence>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_sequence))
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sequence>())).newSequence as *const _ as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(newSequence)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sequence>())).freeSequence as *const _ as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(freeSequence)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sequence>())).loadMidiFile as *const _ as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(loadMidiFile)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sequence>())).getTime as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(getTime)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sequence>())).setTime as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(setTime)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sequence>())).setLoops as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(setLoops)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sequence>())).getTempo as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(getTempo)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sequence>())).setTempo as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(setTempo)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sequence>())).getTrackCount as *const _ as usize
    },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(getTrackCount)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sequence>())).addTrack as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(addTrack)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sequence>())).getTrackAtIndex as *const _ as usize
    },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(getTrackAtIndex)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sequence>())).setTrackAtIndex as *const _ as usize
    },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(setTrackAtIndex)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sequence>())).allNotesOff as *const _ as usize
    },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(allNotesOff)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sequence>())).isPlaying as *const _ as usize },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(isPlaying)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sequence>())).getLength as *const _ as usize },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(getLength)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sequence>())).play as *const _ as usize },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(play)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_sequence>())).stop as *const _ as usize },
    128usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(stop)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sequence>())).getCurrentStep as *const _ as usize
    },
    136usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(getCurrentStep)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_sequence>())).setCurrentStep as *const _ as usize
    },
    144usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_sequence),
      "::",
      stringify!(setCurrentStep)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TwoPoleFilter {
  _unused: [u8; 0],
}
impl TwoPoleFilterType {
  pub const kFilterTypeLowPass: TwoPoleFilterType = TwoPoleFilterType(0);
}
impl TwoPoleFilterType {
  pub const kFilterTypeHighPass: TwoPoleFilterType = TwoPoleFilterType(1);
}
impl TwoPoleFilterType {
  pub const kFilterTypeBandPass: TwoPoleFilterType = TwoPoleFilterType(2);
}
impl TwoPoleFilterType {
  pub const kFilterTypeNotch: TwoPoleFilterType = TwoPoleFilterType(3);
}
impl TwoPoleFilterType {
  pub const kFilterTypePEQ: TwoPoleFilterType = TwoPoleFilterType(4);
}
impl TwoPoleFilterType {
  pub const kFilterTypeLowShelf: TwoPoleFilterType = TwoPoleFilterType(5);
}
impl TwoPoleFilterType {
  pub const kFilterTypeHighShelf: TwoPoleFilterType = TwoPoleFilterType(6);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct TwoPoleFilterType(pub super::ctypes::c_int);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_effect_twopolefilter {
  pub newFilter: ::core::option::Option<unsafe extern "C" fn() -> *mut TwoPoleFilter>,
  pub freeFilter: ::core::option::Option<unsafe extern "C" fn(filter: *mut TwoPoleFilter)>,
  pub setType: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut TwoPoleFilter, type_: TwoPoleFilterType),
  >,
  pub setFrequency:
    ::core::option::Option<unsafe extern "C" fn(filter: *mut TwoPoleFilter, frequency: f32)>,
  pub setFrequencyModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut TwoPoleFilter, signal: *mut PDSynthSignalValue),
  >,
  pub getFrequencyModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut TwoPoleFilter) -> *mut PDSynthSignalValue,
  >,
  pub setGain: ::core::option::Option<unsafe extern "C" fn(filter: *mut TwoPoleFilter, gain: f32)>,
  pub setResonance:
    ::core::option::Option<unsafe extern "C" fn(filter: *mut TwoPoleFilter, resonance: f32)>,
  pub setResonanceModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut TwoPoleFilter, signal: *mut PDSynthSignalValue),
  >,
  pub getResonanceModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut TwoPoleFilter) -> *mut PDSynthSignalValue,
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_effect_twopolefilter() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_effect_twopolefilter>(),
    80usize,
    concat!("Size of: ", stringify!(playdate_sound_effect_twopolefilter))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_effect_twopolefilter>(),
    8usize,
    concat!(
      "Alignment of ",
      stringify!(playdate_sound_effect_twopolefilter)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_twopolefilter>())).newFilter as *const _
        as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_twopolefilter),
      "::",
      stringify!(newFilter)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_twopolefilter>())).freeFilter as *const _
        as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_twopolefilter),
      "::",
      stringify!(freeFilter)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_twopolefilter>())).setType as *const _ as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_twopolefilter),
      "::",
      stringify!(setType)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_twopolefilter>())).setFrequency as *const _
        as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_twopolefilter),
      "::",
      stringify!(setFrequency)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_twopolefilter>())).setFrequencyModulator
        as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_twopolefilter),
      "::",
      stringify!(setFrequencyModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_twopolefilter>())).getFrequencyModulator
        as *const _ as usize
    },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_twopolefilter),
      "::",
      stringify!(getFrequencyModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_twopolefilter>())).setGain as *const _ as usize
    },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_twopolefilter),
      "::",
      stringify!(setGain)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_twopolefilter>())).setResonance as *const _
        as usize
    },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_twopolefilter),
      "::",
      stringify!(setResonance)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_twopolefilter>())).setResonanceModulator
        as *const _ as usize
    },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_twopolefilter),
      "::",
      stringify!(setResonanceModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_twopolefilter>())).getResonanceModulator
        as *const _ as usize
    },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_twopolefilter),
      "::",
      stringify!(getResonanceModulator)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnePoleFilter {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_effect_onepolefilter {
  pub newFilter: ::core::option::Option<unsafe extern "C" fn() -> *mut OnePoleFilter>,
  pub freeFilter: ::core::option::Option<unsafe extern "C" fn(filter: *mut OnePoleFilter)>,
  pub setParameter:
    ::core::option::Option<unsafe extern "C" fn(filter: *mut OnePoleFilter, parameter: f32)>,
  pub setParameterModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut OnePoleFilter, signal: *mut PDSynthSignalValue),
  >,
  pub getParameterModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut OnePoleFilter) -> *mut PDSynthSignalValue,
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_effect_onepolefilter() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_effect_onepolefilter>(),
    40usize,
    concat!("Size of: ", stringify!(playdate_sound_effect_onepolefilter))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_effect_onepolefilter>(),
    8usize,
    concat!(
      "Alignment of ",
      stringify!(playdate_sound_effect_onepolefilter)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_onepolefilter>())).newFilter as *const _
        as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_onepolefilter),
      "::",
      stringify!(newFilter)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_onepolefilter>())).freeFilter as *const _
        as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_onepolefilter),
      "::",
      stringify!(freeFilter)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_onepolefilter>())).setParameter as *const _
        as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_onepolefilter),
      "::",
      stringify!(setParameter)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_onepolefilter>())).setParameterModulator
        as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_onepolefilter),
      "::",
      stringify!(setParameterModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_onepolefilter>())).getParameterModulator
        as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_onepolefilter),
      "::",
      stringify!(getParameterModulator)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitCrusher {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_effect_bitcrusher {
  pub newBitCrusher: ::core::option::Option<unsafe extern "C" fn() -> *mut BitCrusher>,
  pub freeBitCrusher: ::core::option::Option<unsafe extern "C" fn(filter: *mut BitCrusher)>,
  pub setAmount: ::core::option::Option<unsafe extern "C" fn(filter: *mut BitCrusher, amount: f32)>,
  pub setAmountModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut BitCrusher, signal: *mut PDSynthSignalValue),
  >,
  pub getAmountModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut BitCrusher) -> *mut PDSynthSignalValue,
  >,
  pub setUndersampling:
    ::core::option::Option<unsafe extern "C" fn(filter: *mut BitCrusher, undersampling: f32)>,
  pub setUndersampleModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut BitCrusher, signal: *mut PDSynthSignalValue),
  >,
  pub getUndersampleModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut BitCrusher) -> *mut PDSynthSignalValue,
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_effect_bitcrusher() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_effect_bitcrusher>(),
    64usize,
    concat!("Size of: ", stringify!(playdate_sound_effect_bitcrusher))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_effect_bitcrusher>(),
    8usize,
    concat!(
      "Alignment of ",
      stringify!(playdate_sound_effect_bitcrusher)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_bitcrusher>())).newBitCrusher as *const _
        as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_bitcrusher),
      "::",
      stringify!(newBitCrusher)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_bitcrusher>())).freeBitCrusher as *const _
        as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_bitcrusher),
      "::",
      stringify!(freeBitCrusher)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_bitcrusher>())).setAmount as *const _ as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_bitcrusher),
      "::",
      stringify!(setAmount)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_bitcrusher>())).setAmountModulator as *const _
        as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_bitcrusher),
      "::",
      stringify!(setAmountModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_bitcrusher>())).getAmountModulator as *const _
        as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_bitcrusher),
      "::",
      stringify!(getAmountModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_bitcrusher>())).setUndersampling as *const _
        as usize
    },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_bitcrusher),
      "::",
      stringify!(setUndersampling)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_bitcrusher>())).setUndersampleModulator
        as *const _ as usize
    },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_bitcrusher),
      "::",
      stringify!(setUndersampleModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_bitcrusher>())).getUndersampleModulator
        as *const _ as usize
    },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_bitcrusher),
      "::",
      stringify!(getUndersampleModulator)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RingModulator {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_effect_ringmodulator {
  pub newRingmod: ::core::option::Option<unsafe extern "C" fn() -> *mut RingModulator>,
  pub freeRingmod: ::core::option::Option<unsafe extern "C" fn(filter: *mut RingModulator)>,
  pub setFrequency:
    ::core::option::Option<unsafe extern "C" fn(filter: *mut RingModulator, frequency: f32)>,
  pub setFrequencyModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut RingModulator, signal: *mut PDSynthSignalValue),
  >,
  pub getFrequencyModulator: ::core::option::Option<
    unsafe extern "C" fn(filter: *mut RingModulator) -> *mut PDSynthSignalValue,
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_effect_ringmodulator() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_effect_ringmodulator>(),
    40usize,
    concat!("Size of: ", stringify!(playdate_sound_effect_ringmodulator))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_effect_ringmodulator>(),
    8usize,
    concat!(
      "Alignment of ",
      stringify!(playdate_sound_effect_ringmodulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_ringmodulator>())).newRingmod as *const _
        as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_ringmodulator),
      "::",
      stringify!(newRingmod)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_ringmodulator>())).freeRingmod as *const _
        as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_ringmodulator),
      "::",
      stringify!(freeRingmod)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_ringmodulator>())).setFrequency as *const _
        as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_ringmodulator),
      "::",
      stringify!(setFrequency)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_ringmodulator>())).setFrequencyModulator
        as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_ringmodulator),
      "::",
      stringify!(setFrequencyModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_ringmodulator>())).getFrequencyModulator
        as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_ringmodulator),
      "::",
      stringify!(getFrequencyModulator)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DelayLine {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DelayLineTap {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_effect_delayline {
  pub newDelayLine: ::core::option::Option<
    unsafe extern "C" fn(
      length: super::ctypes::c_int,
      stereo: super::ctypes::c_int,
    ) -> *mut DelayLine,
  >,
  pub freeDelayLine: ::core::option::Option<unsafe extern "C" fn(filter: *mut DelayLine)>,
  pub setLength:
    ::core::option::Option<unsafe extern "C" fn(d: *mut DelayLine, frames: super::ctypes::c_int)>,
  pub setFeedback: ::core::option::Option<unsafe extern "C" fn(d: *mut DelayLine, fb: f32)>,
  pub addTap: ::core::option::Option<
    unsafe extern "C" fn(d: *mut DelayLine, delay: super::ctypes::c_int) -> *mut DelayLineTap,
  >,
  pub freeTap: ::core::option::Option<unsafe extern "C" fn(tap: *mut DelayLineTap)>,
  pub setTapDelay: ::core::option::Option<
    unsafe extern "C" fn(t: *mut DelayLineTap, frames: super::ctypes::c_int),
  >,
  pub setTapDelayModulator: ::core::option::Option<
    unsafe extern "C" fn(t: *mut DelayLineTap, mod_: *mut PDSynthSignalValue),
  >,
  pub getTapDelayModulator:
    ::core::option::Option<unsafe extern "C" fn(t: *mut DelayLineTap) -> *mut PDSynthSignalValue>,
  pub setTapChannelsFlipped:
    ::core::option::Option<unsafe extern "C" fn(t: *mut DelayLineTap, flip: super::ctypes::c_int)>,
}
#[test]
fn bindgen_test_layout_playdate_sound_effect_delayline() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_effect_delayline>(),
    80usize,
    concat!("Size of: ", stringify!(playdate_sound_effect_delayline))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_effect_delayline>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_effect_delayline))
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_delayline>())).newDelayLine as *const _ as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_delayline),
      "::",
      stringify!(newDelayLine)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_delayline>())).freeDelayLine as *const _
        as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_delayline),
      "::",
      stringify!(freeDelayLine)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_delayline>())).setLength as *const _ as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_delayline),
      "::",
      stringify!(setLength)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_delayline>())).setFeedback as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_delayline),
      "::",
      stringify!(setFeedback)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_delayline>())).addTap as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_delayline),
      "::",
      stringify!(addTap)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_delayline>())).freeTap as *const _ as usize
    },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_delayline),
      "::",
      stringify!(freeTap)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_delayline>())).setTapDelay as *const _ as usize
    },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_delayline),
      "::",
      stringify!(setTapDelay)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_delayline>())).setTapDelayModulator as *const _
        as usize
    },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_delayline),
      "::",
      stringify!(setTapDelayModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_delayline>())).getTapDelayModulator as *const _
        as usize
    },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_delayline),
      "::",
      stringify!(getTapDelayModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_delayline>())).setTapChannelsFlipped as *const _
        as usize
    },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_delayline),
      "::",
      stringify!(setTapChannelsFlipped)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Overdrive {
  _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_effect_overdrive {
  pub newOverdrive: ::core::option::Option<unsafe extern "C" fn() -> *mut Overdrive>,
  pub freeOverdrive: ::core::option::Option<unsafe extern "C" fn(filter: *mut Overdrive)>,
  pub setGain: ::core::option::Option<unsafe extern "C" fn(o: *mut Overdrive, gain: f32)>,
  pub setLimit: ::core::option::Option<unsafe extern "C" fn(o: *mut Overdrive, limit: f32)>,
  pub setLimitModulator:
    ::core::option::Option<unsafe extern "C" fn(o: *mut Overdrive, mod_: *mut PDSynthSignalValue)>,
  pub getLimitModulator:
    ::core::option::Option<unsafe extern "C" fn(o: *mut Overdrive) -> *mut PDSynthSignalValue>,
  pub setOffset: ::core::option::Option<unsafe extern "C" fn(o: *mut Overdrive, offset: f32)>,
  pub setOffsetModulator:
    ::core::option::Option<unsafe extern "C" fn(o: *mut Overdrive, mod_: *mut PDSynthSignalValue)>,
  pub getOffsetModulator:
    ::core::option::Option<unsafe extern "C" fn(o: *mut Overdrive) -> *mut PDSynthSignalValue>,
}
#[test]
fn bindgen_test_layout_playdate_sound_effect_overdrive() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_effect_overdrive>(),
    72usize,
    concat!("Size of: ", stringify!(playdate_sound_effect_overdrive))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_effect_overdrive>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_effect_overdrive))
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_overdrive>())).newOverdrive as *const _ as usize
    },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_overdrive),
      "::",
      stringify!(newOverdrive)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_overdrive>())).freeOverdrive as *const _
        as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_overdrive),
      "::",
      stringify!(freeOverdrive)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_overdrive>())).setGain as *const _ as usize
    },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_overdrive),
      "::",
      stringify!(setGain)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_overdrive>())).setLimit as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_overdrive),
      "::",
      stringify!(setLimit)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_overdrive>())).setLimitModulator as *const _
        as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_overdrive),
      "::",
      stringify!(setLimitModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_overdrive>())).getLimitModulator as *const _
        as usize
    },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_overdrive),
      "::",
      stringify!(getLimitModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_overdrive>())).setOffset as *const _ as usize
    },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_overdrive),
      "::",
      stringify!(setOffset)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_overdrive>())).setOffsetModulator as *const _
        as usize
    },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_overdrive),
      "::",
      stringify!(setOffsetModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect_overdrive>())).getOffsetModulator as *const _
        as usize
    },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect_overdrive),
      "::",
      stringify!(getOffsetModulator)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SoundEffect {
  _unused: [u8; 0],
}
pub type effectProc = ::core::option::Option<
  unsafe extern "C" fn(
    e: *mut SoundEffect,
    left: *mut i32,
    right: *mut i32,
    nsamples: super::ctypes::c_int,
    bufactive: super::ctypes::c_int,
  ) -> super::ctypes::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_effect {
  pub newEffect: ::core::option::Option<
    unsafe extern "C" fn(
      proc_: effectProc,
      userdata: *mut super::ctypes::c_void,
    ) -> *mut SoundEffect,
  >,
  pub freeEffect: ::core::option::Option<unsafe extern "C" fn(effect: *mut SoundEffect)>,
  pub setMix: ::core::option::Option<unsafe extern "C" fn(effect: *mut SoundEffect, level: f32)>,
  pub setMixModulator: ::core::option::Option<
    unsafe extern "C" fn(effect: *mut SoundEffect, signal: *mut PDSynthSignalValue),
  >,
  pub getMixModulator: ::core::option::Option<
    unsafe extern "C" fn(effect: *mut SoundEffect) -> *mut PDSynthSignalValue,
  >,
  pub setUserdata: ::core::option::Option<
    unsafe extern "C" fn(effect: *mut SoundEffect, userdata: *mut super::ctypes::c_void),
  >,
  pub getUserdata: ::core::option::Option<
    unsafe extern "C" fn(effect: *mut SoundEffect) -> *mut super::ctypes::c_void,
  >,
  pub twopolefilter: *const playdate_sound_effect_twopolefilter,
  pub onepolefilter: *const playdate_sound_effect_onepolefilter,
  pub bitcrusher: *const playdate_sound_effect_bitcrusher,
  pub ringmodulator: *const playdate_sound_effect_ringmodulator,
  pub delayline: *const playdate_sound_effect_delayline,
  pub overdrive: *const playdate_sound_effect_overdrive,
}
#[test]
fn bindgen_test_layout_playdate_sound_effect() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_effect>(),
    104usize,
    concat!("Size of: ", stringify!(playdate_sound_effect))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_effect>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_effect))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_effect>())).newEffect as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(newEffect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_effect>())).freeEffect as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(freeEffect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_effect>())).setMix as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(setMix)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect>())).setMixModulator as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(setMixModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect>())).getMixModulator as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(getMixModulator)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_effect>())).setUserdata as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(setUserdata)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_effect>())).getUserdata as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(getUserdata)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect>())).twopolefilter as *const _ as usize
    },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(twopolefilter)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect>())).onepolefilter as *const _ as usize
    },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(onepolefilter)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_effect>())).bitcrusher as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(bitcrusher)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_effect>())).ringmodulator as *const _ as usize
    },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(ringmodulator)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_effect>())).delayline as *const _ as usize },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(delayline)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_effect>())).overdrive as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_effect),
      "::",
      stringify!(overdrive)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SoundChannel {
  _unused: [u8; 0],
}
pub type AudioSourceFunction = ::core::option::Option<
  unsafe extern "C" fn(
    context: *mut super::ctypes::c_void,
    left: *mut i16,
    right: *mut i16,
    len: super::ctypes::c_int,
  ) -> super::ctypes::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound_channel {
  pub newChannel: ::core::option::Option<unsafe extern "C" fn() -> *mut SoundChannel>,
  pub freeChannel: ::core::option::Option<unsafe extern "C" fn(channel: *mut SoundChannel)>,
  pub addSource: ::core::option::Option<
    unsafe extern "C" fn(
      channel: *mut SoundChannel,
      source: *mut SoundSource,
    ) -> super::ctypes::c_int,
  >,
  pub removeSource: ::core::option::Option<
    unsafe extern "C" fn(
      channel: *mut SoundChannel,
      source: *mut SoundSource,
    ) -> super::ctypes::c_int,
  >,
  pub addCallbackSource: ::core::option::Option<
    unsafe extern "C" fn(
      channel: *mut SoundChannel,
      callback: AudioSourceFunction,
      context: *mut super::ctypes::c_void,
      stereo: super::ctypes::c_int,
    ) -> *mut SoundSource,
  >,
  pub addEffect: ::core::option::Option<
    unsafe extern "C" fn(channel: *mut SoundChannel, effect: *mut SoundEffect),
  >,
  pub removeEffect: ::core::option::Option<
    unsafe extern "C" fn(channel: *mut SoundChannel, effect: *mut SoundEffect),
  >,
  pub setVolume:
    ::core::option::Option<unsafe extern "C" fn(channel: *mut SoundChannel, volume: f32)>,
  pub getVolume: ::core::option::Option<unsafe extern "C" fn(channel: *mut SoundChannel) -> f32>,
  pub setVolumeModulator: ::core::option::Option<
    unsafe extern "C" fn(channel: *mut SoundChannel, mod_: *mut PDSynthSignalValue),
  >,
  pub getVolumeModulator: ::core::option::Option<
    unsafe extern "C" fn(channel: *mut SoundChannel) -> *mut PDSynthSignalValue,
  >,
  pub setPan: ::core::option::Option<unsafe extern "C" fn(channel: *mut SoundChannel, pan: f32)>,
  pub setPanModulator: ::core::option::Option<
    unsafe extern "C" fn(channel: *mut SoundChannel, mod_: *mut PDSynthSignalValue),
  >,
  pub getPanModulator: ::core::option::Option<
    unsafe extern "C" fn(channel: *mut SoundChannel) -> *mut PDSynthSignalValue,
  >,
  pub getDryLevelSignal: ::core::option::Option<
    unsafe extern "C" fn(channel: *mut SoundChannel) -> *mut PDSynthSignalValue,
  >,
  pub getWetLevelSignal: ::core::option::Option<
    unsafe extern "C" fn(channel: *mut SoundChannel) -> *mut PDSynthSignalValue,
  >,
}
#[test]
fn bindgen_test_layout_playdate_sound_channel() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound_channel>(),
    128usize,
    concat!("Size of: ", stringify!(playdate_sound_channel))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound_channel>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound_channel))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_channel>())).newChannel as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(newChannel)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_channel>())).freeChannel as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(freeChannel)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_channel>())).addSource as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(addSource)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_channel>())).removeSource as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(removeSource)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_channel>())).addCallbackSource as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(addCallbackSource)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_channel>())).addEffect as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(addEffect)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_channel>())).removeEffect as *const _ as usize
    },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(removeEffect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_channel>())).setVolume as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(setVolume)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_channel>())).getVolume as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(getVolume)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_channel>())).setVolumeModulator as *const _ as usize
    },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(setVolumeModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_channel>())).getVolumeModulator as *const _ as usize
    },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(getVolumeModulator)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound_channel>())).setPan as *const _ as usize },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(setPan)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_channel>())).setPanModulator as *const _ as usize
    },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(setPanModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_channel>())).getPanModulator as *const _ as usize
    },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(getPanModulator)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_channel>())).getDryLevelSignal as *const _ as usize
    },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(getDryLevelSignal)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_sound_channel>())).getWetLevelSignal as *const _ as usize
    },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound_channel),
      "::",
      stringify!(getWetLevelSignal)
    )
  );
}
pub type RecordCallback = ::core::option::Option<
  unsafe extern "C" fn(
    context: *mut super::ctypes::c_void,
    buffer: *mut i16,
    length: super::ctypes::c_int,
  ) -> super::ctypes::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_sound {
  pub channel: *const playdate_sound_channel,
  pub fileplayer: *const playdate_sound_fileplayer,
  pub sample: *const playdate_sound_sample,
  pub sampleplayer: *const playdate_sound_sampleplayer,
  pub synth: *const playdate_sound_synth,
  pub sequence: *const playdate_sound_sequence,
  pub effect: *const playdate_sound_effect,
  pub lfo: *const playdate_sound_lfo,
  pub envelope: *const playdate_sound_envelope,
  pub source: *const playdate_sound_source,
  pub controlsignal: *const playdate_control_signal,
  pub track: *const playdate_sound_track,
  pub instrument: *const playdate_sound_instrument,
  pub getCurrentTime: ::core::option::Option<unsafe extern "C" fn() -> u32>,
  pub addSource: ::core::option::Option<
    unsafe extern "C" fn(
      callback: AudioSourceFunction,
      context: *mut super::ctypes::c_void,
      stereo: super::ctypes::c_int,
    ) -> *mut SoundSource,
  >,
  pub getDefaultChannel: ::core::option::Option<unsafe extern "C" fn() -> *mut SoundChannel>,
  pub addChannel: ::core::option::Option<unsafe extern "C" fn(channel: *mut SoundChannel)>,
  pub removeChannel: ::core::option::Option<unsafe extern "C" fn(channel: *mut SoundChannel)>,
  pub setMicCallback: ::core::option::Option<
    unsafe extern "C" fn(
      callback: RecordCallback,
      context: *mut super::ctypes::c_void,
      forceInternal: super::ctypes::c_int,
    ),
  >,
  pub getHeadphoneState: ::core::option::Option<
    unsafe extern "C" fn(
      headphone: *mut super::ctypes::c_int,
      headsetmic: *mut super::ctypes::c_int,
      changeCallback: ::core::option::Option<
        unsafe extern "C" fn(headphone: super::ctypes::c_int, mic: super::ctypes::c_int),
      >,
    ),
  >,
  pub setOutputsActive: ::core::option::Option<
    unsafe extern "C" fn(headphone: super::ctypes::c_int, speaker: super::ctypes::c_int),
  >,
  pub removeSource: ::core::option::Option<unsafe extern "C" fn(source: *mut SoundSource)>,
}
#[test]
fn bindgen_test_layout_playdate_sound() {
  assert_eq!(
    ::core::mem::size_of::<playdate_sound>(),
    176usize,
    concat!("Size of: ", stringify!(playdate_sound))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_sound>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_sound))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).channel as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(channel)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).fileplayer as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(fileplayer)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).sample as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(sample)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).sampleplayer as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(sampleplayer)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).synth as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(synth)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).sequence as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(sequence)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).effect as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(effect)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).lfo as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(lfo)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).envelope as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(envelope)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).source as *const _ as usize },
    72usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(source)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).controlsignal as *const _ as usize },
    80usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(controlsignal)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).track as *const _ as usize },
    88usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(track)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).instrument as *const _ as usize },
    96usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(instrument)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).getCurrentTime as *const _ as usize },
    104usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(getCurrentTime)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).addSource as *const _ as usize },
    112usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(addSource)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).getDefaultChannel as *const _ as usize },
    120usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(getDefaultChannel)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).addChannel as *const _ as usize },
    128usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(addChannel)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).removeChannel as *const _ as usize },
    136usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(removeChannel)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).setMicCallback as *const _ as usize },
    144usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(setMicCallback)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).getHeadphoneState as *const _ as usize },
    152usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(getHeadphoneState)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).setOutputsActive as *const _ as usize },
    160usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(setOutputsActive)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_sound>())).removeSource as *const _ as usize },
    168usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_sound),
      "::",
      stringify!(removeSource)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_display {
  pub getWidth: ::core::option::Option<unsafe extern "C" fn() -> super::ctypes::c_int>,
  pub getHeight: ::core::option::Option<unsafe extern "C" fn() -> super::ctypes::c_int>,
  pub setRefreshRate: ::core::option::Option<unsafe extern "C" fn(rate: f32)>,
  pub setInverted: ::core::option::Option<unsafe extern "C" fn(flag: super::ctypes::c_int)>,
  pub setScale: ::core::option::Option<unsafe extern "C" fn(s: super::ctypes::c_uint)>,
  pub setMosaic: ::core::option::Option<
    unsafe extern "C" fn(x: super::ctypes::c_uint, y: super::ctypes::c_uint),
  >,
  pub setFlipped:
    ::core::option::Option<unsafe extern "C" fn(x: super::ctypes::c_int, y: super::ctypes::c_int)>,
  pub setOffset:
    ::core::option::Option<unsafe extern "C" fn(x: super::ctypes::c_int, y: super::ctypes::c_int)>,
}
#[test]
fn bindgen_test_layout_playdate_display() {
  assert_eq!(
    ::core::mem::size_of::<playdate_display>(),
    64usize,
    concat!("Size of: ", stringify!(playdate_display))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_display>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_display))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_display>())).getWidth as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_display),
      "::",
      stringify!(getWidth)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_display>())).getHeight as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_display),
      "::",
      stringify!(getHeight)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_display>())).setRefreshRate as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_display),
      "::",
      stringify!(setRefreshRate)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_display>())).setInverted as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_display),
      "::",
      stringify!(setInverted)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_display>())).setScale as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_display),
      "::",
      stringify!(setScale)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_display>())).setMosaic as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_display),
      "::",
      stringify!(setMosaic)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_display>())).setFlipped as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_display),
      "::",
      stringify!(setFlipped)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_display>())).setOffset as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_display),
      "::",
      stringify!(setOffset)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDScore {
  pub rank: u32,
  pub value: u32,
  pub player: *mut super::ctypes::c_char,
}
#[test]
fn bindgen_test_layout_PDScore() {
  assert_eq!(
    ::core::mem::size_of::<PDScore>(),
    16usize,
    concat!("Size of: ", stringify!(PDScore))
  );
  assert_eq!(
    ::core::mem::align_of::<PDScore>(),
    8usize,
    concat!("Alignment of ", stringify!(PDScore))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDScore>())).rank as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(PDScore),
      "::",
      stringify!(rank)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDScore>())).value as *const _ as usize },
    4usize,
    concat!(
      "Offset of field: ",
      stringify!(PDScore),
      "::",
      stringify!(value)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDScore>())).player as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(PDScore),
      "::",
      stringify!(player)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDScoresList {
  pub boardID: *mut super::ctypes::c_char,
  pub count: super::ctypes::c_uint,
  pub lastUpdated: u32,
  pub playerIncluded: super::ctypes::c_int,
  pub limit: super::ctypes::c_uint,
  pub scores: *mut PDScore,
}
#[test]
fn bindgen_test_layout_PDScoresList() {
  assert_eq!(
    ::core::mem::size_of::<PDScoresList>(),
    32usize,
    concat!("Size of: ", stringify!(PDScoresList))
  );
  assert_eq!(
    ::core::mem::align_of::<PDScoresList>(),
    8usize,
    concat!("Alignment of ", stringify!(PDScoresList))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDScoresList>())).boardID as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(PDScoresList),
      "::",
      stringify!(boardID)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDScoresList>())).count as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(PDScoresList),
      "::",
      stringify!(count)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDScoresList>())).lastUpdated as *const _ as usize },
    12usize,
    concat!(
      "Offset of field: ",
      stringify!(PDScoresList),
      "::",
      stringify!(lastUpdated)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDScoresList>())).playerIncluded as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(PDScoresList),
      "::",
      stringify!(playerIncluded)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDScoresList>())).limit as *const _ as usize },
    20usize,
    concat!(
      "Offset of field: ",
      stringify!(PDScoresList),
      "::",
      stringify!(limit)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDScoresList>())).scores as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(PDScoresList),
      "::",
      stringify!(scores)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDBoard {
  pub boardID: *mut super::ctypes::c_char,
  pub name: *mut super::ctypes::c_char,
}
#[test]
fn bindgen_test_layout_PDBoard() {
  assert_eq!(
    ::core::mem::size_of::<PDBoard>(),
    16usize,
    concat!("Size of: ", stringify!(PDBoard))
  );
  assert_eq!(
    ::core::mem::align_of::<PDBoard>(),
    8usize,
    concat!("Alignment of ", stringify!(PDBoard))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDBoard>())).boardID as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(PDBoard),
      "::",
      stringify!(boardID)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDBoard>())).name as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(PDBoard),
      "::",
      stringify!(name)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PDBoardsList {
  pub count: super::ctypes::c_uint,
  pub lastUpdated: u32,
  pub boards: *mut PDBoard,
}
#[test]
fn bindgen_test_layout_PDBoardsList() {
  assert_eq!(
    ::core::mem::size_of::<PDBoardsList>(),
    16usize,
    concat!("Size of: ", stringify!(PDBoardsList))
  );
  assert_eq!(
    ::core::mem::align_of::<PDBoardsList>(),
    8usize,
    concat!("Alignment of ", stringify!(PDBoardsList))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDBoardsList>())).count as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(PDBoardsList),
      "::",
      stringify!(count)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDBoardsList>())).lastUpdated as *const _ as usize },
    4usize,
    concat!(
      "Offset of field: ",
      stringify!(PDBoardsList),
      "::",
      stringify!(lastUpdated)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PDBoardsList>())).boards as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(PDBoardsList),
      "::",
      stringify!(boards)
    )
  );
}
pub type AddScoreCallback = ::core::option::Option<
  unsafe extern "C" fn(score: *mut PDScore, errorMessage: *const super::ctypes::c_char),
>;
pub type PersonalBestCallback = ::core::option::Option<
  unsafe extern "C" fn(score: *mut PDScore, errorMessage: *const super::ctypes::c_char),
>;
pub type BoardsListCallback = ::core::option::Option<
  unsafe extern "C" fn(boards: *mut PDBoardsList, errorMessage: *const super::ctypes::c_char),
>;
pub type ScoresCallback = ::core::option::Option<
  unsafe extern "C" fn(scores: *mut PDScoresList, errorMessage: *const super::ctypes::c_char),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct playdate_scoreboards {
  pub addScore: ::core::option::Option<
    unsafe extern "C" fn(
      boardId: *const super::ctypes::c_char,
      value: u32,
      callback: AddScoreCallback,
    ) -> super::ctypes::c_int,
  >,
  pub getPersonalBest: ::core::option::Option<
    unsafe extern "C" fn(
      boardId: *const super::ctypes::c_char,
      callback: PersonalBestCallback,
    ) -> super::ctypes::c_int,
  >,
  pub freeScore: ::core::option::Option<unsafe extern "C" fn(score: *mut PDScore)>,
  pub getScoreboards: ::core::option::Option<
    unsafe extern "C" fn(callback: BoardsListCallback) -> super::ctypes::c_int,
  >,
  pub freeBoardsList: ::core::option::Option<unsafe extern "C" fn(boardsList: *mut PDBoardsList)>,
  pub getScores: ::core::option::Option<
    unsafe extern "C" fn(
      boardId: *const super::ctypes::c_char,
      callback: ScoresCallback,
    ) -> super::ctypes::c_int,
  >,
  pub freeScoresList: ::core::option::Option<unsafe extern "C" fn(scoresList: *mut PDScoresList)>,
}
#[test]
fn bindgen_test_layout_playdate_scoreboards() {
  assert_eq!(
    ::core::mem::size_of::<playdate_scoreboards>(),
    56usize,
    concat!("Size of: ", stringify!(playdate_scoreboards))
  );
  assert_eq!(
    ::core::mem::align_of::<playdate_scoreboards>(),
    8usize,
    concat!("Alignment of ", stringify!(playdate_scoreboards))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_scoreboards>())).addScore as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_scoreboards),
      "::",
      stringify!(addScore)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_scoreboards>())).getPersonalBest as *const _ as usize
    },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_scoreboards),
      "::",
      stringify!(getPersonalBest)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_scoreboards>())).freeScore as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_scoreboards),
      "::",
      stringify!(freeScore)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_scoreboards>())).getScoreboards as *const _ as usize
    },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_scoreboards),
      "::",
      stringify!(getScoreboards)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_scoreboards>())).freeBoardsList as *const _ as usize
    },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_scoreboards),
      "::",
      stringify!(freeBoardsList)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<playdate_scoreboards>())).getScores as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_scoreboards),
      "::",
      stringify!(getScores)
    )
  );
  assert_eq!(
    unsafe {
      &(*(::core::ptr::null::<playdate_scoreboards>())).freeScoresList as *const _ as usize
    },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(playdate_scoreboards),
      "::",
      stringify!(freeScoresList)
    )
  );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlaydateAPI {
  pub system: *const playdate_sys,
  pub file: *const playdate_file,
  pub graphics: *const playdate_graphics,
  pub sprite: *const playdate_sprite,
  pub display: *const playdate_display,
  pub sound: *const playdate_sound,
  pub lua: *const playdate_lua,
  pub json: *const playdate_json,
  pub scoreboards: *const playdate_scoreboards,
}
#[test]
fn bindgen_test_layout_PlaydateAPI() {
  assert_eq!(
    ::core::mem::size_of::<PlaydateAPI>(),
    72usize,
    concat!("Size of: ", stringify!(PlaydateAPI))
  );
  assert_eq!(
    ::core::mem::align_of::<PlaydateAPI>(),
    8usize,
    concat!("Alignment of ", stringify!(PlaydateAPI))
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PlaydateAPI>())).system as *const _ as usize },
    0usize,
    concat!(
      "Offset of field: ",
      stringify!(PlaydateAPI),
      "::",
      stringify!(system)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PlaydateAPI>())).file as *const _ as usize },
    8usize,
    concat!(
      "Offset of field: ",
      stringify!(PlaydateAPI),
      "::",
      stringify!(file)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PlaydateAPI>())).graphics as *const _ as usize },
    16usize,
    concat!(
      "Offset of field: ",
      stringify!(PlaydateAPI),
      "::",
      stringify!(graphics)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PlaydateAPI>())).sprite as *const _ as usize },
    24usize,
    concat!(
      "Offset of field: ",
      stringify!(PlaydateAPI),
      "::",
      stringify!(sprite)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PlaydateAPI>())).display as *const _ as usize },
    32usize,
    concat!(
      "Offset of field: ",
      stringify!(PlaydateAPI),
      "::",
      stringify!(display)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PlaydateAPI>())).sound as *const _ as usize },
    40usize,
    concat!(
      "Offset of field: ",
      stringify!(PlaydateAPI),
      "::",
      stringify!(sound)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PlaydateAPI>())).lua as *const _ as usize },
    48usize,
    concat!(
      "Offset of field: ",
      stringify!(PlaydateAPI),
      "::",
      stringify!(lua)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PlaydateAPI>())).json as *const _ as usize },
    56usize,
    concat!(
      "Offset of field: ",
      stringify!(PlaydateAPI),
      "::",
      stringify!(json)
    )
  );
  assert_eq!(
    unsafe { &(*(::core::ptr::null::<PlaydateAPI>())).scoreboards as *const _ as usize },
    64usize,
    concat!(
      "Offset of field: ",
      stringify!(PlaydateAPI),
      "::",
      stringify!(scoreboards)
    )
  );
}
impl PDSystemEvent {
  pub const kEventInit: PDSystemEvent = PDSystemEvent(0);
}
impl PDSystemEvent {
  pub const kEventInitLua: PDSystemEvent = PDSystemEvent(1);
}
impl PDSystemEvent {
  pub const kEventLock: PDSystemEvent = PDSystemEvent(2);
}
impl PDSystemEvent {
  pub const kEventUnlock: PDSystemEvent = PDSystemEvent(3);
}
impl PDSystemEvent {
  pub const kEventPause: PDSystemEvent = PDSystemEvent(4);
}
impl PDSystemEvent {
  pub const kEventResume: PDSystemEvent = PDSystemEvent(5);
}
impl PDSystemEvent {
  pub const kEventTerminate: PDSystemEvent = PDSystemEvent(6);
}
impl PDSystemEvent {
  pub const kEventKeyPressed: PDSystemEvent = PDSystemEvent(7);
}
impl PDSystemEvent {
  pub const kEventKeyReleased: PDSystemEvent = PDSystemEvent(8);
}
impl PDSystemEvent {
  pub const kEventLowPower: PDSystemEvent = PDSystemEvent(9);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct PDSystemEvent(pub super::ctypes::c_int);
extern "C" {
  pub fn eventHandler(
    playdate: *mut PlaydateAPI,
    event: PDSystemEvent,
    arg: u32,
  ) -> super::ctypes::c_int;
}
