/// You can use this macro to "feature-gate" code depending on the placeholder
/// having been overridden (you'll need to define an identity macro in your
/// proxy crate):
///
/** ```rust ,ignore
//! overriding crate

// (identity macro)
#[macro_export]
macro_rules! cfg_not_placeholder {( $($input:tt)* ) => (
    $($input)*
)}
``` */
///
/// With it, you can then use:
///
/** ```rust ,ignore
::your_crate_proxy::cfg_not_placeholder! {
    use ::your_crate_proxy::{your, stuff};

    // …
}
``` */
#[macro_export]
macro_rules! cfg_not_placeholder {( $($input:tt)* ) => (
    /* no output since we are the placeholder */
)}
