### `::cratesio-placeholder-package`

> If there is _nothing_ in a crate, then _a fortiori_,
> there is _nothing wrong_ with it either!

> If you depend on a crate and it is empty, did you really depend on that crate?

## Rationale

Sometimes you may want to publish a crate having a private / git / local
dependency, which is useful for local or experimental development stuff,
but which prevents your crate from being published.

In that case, you can use this ~~hack~~ empty placeholder package in its stead:

```toml
# Cargo.toml

[dependencies.your-crate-proxy]
# What public / crates.io users will see/use:
package = "cratesio-placeholder-package"
version = "=0.0.0"

# What `path` dependents will use
path = "path/to/your-crate-proxy"
```

and then have a `your-crate-proxy` crate, at version `0.0.0`, somewhere in your
private project layout, which correctly depends on the other private stuff you
may need.

```toml
# path/to/your-crate-proxy/Cargo.toml

[package]
name = "your-crate-proxy"
version = "0.0.0"

[dependencies]
# the real private dependency(ies)
your-crate.path = "private/your-crate"
```

### Feature: proxying Cargo `feature`s

<details>

Sometimes, you may also want to proxy features from the frontend to your private dependency.

In order to do that, such features will need to be proxied through
this `cratesio-placeholder-package`.

Hence why this package also features a total of 26 placeholder features
which you can use for the proxying:

```toml
# Cargo.toml
[features]
foo = ["your-crate-proxy/placeholder-feature-a"]

[dependencies.your-crate-proxy]
# What public / crates.io users will see/use:
package = "cratesio-placeholder-package"
version = "=0.0.0"

# What `path` dependents will use
path = "path/to/your-crate-proxy"
```

\+

```toml
# path/to/your-crate-proxy/Cargo.toml
[package]
name = "your-crate-proxy"
version = "0.0.0"

[dependencies]
# the real private dependency(ies)
your-crate.path = "private/your-crate"

[features]
placeholder-feature-a = ["your-crate/foo"]
```

</details>
