// Documentation comments use three slashes
// They are in markdown syntax

// cargo test will run the code in example documentation as tests

//! # Crates
//!
//! `crates` is a collection of utilities to make performing certain
//! calculations more convenient.
//!
//! Describe the crate's organization and overall purpose here
/// Adds one to the number given.
///
/// # Examples
///
/// ```
/// let arg = 5;
/// let answer = crates::add_one(arg);
///
/// assert_eq!(6, answer);
/// ```
pub fn add_one(x: i32) -> i32 {
    x + 1
}

// sections that crates usually have in their documentation (not all required, but good checklist):
// # Examples
// # Panics - scenarios in which the function being documented could panic
// # Errors - if the function returns a Result enum, describes the type of errors that might occur and waht conditions might cause those errors to be returned
// # Safety - If teh function is unsafe, there should be an explanation why that covers the invariants that the function expects callers to uphold

// 'pub use' can be used to re-export items to make a public structure that is different from the private structure.
// this is useful for situations where the module organization makes sense for developers working on the crates, but not for somebody trying to use the crate.

// with pub use these are now easier to find on the Crate documentation page
// additionally, users of the crate can reach the re-exported data by doing:
// use crates::PrimaryColor;
// use crates::mix;
// instead of
// use art::kinds::PrimaryColor;
pub use self::kinds::PrimaryColor;
pub use self::kinds::SecondaryColor;
pub use self::utils::mix;

pub mod kinds {
    /// The primary colors according to the RYB color model.
    pub enum PrimaryColor {
        Red,
        Yellow,
        Blue,
    }

    /// The secondary colors according to the RYB color model.
    pub enum SecondaryColor {
        Orange,
        Green,
        Purple,
    }
}

pub mod utils {
    use crate::kinds::*;

    /// Combines two primary colors in equal amounts to create
    /// a secondary color.
    pub fn mix(c1: PrimaryColor, c2: PrimaryColor) -> SecondaryColor {
        // --snip--
        unimplemented!();
    }
}
