
# This file was @generated by crate2nix 0.10.0-alpha.1 with the command:
#   "generate" "-n" "../nix/nixpkgs.nix" "-f" "./crate2nix/Cargo.toml" "-o" "./crate2nix/Cargo.nix"
# See https://github.com/kolloch/crate2nix for more info.

{ nixpkgs ? ../nix/nixpkgs.nix
, pkgs ? import nixpkgs { config = {}; }
, lib ? pkgs.lib
, stdenv ? pkgs.stdenv
, buildRustCrateForPkgs ? if buildRustCrate != null
    then lib.warn "crate2nix: Passing `buildRustCrate` as argument to Cargo.nix is deprecated. If you don't customize `buildRustCrate`, replace `callPackage ./Cargo.nix {}` by `import ./Cargo.nix { inherit pkgs; }`, and if you need to customize `buildRustCrate`, use `buildRustCrateForPkgs` instead." (_: buildRustCrate)
    else pkgs: pkgs.buildRustCrate
  # Deprecated
, buildRustCrate ? null
  # This is used as the `crateOverrides` argument for `buildRustCrate`.
, defaultCrateOverrides ? pkgs.defaultCrateOverrides
  # The features to enable for the root_crate or the workspace_members.
, rootFeatures ? [ "default" ]
  # If true, throw errors instead of issueing deprecation warnings.
, strictDeprecation ? false
  # Used for conditional compilation based on CPU feature detection.
, targetFeatures ? []
  # Whether to perform release builds: longer compile times, faster binaries.
, release ? true
  # Additional crate2nix configuration if it exists.
, crateConfig
  ? if builtins.pathExists ./crate-config.nix
    then pkgs.callPackage ./crate-config.nix {}
    else {}
}:

rec {
  #
  # "public" attributes that we attempt to keep stable with new versions of crate2nix.
  #

  rootCrate = rec {
    packageId = "crate2nix";

    # Use this attribute to refer to the derivation building your root crate package.
    # You can override the features with rootCrate.build.override { features = [ "default" "feature1" ... ]; }.
    build = internal.buildRustCrateWithFeatures {
      inherit packageId;
    };

    # Debug support which might change between releases.
    # File a bug if you depend on any for non-debug work!
    debug = internal.debugCrate { inherit packageId; };
  };
  # Refer your crate build derivation by name here.
  # You can override the features with
  # workspaceMembers."${crateName}".build.override { features = [ "default" "feature1" ... ]; }.
  workspaceMembers = {
    "crate2nix" = rec {
      packageId = "crate2nix";
      build = internal.buildRustCrateWithFeatures {
        packageId = "crate2nix";
      };

      # Debug support which might change between releases.
      # File a bug if you depend on any for non-debug work!
      debug = internal.debugCrate { inherit packageId; };
    };
  };

  # A derivation that joins the outputs of all workspace members together.
  allWorkspaceMembers = pkgs.symlinkJoin {
      name = "all-workspace-members";
      paths =
        let members = builtins.attrValues workspaceMembers;
        in builtins.map (m: m.build) members;
  };

  #
  # "internal" ("private") attributes that may change in every new version of crate2nix.
  #

  internal = rec {
    # Build and dependency information for crates.
    # Many of the fields are passed one-to-one to buildRustCrate.
    #
    # Noteworthy:
    # * `dependencies`/`buildDependencies`: similar to the corresponding fields for buildRustCrate.
    #   but with additional information which is used during dependency/feature resolution.
    # * `resolvedDependencies`: the selected default features reported by cargo - only included for debugging.
    # * `devDependencies` as of now not used by `buildRustCrate` but used to
    #   inject test dependencies into the build

    crates = {
      "aho-corasick" = rec {
        crateName = "aho-corasick";
        version = "0.7.18";
        edition = "2018";
        sha256 = "0vv50b3nvkhyy7x7ip19qnsq11bqlnffkmj2yx2xlyk5wzawydqy";
        libName = "aho_corasick";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "memchr";
            packageId = "memchr";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "memchr/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "ansi_term" = rec {
        crateName = "ansi_term";
        version = "0.11.0";
        edition = "2015";
        sha256 = "16wpvrghvd0353584i1idnsgm0r3vchg8fyrm0x8ayv1rgvbljgf";
        authors = [
          "ogham@bsago.me"
          "Ryan Scheel (Havvy) <ryan.havvy@gmail.com>"
          "Josh Triplett <josh@joshtriplett.org>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."os" == "windows");
            features = [ "errhandlingapi" "consoleapi" "processenv" ];
          }
        ];

      };
      "anyhow" = rec {
        crateName = "anyhow";
        version = "1.0.41";
        edition = "2018";
        sha256 = "0qaa0vgsa7ybq7wqk57508l52l1lr3sbx49vk9hf43w9yql2dbqm";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "atty" = rec {
        crateName = "atty";
        version = "0.2.14";
        edition = "2015";
        sha256 = "1s7yslcs6a28c5vz7jwj63lkfgyx8mx99fdirlhi9lbhhzhrpcyr";
        authors = [
          "softprops <d.tangren@gmail.com>"
        ];
        dependencies = [
          {
            name = "hermit-abi";
            packageId = "hermit-abi";
            target = { target, features }: (target."os" == "hermit");
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "consoleapi" "processenv" "minwinbase" "minwindef" "winbase" ];
          }
        ];

      };
      "bitflags" = rec {
        crateName = "bitflags";
        version = "1.2.1";
        edition = "2015";
        sha256 = "14qnd5nq8p2almk79m4m8ydqhd413yaxsyjp5xd19g3mikzf47fg";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "block-buffer" = rec {
        crateName = "block-buffer";
        version = "0.7.3";
        edition = "2015";
        sha256 = "12v8wizynqin0hqf140kmp9s38q223mp1b0hkqk8j5pk8720v560";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "block-padding";
            packageId = "block-padding";
          }
          {
            name = "byte-tools";
            packageId = "byte-tools";
          }
          {
            name = "byteorder";
            packageId = "byteorder";
            usesDefaultFeatures = false;
          }
          {
            name = "generic-array";
            packageId = "generic-array";
          }
        ];

      };
      "block-padding" = rec {
        crateName = "block-padding";
        version = "0.1.5";
        edition = "2015";
        sha256 = "1xbkmysiz23vimd17rnsjpw9bgjxipwfslwyygqlkx4in3dxwygs";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "byte-tools";
            packageId = "byte-tools";
          }
        ];

      };
      "bstr" = rec {
        crateName = "bstr";
        version = "0.2.16";
        edition = "2018";
        sha256 = "0y8jy9kcqn1myzxjx7c73rbv4amfw08n936ycqz3glrsc66jqs4h";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "memchr";
            packageId = "memchr";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" "unicode" ];
          "serde1" = [ "std" "serde1-nostd" "serde/std" ];
          "serde1-nostd" = [ "serde" ];
          "std" = [ "memchr/std" ];
          "unicode" = [ "lazy_static" "regex-automata" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "byte-tools" = rec {
        crateName = "byte-tools";
        version = "0.3.1";
        edition = "2015";
        sha256 = "1mqi29wsm8njpl51pfwr31wmpzs5ahlcb40wsjyd92l90ixcmdg3";
        authors = [
          "RustCrypto Developers"
        ];

      };
      "byteorder" = rec {
        crateName = "byteorder";
        version = "1.4.3";
        edition = "2018";
        sha256 = "0456lv9xi1a5bcm32arknf33ikv76p3fr9yzki4lb2897p2qkh8l";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
      };
      "cargo_metadata" = rec {
        crateName = "cargo_metadata";
        version = "0.9.1";
        edition = "2015";
        sha256 = "00pjms89lghvizh4d55lz80hvrih9r55xv9m5wd9vcsgc163gqs6";
        authors = [
          "Oliver Schneider <git-spam-no-reply9815368754983@oli-obk.de>"
        ];
        dependencies = [
          {
            name = "semver";
            packageId = "semver";
            features = [ "serde" ];
          }
          {
            name = "serde";
            packageId = "serde";
          }
          {
            name = "serde_derive";
            packageId = "serde_derive";
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "cfg-if" = rec {
        crateName = "cfg-if";
        version = "1.0.0";
        edition = "2018";
        sha256 = "1za0vb97n4brpzpv8lsbnzmq5r8f2b0cpqqr0sy8h5bn751xxwds";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "clap" = rec {
        crateName = "clap";
        version = "2.33.3";
        edition = "2015";
        sha256 = "00i065a58987k1sbzqmlz721rw521zcg08jmsh40gi3khp3qmr9p";
        authors = [
          "Kevin K. <kbknapp@gmail.com>"
        ];
        dependencies = [
          {
            name = "ansi_term";
            packageId = "ansi_term";
            optional = true;
            target = { target, features }: (!(target."windows" or false));
          }
          {
            name = "atty";
            packageId = "atty";
            optional = true;
          }
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "strsim";
            packageId = "strsim";
            optional = true;
          }
          {
            name = "textwrap";
            packageId = "textwrap";
          }
          {
            name = "unicode-width";
            packageId = "unicode-width";
          }
          {
            name = "vec_map";
            packageId = "vec_map";
            optional = true;
          }
        ];
        features = {
          "color" = [ "ansi_term" "atty" ];
          "default" = [ "suggestions" "color" "vec_map" ];
          "doc" = [ "yaml" ];
          "lints" = [ "clippy" ];
          "suggestions" = [ "strsim" ];
          "wrap_help" = [ "term_size" "textwrap/term_size" ];
          "yaml" = [ "yaml-rust" ];
        };
        resolvedDefaultFeatures = [ "ansi_term" "atty" "color" "default" "strsim" "suggestions" "vec_map" ];
      };
      "colored-diff" = rec {
        crateName = "colored-diff";
        version = "0.2.2";
        edition = "2015";
        sha256 = "1zbfjkp7w1wjcxb1p19dd21mn9xkj6nr2s5pav8b16whzh52cvsi";
        authors = [
          "Christopher Durham <cad97@cad97.com>"
        ];
        dependencies = [
          {
            name = "ansi_term";
            packageId = "ansi_term";
          }
          {
            name = "difference";
            packageId = "difference";
          }
          {
            name = "itertools";
            packageId = "itertools 0.7.11";
            usesDefaultFeatures = false;
          }
        ];

      };
      "crate2nix" = rec {
        crateName = "crate2nix";
        version = "0.10.0-alpha.1";
        edition = "2018";
        crateBin = [
          { name = "crate2nix"; path = "src/main.rs"; }
        ];
        src = lib.cleanSourceWith { filter = sourceFilter;  src = ./.; };
        authors = [
          "Peter Kolloch <info@eigenvalue.net>"
        ];
        dependencies = [
          {
            name = "anyhow";
            packageId = "anyhow";
          }
          {
            name = "cargo_metadata";
            packageId = "cargo_metadata";
          }
          {
            name = "hex";
            packageId = "hex";
          }
          {
            name = "itertools";
            packageId = "itertools 0.9.0";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "nix-base32";
            packageId = "nix-base32";
          }
          {
            name = "pathdiff";
            packageId = "pathdiff";
          }
          {
            name = "semver";
            packageId = "semver";
          }
          {
            name = "serde";
            packageId = "serde";
            features = [ "derive" ];
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
          {
            name = "structopt";
            packageId = "structopt";
          }
          {
            name = "tera";
            packageId = "tera";
            usesDefaultFeatures = false;
          }
          {
            name = "toml";
            packageId = "toml";
          }
          {
            name = "url";
            packageId = "url";
          }
          {
            name = "url_serde";
            packageId = "url_serde";
          }
        ];
        devDependencies = [
          {
            name = "colored-diff";
            packageId = "colored-diff";
          }
          {
            name = "fs_extra";
            packageId = "fs_extra";
          }
          {
            name = "tempdir";
            packageId = "tempdir";
          }
        ];

      };
      "crossbeam-utils" = rec {
        crateName = "crossbeam-utils";
        version = "0.8.5";
        edition = "2018";
        sha256 = "1ny481cx8a5pdknypb41jqym03dl8x26i2ldyyp3yb3zrq8zqb6q";
        authors = [
          "The Crossbeam Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
            optional = true;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "lazy_static" ];
        };
        resolvedDefaultFeatures = [ "default" "lazy_static" "std" ];
      };
      "difference" = rec {
        crateName = "difference";
        version = "2.0.0";
        edition = "2015";
        crateBin = [];
        sha256 = "1621wx4k8h452p6xzmzzvm7mz87kxh4yqz0kzxfjj9xmjxlbyk2j";
        authors = [
          "Johann Hofmann <mail@johann-hofmann.com>"
        ];
        features = {
          "bin" = [ "getopts" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "digest" = rec {
        crateName = "digest";
        version = "0.8.1";
        edition = "2015";
        sha256 = "1madjl27f3kj5ql7kwgvb9c8b7yb7bv7yfgx7rqzj4i3fp4cil7k";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
        ];
        features = {
          "dev" = [ "blobby" ];
        };
      };
      "either" = rec {
        crateName = "either";
        version = "1.6.1";
        edition = "2015";
        sha256 = "0mwl9vngqf5jvrhmhn9x60kr5hivxyjxbmby2pybncxfqhf4z3g7";
        authors = [
          "bluss"
        ];
        features = {
          "default" = [ "use_std" ];
        };
      };
      "fake-simd" = rec {
        crateName = "fake-simd";
        version = "0.1.2";
        edition = "2015";
        sha256 = "1vfylvk4va2ivqx85603lyqqp0zk52cgbs4n5nfbbbqx577qm2p8";
        authors = [
          "The Rust-Crypto Project Developers"
        ];

      };
      "fnv" = rec {
        crateName = "fnv";
        version = "1.0.7";
        edition = "2015";
        sha256 = "1hc2mcqha06aibcaza94vbi81j6pr9a1bbxrxjfhc91zin8yr7iz";
        libPath = "lib.rs";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "fs_extra" = rec {
        crateName = "fs_extra";
        version = "1.2.0";
        edition = "2015";
        sha256 = "151k6dr35mhq5d8pc8krhw55ajhkyiv0pm14s7zzlc5bc9fp28i0";
        authors = [
          "Denis Kurilenko <webdesus@gmail.com>"
        ];

      };
      "fuchsia-cprng" = rec {
        crateName = "fuchsia-cprng";
        version = "0.1.1";
        edition = "2018";
        sha256 = "1fnkqrbz7ixxzsb04bsz9p0zzazanma8znfdqjvh39n14vapfvx0";
        authors = [
          "Erick Tryzelaar <etryzelaar@google.com>"
        ];

      };
      "generic-array" = rec {
        crateName = "generic-array";
        version = "0.12.4";
        edition = "2015";
        sha256 = "1gfpay78vijl9vrwl1k9v7fbvbhkhcmnrk4kfg9l6x24y4s9zpzz";
        libName = "generic_array";
        authors = [
          "Bartłomiej Kamiński <fizyk20@gmail.com>"
          "Aaron Trent <novacrazy@gmail.com>"
        ];
        dependencies = [
          {
            name = "typenum";
            packageId = "typenum";
          }
        ];

      };
      "globset" = rec {
        crateName = "globset";
        version = "0.4.6";
        edition = "2015";
        sha256 = "0jhy0qs5k43g8zyx1fys44kcdzjmcrwjyv9n703kj8g4y6g1cln1";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "aho-corasick";
            packageId = "aho-corasick";
          }
          {
            name = "bstr";
            packageId = "bstr";
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
          {
            name = "fnv";
            packageId = "fnv";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "regex";
            packageId = "regex";
            usesDefaultFeatures = false;
            features = [ "perf" "std" ];
          }
        ];
        features = {
          "serde1" = [ "serde" ];
        };
      };
      "globwalk" = rec {
        crateName = "globwalk";
        version = "0.8.1";
        edition = "2015";
        sha256 = "1k6xwkydr7igvwjn3xkwjywk4213lcs53f576ilqz1h84jaazqwk";
        authors = [
          "Gilad Naaman <gilad@naaman.io>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "ignore";
            packageId = "ignore";
          }
          {
            name = "walkdir";
            packageId = "walkdir";
          }
        ];

      };
      "heck" = rec {
        crateName = "heck";
        version = "0.3.3";
        edition = "2018";
        sha256 = "0b0kkr790p66lvzn9nsmfjvydrbmh9z5gb664jchwgw64vxiwqkd";
        authors = [
          "Without Boats <woboats@gmail.com>"
        ];
        dependencies = [
          {
            name = "unicode-segmentation";
            packageId = "unicode-segmentation";
          }
        ];

      };
      "hermit-abi" = rec {
        crateName = "hermit-abi";
        version = "0.1.18";
        edition = "2018";
        sha256 = "0p6czgbk1izviwxzm6ypy3vz2wqj1yd3ab03wp82xqjng7klsbrj";
        authors = [
          "Stefan Lankes"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins/rustc-dep-of-std" "libc/rustc-dep-of-std" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "hex" = rec {
        crateName = "hex";
        version = "0.4.3";
        edition = "2018";
        sha256 = "0w1a4davm1lgzpamwnba907aysmlrnygbqmfis2mqjx5m552a93z";
        authors = [
          "KokaKiwi <kokakiwi@kokakiwi.net>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "std" ];
      };
      "idna" = rec {
        crateName = "idna";
        version = "0.1.5";
        edition = "2015";
        sha256 = "0kl4gs5kaydn4v07c6ka33spm9qdh2np0x7iw7g5zd8z1c7rxw1q";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "unicode-bidi";
            packageId = "unicode-bidi";
          }
          {
            name = "unicode-normalization";
            packageId = "unicode-normalization";
          }
        ];

      };
      "ignore" = rec {
        crateName = "ignore";
        version = "0.4.17";
        edition = "2015";
        sha256 = "1347mxd0cwiidcl0qvixl7za524x5ds0izv8vjh2df0bqr2zp1xj";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "crossbeam-utils";
            packageId = "crossbeam-utils";
          }
          {
            name = "globset";
            packageId = "globset";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "memchr";
            packageId = "memchr";
          }
          {
            name = "regex";
            packageId = "regex";
          }
          {
            name = "same-file";
            packageId = "same-file";
          }
          {
            name = "thread_local";
            packageId = "thread_local";
          }
          {
            name = "walkdir";
            packageId = "walkdir";
          }
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: (target."windows" or false);
          }
        ];
        features = {
          "simd-accel" = [ "globset/simd-accel" ];
        };
      };
      "itertools 0.7.11" = rec {
        crateName = "itertools";
        version = "0.7.11";
        edition = "2015";
        sha256 = "03cpsj26xmyamcalclqzr1i700vwx8hnbgxbpjvs354f8mnr8iqd";
        authors = [
          "bluss"
        ];
        dependencies = [
          {
            name = "either";
            packageId = "either";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "use_std" ];
        };
      };
      "itertools 0.9.0" = rec {
        crateName = "itertools";
        version = "0.9.0";
        edition = "2018";
        sha256 = "0jyml7ygr7kijkcjdl3fk5f34y5h5jsavclim7l13zjiavw1hkr8";
        authors = [
          "bluss"
        ];
        dependencies = [
          {
            name = "either";
            packageId = "either";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "use_std" ];
        };
        resolvedDefaultFeatures = [ "default" "use_std" ];
      };
      "itoa" = rec {
        crateName = "itoa";
        version = "0.4.7";
        edition = "2015";
        sha256 = "0di7fggbknwfjcw8cgzm1dnm3ik32l2m1f7nmyh8ipmh45h069fx";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
      };
      "lazy_static" = rec {
        crateName = "lazy_static";
        version = "1.4.0";
        edition = "2015";
        sha256 = "0in6ikhw8mgl33wjv6q6xfrb5b9jr16q8ygjy803fay4zcisvaz2";
        authors = [
          "Marvin Löbel <loebel.marvin@gmail.com>"
        ];
        features = {
          "spin_no_std" = [ "spin" ];
        };
      };
      "libc" = rec {
        crateName = "libc";
        version = "0.2.97";
        edition = "2015";
        sha256 = "1dlgdziv6nkabx287jjmghnlgc5dqv6fgpvh9n7ibpr0synsvf0j";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "align" "rustc-std-workspace-core" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "log" = rec {
        crateName = "log";
        version = "0.4.14";
        edition = "2015";
        sha256 = "04175hv0v62shd82qydq58a48k3bjijmk54v38zgqlbxqkkbpfai";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
        ];
        features = {
          "kv_unstable" = [ "value-bag" ];
          "kv_unstable_serde" = [ "kv_unstable_std" "value-bag/serde" "serde" ];
          "kv_unstable_std" = [ "std" "kv_unstable" "value-bag/error" ];
          "kv_unstable_sval" = [ "kv_unstable" "value-bag/sval" "sval" ];
        };
      };
      "maplit" = rec {
        crateName = "maplit";
        version = "1.0.2";
        edition = "2015";
        sha256 = "07b5kjnhrrmfhgqm9wprjw8adx6i225lqp49gasgqg74lahnabiy";
        authors = [
          "bluss"
        ];

      };
      "matches" = rec {
        crateName = "matches";
        version = "0.1.8";
        edition = "2015";
        sha256 = "020axl4q7rk9vz90phs7f8jas4imxal9y9kxl4z4v7a6719mrz3z";
        libPath = "lib.rs";
        authors = [
          "Simon Sapin <simon.sapin@exyr.org>"
        ];

      };
      "memchr" = rec {
        crateName = "memchr";
        version = "2.4.0";
        edition = "2018";
        sha256 = "1p478fqf4nia2ma0kv4npb8x1hli0zz6k16517ikb51jkryx8sxi";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
          "bluss"
        ];
        features = {
          "default" = [ "std" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "nix-base32" = rec {
        crateName = "nix-base32";
        version = "0.1.1";
        edition = "2018";
        sha256 = "04jnq6arig0amz0scadavbzn9bg9k4zphmrm1562n6ygfj1dnj45";
        authors = [
          "Peter Kolloch <info@eigenvalue.net>"
        ];

      };
      "once_cell" = rec {
        crateName = "once_cell";
        version = "1.7.2";
        edition = "2018";
        sha256 = "18qmpyfigg4ibdhjy5mwcjhzk9adwlgfaqv7nj430ivm86q0i2xg";
        authors = [
          "Aleksey Kladov <aleksey.kladov@gmail.com>"
        ];
        features = {
          "alloc" = [ "race" ];
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "race" "std" ];
      };
      "opaque-debug" = rec {
        crateName = "opaque-debug";
        version = "0.2.3";
        edition = "2015";
        sha256 = "172j6bs8ndclqxa2m64qc0y1772rr73g4l9fg2svscgicnbfff98";
        authors = [
          "RustCrypto Developers"
        ];

      };
      "pathdiff" = rec {
        crateName = "pathdiff";
        version = "0.1.0";
        edition = "2015";
        sha256 = "0cfg3isnx6mf3wbi7rsg4nmvywby40sbcs589n20fgi09l4p1gx3";
        authors = [
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];

      };
      "percent-encoding" = rec {
        crateName = "percent-encoding";
        version = "1.0.1";
        edition = "2015";
        sha256 = "0cgq08v1fvr6bs5fvy390cz830lq4fak8havdasdacxcw790s09i";
        libPath = "lib.rs";
        authors = [
          "The rust-url developers"
        ];

      };
      "pest" = rec {
        crateName = "pest";
        version = "2.1.3";
        edition = "2015";
        sha256 = "0lry80bm90x47nq71wxq83kjrm9ashpz4kbm92p90ysdx4m8gx0h";
        authors = [
          "Dragoș Tiselice <dragostiselice@gmail.com>"
        ];
        dependencies = [
          {
            name = "ucd-trie";
            packageId = "ucd-trie";
          }
        ];
        features = {
          "pretty-print" = [ "serde" "serde_json" ];
        };
      };
      "pest_derive" = rec {
        crateName = "pest_derive";
        version = "2.1.0";
        edition = "2015";
        sha256 = "1l5jfa6ril71cw5nsiw0r45br54dd8cj2r1nc2d1wq6wb3jilgc3";
        procMacro = true;
        authors = [
          "Dragoș Tiselice <dragostiselice@gmail.com>"
        ];
        dependencies = [
          {
            name = "pest";
            packageId = "pest";
          }
          {
            name = "pest_generator";
            packageId = "pest_generator";
          }
        ];

      };
      "pest_generator" = rec {
        crateName = "pest_generator";
        version = "2.1.3";
        edition = "2015";
        sha256 = "0mfgl0p6v91ywdqr9i8w053v70cnfqjk8y5rhwbvir9idridpf4r";
        authors = [
          "Dragoș Tiselice <dragostiselice@gmail.com>"
        ];
        dependencies = [
          {
            name = "pest";
            packageId = "pest";
          }
          {
            name = "pest_meta";
            packageId = "pest_meta";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
        ];

      };
      "pest_meta" = rec {
        crateName = "pest_meta";
        version = "2.1.3";
        edition = "2015";
        sha256 = "07d1jbbbpxpchk0j37ljas46sdyyg599z3zw2ac0f5sk9x06xgjl";
        authors = [
          "Dragoș Tiselice <dragostiselice@gmail.com>"
        ];
        dependencies = [
          {
            name = "maplit";
            packageId = "maplit";
          }
          {
            name = "pest";
            packageId = "pest";
          }
        ];
        buildDependencies = [
          {
            name = "sha-1";
            packageId = "sha-1";
            usesDefaultFeatures = false;
          }
        ];

      };
      "proc-macro-error" = rec {
        crateName = "proc-macro-error";
        version = "1.0.4";
        edition = "2018";
        sha256 = "1373bhxaf0pagd8zkyd03kkx6bchzf6g0dkwrwzsnal9z47lj9fs";
        authors = [
          "CreepySkeleton <creepy-skeleton@yandex.ru>"
        ];
        dependencies = [
          {
            name = "proc-macro-error-attr";
            packageId = "proc-macro-error-attr";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check";
          }
        ];
        features = {
          "default" = [ "syn-error" ];
          "syn-error" = [ "syn" ];
        };
        resolvedDefaultFeatures = [ "default" "syn" "syn-error" ];
      };
      "proc-macro-error-attr" = rec {
        crateName = "proc-macro-error-attr";
        version = "1.0.4";
        edition = "2018";
        sha256 = "0sgq6m5jfmasmwwy8x4mjygx5l7kp8s4j60bv25ckv2j1qc41gm1";
        procMacro = true;
        authors = [
          "CreepySkeleton <creepy-skeleton@yandex.ru>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check";
          }
        ];

      };
      "proc-macro2" = rec {
        crateName = "proc-macro2";
        version = "1.0.27";
        edition = "2018";
        sha256 = "0f3h0zl5w5090ajmmvpmhkpr4iwqnn5rip3afacabhc657vwmn7h";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "unicode-xid";
            packageId = "unicode-xid";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "quote" = rec {
        crateName = "quote";
        version = "1.0.9";
        edition = "2018";
        sha256 = "19rjmfqzk26rxbgxy5j2ckqc2v12sw2xw8l4gi8bzpn2bmsbkl63";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "rand" = rec {
        crateName = "rand";
        version = "0.4.6";
        edition = "2015";
        sha256 = "14qjfv3gggzhnma20k0sc1jf8y6pplsaq7n1j9ls5c8kf2wl0a2m";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "fuchsia-cprng";
            packageId = "fuchsia-cprng";
            target = { target, features }: (target."os" == "fuchsia");
          }
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
            target = { target, features }: (target."env" == "sgx");
          }
          {
            name = "rdrand";
            packageId = "rdrand";
            target = { target, features }: (target."env" == "sgx");
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "minwindef" "ntsecapi" "profileapi" "winnt" ];
          }
        ];
        features = {
          "default" = [ "std" ];
          "nightly" = [ "i128_support" ];
          "std" = [ "libc" ];
        };
        resolvedDefaultFeatures = [ "default" "libc" "std" ];
      };
      "rand_core 0.3.1" = rec {
        crateName = "rand_core";
        version = "0.3.1";
        edition = "2015";
        sha256 = "0jzdgszfa4bliigiy4hi66k7fs3gfwi2qxn8vik84ph77fwdwvvs";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.4.2";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" ];
          "serde1" = [ "rand_core/serde1" ];
          "std" = [ "rand_core/std" ];
        };
      };
      "rand_core 0.4.2" = rec {
        crateName = "rand_core";
        version = "0.4.2";
        edition = "2015";
        sha256 = "1p09ynysrq1vcdlmcqnapq4qakl2yd1ng3kxh3qscpx09k2a6cww";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        features = {
          "serde1" = [ "serde" "serde_derive" ];
          "std" = [ "alloc" ];
        };
      };
      "rdrand" = rec {
        crateName = "rdrand";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1cjq0kwx1bk7jx3kzyciiish5gqsj7620dm43dc52sr8fzmm9037";
        authors = [
          "Simonas Kazlauskas <rdrand@kazlauskas.me>"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "regex" = rec {
        crateName = "regex";
        version = "1.5.4";
        edition = "2018";
        sha256 = "0qf479kjbmb582h4d1d6gfl75h0j8aq2nrdi5wg6zdcy6llqcynh";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "aho-corasick";
            packageId = "aho-corasick";
            optional = true;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "regex-syntax";
            packageId = "regex-syntax";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" "perf" "unicode" "regex-syntax/default" ];
          "perf" = [ "perf-cache" "perf-dfa" "perf-inline" "perf-literal" ];
          "perf-literal" = [ "aho-corasick" "memchr" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" "regex-syntax/unicode" ];
          "unicode-age" = [ "regex-syntax/unicode-age" ];
          "unicode-bool" = [ "regex-syntax/unicode-bool" ];
          "unicode-case" = [ "regex-syntax/unicode-case" ];
          "unicode-gencat" = [ "regex-syntax/unicode-gencat" ];
          "unicode-perl" = [ "regex-syntax/unicode-perl" ];
          "unicode-script" = [ "regex-syntax/unicode-script" ];
          "unicode-segment" = [ "regex-syntax/unicode-segment" ];
          "unstable" = [ "pattern" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "aho-corasick" "default" "memchr" "perf" "perf-cache" "perf-dfa" "perf-inline" "perf-literal" "std" "unicode" "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
      };
      "regex-syntax" = rec {
        crateName = "regex-syntax";
        version = "0.6.25";
        edition = "2018";
        sha256 = "16y87hz1bxmmz6kk360cxwfm3jnbsxb3x4zw9x1gzz7khic2i5zl";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "unicode" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
        };
        resolvedDefaultFeatures = [ "default" "unicode" "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
      };
      "remove_dir_all" = rec {
        crateName = "remove_dir_all";
        version = "0.5.3";
        edition = "2015";
        sha256 = "1rzqbsgkmr053bxxl04vmvsd1njyz0nxvly97aip6aa2cmb15k9s";
        authors = [
          "Aaronepower <theaaronepower@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "std" "errhandlingapi" "winerror" "fileapi" "winbase" ];
          }
        ];

      };
      "ryu" = rec {
        crateName = "ryu";
        version = "1.0.5";
        edition = "2018";
        sha256 = "0vpqv1dj7fksa6hm3zpk5rbsjs0ifbfy7xwzsyyil0rx37a03lvi";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
        };
      };
      "same-file" = rec {
        crateName = "same-file";
        version = "1.0.6";
        edition = "2018";
        sha256 = "00h5j1w87dmhnvbv9l8bic3y7xxsnjmssvifw2ayvgx9mb1ivz4k";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: (target."windows" or false);
          }
        ];

      };
      "semver" = rec {
        crateName = "semver";
        version = "0.9.0";
        edition = "2015";
        sha256 = "00q4lkcj0rrgbhviv9sd4p6qmdsipkwkbra7rh11jrhq5kpvjzhx";
        authors = [
          "Steve Klabnik <steve@steveklabnik.com>"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "semver-parser";
            packageId = "semver-parser";
          }
          {
            name = "serde";
            packageId = "serde";
            optional = true;
          }
        ];
        features = {
          "ci" = [ "serde" ];
        };
        resolvedDefaultFeatures = [ "default" "serde" ];
      };
      "semver-parser" = rec {
        crateName = "semver-parser";
        version = "0.7.0";
        edition = "2015";
        sha256 = "18vhypw6zgccnrlm5ps1pwa0khz7ry927iznpr88b87cagr1v2iq";
        authors = [
          "Steve Klabnik <steve@steveklabnik.com>"
        ];

      };
      "serde" = rec {
        crateName = "serde";
        version = "1.0.126";
        edition = "2015";
        sha256 = "00vdk7y3j8h2xv28a2i2ad1d19g5iwrdknbq8yp79v6axamhaxgc";
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "serde_derive";
            packageId = "serde_derive";
            optional = true;
          }
        ];
        devDependencies = [
          {
            name = "serde_derive";
            packageId = "serde_derive";
          }
        ];
        features = {
          "default" = [ "std" ];
          "derive" = [ "serde_derive" ];
        };
        resolvedDefaultFeatures = [ "default" "derive" "serde_derive" "std" ];
      };
      "serde_derive" = rec {
        crateName = "serde_derive";
        version = "1.0.126";
        edition = "2015";
        sha256 = "0hsdh39qj0g187nwndfzg67q4qajbm5g6x0fr5xarblmk2y7sfln";
        procMacro = true;
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "serde_json" = rec {
        crateName = "serde_json";
        version = "1.0.64";
        edition = "2018";
        sha256 = "0y9gk3yikncrc0zajmwc0pidr7zfwafawb4gidf6mqyskzf9g7kr";
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "itoa";
            packageId = "itoa";
            usesDefaultFeatures = false;
          }
          {
            name = "ryu";
            packageId = "ryu";
          }
          {
            name = "serde";
            packageId = "serde";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "serde/alloc" ];
          "default" = [ "std" ];
          "preserve_order" = [ "indexmap" ];
          "std" = [ "serde/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "sha-1" = rec {
        crateName = "sha-1";
        version = "0.8.2";
        edition = "2015";
        sha256 = "1pv387q0r7llk2cqzyq0nivzvkgqgzsiygqzlv7b68z9xl5lvngp";
        libName = "sha1";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "block-buffer";
            packageId = "block-buffer";
          }
          {
            name = "digest";
            packageId = "digest";
          }
          {
            name = "fake-simd";
            packageId = "fake-simd";
          }
          {
            name = "opaque-debug";
            packageId = "opaque-debug";
          }
        ];
        devDependencies = [
          {
            name = "digest";
            packageId = "digest";
            features = [ "dev" ];
          }
        ];
        features = {
          "asm" = [ "sha1-asm" ];
          "asm-aarch64" = [ "asm" "libc" ];
          "default" = [ "std" ];
          "std" = [ "digest/std" ];
        };
      };
      "strsim" = rec {
        crateName = "strsim";
        version = "0.8.0";
        edition = "2015";
        sha256 = "0sjsm7hrvjdifz661pjxq5w4hf190hx53fra8dfvamacvff139cf";
        authors = [
          "Danny Guo <dannyguo91@gmail.com>"
        ];

      };
      "structopt" = rec {
        crateName = "structopt";
        version = "0.3.21";
        edition = "2018";
        sha256 = "136j0lvjmpv5syi751vxg8vb30gfyv4k81x8d18kxrj6xvbsqxsj";
        authors = [
          "Guillaume Pinot <texitoi@texitoi.eu>"
          "others"
        ];
        dependencies = [
          {
            name = "clap";
            packageId = "clap";
            usesDefaultFeatures = false;
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "structopt-derive";
            packageId = "structopt-derive";
          }
        ];
        features = {
          "color" = [ "clap/color" ];
          "debug" = [ "clap/debug" ];
          "default" = [ "clap/default" ];
          "doc" = [ "clap/doc" ];
          "lints" = [ "clap/lints" ];
          "no_cargo" = [ "clap/no_cargo" ];
          "paw" = [ "structopt-derive/paw" "paw_dep" ];
          "suggestions" = [ "clap/suggestions" ];
          "wrap_help" = [ "clap/wrap_help" ];
          "yaml" = [ "clap/yaml" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "structopt-derive" = rec {
        crateName = "structopt-derive";
        version = "0.4.14";
        edition = "2018";
        sha256 = "143gjwvz3s86hwp070km83y25n8kqp5f01kb1dr19f4ilkywvaav";
        procMacro = true;
        authors = [
          "Guillaume Pinot <texitoi@texitoi.eu>"
        ];
        dependencies = [
          {
            name = "heck";
            packageId = "heck";
          }
          {
            name = "proc-macro-error";
            packageId = "proc-macro-error";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" ];
          }
        ];
        features = {
        };
      };
      "syn" = rec {
        crateName = "syn";
        version = "1.0.73";
        edition = "2018";
        sha256 = "1ixw4lscc7009ibaic8g5bvnc94hdcr62ksjk3jjl38363zqj57p";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid";
          }
        ];
        features = {
          "default" = [ "derive" "parsing" "printing" "clone-impls" "proc-macro" ];
          "printing" = [ "quote" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "quote/proc-macro" ];
          "test" = [ "syn-test-suite/all-features" ];
        };
        resolvedDefaultFeatures = [ "clone-impls" "default" "derive" "full" "parsing" "printing" "proc-macro" "quote" ];
      };
      "tempdir" = rec {
        crateName = "tempdir";
        version = "0.3.7";
        edition = "2015";
        sha256 = "1n5n86zxpgd85y0mswrp5cfdisizq2rv3la906g6ipyc03xvbwhm";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "rand";
            packageId = "rand";
          }
          {
            name = "remove_dir_all";
            packageId = "remove_dir_all";
          }
        ];

      };
      "tera" = rec {
        crateName = "tera";
        version = "1.10.0";
        edition = "2018";
        sha256 = "0qpsgbpmcsaw6xnd8nhpqwpkvj7mhsy9dsw26xwwi014i35hl1l1";
        authors = [
          "Vincent Prouillet <hello@prouilletvincent.com>"
        ];
        dependencies = [
          {
            name = "globwalk";
            packageId = "globwalk";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "pest";
            packageId = "pest";
          }
          {
            name = "pest_derive";
            packageId = "pest_derive";
          }
          {
            name = "regex";
            packageId = "regex";
          }
          {
            name = "serde";
            packageId = "serde";
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
        ];
        features = {
          "builtins" = [ "slug" "percent-encoding" "humansize" "chrono" "chrono-tz" "unic-segment" "rand" ];
          "default" = [ "builtins" ];
          "preserve_order" = [ "serde_json/preserve_order" ];
        };
      };
      "textwrap" = rec {
        crateName = "textwrap";
        version = "0.11.0";
        edition = "2015";
        sha256 = "0q5hky03ik3y50s9sz25r438bc4nwhqc6dqwynv4wylc807n29nk";
        authors = [
          "Martin Geisler <martin@geisler.net>"
        ];
        dependencies = [
          {
            name = "unicode-width";
            packageId = "unicode-width";
          }
        ];

      };
      "thread_local" = rec {
        crateName = "thread_local";
        version = "1.1.3";
        edition = "2018";
        sha256 = "1gccp3grndpi6dyhzylz4hkqnkzc1xyri98n0xwwhnn90i7d4640";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "once_cell";
            packageId = "once_cell";
          }
        ];

      };
      "tinyvec" = rec {
        crateName = "tinyvec";
        version = "1.2.0";
        edition = "2018";
        sha256 = "0hn3fkpb9nca9nf9znz2dxlp4ccv37hnbh67aczpzpmpbgq20ljv";
        authors = [
          "Lokathor <zefria@gmail.com>"
        ];
        dependencies = [
          {
            name = "tinyvec_macros";
            packageId = "tinyvec_macros";
            optional = true;
          }
        ];
        features = {
          "alloc" = [ "tinyvec_macros" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "tinyvec_macros" ];
      };
      "tinyvec_macros" = rec {
        crateName = "tinyvec_macros";
        version = "0.1.0";
        edition = "2018";
        sha256 = "0p5zvgbas5nh403fbxica819mf3g83n8g2hzpfazfr56w6klv9yd";
        authors = [
          "Soveu <marx.tomasz@gmail.com>"
        ];

      };
      "toml" = rec {
        crateName = "toml";
        version = "0.5.8";
        edition = "2018";
        sha256 = "1apcmjrrjw429pjw7mqlmdwwd67g8305vwqy4kw3swr612bl44d3";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "serde";
            packageId = "serde";
          }
        ];
        features = {
          "preserve_order" = [ "indexmap" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "typenum" = rec {
        crateName = "typenum";
        version = "1.13.0";
        edition = "2018";
        sha256 = "01lbbspn4080yg8wp6y7q3xcqih1c1dmkkx4pwax4z1a9436k7w7";
        build = "build/main.rs";
        authors = [
          "Paho Lurie-Gregg <paho@paholg.com>"
          "Andre Bogus <bogusandre@gmail.com>"
        ];
        features = {
        };
      };
      "ucd-trie" = rec {
        crateName = "ucd-trie";
        version = "0.1.3";
        edition = "2018";
        sha256 = "072cblf8v3wzyaz3lhbpzgil4s03dpzg1ppy3gqx2l4v622y3pjn";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "unicode-bidi" = rec {
        crateName = "unicode-bidi";
        version = "0.3.5";
        edition = "2018";
        sha256 = "1q07h5kp9jszwf0bkrpa1v5wmv04dv920x3w2xy6pjdikchbxf7f";
        libName = "unicode_bidi";
        authors = [
          "The Servo Project Developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
        ];
        features = {
          "flame_it" = [ "flame" "flamer" ];
          "with_serde" = [ "serde" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "unicode-normalization" = rec {
        crateName = "unicode-normalization";
        version = "0.1.19";
        edition = "2018";
        sha256 = "1yabhmg8zlcksda3ajly9hpbzqgbhknxwch8dwkfkaa1569r0ifm";
        authors = [
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        dependencies = [
          {
            name = "tinyvec";
            packageId = "tinyvec";
            features = [ "alloc" ];
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "unicode-segmentation" = rec {
        crateName = "unicode-segmentation";
        version = "1.7.1";
        edition = "2015";
        sha256 = "15n736z0pbj30pj44jb9s9rjavzrmx8v8pzdgsl5yfmfwrxjw3dv";
        authors = [
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
        };
      };
      "unicode-width" = rec {
        crateName = "unicode-width";
        version = "0.1.8";
        edition = "2015";
        sha256 = "1qxizyi6xbcqyi4z79p523ywvmgsfcgfqb3zv3c8i6x1jcc5jdwk";
        authors = [
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "std" "core" "compiler_builtins" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "unicode-xid" = rec {
        crateName = "unicode-xid";
        version = "0.2.2";
        edition = "2015";
        sha256 = "1wrkgcw557v311dkdb6n2hrix9dm2qdsb1zpw7pn79l03zb85jwc";
        authors = [
          "erick.tryzelaar <erick.tryzelaar@gmail.com>"
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "url" = rec {
        crateName = "url";
        version = "1.7.2";
        edition = "2015";
        sha256 = "0nim1c90mxpi9wgdw2xh8dqd72vlklwlzam436akcrhjac6pqknx";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "idna";
            packageId = "idna";
          }
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding";
          }
        ];
        features = {
          "heap_size" = [ "heapsize" ];
          "query_encoding" = [ "encoding" ];
        };
      };
      "url_serde" = rec {
        crateName = "url_serde";
        version = "0.2.0";
        edition = "2015";
        sha256 = "1snxgdzlcj5mpnbkpnzm533l6830qf9hrmmxshizhlpfy6cx1rvl";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "serde";
            packageId = "serde";
          }
          {
            name = "url";
            packageId = "url";
          }
        ];

      };
      "vec_map" = rec {
        crateName = "vec_map";
        version = "0.8.2";
        edition = "2015";
        sha256 = "1481w9g1dw9rxp3l6snkdqihzyrd2f8vispzqmwjwsdyhw8xzggi";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Jorge Aparicio <japaricious@gmail.com>"
          "Alexis Beingessner <a.beingessner@gmail.com>"
          "Brian Anderson <>"
          "tbu- <>"
          "Manish Goregaokar <>"
          "Aaron Turon <aturon@mozilla.com>"
          "Adolfo Ochagavía <>"
          "Niko Matsakis <>"
          "Steven Fackler <>"
          "Chase Southwood <csouth3@illinois.edu>"
          "Eduard Burtescu <>"
          "Florian Wilkens <>"
          "Félix Raimundo <>"
          "Tibor Benke <>"
          "Markus Siemens <markus@m-siemens.de>"
          "Josh Branchaud <jbranchaud@gmail.com>"
          "Huon Wilson <dbau.pp@gmail.com>"
          "Corey Farwell <coref@rwell.org>"
          "Aaron Liblong <>"
          "Nick Cameron <nrc@ncameron.org>"
          "Patrick Walton <pcwalton@mimiga.net>"
          "Felix S Klock II <>"
          "Andrew Paseltiner <apaseltiner@gmail.com>"
          "Sean McArthur <sean.monstar@gmail.com>"
          "Vadim Petrochenkov <>"
        ];
        features = {
          "eders" = [ "serde" ];
        };
      };
      "version_check" = rec {
        crateName = "version_check";
        version = "0.9.3";
        edition = "2015";
        sha256 = "1zmkcgj2m0pq0l4wnhrp1wl1lygf7x2h5p7pvjwc4719lnlxrv2z";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];

      };
      "walkdir" = rec {
        crateName = "walkdir";
        version = "2.3.2";
        edition = "2018";
        sha256 = "0mnszy33685v8y9js8mw6x2p3iddqs8vfj7n2dhqddnlbirz5340";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "same-file";
            packageId = "same-file";
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "std" "winnt" ];
          }
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: (target."windows" or false);
          }
        ];

      };
      "winapi" = rec {
        crateName = "winapi";
        version = "0.3.9";
        edition = "2015";
        sha256 = "06gl025x418lchw1wxj64ycr7gha83m44cjr5sarhynd9xkrm0sw";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-i686-pc-windows-gnu";
            packageId = "winapi-i686-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "i686-pc-windows-gnu");
          }
          {
            name = "winapi-x86_64-pc-windows-gnu";
            packageId = "winapi-x86_64-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "x86_64-pc-windows-gnu");
          }
        ];
        features = {
          "debug" = [ "impl-debug" ];
        };
        resolvedDefaultFeatures = [ "consoleapi" "errhandlingapi" "fileapi" "minwinbase" "minwindef" "ntsecapi" "processenv" "profileapi" "std" "winbase" "wincon" "winerror" "winnt" ];
      };
      "winapi-i686-pc-windows-gnu" = rec {
        crateName = "winapi-i686-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1dmpa6mvcvzz16zg6d5vrfy4bxgg541wxrcip7cnshi06v38ffxc";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "winapi-util" = rec {
        crateName = "winapi-util";
        version = "0.1.5";
        edition = "2018";
        sha256 = "0y71bp7f6d536czj40dhqk0d55wfbbwqfp2ymqf1an5ibgl6rv3h";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "std" "consoleapi" "errhandlingapi" "fileapi" "minwindef" "processenv" "winbase" "wincon" "winerror" "winnt" ];
          }
        ];

      };
      "winapi-x86_64-pc-windows-gnu" = rec {
        crateName = "winapi-x86_64-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "0gqq64czqb64kskjryj8isp62m2sgvx25yyj3kpc2myh85w24bki";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
    };

    #
# crate2nix/default.nix (excerpt start)
#

  /* Target (platform) data for conditional dependencies.
     This corresponds roughly to what buildRustCrate is setting.
  */
  defaultTarget = {
    unix = true;
    windows = false;
    fuchsia = true;
    test = false;

    # This doesn't appear to be officially documented anywhere yet.
    # See https://github.com/rust-lang-nursery/rust-forge/issues/101.
    os =
      if stdenv.hostPlatform.isDarwin
      then "macos"
      else stdenv.hostPlatform.parsed.kernel.name;
    arch = stdenv.hostPlatform.parsed.cpu.name;
    family = "unix";
    env = "gnu";
    endian =
      if stdenv.hostPlatform.parsed.cpu.significantByte.name == "littleEndian"
      then "little" else "big";
    pointer_width = toString stdenv.hostPlatform.parsed.cpu.bits;
    vendor = stdenv.hostPlatform.parsed.vendor.name;
    debug_assertions = false;
  };

  /* Filters common temp files and build files. */
  # TODO(pkolloch): Substitute with gitignore filter
  sourceFilter = name: type:
    let
      baseName = builtins.baseNameOf (builtins.toString name);
    in
      ! (
        # Filter out git
        baseName == ".gitignore"
        || (type == "directory" && baseName == ".git")

        # Filter out build results
        || (
          type == "directory" && (
            baseName == "target"
            || baseName == "_site"
            || baseName == ".sass-cache"
            || baseName == ".jekyll-metadata"
            || baseName == "build-artifacts"
          )
        )

        # Filter out nix-build result symlinks
        || (
          type == "symlink" && lib.hasPrefix "result" baseName
        )

        # Filter out IDE config
        || (
          type == "directory" && (
            baseName == ".idea" || baseName == ".vscode"
          )
        ) || lib.hasSuffix ".iml" baseName

        # Filter out nix build files
        || baseName == "Cargo.nix"

        # Filter out editor backup / swap files.
        || lib.hasSuffix "~" baseName
        || builtins.match "^\\.sw[a-z]$$" baseName != null
        || builtins.match "^\\..*\\.sw[a-z]$$" baseName != null
        || lib.hasSuffix ".tmp" baseName
        || lib.hasSuffix ".bak" baseName
        || baseName == "tests.nix"
      );

  /* Returns a crate which depends on successful test execution
     of crate given as the second argument.

     testCrateFlags: list of flags to pass to the test exectuable
     testInputs: list of packages that should be available during test execution
  */
  crateWithTest = { crate, testCrate, testCrateFlags, testInputs, testPreRun, testPostRun }:
    assert builtins.typeOf testCrateFlags == "list";
    assert builtins.typeOf testInputs == "list";
    assert builtins.typeOf testPreRun == "string";
    assert builtins.typeOf testPostRun == "string";
    let
      # override the `crate` so that it will build and execute tests instead of
      # building the actual lib and bin targets We just have to pass `--test`
      # to rustc and it will do the right thing.  We execute the tests and copy
      # their log and the test executables to $out for later inspection.
      test =
        let
          drv = testCrate.override
            (
              _: {
                buildTests = true;
              }
            );
          # If the user hasn't set any pre/post commands, we don't want to
          # insert empty lines. This means that any existing users of crate2nix
          # don't get a spurious rebuild unless they set these explicitly.
          testCommand = pkgs.lib.concatStringsSep "\n"
            (pkgs.lib.filter (s: s != "") [
              testPreRun
              "$f $testCrateFlags 2>&1 | tee -a $out"
              testPostRun
            ]);
        in
        pkgs.runCommand "run-tests-${testCrate.name}"
          {
            inherit testCrateFlags;
            buildInputs = testInputs;
          } ''
          set -ex

          export RUST_BACKTRACE=1

          # recreate a file hierarchy as when running tests with cargo

          # the source for test data
          ${pkgs.xorg.lndir}/bin/lndir ${crate.src}

          # build outputs
          testRoot=target/debug
          mkdir -p $testRoot

          # executables of the crate
          # we copy to prevent std::env::current_exe() to resolve to a store location
          for i in ${crate}/bin/*; do
            cp "$i" "$testRoot"
          done
          chmod +w -R .

          # test harness executables are suffixed with a hash, like cargo does
          # this allows to prevent name collision with the main
          # executables of the crate
          hash=$(basename $out)
          for file in ${drv}/tests/*; do
            f=$testRoot/$(basename $file)-$hash
            cp $file $f
            ${testCommand}
          done
        '';
    in
    pkgs.runCommand "${crate.name}-linked"
      {
        inherit (crate) outputs crateName;
        passthru = (crate.passthru or { }) // {
          inherit test;
        };
      } ''
      echo tested by ${test}
      ${lib.concatMapStringsSep "\n" (output: "ln -s ${crate.${output}} ${"$"}${output}") crate.outputs}
    '';

  /* A restricted overridable version of builtRustCratesWithFeatures. */
  buildRustCrateWithFeatures =
    { packageId
    , features ? rootFeatures
    , crateOverrides ? defaultCrateOverrides
    , buildRustCrateForPkgsFunc ? null
    , runTests ? false
    , testCrateFlags ? [ ]
    , testInputs ? [ ]
      # Any command to run immediatelly before a test is executed.
    , testPreRun ? ""
      # Any command run immediatelly after a test is executed.
    , testPostRun ? ""
    }:
    lib.makeOverridable
      (
        { features
        , crateOverrides
        , runTests
        , testCrateFlags
        , testInputs
        , testPreRun
        , testPostRun
        }:
        let
          buildRustCrateForPkgsFuncOverriden =
            if buildRustCrateForPkgsFunc != null
            then buildRustCrateForPkgsFunc
            else
              (
                if crateOverrides == pkgs.defaultCrateOverrides
                then buildRustCrateForPkgs
                else
                  pkgs: (buildRustCrateForPkgs pkgs).override {
                    defaultCrateOverrides = crateOverrides;
                  }
              );
          builtRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
            runTests = false;
          };
          builtTestRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
            runTests = true;
          };
          drv = builtRustCrates.crates.${packageId};
          testDrv = builtTestRustCrates.crates.${packageId};
          derivation =
            if runTests then
              crateWithTest
                {
                  crate = drv;
                  testCrate = testDrv;
                  inherit testCrateFlags testInputs testPreRun testPostRun;
                }
            else drv;
        in
        derivation
      )
      { inherit features crateOverrides runTests testCrateFlags testInputs testPreRun testPostRun; };

  /* Returns an attr set with packageId mapped to the result of buildRustCrateForPkgsFunc
     for the corresponding crate.
  */
  builtRustCratesWithFeatures =
    { packageId
    , features
    , crateConfigs ? crates
    , buildRustCrateForPkgsFunc
    , runTests
    , target ? defaultTarget
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isList features);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        rootPackageId = packageId;
        mergedFeatures = mergePackageFeatures
          (
            args // {
              inherit rootPackageId;
              target = target // { test = runTests; };
            }
          );
        # Memoize built packages so that reappearing packages are only built once.
        builtByPackageIdByPkgs = mkBuiltByPackageIdByPkgs pkgs;
        mkBuiltByPackageIdByPkgs = pkgs:
          let
            self = {
              crates = lib.mapAttrs (packageId: value: buildByPackageIdForPkgsImpl self pkgs packageId) crateConfigs;
              build = mkBuiltByPackageIdByPkgs pkgs.buildPackages;
            };
          in
          self;
        buildByPackageIdForPkgsImpl = self: pkgs: packageId:
          let
            features = mergedFeatures."${packageId}" or [ ];
            crateConfig' = crateConfigs."${packageId}";
            crateConfig =
              builtins.removeAttrs crateConfig' [ "resolvedDefaultFeatures" "devDependencies" ];
            devDependencies =
              lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig'.devDependencies or [ ]);
            dependencies =
              dependencyDerivations {
                inherit features target;
                buildByPackageId = depPackageId:
                  # proc_macro crates must be compiled for the build architecture
                  if crateConfigs.${depPackageId}.procMacro or false
                  then self.build.crates.${depPackageId}
                  else self.crates.${depPackageId};
                dependencies =
                  (crateConfig.dependencies or [ ])
                  ++ devDependencies;
              };
            buildDependencies =
              dependencyDerivations {
                inherit features target;
                buildByPackageId = depPackageId:
                  self.build.crates.${depPackageId};
                dependencies = crateConfig.buildDependencies or [ ];
              };
            filterEnabledDependenciesForThis = dependencies: filterEnabledDependencies {
              inherit dependencies features target;
            };
            dependenciesWithRenames =
              lib.filter (d: d ? "rename")
                (
                  filterEnabledDependenciesForThis
                    (
                      (crateConfig.buildDependencies or [ ])
                      ++ (crateConfig.dependencies or [ ])
                      ++ devDependencies
                    )
                );
            # Crate renames have the form:
            #
            # {
            #    crate_name = [
            #       { version = "1.2.3"; rename = "crate_name01"; }
            #    ];
            #    # ...
            # }
            crateRenames =
              let
                grouped =
                  lib.groupBy
                    (dependency: dependency.name)
                    dependenciesWithRenames;
                versionAndRename = dep:
                  let
                    package = crateConfigs."${dep.packageId}";
                  in
                  { inherit (dep) rename; version = package.version; };
              in
              lib.mapAttrs (name: choices: builtins.map versionAndRename choices) grouped;
          in
          buildRustCrateForPkgsFunc pkgs
            (
              crateConfig // {
                src = crateConfig.src or (
                  pkgs.fetchurl rec {
                    name = "${crateConfig.crateName}-${crateConfig.version}.tar.gz";
                    # https://www.pietroalbini.org/blog/downloading-crates-io/
                    # Not rate-limited, CDN URL.
                    url = "https://static.crates.io/crates/${crateConfig.crateName}/${crateConfig.crateName}-${crateConfig.version}.crate";
                    sha256 =
                      assert (lib.assertMsg (crateConfig ? sha256) "Missing sha256 for ${name}");
                      crateConfig.sha256;
                  }
                );
                extraRustcOpts = lib.lists.optional (targetFeatures != [ ]) "-C target-feature=${lib.concatMapStringsSep "," (x: "+${x}") targetFeatures}";
                inherit features dependencies buildDependencies crateRenames release;
              }
            );
      in
      builtByPackageIdByPkgs;

  /* Returns the actual derivations for the given dependencies. */
  dependencyDerivations =
    { buildByPackageId
    , features
    , dependencies
    , target
    }:
      assert (builtins.isList features);
      assert (builtins.isList dependencies);
      assert (builtins.isAttrs target);
      let
        enabledDependencies = filterEnabledDependencies {
          inherit dependencies features target;
        };
        depDerivation = dependency: buildByPackageId dependency.packageId;
      in
      map depDerivation enabledDependencies;

  /* Returns a sanitized version of val with all values substituted that cannot
     be serialized as JSON.
  */
  sanitizeForJson = val:
    if builtins.isAttrs val
    then lib.mapAttrs (n: v: sanitizeForJson v) val
    else if builtins.isList val
    then builtins.map sanitizeForJson val
    else if builtins.isFunction val
    then "function"
    else val;

  /* Returns various tools to debug a crate. */
  debugCrate = { packageId, target ? defaultTarget }:
    assert (builtins.isString packageId);
    let
      debug = rec {
        # The built tree as passed to buildRustCrate.
        buildTree = buildRustCrateWithFeatures {
          buildRustCrateForPkgsFunc = _: lib.id;
          inherit packageId;
        };
        sanitizedBuildTree = sanitizeForJson buildTree;
        dependencyTree = sanitizeForJson
          (
            buildRustCrateWithFeatures {
              buildRustCrateForPkgsFunc = _: crate: {
                "01_crateName" = crate.crateName or false;
                "02_features" = crate.features or [ ];
                "03_dependencies" = crate.dependencies or [ ];
              };
              inherit packageId;
            }
          );
        mergedPackageFeatures = mergePackageFeatures {
          features = rootFeatures;
          inherit packageId target;
        };
        diffedDefaultPackageFeatures = diffDefaultPackageFeatures {
          inherit packageId target;
        };
      };
    in
    { internal = debug; };

  /* Returns differences between cargo default features and crate2nix default
     features.

     This is useful for verifying the feature resolution in crate2nix.
  */
  diffDefaultPackageFeatures =
    { crateConfigs ? crates
    , packageId
    , target
    }:
      assert (builtins.isAttrs crateConfigs);
      let
        prefixValues = prefix: lib.mapAttrs (n: v: { "${prefix}" = v; });
        mergedFeatures =
          prefixValues
            "crate2nix"
            (mergePackageFeatures { inherit crateConfigs packageId target; features = [ "default" ]; });
        configs = prefixValues "cargo" crateConfigs;
        combined = lib.foldAttrs (a: b: a // b) { } [ mergedFeatures configs ];
        onlyInCargo =
          builtins.attrNames
            (lib.filterAttrs (n: v: !(v ? "crate2nix") && (v ? "cargo")) combined);
        onlyInCrate2Nix =
          builtins.attrNames
            (lib.filterAttrs (n: v: (v ? "crate2nix") && !(v ? "cargo")) combined);
        differentFeatures = lib.filterAttrs
          (
            n: v:
              (v ? "crate2nix")
              && (v ? "cargo")
              && (v.crate2nix.features or [ ]) != (v."cargo".resolved_default_features or [ ])
          )
          combined;
      in
      builtins.toJSON {
        inherit onlyInCargo onlyInCrate2Nix differentFeatures;
      };

  /* Returns an attrset mapping packageId to the list of enabled features.

     If multiple paths to a dependency enable different features, the
     corresponding feature sets are merged. Features in rust are additive.
  */
  mergePackageFeatures =
    { crateConfigs ? crates
    , packageId
    , rootPackageId ? packageId
    , features ? rootFeatures
    , dependencyPath ? [ crates.${packageId}.crateName ]
    , featuresByPackageId ? { }
    , target
      # Adds devDependencies to the crate with rootPackageId.
    , runTests ? false
    , ...
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isString rootPackageId);
      assert (builtins.isList features);
      assert (builtins.isList dependencyPath);
      assert (builtins.isAttrs featuresByPackageId);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        crateConfig = crateConfigs."${packageId}" or (builtins.throw "Package not found: ${packageId}");
        expandedFeatures = expandFeatures (crateConfig.features or { }) features;
        enabledFeatures = enableFeatures (crateConfig.dependencies or [ ]) expandedFeatures;
        depWithResolvedFeatures = dependency:
          let
            packageId = dependency.packageId;
            features = dependencyFeatures enabledFeatures dependency;
          in
          { inherit packageId features; };
        resolveDependencies = cache: path: dependencies:
          assert (builtins.isAttrs cache);
          assert (builtins.isList dependencies);
          let
            enabledDependencies = filterEnabledDependencies {
              inherit dependencies target;
              features = enabledFeatures;
            };
            directDependencies = map depWithResolvedFeatures enabledDependencies;
            foldOverCache = op: lib.foldl op cache directDependencies;
          in
          foldOverCache
            (
              cache: { packageId, features }:
                let
                  cacheFeatures = cache.${packageId} or [ ];
                  combinedFeatures = sortedUnique (cacheFeatures ++ features);
                in
                if cache ? ${packageId} && cache.${packageId} == combinedFeatures
                then cache
                else
                  mergePackageFeatures {
                    features = combinedFeatures;
                    featuresByPackageId = cache;
                    inherit crateConfigs packageId target runTests rootPackageId;
                  }
            );
        cacheWithSelf =
          let
            cacheFeatures = featuresByPackageId.${packageId} or [ ];
            combinedFeatures = sortedUnique (cacheFeatures ++ enabledFeatures);
          in
          featuresByPackageId // {
            "${packageId}" = combinedFeatures;
          };
        cacheWithDependencies =
          resolveDependencies cacheWithSelf "dep"
            (
              crateConfig.dependencies or [ ]
              ++ lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig.devDependencies or [ ])
            );
        cacheWithAll =
          resolveDependencies
            cacheWithDependencies "build"
            (crateConfig.buildDependencies or [ ]);
      in
      cacheWithAll;

  /* Returns the enabled dependencies given the enabled features. */
  filterEnabledDependencies = { dependencies, features, target }:
    assert (builtins.isList dependencies);
    assert (builtins.isList features);
    assert (builtins.isAttrs target);

    lib.filter
      (
        dep:
        let
          targetFunc = dep.target or (features: true);
        in
        targetFunc { inherit features target; }
        && (
          !(dep.optional or false)
          || builtins.any (doesFeatureEnableDependency dep) features
        )
      )
      dependencies;

  /* Returns whether the given feature should enable the given dependency. */
  doesFeatureEnableDependency = { name, rename ? null, ... }: feature:
    let
      prefix = "${name}/";
      len = builtins.stringLength prefix;
      startsWithPrefix = builtins.substring 0 len feature == prefix;
    in
    (rename == null && feature == name)
    || (rename != null && rename == feature)
    || startsWithPrefix;

  /* Returns the expanded features for the given inputFeatures by applying the
     rules in featureMap.

     featureMap is an attribute set which maps feature names to lists of further
     feature names to enable in case this feature is selected.
  */
  expandFeatures = featureMap: inputFeatures:
    assert (builtins.isAttrs featureMap);
    assert (builtins.isList inputFeatures);
    let
      expandFeature = feature:
        assert (builtins.isString feature);
        [ feature ] ++ (expandFeatures featureMap (featureMap."${feature}" or [ ]));
      outFeatures = lib.concatMap expandFeature inputFeatures;
    in
    sortedUnique outFeatures;

  /* This function adds optional dependencies as features if they are enabled
     indirectly by dependency features. This function mimics Cargo's behavior
     described in a note at:
     https://doc.rust-lang.org/nightly/cargo/reference/features.html#dependency-features
  */
  enableFeatures = dependencies: features:
    assert (builtins.isList features);
    assert (builtins.isList dependencies);
    let
      additionalFeatures = lib.concatMap
        (
          dependency:
            assert (builtins.isAttrs dependency);
            let
              enabled = builtins.any (doesFeatureEnableDependency dependency) features;
            in
            if (dependency.optional or false) && enabled then [ dependency.name ] else [ ]
        )
        dependencies;
    in
    sortedUnique (features ++ additionalFeatures);

  /*
     Returns the actual features for the given dependency.

     features: The features of the crate that refers this dependency.
  */
  dependencyFeatures = features: dependency:
    assert (builtins.isList features);
    assert (builtins.isAttrs dependency);
    let
      defaultOrNil =
        if dependency.usesDefaultFeatures or true
        then [ "default" ]
        else [ ];
      explicitFeatures = dependency.features or [ ];
      additionalDependencyFeatures =
        let
          dependencyPrefix = (dependency.rename or dependency.name) + "/";
          dependencyFeatures =
            builtins.filter (f: lib.hasPrefix dependencyPrefix f) features;
        in
        builtins.map (lib.removePrefix dependencyPrefix) dependencyFeatures;
    in
    defaultOrNil ++ explicitFeatures ++ additionalDependencyFeatures;

  /* Sorts and removes duplicates from a list of strings. */
  sortedUnique = features:
    assert (builtins.isList features);
    assert (builtins.all builtins.isString features);
    let
      outFeaturesSet = lib.foldl (set: feature: set // { "${feature}" = 1; }) { } features;
      outFeaturesUnique = builtins.attrNames outFeaturesSet;
    in
    builtins.sort (a: b: a < b) outFeaturesUnique;

  deprecationWarning = message: value:
    if strictDeprecation
    then builtins.throw "strictDeprecation enabled, aborting: ${message}"
    else builtins.trace message value;

  #
  # crate2nix/default.nix (excerpt end)
  #
  };
}

