// GENERATED BY ISLE. DO NOT EDIT!
//
// Generated automatically from the instruction-selection DSL code in:
// - src/clif.isle
// - src/prelude.isle
// - src/isa/s390x/inst.isle
// - src/isa/s390x/lower.isle

#![allow(dead_code, unreachable_code, unreachable_patterns)]
#![allow(unused_imports, unused_variables, non_snake_case)]
#![allow(irrefutable_let_patterns)]

use super::*; // Pulls in all external types.

/// Context during lowering: an implementation of this trait
/// must be provided with all external constructors and extractors.
/// A mutable borrow is passed along through all lowering logic.
pub trait Context {
    fn unpack_value_array_2(&mut self, arg0: &ValueArray2) -> (Value, Value);
    fn pack_value_array_2(&mut self, arg0: Value, arg1: Value) -> ValueArray2;
    fn unpack_value_array_3(&mut self, arg0: &ValueArray3) -> (Value, Value, Value);
    fn pack_value_array_3(&mut self, arg0: Value, arg1: Value, arg2: Value) -> ValueArray3;
    fn u32_add(&mut self, arg0: u32, arg1: u32) -> u32;
    fn u8_and(&mut self, arg0: u8, arg1: u8) -> u8;
    fn value_reg(&mut self, arg0: Reg) -> ValueRegs;
    fn value_regs(&mut self, arg0: Reg, arg1: Reg) -> ValueRegs;
    fn value_regs_invalid(&mut self) -> ValueRegs;
    fn output_none(&mut self) -> InstOutput;
    fn output(&mut self, arg0: ValueRegs) -> InstOutput;
    fn output_pair(&mut self, arg0: ValueRegs, arg1: ValueRegs) -> InstOutput;
    fn output_builder_new(&mut self) -> InstOutputBuilder;
    fn output_builder_push(&mut self, arg0: &InstOutputBuilder, arg1: ValueRegs) -> Unit;
    fn output_builder_finish(&mut self, arg0: &InstOutputBuilder) -> InstOutput;
    fn temp_writable_reg(&mut self, arg0: Type) -> WritableReg;
    fn invalid_reg(&mut self) -> Reg;
    fn put_in_reg(&mut self, arg0: Value) -> Reg;
    fn put_in_regs(&mut self, arg0: Value) -> ValueRegs;
    fn value_regs_get(&mut self, arg0: ValueRegs, arg1: usize) -> Reg;
    fn u8_as_u64(&mut self, arg0: u8) -> u64;
    fn u16_as_u64(&mut self, arg0: u16) -> u64;
    fn u32_as_u64(&mut self, arg0: u32) -> u64;
    fn i64_as_u64(&mut self, arg0: i64) -> u64;
    fn u64_add(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_sub(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_and(&mut self, arg0: u64, arg1: u64) -> u64;
    fn ty_bits(&mut self, arg0: Type) -> u8;
    fn ty_bits_u16(&mut self, arg0: Type) -> u16;
    fn ty_bits_u64(&mut self, arg0: Type) -> u64;
    fn ty_mask(&mut self, arg0: Type) -> u64;
    fn ty_bytes(&mut self, arg0: Type) -> u16;
    fn lane_type(&mut self, arg0: Type) -> Type;
    fn fits_in_16(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_32_or_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_8_or_16(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_bool_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_bool_128(&mut self, arg0: Type) -> Option<Type>;
    fn ty_scalar_float(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec128(&mut self, arg0: Type) -> Option<Type>;
    fn not_i64x2(&mut self, arg0: Type) -> Option<()>;
    fn value_list_slice(&mut self, arg0: ValueList) -> ValueSlice;
    fn value_slice_empty(&mut self, arg0: ValueSlice) -> Option<()>;
    fn value_slice_unwrap(&mut self, arg0: ValueSlice) -> Option<(Value, ValueSlice)>;
    fn value_slice_len(&mut self, arg0: ValueSlice) -> usize;
    fn value_slice_get(&mut self, arg0: ValueSlice, arg1: usize) -> Value;
    fn writable_reg_to_reg(&mut self, arg0: WritableReg) -> Reg;
    fn u8_from_uimm8(&mut self, arg0: Uimm8) -> u8;
    fn u64_from_imm64(&mut self, arg0: Imm64) -> u64;
    fn nonzero_u64_from_imm64(&mut self, arg0: Imm64) -> Option<u64>;
    fn u64_from_ieee32(&mut self, arg0: Ieee32) -> u64;
    fn u64_from_ieee64(&mut self, arg0: Ieee64) -> u64;
    fn inst_results(&mut self, arg0: Inst) -> ValueSlice;
    fn first_result(&mut self, arg0: Inst) -> Option<Value>;
    fn inst_data(&mut self, arg0: Inst) -> InstructionData;
    fn value_type(&mut self, arg0: Value) -> Type;
    fn multi_lane(&mut self, arg0: Type) -> Option<(u8, u16)>;
    fn def_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn emit(&mut self, arg0: &MInst) -> Unit;
    fn emit_safepoint(&mut self, arg0: &MInst) -> Unit;
    fn trap_code_division_by_zero(&mut self) -> TrapCode;
    fn trap_code_integer_overflow(&mut self) -> TrapCode;
    fn trap_code_bad_conversion_to_integer(&mut self) -> TrapCode;
    fn avoid_div_traps(&mut self, arg0: Type) -> Option<()>;
    fn func_ref_data(&mut self, arg0: FuncRef) -> (SigRef, ExternalName, RelocDistance);
    fn symbol_value_data(
        &mut self,
        arg0: GlobalValue,
    ) -> Option<(ExternalName, RelocDistance, i64)>;
    fn reloc_distance_near(&mut self, arg0: RelocDistance) -> Option<()>;
    fn mie2_enabled(&mut self, arg0: Type) -> Option<()>;
    fn mie2_disabled(&mut self, arg0: Type) -> Option<()>;
    fn vxrs_ext2_enabled(&mut self, arg0: Type) -> Option<()>;
    fn vxrs_ext2_disabled(&mut self, arg0: Type) -> Option<()>;
    fn allow_div_traps(&mut self, arg0: Type) -> Option<()>;
    fn writable_gpr(&mut self, arg0: u8) -> WritableReg;
    fn zero_reg(&mut self) -> Reg;
    fn gpr32_ty(&mut self, arg0: Type) -> Option<Type>;
    fn gpr64_ty(&mut self, arg0: Type) -> Option<Type>;
    fn uimm32shifted(&mut self, arg0: u32, arg1: u8) -> UImm32Shifted;
    fn uimm16shifted(&mut self, arg0: u16, arg1: u8) -> UImm16Shifted;
    fn i64_nonequal(&mut self, arg0: i64, arg1: i64) -> Option<i64>;
    fn u8_as_u16(&mut self, arg0: u8) -> u16;
    fn u64_as_u32(&mut self, arg0: u64) -> u32;
    fn u64_as_i16(&mut self, arg0: u64) -> i16;
    fn u64_nonzero_hipart(&mut self, arg0: u64) -> Option<u64>;
    fn u64_nonzero_lopart(&mut self, arg0: u64) -> Option<u64>;
    fn i32_from_u64(&mut self, arg0: u64) -> Option<i32>;
    fn i16_from_u64(&mut self, arg0: u64) -> Option<i16>;
    fn uimm32shifted_from_u64(&mut self, arg0: u64) -> Option<UImm32Shifted>;
    fn uimm16shifted_from_u64(&mut self, arg0: u64) -> Option<UImm16Shifted>;
    fn u64_from_value(&mut self, arg0: Value) -> Option<u64>;
    fn u32_from_value(&mut self, arg0: Value) -> Option<u32>;
    fn u8_from_value(&mut self, arg0: Value) -> Option<u8>;
    fn u64_from_signed_value(&mut self, arg0: Value) -> Option<u64>;
    fn i64_from_value(&mut self, arg0: Value) -> Option<i64>;
    fn i32_from_value(&mut self, arg0: Value) -> Option<i32>;
    fn i16_from_value(&mut self, arg0: Value) -> Option<i16>;
    fn i16_from_swapped_value(&mut self, arg0: Value) -> Option<i16>;
    fn i64_from_negated_value(&mut self, arg0: Value) -> Option<i64>;
    fn i32_from_negated_value(&mut self, arg0: Value) -> Option<i32>;
    fn i16_from_negated_value(&mut self, arg0: Value) -> Option<i16>;
    fn uimm16shifted_from_value(&mut self, arg0: Value) -> Option<UImm16Shifted>;
    fn uimm32shifted_from_value(&mut self, arg0: Value) -> Option<UImm32Shifted>;
    fn uimm16shifted_from_inverted_value(&mut self, arg0: Value) -> Option<UImm16Shifted>;
    fn uimm32shifted_from_inverted_value(&mut self, arg0: Value) -> Option<UImm32Shifted>;
    fn mask_amt_imm(&mut self, arg0: Type, arg1: i64) -> u8;
    fn mask_as_cond(&mut self, arg0: u8) -> Cond;
    fn intcc_as_cond(&mut self, arg0: &IntCC) -> Cond;
    fn floatcc_as_cond(&mut self, arg0: &FloatCC) -> Cond;
    fn invert_cond(&mut self, arg0: &Cond) -> Cond;
    fn signed(&mut self, arg0: &IntCC) -> Option<()>;
    fn unsigned(&mut self, arg0: &IntCC) -> Option<()>;
    fn vec_length_minus1(&mut self, arg0: &VecMachLabel) -> u32;
    fn vec_element(&mut self, arg0: &VecMachLabel, arg1: u8) -> MachLabel;
    fn zero_offset(&mut self) -> Offset32;
    fn i64_from_offset(&mut self, arg0: Offset32) -> i64;
    fn box_external_name(&mut self, arg0: ExternalName) -> BoxExternalName;
    fn littleendian(&mut self, arg0: MemFlags) -> Option<()>;
    fn bigendian(&mut self, arg0: MemFlags) -> Option<()>;
    fn memflags_trusted(&mut self) -> MemFlags;
    fn memarg_reg_plus_reg(&mut self, arg0: Reg, arg1: Reg, arg2: MemFlags) -> MemArg;
    fn memarg_reg_plus_off(&mut self, arg0: Reg, arg1: i64, arg2: MemFlags) -> MemArg;
    fn memarg_symbol(&mut self, arg0: ExternalName, arg1: i32, arg2: MemFlags) -> MemArg;
    fn memarg_symbol_offset_sum(&mut self, arg0: i64, arg1: i64) -> Option<i32>;
    fn abi_stackslot_addr(&mut self, arg0: WritableReg, arg1: StackSlot, arg2: Offset32) -> MInst;
    fn sinkable_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn sink_inst(&mut self, arg0: Inst) -> Unit;
    fn inst_builder_new(&mut self) -> VecMInstBuilder;
    fn inst_builder_push(&mut self, arg0: &VecMInstBuilder, arg1: &MInst) -> Unit;
    fn inst_builder_finish(&mut self, arg0: &VecMInstBuilder) -> VecMInst;
    fn real_reg(&mut self, arg0: WritableReg) -> Option<WritableReg>;
    fn same_reg(&mut self, arg0: Reg, arg1: WritableReg) -> Option<()>;
}

/// Internal type SideEffectNoResult: defined at src/prelude.isle line 397.
#[derive(Clone, Debug)]
pub enum SideEffectNoResult {
    Inst { inst: MInst },
}

/// Internal type ProducesFlags: defined at src/prelude.isle line 419.
#[derive(Clone, Debug)]
pub enum ProducesFlags {
    ProducesFlagsSideEffect { inst: MInst },
    ProducesFlagsReturnsReg { inst: MInst, result: Reg },
    ProducesFlagsReturnsResultWithConsumer { inst: MInst, result: Reg },
}

/// Internal type ConsumesFlags: defined at src/prelude.isle line 430.
#[derive(Clone, Debug)]
pub enum ConsumesFlags {
    ConsumesFlagsReturnsResultWithProducer {
        inst: MInst,
        result: Reg,
    },
    ConsumesFlagsReturnsReg {
        inst: MInst,
        result: Reg,
    },
    ConsumesFlagsTwiceReturnsValueRegs {
        inst1: MInst,
        inst2: MInst,
        result: ValueRegs,
    },
    ConsumesFlagsFourTimesReturnsValueRegs {
        inst1: MInst,
        inst2: MInst,
        inst3: MInst,
        inst4: MInst,
        result: ValueRegs,
    },
}

/// Internal type MInst: defined at src/isa/s390x/inst.isle line 2.
#[derive(Clone, Debug)]
pub enum MInst {
    Nop0,
    Nop2,
    AluRRR {
        alu_op: ALUOp,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
    },
    AluRRSImm16 {
        alu_op: ALUOp,
        rd: WritableReg,
        rn: Reg,
        imm: i16,
    },
    AluRR {
        alu_op: ALUOp,
        rd: WritableReg,
        rm: Reg,
    },
    AluRX {
        alu_op: ALUOp,
        rd: WritableReg,
        mem: MemArg,
    },
    AluRSImm16 {
        alu_op: ALUOp,
        rd: WritableReg,
        imm: i16,
    },
    AluRSImm32 {
        alu_op: ALUOp,
        rd: WritableReg,
        imm: i32,
    },
    AluRUImm32 {
        alu_op: ALUOp,
        rd: WritableReg,
        imm: u32,
    },
    AluRUImm16Shifted {
        alu_op: ALUOp,
        rd: WritableReg,
        imm: UImm16Shifted,
    },
    AluRUImm32Shifted {
        alu_op: ALUOp,
        rd: WritableReg,
        imm: UImm32Shifted,
    },
    SMulWide {
        rn: Reg,
        rm: Reg,
    },
    UMulWide {
        rn: Reg,
    },
    SDivMod32 {
        rn: Reg,
    },
    SDivMod64 {
        rn: Reg,
    },
    UDivMod32 {
        rn: Reg,
    },
    UDivMod64 {
        rn: Reg,
    },
    Flogr {
        rn: Reg,
    },
    ShiftRR {
        shift_op: ShiftOp,
        rd: WritableReg,
        rn: Reg,
        shift_imm: u8,
        shift_reg: Reg,
    },
    RxSBG {
        op: RxSBGOp,
        rd: WritableReg,
        rn: Reg,
        start_bit: u8,
        end_bit: u8,
        rotate_amt: i8,
    },
    RxSBGTest {
        op: RxSBGOp,
        rd: Reg,
        rn: Reg,
        start_bit: u8,
        end_bit: u8,
        rotate_amt: i8,
    },
    UnaryRR {
        op: UnaryOp,
        rd: WritableReg,
        rn: Reg,
    },
    CmpRR {
        op: CmpOp,
        rn: Reg,
        rm: Reg,
    },
    CmpRX {
        op: CmpOp,
        rn: Reg,
        mem: MemArg,
    },
    CmpRSImm16 {
        op: CmpOp,
        rn: Reg,
        imm: i16,
    },
    CmpRSImm32 {
        op: CmpOp,
        rn: Reg,
        imm: i32,
    },
    CmpRUImm32 {
        op: CmpOp,
        rn: Reg,
        imm: u32,
    },
    CmpTrapRR {
        op: CmpOp,
        rn: Reg,
        rm: Reg,
        cond: Cond,
        trap_code: TrapCode,
    },
    CmpTrapRSImm16 {
        op: CmpOp,
        rn: Reg,
        imm: i16,
        cond: Cond,
        trap_code: TrapCode,
    },
    CmpTrapRUImm16 {
        op: CmpOp,
        rn: Reg,
        imm: u16,
        cond: Cond,
        trap_code: TrapCode,
    },
    AtomicRmw {
        alu_op: ALUOp,
        rd: WritableReg,
        rn: Reg,
        mem: MemArg,
    },
    AtomicCas32 {
        rd: WritableReg,
        rn: Reg,
        mem: MemArg,
    },
    AtomicCas64 {
        rd: WritableReg,
        rn: Reg,
        mem: MemArg,
    },
    Fence,
    Load32 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load32ZExt8 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load32SExt8 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load32ZExt16 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load32SExt16 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64ZExt8 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64SExt8 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64ZExt16 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64SExt16 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64ZExt32 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64SExt32 {
        rd: WritableReg,
        mem: MemArg,
    },
    LoadRev16 {
        rd: WritableReg,
        mem: MemArg,
    },
    LoadRev32 {
        rd: WritableReg,
        mem: MemArg,
    },
    LoadRev64 {
        rd: WritableReg,
        mem: MemArg,
    },
    Store8 {
        rd: Reg,
        mem: MemArg,
    },
    Store16 {
        rd: Reg,
        mem: MemArg,
    },
    Store32 {
        rd: Reg,
        mem: MemArg,
    },
    Store64 {
        rd: Reg,
        mem: MemArg,
    },
    StoreImm8 {
        imm: u8,
        mem: MemArg,
    },
    StoreImm16 {
        imm: i16,
        mem: MemArg,
    },
    StoreImm32SExt16 {
        imm: i16,
        mem: MemArg,
    },
    StoreImm64SExt16 {
        imm: i16,
        mem: MemArg,
    },
    StoreRev16 {
        rd: Reg,
        mem: MemArg,
    },
    StoreRev32 {
        rd: Reg,
        mem: MemArg,
    },
    StoreRev64 {
        rd: Reg,
        mem: MemArg,
    },
    LoadMultiple64 {
        rt: WritableReg,
        rt2: WritableReg,
        mem: MemArg,
    },
    StoreMultiple64 {
        rt: Reg,
        rt2: Reg,
        mem: MemArg,
    },
    Mov32 {
        rd: WritableReg,
        rm: Reg,
    },
    Mov64 {
        rd: WritableReg,
        rm: Reg,
    },
    Mov32Imm {
        rd: WritableReg,
        imm: u32,
    },
    Mov32SImm16 {
        rd: WritableReg,
        imm: i16,
    },
    Mov64SImm16 {
        rd: WritableReg,
        imm: i16,
    },
    Mov64SImm32 {
        rd: WritableReg,
        imm: i32,
    },
    Mov64UImm16Shifted {
        rd: WritableReg,
        imm: UImm16Shifted,
    },
    Mov64UImm32Shifted {
        rd: WritableReg,
        imm: UImm32Shifted,
    },
    Insert64UImm16Shifted {
        rd: WritableReg,
        imm: UImm16Shifted,
    },
    Insert64UImm32Shifted {
        rd: WritableReg,
        imm: UImm32Shifted,
    },
    Extend {
        rd: WritableReg,
        rn: Reg,
        signed: bool,
        from_bits: u8,
        to_bits: u8,
    },
    CMov32 {
        rd: WritableReg,
        cond: Cond,
        rm: Reg,
    },
    CMov64 {
        rd: WritableReg,
        cond: Cond,
        rm: Reg,
    },
    CMov32SImm16 {
        rd: WritableReg,
        cond: Cond,
        imm: i16,
    },
    CMov64SImm16 {
        rd: WritableReg,
        cond: Cond,
        imm: i16,
    },
    FpuMove32 {
        rd: WritableReg,
        rn: Reg,
    },
    FpuMove64 {
        rd: WritableReg,
        rn: Reg,
    },
    FpuCMov32 {
        rd: WritableReg,
        cond: Cond,
        rm: Reg,
    },
    FpuCMov64 {
        rd: WritableReg,
        cond: Cond,
        rm: Reg,
    },
    MovToFpr {
        rd: WritableReg,
        rn: Reg,
    },
    MovFromFpr {
        rd: WritableReg,
        rn: Reg,
    },
    FpuRR {
        fpu_op: FPUOp1,
        rd: WritableReg,
        rn: Reg,
    },
    FpuRRR {
        fpu_op: FPUOp2,
        rd: WritableReg,
        rm: Reg,
    },
    FpuRRRR {
        fpu_op: FPUOp3,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
    },
    FpuCopysign {
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
    },
    FpuCmp32 {
        rn: Reg,
        rm: Reg,
    },
    FpuCmp64 {
        rn: Reg,
        rm: Reg,
    },
    FpuLoad32 {
        rd: WritableReg,
        mem: MemArg,
    },
    FpuStore32 {
        rd: Reg,
        mem: MemArg,
    },
    FpuLoad64 {
        rd: WritableReg,
        mem: MemArg,
    },
    FpuStore64 {
        rd: Reg,
        mem: MemArg,
    },
    FpuLoadRev32 {
        rd: WritableReg,
        mem: MemArg,
    },
    FpuStoreRev32 {
        rd: Reg,
        mem: MemArg,
    },
    FpuLoadRev64 {
        rd: WritableReg,
        mem: MemArg,
    },
    FpuStoreRev64 {
        rd: Reg,
        mem: MemArg,
    },
    LoadFpuConst32 {
        rd: WritableReg,
        const_data: u32,
    },
    LoadFpuConst64 {
        rd: WritableReg,
        const_data: u64,
    },
    FpuToInt {
        op: FpuToIntOp,
        rd: WritableReg,
        rn: Reg,
    },
    IntToFpu {
        op: IntToFpuOp,
        rd: WritableReg,
        rn: Reg,
    },
    FpuRound {
        op: FpuRoundMode,
        rd: WritableReg,
        rn: Reg,
    },
    FpuVecRRR {
        fpu_op: FPUOp2,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
    },
    Call {
        link: WritableReg,
        info: BoxCallInfo,
    },
    CallInd {
        link: WritableReg,
        info: BoxCallIndInfo,
    },
    Ret {
        link: Reg,
    },
    EpiloguePlaceholder,
    Jump {
        dest: MachLabel,
    },
    CondBr {
        taken: MachLabel,
        not_taken: MachLabel,
        cond: Cond,
    },
    TrapIf {
        cond: Cond,
        trap_code: TrapCode,
    },
    OneWayCondBr {
        target: MachLabel,
        cond: Cond,
    },
    IndirectBr {
        rn: Reg,
        targets: VecMachLabel,
    },
    Debugtrap,
    Trap {
        trap_code: TrapCode,
    },
    JTSequence {
        ridx: Reg,
        targets: VecMachLabel,
    },
    LoadExtNameFar {
        rd: WritableReg,
        name: BoxExternalName,
        offset: i64,
    },
    LoadAddr {
        rd: WritableReg,
        mem: MemArg,
    },
    Loop {
        body: VecMInst,
        cond: Cond,
    },
    CondBreak {
        cond: Cond,
    },
    VirtualSPOffsetAdj {
        offset: i64,
    },
    ValueLabelMarker {
        reg: Reg,
        label: ValueLabel,
    },
    Unwind {
        inst: UnwindInst,
    },
}

/// Internal type ALUOp: defined at src/isa/s390x/inst.isle line 717.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum ALUOp {
    Add32,
    Add32Ext16,
    Add64,
    Add64Ext16,
    Add64Ext32,
    AddLogical32,
    AddLogical64,
    AddLogical64Ext32,
    Sub32,
    Sub32Ext16,
    Sub64,
    Sub64Ext16,
    Sub64Ext32,
    SubLogical32,
    SubLogical64,
    SubLogical64Ext32,
    Mul32,
    Mul32Ext16,
    Mul64,
    Mul64Ext16,
    Mul64Ext32,
    And32,
    And64,
    Orr32,
    Orr64,
    Xor32,
    Xor64,
    AndNot32,
    AndNot64,
    OrrNot32,
    OrrNot64,
    XorNot32,
    XorNot64,
}

/// Internal type UnaryOp: defined at src/isa/s390x/inst.isle line 758.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum UnaryOp {
    Abs32,
    Abs64,
    Abs64Ext32,
    Neg32,
    Neg64,
    Neg64Ext32,
    PopcntByte,
    PopcntReg,
    BSwap32,
    BSwap64,
}

/// Internal type ShiftOp: defined at src/isa/s390x/inst.isle line 773.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum ShiftOp {
    RotL32,
    RotL64,
    LShL32,
    LShL64,
    LShR32,
    LShR64,
    AShR32,
    AShR64,
}

/// Internal type RxSBGOp: defined at src/isa/s390x/inst.isle line 786.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum RxSBGOp {
    Insert,
    And,
    Or,
    Xor,
}

/// Internal type CmpOp: defined at src/isa/s390x/inst.isle line 795.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum CmpOp {
    CmpS32,
    CmpS32Ext16,
    CmpS64,
    CmpS64Ext16,
    CmpS64Ext32,
    CmpL32,
    CmpL32Ext16,
    CmpL64,
    CmpL64Ext16,
    CmpL64Ext32,
}

/// Internal type FPUOp1: defined at src/isa/s390x/inst.isle line 810.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FPUOp1 {
    Abs32,
    Abs64,
    Neg32,
    Neg64,
    NegAbs32,
    NegAbs64,
    Sqrt32,
    Sqrt64,
    Cvt32To64,
    Cvt64To32,
}

/// Internal type FPUOp2: defined at src/isa/s390x/inst.isle line 825.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FPUOp2 {
    Add32,
    Add64,
    Sub32,
    Sub64,
    Mul32,
    Mul64,
    Div32,
    Div64,
    Max32,
    Max64,
    Min32,
    Min64,
}

/// Internal type FPUOp3: defined at src/isa/s390x/inst.isle line 842.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FPUOp3 {
    MAdd32,
    MAdd64,
    MSub32,
    MSub64,
}

/// Internal type FpuToIntOp: defined at src/isa/s390x/inst.isle line 851.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FpuToIntOp {
    F32ToU32,
    F32ToI32,
    F32ToU64,
    F32ToI64,
    F64ToU32,
    F64ToI32,
    F64ToU64,
    F64ToI64,
}

/// Internal type IntToFpuOp: defined at src/isa/s390x/inst.isle line 864.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum IntToFpuOp {
    U32ToF32,
    I32ToF32,
    U32ToF64,
    I32ToF64,
    U64ToF32,
    I64ToF32,
    U64ToF64,
    I64ToF64,
}

/// Internal type FpuRoundMode: defined at src/isa/s390x/inst.isle line 878.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FpuRoundMode {
    Minus32,
    Minus64,
    Plus32,
    Plus64,
    Zero32,
    Zero64,
    Nearest32,
    Nearest64,
}

/// Internal type WritableRegPair: defined at src/isa/s390x/inst.isle line 1269.
#[derive(Clone, Debug)]
pub enum WritableRegPair {
    WritableRegPair { hi: WritableReg, lo: WritableReg },
}

/// Internal type RegPair: defined at src/isa/s390x/inst.isle line 1291.
#[derive(Clone, Debug)]
pub enum RegPair {
    RegPair { hi: Reg, lo: Reg },
}

/// Internal type ProducesBool: defined at src/isa/s390x/inst.isle line 2316.
#[derive(Clone, Debug)]
pub enum ProducesBool {
    ProducesBool { producer: ProducesFlags, cond: Cond },
}

// Generated as internal constructor for term output_reg.
pub fn constructor_output_reg<C: Context>(ctx: &mut C, arg0: Reg) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 86.
    let expr0_0 = C::value_reg(ctx, pattern0_0);
    let expr1_0 = C::output(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term output_value.
pub fn constructor_output_value<C: Context>(ctx: &mut C, arg0: Value) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 90.
    let expr0_0 = C::put_in_regs(ctx, pattern0_0);
    let expr1_0 = C::output(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term temp_reg.
pub fn constructor_temp_reg<C: Context>(ctx: &mut C, arg0: Type) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 110.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term lo_reg.
pub fn constructor_lo_reg<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 145.
    let expr0_0 = C::put_in_regs(ctx, pattern0_0);
    let expr1_0: usize = 0;
    let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term side_effect.
pub fn constructor_side_effect<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    if let &SideEffectNoResult::Inst {
        inst: ref pattern1_0,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 402.
        let expr0_0 = C::emit(ctx, pattern1_0);
        let expr1_0 = C::output_none(ctx);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term safepoint.
pub fn constructor_safepoint<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    if let &SideEffectNoResult::Inst {
        inst: ref pattern1_0,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 408.
        let expr0_0 = C::emit_safepoint(ctx, pattern1_0);
        let expr1_0 = C::output_none(ctx);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term produces_flags_get_reg.
pub fn constructor_produces_flags_get_reg<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlagsReturnsReg {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 446.
        return Some(pattern1_1);
    }
    return None;
}

// Generated as internal constructor for term produces_flags_ignore.
pub fn constructor_produces_flags_ignore<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &ProducesFlags::ProducesFlagsReturnsReg {
            inst: ref pattern1_0,
            result: pattern1_1,
        } => {
            // Rule at src/prelude.isle line 451.
            let expr0_0 = ProducesFlags::ProducesFlagsSideEffect {
                inst: pattern1_0.clone(),
            };
            return Some(expr0_0);
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref pattern1_0,
            result: pattern1_1,
        } => {
            // Rule at src/prelude.isle line 453.
            let expr0_0 = ProducesFlags::ProducesFlagsSideEffect {
                inst: pattern1_0.clone(),
            };
            return Some(expr0_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term consumes_flags_concat.
pub fn constructor_consumes_flags_concat<C: Context>(
    ctx: &mut C,
    arg0: &ConsumesFlags,
    arg1: &ConsumesFlags,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    if let &ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        if let &ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: ref pattern3_0,
            result: pattern3_1,
        } = pattern2_0
        {
            // Rule at src/prelude.isle line 460.
            let expr0_0 = C::value_regs(ctx, pattern1_1, pattern3_1);
            let expr1_0 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                inst1: pattern1_0.clone(),
                inst2: pattern3_0.clone(),
                result: expr0_0,
            };
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term with_flags.
pub fn constructor_with_flags<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &ProducesFlags::ProducesFlagsSideEffect {
            inst: ref pattern1_0,
        } => {
            let pattern2_0 = arg1;
            match pattern2_0 {
                &ConsumesFlags::ConsumesFlagsReturnsReg {
                    inst: ref pattern3_0,
                    result: pattern3_1,
                } => {
                    // Rule at src/prelude.isle line 485.
                    let expr0_0 = C::emit(ctx, pattern1_0);
                    let expr1_0 = C::emit(ctx, pattern3_0);
                    let expr2_0 = C::value_reg(ctx, pattern3_1);
                    return Some(expr2_0);
                }
                &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                    inst1: ref pattern3_0,
                    inst2: ref pattern3_1,
                    result: pattern3_2,
                } => {
                    // Rule at src/prelude.isle line 491.
                    let expr0_0 = C::emit(ctx, pattern1_0);
                    let expr1_0 = C::emit(ctx, pattern3_0);
                    let expr2_0 = C::emit(ctx, pattern3_1);
                    return Some(pattern3_2);
                }
                &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                    inst1: ref pattern3_0,
                    inst2: ref pattern3_1,
                    inst3: ref pattern3_2,
                    inst4: ref pattern3_3,
                    result: pattern3_4,
                } => {
                    // Rule at src/prelude.isle line 503.
                    let expr0_0 = C::emit(ctx, pattern1_0);
                    let expr1_0 = C::emit(ctx, pattern3_0);
                    let expr2_0 = C::emit(ctx, pattern3_1);
                    let expr3_0 = C::emit(ctx, pattern3_2);
                    let expr4_0 = C::emit(ctx, pattern3_3);
                    return Some(pattern3_4);
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref pattern1_0,
            result: pattern1_1,
        } => {
            let pattern2_0 = arg1;
            if let &ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
                inst: ref pattern3_0,
                result: pattern3_1,
            } = pattern2_0
            {
                // Rule at src/prelude.isle line 479.
                let expr0_0 = C::emit(ctx, pattern1_0);
                let expr1_0 = C::emit(ctx, pattern3_0);
                let expr2_0 = C::value_regs(ctx, pattern1_1, pattern3_1);
                return Some(expr2_0);
            }
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term with_flags_reg.
pub fn constructor_with_flags_reg<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/prelude.isle line 520.
    let expr0_0 = constructor_with_flags(ctx, pattern0_0, pattern1_0)?;
    let expr1_0: usize = 0;
    let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term mask_amt_reg.
pub fn constructor_mask_amt_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 1040.
        let expr0_0: i64 = -1;
        let expr1_0 = C::mask_amt_imm(ctx, pattern1_0, expr0_0);
        let expr2_0 = C::u8_as_u16(ctx, expr1_0);
        let expr3_0: u8 = 0;
        let expr4_0 = C::uimm16shifted(ctx, expr2_0, expr3_0);
        let expr5_0 = constructor_and_uimm16shifted(ctx, pattern1_0, pattern2_0, expr4_0)?;
        return Some(expr5_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 1043.
        return Some(pattern2_0);
    }
    return None;
}

// Generated as internal constructor for term lower_address.
pub fn constructor_lower_address<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Offset32,
) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(pattern2_0) = C::def_inst(ctx, pattern1_0) {
        let pattern3_0 = C::inst_data(ctx, pattern2_0);
        match &pattern3_0 {
            &InstructionData::UnaryGlobalValue {
                opcode: ref pattern4_0,
                global_value: pattern4_1,
            } => {
                if let &Opcode::SymbolValue = pattern4_0 {
                    if let Some((pattern6_0, pattern6_1, pattern6_2)) =
                        C::symbol_value_data(ctx, pattern4_1)
                    {
                        if let Some(()) = C::reloc_distance_near(ctx, pattern6_1) {
                            let pattern8_0 = arg2;
                            let pattern9_0 = C::i64_from_offset(ctx, pattern8_0);
                            let closure10 = || {
                                return Some(pattern6_2);
                            };
                            if let Some(pattern10_0) = closure10() {
                                if let Some(pattern11_0) =
                                    C::memarg_symbol_offset_sum(ctx, pattern9_0, pattern10_0)
                                {
                                    // Rule at src/isa/s390x/inst.isle line 1136.
                                    let expr0_0 =
                                        C::memarg_symbol(ctx, pattern6_0, pattern11_0, pattern0_0);
                                    return Some(expr0_0);
                                }
                            }
                        }
                    }
                }
            }
            &InstructionData::Binary {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
            } => {
                if let &Opcode::Iadd = pattern4_0 {
                    let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                    let pattern7_0 = arg2;
                    let pattern8_0 = C::i64_from_offset(ctx, pattern7_0);
                    if pattern8_0 == 0 {
                        // Rule at src/isa/s390x/inst.isle line 1133.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = C::memarg_reg_plus_reg(ctx, expr0_0, expr1_0, pattern0_0);
                        return Some(expr2_0);
                    }
                }
            }
            _ => {}
        }
    }
    let pattern2_0 = arg2;
    let pattern3_0 = C::i64_from_offset(ctx, pattern2_0);
    // Rule at src/isa/s390x/inst.isle line 1130.
    let expr0_0 = C::put_in_reg(ctx, pattern1_0);
    let expr1_0 = C::memarg_reg_plus_off(ctx, expr0_0, pattern3_0, pattern0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term stack_addr_impl.
pub fn constructor_stack_addr_impl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: StackSlot,
    arg2: Offset32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1163.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::abi_stackslot_addr(ctx, expr0_0, pattern1_0, pattern2_0);
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term sink_load.
pub fn constructor_sink_load<C: Context>(ctx: &mut C, arg0: Inst) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    if let &InstructionData::Load {
        opcode: ref pattern2_0,
        arg: pattern2_1,
        flags: pattern2_2,
        offset: pattern2_3,
    } = &pattern1_0
    {
        if let &Opcode::Load = pattern2_0 {
            // Rule at src/isa/s390x/inst.isle line 1233.
            let expr0_0 = C::sink_inst(ctx, pattern0_0);
            let expr1_0 = constructor_lower_address(ctx, pattern2_2, pattern2_1, pattern2_3)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term sink_sload16.
pub fn constructor_sink_sload16<C: Context>(ctx: &mut C, arg0: Inst) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    if let &InstructionData::Load {
        opcode: ref pattern2_0,
        arg: pattern2_1,
        flags: pattern2_2,
        offset: pattern2_3,
    } = &pattern1_0
    {
        if let &Opcode::Sload16 = pattern2_0 {
            // Rule at src/isa/s390x/inst.isle line 1240.
            let expr0_0 = C::sink_inst(ctx, pattern0_0);
            let expr1_0 = constructor_lower_address(ctx, pattern2_2, pattern2_1, pattern2_3)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term sink_sload32.
pub fn constructor_sink_sload32<C: Context>(ctx: &mut C, arg0: Inst) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    if let &InstructionData::Load {
        opcode: ref pattern2_0,
        arg: pattern2_1,
        flags: pattern2_2,
        offset: pattern2_3,
    } = &pattern1_0
    {
        if let &Opcode::Sload32 = pattern2_0 {
            // Rule at src/isa/s390x/inst.isle line 1247.
            let expr0_0 = C::sink_inst(ctx, pattern0_0);
            let expr1_0 = constructor_lower_address(ctx, pattern2_2, pattern2_1, pattern2_3)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term sink_uload16.
pub fn constructor_sink_uload16<C: Context>(ctx: &mut C, arg0: Inst) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    if let &InstructionData::Load {
        opcode: ref pattern2_0,
        arg: pattern2_1,
        flags: pattern2_2,
        offset: pattern2_3,
    } = &pattern1_0
    {
        if let &Opcode::Uload16 = pattern2_0 {
            // Rule at src/isa/s390x/inst.isle line 1254.
            let expr0_0 = C::sink_inst(ctx, pattern0_0);
            let expr1_0 = constructor_lower_address(ctx, pattern2_2, pattern2_1, pattern2_3)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term sink_uload32.
pub fn constructor_sink_uload32<C: Context>(ctx: &mut C, arg0: Inst) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    if let &InstructionData::Load {
        opcode: ref pattern2_0,
        arg: pattern2_1,
        flags: pattern2_2,
        offset: pattern2_3,
    } = &pattern1_0
    {
        if let &Opcode::Uload32 = pattern2_0 {
            // Rule at src/isa/s390x/inst.isle line 1261.
            let expr0_0 = C::sink_inst(ctx, pattern0_0);
            let expr1_0 = constructor_lower_address(ctx, pattern2_2, pattern2_1, pattern2_3)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term temp_writable_regpair.
pub fn constructor_temp_writable_regpair<C: Context>(ctx: &mut C) -> Option<WritableRegPair> {
    // Rule at src/isa/s390x/inst.isle line 1274.
    let expr0_0: u8 = 0;
    let expr1_0 = C::writable_gpr(ctx, expr0_0);
    let expr2_0: u8 = 1;
    let expr3_0 = C::writable_gpr(ctx, expr2_0);
    let expr4_0 = WritableRegPair::WritableRegPair {
        hi: expr1_0,
        lo: expr3_0,
    };
    return Some(expr4_0);
}

// Generated as internal constructor for term copy_writable_regpair.
pub fn constructor_copy_writable_regpair<C: Context>(
    ctx: &mut C,
    arg0: &RegPair,
) -> Option<WritableRegPair> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1280.
    let expr0_0 = constructor_temp_writable_regpair(ctx)?;
    return Some(expr0_0);
}

// Generated as internal constructor for term writable_regpair_hi.
pub fn constructor_writable_regpair_hi<C: Context>(
    ctx: &mut C,
    arg0: &WritableRegPair,
) -> Option<WritableReg> {
    let pattern0_0 = arg0;
    if let &WritableRegPair::WritableRegPair {
        hi: pattern1_0,
        lo: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1284.
        return Some(pattern1_0);
    }
    return None;
}

// Generated as internal constructor for term writable_regpair_lo.
pub fn constructor_writable_regpair_lo<C: Context>(
    ctx: &mut C,
    arg0: &WritableRegPair,
) -> Option<WritableReg> {
    let pattern0_0 = arg0;
    if let &WritableRegPair::WritableRegPair {
        hi: pattern1_0,
        lo: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1288.
        return Some(pattern1_1);
    }
    return None;
}

// Generated as internal constructor for term writable_regpair_to_regpair.
pub fn constructor_writable_regpair_to_regpair<C: Context>(
    ctx: &mut C,
    arg0: &WritableRegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    if let &WritableRegPair::WritableRegPair {
        hi: pattern1_0,
        lo: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1295.
        let expr0_0 = C::writable_reg_to_reg(ctx, pattern1_0);
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern1_1);
        let expr2_0 = RegPair::RegPair {
            hi: expr0_0,
            lo: expr1_0,
        };
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term uninitialized_regpair.
pub fn constructor_uninitialized_regpair<C: Context>(ctx: &mut C) -> Option<RegPair> {
    // Rule at src/isa/s390x/inst.isle line 1300.
    let expr0_0 = constructor_temp_writable_regpair(ctx)?;
    let expr1_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term regpair_hi.
pub fn constructor_regpair_hi<C: Context>(ctx: &mut C, arg0: &RegPair) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &RegPair::RegPair {
        hi: pattern1_0,
        lo: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1305.
        return Some(pattern1_0);
    }
    return None;
}

// Generated as internal constructor for term regpair_lo.
pub fn constructor_regpair_lo<C: Context>(ctx: &mut C, arg0: &RegPair) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &RegPair::RegPair {
        hi: pattern1_0,
        lo: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1309.
        return Some(pattern1_1);
    }
    return None;
}

// Generated as internal constructor for term alu_rrr.
pub fn constructor_alu_rrr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1316.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::AluRRR {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
        rm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_rrsimm16.
pub fn constructor_alu_rrsimm16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: i16,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1323.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::AluRRSImm16 {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_rr.
pub fn constructor_alu_rr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1330.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRR {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        rm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_rx.
pub fn constructor_alu_rx<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1337.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRX {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        mem: pattern3_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_rsimm16.
pub fn constructor_alu_rsimm16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: i16,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1344.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRSImm16 {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_rsimm32.
pub fn constructor_alu_rsimm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: i32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1351.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRSImm32 {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_ruimm32.
pub fn constructor_alu_ruimm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: u32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1358.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRUImm32 {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_ruimm16shifted.
pub fn constructor_alu_ruimm16shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: UImm16Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1365.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRUImm16Shifted {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_ruimm32shifted.
pub fn constructor_alu_ruimm32shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: UImm32Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1372.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRUImm32Shifted {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term smul_wide.
pub fn constructor_smul_wide<C: Context>(ctx: &mut C, arg0: Reg, arg1: Reg) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1379.
    let expr0_0 = constructor_temp_writable_regpair(ctx)?;
    let expr1_0 = MInst::SMulWide {
        rn: pattern0_0,
        rm: pattern1_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term umul_wide.
pub fn constructor_umul_wide<C: Context>(ctx: &mut C, arg0: Reg, arg1: Reg) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1386.
    let expr0_0 = constructor_temp_writable_regpair(ctx)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = MInst::Mov64 {
        rd: expr1_0,
        rm: pattern1_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = MInst::UMulWide { rn: pattern0_0 };
    let expr5_0 = C::emit(ctx, &expr4_0);
    let expr6_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr6_0);
}

// Generated as internal constructor for term sdivmod32.
pub fn constructor_sdivmod32<C: Context>(
    ctx: &mut C,
    arg0: &RegPair,
    arg1: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1394.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern0_0)?;
    let expr1_0 = MInst::SDivMod32 { rn: pattern1_0 };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term sdivmod64.
pub fn constructor_sdivmod64<C: Context>(
    ctx: &mut C,
    arg0: &RegPair,
    arg1: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1401.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern0_0)?;
    let expr1_0 = MInst::SDivMod64 { rn: pattern1_0 };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term udivmod32.
pub fn constructor_udivmod32<C: Context>(
    ctx: &mut C,
    arg0: &RegPair,
    arg1: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1408.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern0_0)?;
    let expr1_0 = MInst::UDivMod32 { rn: pattern1_0 };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term udivmod64.
pub fn constructor_udivmod64<C: Context>(
    ctx: &mut C,
    arg0: &RegPair,
    arg1: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1415.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern0_0)?;
    let expr1_0 = MInst::UDivMod64 { rn: pattern1_0 };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term shift_rr.
pub fn constructor_shift_rr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ShiftOp,
    arg2: Reg,
    arg3: u8,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 1422.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::ShiftRR {
        shift_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
        shift_imm: pattern3_0,
        shift_reg: pattern4_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term rxsbg_test.
pub fn constructor_rxsbg_test<C: Context>(
    ctx: &mut C,
    arg0: &RxSBGOp,
    arg1: Reg,
    arg2: Reg,
    arg3: u8,
    arg4: u8,
    arg5: i8,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    let pattern5_0 = arg5;
    // Rule at src/isa/s390x/inst.isle line 1429.
    let expr0_0 = MInst::RxSBGTest {
        op: pattern0_0.clone(),
        rd: pattern1_0,
        rn: pattern2_0,
        start_bit: pattern3_0,
        end_bit: pattern4_0,
        rotate_amt: pattern5_0,
    };
    let expr1_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term unary_rr.
pub fn constructor_unary_rr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &UnaryOp,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1435.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::UnaryRR {
        op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term cmp_rr.
pub fn constructor_cmp_rr<C: Context>(
    ctx: &mut C,
    arg0: &CmpOp,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1442.
    let expr0_0 = MInst::CmpRR {
        op: pattern0_0.clone(),
        rn: pattern1_0,
        rm: pattern2_0,
    };
    let expr1_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term cmp_rx.
pub fn constructor_cmp_rx<C: Context>(
    ctx: &mut C,
    arg0: &CmpOp,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1447.
    let expr0_0 = MInst::CmpRX {
        op: pattern0_0.clone(),
        rn: pattern1_0,
        mem: pattern2_0.clone(),
    };
    let expr1_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term cmp_rsimm16.
pub fn constructor_cmp_rsimm16<C: Context>(
    ctx: &mut C,
    arg0: &CmpOp,
    arg1: Reg,
    arg2: i16,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1452.
    let expr0_0 = MInst::CmpRSImm16 {
        op: pattern0_0.clone(),
        rn: pattern1_0,
        imm: pattern2_0,
    };
    let expr1_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term cmp_rsimm32.
pub fn constructor_cmp_rsimm32<C: Context>(
    ctx: &mut C,
    arg0: &CmpOp,
    arg1: Reg,
    arg2: i32,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1457.
    let expr0_0 = MInst::CmpRSImm32 {
        op: pattern0_0.clone(),
        rn: pattern1_0,
        imm: pattern2_0,
    };
    let expr1_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term cmp_ruimm32.
pub fn constructor_cmp_ruimm32<C: Context>(
    ctx: &mut C,
    arg0: &CmpOp,
    arg1: Reg,
    arg2: u32,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1462.
    let expr0_0 = MInst::CmpRUImm32 {
        op: pattern0_0.clone(),
        rn: pattern1_0,
        imm: pattern2_0,
    };
    let expr1_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term atomic_rmw_impl.
pub fn constructor_atomic_rmw_impl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1467.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::AtomicRmw {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
        mem: pattern3_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term atomic_cas32.
pub fn constructor_atomic_cas32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1474.
    let expr0_0: Type = I32;
    let expr1_0 = constructor_copy_writable_reg(ctx, expr0_0, pattern0_0)?;
    let expr2_0 = MInst::AtomicCas32 {
        rd: expr1_0,
        rn: pattern1_0,
        mem: pattern2_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term atomic_cas64.
pub fn constructor_atomic_cas64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1481.
    let expr0_0: Type = I64;
    let expr1_0 = constructor_copy_writable_reg(ctx, expr0_0, pattern0_0)?;
    let expr2_0 = MInst::AtomicCas64 {
        rd: expr1_0,
        rn: pattern1_0,
        mem: pattern2_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fence_impl.
pub fn constructor_fence_impl<C: Context>(ctx: &mut C) -> Option<SideEffectNoResult> {
    // Rule at src/isa/s390x/inst.isle line 1488.
    let expr0_0 = MInst::Fence;
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term load32.
pub fn constructor_load32<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1493.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::Load32 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term load64.
pub fn constructor_load64<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1500.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::Load64 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term loadrev16.
pub fn constructor_loadrev16<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1507.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::LoadRev16 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term loadrev32.
pub fn constructor_loadrev32<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1514.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::LoadRev32 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term loadrev64.
pub fn constructor_loadrev64<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1521.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::LoadRev64 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term store8.
pub fn constructor_store8<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1528.
    let expr0_0 = MInst::Store8 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store16.
pub fn constructor_store16<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1533.
    let expr0_0 = MInst::Store16 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store32.
pub fn constructor_store32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1538.
    let expr0_0 = MInst::Store32 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store64.
pub fn constructor_store64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1543.
    let expr0_0 = MInst::Store64 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store8_imm.
pub fn constructor_store8_imm<C: Context>(
    ctx: &mut C,
    arg0: u8,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1548.
    let expr0_0 = MInst::StoreImm8 {
        imm: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store16_imm.
pub fn constructor_store16_imm<C: Context>(
    ctx: &mut C,
    arg0: i16,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1553.
    let expr0_0 = MInst::StoreImm16 {
        imm: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store32_simm16.
pub fn constructor_store32_simm16<C: Context>(
    ctx: &mut C,
    arg0: i16,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1558.
    let expr0_0 = MInst::StoreImm32SExt16 {
        imm: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store64_simm16.
pub fn constructor_store64_simm16<C: Context>(
    ctx: &mut C,
    arg0: i16,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1563.
    let expr0_0 = MInst::StoreImm64SExt16 {
        imm: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term storerev16.
pub fn constructor_storerev16<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1568.
    let expr0_0 = MInst::StoreRev16 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term storerev32.
pub fn constructor_storerev32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1573.
    let expr0_0 = MInst::StoreRev32 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term storerev64.
pub fn constructor_storerev64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1578.
    let expr0_0 = MInst::StoreRev64 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_rr.
pub fn constructor_fpu_rr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FPUOp1,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1583.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::FpuRR {
        fpu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpu_rrr.
pub fn constructor_fpu_rrr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FPUOp2,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1590.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::FpuRRR {
        fpu_op: pattern1_0.clone(),
        rd: expr0_0,
        rm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpu_rrrr.
pub fn constructor_fpu_rrrr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FPUOp3,
    arg2: Reg,
    arg3: Reg,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 1597.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::FpuRRRR {
        fpu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern3_0,
        rm: pattern4_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpu_copysign.
pub fn constructor_fpu_copysign<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1604.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::FpuCopysign {
        rd: expr0_0,
        rn: pattern1_0,
        rm: pattern2_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpu_cmp32.
pub fn constructor_fpu_cmp32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1611.
    let expr0_0 = MInst::FpuCmp32 {
        rn: pattern0_0,
        rm: pattern1_0,
    };
    let expr1_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_cmp64.
pub fn constructor_fpu_cmp64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1616.
    let expr0_0 = MInst::FpuCmp64 {
        rn: pattern0_0,
        rm: pattern1_0,
    };
    let expr1_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_to_int.
pub fn constructor_fpu_to_int<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FpuToIntOp,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1621.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::FpuToInt {
        op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
    };
    let expr2_0 = C::writable_reg_to_reg(ctx, expr0_0);
    let expr3_0 = ProducesFlags::ProducesFlagsReturnsReg {
        inst: expr1_0,
        result: expr2_0,
    };
    return Some(expr3_0);
}

// Generated as internal constructor for term int_to_fpu.
pub fn constructor_int_to_fpu<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &IntToFpuOp,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1628.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::IntToFpu {
        op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpu_round.
pub fn constructor_fpu_round<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FpuRoundMode,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1635.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::FpuRound {
        op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpuvec_rrr.
pub fn constructor_fpuvec_rrr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FPUOp2,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1642.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::FpuVecRRR {
        fpu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
        rm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term mov_to_fpr.
pub fn constructor_mov_to_fpr<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1649.
    let expr0_0: Type = F64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::MovToFpr {
        rd: expr1_0,
        rn: pattern0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term mov_from_fpr.
pub fn constructor_mov_from_fpr<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1656.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::MovFromFpr {
        rd: expr1_0,
        rn: pattern0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fpu_load32.
pub fn constructor_fpu_load32<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1663.
    let expr0_0: Type = F32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::FpuLoad32 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fpu_load64.
pub fn constructor_fpu_load64<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1670.
    let expr0_0: Type = F64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::FpuLoad64 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fpu_loadrev32.
pub fn constructor_fpu_loadrev32<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1677.
    let expr0_0: Type = F32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::FpuLoadRev32 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fpu_loadrev64.
pub fn constructor_fpu_loadrev64<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1684.
    let expr0_0: Type = F64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::FpuLoadRev64 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fpu_store32.
pub fn constructor_fpu_store32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1691.
    let expr0_0 = MInst::FpuStore32 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_store64.
pub fn constructor_fpu_store64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1696.
    let expr0_0 = MInst::FpuStore64 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_storerev32.
pub fn constructor_fpu_storerev32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1701.
    let expr0_0 = MInst::FpuStoreRev32 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_storerev64.
pub fn constructor_fpu_storerev64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1706.
    let expr0_0 = MInst::FpuStoreRev64 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term load_ext_name_far.
pub fn constructor_load_ext_name_far<C: Context>(
    ctx: &mut C,
    arg0: ExternalName,
    arg1: i64,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1711.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = C::box_external_name(ctx, pattern0_0);
    let expr3_0 = MInst::LoadExtNameFar {
        rd: expr1_0,
        name: expr2_0,
        offset: pattern1_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term load_addr.
pub fn constructor_load_addr<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1719.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::LoadAddr {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term jump_impl.
pub fn constructor_jump_impl<C: Context>(
    ctx: &mut C,
    arg0: MachLabel,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1726.
    let expr0_0 = MInst::Jump { dest: pattern0_0 };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term cond_br.
pub fn constructor_cond_br<C: Context>(
    ctx: &mut C,
    arg0: MachLabel,
    arg1: MachLabel,
    arg2: &Cond,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1731.
    let expr0_0 = MInst::CondBr {
        taken: pattern0_0,
        not_taken: pattern1_0,
        cond: pattern2_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term oneway_cond_br.
pub fn constructor_oneway_cond_br<C: Context>(
    ctx: &mut C,
    arg0: MachLabel,
    arg1: &Cond,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1736.
    let expr0_0 = MInst::OneWayCondBr {
        target: pattern0_0,
        cond: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term jt_sequence.
pub fn constructor_jt_sequence<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &VecMachLabel,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1741.
    let expr0_0 = MInst::JTSequence {
        ridx: pattern0_0,
        targets: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term drop_flags.
pub fn constructor_drop_flags<C: Context>(ctx: &mut C, arg0: &ProducesFlags) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlagsReturnsReg {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1746.
        let expr0_0 = C::emit(ctx, pattern1_0);
        return Some(pattern1_1);
    }
    return None;
}

// Generated as internal constructor for term push_alu_reg.
pub fn constructor_push_alu_reg<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: &ALUOp,
    arg2: WritableReg,
    arg3: Reg,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    if let Some(pattern3_0) = C::real_reg(ctx, pattern2_0) {
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/s390x/inst.isle line 1785.
        let expr0_0 = MInst::AluRRR {
            alu_op: pattern1_0.clone(),
            rd: pattern3_0,
            rn: pattern4_0,
            rm: pattern5_0,
        };
        let expr1_0 = C::inst_builder_push(ctx, pattern0_0, &expr0_0);
        let expr2_0 = C::writable_reg_to_reg(ctx, pattern3_0);
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term push_alu_uimm32shifted.
pub fn constructor_push_alu_uimm32shifted<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: &ALUOp,
    arg2: WritableReg,
    arg3: Reg,
    arg4: UImm32Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    if let Some(pattern3_0) = C::real_reg(ctx, pattern2_0) {
        let pattern4_0 = arg3;
        let closure5 = || {
            return Some(pattern3_0);
        };
        if let Some(pattern5_0) = closure5() {
            if let Some(()) = C::same_reg(ctx, pattern4_0, pattern5_0) {
                let pattern7_0 = arg4;
                // Rule at src/isa/s390x/inst.isle line 1791.
                let expr0_0 = MInst::AluRUImm32Shifted {
                    alu_op: pattern1_0.clone(),
                    rd: pattern3_0,
                    imm: pattern7_0,
                };
                let expr1_0 = C::inst_builder_push(ctx, pattern0_0, &expr0_0);
                let expr2_0 = C::writable_reg_to_reg(ctx, pattern3_0);
                return Some(expr2_0);
            }
        }
    }
    return None;
}

// Generated as internal constructor for term push_shift.
pub fn constructor_push_shift<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: &ShiftOp,
    arg2: WritableReg,
    arg3: Reg,
    arg4: u8,
    arg5: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    if let Some(pattern3_0) = C::real_reg(ctx, pattern2_0) {
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        let pattern6_0 = arg5;
        // Rule at src/isa/s390x/inst.isle line 1797.
        let expr0_0 = MInst::ShiftRR {
            shift_op: pattern1_0.clone(),
            rd: pattern3_0,
            rn: pattern4_0,
            shift_imm: pattern5_0,
            shift_reg: pattern6_0,
        };
        let expr1_0 = C::inst_builder_push(ctx, pattern0_0, &expr0_0);
        let expr2_0 = C::writable_reg_to_reg(ctx, pattern3_0);
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term push_rxsbg.
pub fn constructor_push_rxsbg<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: &RxSBGOp,
    arg2: WritableReg,
    arg3: Reg,
    arg4: Reg,
    arg5: u8,
    arg6: u8,
    arg7: i8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    if let Some(pattern3_0) = C::real_reg(ctx, pattern2_0) {
        let pattern4_0 = arg3;
        let closure5 = || {
            return Some(pattern3_0);
        };
        if let Some(pattern5_0) = closure5() {
            if let Some(()) = C::same_reg(ctx, pattern4_0, pattern5_0) {
                let pattern7_0 = arg4;
                let pattern8_0 = arg5;
                let pattern9_0 = arg6;
                let pattern10_0 = arg7;
                // Rule at src/isa/s390x/inst.isle line 1804.
                let expr0_0 = MInst::RxSBG {
                    op: pattern1_0.clone(),
                    rd: pattern3_0,
                    rn: pattern7_0,
                    start_bit: pattern8_0,
                    end_bit: pattern9_0,
                    rotate_amt: pattern10_0,
                };
                let expr1_0 = C::inst_builder_push(ctx, pattern0_0, &expr0_0);
                let expr2_0 = C::writable_reg_to_reg(ctx, pattern3_0);
                return Some(expr2_0);
            }
        }
    }
    return None;
}

// Generated as internal constructor for term push_unary.
pub fn constructor_push_unary<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: &UnaryOp,
    arg2: WritableReg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    if let Some(pattern3_0) = C::real_reg(ctx, pattern2_0) {
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 1811.
        let expr0_0 = MInst::UnaryRR {
            op: pattern1_0.clone(),
            rd: pattern3_0,
            rn: pattern4_0,
        };
        let expr1_0 = C::inst_builder_push(ctx, pattern0_0, &expr0_0);
        let expr2_0 = C::writable_reg_to_reg(ctx, pattern3_0);
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term push_atomic_cas32.
pub fn constructor_push_atomic_cas32<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: WritableReg,
    arg2: Reg,
    arg3: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(pattern2_0) = C::real_reg(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 1817.
        let expr0_0 = MInst::AtomicCas32 {
            rd: pattern2_0,
            rn: pattern3_0,
            mem: pattern4_0.clone(),
        };
        let expr1_0 = C::inst_builder_push(ctx, pattern0_0, &expr0_0);
        let expr2_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term push_atomic_cas64.
pub fn constructor_push_atomic_cas64<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: WritableReg,
    arg2: Reg,
    arg3: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(pattern2_0) = C::real_reg(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 1823.
        let expr0_0 = MInst::AtomicCas64 {
            rd: pattern2_0,
            rn: pattern3_0,
            mem: pattern4_0.clone(),
        };
        let expr1_0 = C::inst_builder_push(ctx, pattern0_0, &expr0_0);
        let expr2_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term push_break_if.
pub fn constructor_push_break_if<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: &ProducesFlags,
    arg2: &Cond,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let &ProducesFlags::ProducesFlagsSideEffect {
        inst: ref pattern2_0,
    } = pattern1_0
    {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1829.
        let expr0_0 = C::inst_builder_push(ctx, pattern0_0, pattern2_0);
        let expr1_0 = MInst::CondBreak {
            cond: pattern3_0.clone(),
        };
        let expr2_0 = C::inst_builder_push(ctx, pattern0_0, &expr1_0);
        let expr3_0 = C::invalid_reg(ctx);
        return Some(expr3_0);
    }
    return None;
}

// Generated as internal constructor for term emit_loop.
pub fn constructor_emit_loop<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: &Cond,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1836.
    let expr0_0 = C::inst_builder_finish(ctx, pattern0_0);
    let expr1_0 = MInst::Loop {
        body: expr0_0,
        cond: pattern1_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term emit_mov.
pub fn constructor_emit_mov<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: WritableReg,
    arg2: Reg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1851.
        let expr0_0 = MInst::FpuMove32 {
            rd: pattern2_0,
            rn: pattern3_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1854.
        let expr0_0 = MInst::FpuMove64 {
            rd: pattern2_0,
            rn: pattern3_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1845.
        let expr0_0 = MInst::Mov32 {
            rd: pattern2_0,
            rm: pattern3_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1848.
        let expr0_0 = MInst::Mov64 {
            rd: pattern2_0,
            rm: pattern3_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term copy_writable_reg.
pub fn constructor_copy_writable_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
) -> Option<WritableReg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1859.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = constructor_emit_mov(ctx, pattern0_0, expr0_0, pattern1_0)?;
    return Some(expr0_0);
}

// Generated as internal constructor for term copy_reg.
pub fn constructor_copy_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1866.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term emit_load.
pub fn constructor_emit_load<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: WritableReg,
    arg2: &MemArg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1870.
        let expr0_0 = MInst::Load32 {
            rd: pattern2_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1872.
        let expr0_0 = MInst::Load64 {
            rd: pattern2_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_imm.
pub fn constructor_emit_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: WritableReg,
    arg2: u64,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1928.
        let expr0_0 = C::u64_as_u32(ctx, pattern3_0);
        let expr1_0 = MInst::LoadFpuConst32 {
            rd: pattern2_0,
            const_data: expr0_0,
        };
        let expr2_0 = C::emit(ctx, &expr1_0);
        return Some(expr2_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1933.
        let expr0_0 = MInst::LoadFpuConst64 {
            rd: pattern2_0,
            const_data: pattern3_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if let Some(pattern1_0) = C::fits_in_16(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1882.
        let expr0_0 = C::u64_as_i16(ctx, pattern3_0);
        let expr1_0 = MInst::Mov32SImm16 {
            rd: pattern2_0,
            imm: expr0_0,
        };
        let expr2_0 = C::emit(ctx, &expr1_0);
        return Some(expr2_0);
    }
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        if let Some(pattern4_0) = C::i16_from_u64(ctx, pattern3_0) {
            // Rule at src/isa/s390x/inst.isle line 1886.
            let expr0_0 = MInst::Mov32SImm16 {
                rd: pattern2_0,
                imm: pattern4_0,
            };
            let expr1_0 = C::emit(ctx, &expr0_0);
            return Some(expr1_0);
        }
        // Rule at src/isa/s390x/inst.isle line 1890.
        let expr0_0 = C::u64_as_u32(ctx, pattern3_0);
        let expr1_0 = MInst::Mov32Imm {
            rd: pattern2_0,
            imm: expr0_0,
        };
        let expr2_0 = C::emit(ctx, &expr1_0);
        return Some(expr2_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        if let Some(pattern4_0) = C::u64_nonzero_hipart(ctx, pattern3_0) {
            if let Some(pattern5_0) = C::u64_nonzero_lopart(ctx, pattern3_0) {
                // Rule at src/isa/s390x/inst.isle line 1910.
                let expr0_0 = constructor_emit_imm(ctx, pattern1_0, pattern2_0, pattern4_0)?;
                let expr1_0 = constructor_emit_insert_imm(ctx, pattern2_0, pattern5_0)?;
                return Some(expr1_0);
            }
        }
        if let Some(pattern4_0) = C::i16_from_u64(ctx, pattern3_0) {
            // Rule at src/isa/s390x/inst.isle line 1894.
            let expr0_0 = MInst::Mov64SImm16 {
                rd: pattern2_0,
                imm: pattern4_0,
            };
            let expr1_0 = C::emit(ctx, &expr0_0);
            return Some(expr1_0);
        }
        if let Some(pattern4_0) = C::i32_from_u64(ctx, pattern3_0) {
            // Rule at src/isa/s390x/inst.isle line 1898.
            let expr0_0 = MInst::Mov64SImm32 {
                rd: pattern2_0,
                imm: pattern4_0,
            };
            let expr1_0 = C::emit(ctx, &expr0_0);
            return Some(expr1_0);
        }
        if let Some(pattern4_0) = C::uimm32shifted_from_u64(ctx, pattern3_0) {
            // Rule at src/isa/s390x/inst.isle line 1906.
            let expr0_0 = MInst::Mov64UImm32Shifted {
                rd: pattern2_0,
                imm: pattern4_0,
            };
            let expr1_0 = C::emit(ctx, &expr0_0);
            return Some(expr1_0);
        }
        if let Some(pattern4_0) = C::uimm16shifted_from_u64(ctx, pattern3_0) {
            // Rule at src/isa/s390x/inst.isle line 1902.
            let expr0_0 = MInst::Mov64UImm16Shifted {
                rd: pattern2_0,
                imm: pattern4_0,
            };
            let expr1_0 = C::emit(ctx, &expr0_0);
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term emit_insert_imm.
pub fn constructor_emit_insert_imm<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: u64,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(pattern2_0) = C::uimm32shifted_from_u64(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 1923.
        let expr0_0 = MInst::Insert64UImm32Shifted {
            rd: pattern0_0,
            imm: pattern2_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::uimm16shifted_from_u64(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 1919.
        let expr0_0 = MInst::Insert64UImm16Shifted {
            rd: pattern0_0,
            imm: pattern2_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term imm.
pub fn constructor_imm<C: Context>(ctx: &mut C, arg0: Type, arg1: u64) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1938.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = constructor_emit_imm(ctx, pattern0_0, expr0_0, pattern1_0)?;
    let expr2_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term imm_regpair_lo.
pub fn constructor_imm_regpair_lo<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: u64,
    arg2: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1946.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern2_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_imm(ctx, pattern0_0, expr1_0, pattern1_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term imm_regpair_hi.
pub fn constructor_imm_regpair_hi<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: u64,
    arg2: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1954.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern2_0)?;
    let expr1_0 = constructor_writable_regpair_hi(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_imm(ctx, pattern0_0, expr1_0, pattern1_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term ty_ext32.
pub fn constructor_ty_ext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<Type> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 1964.
        let expr0_0: Type = I32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 1965.
        let expr0_0: Type = I32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 1966.
        let expr0_0: Type = I32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 1967.
        let expr0_0: Type = I64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term ty_ext64.
pub fn constructor_ty_ext64<C: Context>(ctx: &mut C, arg0: Type) -> Option<Type> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 1971.
        let expr0_0: Type = I64;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 1972.
        let expr0_0: Type = I64;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 1973.
        let expr0_0: Type = I64;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 1974.
        let expr0_0: Type = I64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term emit_zext32_reg.
pub fn constructor_emit_zext32_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: Reg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1979.
    let expr0_0: bool = false;
    let expr1_0 = C::ty_bits(ctx, pattern1_0);
    let expr2_0: u8 = 32;
    let expr3_0 = MInst::Extend {
        rd: pattern0_0,
        rn: pattern2_0,
        signed: expr0_0,
        from_bits: expr1_0,
        to_bits: expr2_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term emit_sext32_reg.
pub fn constructor_emit_sext32_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: Reg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1985.
    let expr0_0: bool = true;
    let expr1_0 = C::ty_bits(ctx, pattern1_0);
    let expr2_0: u8 = 32;
    let expr3_0 = MInst::Extend {
        rd: pattern0_0,
        rn: pattern2_0,
        signed: expr0_0,
        from_bits: expr1_0,
        to_bits: expr2_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term emit_zext64_reg.
pub fn constructor_emit_zext64_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: Reg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1991.
    let expr0_0: bool = false;
    let expr1_0 = C::ty_bits(ctx, pattern1_0);
    let expr2_0: u8 = 64;
    let expr3_0 = MInst::Extend {
        rd: pattern0_0,
        rn: pattern2_0,
        signed: expr0_0,
        from_bits: expr1_0,
        to_bits: expr2_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term emit_sext64_reg.
pub fn constructor_emit_sext64_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: Reg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1997.
    let expr0_0: bool = true;
    let expr1_0 = C::ty_bits(ctx, pattern1_0);
    let expr2_0: u8 = 64;
    let expr3_0 = MInst::Extend {
        rd: pattern0_0,
        rn: pattern2_0,
        signed: expr0_0,
        from_bits: expr1_0,
        to_bits: expr2_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term zext32_reg.
pub fn constructor_zext32_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2003.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_zext32_reg(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term sext32_reg.
pub fn constructor_sext32_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2011.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_sext32_reg(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term zext64_reg.
pub fn constructor_zext64_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2019.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_zext64_reg(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term sext64_reg.
pub fn constructor_sext64_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2027.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_sext64_reg(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term emit_zext32_mem.
pub fn constructor_emit_zext32_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: &MemArg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2035.
        let expr0_0 = MInst::Load32ZExt8 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2036.
        let expr0_0 = MInst::Load32ZExt16 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_sext32_mem.
pub fn constructor_emit_sext32_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: &MemArg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2040.
        let expr0_0 = MInst::Load32SExt8 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2041.
        let expr0_0 = MInst::Load32SExt16 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_zext64_mem.
pub fn constructor_emit_zext64_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: &MemArg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2045.
        let expr0_0 = MInst::Load64ZExt8 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2046.
        let expr0_0 = MInst::Load64ZExt16 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I32 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2047.
        let expr0_0 = MInst::Load64ZExt32 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_sext64_mem.
pub fn constructor_emit_sext64_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: &MemArg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2051.
        let expr0_0 = MInst::Load64SExt8 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2052.
        let expr0_0 = MInst::Load64SExt16 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I32 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2053.
        let expr0_0 = MInst::Load64SExt32 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term zext32_mem.
pub fn constructor_zext32_mem<C: Context>(ctx: &mut C, arg0: Type, arg1: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2057.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_zext32_mem(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term sext32_mem.
pub fn constructor_sext32_mem<C: Context>(ctx: &mut C, arg0: Type, arg1: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2064.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_sext32_mem(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term zext64_mem.
pub fn constructor_zext64_mem<C: Context>(ctx: &mut C, arg0: Type, arg1: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2071.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_zext64_mem(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term sext64_mem.
pub fn constructor_sext64_mem<C: Context>(ctx: &mut C, arg0: Type, arg1: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2078.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_sext64_mem(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term emit_put_in_reg_zext32.
pub fn constructor_emit_put_in_reg_zext32<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Value,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::u64_from_value(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2086.
        let expr0_0 = constructor_ty_ext32(ctx, pattern2_0)?;
        let expr1_0 = constructor_emit_imm(ctx, expr0_0, pattern0_0, pattern3_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::fits_in_16(ctx, pattern2_0) {
        if let Some(pattern4_0) = C::sinkable_inst(ctx, pattern1_0) {
            let pattern5_0 = C::inst_data(ctx, pattern4_0);
            if let &InstructionData::Load {
                opcode: ref pattern6_0,
                arg: pattern6_1,
                flags: pattern6_2,
                offset: pattern6_3,
            } = &pattern5_0
            {
                if let &Opcode::Load = pattern6_0 {
                    if let Some(()) = C::bigendian(ctx, pattern6_2) {
                        // Rule at src/isa/s390x/inst.isle line 2088.
                        let expr0_0 = constructor_sink_load(ctx, pattern4_0)?;
                        let expr1_0 =
                            constructor_emit_zext32_mem(ctx, pattern0_0, pattern3_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2090.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_zext32_reg(ctx, pattern0_0, pattern3_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern2_0) {
        // Rule at src/isa/s390x/inst.isle line 2092.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_mov(ctx, pattern3_0, pattern0_0, expr0_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_put_in_reg_sext32.
pub fn constructor_emit_put_in_reg_sext32<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Value,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::u64_from_signed_value(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2097.
        let expr0_0 = constructor_ty_ext32(ctx, pattern2_0)?;
        let expr1_0 = constructor_emit_imm(ctx, expr0_0, pattern0_0, pattern3_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::fits_in_16(ctx, pattern2_0) {
        if let Some(pattern4_0) = C::sinkable_inst(ctx, pattern1_0) {
            let pattern5_0 = C::inst_data(ctx, pattern4_0);
            if let &InstructionData::Load {
                opcode: ref pattern6_0,
                arg: pattern6_1,
                flags: pattern6_2,
                offset: pattern6_3,
            } = &pattern5_0
            {
                if let &Opcode::Load = pattern6_0 {
                    if let Some(()) = C::bigendian(ctx, pattern6_2) {
                        // Rule at src/isa/s390x/inst.isle line 2099.
                        let expr0_0 = constructor_sink_load(ctx, pattern4_0)?;
                        let expr1_0 =
                            constructor_emit_sext32_mem(ctx, pattern0_0, pattern3_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2101.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_sext32_reg(ctx, pattern0_0, pattern3_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern2_0) {
        // Rule at src/isa/s390x/inst.isle line 2103.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_mov(ctx, pattern3_0, pattern0_0, expr0_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_put_in_reg_zext64.
pub fn constructor_emit_put_in_reg_zext64<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Value,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::u64_from_value(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2108.
        let expr0_0 = constructor_ty_ext64(ctx, pattern2_0)?;
        let expr1_0 = constructor_emit_imm(ctx, expr0_0, pattern0_0, pattern3_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::gpr32_ty(ctx, pattern2_0) {
        if let Some(pattern4_0) = C::sinkable_inst(ctx, pattern1_0) {
            let pattern5_0 = C::inst_data(ctx, pattern4_0);
            if let &InstructionData::Load {
                opcode: ref pattern6_0,
                arg: pattern6_1,
                flags: pattern6_2,
                offset: pattern6_3,
            } = &pattern5_0
            {
                if let &Opcode::Load = pattern6_0 {
                    if let Some(()) = C::bigendian(ctx, pattern6_2) {
                        // Rule at src/isa/s390x/inst.isle line 2110.
                        let expr0_0 = constructor_sink_load(ctx, pattern4_0)?;
                        let expr1_0 =
                            constructor_emit_zext64_mem(ctx, pattern0_0, pattern3_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2112.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_zext64_reg(ctx, pattern0_0, pattern3_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::gpr64_ty(ctx, pattern2_0) {
        // Rule at src/isa/s390x/inst.isle line 2114.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_mov(ctx, pattern3_0, pattern0_0, expr0_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_put_in_reg_sext64.
pub fn constructor_emit_put_in_reg_sext64<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Value,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::u64_from_signed_value(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2119.
        let expr0_0 = constructor_ty_ext64(ctx, pattern2_0)?;
        let expr1_0 = constructor_emit_imm(ctx, expr0_0, pattern0_0, pattern3_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::gpr32_ty(ctx, pattern2_0) {
        if let Some(pattern4_0) = C::sinkable_inst(ctx, pattern1_0) {
            let pattern5_0 = C::inst_data(ctx, pattern4_0);
            if let &InstructionData::Load {
                opcode: ref pattern6_0,
                arg: pattern6_1,
                flags: pattern6_2,
                offset: pattern6_3,
            } = &pattern5_0
            {
                if let &Opcode::Load = pattern6_0 {
                    if let Some(()) = C::bigendian(ctx, pattern6_2) {
                        // Rule at src/isa/s390x/inst.isle line 2121.
                        let expr0_0 = constructor_sink_load(ctx, pattern4_0)?;
                        let expr1_0 =
                            constructor_emit_sext64_mem(ctx, pattern0_0, pattern3_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2123.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_sext64_reg(ctx, pattern0_0, pattern3_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::gpr64_ty(ctx, pattern2_0) {
        // Rule at src/isa/s390x/inst.isle line 2125.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_mov(ctx, pattern3_0, pattern0_0, expr0_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_zext32.
pub fn constructor_put_in_reg_zext32<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::u64_from_value(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2130.
        let expr0_0 = constructor_ty_ext32(ctx, pattern1_0)?;
        let expr1_0 = constructor_imm(ctx, expr0_0, pattern2_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::fits_in_16(ctx, pattern1_0) {
        if let Some(pattern3_0) = C::sinkable_inst(ctx, pattern0_0) {
            let pattern4_0 = C::inst_data(ctx, pattern3_0);
            if let &InstructionData::Load {
                opcode: ref pattern5_0,
                arg: pattern5_1,
                flags: pattern5_2,
                offset: pattern5_3,
            } = &pattern4_0
            {
                if let &Opcode::Load = pattern5_0 {
                    if let Some(()) = C::bigendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/inst.isle line 2132.
                        let expr0_0 = constructor_sink_load(ctx, pattern3_0)?;
                        let expr1_0 = constructor_zext32_mem(ctx, pattern2_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2134.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0 = constructor_zext32_reg(ctx, pattern2_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::ty_32_or_64(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2136.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_sext32.
pub fn constructor_put_in_reg_sext32<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::u64_from_signed_value(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2141.
        let expr0_0 = constructor_ty_ext32(ctx, pattern1_0)?;
        let expr1_0 = constructor_imm(ctx, expr0_0, pattern2_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::fits_in_16(ctx, pattern1_0) {
        if let Some(pattern3_0) = C::sinkable_inst(ctx, pattern0_0) {
            let pattern4_0 = C::inst_data(ctx, pattern3_0);
            if let &InstructionData::Load {
                opcode: ref pattern5_0,
                arg: pattern5_1,
                flags: pattern5_2,
                offset: pattern5_3,
            } = &pattern4_0
            {
                if let &Opcode::Load = pattern5_0 {
                    if let Some(()) = C::bigendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/inst.isle line 2143.
                        let expr0_0 = constructor_sink_load(ctx, pattern3_0)?;
                        let expr1_0 = constructor_sext32_mem(ctx, pattern2_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2145.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0 = constructor_sext32_reg(ctx, pattern2_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::ty_32_or_64(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2147.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_zext64.
pub fn constructor_put_in_reg_zext64<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::u64_from_value(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2152.
        let expr0_0 = constructor_ty_ext64(ctx, pattern1_0)?;
        let expr1_0 = constructor_imm(ctx, expr0_0, pattern2_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::gpr32_ty(ctx, pattern1_0) {
        if let Some(pattern3_0) = C::sinkable_inst(ctx, pattern0_0) {
            let pattern4_0 = C::inst_data(ctx, pattern3_0);
            if let &InstructionData::Load {
                opcode: ref pattern5_0,
                arg: pattern5_1,
                flags: pattern5_2,
                offset: pattern5_3,
            } = &pattern4_0
            {
                if let &Opcode::Load = pattern5_0 {
                    if let Some(()) = C::bigendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/inst.isle line 2154.
                        let expr0_0 = constructor_sink_load(ctx, pattern3_0)?;
                        let expr1_0 = constructor_zext64_mem(ctx, pattern2_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2156.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0 = constructor_zext64_reg(ctx, pattern2_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::gpr64_ty(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2158.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_sext64.
pub fn constructor_put_in_reg_sext64<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::u64_from_signed_value(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2163.
        let expr0_0 = constructor_ty_ext64(ctx, pattern1_0)?;
        let expr1_0 = constructor_imm(ctx, expr0_0, pattern2_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::gpr32_ty(ctx, pattern1_0) {
        if let Some(pattern3_0) = C::sinkable_inst(ctx, pattern0_0) {
            let pattern4_0 = C::inst_data(ctx, pattern3_0);
            if let &InstructionData::Load {
                opcode: ref pattern5_0,
                arg: pattern5_1,
                flags: pattern5_2,
                offset: pattern5_3,
            } = &pattern4_0
            {
                if let &Opcode::Load = pattern5_0 {
                    if let Some(()) = C::bigendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/inst.isle line 2165.
                        let expr0_0 = constructor_sink_load(ctx, pattern3_0)?;
                        let expr1_0 = constructor_sext64_mem(ctx, pattern2_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2167.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0 = constructor_sext64_reg(ctx, pattern2_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::gpr64_ty(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2169.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_regpair_lo_zext32.
pub fn constructor_put_in_regpair_lo_zext32<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2175.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern1_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_put_in_reg_zext32(ctx, expr1_0, pattern0_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term put_in_regpair_lo_sext32.
pub fn constructor_put_in_regpair_lo_sext32<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2183.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern1_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_put_in_reg_sext32(ctx, expr1_0, pattern0_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term put_in_regpair_lo_zext64.
pub fn constructor_put_in_regpair_lo_zext64<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2191.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern1_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_put_in_reg_zext64(ctx, expr1_0, pattern0_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term put_in_regpair_lo_sext64.
pub fn constructor_put_in_regpair_lo_sext64<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2199.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern1_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_put_in_reg_sext64(ctx, expr1_0, pattern0_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term emit_cmov_imm.
pub fn constructor_emit_cmov_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: WritableReg,
    arg2: &Cond,
    arg3: i16,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2209.
        let expr0_0 = MInst::CMov32SImm16 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            imm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2212.
        let expr0_0 = MInst::CMov64SImm16 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            imm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term cmov_imm.
pub fn constructor_cmov_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Cond,
    arg2: i16,
    arg3: Reg,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 2218.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern3_0)?;
    let expr1_0 = constructor_emit_cmov_imm(ctx, pattern0_0, expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmov_imm_regpair_lo.
pub fn constructor_cmov_imm_regpair_lo<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ProducesFlags,
    arg2: &Cond,
    arg3: i16,
    arg4: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2225.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern4_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_cmov_imm(ctx, pattern0_0, expr1_0, pattern2_0, pattern3_0)?;
    let expr3_0 = constructor_with_flags_reg(ctx, pattern1_0, &expr2_0)?;
    let expr4_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term cmov_imm_regpair_hi.
pub fn constructor_cmov_imm_regpair_hi<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ProducesFlags,
    arg2: &Cond,
    arg3: i16,
    arg4: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2234.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern4_0)?;
    let expr1_0 = constructor_writable_regpair_hi(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_cmov_imm(ctx, pattern0_0, expr1_0, pattern2_0, pattern3_0)?;
    let expr3_0 = constructor_with_flags_reg(ctx, pattern1_0, &expr2_0)?;
    let expr4_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term emit_cmov_reg.
pub fn constructor_emit_cmov_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: WritableReg,
    arg2: &Cond,
    arg3: Reg,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2248.
        let expr0_0 = MInst::FpuCMov32 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            rm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2251.
        let expr0_0 = MInst::FpuCMov64 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            rm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2242.
        let expr0_0 = MInst::CMov32 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            rm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2245.
        let expr0_0 = MInst::CMov64 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            rm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term cmov_reg.
pub fn constructor_cmov_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Cond,
    arg2: Reg,
    arg3: Reg,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 2257.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern3_0)?;
    let expr1_0 = constructor_emit_cmov_reg(ctx, pattern0_0, expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term trap_if.
pub fn constructor_trap_if<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &Cond,
    arg2: &TrapCode,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &ProducesFlags::ProducesFlagsSideEffect {
            inst: ref pattern1_0,
        } => {
            let pattern2_0 = arg1;
            let pattern3_0 = arg2;
            // Rule at src/isa/s390x/inst.isle line 2269.
            let expr0_0 = C::emit(ctx, pattern1_0);
            let expr1_0 = MInst::TrapIf {
                cond: pattern2_0.clone(),
                trap_code: pattern3_0.clone(),
            };
            let expr2_0 = C::emit(ctx, &expr1_0);
            let expr3_0 = C::invalid_reg(ctx);
            return Some(expr3_0);
        }
        &ProducesFlags::ProducesFlagsReturnsReg {
            inst: ref pattern1_0,
            result: pattern1_1,
        } => {
            let pattern2_0 = arg1;
            let pattern3_0 = arg2;
            // Rule at src/isa/s390x/inst.isle line 2265.
            let expr0_0 = C::emit(ctx, pattern1_0);
            let expr1_0 = MInst::TrapIf {
                cond: pattern2_0.clone(),
                trap_code: pattern3_0.clone(),
            };
            let expr2_0 = C::emit(ctx, &expr1_0);
            return Some(pattern1_1);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term icmps_reg_and_trap.
pub fn constructor_icmps_reg_and_trap<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: &Cond,
    arg4: &TrapCode,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2275.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = MInst::CmpTrapRR {
        op: expr0_0,
        rn: pattern1_0,
        rm: pattern2_0,
        cond: pattern3_0.clone(),
        trap_code: pattern4_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::invalid_reg(ctx);
    return Some(expr3_0);
}

// Generated as internal constructor for term icmps_simm16_and_trap.
pub fn constructor_icmps_simm16_and_trap<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i16,
    arg3: &Cond,
    arg4: &TrapCode,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2281.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = MInst::CmpTrapRSImm16 {
        op: expr0_0,
        rn: pattern1_0,
        imm: pattern2_0,
        cond: pattern3_0.clone(),
        trap_code: pattern4_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::invalid_reg(ctx);
    return Some(expr3_0);
}

// Generated as internal constructor for term icmpu_reg_and_trap.
pub fn constructor_icmpu_reg_and_trap<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: &Cond,
    arg4: &TrapCode,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2287.
    let expr0_0 = constructor_cmpop_cmpu(ctx, pattern0_0)?;
    let expr1_0 = MInst::CmpTrapRR {
        op: expr0_0,
        rn: pattern1_0,
        rm: pattern2_0,
        cond: pattern3_0.clone(),
        trap_code: pattern4_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::invalid_reg(ctx);
    return Some(expr3_0);
}

// Generated as internal constructor for term icmpu_uimm16_and_trap.
pub fn constructor_icmpu_uimm16_and_trap<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u16,
    arg3: &Cond,
    arg4: &TrapCode,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2293.
    let expr0_0 = constructor_cmpop_cmpu(ctx, pattern0_0)?;
    let expr1_0 = MInst::CmpTrapRUImm16 {
        op: expr0_0,
        rn: pattern1_0,
        imm: pattern2_0,
        cond: pattern3_0.clone(),
        trap_code: pattern4_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::invalid_reg(ctx);
    return Some(expr3_0);
}

// Generated as internal constructor for term trap_impl.
pub fn constructor_trap_impl<C: Context>(
    ctx: &mut C,
    arg0: &TrapCode,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 2299.
    let expr0_0 = MInst::Trap {
        trap_code: pattern0_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term trap_if_impl.
pub fn constructor_trap_if_impl<C: Context>(
    ctx: &mut C,
    arg0: &Cond,
    arg1: &TrapCode,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2303.
    let expr0_0 = MInst::TrapIf {
        cond: pattern0_0.clone(),
        trap_code: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term debugtrap_impl.
pub fn constructor_debugtrap_impl<C: Context>(ctx: &mut C) -> Option<SideEffectNoResult> {
    // Rule at src/isa/s390x/inst.isle line 2307.
    let expr0_0 = MInst::Debugtrap;
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term bool.
pub fn constructor_bool<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &Cond,
) -> Option<ProducesBool> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2318.
    let expr0_0 = ProducesBool::ProducesBool {
        producer: pattern0_0.clone(),
        cond: pattern1_0.clone(),
    };
    return Some(expr0_0);
}

// Generated as internal constructor for term invert_bool.
pub fn constructor_invert_bool<C: Context>(
    ctx: &mut C,
    arg0: &ProducesBool,
) -> Option<ProducesBool> {
    let pattern0_0 = arg0;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern1_0,
        cond: ref pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 2322.
        let expr0_0 = C::invert_cond(ctx, pattern1_1);
        let expr1_0 = constructor_bool(ctx, pattern1_0, &expr0_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_producer.
pub fn constructor_emit_producer<C: Context>(ctx: &mut C, arg0: &ProducesFlags) -> Option<Unit> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlagsSideEffect {
        inst: ref pattern1_0,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 2331.
        let expr0_0 = C::emit(ctx, pattern1_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term emit_consumer.
pub fn constructor_emit_consumer<C: Context>(ctx: &mut C, arg0: &ConsumesFlags) -> Option<Unit> {
    let pattern0_0 = arg0;
    if let &ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 2333.
        let expr0_0 = C::emit(ctx, pattern1_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term select_bool_reg.
pub fn constructor_select_bool_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ProducesBool,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern2_0,
        cond: ref pattern2_1,
    } = pattern1_0
    {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2337.
        let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
        let expr1_0 = constructor_emit_producer(ctx, pattern2_0)?;
        let expr2_0 = constructor_emit_mov(ctx, pattern0_0, expr0_0, pattern4_0)?;
        let expr3_0 = constructor_emit_cmov_reg(ctx, pattern0_0, expr0_0, pattern2_1, pattern3_0)?;
        let expr4_0 = constructor_emit_consumer(ctx, &expr3_0)?;
        let expr5_0 = C::writable_reg_to_reg(ctx, expr0_0);
        return Some(expr5_0);
    }
    return None;
}

// Generated as internal constructor for term select_bool_imm.
pub fn constructor_select_bool_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ProducesBool,
    arg2: i16,
    arg3: u64,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern2_0,
        cond: ref pattern2_1,
    } = pattern1_0
    {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2346.
        let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
        let expr1_0 = constructor_emit_producer(ctx, pattern2_0)?;
        let expr2_0 = constructor_emit_imm(ctx, pattern0_0, expr0_0, pattern4_0)?;
        let expr3_0 = constructor_emit_cmov_imm(ctx, pattern0_0, expr0_0, pattern2_1, pattern3_0)?;
        let expr4_0 = constructor_emit_consumer(ctx, &expr3_0)?;
        let expr5_0 = C::writable_reg_to_reg(ctx, expr0_0);
        return Some(expr5_0);
    }
    return None;
}

// Generated as internal constructor for term lower_bool.
pub fn constructor_lower_bool<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ProducesBool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == B1 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2356.
        let expr0_0: Type = B1;
        let expr1_0: i16 = 1;
        let expr2_0: u64 = 0;
        let expr3_0 = constructor_select_bool_imm(ctx, expr0_0, pattern2_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    if pattern0_0 == B8 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2357.
        let expr0_0: Type = B8;
        let expr1_0: i16 = -1;
        let expr2_0: u64 = 0;
        let expr3_0 = constructor_select_bool_imm(ctx, expr0_0, pattern2_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    if pattern0_0 == B16 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2358.
        let expr0_0: Type = B16;
        let expr1_0: i16 = -1;
        let expr2_0: u64 = 0;
        let expr3_0 = constructor_select_bool_imm(ctx, expr0_0, pattern2_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    if pattern0_0 == B32 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2359.
        let expr0_0: Type = B32;
        let expr1_0: i16 = -1;
        let expr2_0: u64 = 0;
        let expr3_0 = constructor_select_bool_imm(ctx, expr0_0, pattern2_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    if pattern0_0 == B64 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2360.
        let expr0_0: Type = B64;
        let expr1_0: i16 = -1;
        let expr2_0: u64 = 0;
        let expr3_0 = constructor_select_bool_imm(ctx, expr0_0, pattern2_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    return None;
}

// Generated as internal constructor for term cond_br_bool.
pub fn constructor_cond_br_bool<C: Context>(
    ctx: &mut C,
    arg0: &ProducesBool,
    arg1: MachLabel,
    arg2: MachLabel,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern1_0,
        cond: ref pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2364.
        let expr0_0 = constructor_emit_producer(ctx, pattern1_0)?;
        let expr1_0 = constructor_cond_br(ctx, pattern2_0, pattern3_0, pattern1_1)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term oneway_cond_br_bool.
pub fn constructor_oneway_cond_br_bool<C: Context>(
    ctx: &mut C,
    arg0: &ProducesBool,
    arg1: MachLabel,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern1_0,
        cond: ref pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2370.
        let expr0_0 = constructor_emit_producer(ctx, pattern1_0)?;
        let expr1_0 = constructor_oneway_cond_br(ctx, pattern2_0, pattern1_1)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term trap_if_bool.
pub fn constructor_trap_if_bool<C: Context>(
    ctx: &mut C,
    arg0: &ProducesBool,
    arg1: &TrapCode,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern1_0,
        cond: ref pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2376.
        let expr0_0 = constructor_emit_producer(ctx, pattern1_0)?;
        let expr1_0 = constructor_trap_if_impl(ctx, pattern1_1, pattern2_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term casloop_val_reg.
pub fn constructor_casloop_val_reg<C: Context>(ctx: &mut C) -> Option<WritableReg> {
    // Rule at src/isa/s390x/inst.isle line 2390.
    let expr0_0: u8 = 0;
    let expr1_0 = C::writable_gpr(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term casloop_tmp_reg.
pub fn constructor_casloop_tmp_reg<C: Context>(ctx: &mut C) -> Option<WritableReg> {
    // Rule at src/isa/s390x/inst.isle line 2394.
    let expr0_0: u8 = 1;
    let expr1_0 = C::writable_gpr(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term casloop_emit.
pub fn constructor_casloop_emit<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: Reg,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2403.
    let expr0_0: i64 = 0;
    let expr1_0 = C::memarg_reg_plus_off(ctx, pattern3_0, expr0_0, pattern2_0);
    let expr2_0 = constructor_ty_ext32(ctx, pattern1_0)?;
    let expr3_0 = constructor_casloop_val_reg(ctx)?;
    let expr4_0 =
        constructor_push_atomic_cas(ctx, pattern0_0, expr2_0, expr3_0, pattern4_0, &expr1_0)?;
    let expr5_0 = constructor_ty_ext32(ctx, pattern1_0)?;
    let expr6_0 = constructor_casloop_val_reg(ctx)?;
    let expr7_0 = constructor_emit_load(ctx, expr5_0, expr6_0, &expr1_0)?;
    let expr8_0 = IntCC::NotEqual;
    let expr9_0 = C::intcc_as_cond(ctx, &expr8_0);
    let expr10_0 = constructor_emit_loop(ctx, pattern0_0, &expr9_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term casloop_result.
pub fn constructor_casloop_result<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: MemFlags,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::ty_32_or_64(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if let Some(()) = C::littleendian(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            // Rule at src/isa/s390x/inst.isle line 2421.
            let expr0_0 = constructor_bswap_reg(ctx, pattern1_0, pattern4_0)?;
            return Some(expr0_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            // Rule at src/isa/s390x/inst.isle line 2419.
            let expr0_0 = constructor_copy_reg(ctx, pattern1_0, pattern4_0)?;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term casloop.
pub fn constructor_casloop<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: Reg,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2426.
    let expr0_0 = constructor_casloop_emit(
        ctx, pattern0_0, pattern1_0, pattern2_0, pattern3_0, pattern4_0,
    )?;
    let expr1_0 = constructor_casloop_result(ctx, pattern1_0, pattern2_0, expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term casloop_bitshift.
pub fn constructor_casloop_bitshift<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 2441.
    let expr0_0: Type = I32;
    let expr1_0: u8 = 3;
    let expr2_0 = constructor_lshl_imm(ctx, expr0_0, pattern0_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term casloop_aligned_addr.
pub fn constructor_casloop_aligned_addr<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 2446.
    let expr0_0: Type = I64;
    let expr1_0: u16 = 65532;
    let expr2_0: u8 = 0;
    let expr3_0 = C::uimm16shifted(ctx, expr1_0, expr2_0);
    let expr4_0 = constructor_and_uimm16shifted(ctx, expr0_0, pattern0_0, expr3_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term casloop_rotate_in.
pub fn constructor_casloop_rotate_in<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: Reg,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/s390x/inst.isle line 2456.
        let expr0_0: Type = I32;
        let expr1_0 = constructor_casloop_tmp_reg(ctx)?;
        let expr2_0: u8 = 0;
        let expr3_0 = constructor_push_rot_imm_reg(
            ctx, pattern0_0, expr0_0, expr1_0, pattern5_0, expr2_0, pattern4_0,
        )?;
        return Some(expr3_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        if let Some(()) = C::littleendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            // Rule at src/isa/s390x/inst.isle line 2460.
            let expr0_0: Type = I32;
            let expr1_0 = constructor_casloop_tmp_reg(ctx)?;
            let expr2_0: u8 = 16;
            let expr3_0 = constructor_push_rot_imm_reg(
                ctx, pattern0_0, expr0_0, expr1_0, pattern6_0, expr2_0, pattern5_0,
            )?;
            return Some(expr3_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            // Rule at src/isa/s390x/inst.isle line 2458.
            let expr0_0: Type = I32;
            let expr1_0 = constructor_casloop_tmp_reg(ctx)?;
            let expr2_0: u8 = 0;
            let expr3_0 = constructor_push_rot_imm_reg(
                ctx, pattern0_0, expr0_0, expr1_0, pattern6_0, expr2_0, pattern5_0,
            )?;
            return Some(expr3_0);
        }
    }
    return None;
}

// Generated as internal constructor for term casloop_rotate_out.
pub fn constructor_casloop_rotate_out<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: Reg,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/s390x/inst.isle line 2469.
        let expr0_0: Type = I32;
        let expr1_0 = constructor_casloop_tmp_reg(ctx)?;
        let expr2_0: u8 = 0;
        let expr3_0: Type = I32;
        let expr4_0 = constructor_neg_reg(ctx, expr3_0, pattern4_0)?;
        let expr5_0 = constructor_push_rot_imm_reg(
            ctx, pattern0_0, expr0_0, expr1_0, pattern5_0, expr2_0, expr4_0,
        )?;
        return Some(expr5_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        if let Some(()) = C::littleendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            // Rule at src/isa/s390x/inst.isle line 2473.
            let expr0_0: Type = I32;
            let expr1_0 = constructor_casloop_tmp_reg(ctx)?;
            let expr2_0: u8 = 16;
            let expr3_0 = constructor_push_rot_imm_reg(
                ctx, pattern0_0, expr0_0, expr1_0, pattern6_0, expr2_0, pattern5_0,
            )?;
            return Some(expr3_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            // Rule at src/isa/s390x/inst.isle line 2471.
            let expr0_0: Type = I32;
            let expr1_0 = constructor_casloop_tmp_reg(ctx)?;
            let expr2_0: u8 = 0;
            let expr3_0 = constructor_push_rot_imm_reg(
                ctx, pattern0_0, expr0_0, expr1_0, pattern6_0, expr2_0, pattern5_0,
            )?;
            return Some(expr3_0);
        }
    }
    return None;
}

// Generated as internal constructor for term casloop_rotate_result.
pub fn constructor_casloop_rotate_result<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: MemFlags,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2484.
        let expr0_0: Type = I32;
        let expr1_0: u8 = 8;
        let expr2_0 = constructor_rot_imm_reg(ctx, expr0_0, pattern4_0, expr1_0, pattern3_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I16 {
        let pattern2_0 = arg1;
        if let Some(()) = C::littleendian(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/inst.isle line 2488.
            let expr0_0: Type = I32;
            let expr1_0: Type = I32;
            let expr2_0 = constructor_rot_reg(ctx, expr1_0, pattern5_0, pattern4_0)?;
            let expr3_0 = constructor_bswap_reg(ctx, expr0_0, expr2_0)?;
            return Some(expr3_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/inst.isle line 2486.
            let expr0_0: Type = I32;
            let expr1_0: u8 = 16;
            let expr2_0 = constructor_rot_imm_reg(ctx, expr0_0, pattern5_0, expr1_0, pattern4_0)?;
            return Some(expr2_0);
        }
    }
    return None;
}

// Generated as internal constructor for term casloop_subword.
pub fn constructor_casloop_subword<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: Reg,
    arg4: Reg,
    arg5: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    let pattern5_0 = arg5;
    // Rule at src/isa/s390x/inst.isle line 2493.
    let expr0_0 = constructor_casloop_emit(
        ctx, pattern0_0, pattern1_0, pattern2_0, pattern3_0, pattern5_0,
    )?;
    let expr1_0 =
        constructor_casloop_rotate_result(ctx, pattern1_0, pattern2_0, pattern4_0, expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term clz_reg.
pub fn constructor_clz_reg<C: Context>(ctx: &mut C, arg0: i16, arg1: Reg) -> Option<RegPair> {
    let pattern0_0 = arg0;
    if pattern0_0 == 64 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2504.
        let expr0_0 = constructor_temp_writable_regpair(ctx)?;
        let expr1_0 = MInst::Flogr { rn: pattern2_0 };
        let expr2_0 = C::emit(ctx, &expr1_0);
        let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
        return Some(expr3_0);
    }
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2513.
    let expr0_0 = constructor_temp_writable_regpair(ctx)?;
    let expr1_0 = MInst::Flogr { rn: pattern1_0 };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_hi(ctx, &expr0_0)?;
    let expr4_0 = IntCC::Equal;
    let expr5_0 = C::intcc_as_cond(ctx, &expr4_0);
    let expr6_0 = MInst::CMov64SImm16 {
        rd: expr3_0,
        cond: expr5_0,
        imm: pattern0_0,
    };
    let expr7_0 = C::emit(ctx, &expr6_0);
    let expr8_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr8_0);
}

// Generated as internal constructor for term aluop_add.
pub fn constructor_aluop_add<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 2524.
        let expr0_0 = ALUOp::Add32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2525.
        let expr0_0 = ALUOp::Add32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2526.
        let expr0_0 = ALUOp::Add32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2527.
        let expr0_0 = ALUOp::Add64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_add_sext16.
pub fn constructor_aluop_add_sext16<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2530.
        let expr0_0 = ALUOp::Add32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2531.
        let expr0_0 = ALUOp::Add32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2532.
        let expr0_0 = ALUOp::Add64Ext16;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_add_sext32.
pub fn constructor_aluop_add_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2535.
        let expr0_0 = ALUOp::Add64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term add_reg.
pub fn constructor_add_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2538.
    let expr0_0 = constructor_aluop_add(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_reg_sext32.
pub fn constructor_add_reg_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2541.
    let expr0_0 = constructor_aluop_add_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_simm16.
pub fn constructor_add_simm16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i16,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2544.
    let expr0_0 = constructor_aluop_add(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrsimm16(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_simm32.
pub fn constructor_add_simm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2547.
    let expr0_0 = constructor_aluop_add(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rsimm32(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_mem.
pub fn constructor_add_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2550.
    let expr0_0 = constructor_aluop_add(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_mem_sext16.
pub fn constructor_add_mem_sext16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2553.
    let expr0_0 = constructor_aluop_add_sext16(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_mem_sext32.
pub fn constructor_add_mem_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2556.
    let expr0_0 = constructor_aluop_add_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_add_logical.
pub fn constructor_aluop_add_logical<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2562.
        let expr0_0 = ALUOp::AddLogical32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2563.
        let expr0_0 = ALUOp::AddLogical64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_add_logical_zext32.
pub fn constructor_aluop_add_logical_zext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2566.
        let expr0_0 = ALUOp::AddLogical64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term add_logical_reg.
pub fn constructor_add_logical_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2569.
    let expr0_0 = constructor_aluop_add_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_logical_reg_zext32.
pub fn constructor_add_logical_reg_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2572.
    let expr0_0 = constructor_aluop_add_logical_zext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_logical_zimm32.
pub fn constructor_add_logical_zimm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2575.
    let expr0_0 = constructor_aluop_add_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_ruimm32(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_logical_mem.
pub fn constructor_add_logical_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2578.
    let expr0_0 = constructor_aluop_add_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_logical_mem_zext32.
pub fn constructor_add_logical_mem_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2581.
    let expr0_0 = constructor_aluop_add_logical_zext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_sub.
pub fn constructor_aluop_sub<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 2587.
        let expr0_0 = ALUOp::Sub32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2588.
        let expr0_0 = ALUOp::Sub32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2589.
        let expr0_0 = ALUOp::Sub32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2590.
        let expr0_0 = ALUOp::Sub64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_sub_sext16.
pub fn constructor_aluop_sub_sext16<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2593.
        let expr0_0 = ALUOp::Sub32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2594.
        let expr0_0 = ALUOp::Sub32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2595.
        let expr0_0 = ALUOp::Sub64Ext16;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_sub_sext32.
pub fn constructor_aluop_sub_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2598.
        let expr0_0 = ALUOp::Sub64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sub_reg.
pub fn constructor_sub_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2601.
    let expr0_0 = constructor_aluop_sub(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_reg_sext32.
pub fn constructor_sub_reg_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2604.
    let expr0_0 = constructor_aluop_sub_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_mem.
pub fn constructor_sub_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2607.
    let expr0_0 = constructor_aluop_sub(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_mem_sext16.
pub fn constructor_sub_mem_sext16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2610.
    let expr0_0 = constructor_aluop_sub_sext16(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_mem_sext32.
pub fn constructor_sub_mem_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2613.
    let expr0_0 = constructor_aluop_sub_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_sub_logical.
pub fn constructor_aluop_sub_logical<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2619.
        let expr0_0 = ALUOp::SubLogical32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2620.
        let expr0_0 = ALUOp::SubLogical64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_sub_logical_zext32.
pub fn constructor_aluop_sub_logical_zext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2623.
        let expr0_0 = ALUOp::SubLogical64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sub_logical_reg.
pub fn constructor_sub_logical_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2626.
    let expr0_0 = constructor_aluop_sub_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_logical_reg_zext32.
pub fn constructor_sub_logical_reg_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2629.
    let expr0_0 = constructor_aluop_sub_logical_zext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_logical_zimm32.
pub fn constructor_sub_logical_zimm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2632.
    let expr0_0 = constructor_aluop_sub_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_ruimm32(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_logical_mem.
pub fn constructor_sub_logical_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2635.
    let expr0_0 = constructor_aluop_sub_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_logical_mem_zext32.
pub fn constructor_sub_logical_mem_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2638.
    let expr0_0 = constructor_aluop_sub_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_mul.
pub fn constructor_aluop_mul<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 2644.
        let expr0_0 = ALUOp::Mul32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2645.
        let expr0_0 = ALUOp::Mul32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2646.
        let expr0_0 = ALUOp::Mul32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2647.
        let expr0_0 = ALUOp::Mul64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_mul_sext16.
pub fn constructor_aluop_mul_sext16<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2650.
        let expr0_0 = ALUOp::Mul32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2651.
        let expr0_0 = ALUOp::Mul32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2652.
        let expr0_0 = ALUOp::Mul64Ext16;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_mul_sext32.
pub fn constructor_aluop_mul_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2655.
        let expr0_0 = ALUOp::Mul64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term mul_reg.
pub fn constructor_mul_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2658.
    let expr0_0 = constructor_aluop_mul(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_reg_sext32.
pub fn constructor_mul_reg_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2661.
    let expr0_0 = constructor_aluop_mul_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_simm16.
pub fn constructor_mul_simm16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i16,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2664.
    let expr0_0 = constructor_aluop_mul(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rsimm16(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_simm32.
pub fn constructor_mul_simm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2667.
    let expr0_0 = constructor_aluop_mul(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rsimm32(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_mem.
pub fn constructor_mul_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2670.
    let expr0_0 = constructor_aluop_mul(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_mem_sext16.
pub fn constructor_mul_mem_sext16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2673.
    let expr0_0 = constructor_aluop_mul_sext16(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_mem_sext32.
pub fn constructor_mul_mem_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2676.
    let expr0_0 = constructor_aluop_mul_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term udivmod.
pub fn constructor_udivmod<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &RegPair,
    arg2: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2682.
        let expr0_0 = constructor_udivmod32(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2683.
        let expr0_0 = constructor_udivmod64(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sdivmod.
pub fn constructor_sdivmod<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &RegPair,
    arg2: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2689.
        let expr0_0 = constructor_sdivmod32(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2690.
        let expr0_0 = constructor_sdivmod64(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_and.
pub fn constructor_aluop_and<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2696.
        let expr0_0 = ALUOp::And32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2697.
        let expr0_0 = ALUOp::And64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term and_reg.
pub fn constructor_and_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2700.
    let expr0_0 = constructor_aluop_and(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term and_uimm16shifted.
pub fn constructor_and_uimm16shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: UImm16Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2703.
    let expr0_0 = constructor_aluop_and(ctx, pattern0_0)?;
    let expr1_0 =
        constructor_alu_ruimm16shifted(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term and_uimm32shifted.
pub fn constructor_and_uimm32shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: UImm32Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2706.
    let expr0_0 = constructor_aluop_and(ctx, pattern0_0)?;
    let expr1_0 =
        constructor_alu_ruimm32shifted(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term and_mem.
pub fn constructor_and_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2709.
    let expr0_0 = constructor_aluop_and(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_or.
pub fn constructor_aluop_or<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2715.
        let expr0_0 = ALUOp::Orr32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2716.
        let expr0_0 = ALUOp::Orr64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term or_reg.
pub fn constructor_or_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2719.
    let expr0_0 = constructor_aluop_or(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term or_uimm16shifted.
pub fn constructor_or_uimm16shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: UImm16Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2722.
    let expr0_0 = constructor_aluop_or(ctx, pattern0_0)?;
    let expr1_0 =
        constructor_alu_ruimm16shifted(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term or_uimm32shifted.
pub fn constructor_or_uimm32shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: UImm32Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2725.
    let expr0_0 = constructor_aluop_or(ctx, pattern0_0)?;
    let expr1_0 =
        constructor_alu_ruimm32shifted(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term or_mem.
pub fn constructor_or_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2728.
    let expr0_0 = constructor_aluop_or(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_xor.
pub fn constructor_aluop_xor<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2734.
        let expr0_0 = ALUOp::Xor32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2735.
        let expr0_0 = ALUOp::Xor64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term xor_reg.
pub fn constructor_xor_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2738.
    let expr0_0 = constructor_aluop_xor(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xor_uimm32shifted.
pub fn constructor_xor_uimm32shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: UImm32Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2741.
    let expr0_0 = constructor_aluop_xor(ctx, pattern0_0)?;
    let expr1_0 =
        constructor_alu_ruimm32shifted(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xor_mem.
pub fn constructor_xor_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2744.
    let expr0_0 = constructor_aluop_xor(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term push_xor_uimm32shifted.
pub fn constructor_push_xor_uimm32shifted<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: WritableReg,
    arg3: Reg,
    arg4: UImm32Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2747.
    let expr0_0 = constructor_aluop_xor(ctx, pattern1_0)?;
    let expr1_0 = constructor_push_alu_uimm32shifted(
        ctx, pattern0_0, &expr0_0, pattern2_0, pattern3_0, pattern4_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term not_reg.
pub fn constructor_not_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2753.
        let expr0_0: u32 = 4294967295;
        let expr1_0: u8 = 0;
        let expr2_0 = C::uimm32shifted(ctx, expr0_0, expr1_0);
        let expr3_0 = constructor_xor_uimm32shifted(ctx, pattern1_0, pattern2_0, expr2_0)?;
        return Some(expr3_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2755.
        let expr0_0: u32 = 4294967295;
        let expr1_0: u8 = 0;
        let expr2_0 = C::uimm32shifted(ctx, expr0_0, expr1_0);
        let expr3_0 = constructor_xor_uimm32shifted(ctx, pattern1_0, pattern2_0, expr2_0)?;
        let expr4_0: u32 = 4294967295;
        let expr5_0: u8 = 32;
        let expr6_0 = C::uimm32shifted(ctx, expr4_0, expr5_0);
        let expr7_0 = constructor_xor_uimm32shifted(ctx, pattern1_0, expr3_0, expr6_0)?;
        return Some(expr7_0);
    }
    return None;
}

// Generated as internal constructor for term push_not_reg.
pub fn constructor_push_not_reg<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: WritableReg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(pattern2_0) = C::gpr32_ty(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2761.
        let expr0_0: u32 = 4294967295;
        let expr1_0: u8 = 0;
        let expr2_0 = C::uimm32shifted(ctx, expr0_0, expr1_0);
        let expr3_0 = constructor_push_xor_uimm32shifted(
            ctx, pattern0_0, pattern2_0, pattern3_0, pattern4_0, expr2_0,
        )?;
        return Some(expr3_0);
    }
    if let Some(pattern2_0) = C::gpr64_ty(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2763.
        let expr0_0: u32 = 4294967295;
        let expr1_0: u8 = 0;
        let expr2_0 = C::uimm32shifted(ctx, expr0_0, expr1_0);
        let expr3_0 = constructor_push_xor_uimm32shifted(
            ctx, pattern0_0, pattern2_0, pattern3_0, pattern4_0, expr2_0,
        )?;
        let expr4_0: u32 = 4294967295;
        let expr5_0: u8 = 32;
        let expr6_0 = C::uimm32shifted(ctx, expr4_0, expr5_0);
        let expr7_0 = constructor_push_xor_uimm32shifted(
            ctx, pattern0_0, pattern2_0, pattern3_0, expr3_0, expr6_0,
        )?;
        return Some(expr7_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_and_not.
pub fn constructor_aluop_and_not<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2771.
        let expr0_0 = ALUOp::AndNot32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2772.
        let expr0_0 = ALUOp::AndNot64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term and_not_reg.
pub fn constructor_and_not_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2775.
    let expr0_0 = constructor_aluop_and_not(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_or_not.
pub fn constructor_aluop_or_not<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2781.
        let expr0_0 = ALUOp::OrrNot32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2782.
        let expr0_0 = ALUOp::OrrNot64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term or_not_reg.
pub fn constructor_or_not_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2785.
    let expr0_0 = constructor_aluop_or_not(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_xor_not.
pub fn constructor_aluop_xor_not<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2791.
        let expr0_0 = ALUOp::XorNot32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2792.
        let expr0_0 = ALUOp::XorNot64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term xor_not_reg.
pub fn constructor_xor_not_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2795.
    let expr0_0 = constructor_aluop_xor_not(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term unaryop_abs.
pub fn constructor_unaryop_abs<C: Context>(ctx: &mut C, arg0: Type) -> Option<UnaryOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2801.
        let expr0_0 = UnaryOp::Abs32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2802.
        let expr0_0 = UnaryOp::Abs64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term unaryop_abs_sext32.
pub fn constructor_unaryop_abs_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<UnaryOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2805.
        let expr0_0 = UnaryOp::Abs64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term abs_reg.
pub fn constructor_abs_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2808.
    let expr0_0 = constructor_unaryop_abs(ctx, pattern0_0)?;
    let expr1_0 = constructor_unary_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term abs_reg_sext32.
pub fn constructor_abs_reg_sext32<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2811.
    let expr0_0 = constructor_unaryop_abs_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_unary_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term unaryop_neg.
pub fn constructor_unaryop_neg<C: Context>(ctx: &mut C, arg0: Type) -> Option<UnaryOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 2817.
        let expr0_0 = UnaryOp::Neg32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2818.
        let expr0_0 = UnaryOp::Neg32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2819.
        let expr0_0 = UnaryOp::Neg32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2820.
        let expr0_0 = UnaryOp::Neg64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term unaryop_neg_sext32.
pub fn constructor_unaryop_neg_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<UnaryOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2823.
        let expr0_0 = UnaryOp::Neg64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term neg_reg.
pub fn constructor_neg_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2826.
    let expr0_0 = constructor_unaryop_neg(ctx, pattern0_0)?;
    let expr1_0 = constructor_unary_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term neg_reg_sext32.
pub fn constructor_neg_reg_sext32<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2829.
    let expr0_0 = constructor_unaryop_neg_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_unary_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term unaryop_bswap.
pub fn constructor_unaryop_bswap<C: Context>(ctx: &mut C, arg0: Type) -> Option<UnaryOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2835.
        let expr0_0 = UnaryOp::BSwap32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2836.
        let expr0_0 = UnaryOp::BSwap64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term bswap_reg.
pub fn constructor_bswap_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2839.
    let expr0_0 = constructor_unaryop_bswap(ctx, pattern0_0)?;
    let expr1_0 = constructor_unary_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term push_bswap_reg.
pub fn constructor_push_bswap_reg<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: WritableReg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 2842.
    let expr0_0 = constructor_unaryop_bswap(ctx, pattern1_0)?;
    let expr1_0 = constructor_push_unary(ctx, pattern0_0, &expr0_0, pattern2_0, pattern3_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term shiftop_rot.
pub fn constructor_shiftop_rot<C: Context>(ctx: &mut C, arg0: Type) -> Option<ShiftOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2848.
        let expr0_0 = ShiftOp::RotL32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2849.
        let expr0_0 = ShiftOp::RotL64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term rot_reg.
pub fn constructor_rot_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2852.
    let expr0_0 = constructor_shiftop_rot(ctx, pattern0_0)?;
    let expr1_0: u8 = 0;
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, expr1_0, pattern2_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term rot_imm.
pub fn constructor_rot_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2856.
    let expr0_0 = constructor_shiftop_rot(ctx, pattern0_0)?;
    let expr1_0 = C::zero_reg(ctx);
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term rot_imm_reg.
pub fn constructor_rot_imm_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u8,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 2860.
    let expr0_0 = constructor_shiftop_rot(ctx, pattern0_0)?;
    let expr1_0 = constructor_shift_rr(
        ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0, pattern3_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term push_rot_imm_reg.
pub fn constructor_push_rot_imm_reg<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: WritableReg,
    arg3: Reg,
    arg4: u8,
    arg5: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    let pattern5_0 = arg5;
    // Rule at src/isa/s390x/inst.isle line 2864.
    let expr0_0 = constructor_shiftop_rot(ctx, pattern1_0)?;
    let expr1_0 = constructor_push_shift(
        ctx, pattern0_0, &expr0_0, pattern2_0, pattern3_0, pattern4_0, pattern5_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term shiftop_lshl.
pub fn constructor_shiftop_lshl<C: Context>(ctx: &mut C, arg0: Type) -> Option<ShiftOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 2871.
        let expr0_0 = ShiftOp::LShL32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2872.
        let expr0_0 = ShiftOp::LShL32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2873.
        let expr0_0 = ShiftOp::LShL32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2874.
        let expr0_0 = ShiftOp::LShL64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term lshl_reg.
pub fn constructor_lshl_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2877.
    let expr0_0 = constructor_shiftop_lshl(ctx, pattern0_0)?;
    let expr1_0: u8 = 0;
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, expr1_0, pattern2_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term lshl_imm.
pub fn constructor_lshl_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2881.
    let expr0_0 = constructor_shiftop_lshl(ctx, pattern0_0)?;
    let expr1_0 = C::zero_reg(ctx);
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term shiftop_lshr.
pub fn constructor_shiftop_lshr<C: Context>(ctx: &mut C, arg0: Type) -> Option<ShiftOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2888.
        let expr0_0 = ShiftOp::LShR32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2889.
        let expr0_0 = ShiftOp::LShR64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term lshr_reg.
pub fn constructor_lshr_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2892.
    let expr0_0 = constructor_shiftop_lshr(ctx, pattern0_0)?;
    let expr1_0: u8 = 0;
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, expr1_0, pattern2_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term lshr_imm.
pub fn constructor_lshr_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2896.
    let expr0_0 = constructor_shiftop_lshr(ctx, pattern0_0)?;
    let expr1_0 = C::zero_reg(ctx);
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term shiftop_ashr.
pub fn constructor_shiftop_ashr<C: Context>(ctx: &mut C, arg0: Type) -> Option<ShiftOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2903.
        let expr0_0 = ShiftOp::AShR32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2904.
        let expr0_0 = ShiftOp::AShR64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term ashr_reg.
pub fn constructor_ashr_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2907.
    let expr0_0 = constructor_shiftop_ashr(ctx, pattern0_0)?;
    let expr1_0: u8 = 0;
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, expr1_0, pattern2_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term ashr_imm.
pub fn constructor_ashr_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2911.
    let expr0_0 = constructor_shiftop_ashr(ctx, pattern0_0)?;
    let expr1_0 = C::zero_reg(ctx);
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term popcnt_byte.
pub fn constructor_popcnt_byte<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 2918.
    let expr0_0: Type = I64;
    let expr1_0 = UnaryOp::PopcntByte;
    let expr2_0 = constructor_unary_rr(ctx, expr0_0, &expr1_0, pattern0_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term popcnt_reg.
pub fn constructor_popcnt_reg<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 2921.
    let expr0_0: Type = I64;
    let expr1_0 = UnaryOp::PopcntReg;
    let expr2_0 = constructor_unary_rr(ctx, expr0_0, &expr1_0, pattern0_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term atomic_rmw_and.
pub fn constructor_atomic_rmw_and<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2927.
        let expr0_0: Type = I32;
        let expr1_0 = ALUOp::And32;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2928.
        let expr0_0: Type = I64;
        let expr1_0 = ALUOp::And64;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_or.
pub fn constructor_atomic_rmw_or<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2931.
        let expr0_0: Type = I32;
        let expr1_0 = ALUOp::Orr32;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2932.
        let expr0_0: Type = I64;
        let expr1_0 = ALUOp::Orr64;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_xor.
pub fn constructor_atomic_rmw_xor<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2935.
        let expr0_0: Type = I32;
        let expr1_0 = ALUOp::Xor32;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2936.
        let expr0_0: Type = I64;
        let expr1_0 = ALUOp::Xor64;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_add.
pub fn constructor_atomic_rmw_add<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2939.
        let expr0_0: Type = I32;
        let expr1_0 = ALUOp::Add32;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2940.
        let expr0_0: Type = I64;
        let expr1_0 = ALUOp::Add64;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term atomic_cas_impl.
pub fn constructor_atomic_cas_impl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2946.
        let expr0_0 = constructor_atomic_cas32(ctx, pattern2_0, pattern3_0, pattern4_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2947.
        let expr0_0 = constructor_atomic_cas64(ctx, pattern2_0, pattern3_0, pattern4_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term push_atomic_cas.
pub fn constructor_push_atomic_cas<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: WritableReg,
    arg3: Reg,
    arg4: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I32 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/s390x/inst.isle line 2950.
        let expr0_0 =
            constructor_push_atomic_cas32(ctx, pattern0_0, pattern3_0, pattern4_0, pattern5_0)?;
        return Some(expr0_0);
    }
    if pattern1_0 == I64 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/s390x/inst.isle line 2951.
        let expr0_0 =
            constructor_push_atomic_cas64(ctx, pattern0_0, pattern3_0, pattern4_0, pattern5_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fpuop2_add.
pub fn constructor_fpuop2_add<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2957.
        let expr0_0 = FPUOp2::Add32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2958.
        let expr0_0 = FPUOp2::Add64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fadd_reg.
pub fn constructor_fadd_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2961.
    let expr0_0 = constructor_fpuop2_add(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop2_sub.
pub fn constructor_fpuop2_sub<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2967.
        let expr0_0 = FPUOp2::Sub32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2968.
        let expr0_0 = FPUOp2::Sub64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fsub_reg.
pub fn constructor_fsub_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2971.
    let expr0_0 = constructor_fpuop2_sub(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop2_mul.
pub fn constructor_fpuop2_mul<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2977.
        let expr0_0 = FPUOp2::Mul32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2978.
        let expr0_0 = FPUOp2::Mul64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fmul_reg.
pub fn constructor_fmul_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2981.
    let expr0_0 = constructor_fpuop2_mul(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop2_div.
pub fn constructor_fpuop2_div<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2987.
        let expr0_0 = FPUOp2::Div32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2988.
        let expr0_0 = FPUOp2::Div64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fdiv_reg.
pub fn constructor_fdiv_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2991.
    let expr0_0 = constructor_fpuop2_div(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop2_min.
pub fn constructor_fpuop2_min<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2997.
        let expr0_0 = FPUOp2::Min32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2998.
        let expr0_0 = FPUOp2::Min64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fmin_reg.
pub fn constructor_fmin_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3001.
    let expr0_0 = constructor_fpuop2_min(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpuvec_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop2_max.
pub fn constructor_fpuop2_max<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 3007.
        let expr0_0 = FPUOp2::Max32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 3008.
        let expr0_0 = FPUOp2::Max64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fmax_reg.
pub fn constructor_fmax_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3011.
    let expr0_0 = constructor_fpuop2_max(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpuvec_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop3_fma.
pub fn constructor_fpuop3_fma<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp3> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 3017.
        let expr0_0 = FPUOp3::MAdd32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 3018.
        let expr0_0 = FPUOp3::MAdd64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fma_reg.
pub fn constructor_fma_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 3021.
    let expr0_0 = constructor_fpuop3_fma(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rrrr(
        ctx, pattern0_0, &expr0_0, pattern3_0, pattern1_0, pattern2_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop1_sqrt.
pub fn constructor_fpuop1_sqrt<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp1> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 3027.
        let expr0_0 = FPUOp1::Sqrt32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 3028.
        let expr0_0 = FPUOp1::Sqrt64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sqrt_reg.
pub fn constructor_sqrt_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 3031.
    let expr0_0 = constructor_fpuop1_sqrt(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop1_neg.
pub fn constructor_fpuop1_neg<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp1> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 3037.
        let expr0_0 = FPUOp1::Neg32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 3038.
        let expr0_0 = FPUOp1::Neg64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fneg_reg.
pub fn constructor_fneg_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 3041.
    let expr0_0 = constructor_fpuop1_neg(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop1_abs.
pub fn constructor_fpuop1_abs<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp1> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 3047.
        let expr0_0 = FPUOp1::Abs32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 3048.
        let expr0_0 = FPUOp1::Abs64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fabs_reg.
pub fn constructor_fabs_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 3051.
    let expr0_0 = constructor_fpuop1_abs(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuroundmode_ceil.
pub fn constructor_fpuroundmode_ceil<C: Context>(ctx: &mut C, arg0: Type) -> Option<FpuRoundMode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 3057.
        let expr0_0 = FpuRoundMode::Plus32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 3058.
        let expr0_0 = FpuRoundMode::Plus64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term ceil_reg.
pub fn constructor_ceil_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 3061.
    let expr0_0 = constructor_fpuroundmode_ceil(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_round(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuroundmode_floor.
pub fn constructor_fpuroundmode_floor<C: Context>(ctx: &mut C, arg0: Type) -> Option<FpuRoundMode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 3067.
        let expr0_0 = FpuRoundMode::Minus32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 3068.
        let expr0_0 = FpuRoundMode::Minus64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term floor_reg.
pub fn constructor_floor_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 3071.
    let expr0_0 = constructor_fpuroundmode_floor(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_round(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuroundmode_trunc.
pub fn constructor_fpuroundmode_trunc<C: Context>(ctx: &mut C, arg0: Type) -> Option<FpuRoundMode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 3077.
        let expr0_0 = FpuRoundMode::Zero32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 3078.
        let expr0_0 = FpuRoundMode::Zero64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term trunc_reg.
pub fn constructor_trunc_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 3081.
    let expr0_0 = constructor_fpuroundmode_trunc(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_round(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuroundmode_nearest.
pub fn constructor_fpuroundmode_nearest<C: Context>(
    ctx: &mut C,
    arg0: Type,
) -> Option<FpuRoundMode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 3087.
        let expr0_0 = FpuRoundMode::Nearest32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 3088.
        let expr0_0 = FpuRoundMode::Nearest64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term nearest_reg.
pub fn constructor_nearest_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 3091.
    let expr0_0 = constructor_fpuroundmode_nearest(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_round(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop1_promote.
pub fn constructor_fpuop1_promote<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<FPUOp1> {
    let pattern0_0 = arg0;
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        if pattern2_0 == F32 {
            // Rule at src/isa/s390x/inst.isle line 3097.
            let expr0_0 = FPUOp1::Cvt32To64;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fpromote_reg.
pub fn constructor_fpromote_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3100.
    let expr0_0 = constructor_fpuop1_promote(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_fpu_rr(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop1_demote.
pub fn constructor_fpuop1_demote<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<FPUOp1> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        if pattern2_0 == F64 {
            // Rule at src/isa/s390x/inst.isle line 3107.
            let expr0_0 = FPUOp1::Cvt64To32;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fdemote_reg.
pub fn constructor_fdemote_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3110.
    let expr0_0 = constructor_fpuop1_demote(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_fpu_rr(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term uint_to_fpu_op.
pub fn constructor_uint_to_fpu_op<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<IntToFpuOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        if pattern2_0 == I32 {
            // Rule at src/isa/s390x/inst.isle line 3117.
            let expr0_0 = IntToFpuOp::U32ToF32;
            return Some(expr0_0);
        }
        if pattern2_0 == I64 {
            // Rule at src/isa/s390x/inst.isle line 3119.
            let expr0_0 = IntToFpuOp::U64ToF32;
            return Some(expr0_0);
        }
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        if pattern2_0 == I32 {
            // Rule at src/isa/s390x/inst.isle line 3118.
            let expr0_0 = IntToFpuOp::U32ToF64;
            return Some(expr0_0);
        }
        if pattern2_0 == I64 {
            // Rule at src/isa/s390x/inst.isle line 3120.
            let expr0_0 = IntToFpuOp::U64ToF64;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fcvt_from_uint_reg.
pub fn constructor_fcvt_from_uint_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3123.
    let expr0_0 = constructor_uint_to_fpu_op(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_int_to_fpu(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sint_to_fpu_op.
pub fn constructor_sint_to_fpu_op<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<IntToFpuOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        if pattern2_0 == I32 {
            // Rule at src/isa/s390x/inst.isle line 3130.
            let expr0_0 = IntToFpuOp::I32ToF32;
            return Some(expr0_0);
        }
        if pattern2_0 == I64 {
            // Rule at src/isa/s390x/inst.isle line 3132.
            let expr0_0 = IntToFpuOp::I64ToF32;
            return Some(expr0_0);
        }
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        if pattern2_0 == I32 {
            // Rule at src/isa/s390x/inst.isle line 3131.
            let expr0_0 = IntToFpuOp::I32ToF64;
            return Some(expr0_0);
        }
        if pattern2_0 == I64 {
            // Rule at src/isa/s390x/inst.isle line 3133.
            let expr0_0 = IntToFpuOp::I64ToF64;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fcvt_from_sint_reg.
pub fn constructor_fcvt_from_sint_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3136.
    let expr0_0 = constructor_sint_to_fpu_op(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_int_to_fpu(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_to_uint_op.
pub fn constructor_fpu_to_uint_op<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<FpuToIntOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        if pattern2_0 == F32 {
            // Rule at src/isa/s390x/inst.isle line 3143.
            let expr0_0 = FpuToIntOp::F32ToU32;
            return Some(expr0_0);
        }
        if pattern2_0 == F64 {
            // Rule at src/isa/s390x/inst.isle line 3144.
            let expr0_0 = FpuToIntOp::F64ToU32;
            return Some(expr0_0);
        }
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        if pattern2_0 == F32 {
            // Rule at src/isa/s390x/inst.isle line 3145.
            let expr0_0 = FpuToIntOp::F32ToU64;
            return Some(expr0_0);
        }
        if pattern2_0 == F64 {
            // Rule at src/isa/s390x/inst.isle line 3146.
            let expr0_0 = FpuToIntOp::F64ToU64;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fcvt_to_uint_reg_with_flags.
pub fn constructor_fcvt_to_uint_reg_with_flags<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3149.
    let expr0_0 = constructor_fpu_to_uint_op(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_fpu_to_int(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fcvt_to_uint_reg.
pub fn constructor_fcvt_to_uint_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3153.
    let expr0_0 = constructor_fcvt_to_uint_reg_with_flags(ctx, pattern0_0, pattern1_0, pattern2_0)?;
    let expr1_0 = constructor_drop_flags(ctx, &expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_to_sint_op.
pub fn constructor_fpu_to_sint_op<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<FpuToIntOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        if pattern2_0 == F32 {
            // Rule at src/isa/s390x/inst.isle line 3160.
            let expr0_0 = FpuToIntOp::F32ToI32;
            return Some(expr0_0);
        }
        if pattern2_0 == F64 {
            // Rule at src/isa/s390x/inst.isle line 3161.
            let expr0_0 = FpuToIntOp::F64ToI32;
            return Some(expr0_0);
        }
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        if pattern2_0 == F32 {
            // Rule at src/isa/s390x/inst.isle line 3162.
            let expr0_0 = FpuToIntOp::F32ToI64;
            return Some(expr0_0);
        }
        if pattern2_0 == F64 {
            // Rule at src/isa/s390x/inst.isle line 3163.
            let expr0_0 = FpuToIntOp::F64ToI64;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fcvt_to_sint_reg_with_flags.
pub fn constructor_fcvt_to_sint_reg_with_flags<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3166.
    let expr0_0 = constructor_fpu_to_sint_op(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_fpu_to_int(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fcvt_to_sint_reg.
pub fn constructor_fcvt_to_sint_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3170.
    let expr0_0 = constructor_fcvt_to_sint_reg_with_flags(ctx, pattern0_0, pattern1_0, pattern2_0)?;
    let expr1_0 = constructor_drop_flags(ctx, &expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmpop_cmps.
pub fn constructor_cmpop_cmps<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 3177.
        let expr0_0 = CmpOp::CmpS32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 3178.
        let expr0_0 = CmpOp::CmpS64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term cmpop_cmps_sext16.
pub fn constructor_cmpop_cmps_sext16<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 3181.
        let expr0_0 = CmpOp::CmpS32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 3182.
        let expr0_0 = CmpOp::CmpS64Ext16;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term cmpop_cmps_sext32.
pub fn constructor_cmpop_cmps_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 3185.
        let expr0_0 = CmpOp::CmpS64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term icmps_reg.
pub fn constructor_icmps_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3188.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rr(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_reg_sext32.
pub fn constructor_icmps_reg_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3191.
    let expr0_0 = constructor_cmpop_cmps_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rr(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_simm16.
pub fn constructor_icmps_simm16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i16,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3194.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rsimm16(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_simm32.
pub fn constructor_icmps_simm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i32,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3197.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rsimm32(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_mem.
pub fn constructor_icmps_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3200.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_mem_sext16.
pub fn constructor_icmps_mem_sext16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3203.
    let expr0_0 = constructor_cmpop_cmps_sext16(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_mem_sext32.
pub fn constructor_icmps_mem_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3206.
    let expr0_0 = constructor_cmpop_cmps_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmpop_cmpu.
pub fn constructor_cmpop_cmpu<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 3212.
        let expr0_0 = CmpOp::CmpL32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 3213.
        let expr0_0 = CmpOp::CmpL64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term cmpop_cmpu_zext16.
pub fn constructor_cmpop_cmpu_zext16<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 3216.
        let expr0_0 = CmpOp::CmpL32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 3217.
        let expr0_0 = CmpOp::CmpL64Ext16;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term cmpop_cmpu_zext32.
pub fn constructor_cmpop_cmpu_zext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 3220.
        let expr0_0 = CmpOp::CmpL64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term icmpu_reg.
pub fn constructor_icmpu_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3223.
    let expr0_0 = constructor_cmpop_cmpu(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rr(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmpu_reg_zext32.
pub fn constructor_icmpu_reg_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3226.
    let expr0_0 = constructor_cmpop_cmpu_zext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rr(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmpu_uimm32.
pub fn constructor_icmpu_uimm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u32,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3229.
    let expr0_0 = constructor_cmpop_cmpu(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_ruimm32(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmpu_mem.
pub fn constructor_icmpu_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3232.
    let expr0_0 = constructor_cmpop_cmpu(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmpu_mem_zext16.
pub fn constructor_icmpu_mem_zext16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3235.
    let expr0_0 = constructor_cmpop_cmpu_zext16(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmpu_mem_zext32.
pub fn constructor_icmpu_mem_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 3238.
    let expr0_0 = constructor_cmpop_cmpu_zext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fcmp_reg.
pub fn constructor_fcmp_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 3244.
        let expr0_0 = constructor_fpu_cmp32(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 3245.
        let expr0_0 = constructor_fpu_cmp64(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term lower.
pub fn constructor_lower<C: Context>(ctx: &mut C, arg0: Inst) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    match &pattern1_0 {
        &InstructionData::NullAry {
            opcode: ref pattern2_0,
        } => {
            match pattern2_0 {
                &Opcode::Debugtrap => {
                    // Rule at src/isa/s390x/lower.isle line 2169.
                    let expr0_0 = constructor_debugtrap_impl(ctx)?;
                    let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                &Opcode::Nop => {
                    // Rule at src/isa/s390x/lower.isle line 47.
                    let expr0_0 = C::invalid_reg(ctx);
                    let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                    return Some(expr1_0);
                }
                &Opcode::Fence => {
                    // Rule at src/isa/s390x/lower.isle line 1882.
                    let expr0_0 = constructor_fence_impl(ctx)?;
                    let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                _ => {}
            }
        }
        &InstructionData::FuncAddr {
            opcode: ref pattern2_0,
            func_ref: pattern2_1,
        } => {
            if let &Opcode::FuncAddr = pattern2_0 {
                let (pattern4_0, pattern4_1, pattern4_2) = C::func_ref_data(ctx, pattern2_1);
                if let Some(()) = C::reloc_distance_near(ctx, pattern4_2) {
                    // Rule at src/isa/s390x/lower.isle line 1159.
                    let expr0_0: i32 = 0;
                    let expr1_0 = C::memflags_trusted(ctx);
                    let expr2_0 = C::memarg_symbol(ctx, pattern4_1, expr0_0, expr1_0);
                    let expr3_0 = constructor_load_addr(ctx, &expr2_0)?;
                    let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                    return Some(expr4_0);
                }
                // Rule at src/isa/s390x/lower.isle line 1163.
                let expr0_0: i64 = 0;
                let expr1_0 = constructor_load_ext_name_far(ctx, pattern4_1, expr0_0)?;
                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                return Some(expr2_0);
            }
        }
        &InstructionData::UnaryGlobalValue {
            opcode: ref pattern2_0,
            global_value: pattern2_1,
        } => {
            if let &Opcode::SymbolValue = pattern2_0 {
                if let Some((pattern4_0, pattern4_1, pattern4_2)) =
                    C::symbol_value_data(ctx, pattern2_1)
                {
                    if let Some(()) = C::reloc_distance_near(ctx, pattern4_1) {
                        let pattern6_0 = 0;
                        if let Some(pattern7_0) =
                            C::memarg_symbol_offset_sum(ctx, pattern4_2, pattern6_0)
                        {
                            // Rule at src/isa/s390x/lower.isle line 1170.
                            let expr0_0 = C::memflags_trusted(ctx);
                            let expr1_0 = C::memarg_symbol(ctx, pattern4_0, pattern7_0, expr0_0);
                            let expr2_0 = constructor_load_addr(ctx, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                    }
                    // Rule at src/isa/s390x/lower.isle line 1175.
                    let expr0_0 = constructor_load_ext_name_far(ctx, pattern4_0, pattern4_2)?;
                    let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                    return Some(expr1_0);
                }
            }
        }
        &InstructionData::UnaryIeee32 {
            opcode: ref pattern2_0,
            imm: pattern2_1,
        } => {
            if let &Opcode::F32const = pattern2_0 {
                let pattern4_0 = C::u64_from_ieee32(ctx, pattern2_1);
                // Rule at src/isa/s390x/lower.isle line 29.
                let expr0_0: Type = F32;
                let expr1_0 = constructor_imm(ctx, expr0_0, pattern4_0)?;
                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                return Some(expr2_0);
            }
        }
        &InstructionData::UnaryIeee64 {
            opcode: ref pattern2_0,
            imm: pattern2_1,
        } => {
            if let &Opcode::F64const = pattern2_0 {
                let pattern4_0 = C::u64_from_ieee64(ctx, pattern2_1);
                // Rule at src/isa/s390x/lower.isle line 35.
                let expr0_0: Type = F64;
                let expr1_0 = constructor_imm(ctx, expr0_0, pattern4_0)?;
                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                return Some(expr2_0);
            }
        }
        &InstructionData::Trap {
            opcode: ref pattern2_0,
            code: ref pattern2_1,
        } => {
            match pattern2_0 {
                &Opcode::Trap => {
                    // Rule at src/isa/s390x/lower.isle line 2139.
                    let expr0_0 = constructor_trap_impl(ctx, pattern2_1)?;
                    let expr1_0 = constructor_safepoint(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                &Opcode::ResumableTrap => {
                    // Rule at src/isa/s390x/lower.isle line 2145.
                    let expr0_0 = constructor_trap_impl(ctx, pattern2_1)?;
                    let expr1_0 = constructor_safepoint(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                _ => {}
            }
        }
        &InstructionData::StoreNoOffset {
            opcode: ref pattern2_0,
            args: ref pattern2_1,
            flags: pattern2_2,
        } => {
            if let &Opcode::AtomicStore = pattern2_0 {
                let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, pattern2_1);
                let pattern5_0 = C::value_type(ctx, pattern4_0);
                if pattern5_0 == I8 {
                    // Rule at src/isa/s390x/lower.isle line 1863.
                    let expr0_0 = C::zero_offset(ctx);
                    let expr1_0 =
                        constructor_istore8_impl(ctx, pattern2_2, pattern4_0, pattern4_1, expr0_0)?;
                    let expr2_0 = constructor_atomic_store_impl(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
                if pattern5_0 == I16 {
                    // Rule at src/isa/s390x/lower.isle line 1867.
                    let expr0_0 = C::zero_offset(ctx);
                    let expr1_0 = constructor_istore16_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, expr0_0,
                    )?;
                    let expr2_0 = constructor_atomic_store_impl(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
                if pattern5_0 == I32 {
                    // Rule at src/isa/s390x/lower.isle line 1871.
                    let expr0_0 = C::zero_offset(ctx);
                    let expr1_0 = constructor_istore32_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, expr0_0,
                    )?;
                    let expr2_0 = constructor_atomic_store_impl(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
                if pattern5_0 == I64 {
                    // Rule at src/isa/s390x/lower.isle line 1875.
                    let expr0_0 = C::zero_offset(ctx);
                    let expr1_0 = constructor_istore64_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, expr0_0,
                    )?;
                    let expr2_0 = constructor_atomic_store_impl(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
            }
        }
        &InstructionData::Store {
            opcode: ref pattern2_0,
            args: ref pattern2_1,
            flags: pattern2_2,
            offset: pattern2_3,
        } => {
            match pattern2_0 {
                &Opcode::Store => {
                    let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, pattern2_1);
                    let pattern5_0 = C::value_type(ctx, pattern4_0);
                    if pattern5_0 == I8 {
                        // Rule at src/isa/s390x/lower.isle line 1354.
                        let expr0_0 = constructor_istore8_impl(
                            ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                        )?;
                        let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                        return Some(expr1_0);
                    }
                    if pattern5_0 == I16 {
                        // Rule at src/isa/s390x/lower.isle line 1358.
                        let expr0_0 = constructor_istore16_impl(
                            ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                        )?;
                        let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                        return Some(expr1_0);
                    }
                    if pattern5_0 == I32 {
                        // Rule at src/isa/s390x/lower.isle line 1362.
                        let expr0_0 = constructor_istore32_impl(
                            ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                        )?;
                        let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                        return Some(expr1_0);
                    }
                    if pattern5_0 == I64 {
                        // Rule at src/isa/s390x/lower.isle line 1366.
                        let expr0_0 = constructor_istore64_impl(
                            ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                        )?;
                        let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                        return Some(expr1_0);
                    }
                    if pattern5_0 == R64 {
                        // Rule at src/isa/s390x/lower.isle line 1370.
                        let expr0_0 = constructor_istore64_impl(
                            ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                        )?;
                        let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                        return Some(expr1_0);
                    }
                    if pattern5_0 == F32 {
                        if let Some(()) = C::bigendian(ctx, pattern2_2) {
                            // Rule at src/isa/s390x/lower.isle line 1374.
                            let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern2_2, pattern4_1, pattern2_3)?;
                            let expr2_0 = constructor_fpu_store32(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_side_effect(ctx, &expr2_0)?;
                            return Some(expr3_0);
                        }
                        if let Some(()) = C::vxrs_ext2_enabled(ctx, pattern5_0) {
                            if let Some(()) = C::littleendian(ctx, pattern2_2) {
                                // Rule at src/isa/s390x/lower.isle line 1380.
                                let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern2_2, pattern4_1, pattern2_3,
                                )?;
                                let expr2_0 = constructor_fpu_storerev32(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_side_effect(ctx, &expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                        if let Some(()) = C::vxrs_ext2_disabled(ctx, pattern5_0) {
                            if let Some(()) = C::littleendian(ctx, pattern2_2) {
                                // Rule at src/isa/s390x/lower.isle line 1386.
                                let expr0_0: Type = I64;
                                let expr1_0 = C::put_in_reg(ctx, pattern4_0);
                                let expr2_0 = constructor_mov_from_fpr(ctx, expr1_0)?;
                                let expr3_0: u8 = 32;
                                let expr4_0 = constructor_lshr_imm(ctx, expr0_0, expr2_0, expr3_0)?;
                                let expr5_0 = constructor_lower_address(
                                    ctx, pattern2_2, pattern4_1, pattern2_3,
                                )?;
                                let expr6_0 = constructor_storerev32(ctx, expr4_0, &expr5_0)?;
                                let expr7_0 = constructor_side_effect(ctx, &expr6_0)?;
                                return Some(expr7_0);
                            }
                        }
                    }
                    if pattern5_0 == F64 {
                        if let Some(()) = C::bigendian(ctx, pattern2_2) {
                            // Rule at src/isa/s390x/lower.isle line 1392.
                            let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern2_2, pattern4_1, pattern2_3)?;
                            let expr2_0 = constructor_fpu_store64(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_side_effect(ctx, &expr2_0)?;
                            return Some(expr3_0);
                        }
                        if let Some(()) = C::vxrs_ext2_enabled(ctx, pattern5_0) {
                            if let Some(()) = C::littleendian(ctx, pattern2_2) {
                                // Rule at src/isa/s390x/lower.isle line 1398.
                                let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern2_2, pattern4_1, pattern2_3,
                                )?;
                                let expr2_0 = constructor_fpu_storerev64(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_side_effect(ctx, &expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                        if let Some(()) = C::vxrs_ext2_disabled(ctx, pattern5_0) {
                            if let Some(()) = C::littleendian(ctx, pattern2_2) {
                                // Rule at src/isa/s390x/lower.isle line 1404.
                                let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                                let expr1_0 = constructor_mov_from_fpr(ctx, expr0_0)?;
                                let expr2_0 = constructor_lower_address(
                                    ctx, pattern2_2, pattern4_1, pattern2_3,
                                )?;
                                let expr3_0 = constructor_storerev64(ctx, expr1_0, &expr2_0)?;
                                let expr4_0 = constructor_side_effect(ctx, &expr3_0)?;
                                return Some(expr4_0);
                            }
                        }
                    }
                }
                &Opcode::Istore8 => {
                    let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, pattern2_1);
                    // Rule at src/isa/s390x/lower.isle line 1413.
                    let expr0_0 = constructor_istore8_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                    )?;
                    let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                &Opcode::Istore16 => {
                    let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, pattern2_1);
                    // Rule at src/isa/s390x/lower.isle line 1431.
                    let expr0_0 = constructor_istore16_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                    )?;
                    let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                &Opcode::Istore32 => {
                    let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, pattern2_1);
                    // Rule at src/isa/s390x/lower.isle line 1457.
                    let expr0_0 = constructor_istore32_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                    )?;
                    let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                _ => {}
            }
        }
        &InstructionData::Unary {
            opcode: ref pattern2_0,
            arg: pattern2_1,
        } => {
            match pattern2_0 {
                &Opcode::Copy => {
                    // Rule at src/isa/s390x/lower.isle line 53.
                    let expr0_0 = constructor_output_value(ctx, pattern2_1)?;
                    return Some(expr0_0);
                }
                &Opcode::Breduce => {
                    // Rule at src/isa/s390x/lower.isle line 752.
                    let expr0_0 = constructor_output_value(ctx, pattern2_1)?;
                    return Some(expr0_0);
                }
                &Opcode::Ireduce => {
                    // Rule at src/isa/s390x/lower.isle line 596.
                    let expr0_0 = constructor_output_value(ctx, pattern2_1)?;
                    return Some(expr0_0);
                }
                _ => {}
            }
        }
        &InstructionData::IntCondTrap {
            opcode: ref pattern2_0,
            arg: pattern2_1,
            cond: ref pattern2_2,
            code: ref pattern2_3,
        } => {
            if let &Opcode::Trapif = pattern2_0 {
                if let Some(pattern4_0) = C::def_inst(ctx, pattern2_1) {
                    let pattern5_0 = C::inst_data(ctx, pattern4_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern6_0,
                        args: ref pattern6_1,
                    } = &pattern5_0
                    {
                        match pattern6_0 {
                            &Opcode::Ifcmp => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 2181.
                                let expr0_0: bool = false;
                                let expr1_0 = constructor_icmp_val(
                                    ctx, expr0_0, pattern2_2, pattern8_0, pattern8_1,
                                )?;
                                let expr2_0 = constructor_trap_if_bool(ctx, &expr1_0, pattern2_3)?;
                                let expr3_0 = constructor_safepoint(ctx, &expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::IaddIfcout => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, pattern6_1);
                                if let &IntCC::UnsignedGreaterThan = pattern2_2 {
                                    // Rule at src/isa/s390x/lower.isle line 2206.
                                    let expr0_0: u8 = 3;
                                    let expr1_0 = C::mask_as_cond(ctx, expr0_0);
                                    let expr2_0 =
                                        constructor_trap_if_impl(ctx, &expr1_0, pattern2_3)?;
                                    let expr3_0 = constructor_side_effect(ctx, &expr2_0)?;
                                    return Some(expr3_0);
                                }
                            }
                            _ => {}
                        }
                    }
                }
            }
        }
        &InstructionData::CondTrap {
            opcode: ref pattern2_0,
            arg: pattern2_1,
            code: ref pattern2_2,
        } => {
            match pattern2_0 {
                &Opcode::Trapz => {
                    // Rule at src/isa/s390x/lower.isle line 2151.
                    let expr0_0 = constructor_value_nonzero(ctx, pattern2_1)?;
                    let expr1_0 = constructor_invert_bool(ctx, &expr0_0)?;
                    let expr2_0 = constructor_trap_if_bool(ctx, &expr1_0, pattern2_2)?;
                    let expr3_0 = constructor_safepoint(ctx, &expr2_0)?;
                    return Some(expr3_0);
                }
                &Opcode::Trapnz => {
                    // Rule at src/isa/s390x/lower.isle line 2157.
                    let expr0_0 = constructor_value_nonzero(ctx, pattern2_1)?;
                    let expr1_0 = constructor_trap_if_bool(ctx, &expr0_0, pattern2_2)?;
                    let expr2_0 = constructor_safepoint(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
                &Opcode::ResumableTrapnz => {
                    // Rule at src/isa/s390x/lower.isle line 2163.
                    let expr0_0 = constructor_value_nonzero(ctx, pattern2_1)?;
                    let expr1_0 = constructor_trap_if_bool(ctx, &expr0_0, pattern2_2)?;
                    let expr2_0 = constructor_safepoint(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
                _ => {}
            }
        }
        _ => {}
    }
    if let Some(pattern1_0) = C::first_result(ctx, pattern0_0) {
        let pattern2_0 = C::value_type(ctx, pattern1_0);
        if pattern2_0 == B1 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                match pattern5_0 {
                    &Opcode::IsNull => {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == R64 {
                            // Rule at src/isa/s390x/lower.isle line 2017.
                            let expr0_0: Type = B1;
                            let expr1_0: Type = I64;
                            let expr2_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr3_0: i16 = 0;
                            let expr4_0 = constructor_icmps_simm16(ctx, expr1_0, expr2_0, expr3_0)?;
                            let expr5_0 = IntCC::Equal;
                            let expr6_0 = C::intcc_as_cond(ctx, &expr5_0);
                            let expr7_0 = constructor_bool(ctx, &expr4_0, &expr6_0)?;
                            let expr8_0 = constructor_lower_bool(ctx, expr0_0, &expr7_0)?;
                            let expr9_0 = constructor_output_reg(ctx, expr8_0)?;
                            return Some(expr9_0);
                        }
                    }
                    &Opcode::IsInvalid => {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == R64 {
                            // Rule at src/isa/s390x/lower.isle line 2023.
                            let expr0_0: Type = B1;
                            let expr1_0: Type = I64;
                            let expr2_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr3_0: i16 = -1;
                            let expr4_0 = constructor_icmps_simm16(ctx, expr1_0, expr2_0, expr3_0)?;
                            let expr5_0 = IntCC::Equal;
                            let expr6_0 = C::intcc_as_cond(ctx, &expr5_0);
                            let expr7_0 = constructor_bool(ctx, &expr4_0, &expr6_0)?;
                            let expr8_0 = constructor_lower_bool(ctx, expr0_0, &expr7_0)?;
                            let expr9_0 = constructor_output_reg(ctx, expr8_0)?;
                            return Some(expr9_0);
                        }
                    }
                    _ => {}
                }
            }
        }
        if pattern2_0 == I8 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Popcnt = pattern5_0 {
                        // Rule at src/isa/s390x/lower.isle line 884.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0 = constructor_popcnt_byte(ctx, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
                &InstructionData::LoadNoOffset {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicLoad = pattern5_0 {
                        // Rule at src/isa/s390x/lower.isle line 1826.
                        let expr0_0: Type = I8;
                        let expr1_0 = C::zero_offset(ctx);
                        let expr2_0 =
                            constructor_lower_address(ctx, pattern5_2, pattern5_1, expr1_0)?;
                        let expr3_0 = constructor_zext32_mem(ctx, expr0_0, &expr2_0)?;
                        let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                        return Some(expr4_0);
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = pattern5_0 {
                        // Rule at src/isa/s390x/lower.isle line 1182.
                        let expr0_0: Type = I8;
                        let expr1_0 =
                            constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                        let expr2_0 = constructor_zext32_mem(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I16 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::LoadNoOffset {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicLoad = pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1834.
                            let expr0_0 = C::zero_offset(ctx);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr0_0)?;
                            let expr2_0 = constructor_loadrev16(ctx, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1830.
                            let expr0_0: Type = I16;
                            let expr1_0 = C::zero_offset(ctx);
                            let expr2_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr1_0)?;
                            let expr3_0 = constructor_zext32_mem(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1190.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_loadrev16(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1186.
                            let expr0_0: Type = I16;
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr2_0 = constructor_zext32_mem(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I32 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Umulhi => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 252.
                            let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_reg_zext64(ctx, pattern7_1)?;
                            let expr2_0: Type = I64;
                            let expr3_0 = constructor_mul_reg(ctx, expr2_0, expr0_0, expr1_0)?;
                            let expr4_0: Type = I64;
                            let expr5_0: u8 = 32;
                            let expr6_0 = constructor_lshr_imm(ctx, expr4_0, expr3_0, expr5_0)?;
                            let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                            return Some(expr7_0);
                        }
                        &Opcode::Smulhi => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 274.
                            let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_reg_sext64(ctx, pattern7_1)?;
                            let expr2_0: Type = I64;
                            let expr3_0 = constructor_mul_reg(ctx, expr2_0, expr0_0, expr1_0)?;
                            let expr4_0: Type = I64;
                            let expr5_0: u8 = 32;
                            let expr6_0 = constructor_ashr_imm(ctx, expr4_0, expr3_0, expr5_0)?;
                            let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                            return Some(expr7_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bitcast = pattern5_0 {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == F32 {
                            // Rule at src/isa/s390x/lower.isle line 1145.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr2_0 = constructor_mov_from_fpr(ctx, expr1_0)?;
                            let expr3_0: u8 = 32;
                            let expr4_0 = constructor_lshr_imm(ctx, expr0_0, expr2_0, expr3_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                    }
                }
                &InstructionData::LoadNoOffset {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicLoad = pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1842.
                            let expr0_0 = C::zero_offset(ctx);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr0_0)?;
                            let expr2_0 = constructor_loadrev32(ctx, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1838.
                            let expr0_0 = C::zero_offset(ctx);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr0_0)?;
                            let expr2_0 = constructor_load32(ctx, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1198.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_loadrev32(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1194.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_load32(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I64 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Umulhi => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 259.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_umul_wide(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = I64;
                            let expr4_0 = constructor_regpair_hi(ctx, &expr2_0)?;
                            let expr5_0 = constructor_copy_reg(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = constructor_output_reg(ctx, expr5_0)?;
                            return Some(expr6_0);
                        }
                        &Opcode::Smulhi => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 281.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_smul_wide(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = I64;
                            let expr4_0 = constructor_regpair_hi(ctx, &expr2_0)?;
                            let expr5_0 = constructor_copy_reg(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = constructor_output_reg(ctx, expr5_0)?;
                            return Some(expr6_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bitcast = pattern5_0 {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == F64 {
                            // Rule at src/isa/s390x/lower.isle line 1135.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_mov_from_fpr(ctx, expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
                &InstructionData::LoadNoOffset {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicLoad = pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1850.
                            let expr0_0 = C::zero_offset(ctx);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr0_0)?;
                            let expr2_0 = constructor_loadrev64(ctx, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1846.
                            let expr0_0 = C::zero_offset(ctx);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr0_0)?;
                            let expr2_0 = constructor_load64(ctx, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1206.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_loadrev64(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1202.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_load64(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == R64 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Load {
                opcode: ref pattern5_0,
                arg: pattern5_1,
                flags: pattern5_2,
                offset: pattern5_3,
            } = &pattern4_0
            {
                if let &Opcode::Load = pattern5_0 {
                    if let Some(()) = C::littleendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/lower.isle line 1214.
                        let expr0_0 =
                            constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                        let expr1_0 = constructor_loadrev64(ctx, &expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    if let Some(()) = C::bigendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/lower.isle line 1210.
                        let expr0_0 =
                            constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                        let expr1_0 = constructor_load64(ctx, &expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
            }
        }
        if pattern2_0 == F32 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bitcast = pattern5_0 {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == I32 {
                            // Rule at src/isa/s390x/lower.isle line 1140.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr2_0: u8 = 32;
                            let expr3_0 = constructor_lshl_imm(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0 = constructor_mov_to_fpr(ctx, expr3_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = pattern5_0 {
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1218.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_fpu_load32(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == F64 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bitcast = pattern5_0 {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == I64 {
                            // Rule at src/isa/s390x/lower.isle line 1131.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_mov_to_fpr(ctx, expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = pattern5_0 {
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1233.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_fpu_load64(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
                _ => {}
            }
        }
        let pattern3_0 = C::inst_data(ctx, pattern0_0);
        match &pattern3_0 {
            &InstructionData::NullAry {
                opcode: ref pattern4_0,
            } => {
                if let &Opcode::Null = pattern4_0 {
                    // Rule at src/isa/s390x/lower.isle line 41.
                    let expr0_0: u64 = 0;
                    let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                    let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                    return Some(expr2_0);
                }
            }
            &InstructionData::UnaryImm {
                opcode: ref pattern4_0,
                imm: pattern4_1,
            } => {
                if let &Opcode::Iconst = pattern4_0 {
                    let pattern6_0 = C::u64_from_imm64(ctx, pattern4_1);
                    // Rule at src/isa/s390x/lower.isle line 15.
                    let expr0_0 = constructor_imm(ctx, pattern2_0, pattern6_0)?;
                    let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                    return Some(expr1_0);
                }
            }
            &InstructionData::StackLoad {
                opcode: ref pattern4_0,
                stack_slot: pattern4_1,
                offset: pattern4_2,
            } => {
                if let &Opcode::StackAddr = pattern4_0 {
                    // Rule at src/isa/s390x/lower.isle line 1152.
                    let expr0_0 =
                        constructor_stack_addr_impl(ctx, pattern2_0, pattern4_1, pattern4_2)?;
                    let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                    return Some(expr1_0);
                }
            }
            &InstructionData::UnaryBool {
                opcode: ref pattern4_0,
                imm: pattern4_1,
            } => {
                if let &Opcode::Bconst = pattern4_0 {
                    if pattern4_1 == true {
                        // Rule at src/isa/s390x/lower.isle line 23.
                        let expr0_0: u64 = 1;
                        let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    if pattern4_1 == false {
                        // Rule at src/isa/s390x/lower.isle line 21.
                        let expr0_0: u64 = 0;
                        let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
            }
            &InstructionData::Binary {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
            } => {
                match pattern4_0 {
                    &Opcode::Fadd => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 920.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fadd_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fsub => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 927.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fsub_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fmul => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 934.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fmul_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fdiv => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 941.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fdiv_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fcopysign => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 962.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fpu_copysign(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fmin => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 948.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fmin_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fmax => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 955.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fmax_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    _ => {}
                }
            }
            &InstructionData::FloatCompare {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
                cond: ref pattern4_2,
            } => {
                if let &Opcode::Fcmp = pattern4_0 {
                    let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                    // Rule at src/isa/s390x/lower.isle line 2004.
                    let expr0_0 = constructor_fcmp_val(ctx, pattern4_2, pattern6_0, pattern6_1)?;
                    let expr1_0 = constructor_lower_bool(ctx, pattern2_0, &expr0_0)?;
                    let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                    return Some(expr2_0);
                }
            }
            &InstructionData::IntCompare {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
                cond: ref pattern4_2,
            } => {
                if let &Opcode::Icmp = pattern4_0 {
                    let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                    // Rule at src/isa/s390x/lower.isle line 1915.
                    let expr0_0: bool = true;
                    let expr1_0 =
                        constructor_icmp_val(ctx, expr0_0, pattern4_2, pattern6_0, pattern6_1)?;
                    let expr2_0 = constructor_lower_bool(ctx, pattern2_0, &expr1_0)?;
                    let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                    return Some(expr3_0);
                }
            }
            &InstructionData::Ternary {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
            } => {
                match pattern4_0 {
                    &Opcode::Select => {
                        let (pattern6_0, pattern6_1, pattern6_2) =
                            C::unpack_value_array_3(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 2046.
                        let expr0_0 = constructor_value_nonzero(ctx, pattern6_0)?;
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = C::put_in_reg(ctx, pattern6_2);
                        let expr3_0 = constructor_select_bool_reg(
                            ctx, pattern2_0, &expr0_0, expr1_0, expr2_0,
                        )?;
                        let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                        return Some(expr4_0);
                    }
                    &Opcode::Fma => {
                        let (pattern6_0, pattern6_1, pattern6_2) =
                            C::unpack_value_array_3(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 969.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = C::put_in_reg(ctx, pattern6_2);
                        let expr3_0 =
                            constructor_fma_reg(ctx, pattern2_0, expr0_0, expr1_0, expr2_0)?;
                        let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                        return Some(expr4_0);
                    }
                    _ => {}
                }
            }
            &InstructionData::IntSelect {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
                cond: ref pattern4_2,
            } => {
                if let &Opcode::SelectifSpectreGuard = pattern4_0 {
                    let (pattern6_0, pattern6_1, pattern6_2) =
                        C::unpack_value_array_3(ctx, pattern4_1);
                    if let Some(pattern7_0) = C::def_inst(ctx, pattern6_0) {
                        let pattern8_0 = C::inst_data(ctx, pattern7_0);
                        if let &InstructionData::Binary {
                            opcode: ref pattern9_0,
                            args: ref pattern9_1,
                        } = &pattern8_0
                        {
                            if let &Opcode::Ifcmp = pattern9_0 {
                                let (pattern11_0, pattern11_1) =
                                    C::unpack_value_array_2(ctx, pattern9_1);
                                // Rule at src/isa/s390x/lower.isle line 2058.
                                let expr0_0: bool = false;
                                let expr1_0 = constructor_icmp_val(
                                    ctx,
                                    expr0_0,
                                    pattern4_2,
                                    pattern11_0,
                                    pattern11_1,
                                )?;
                                let expr2_0 = C::put_in_reg(ctx, pattern6_1);
                                let expr3_0 = C::put_in_reg(ctx, pattern6_2);
                                let expr4_0 = constructor_select_bool_reg(
                                    ctx, pattern2_0, &expr1_0, expr2_0, expr3_0,
                                )?;
                                let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                                return Some(expr5_0);
                            }
                        }
                    }
                }
            }
            &InstructionData::Unary {
                opcode: ref pattern4_0,
                arg: pattern4_1,
            } => {
                match pattern4_0 {
                    &Opcode::Sqrt => {
                        // Rule at src/isa/s390x/lower.isle line 976.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_sqrt_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Fneg => {
                        // Rule at src/isa/s390x/lower.isle line 983.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_fneg_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Fabs => {
                        // Rule at src/isa/s390x/lower.isle line 990.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_fabs_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Ceil => {
                        // Rule at src/isa/s390x/lower.isle line 997.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_ceil_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Floor => {
                        // Rule at src/isa/s390x/lower.isle line 1004.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_floor_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Trunc => {
                        // Rule at src/isa/s390x/lower.isle line 1011.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_trunc_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Nearest => {
                        // Rule at src/isa/s390x/lower.isle line 1018.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_nearest_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Bextend => {
                        // Rule at src/isa/s390x/lower.isle line 760.
                        let expr0_0 = constructor_cast_bool(ctx, pattern2_0, pattern4_1)?;
                        let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                        return Some(expr1_0);
                    }
                    &Opcode::Bmask => {
                        // Rule at src/isa/s390x/lower.isle line 762.
                        let expr0_0 = constructor_cast_bool(ctx, pattern2_0, pattern4_1)?;
                        let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                        return Some(expr1_0);
                    }
                    &Opcode::Fpromote => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 1025.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 =
                            constructor_fpromote_reg(ctx, pattern2_0, pattern6_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Fdemote => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 1032.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 =
                            constructor_fdemote_reg(ctx, pattern2_0, pattern6_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::FcvtFromUint => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 1039.
                        let expr0_0 = constructor_ty_ext32(ctx, pattern6_0)?;
                        let expr1_0 = constructor_put_in_reg_zext32(ctx, pattern4_1)?;
                        let expr2_0 =
                            constructor_fcvt_from_uint_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::FcvtFromSint => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 1047.
                        let expr0_0 = constructor_ty_ext32(ctx, pattern6_0)?;
                        let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern4_1)?;
                        let expr2_0 =
                            constructor_fcvt_from_sint_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    _ => {}
                }
            }
            _ => {}
        }
        if let Some(()) = C::mie2_enabled(ctx, pattern2_0) {
            if let Some(pattern4_0) = C::fits_in_64(ctx, pattern2_0) {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                match &pattern5_0 {
                    &InstructionData::Binary {
                        opcode: ref pattern6_0,
                        args: ref pattern6_1,
                    } => {
                        match pattern6_0 {
                            &Opcode::BandNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 702.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_and_not_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::BorNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 713.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_or_not_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::BxorNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 724.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_xor_not_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            _ => {}
                        }
                    }
                    &InstructionData::Ternary {
                        opcode: ref pattern6_0,
                        args: ref pattern6_1,
                    } => {
                        if let &Opcode::Bitselect = pattern6_0 {
                            let (pattern8_0, pattern8_1, pattern8_2) =
                                C::unpack_value_array_3(ctx, pattern6_1);
                            // Rule at src/isa/s390x/lower.isle line 735.
                            let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                            let expr2_0 = constructor_and_reg(ctx, pattern4_0, expr1_0, expr0_0)?;
                            let expr3_0 = C::put_in_reg(ctx, pattern8_2);
                            let expr4_0 =
                                constructor_and_not_reg(ctx, pattern4_0, expr3_0, expr0_0)?;
                            let expr5_0 = constructor_or_reg(ctx, pattern4_0, expr4_0, expr2_0)?;
                            let expr6_0 = constructor_output_reg(ctx, expr5_0)?;
                            return Some(expr6_0);
                        }
                    }
                    &InstructionData::Unary {
                        opcode: ref pattern6_0,
                        arg: pattern6_1,
                    } => {
                        match pattern6_0 {
                            &Opcode::Bnot => {
                                // Rule at src/isa/s390x/lower.isle line 625.
                                let expr0_0 = C::put_in_reg(ctx, pattern6_1);
                                let expr1_0 =
                                    constructor_or_not_reg(ctx, pattern4_0, expr0_0, expr0_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            &Opcode::Popcnt => {
                                // Rule at src/isa/s390x/lower.isle line 889.
                                let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern6_1)?;
                                let expr1_0 = constructor_popcnt_reg(ctx, expr0_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            _ => {}
                        }
                    }
                    _ => {}
                }
            }
        }
        if let Some(()) = C::mie2_disabled(ctx, pattern2_0) {
            if pattern2_0 == I16 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Popcnt = pattern6_0 {
                        // Rule at src/isa/s390x/lower.isle line 898.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr1_0 = constructor_popcnt_byte(ctx, expr0_0)?;
                        let expr2_0: Type = I32;
                        let expr3_0: Type = I32;
                        let expr4_0: u8 = 8;
                        let expr5_0 = constructor_lshl_imm(ctx, expr3_0, expr1_0, expr4_0)?;
                        let expr6_0 = constructor_add_reg(ctx, expr2_0, expr1_0, expr5_0)?;
                        let expr7_0: Type = I32;
                        let expr8_0: u8 = 8;
                        let expr9_0 = constructor_lshr_imm(ctx, expr7_0, expr6_0, expr8_0)?;
                        let expr10_0 = constructor_output_reg(ctx, expr9_0)?;
                        return Some(expr10_0);
                    }
                }
            }
            if pattern2_0 == I32 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Popcnt = pattern6_0 {
                        // Rule at src/isa/s390x/lower.isle line 903.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr1_0 = constructor_popcnt_byte(ctx, expr0_0)?;
                        let expr2_0: Type = I32;
                        let expr3_0: Type = I32;
                        let expr4_0: u8 = 16;
                        let expr5_0 = constructor_lshl_imm(ctx, expr3_0, expr1_0, expr4_0)?;
                        let expr6_0 = constructor_add_reg(ctx, expr2_0, expr1_0, expr5_0)?;
                        let expr7_0: Type = I32;
                        let expr8_0: Type = I32;
                        let expr9_0: u8 = 8;
                        let expr10_0 = constructor_lshl_imm(ctx, expr8_0, expr6_0, expr9_0)?;
                        let expr11_0 = constructor_add_reg(ctx, expr7_0, expr6_0, expr10_0)?;
                        let expr12_0: Type = I32;
                        let expr13_0: u8 = 24;
                        let expr14_0 = constructor_lshr_imm(ctx, expr12_0, expr11_0, expr13_0)?;
                        let expr15_0 = constructor_output_reg(ctx, expr14_0)?;
                        return Some(expr15_0);
                    }
                }
            }
            if pattern2_0 == I64 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Popcnt = pattern6_0 {
                        // Rule at src/isa/s390x/lower.isle line 909.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr1_0 = constructor_popcnt_byte(ctx, expr0_0)?;
                        let expr2_0: Type = I64;
                        let expr3_0: Type = I64;
                        let expr4_0: u8 = 32;
                        let expr5_0 = constructor_lshl_imm(ctx, expr3_0, expr1_0, expr4_0)?;
                        let expr6_0 = constructor_add_reg(ctx, expr2_0, expr1_0, expr5_0)?;
                        let expr7_0: Type = I64;
                        let expr8_0: Type = I64;
                        let expr9_0: u8 = 16;
                        let expr10_0 = constructor_lshl_imm(ctx, expr8_0, expr6_0, expr9_0)?;
                        let expr11_0 = constructor_add_reg(ctx, expr7_0, expr6_0, expr10_0)?;
                        let expr12_0: Type = I64;
                        let expr13_0: Type = I64;
                        let expr14_0: u8 = 8;
                        let expr15_0 = constructor_lshl_imm(ctx, expr13_0, expr11_0, expr14_0)?;
                        let expr16_0 = constructor_add_reg(ctx, expr12_0, expr11_0, expr15_0)?;
                        let expr17_0: Type = I64;
                        let expr18_0: u8 = 56;
                        let expr19_0 = constructor_lshr_imm(ctx, expr17_0, expr16_0, expr18_0)?;
                        let expr20_0 = constructor_output_reg(ctx, expr19_0)?;
                        return Some(expr20_0);
                    }
                }
            }
            if let Some(pattern4_0) = C::fits_in_64(ctx, pattern2_0) {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                match &pattern5_0 {
                    &InstructionData::Binary {
                        opcode: ref pattern6_0,
                        args: ref pattern6_1,
                    } => {
                        match pattern6_0 {
                            &Opcode::BandNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 706.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_and_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = constructor_not_reg(ctx, pattern4_0, expr2_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            &Opcode::BorNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 717.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_or_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = constructor_not_reg(ctx, pattern4_0, expr2_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            &Opcode::BxorNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 728.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_xor_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = constructor_not_reg(ctx, pattern4_0, expr2_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            _ => {}
                        }
                    }
                    &InstructionData::Ternary {
                        opcode: ref pattern6_0,
                        args: ref pattern6_1,
                    } => {
                        if let &Opcode::Bitselect = pattern6_0 {
                            let (pattern8_0, pattern8_1, pattern8_2) =
                                C::unpack_value_array_3(ctx, pattern6_1);
                            // Rule at src/isa/s390x/lower.isle line 742.
                            let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                            let expr2_0 = constructor_and_reg(ctx, pattern4_0, expr1_0, expr0_0)?;
                            let expr3_0 = C::put_in_reg(ctx, pattern8_2);
                            let expr4_0 = constructor_and_reg(ctx, pattern4_0, expr3_0, expr0_0)?;
                            let expr5_0 = constructor_not_reg(ctx, pattern4_0, expr4_0)?;
                            let expr6_0 = constructor_or_reg(ctx, pattern4_0, expr5_0, expr2_0)?;
                            let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                            return Some(expr7_0);
                        }
                    }
                    &InstructionData::Unary {
                        opcode: ref pattern6_0,
                        arg: pattern6_1,
                    } => {
                        if let &Opcode::Bnot = pattern6_0 {
                            // Rule at src/isa/s390x/lower.isle line 630.
                            let expr0_0 = C::put_in_reg(ctx, pattern6_1);
                            let expr1_0 = constructor_not_reg(ctx, pattern4_0, expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                    _ => {}
                }
            }
        }
        if let Some(()) = C::vxrs_ext2_enabled(ctx, pattern2_0) {
            if pattern2_0 == F32 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Load {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                    flags: pattern6_2,
                    offset: pattern6_3,
                } = &pattern5_0
                {
                    if let &Opcode::Load = pattern6_0 {
                        if let Some(()) = C::littleendian(ctx, pattern6_2) {
                            // Rule at src/isa/s390x/lower.isle line 1222.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern6_2, pattern6_1, pattern6_3)?;
                            let expr1_0 = constructor_fpu_loadrev32(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
            }
            if pattern2_0 == F64 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Load {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                    flags: pattern6_2,
                    offset: pattern6_3,
                } = &pattern5_0
                {
                    if let &Opcode::Load = pattern6_0 {
                        if let Some(()) = C::littleendian(ctx, pattern6_2) {
                            // Rule at src/isa/s390x/lower.isle line 1237.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern6_2, pattern6_1, pattern6_3)?;
                            let expr1_0 = constructor_fpu_loadrev64(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
            }
        }
        if let Some(()) = C::vxrs_ext2_disabled(ctx, pattern2_0) {
            if pattern2_0 == F32 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Load {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                    flags: pattern6_2,
                    offset: pattern6_3,
                } = &pattern5_0
                {
                    if let &Opcode::Load = pattern6_0 {
                        if let Some(()) = C::littleendian(ctx, pattern6_2) {
                            // Rule at src/isa/s390x/lower.isle line 1227.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern6_2, pattern6_1, pattern6_3)?;
                            let expr1_0 = constructor_loadrev32(ctx, &expr0_0)?;
                            let expr2_0: Type = I64;
                            let expr3_0: u8 = 32;
                            let expr4_0 = constructor_lshl_imm(ctx, expr2_0, expr1_0, expr3_0)?;
                            let expr5_0 = constructor_mov_to_fpr(ctx, expr4_0)?;
                            let expr6_0 = constructor_output_reg(ctx, expr5_0)?;
                            return Some(expr6_0);
                        }
                    }
                }
            }
            if pattern2_0 == F64 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Load {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                    flags: pattern6_2,
                    offset: pattern6_3,
                } = &pattern5_0
                {
                    if let &Opcode::Load = pattern6_0 {
                        if let Some(()) = C::littleendian(ctx, pattern6_2) {
                            // Rule at src/isa/s390x/lower.isle line 1242.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern6_2, pattern6_1, pattern6_3)?;
                            let expr1_0 = constructor_loadrev64(ctx, &expr0_0)?;
                            let expr2_0 = constructor_mov_to_fpr(ctx, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                    }
                }
            }
        }
        if let Some(pattern3_0) = C::fits_in_16(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Bint = pattern5_0 {
                    // Rule at src/isa/s390x/lower.isle line 796.
                    let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                    let expr1_0: u16 = 1;
                    let expr2_0: u8 = 0;
                    let expr3_0 = C::uimm16shifted(ctx, expr1_0, expr2_0);
                    let expr4_0 = constructor_and_uimm16shifted(ctx, pattern3_0, expr0_0, expr3_0)?;
                    let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                    return Some(expr5_0);
                }
            }
        }
        if let Some(pattern3_0) = C::fits_in_32(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Bint = pattern5_0 {
                    // Rule at src/isa/s390x/lower.isle line 800.
                    let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                    let expr1_0: u32 = 1;
                    let expr2_0: u8 = 0;
                    let expr3_0 = C::uimm32shifted(ctx, expr1_0, expr2_0);
                    let expr4_0 = constructor_and_uimm32shifted(ctx, pattern3_0, expr0_0, expr3_0)?;
                    let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                    return Some(expr5_0);
                }
            }
        }
        if let Some(pattern3_0) = C::fits_in_64(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Iadd => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::i16_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 72.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_add_simm16(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::i32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 76.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_add_simm32(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Sextend = pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 66.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_add_reg_sext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    match pattern10_0 {
                                        &Opcode::Sload16 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 94.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_sload16(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_add_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                        &Opcode::Sload32 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 98.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_sload32(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_add_mem_sext32(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if pattern8_0 == I16 {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 88.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 82.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::i16_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 70.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_add_simm16(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::i32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 74.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_add_simm32(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Sextend = pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 64.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_add_reg_sext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    match pattern10_0 {
                                        &Opcode::Sload16 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 92.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload16(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_add_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                        &Opcode::Sload32 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 96.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload32(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_add_mem_sext32(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if pattern8_0 == I16 {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 86.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 80.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 60.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_add_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Isub => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::i16_from_negated_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 113.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_add_simm16(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::i32_from_negated_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 115.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_add_simm32(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Sextend = pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 109.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_sub_reg_sext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    match pattern10_0 {
                                        &Opcode::Sload16 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 127.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload16(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_sub_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                        &Opcode::Sload32 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 129.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload32(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_sub_mem_sext32(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if pattern8_0 == I16 {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 123.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_sub_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 119.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_sub_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 105.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_sub_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Imul => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::i16_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 212.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_mul_simm16(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::i32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 216.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_mul_simm32(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Sextend = pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 206.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_mul_reg_sext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    match pattern10_0 {
                                        &Opcode::Sload16 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 234.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_sload16(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_mul_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                        &Opcode::Sload32 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 238.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_sload32(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_mul_mem_sext32(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if pattern8_0 == I16 {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 228.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_mul_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 222.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_mul_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::i16_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 210.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_mul_simm16(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::i32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 214.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_mul_simm32(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Sextend = pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 204.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_mul_reg_sext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    match pattern10_0 {
                                        &Opcode::Sload16 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 232.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload16(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_mul_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                        &Opcode::Sload32 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 236.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload32(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_mul_mem_sext32(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if pattern8_0 == I16 {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 226.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_mul_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 220.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_mul_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 200.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_mul_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Udiv => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 303.
                            let expr0_0 = constructor_zero_divisor_check_needed(ctx, pattern7_1)?;
                            let expr1_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr2_0: u64 = 0;
                            let expr3_0 = constructor_uninitialized_regpair(ctx)?;
                            let expr4_0 =
                                constructor_imm_regpair_hi(ctx, expr1_0, expr2_0, &expr3_0)?;
                            let expr5_0 =
                                constructor_put_in_regpair_lo_zext32(ctx, pattern7_0, &expr4_0)?;
                            let expr6_0 = constructor_put_in_reg_zext32(ctx, pattern7_1)?;
                            let expr7_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr8_0 = constructor_maybe_trap_if_zero_divisor(
                                ctx, expr0_0, expr7_0, expr6_0,
                            )?;
                            let expr9_0 = constructor_udivmod(ctx, expr7_0, &expr5_0, expr6_0)?;
                            let expr10_0 = constructor_regpair_lo(ctx, &expr9_0)?;
                            let expr11_0 = constructor_copy_reg(ctx, pattern3_0, expr10_0)?;
                            let expr12_0 = constructor_output_reg(ctx, expr11_0)?;
                            return Some(expr12_0);
                        }
                        &Opcode::Sdiv => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 375.
                            let expr0_0 = constructor_zero_divisor_check_needed(ctx, pattern7_1)?;
                            let expr1_0 = constructor_div_overflow_check_needed(ctx, pattern7_1)?;
                            let expr2_0 = constructor_uninitialized_regpair(ctx)?;
                            let expr3_0 =
                                constructor_put_in_regpair_lo_sext64(ctx, pattern7_0, &expr2_0)?;
                            let expr4_0 = constructor_put_in_reg_sext32(ctx, pattern7_1)?;
                            let expr5_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr6_0 = constructor_maybe_trap_if_zero_divisor(
                                ctx, expr0_0, expr5_0, expr4_0,
                            )?;
                            let expr7_0 = constructor_maybe_trap_if_sdiv_overflow(
                                ctx, expr1_0, expr5_0, pattern3_0, &expr3_0, expr4_0,
                            )?;
                            let expr8_0 = constructor_sdivmod(ctx, expr5_0, &expr3_0, expr4_0)?;
                            let expr9_0 = constructor_regpair_lo(ctx, &expr8_0)?;
                            let expr10_0 = constructor_copy_reg(ctx, pattern3_0, expr9_0)?;
                            let expr11_0 = constructor_output_reg(ctx, expr10_0)?;
                            return Some(expr11_0);
                        }
                        &Opcode::Urem => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 326.
                            let expr0_0 = constructor_zero_divisor_check_needed(ctx, pattern7_1)?;
                            let expr1_0: u64 = 0;
                            let expr2_0 = constructor_uninitialized_regpair(ctx)?;
                            let expr3_0 =
                                constructor_imm_regpair_hi(ctx, pattern3_0, expr1_0, &expr2_0)?;
                            let expr4_0 =
                                constructor_put_in_regpair_lo_zext32(ctx, pattern7_0, &expr3_0)?;
                            let expr5_0 = constructor_put_in_reg_zext32(ctx, pattern7_1)?;
                            let expr6_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr7_0 = constructor_maybe_trap_if_zero_divisor(
                                ctx, expr0_0, expr6_0, expr5_0,
                            )?;
                            let expr8_0 = constructor_udivmod(ctx, expr6_0, &expr4_0, expr5_0)?;
                            let expr9_0 = constructor_regpair_hi(ctx, &expr8_0)?;
                            let expr10_0 = constructor_copy_reg(ctx, pattern3_0, expr9_0)?;
                            let expr11_0 = constructor_output_reg(ctx, expr10_0)?;
                            return Some(expr11_0);
                        }
                        &Opcode::Srem => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 398.
                            let expr0_0 = constructor_zero_divisor_check_needed(ctx, pattern7_1)?;
                            let expr1_0 = constructor_div_overflow_check_needed(ctx, pattern7_1)?;
                            let expr2_0 = constructor_uninitialized_regpair(ctx)?;
                            let expr3_0 =
                                constructor_put_in_regpair_lo_sext64(ctx, pattern7_0, &expr2_0)?;
                            let expr4_0 = constructor_put_in_reg_sext32(ctx, pattern7_1)?;
                            let expr5_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr6_0 = constructor_maybe_trap_if_zero_divisor(
                                ctx, expr0_0, expr5_0, expr4_0,
                            )?;
                            let expr7_0 = constructor_maybe_avoid_srem_overflow(
                                ctx, expr1_0, expr5_0, &expr3_0, expr4_0,
                            )?;
                            let expr8_0 = constructor_sdivmod(ctx, expr5_0, &expr7_0, expr4_0)?;
                            let expr9_0 = constructor_regpair_hi(ctx, &expr8_0)?;
                            let expr10_0 = constructor_copy_reg(ctx, pattern3_0, expr9_0)?;
                            let expr11_0 = constructor_output_reg(ctx, expr10_0)?;
                            return Some(expr11_0);
                        }
                        &Opcode::IaddIfcout => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::u32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 170.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_add_logical_zimm32(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_ifcout(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Uextend = pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 164.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_add_logical_reg_zext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = constructor_output_ifcout(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Uload32 = pattern10_0 {
                                        if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                            // Rule at src/isa/s390x/lower.isle line 182.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                            let expr1_0 =
                                                constructor_sink_uload32(ctx, pattern8_0)?;
                                            let expr2_0 = constructor_add_logical_mem_zext32(
                                                ctx, pattern3_0, expr0_0, &expr1_0,
                                            )?;
                                            let expr3_0 = constructor_output_ifcout(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 176.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_logical_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 =
                                                    constructor_output_ifcout(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::u32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 168.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_add_logical_zimm32(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_ifcout(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Uextend = pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 162.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_add_logical_reg_zext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = constructor_output_ifcout(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Uload32 = pattern10_0 {
                                        if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                            // Rule at src/isa/s390x/lower.isle line 180.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                            let expr1_0 =
                                                constructor_sink_uload32(ctx, pattern8_0)?;
                                            let expr2_0 = constructor_add_logical_mem_zext32(
                                                ctx, pattern3_0, expr0_0, &expr1_0,
                                            )?;
                                            let expr3_0 = constructor_output_ifcout(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 174.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_logical_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 =
                                                    constructor_output_ifcout(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 158.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 =
                                constructor_add_logical_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_ifcout(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 653.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_and_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) =
                                C::uimm32shifted_from_inverted_value(ctx, pattern7_0)
                            {
                                // Rule at src/isa/s390x/lower.isle line 647.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_and_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) =
                                C::uimm16shifted_from_inverted_value(ctx, pattern7_0)
                            {
                                // Rule at src/isa/s390x/lower.isle line 643.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_and_uimm16shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 651.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_and_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) =
                                C::uimm32shifted_from_inverted_value(ctx, pattern7_1)
                            {
                                // Rule at src/isa/s390x/lower.isle line 645.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_and_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) =
                                C::uimm16shifted_from_inverted_value(ctx, pattern7_1)
                            {
                                // Rule at src/isa/s390x/lower.isle line 641.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_and_uimm16shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 637.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_and_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 676.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_or_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::uimm32shifted_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 670.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_or_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::uimm16shifted_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 666.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_or_uimm16shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 674.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_or_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::uimm32shifted_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 668.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_or_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::uimm16shifted_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 664.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_or_uimm16shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 660.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_or_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 695.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_xor_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::uimm32shifted_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 689.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_xor_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 693.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_xor_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::uimm32shifted_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 687.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_xor_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 683.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_xor_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 482.
                                let expr0_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr2_0 =
                                    constructor_lshl_imm(ctx, pattern3_0, expr1_0, expr0_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 477.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr3_0 = constructor_lshl_reg(ctx, pattern3_0, expr2_0, expr1_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 498.
                                let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                                let expr1_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr2_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                                let expr3_0 = constructor_lshr_imm(ctx, expr2_0, expr0_0, expr1_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 491.
                            let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr1_0)?;
                            let expr3_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr4_0 = constructor_lshr_reg(ctx, expr3_0, expr0_0, expr2_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 515.
                                let expr0_0 = constructor_put_in_reg_sext32(ctx, pattern7_0)?;
                                let expr1_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr2_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                                let expr3_0 = constructor_ashr_imm(ctx, expr2_0, expr0_0, expr1_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 508.
                            let expr0_0 = constructor_put_in_reg_sext32(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr1_0)?;
                            let expr3_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr4_0 = constructor_ashr_reg(ctx, expr3_0, expr0_0, expr2_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ineg => {
                            if let Some(pattern7_0) = C::def_inst(ctx, pattern5_1) {
                                let pattern8_0 = C::inst_data(ctx, pattern7_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern9_0,
                                    arg: pattern9_1,
                                } = &pattern8_0
                                {
                                    if let &Opcode::Sextend = pattern9_0 {
                                        let pattern11_0 = C::value_type(ctx, pattern9_1);
                                        if pattern11_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 193.
                                            let expr0_0 = C::put_in_reg(ctx, pattern9_1);
                                            let expr1_0 = constructor_neg_reg_sext32(
                                                ctx, pattern3_0, expr0_0,
                                            )?;
                                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                            return Some(expr2_0);
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 189.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_neg_reg(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        &Opcode::Iabs => {
                            if let Some(pattern7_0) = C::def_inst(ctx, pattern5_1) {
                                let pattern8_0 = C::inst_data(ctx, pattern7_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern9_0,
                                    arg: pattern9_1,
                                } = &pattern8_0
                                {
                                    if let &Opcode::Sextend = pattern9_0 {
                                        let pattern11_0 = C::value_type(ctx, pattern9_1);
                                        if pattern11_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 141.
                                            let expr0_0 = C::put_in_reg(ctx, pattern9_1);
                                            let expr1_0 = constructor_abs_reg_sext32(
                                                ctx, pattern3_0, expr0_0,
                                            )?;
                                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                            return Some(expr2_0);
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 137.
                            let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern5_1)?;
                            let expr2_0 = constructor_abs_reg(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Clz => {
                            // Rule at src/isa/s390x/lower.isle line 821.
                            let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern5_1)?;
                            let expr1_0: i16 = 64;
                            let expr2_0 = constructor_clz_reg(ctx, expr1_0, expr0_0)?;
                            let expr3_0 = constructor_regpair_hi(ctx, &expr2_0)?;
                            let expr4_0 = constructor_clz_offset(ctx, pattern3_0, expr3_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        &Opcode::Cls => {
                            // Rule at src/isa/s390x/lower.isle line 836.
                            let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern5_1)?;
                            let expr1_0: Type = I64;
                            let expr2_0: u8 = 63;
                            let expr3_0 = constructor_ashr_imm(ctx, expr1_0, expr0_0, expr2_0)?;
                            let expr4_0: Type = I64;
                            let expr5_0 = constructor_xor_reg(ctx, expr4_0, expr0_0, expr3_0)?;
                            let expr6_0: i16 = 64;
                            let expr7_0 = constructor_clz_reg(ctx, expr6_0, expr5_0)?;
                            let expr8_0 = constructor_regpair_hi(ctx, &expr7_0)?;
                            let expr9_0 = constructor_clz_offset(ctx, pattern3_0, expr8_0)?;
                            let expr10_0 = constructor_output_reg(ctx, expr9_0)?;
                            return Some(expr10_0);
                        }
                        &Opcode::Bint => {
                            // Rule at src/isa/s390x/lower.isle line 804.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0: u64 = 1;
                            let expr2_0 = constructor_imm(ctx, pattern3_0, expr1_0)?;
                            let expr3_0 = constructor_and_reg(ctx, pattern3_0, expr0_0, expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Rotl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 528.
                                let expr0_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr2_0 =
                                    constructor_rot_imm(ctx, pattern3_0, expr1_0, expr0_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 524.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_rot_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Rotr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_negated_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 566.
                                let expr0_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr2_0 =
                                    constructor_rot_imm(ctx, pattern3_0, expr1_0, expr0_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 560.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = constructor_neg_reg(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr3_0 = constructor_rot_reg(ctx, pattern3_0, expr2_0, expr1_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::AtomicRmw {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                    flags: pattern5_2,
                    op: ref pattern5_3,
                } => {
                    if let &Opcode::AtomicRmw = pattern5_0 {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            match pattern5_3 {
                                &AtomicRmwOp::And => {
                                    // Rule at src/isa/s390x/lower.isle line 1505.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = constructor_bswap_reg(ctx, pattern3_0, expr0_0)?;
                                    let expr2_0 = C::zero_offset(ctx);
                                    let expr3_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr2_0,
                                    )?;
                                    let expr4_0 = constructor_atomic_rmw_and(
                                        ctx, pattern3_0, expr1_0, &expr3_0,
                                    )?;
                                    let expr5_0 = constructor_bswap_reg(ctx, pattern3_0, expr4_0)?;
                                    let expr6_0 = constructor_output_reg(ctx, expr5_0)?;
                                    return Some(expr6_0);
                                }
                                &AtomicRmwOp::Or => {
                                    // Rule at src/isa/s390x/lower.isle line 1517.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = constructor_bswap_reg(ctx, pattern3_0, expr0_0)?;
                                    let expr2_0 = C::zero_offset(ctx);
                                    let expr3_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr2_0,
                                    )?;
                                    let expr4_0 = constructor_atomic_rmw_or(
                                        ctx, pattern3_0, expr1_0, &expr3_0,
                                    )?;
                                    let expr5_0 = constructor_bswap_reg(ctx, pattern3_0, expr4_0)?;
                                    let expr6_0 = constructor_output_reg(ctx, expr5_0)?;
                                    return Some(expr6_0);
                                }
                                &AtomicRmwOp::Xor => {
                                    // Rule at src/isa/s390x/lower.isle line 1529.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = constructor_bswap_reg(ctx, pattern3_0, expr0_0)?;
                                    let expr2_0 = C::zero_offset(ctx);
                                    let expr3_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr2_0,
                                    )?;
                                    let expr4_0 = constructor_atomic_rmw_xor(
                                        ctx, pattern3_0, expr1_0, &expr3_0,
                                    )?;
                                    let expr5_0 = constructor_bswap_reg(ctx, pattern3_0, expr4_0)?;
                                    let expr6_0 = constructor_output_reg(ctx, expr5_0)?;
                                    return Some(expr6_0);
                                }
                                _ => {}
                            }
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            match pattern5_3 {
                                &AtomicRmwOp::Add => {
                                    // Rule at src/isa/s390x/lower.isle line 1535.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = C::zero_offset(ctx);
                                    let expr2_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr1_0,
                                    )?;
                                    let expr3_0 = constructor_atomic_rmw_add(
                                        ctx, pattern3_0, expr0_0, &expr2_0,
                                    )?;
                                    let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                    return Some(expr4_0);
                                }
                                &AtomicRmwOp::And => {
                                    // Rule at src/isa/s390x/lower.isle line 1499.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = C::zero_offset(ctx);
                                    let expr2_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr1_0,
                                    )?;
                                    let expr3_0 = constructor_atomic_rmw_and(
                                        ctx, pattern3_0, expr0_0, &expr2_0,
                                    )?;
                                    let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                    return Some(expr4_0);
                                }
                                &AtomicRmwOp::Or => {
                                    // Rule at src/isa/s390x/lower.isle line 1511.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = C::zero_offset(ctx);
                                    let expr2_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr1_0,
                                    )?;
                                    let expr3_0 = constructor_atomic_rmw_or(
                                        ctx, pattern3_0, expr0_0, &expr2_0,
                                    )?;
                                    let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                    return Some(expr4_0);
                                }
                                &AtomicRmwOp::Sub => {
                                    // Rule at src/isa/s390x/lower.isle line 1541.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = constructor_neg_reg(ctx, pattern3_0, expr0_0)?;
                                    let expr2_0 = C::zero_offset(ctx);
                                    let expr3_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr2_0,
                                    )?;
                                    let expr4_0 = constructor_atomic_rmw_add(
                                        ctx, pattern3_0, expr1_0, &expr3_0,
                                    )?;
                                    let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                                    return Some(expr5_0);
                                }
                                &AtomicRmwOp::Xor => {
                                    // Rule at src/isa/s390x/lower.isle line 1523.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = C::zero_offset(ctx);
                                    let expr2_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr1_0,
                                    )?;
                                    let expr3_0 = constructor_atomic_rmw_xor(
                                        ctx, pattern3_0, expr0_0, &expr2_0,
                                    )?;
                                    let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                    return Some(expr4_0);
                                }
                                _ => {}
                            }
                        }
                        // Rule at src/isa/s390x/lower.isle line 1550.
                        let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                        let expr2_0 = C::inst_builder_new(ctx);
                        let expr3_0 = constructor_casloop_val_reg(ctx)?;
                        let expr4_0 = C::writable_reg_to_reg(ctx, expr3_0);
                        let expr5_0 = constructor_casloop_tmp_reg(ctx)?;
                        let expr6_0 = constructor_atomic_rmw_body(
                            ctx, &expr2_0, pattern3_0, pattern5_2, pattern5_3, expr5_0, expr4_0,
                            expr0_0,
                        )?;
                        let expr7_0 = constructor_casloop(
                            ctx, &expr2_0, pattern3_0, pattern5_2, expr1_0, expr6_0,
                        )?;
                        let expr8_0 = constructor_output_reg(ctx, expr7_0)?;
                        return Some(expr8_0);
                    }
                }
                &InstructionData::AtomicCas {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicCas = pattern5_0 {
                        let (pattern7_0, pattern7_1, pattern7_2) =
                            C::unpack_value_array_3(ctx, pattern5_1);
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1762.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = constructor_bswap_reg(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = C::put_in_reg(ctx, pattern7_2);
                            let expr3_0 = constructor_bswap_reg(ctx, pattern3_0, expr2_0)?;
                            let expr4_0 = C::zero_offset(ctx);
                            let expr5_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern7_0, expr4_0)?;
                            let expr6_0 = constructor_atomic_cas_impl(
                                ctx, pattern3_0, expr1_0, expr3_0, &expr5_0,
                            )?;
                            let expr7_0 = constructor_bswap_reg(ctx, pattern3_0, expr6_0)?;
                            let expr8_0 = constructor_output_reg(ctx, expr7_0)?;
                            return Some(expr8_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1755.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_2);
                            let expr2_0 = C::zero_offset(ctx);
                            let expr3_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern7_0, expr2_0)?;
                            let expr4_0 = constructor_atomic_cas_impl(
                                ctx, pattern3_0, expr0_0, expr1_0, &expr3_0,
                            )?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::FcvtToUint => {
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 1057.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_fcmp_reg(ctx, pattern7_0, expr0_0, expr0_0)?;
                            let expr2_0 = FloatCC::Unordered;
                            let expr3_0 = C::floatcc_as_cond(ctx, &expr2_0);
                            let expr4_0 = C::trap_code_bad_conversion_to_integer(ctx);
                            let expr5_0 = constructor_trap_if(ctx, &expr1_0, &expr3_0, &expr4_0)?;
                            let expr6_0 = constructor_fcvt_to_uint_reg_with_flags(
                                ctx, pattern3_0, pattern7_0, expr0_0,
                            )?;
                            let expr7_0 = FloatCC::Unordered;
                            let expr8_0 = C::floatcc_as_cond(ctx, &expr7_0);
                            let expr9_0 = C::trap_code_integer_overflow(ctx);
                            let expr10_0 = constructor_trap_if(ctx, &expr6_0, &expr8_0, &expr9_0)?;
                            let expr11_0 = constructor_output_reg(ctx, expr10_0)?;
                            return Some(expr11_0);
                        }
                        &Opcode::FcvtToUintSat => {
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 1098.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 =
                                constructor_fcvt_to_uint_reg(ctx, pattern3_0, pattern7_0, expr0_0)?;
                            let expr2_0 = constructor_fcmp_reg(ctx, pattern7_0, expr0_0, expr0_0)?;
                            let expr3_0 = FloatCC::Unordered;
                            let expr4_0 = C::floatcc_as_cond(ctx, &expr3_0);
                            let expr5_0: i16 = 0;
                            let expr6_0 =
                                constructor_cmov_imm(ctx, pattern3_0, &expr4_0, expr5_0, expr1_0)?;
                            let expr7_0 = constructor_with_flags_reg(ctx, &expr2_0, &expr6_0)?;
                            let expr8_0 = constructor_output_reg(ctx, expr7_0)?;
                            return Some(expr8_0);
                        }
                        &Opcode::FcvtToSint => {
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 1078.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_fcmp_reg(ctx, pattern7_0, expr0_0, expr0_0)?;
                            let expr2_0 = FloatCC::Unordered;
                            let expr3_0 = C::floatcc_as_cond(ctx, &expr2_0);
                            let expr4_0 = C::trap_code_bad_conversion_to_integer(ctx);
                            let expr5_0 = constructor_trap_if(ctx, &expr1_0, &expr3_0, &expr4_0)?;
                            let expr6_0 = constructor_fcvt_to_sint_reg_with_flags(
                                ctx, pattern3_0, pattern7_0, expr0_0,
                            )?;
                            let expr7_0 = FloatCC::Unordered;
                            let expr8_0 = C::floatcc_as_cond(ctx, &expr7_0);
                            let expr9_0 = C::trap_code_integer_overflow(ctx);
                            let expr10_0 = constructor_trap_if(ctx, &expr6_0, &expr8_0, &expr9_0)?;
                            let expr11_0 = constructor_output_reg(ctx, expr10_0)?;
                            return Some(expr11_0);
                        }
                        &Opcode::FcvtToSintSat => {
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 1115.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 =
                                constructor_fcvt_to_sint_reg(ctx, pattern3_0, pattern7_0, expr0_0)?;
                            let expr2_0 = constructor_fcmp_reg(ctx, pattern7_0, expr0_0, expr0_0)?;
                            let expr3_0 = FloatCC::Unordered;
                            let expr4_0 = C::floatcc_as_cond(ctx, &expr3_0);
                            let expr5_0: i16 = 0;
                            let expr6_0 =
                                constructor_cmov_imm(ctx, pattern3_0, &expr4_0, expr5_0, expr1_0)?;
                            let expr7_0 = constructor_with_flags_reg(ctx, &expr2_0, &expr6_0)?;
                            let expr8_0 = constructor_output_reg(ctx, expr7_0)?;
                            return Some(expr8_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::ty_8_or_16(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Umulhi => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 245.
                            let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_reg_zext32(ctx, pattern7_1)?;
                            let expr2_0: Type = I32;
                            let expr3_0 = constructor_mul_reg(ctx, expr2_0, expr0_0, expr1_0)?;
                            let expr4_0: Type = I32;
                            let expr5_0 = C::ty_bits(ctx, pattern3_0);
                            let expr6_0 = constructor_lshr_imm(ctx, expr4_0, expr3_0, expr5_0)?;
                            let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                            return Some(expr7_0);
                        }
                        &Opcode::Smulhi => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 267.
                            let expr0_0 = constructor_put_in_reg_sext32(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern7_1)?;
                            let expr2_0: Type = I32;
                            let expr3_0 = constructor_mul_reg(ctx, expr2_0, expr0_0, expr1_0)?;
                            let expr4_0: Type = I32;
                            let expr5_0 = C::ty_bits(ctx, pattern3_0);
                            let expr6_0 = constructor_ashr_imm(ctx, expr4_0, expr3_0, expr5_0)?;
                            let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                            return Some(expr7_0);
                        }
                        &Opcode::Rotl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                                if let Some(pattern9_0) = C::i64_from_negated_value(ctx, pattern7_1)
                                {
                                    // Rule at src/isa/s390x/lower.isle line 546.
                                    let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                                    let expr1_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                                    let expr2_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                    let expr3_0 = C::mask_amt_imm(ctx, pattern3_0, pattern9_0);
                                    let expr4_0 =
                                        constructor_lshl_imm(ctx, expr1_0, expr0_0, expr2_0)?;
                                    let expr5_0 =
                                        constructor_lshr_imm(ctx, expr1_0, expr0_0, expr3_0)?;
                                    let expr6_0 =
                                        constructor_or_reg(ctx, pattern3_0, expr4_0, expr5_0)?;
                                    let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                                    return Some(expr7_0);
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 534.
                            let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                            let expr1_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr3_0 = constructor_neg_reg(ctx, pattern3_0, expr2_0)?;
                            let expr4_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr2_0)?;
                            let expr5_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr3_0)?;
                            let expr6_0 = constructor_lshl_reg(ctx, expr1_0, expr0_0, expr4_0)?;
                            let expr7_0 = constructor_lshr_reg(ctx, expr1_0, expr0_0, expr5_0)?;
                            let expr8_0 = constructor_or_reg(ctx, pattern3_0, expr6_0, expr7_0)?;
                            let expr9_0 = constructor_output_reg(ctx, expr8_0)?;
                            return Some(expr9_0);
                        }
                        &Opcode::Rotr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                                if let Some(pattern9_0) = C::i64_from_negated_value(ctx, pattern7_1)
                                {
                                    // Rule at src/isa/s390x/lower.isle line 584.
                                    let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                                    let expr1_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                                    let expr2_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                    let expr3_0 = C::mask_amt_imm(ctx, pattern3_0, pattern9_0);
                                    let expr4_0 =
                                        constructor_lshl_imm(ctx, expr1_0, expr0_0, expr3_0)?;
                                    let expr5_0 =
                                        constructor_lshr_imm(ctx, expr1_0, expr0_0, expr2_0)?;
                                    let expr6_0 =
                                        constructor_or_reg(ctx, pattern3_0, expr4_0, expr5_0)?;
                                    let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                                    return Some(expr7_0);
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 572.
                            let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                            let expr1_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr3_0 = constructor_neg_reg(ctx, pattern3_0, expr2_0)?;
                            let expr4_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr2_0)?;
                            let expr5_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr3_0)?;
                            let expr6_0 = constructor_lshl_reg(ctx, expr1_0, expr0_0, expr5_0)?;
                            let expr7_0 = constructor_lshr_reg(ctx, expr1_0, expr0_0, expr4_0)?;
                            let expr8_0 = constructor_or_reg(ctx, pattern3_0, expr6_0, expr7_0)?;
                            let expr9_0 = constructor_output_reg(ctx, expr8_0)?;
                            return Some(expr9_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::AtomicRmw {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                    flags: pattern5_2,
                    op: ref pattern5_3,
                } => {
                    if let &Opcode::AtomicRmw = pattern5_0 {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/s390x/lower.isle line 1562.
                        let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                        let expr2_0 = constructor_casloop_bitshift(ctx, expr1_0)?;
                        let expr3_0 = constructor_casloop_aligned_addr(ctx, expr1_0)?;
                        let expr4_0 = C::inst_builder_new(ctx);
                        let expr5_0 = constructor_casloop_val_reg(ctx)?;
                        let expr6_0 = C::writable_reg_to_reg(ctx, expr5_0);
                        let expr7_0 = constructor_casloop_rotate_in(
                            ctx, &expr4_0, pattern3_0, pattern5_2, expr2_0, expr6_0,
                        )?;
                        let expr8_0 = constructor_casloop_tmp_reg(ctx)?;
                        let expr9_0 = constructor_atomic_rmw_body(
                            ctx, &expr4_0, pattern3_0, pattern5_2, pattern5_3, expr8_0, expr7_0,
                            expr0_0,
                        )?;
                        let expr10_0 = constructor_casloop_rotate_out(
                            ctx, &expr4_0, pattern3_0, pattern5_2, expr2_0, expr9_0,
                        )?;
                        let expr11_0 = constructor_casloop_subword(
                            ctx, &expr4_0, pattern3_0, pattern5_2, expr3_0, expr2_0, expr10_0,
                        )?;
                        let expr12_0 = constructor_output_reg(ctx, expr11_0)?;
                        return Some(expr12_0);
                    }
                }
                &InstructionData::AtomicCas {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicCas = pattern5_0 {
                        let (pattern7_0, pattern7_1, pattern7_2) =
                            C::unpack_value_array_3(ctx, pattern5_1);
                        // Rule at src/isa/s390x/lower.isle line 1769.
                        let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr1_0 = C::put_in_reg(ctx, pattern7_2);
                        let expr2_0 = C::put_in_reg(ctx, pattern7_0);
                        let expr3_0 = constructor_casloop_bitshift(ctx, expr2_0)?;
                        let expr4_0 = constructor_casloop_aligned_addr(ctx, expr2_0)?;
                        let expr5_0 = C::inst_builder_new(ctx);
                        let expr6_0 = constructor_casloop_val_reg(ctx)?;
                        let expr7_0 = C::writable_reg_to_reg(ctx, expr6_0);
                        let expr8_0 = constructor_casloop_rotate_in(
                            ctx, &expr5_0, pattern3_0, pattern5_2, expr3_0, expr7_0,
                        )?;
                        let expr9_0 = constructor_casloop_tmp_reg(ctx)?;
                        let expr10_0 = constructor_atomic_cas_body(
                            ctx, &expr5_0, pattern3_0, pattern5_2, expr9_0, expr8_0, expr0_0,
                            expr1_0,
                        )?;
                        let expr11_0 = constructor_casloop_rotate_out(
                            ctx, &expr5_0, pattern3_0, pattern5_2, expr3_0, expr10_0,
                        )?;
                        let expr12_0 = constructor_casloop_subword(
                            ctx, &expr5_0, pattern3_0, pattern5_2, expr4_0, expr3_0, expr11_0,
                        )?;
                        let expr13_0 = constructor_output_reg(ctx, expr12_0)?;
                        return Some(expr13_0);
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::gpr32_ty(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ctz => {
                            // Rule at src/isa/s390x/lower.isle line 859.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr2_0 = constructor_ctz_guardbit(ctx, pattern3_0)?;
                            let expr3_0 =
                                constructor_or_uimm16shifted(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0: Type = I64;
                            let expr5_0: Type = I64;
                            let expr6_0 = constructor_neg_reg(ctx, expr5_0, expr3_0)?;
                            let expr7_0 = constructor_and_reg(ctx, expr4_0, expr3_0, expr6_0)?;
                            let expr8_0: i16 = 64;
                            let expr9_0 = constructor_clz_reg(ctx, expr8_0, expr7_0)?;
                            let expr10_0: u64 = 63;
                            let expr11_0 = constructor_imm(ctx, pattern3_0, expr10_0)?;
                            let expr12_0 = constructor_regpair_hi(ctx, &expr9_0)?;
                            let expr13_0 =
                                constructor_sub_reg(ctx, pattern3_0, expr11_0, expr12_0)?;
                            let expr14_0 = constructor_output_reg(ctx, expr13_0)?;
                            return Some(expr14_0);
                        }
                        &Opcode::Uextend => {
                            // Rule at src/isa/s390x/lower.isle line 603.
                            let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern5_1)?;
                            let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                            return Some(expr1_0);
                        }
                        &Opcode::Sextend => {
                            // Rule at src/isa/s390x/lower.isle line 614.
                            let expr0_0 = constructor_put_in_reg_sext32(ctx, pattern5_1)?;
                            let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                            return Some(expr1_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    match pattern5_0 {
                        &Opcode::Uload8 => {
                            // Rule at src/isa/s390x/lower.isle line 1251.
                            let expr0_0: Type = I8;
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr2_0 = constructor_zext32_mem(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Sload8 => {
                            // Rule at src/isa/s390x/lower.isle line 1262.
                            let expr0_0: Type = I8;
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr2_0 = constructor_sext32_mem(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Uload16 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1278.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev16(ctx, &expr0_0)?;
                                let expr2_0: Type = I16;
                                let expr3_0 = constructor_zext32_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1273.
                                let expr0_0: Type = I16;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_zext32_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                        &Opcode::Sload16 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1303.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev16(ctx, &expr0_0)?;
                                let expr2_0: Type = I16;
                                let expr3_0 = constructor_sext32_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1298.
                                let expr0_0: Type = I16;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_sext32_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::gpr64_ty(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ctz => {
                            // Rule at src/isa/s390x/lower.isle line 874.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0: Type = I64;
                            let expr2_0: Type = I64;
                            let expr3_0 = constructor_neg_reg(ctx, expr2_0, expr0_0)?;
                            let expr4_0 = constructor_and_reg(ctx, expr1_0, expr0_0, expr3_0)?;
                            let expr5_0: i16 = -1;
                            let expr6_0 = constructor_clz_reg(ctx, expr5_0, expr4_0)?;
                            let expr7_0: Type = I64;
                            let expr8_0: Type = I64;
                            let expr9_0: u64 = 63;
                            let expr10_0 = constructor_imm(ctx, expr8_0, expr9_0)?;
                            let expr11_0 = constructor_regpair_hi(ctx, &expr6_0)?;
                            let expr12_0 = constructor_sub_reg(ctx, expr7_0, expr10_0, expr11_0)?;
                            let expr13_0 = constructor_output_reg(ctx, expr12_0)?;
                            return Some(expr13_0);
                        }
                        &Opcode::Uextend => {
                            // Rule at src/isa/s390x/lower.isle line 607.
                            let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern5_1)?;
                            let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                            return Some(expr1_0);
                        }
                        &Opcode::Sextend => {
                            // Rule at src/isa/s390x/lower.isle line 618.
                            let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern5_1)?;
                            let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                            return Some(expr1_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    match pattern5_0 {
                        &Opcode::Uload8 => {
                            // Rule at src/isa/s390x/lower.isle line 1255.
                            let expr0_0: Type = I8;
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr2_0 = constructor_zext64_mem(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Sload8 => {
                            // Rule at src/isa/s390x/lower.isle line 1266.
                            let expr0_0: Type = I8;
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr2_0 = constructor_sext64_mem(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Uload16 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1289.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev16(ctx, &expr0_0)?;
                                let expr2_0: Type = I16;
                                let expr3_0 = constructor_zext64_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1284.
                                let expr0_0: Type = I16;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_zext64_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                        &Opcode::Sload16 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1314.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev16(ctx, &expr0_0)?;
                                let expr2_0: Type = I16;
                                let expr3_0 = constructor_sext64_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1309.
                                let expr0_0: Type = I16;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_sext64_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                        &Opcode::Uload32 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1328.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev32(ctx, &expr0_0)?;
                                let expr2_0: Type = I32;
                                let expr3_0 = constructor_zext64_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1323.
                                let expr0_0: Type = I32;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_zext64_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                        &Opcode::Sload32 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1342.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev32(ctx, &expr0_0)?;
                                let expr2_0: Type = I32;
                                let expr3_0 = constructor_sext64_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1337.
                                let expr0_0: Type = I32;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_sext64_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
    }
    return None;
}

// Generated as internal constructor for term lower_branch.
pub fn constructor_lower_branch<C: Context>(
    ctx: &mut C,
    arg0: Inst,
    arg1: &VecMachLabel,
) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    match &pattern1_0 {
        &InstructionData::BranchTable {
            opcode: ref pattern2_0,
            arg: pattern2_1,
            destination: pattern2_2,
            table: pattern2_3,
        } => {
            if let &Opcode::BrTable = pattern2_0 {
                let pattern4_0 = arg1;
                // Rule at src/isa/s390x/lower.isle line 2076.
                let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern2_1)?;
                let expr1_0: Type = I64;
                let expr2_0 = C::vec_length_minus1(ctx, pattern4_0);
                let expr3_0 = constructor_icmpu_uimm32(ctx, expr1_0, expr0_0, expr2_0)?;
                let expr4_0 = IntCC::UnsignedGreaterThanOrEqual;
                let expr5_0 = C::intcc_as_cond(ctx, &expr4_0);
                let expr6_0 = constructor_bool(ctx, &expr3_0, &expr5_0)?;
                let expr7_0: u8 = 0;
                let expr8_0 = C::vec_element(ctx, pattern4_0, expr7_0);
                let expr9_0 = constructor_oneway_cond_br_bool(ctx, &expr6_0, expr8_0)?;
                let expr10_0 = constructor_side_effect(ctx, &expr9_0)?;
                let expr11_0: Type = I64;
                let expr12_0: u8 = 2;
                let expr13_0 = constructor_lshl_imm(ctx, expr11_0, expr0_0, expr12_0)?;
                let expr14_0 = constructor_jt_sequence(ctx, expr13_0, pattern4_0)?;
                let expr15_0 = constructor_side_effect(ctx, &expr14_0)?;
                return Some(expr15_0);
            }
        }
        &InstructionData::Branch {
            opcode: ref pattern2_0,
            args: pattern2_1,
            destination: pattern2_2,
        } => {
            match pattern2_0 {
                &Opcode::Brz => {
                    let pattern4_0 = C::value_list_slice(ctx, pattern2_1);
                    if let Some((pattern5_0, pattern5_1)) = C::value_slice_unwrap(ctx, pattern4_0) {
                        let pattern6_0 = arg1;
                        // Rule at src/isa/s390x/lower.isle line 2109.
                        let expr0_0 = constructor_value_nonzero(ctx, pattern5_0)?;
                        let expr1_0 = constructor_invert_bool(ctx, &expr0_0)?;
                        let expr2_0: u8 = 0;
                        let expr3_0 = C::vec_element(ctx, pattern6_0, expr2_0);
                        let expr4_0: u8 = 1;
                        let expr5_0 = C::vec_element(ctx, pattern6_0, expr4_0);
                        let expr6_0 = constructor_cond_br_bool(ctx, &expr1_0, expr3_0, expr5_0)?;
                        let expr7_0 = constructor_side_effect(ctx, &expr6_0)?;
                        return Some(expr7_0);
                    }
                }
                &Opcode::Brnz => {
                    let pattern4_0 = C::value_list_slice(ctx, pattern2_1);
                    if let Some((pattern5_0, pattern5_1)) = C::value_slice_unwrap(ctx, pattern4_0) {
                        let pattern6_0 = arg1;
                        // Rule at src/isa/s390x/lower.isle line 2120.
                        let expr0_0 = constructor_value_nonzero(ctx, pattern5_0)?;
                        let expr1_0: u8 = 0;
                        let expr2_0 = C::vec_element(ctx, pattern6_0, expr1_0);
                        let expr3_0: u8 = 1;
                        let expr4_0 = C::vec_element(ctx, pattern6_0, expr3_0);
                        let expr5_0 = constructor_cond_br_bool(ctx, &expr0_0, expr2_0, expr4_0)?;
                        let expr6_0 = constructor_side_effect(ctx, &expr5_0)?;
                        return Some(expr6_0);
                    }
                }
                _ => {}
            }
        }
        &InstructionData::Jump {
            opcode: ref pattern2_0,
            args: pattern2_1,
            destination: pattern2_2,
        } => {
            if let &Opcode::Jump = pattern2_0 {
                let pattern4_0 = C::value_list_slice(ctx, pattern2_1);
                let pattern5_0 = arg1;
                // Rule at src/isa/s390x/lower.isle line 2068.
                let expr0_0: u8 = 0;
                let expr1_0 = C::vec_element(ctx, pattern5_0, expr0_0);
                let expr2_0 = constructor_jump_impl(ctx, expr1_0)?;
                let expr3_0 = constructor_side_effect(ctx, &expr2_0)?;
                return Some(expr3_0);
            }
        }
        &InstructionData::BranchInt {
            opcode: ref pattern2_0,
            args: pattern2_1,
            cond: ref pattern2_2,
            destination: pattern2_3,
        } => {
            if let &Opcode::Brif = pattern2_0 {
                let pattern4_0 = C::value_list_slice(ctx, pattern2_1);
                if let Some((pattern5_0, pattern5_1)) = C::value_slice_unwrap(ctx, pattern4_0) {
                    if let Some(pattern6_0) = C::def_inst(ctx, pattern5_0) {
                        let pattern7_0 = C::inst_data(ctx, pattern6_0);
                        if let &InstructionData::Binary {
                            opcode: ref pattern8_0,
                            args: ref pattern8_1,
                        } = &pattern7_0
                        {
                            if let &Opcode::Ifcmp = pattern8_0 {
                                let (pattern10_0, pattern10_1) =
                                    C::unpack_value_array_2(ctx, pattern8_1);
                                let pattern11_0 = arg1;
                                // Rule at src/isa/s390x/lower.isle line 2131.
                                let expr0_0: bool = false;
                                let expr1_0 = constructor_icmp_val(
                                    ctx,
                                    expr0_0,
                                    pattern2_2,
                                    pattern10_0,
                                    pattern10_1,
                                )?;
                                let expr2_0: u8 = 0;
                                let expr3_0 = C::vec_element(ctx, pattern11_0, expr2_0);
                                let expr4_0: u8 = 1;
                                let expr5_0 = C::vec_element(ctx, pattern11_0, expr4_0);
                                let expr6_0 =
                                    constructor_cond_br_bool(ctx, &expr1_0, expr3_0, expr5_0)?;
                                let expr7_0 = constructor_side_effect(ctx, &expr6_0)?;
                                return Some(expr7_0);
                            }
                        }
                    }
                }
            }
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term output_ifcout.
pub fn constructor_output_ifcout<C: Context>(ctx: &mut C, arg0: Reg) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/lower.isle line 154.
    let expr0_0 = C::value_reg(ctx, pattern0_0);
    let expr1_0 = C::value_regs_invalid(ctx);
    let expr2_0 = C::output_pair(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term zero_divisor_check_needed.
pub fn constructor_zero_divisor_check_needed<C: Context>(ctx: &mut C, arg0: Value) -> Option<bool> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::i64_from_value(ctx, pattern0_0) {
        let pattern2_0 = 0;
        if let Some(pattern3_0) = C::i64_nonequal(ctx, pattern1_0, pattern2_0) {
            // Rule at src/isa/s390x/lower.isle line 344.
            let expr0_0: bool = false;
            return Some(expr0_0);
        }
    }
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(()) = C::allow_div_traps(ctx, pattern1_0) {
        // Rule at src/isa/s390x/lower.isle line 345.
        let expr0_0: bool = false;
        return Some(expr0_0);
    }
    // Rule at src/isa/s390x/lower.isle line 346.
    let expr0_0: bool = true;
    return Some(expr0_0);
}

// Generated as internal constructor for term maybe_trap_if_zero_divisor.
pub fn constructor_maybe_trap_if_zero_divisor<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == true {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/lower.isle line 352.
        let expr0_0: i16 = 0;
        let expr1_0 = IntCC::Equal;
        let expr2_0 = C::intcc_as_cond(ctx, &expr1_0);
        let expr3_0 = C::trap_code_division_by_zero(ctx);
        let expr4_0 = constructor_icmps_simm16_and_trap(
            ctx, pattern2_0, pattern3_0, expr0_0, &expr2_0, &expr3_0,
        )?;
        return Some(expr4_0);
    }
    if pattern0_0 == false {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/lower.isle line 351.
        let expr0_0 = C::invalid_reg(ctx);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term div_overflow_check_needed.
pub fn constructor_div_overflow_check_needed<C: Context>(ctx: &mut C, arg0: Value) -> Option<bool> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::i64_from_value(ctx, pattern0_0) {
        let pattern2_0 = -1;
        if let Some(pattern3_0) = C::i64_nonequal(ctx, pattern1_0, pattern2_0) {
            // Rule at src/isa/s390x/lower.isle line 425.
            let expr0_0: bool = false;
            return Some(expr0_0);
        }
    }
    // Rule at src/isa/s390x/lower.isle line 426.
    let expr0_0: bool = true;
    return Some(expr0_0);
}

// Generated as internal constructor for term maybe_trap_if_sdiv_overflow.
pub fn constructor_maybe_trap_if_sdiv_overflow<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Type,
    arg2: Type,
    arg3: &RegPair,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == true {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/s390x/lower.isle line 439.
        let expr0_0 = constructor_int_max(ctx, pattern3_0)?;
        let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
        let expr2_0 = constructor_regpair_lo(ctx, pattern4_0)?;
        let expr3_0 = constructor_xor_reg(ctx, pattern2_0, expr1_0, expr2_0)?;
        let expr4_0 = constructor_and_reg(ctx, pattern2_0, expr3_0, pattern5_0)?;
        let expr5_0: i16 = -1;
        let expr6_0 = IntCC::Equal;
        let expr7_0 = C::intcc_as_cond(ctx, &expr6_0);
        let expr8_0 = C::trap_code_integer_overflow(ctx);
        let expr9_0 = constructor_icmps_simm16_and_trap(
            ctx, pattern2_0, expr4_0, expr5_0, &expr7_0, &expr8_0,
        )?;
        return Some(expr9_0);
    }
    if pattern0_0 == false {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/s390x/lower.isle line 438.
        let expr0_0 = C::invalid_reg(ctx);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term int_max.
pub fn constructor_int_max<C: Context>(ctx: &mut C, arg0: Type) -> Option<u64> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/lower.isle line 447.
        let expr0_0: u64 = 127;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/lower.isle line 448.
        let expr0_0: u64 = 32767;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/lower.isle line 449.
        let expr0_0: u64 = 2147483647;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/lower.isle line 450.
        let expr0_0: u64 = 9223372036854775807;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term maybe_avoid_srem_overflow.
pub fn constructor_maybe_avoid_srem_overflow<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Type,
    arg2: &RegPair,
    arg3: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    if pattern0_0 == true {
        let pattern2_0 = arg1;
        if pattern2_0 == I32 {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 468.
            return Some(pattern4_0.clone());
        }
        if pattern2_0 == I64 {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 469.
            let expr0_0: Type = I64;
            let expr1_0: Type = I64;
            let expr2_0: i16 = -1;
            let expr3_0 = constructor_icmps_simm16(ctx, expr1_0, pattern5_0, expr2_0)?;
            let expr4_0 = IntCC::Equal;
            let expr5_0 = C::intcc_as_cond(ctx, &expr4_0);
            let expr6_0: i16 = 0;
            let expr7_0 = constructor_cmov_imm_regpair_lo(
                ctx, expr0_0, &expr3_0, &expr5_0, expr6_0, pattern4_0,
            )?;
            return Some(expr7_0);
        }
    }
    if pattern0_0 == false {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 467.
        return Some(pattern3_0.clone());
    }
    return None;
}

// Generated as internal constructor for term cast_bool.
pub fn constructor_cast_bool<C: Context>(ctx: &mut C, arg0: Type, arg1: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == B1 {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B1 {
            // Rule at src/isa/s390x/lower.isle line 766.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
        if pattern3_0 == B8 {
            // Rule at src/isa/s390x/lower.isle line 767.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if pattern0_0 == B8 {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B8 {
            // Rule at src/isa/s390x/lower.isle line 768.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if pattern0_0 == I8 {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B8 {
            // Rule at src/isa/s390x/lower.isle line 769.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if let Some(pattern1_0) = C::fits_in_16(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B16 {
            // Rule at src/isa/s390x/lower.isle line 770.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if let Some(pattern1_0) = C::fits_in_32(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B32 {
            // Rule at src/isa/s390x/lower.isle line 771.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if let Some(pattern1_0) = C::fits_in_64(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B64 {
            // Rule at src/isa/s390x/lower.isle line 772.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B1 {
            // Rule at src/isa/s390x/lower.isle line 775.
            let expr0_0: Type = I32;
            let expr1_0: Type = I32;
            let expr2_0 = C::put_in_reg(ctx, pattern2_0);
            let expr3_0: u8 = 31;
            let expr4_0 = constructor_lshl_imm(ctx, expr1_0, expr2_0, expr3_0)?;
            let expr5_0: u8 = 31;
            let expr6_0 = constructor_ashr_imm(ctx, expr0_0, expr4_0, expr5_0)?;
            return Some(expr6_0);
        }
        if pattern3_0 == B8 {
            // Rule at src/isa/s390x/lower.isle line 781.
            let expr0_0: Type = I8;
            let expr1_0 = C::put_in_reg(ctx, pattern2_0);
            let expr2_0 = constructor_sext32_reg(ctx, expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
        if pattern3_0 == B16 {
            // Rule at src/isa/s390x/lower.isle line 783.
            let expr0_0: Type = I16;
            let expr1_0 = C::put_in_reg(ctx, pattern2_0);
            let expr2_0 = constructor_sext32_reg(ctx, expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B1 {
            // Rule at src/isa/s390x/lower.isle line 777.
            let expr0_0: Type = I64;
            let expr1_0: Type = I64;
            let expr2_0 = C::put_in_reg(ctx, pattern2_0);
            let expr3_0: u8 = 63;
            let expr4_0 = constructor_lshl_imm(ctx, expr1_0, expr2_0, expr3_0)?;
            let expr5_0: u8 = 63;
            let expr6_0 = constructor_ashr_imm(ctx, expr0_0, expr4_0, expr5_0)?;
            return Some(expr6_0);
        }
        if pattern3_0 == B8 {
            // Rule at src/isa/s390x/lower.isle line 785.
            let expr0_0: Type = I8;
            let expr1_0 = C::put_in_reg(ctx, pattern2_0);
            let expr2_0 = constructor_sext64_reg(ctx, expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
        if pattern3_0 == B16 {
            // Rule at src/isa/s390x/lower.isle line 787.
            let expr0_0: Type = I16;
            let expr1_0 = C::put_in_reg(ctx, pattern2_0);
            let expr2_0 = constructor_sext64_reg(ctx, expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
        if pattern3_0 == B32 {
            // Rule at src/isa/s390x/lower.isle line 789.
            let expr0_0: Type = I32;
            let expr1_0 = C::put_in_reg(ctx, pattern2_0);
            let expr2_0 = constructor_sext64_reg(ctx, expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
    }
    return None;
}

// Generated as internal constructor for term clz_offset.
pub fn constructor_clz_offset<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/lower.isle line 814.
        let expr0_0: Type = I8;
        let expr1_0: i16 = -56;
        let expr2_0 = constructor_add_simm16(ctx, expr0_0, pattern2_0, expr1_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I16 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/lower.isle line 815.
        let expr0_0: Type = I16;
        let expr1_0: i16 = -48;
        let expr2_0 = constructor_add_simm16(ctx, expr0_0, pattern2_0, expr1_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/lower.isle line 816.
        let expr0_0: Type = I32;
        let expr1_0: i16 = -32;
        let expr2_0 = constructor_add_simm16(ctx, expr0_0, pattern2_0, expr1_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/lower.isle line 817.
        let expr0_0: Type = I64;
        let expr1_0 = constructor_copy_reg(ctx, expr0_0, pattern2_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term ctz_guardbit.
pub fn constructor_ctz_guardbit<C: Context>(ctx: &mut C, arg0: Type) -> Option<UImm16Shifted> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/lower.isle line 866.
        let expr0_0: u16 = 256;
        let expr1_0: u8 = 0;
        let expr2_0 = C::uimm16shifted(ctx, expr0_0, expr1_0);
        return Some(expr2_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/lower.isle line 867.
        let expr0_0: u16 = 1;
        let expr1_0: u8 = 16;
        let expr2_0 = C::uimm16shifted(ctx, expr0_0, expr1_0);
        return Some(expr2_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/lower.isle line 868.
        let expr0_0: u16 = 1;
        let expr1_0: u8 = 32;
        let expr2_0 = C::uimm16shifted(ctx, expr0_0, expr1_0);
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term istore8_impl.
pub fn constructor_istore8_impl<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(pattern2_0) = C::u8_from_value(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1424.
        let expr0_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr1_0 = constructor_store8_imm(ctx, pattern2_0, &expr0_0)?;
        return Some(expr1_0);
    }
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/lower.isle line 1420.
    let expr0_0 = C::put_in_reg(ctx, pattern1_0);
    let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern2_0, pattern3_0)?;
    let expr2_0 = constructor_store8(ctx, expr0_0, &expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term istore16_impl.
pub fn constructor_istore16_impl<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let Some(()) = C::littleendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if let Some(pattern3_0) = C::i16_from_swapped_value(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 1450.
            let expr0_0 = constructor_lower_address(ctx, pattern0_0, pattern4_0, pattern5_0)?;
            let expr1_0 = constructor_store16_imm(ctx, pattern3_0, &expr0_0)?;
            return Some(expr1_0);
        }
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1442.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_storerev16(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    if let Some(()) = C::bigendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if let Some(pattern3_0) = C::i16_from_value(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 1446.
            let expr0_0 = constructor_lower_address(ctx, pattern0_0, pattern4_0, pattern5_0)?;
            let expr1_0 = constructor_store16_imm(ctx, pattern3_0, &expr0_0)?;
            return Some(expr1_0);
        }
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1438.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_store16(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term istore32_impl.
pub fn constructor_istore32_impl<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let Some(()) = C::littleendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1472.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_storerev32(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    if let Some(()) = C::bigendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if let Some(pattern3_0) = C::i16_from_value(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 1468.
            let expr0_0 = constructor_lower_address(ctx, pattern0_0, pattern4_0, pattern5_0)?;
            let expr1_0 = constructor_store32_simm16(ctx, pattern3_0, &expr0_0)?;
            return Some(expr1_0);
        }
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1464.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_store32(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term istore64_impl.
pub fn constructor_istore64_impl<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let Some(()) = C::littleendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1490.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_storerev64(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    if let Some(()) = C::bigendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if let Some(pattern3_0) = C::i16_from_value(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 1486.
            let expr0_0 = constructor_lower_address(ctx, pattern0_0, pattern4_0, pattern5_0)?;
            let expr1_0 = constructor_store64_simm16(ctx, pattern3_0, &expr0_0)?;
            return Some(expr1_0);
        }
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1482.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_store64(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_body.
pub fn constructor_atomic_rmw_body<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: &AtomicRmwOp,
    arg4: WritableReg,
    arg5: Reg,
    arg6: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(()) = C::mie2_enabled(ctx, pattern1_0) {
        if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern1_0) {
            let pattern4_0 = arg2;
            if let Some(()) = C::littleendian(ctx, pattern4_0) {
                let pattern6_0 = arg3;
                if let &AtomicRmwOp::Nand = pattern6_0 {
                    let pattern8_0 = arg4;
                    let pattern9_0 = arg5;
                    let pattern10_0 = arg6;
                    // Rule at src/isa/s390x/lower.isle line 1598.
                    let expr0_0 = constructor_aluop_and_not(ctx, pattern3_0)?;
                    let expr1_0 = constructor_bswap_reg(ctx, pattern3_0, pattern10_0)?;
                    let expr2_0 = constructor_push_alu_reg(
                        ctx, pattern0_0, &expr0_0, pattern8_0, pattern9_0, expr1_0,
                    )?;
                    return Some(expr2_0);
                }
            }
            if let Some(()) = C::bigendian(ctx, pattern4_0) {
                let pattern6_0 = arg3;
                if let &AtomicRmwOp::Nand = pattern6_0 {
                    let pattern8_0 = arg4;
                    let pattern9_0 = arg5;
                    let pattern10_0 = arg6;
                    // Rule at src/isa/s390x/lower.isle line 1595.
                    let expr0_0 = constructor_aluop_and_not(ctx, pattern3_0)?;
                    let expr1_0 = constructor_push_alu_reg(
                        ctx,
                        pattern0_0,
                        &expr0_0,
                        pattern8_0,
                        pattern9_0,
                        pattern10_0,
                    )?;
                    return Some(expr1_0);
                }
            }
        }
    }
    if let Some(()) = C::mie2_disabled(ctx, pattern1_0) {
        if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern1_0) {
            let pattern4_0 = arg2;
            if let Some(()) = C::littleendian(ctx, pattern4_0) {
                let pattern6_0 = arg3;
                if let &AtomicRmwOp::Nand = pattern6_0 {
                    let pattern8_0 = arg4;
                    let pattern9_0 = arg5;
                    let pattern10_0 = arg6;
                    // Rule at src/isa/s390x/lower.isle line 1605.
                    let expr0_0 = constructor_aluop_and(ctx, pattern3_0)?;
                    let expr1_0 = constructor_bswap_reg(ctx, pattern3_0, pattern10_0)?;
                    let expr2_0 = constructor_push_alu_reg(
                        ctx, pattern0_0, &expr0_0, pattern8_0, pattern9_0, expr1_0,
                    )?;
                    let expr3_0 =
                        constructor_push_not_reg(ctx, pattern0_0, pattern3_0, pattern8_0, expr2_0)?;
                    return Some(expr3_0);
                }
            }
            if let Some(()) = C::bigendian(ctx, pattern4_0) {
                let pattern6_0 = arg3;
                if let &AtomicRmwOp::Nand = pattern6_0 {
                    let pattern8_0 = arg4;
                    let pattern9_0 = arg5;
                    let pattern10_0 = arg6;
                    // Rule at src/isa/s390x/lower.isle line 1601.
                    let expr0_0 = constructor_aluop_and(ctx, pattern3_0)?;
                    let expr1_0 = constructor_push_alu_reg(
                        ctx,
                        pattern0_0,
                        &expr0_0,
                        pattern8_0,
                        pattern9_0,
                        pattern10_0,
                    )?;
                    let expr2_0 =
                        constructor_push_not_reg(ctx, pattern0_0, pattern3_0, pattern8_0, expr1_0)?;
                    return Some(expr2_0);
                }
            }
        }
    }
    if let Some(pattern2_0) = C::ty_32_or_64(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        if let Some(()) = C::littleendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            if let &AtomicRmwOp::Xchg = pattern5_0 {
                let pattern7_0 = arg4;
                let pattern8_0 = arg5;
                let pattern9_0 = arg6;
                // Rule at src/isa/s390x/lower.isle line 1587.
                let expr0_0 = constructor_bswap_reg(ctx, pattern2_0, pattern9_0)?;
                return Some(expr0_0);
            }
        }
        if let Some(()) = C::bigendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            if let &AtomicRmwOp::Xchg = pattern5_0 {
                let pattern7_0 = arg4;
                let pattern8_0 = arg5;
                let pattern9_0 = arg6;
                // Rule at src/isa/s390x/lower.isle line 1584.
                return Some(pattern9_0);
            }
        }
    }
    if let Some(pattern2_0) = C::ty_8_or_16(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        match pattern4_0 {
            &AtomicRmwOp::And => {
                let pattern6_0 = arg4;
                let pattern7_0 = arg5;
                let pattern8_0 = arg6;
                // Rule at src/isa/s390x/lower.isle line 1615.
                let expr0_0 = RxSBGOp::And;
                let expr1_0 = constructor_atomic_rmw_body_rxsbg(
                    ctx, pattern0_0, pattern2_0, pattern3_0, &expr0_0, pattern6_0, pattern7_0,
                    pattern8_0,
                )?;
                return Some(expr1_0);
            }
            &AtomicRmwOp::Nand => {
                let pattern6_0 = arg4;
                let pattern7_0 = arg5;
                let pattern8_0 = arg6;
                // Rule at src/isa/s390x/lower.isle line 1621.
                let expr0_0 = RxSBGOp::And;
                let expr1_0 = constructor_atomic_rmw_body_rxsbg(
                    ctx, pattern0_0, pattern2_0, pattern3_0, &expr0_0, pattern6_0, pattern7_0,
                    pattern8_0,
                )?;
                let expr2_0 = constructor_atomic_rmw_body_invert(
                    ctx, pattern0_0, pattern2_0, pattern3_0, pattern6_0, expr1_0,
                )?;
                return Some(expr2_0);
            }
            &AtomicRmwOp::Or => {
                let pattern6_0 = arg4;
                let pattern7_0 = arg5;
                let pattern8_0 = arg6;
                // Rule at src/isa/s390x/lower.isle line 1617.
                let expr0_0 = RxSBGOp::Or;
                let expr1_0 = constructor_atomic_rmw_body_rxsbg(
                    ctx, pattern0_0, pattern2_0, pattern3_0, &expr0_0, pattern6_0, pattern7_0,
                    pattern8_0,
                )?;
                return Some(expr1_0);
            }
            &AtomicRmwOp::Xchg => {
                let pattern6_0 = arg4;
                let pattern7_0 = arg5;
                let pattern8_0 = arg6;
                // Rule at src/isa/s390x/lower.isle line 1613.
                let expr0_0 = RxSBGOp::Insert;
                let expr1_0 = constructor_atomic_rmw_body_rxsbg(
                    ctx, pattern0_0, pattern2_0, pattern3_0, &expr0_0, pattern6_0, pattern7_0,
                    pattern8_0,
                )?;
                return Some(expr1_0);
            }
            &AtomicRmwOp::Xor => {
                let pattern6_0 = arg4;
                let pattern7_0 = arg5;
                let pattern8_0 = arg6;
                // Rule at src/isa/s390x/lower.isle line 1619.
                let expr0_0 = RxSBGOp::Xor;
                let expr1_0 = constructor_atomic_rmw_body_rxsbg(
                    ctx, pattern0_0, pattern2_0, pattern3_0, &expr0_0, pattern6_0, pattern7_0,
                    pattern8_0,
                )?;
                return Some(expr1_0);
            }
            _ => {}
        }
    }
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    match pattern3_0 {
        &AtomicRmwOp::Add => {
            let pattern5_0 = arg4;
            let pattern6_0 = arg5;
            let pattern7_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1653.
            let expr0_0 = constructor_ty_ext32(ctx, pattern1_0)?;
            let expr1_0 = constructor_aluop_add(ctx, expr0_0)?;
            let expr2_0 = constructor_atomic_rmw_body_addsub(
                ctx, pattern0_0, pattern1_0, pattern2_0, &expr1_0, pattern5_0, pattern6_0,
                pattern7_0,
            )?;
            return Some(expr2_0);
        }
        &AtomicRmwOp::Smax => {
            let pattern5_0 = arg4;
            let pattern6_0 = arg5;
            let pattern7_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1694.
            let expr0_0 = constructor_ty_ext32(ctx, pattern1_0)?;
            let expr1_0 = constructor_cmpop_cmps(ctx, expr0_0)?;
            let expr2_0 = IntCC::SignedGreaterThan;
            let expr3_0 = C::intcc_as_cond(ctx, &expr2_0);
            let expr4_0 = constructor_atomic_rmw_body_minmax(
                ctx, pattern0_0, pattern1_0, pattern2_0, &expr1_0, &expr3_0, pattern5_0,
                pattern6_0, pattern7_0,
            )?;
            return Some(expr4_0);
        }
        &AtomicRmwOp::Smin => {
            let pattern5_0 = arg4;
            let pattern6_0 = arg5;
            let pattern7_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1691.
            let expr0_0 = constructor_ty_ext32(ctx, pattern1_0)?;
            let expr1_0 = constructor_cmpop_cmps(ctx, expr0_0)?;
            let expr2_0 = IntCC::SignedLessThan;
            let expr3_0 = C::intcc_as_cond(ctx, &expr2_0);
            let expr4_0 = constructor_atomic_rmw_body_minmax(
                ctx, pattern0_0, pattern1_0, pattern2_0, &expr1_0, &expr3_0, pattern5_0,
                pattern6_0, pattern7_0,
            )?;
            return Some(expr4_0);
        }
        &AtomicRmwOp::Sub => {
            let pattern5_0 = arg4;
            let pattern6_0 = arg5;
            let pattern7_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1655.
            let expr0_0 = constructor_ty_ext32(ctx, pattern1_0)?;
            let expr1_0 = constructor_aluop_sub(ctx, expr0_0)?;
            let expr2_0 = constructor_atomic_rmw_body_addsub(
                ctx, pattern0_0, pattern1_0, pattern2_0, &expr1_0, pattern5_0, pattern6_0,
                pattern7_0,
            )?;
            return Some(expr2_0);
        }
        &AtomicRmwOp::Umax => {
            let pattern5_0 = arg4;
            let pattern6_0 = arg5;
            let pattern7_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1700.
            let expr0_0 = constructor_ty_ext32(ctx, pattern1_0)?;
            let expr1_0 = constructor_cmpop_cmpu(ctx, expr0_0)?;
            let expr2_0 = IntCC::UnsignedGreaterThan;
            let expr3_0 = C::intcc_as_cond(ctx, &expr2_0);
            let expr4_0 = constructor_atomic_rmw_body_minmax(
                ctx, pattern0_0, pattern1_0, pattern2_0, &expr1_0, &expr3_0, pattern5_0,
                pattern6_0, pattern7_0,
            )?;
            return Some(expr4_0);
        }
        &AtomicRmwOp::Umin => {
            let pattern5_0 = arg4;
            let pattern6_0 = arg5;
            let pattern7_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1697.
            let expr0_0 = constructor_ty_ext32(ctx, pattern1_0)?;
            let expr1_0 = constructor_cmpop_cmpu(ctx, expr0_0)?;
            let expr2_0 = IntCC::UnsignedLessThan;
            let expr3_0 = C::intcc_as_cond(ctx, &expr2_0);
            let expr4_0 = constructor_atomic_rmw_body_minmax(
                ctx, pattern0_0, pattern1_0, pattern2_0, &expr1_0, &expr3_0, pattern5_0,
                pattern6_0, pattern7_0,
            )?;
            return Some(expr4_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_body_rxsbg.
pub fn constructor_atomic_rmw_body_rxsbg<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: &RxSBGOp,
    arg4: WritableReg,
    arg5: Reg,
    arg6: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        let pattern6_0 = arg5;
        let pattern7_0 = arg6;
        // Rule at src/isa/s390x/lower.isle line 1629.
        let expr0_0: u8 = 32;
        let expr1_0: u8 = 40;
        let expr2_0: i8 = 24;
        let expr3_0 = constructor_push_rxsbg(
            ctx, pattern0_0, pattern4_0, pattern5_0, pattern6_0, pattern7_0, expr0_0, expr1_0,
            expr2_0,
        )?;
        return Some(expr3_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        if let Some(()) = C::littleendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1637.
            let expr0_0: Type = I32;
            let expr1_0 = constructor_bswap_reg(ctx, expr0_0, pattern8_0)?;
            let expr2_0: u8 = 48;
            let expr3_0: u8 = 64;
            let expr4_0: i8 = -16;
            let expr5_0 = constructor_push_rxsbg(
                ctx, pattern0_0, pattern5_0, pattern6_0, pattern7_0, expr1_0, expr2_0, expr3_0,
                expr4_0,
            )?;
            return Some(expr5_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1633.
            let expr0_0: u8 = 32;
            let expr1_0: u8 = 48;
            let expr2_0: i8 = 16;
            let expr3_0 = constructor_push_rxsbg(
                ctx, pattern0_0, pattern5_0, pattern6_0, pattern7_0, pattern8_0, expr0_0, expr1_0,
                expr2_0,
            )?;
            return Some(expr3_0);
        }
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_body_invert.
pub fn constructor_atomic_rmw_body_invert<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: WritableReg,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/s390x/lower.isle line 1643.
        let expr0_0: Type = I32;
        let expr1_0: u32 = 4278190080;
        let expr2_0: u8 = 0;
        let expr3_0 = C::uimm32shifted(ctx, expr1_0, expr2_0);
        let expr4_0 = constructor_push_xor_uimm32shifted(
            ctx, pattern0_0, expr0_0, pattern4_0, pattern5_0, expr3_0,
        )?;
        return Some(expr4_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        if let Some(()) = C::littleendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            // Rule at src/isa/s390x/lower.isle line 1649.
            let expr0_0: Type = I32;
            let expr1_0: u32 = 65535;
            let expr2_0: u8 = 0;
            let expr3_0 = C::uimm32shifted(ctx, expr1_0, expr2_0);
            let expr4_0 = constructor_push_xor_uimm32shifted(
                ctx, pattern0_0, expr0_0, pattern5_0, pattern6_0, expr3_0,
            )?;
            return Some(expr4_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            // Rule at src/isa/s390x/lower.isle line 1646.
            let expr0_0: Type = I32;
            let expr1_0: u32 = 4294901760;
            let expr2_0: u8 = 0;
            let expr3_0 = C::uimm32shifted(ctx, expr1_0, expr2_0);
            let expr4_0 = constructor_push_xor_uimm32shifted(
                ctx, pattern0_0, expr0_0, pattern5_0, pattern6_0, expr3_0,
            )?;
            return Some(expr4_0);
        }
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_body_addsub.
pub fn constructor_atomic_rmw_body_addsub<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: &ALUOp,
    arg4: WritableReg,
    arg5: Reg,
    arg6: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        let pattern6_0 = arg5;
        let pattern7_0 = arg6;
        // Rule at src/isa/s390x/lower.isle line 1672.
        let expr0_0: Type = I32;
        let expr1_0: u8 = 24;
        let expr2_0 = constructor_lshl_imm(ctx, expr0_0, pattern7_0, expr1_0)?;
        let expr3_0 =
            constructor_push_alu_reg(ctx, pattern0_0, pattern4_0, pattern5_0, pattern6_0, expr2_0)?;
        return Some(expr3_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        if let Some(()) = C::littleendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1684.
            let expr0_0: Type = I32;
            let expr1_0: u8 = 16;
            let expr2_0 = constructor_lshl_imm(ctx, expr0_0, pattern8_0, expr1_0)?;
            let expr3_0: Type = I32;
            let expr4_0 =
                constructor_push_bswap_reg(ctx, pattern0_0, expr3_0, pattern6_0, pattern7_0)?;
            let expr5_0 = constructor_push_alu_reg(
                ctx, pattern0_0, pattern5_0, pattern6_0, expr4_0, expr2_0,
            )?;
            let expr6_0: Type = I32;
            let expr7_0 =
                constructor_push_bswap_reg(ctx, pattern0_0, expr6_0, pattern6_0, expr5_0)?;
            return Some(expr7_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1676.
            let expr0_0: Type = I32;
            let expr1_0: u8 = 16;
            let expr2_0 = constructor_lshl_imm(ctx, expr0_0, pattern8_0, expr1_0)?;
            let expr3_0 = constructor_push_alu_reg(
                ctx, pattern0_0, pattern5_0, pattern6_0, pattern7_0, expr2_0,
            )?;
            return Some(expr3_0);
        }
    }
    if let Some(pattern2_0) = C::ty_32_or_64(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        if let Some(()) = C::littleendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1666.
            let expr0_0 =
                constructor_push_bswap_reg(ctx, pattern0_0, pattern2_0, pattern6_0, pattern7_0)?;
            let expr1_0 = constructor_push_alu_reg(
                ctx, pattern0_0, pattern5_0, pattern6_0, expr0_0, pattern8_0,
            )?;
            let expr2_0 =
                constructor_push_bswap_reg(ctx, pattern0_0, pattern2_0, pattern6_0, expr1_0)?;
            return Some(expr2_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1662.
            let expr0_0 = constructor_push_alu_reg(
                ctx, pattern0_0, pattern5_0, pattern6_0, pattern7_0, pattern8_0,
            )?;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_body_minmax.
pub fn constructor_atomic_rmw_body_minmax<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: &CmpOp,
    arg4: &Cond,
    arg5: WritableReg,
    arg6: Reg,
    arg7: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        let pattern6_0 = arg5;
        let pattern7_0 = arg6;
        let pattern8_0 = arg7;
        // Rule at src/isa/s390x/lower.isle line 1729.
        let expr0_0: Type = I32;
        let expr1_0: u8 = 24;
        let expr2_0 = constructor_lshl_imm(ctx, expr0_0, pattern8_0, expr1_0)?;
        let expr3_0 = constructor_cmp_rr(ctx, pattern4_0, expr2_0, pattern7_0)?;
        let expr4_0 = C::invert_cond(ctx, pattern5_0);
        let expr5_0 = constructor_push_break_if(ctx, pattern0_0, &expr3_0, &expr4_0)?;
        let expr6_0 = RxSBGOp::Insert;
        let expr7_0: u8 = 32;
        let expr8_0: u8 = 40;
        let expr9_0: i8 = 0;
        let expr10_0 = constructor_push_rxsbg(
            ctx, pattern0_0, &expr6_0, pattern6_0, pattern7_0, expr2_0, expr7_0, expr8_0, expr9_0,
        )?;
        return Some(expr10_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        if let Some(()) = C::littleendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            let pattern9_0 = arg7;
            // Rule at src/isa/s390x/lower.isle line 1742.
            let expr0_0: Type = I32;
            let expr1_0: u8 = 16;
            let expr2_0 = constructor_lshl_imm(ctx, expr0_0, pattern9_0, expr1_0)?;
            let expr3_0: Type = I32;
            let expr4_0 =
                constructor_push_bswap_reg(ctx, pattern0_0, expr3_0, pattern7_0, pattern8_0)?;
            let expr5_0 = constructor_cmp_rr(ctx, pattern5_0, expr2_0, expr4_0)?;
            let expr6_0 = C::invert_cond(ctx, pattern6_0);
            let expr7_0 = constructor_push_break_if(ctx, pattern0_0, &expr5_0, &expr6_0)?;
            let expr8_0 = RxSBGOp::Insert;
            let expr9_0: u8 = 32;
            let expr10_0: u8 = 48;
            let expr11_0: i8 = 0;
            let expr12_0 = constructor_push_rxsbg(
                ctx, pattern0_0, &expr8_0, pattern7_0, expr4_0, expr2_0, expr9_0, expr10_0,
                expr11_0,
            )?;
            let expr13_0: Type = I32;
            let expr14_0 =
                constructor_push_bswap_reg(ctx, pattern0_0, expr13_0, pattern7_0, expr12_0)?;
            return Some(expr14_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            let pattern9_0 = arg7;
            // Rule at src/isa/s390x/lower.isle line 1735.
            let expr0_0: Type = I32;
            let expr1_0: u8 = 16;
            let expr2_0 = constructor_lshl_imm(ctx, expr0_0, pattern9_0, expr1_0)?;
            let expr3_0 = constructor_cmp_rr(ctx, pattern5_0, expr2_0, pattern8_0)?;
            let expr4_0 = C::invert_cond(ctx, pattern6_0);
            let expr5_0 = constructor_push_break_if(ctx, pattern0_0, &expr3_0, &expr4_0)?;
            let expr6_0 = RxSBGOp::Insert;
            let expr7_0: u8 = 32;
            let expr8_0: u8 = 48;
            let expr9_0: i8 = 0;
            let expr10_0 = constructor_push_rxsbg(
                ctx, pattern0_0, &expr6_0, pattern7_0, pattern8_0, expr2_0, expr7_0, expr8_0,
                expr9_0,
            )?;
            return Some(expr10_0);
        }
    }
    if let Some(pattern2_0) = C::ty_32_or_64(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        if let Some(()) = C::littleendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            let pattern9_0 = arg7;
            // Rule at src/isa/s390x/lower.isle line 1717.
            let expr0_0 =
                constructor_push_bswap_reg(ctx, pattern0_0, pattern2_0, pattern7_0, pattern8_0)?;
            let expr1_0 = constructor_cmp_rr(ctx, pattern5_0, pattern9_0, expr0_0)?;
            let expr2_0 = C::invert_cond(ctx, pattern6_0);
            let expr3_0 = constructor_push_break_if(ctx, pattern0_0, &expr1_0, &expr2_0)?;
            let expr4_0 =
                constructor_push_bswap_reg(ctx, pattern0_0, pattern2_0, pattern7_0, pattern9_0)?;
            return Some(expr4_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            let pattern9_0 = arg7;
            // Rule at src/isa/s390x/lower.isle line 1710.
            let expr0_0 = constructor_cmp_rr(ctx, pattern5_0, pattern9_0, pattern8_0)?;
            let expr1_0 = C::invert_cond(ctx, pattern6_0);
            let expr2_0 = constructor_push_break_if(ctx, pattern0_0, &expr0_0, &expr1_0)?;
            return Some(pattern9_0);
        }
    }
    return None;
}

// Generated as internal constructor for term atomic_cas_body.
pub fn constructor_atomic_cas_body<C: Context>(
    ctx: &mut C,
    arg0: &VecMInstBuilder,
    arg1: Type,
    arg2: MemFlags,
    arg3: WritableReg,
    arg4: Reg,
    arg5: Reg,
    arg6: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        let pattern6_0 = arg5;
        let pattern7_0 = arg6;
        // Rule at src/isa/s390x/lower.isle line 1794.
        let expr0_0 = RxSBGOp::Xor;
        let expr1_0: u8 = 32;
        let expr2_0: u8 = 40;
        let expr3_0: i8 = 24;
        let expr4_0 = constructor_rxsbg_test(
            ctx, &expr0_0, pattern5_0, pattern6_0, expr1_0, expr2_0, expr3_0,
        )?;
        let expr5_0 = IntCC::NotEqual;
        let expr6_0 = C::intcc_as_cond(ctx, &expr5_0);
        let expr7_0 = constructor_push_break_if(ctx, pattern0_0, &expr4_0, &expr6_0)?;
        let expr8_0 = RxSBGOp::Insert;
        let expr9_0: u8 = 32;
        let expr10_0: u8 = 40;
        let expr11_0: i8 = 24;
        let expr12_0 = constructor_push_rxsbg(
            ctx, pattern0_0, &expr8_0, pattern4_0, pattern5_0, pattern7_0, expr9_0, expr10_0,
            expr11_0,
        )?;
        return Some(expr12_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        if let Some(()) = C::littleendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1812.
            let expr0_0: Type = I32;
            let expr1_0 = constructor_bswap_reg(ctx, expr0_0, pattern7_0)?;
            let expr2_0: Type = I32;
            let expr3_0 = constructor_bswap_reg(ctx, expr2_0, pattern8_0)?;
            let expr4_0 = RxSBGOp::Xor;
            let expr5_0: u8 = 48;
            let expr6_0: u8 = 64;
            let expr7_0: i8 = -16;
            let expr8_0 = constructor_rxsbg_test(
                ctx, &expr4_0, pattern6_0, expr1_0, expr5_0, expr6_0, expr7_0,
            )?;
            let expr9_0 = IntCC::NotEqual;
            let expr10_0 = C::intcc_as_cond(ctx, &expr9_0);
            let expr11_0 = constructor_push_break_if(ctx, pattern0_0, &expr8_0, &expr10_0)?;
            let expr12_0 = RxSBGOp::Insert;
            let expr13_0: u8 = 48;
            let expr14_0: u8 = 64;
            let expr15_0: i8 = -16;
            let expr16_0 = constructor_push_rxsbg(
                ctx, pattern0_0, &expr12_0, pattern5_0, pattern6_0, expr3_0, expr13_0, expr14_0,
                expr15_0,
            )?;
            return Some(expr16_0);
        }
        if let Some(()) = C::bigendian(ctx, pattern3_0) {
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            let pattern7_0 = arg5;
            let pattern8_0 = arg6;
            // Rule at src/isa/s390x/lower.isle line 1801.
            let expr0_0 = RxSBGOp::Xor;
            let expr1_0: u8 = 32;
            let expr2_0: u8 = 48;
            let expr3_0: i8 = 16;
            let expr4_0 = constructor_rxsbg_test(
                ctx, &expr0_0, pattern6_0, pattern7_0, expr1_0, expr2_0, expr3_0,
            )?;
            let expr5_0 = IntCC::NotEqual;
            let expr6_0 = C::intcc_as_cond(ctx, &expr5_0);
            let expr7_0 = constructor_push_break_if(ctx, pattern0_0, &expr4_0, &expr6_0)?;
            let expr8_0 = RxSBGOp::Insert;
            let expr9_0: u8 = 32;
            let expr10_0: u8 = 48;
            let expr11_0: i8 = 16;
            let expr12_0 = constructor_push_rxsbg(
                ctx, pattern0_0, &expr8_0, pattern5_0, pattern6_0, pattern8_0, expr9_0, expr10_0,
                expr11_0,
            )?;
            return Some(expr12_0);
        }
    }
    return None;
}

// Generated as internal constructor for term atomic_store_impl.
pub fn constructor_atomic_store_impl<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/lower.isle line 1858.
    let expr0_0 = constructor_side_effect(ctx, pattern0_0)?;
    let expr1_0 = constructor_fence_impl(ctx)?;
    let expr2_0 = constructor_side_effect(ctx, &expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term icmp_val.
pub fn constructor_icmp_val<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: &IntCC,
    arg2: Value,
    arg3: Value,
) -> Option<ProducesBool> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(()) = C::signed(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1925.
        let expr0_0 = constructor_icmps_val(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr1_0 = C::intcc_as_cond(ctx, pattern1_0);
        let expr2_0 = constructor_bool(ctx, &expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    if let Some(()) = C::unsigned(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1928.
        let expr0_0 = constructor_icmpu_val(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr1_0 = C::intcc_as_cond(ctx, pattern1_0);
        let expr2_0 = constructor_bool(ctx, &expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term icmps_val.
pub fn constructor_icmps_val<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Value,
    arg2: Value,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    if pattern0_0 == true {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if let Some(pattern4_0) = C::fits_in_64(ctx, pattern3_0) {
            let pattern5_0 = arg2;
            if let Some(pattern6_0) = C::sinkable_inst(ctx, pattern5_0) {
                let pattern7_0 = C::inst_data(ctx, pattern6_0);
                if let &InstructionData::Load {
                    opcode: ref pattern8_0,
                    arg: pattern8_1,
                    flags: pattern8_2,
                    offset: pattern8_3,
                } = &pattern7_0
                {
                    match pattern8_0 {
                        &Opcode::Sload16 => {
                            if let Some(()) = C::bigendian(ctx, pattern8_2) {
                                // Rule at src/isa/s390x/lower.isle line 1958.
                                let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                let expr1_0 = constructor_sink_sload16(ctx, pattern6_0)?;
                                let expr2_0 = constructor_icmps_mem_sext16(
                                    ctx, pattern4_0, expr0_0, &expr1_0,
                                )?;
                                return Some(expr2_0);
                            }
                        }
                        &Opcode::Sload32 => {
                            if let Some(()) = C::bigendian(ctx, pattern8_2) {
                                // Rule at src/isa/s390x/lower.isle line 1960.
                                let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                let expr1_0 = constructor_sink_sload32(ctx, pattern6_0)?;
                                let expr2_0 = constructor_icmps_mem_sext32(
                                    ctx, pattern4_0, expr0_0, &expr1_0,
                                )?;
                                return Some(expr2_0);
                            }
                        }
                        _ => {}
                    }
                }
            }
            let pattern6_0 = C::value_type(ctx, pattern5_0);
            if pattern6_0 == I16 {
                if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern5_0) {
                    let pattern9_0 = C::inst_data(ctx, pattern8_0);
                    if let &InstructionData::Load {
                        opcode: ref pattern10_0,
                        arg: pattern10_1,
                        flags: pattern10_2,
                        offset: pattern10_3,
                    } = &pattern9_0
                    {
                        if let &Opcode::Load = pattern10_0 {
                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                // Rule at src/isa/s390x/lower.isle line 1954.
                                let expr0_0 = constructor_ty_ext32(ctx, pattern4_0)?;
                                let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern2_0)?;
                                let expr2_0 = constructor_sink_load(ctx, pattern8_0)?;
                                let expr3_0 =
                                    constructor_icmps_mem_sext16(ctx, expr0_0, expr1_0, &expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                    }
                }
            }
            if let Some(pattern7_0) = C::ty_32_or_64(ctx, pattern6_0) {
                if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern5_0) {
                    let pattern9_0 = C::inst_data(ctx, pattern8_0);
                    if let &InstructionData::Load {
                        opcode: ref pattern10_0,
                        arg: pattern10_1,
                        flags: pattern10_2,
                        offset: pattern10_3,
                    } = &pattern9_0
                    {
                        if let &Opcode::Load = pattern10_0 {
                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                // Rule at src/isa/s390x/lower.isle line 1950.
                                let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                let expr1_0 = constructor_sink_load(ctx, pattern8_0)?;
                                let expr2_0 =
                                    constructor_icmps_mem(ctx, pattern4_0, expr0_0, &expr1_0)?;
                                return Some(expr2_0);
                            }
                        }
                    }
                }
            }
        }
    }
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::fits_in_64(ctx, pattern2_0) {
        let pattern4_0 = arg2;
        if let Some(pattern5_0) = C::i16_from_value(ctx, pattern4_0) {
            // Rule at src/isa/s390x/lower.isle line 1944.
            let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
            let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern1_0)?;
            let expr2_0 = constructor_icmps_simm16(ctx, expr0_0, expr1_0, pattern5_0)?;
            return Some(expr2_0);
        }
        if let Some(pattern5_0) = C::i32_from_value(ctx, pattern4_0) {
            // Rule at src/isa/s390x/lower.isle line 1946.
            let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
            let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern1_0)?;
            let expr2_0 = constructor_icmps_simm32(ctx, expr0_0, expr1_0, pattern5_0)?;
            return Some(expr2_0);
        }
        if let Some(pattern5_0) = C::def_inst(ctx, pattern4_0) {
            let pattern6_0 = C::inst_data(ctx, pattern5_0);
            if let &InstructionData::Unary {
                opcode: ref pattern7_0,
                arg: pattern7_1,
            } = &pattern6_0
            {
                if let &Opcode::Sextend = pattern7_0 {
                    let pattern9_0 = C::value_type(ctx, pattern7_1);
                    if pattern9_0 == I32 {
                        // Rule at src/isa/s390x/lower.isle line 1940.
                        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr2_0 =
                            constructor_icmps_reg_sext32(ctx, pattern3_0, expr0_0, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/lower.isle line 1936.
        let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
        let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern1_0)?;
        let expr2_0 = constructor_put_in_reg_sext32(ctx, pattern4_0)?;
        let expr3_0 = constructor_icmps_reg(ctx, expr0_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    return None;
}

// Generated as internal constructor for term icmpu_val.
pub fn constructor_icmpu_val<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Value,
    arg2: Value,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    if pattern0_0 == true {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if let Some(pattern4_0) = C::fits_in_64(ctx, pattern3_0) {
            let pattern5_0 = arg2;
            if let Some(pattern6_0) = C::sinkable_inst(ctx, pattern5_0) {
                let pattern7_0 = C::inst_data(ctx, pattern6_0);
                if let &InstructionData::Load {
                    opcode: ref pattern8_0,
                    arg: pattern8_1,
                    flags: pattern8_2,
                    offset: pattern8_3,
                } = &pattern7_0
                {
                    match pattern8_0 {
                        &Opcode::Uload16 => {
                            if let Some(pattern10_0) = C::def_inst(ctx, pattern8_1) {
                                let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                if let &InstructionData::UnaryGlobalValue {
                                    opcode: ref pattern12_0,
                                    global_value: pattern12_1,
                                } = &pattern11_0
                                {
                                    if let &Opcode::SymbolValue = pattern12_0 {
                                        if let Some((pattern14_0, pattern14_1, pattern14_2)) =
                                            C::symbol_value_data(ctx, pattern12_1)
                                        {
                                            if let Some(()) =
                                                C::reloc_distance_near(ctx, pattern14_1)
                                            {
                                                let pattern16_0 =
                                                    C::i64_from_offset(ctx, pattern8_3);
                                                let closure17 = || {
                                                    return Some(pattern14_2);
                                                };
                                                if let Some(pattern17_0) = closure17() {
                                                    if let Some(pattern18_0) =
                                                        C::memarg_symbol_offset_sum(
                                                            ctx,
                                                            pattern16_0,
                                                            pattern17_0,
                                                        )
                                                    {
                                                        let pattern19_0 =
                                                            C::inst_data(ctx, pattern6_0);
                                                        if let &InstructionData::Load {
                                                            opcode: ref pattern20_0,
                                                            arg: pattern20_1,
                                                            flags: pattern20_2,
                                                            offset: pattern20_3,
                                                        } = &pattern19_0
                                                        {
                                                            if let &Opcode::Uload16 = pattern20_0 {
                                                                if let Some(()) =
                                                                    C::bigendian(ctx, pattern20_2)
                                                                {
                                                                    // Rule at src/isa/s390x/lower.isle line 1993.
                                                                    let expr0_0 = C::put_in_reg(
                                                                        ctx, pattern2_0,
                                                                    );
                                                                    let expr1_0 =
                                                                        constructor_sink_uload16(
                                                                            ctx, pattern6_0,
                                                                        )?;
                                                                    let expr2_0 = constructor_icmpu_mem_zext16(ctx, pattern4_0, expr0_0, &expr1_0)?;
                                                                    return Some(expr2_0);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        &Opcode::Uload32 => {
                            if let Some(()) = C::bigendian(ctx, pattern8_2) {
                                // Rule at src/isa/s390x/lower.isle line 1996.
                                let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                let expr1_0 = constructor_sink_uload32(ctx, pattern6_0)?;
                                let expr2_0 = constructor_icmpu_mem_zext32(
                                    ctx, pattern4_0, expr0_0, &expr1_0,
                                )?;
                                return Some(expr2_0);
                            }
                        }
                        _ => {}
                    }
                }
            }
            let pattern6_0 = C::value_type(ctx, pattern5_0);
            if pattern6_0 == I16 {
                if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern5_0) {
                    let pattern9_0 = C::inst_data(ctx, pattern8_0);
                    if let &InstructionData::Load {
                        opcode: ref pattern10_0,
                        arg: pattern10_1,
                        flags: pattern10_2,
                        offset: pattern10_3,
                    } = &pattern9_0
                    {
                        if let &Opcode::Load = pattern10_0 {
                            if let Some(pattern12_0) = C::def_inst(ctx, pattern10_1) {
                                let pattern13_0 = C::inst_data(ctx, pattern12_0);
                                if let &InstructionData::UnaryGlobalValue {
                                    opcode: ref pattern14_0,
                                    global_value: pattern14_1,
                                } = &pattern13_0
                                {
                                    if let &Opcode::SymbolValue = pattern14_0 {
                                        if let Some((pattern16_0, pattern16_1, pattern16_2)) =
                                            C::symbol_value_data(ctx, pattern14_1)
                                        {
                                            if let Some(()) =
                                                C::reloc_distance_near(ctx, pattern16_1)
                                            {
                                                let pattern18_0 =
                                                    C::i64_from_offset(ctx, pattern10_3);
                                                let closure19 = || {
                                                    return Some(pattern16_2);
                                                };
                                                if let Some(pattern19_0) = closure19() {
                                                    if let Some(pattern20_0) =
                                                        C::memarg_symbol_offset_sum(
                                                            ctx,
                                                            pattern18_0,
                                                            pattern19_0,
                                                        )
                                                    {
                                                        let pattern21_0 =
                                                            C::inst_data(ctx, pattern8_0);
                                                        if let &InstructionData::Load {
                                                            opcode: ref pattern22_0,
                                                            arg: pattern22_1,
                                                            flags: pattern22_2,
                                                            offset: pattern22_3,
                                                        } = &pattern21_0
                                                        {
                                                            if let &Opcode::Load = pattern22_0 {
                                                                if let Some(()) =
                                                                    C::bigendian(ctx, pattern22_2)
                                                                {
                                                                    // Rule at src/isa/s390x/lower.isle line 1986.
                                                                    let expr0_0 =
                                                                        constructor_ty_ext32(
                                                                            ctx, pattern4_0,
                                                                        )?;
                                                                    let expr1_0 = constructor_put_in_reg_zext32(ctx, pattern2_0)?;
                                                                    let expr2_0 =
                                                                        constructor_sink_load(
                                                                            ctx, pattern8_0,
                                                                        )?;
                                                                    let expr3_0 = constructor_icmpu_mem_zext16(ctx, expr0_0, expr1_0, &expr2_0)?;
                                                                    return Some(expr3_0);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if let Some(pattern7_0) = C::ty_32_or_64(ctx, pattern6_0) {
                if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern5_0) {
                    let pattern9_0 = C::inst_data(ctx, pattern8_0);
                    if let &InstructionData::Load {
                        opcode: ref pattern10_0,
                        arg: pattern10_1,
                        flags: pattern10_2,
                        offset: pattern10_3,
                    } = &pattern9_0
                    {
                        if let &Opcode::Load = pattern10_0 {
                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                // Rule at src/isa/s390x/lower.isle line 1980.
                                let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                let expr1_0 = constructor_sink_load(ctx, pattern8_0)?;
                                let expr2_0 =
                                    constructor_icmpu_mem(ctx, pattern4_0, expr0_0, &expr1_0)?;
                                return Some(expr2_0);
                            }
                        }
                    }
                }
            }
        }
    }
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::fits_in_64(ctx, pattern2_0) {
        let pattern4_0 = arg2;
        if let Some(pattern5_0) = C::u32_from_value(ctx, pattern4_0) {
            // Rule at src/isa/s390x/lower.isle line 1976.
            let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
            let expr1_0 = constructor_put_in_reg_zext32(ctx, pattern1_0)?;
            let expr2_0 = constructor_icmpu_uimm32(ctx, expr0_0, expr1_0, pattern5_0)?;
            return Some(expr2_0);
        }
        if let Some(pattern5_0) = C::def_inst(ctx, pattern4_0) {
            let pattern6_0 = C::inst_data(ctx, pattern5_0);
            if let &InstructionData::Unary {
                opcode: ref pattern7_0,
                arg: pattern7_1,
            } = &pattern6_0
            {
                if let &Opcode::Uextend = pattern7_0 {
                    let pattern9_0 = C::value_type(ctx, pattern7_1);
                    if pattern9_0 == I32 {
                        // Rule at src/isa/s390x/lower.isle line 1972.
                        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr2_0 =
                            constructor_icmpu_reg_zext32(ctx, pattern3_0, expr0_0, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/lower.isle line 1968.
        let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
        let expr1_0 = constructor_put_in_reg_zext32(ctx, pattern1_0)?;
        let expr2_0 = constructor_put_in_reg_zext32(ctx, pattern4_0)?;
        let expr3_0 = constructor_icmpu_reg(ctx, expr0_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    return None;
}

// Generated as internal constructor for term fcmp_val.
pub fn constructor_fcmp_val<C: Context>(
    ctx: &mut C,
    arg0: &FloatCC,
    arg1: Value,
    arg2: Value,
) -> Option<ProducesBool> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    let pattern3_0 = arg2;
    // Rule at src/isa/s390x/lower.isle line 2009.
    let expr0_0 = C::put_in_reg(ctx, pattern1_0);
    let expr1_0 = C::put_in_reg(ctx, pattern3_0);
    let expr2_0 = constructor_fcmp_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
    let expr3_0 = C::floatcc_as_cond(ctx, pattern0_0);
    let expr4_0 = constructor_bool(ctx, &expr2_0, &expr3_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term value_nonzero.
pub fn constructor_value_nonzero<C: Context>(ctx: &mut C, arg0: Value) -> Option<ProducesBool> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::def_inst(ctx, pattern0_0) {
        let pattern2_0 = C::inst_data(ctx, pattern1_0);
        match &pattern2_0 {
            &InstructionData::FloatCompare {
                opcode: ref pattern3_0,
                args: ref pattern3_1,
                cond: ref pattern3_2,
            } => {
                if let &Opcode::Fcmp = pattern3_0 {
                    let (pattern5_0, pattern5_1) = C::unpack_value_array_2(ctx, pattern3_1);
                    // Rule at src/isa/s390x/lower.isle line 2037.
                    let expr0_0 = constructor_fcmp_val(ctx, pattern3_2, pattern5_0, pattern5_1)?;
                    return Some(expr0_0);
                }
            }
            &InstructionData::IntCompare {
                opcode: ref pattern3_0,
                args: ref pattern3_1,
                cond: ref pattern3_2,
            } => {
                if let &Opcode::Icmp = pattern3_0 {
                    let (pattern5_0, pattern5_1) = C::unpack_value_array_2(ctx, pattern3_1);
                    // Rule at src/isa/s390x/lower.isle line 2036.
                    let expr0_0: bool = false;
                    let expr1_0 =
                        constructor_icmp_val(ctx, expr0_0, pattern3_2, pattern5_0, pattern5_1)?;
                    return Some(expr1_0);
                }
            }
            &InstructionData::Unary {
                opcode: ref pattern3_0,
                arg: pattern3_1,
            } => {
                if let &Opcode::Bint = pattern3_0 {
                    // Rule at src/isa/s390x/lower.isle line 2035.
                    let expr0_0 = constructor_value_nonzero(ctx, pattern3_1)?;
                    return Some(expr0_0);
                }
            }
            _ => {}
        }
    }
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::gpr32_ty(ctx, pattern1_0) {
        // Rule at src/isa/s390x/lower.isle line 2038.
        let expr0_0: Type = I32;
        let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern0_0)?;
        let expr2_0: i16 = 0;
        let expr3_0 = constructor_icmps_simm16(ctx, expr0_0, expr1_0, expr2_0)?;
        let expr4_0 = IntCC::NotEqual;
        let expr5_0 = C::intcc_as_cond(ctx, &expr4_0);
        let expr6_0 = constructor_bool(ctx, &expr3_0, &expr5_0)?;
        return Some(expr6_0);
    }
    if let Some(pattern2_0) = C::gpr64_ty(ctx, pattern1_0) {
        // Rule at src/isa/s390x/lower.isle line 2041.
        let expr0_0: Type = I64;
        let expr1_0 = C::put_in_reg(ctx, pattern0_0);
        let expr2_0: i16 = 0;
        let expr3_0 = constructor_icmps_simm16(ctx, expr0_0, expr1_0, expr2_0)?;
        let expr4_0 = IntCC::NotEqual;
        let expr5_0 = C::intcc_as_cond(ctx, &expr4_0);
        let expr6_0 = constructor_bool(ctx, &expr3_0, &expr5_0)?;
        return Some(expr6_0);
    }
    return None;
}
