// GENERATED BY ISLE. DO NOT EDIT!
//
// Generated automatically from the instruction-selection DSL code in:
// - src/clif.isle
// - src/prelude.isle
// - src/isa/aarch64/inst.isle
// - src/isa/aarch64/lower.isle

#![allow(dead_code, unreachable_code, unreachable_patterns)]
#![allow(unused_imports, unused_variables, non_snake_case)]
#![allow(irrefutable_let_patterns)]

use super::*; // Pulls in all external types.

/// Context during lowering: an implementation of this trait
/// must be provided with all external constructors and extractors.
/// A mutable borrow is passed along through all lowering logic.
pub trait Context {
    fn unpack_value_array_2(&mut self, arg0: &ValueArray2) -> (Value, Value);
    fn pack_value_array_2(&mut self, arg0: Value, arg1: Value) -> ValueArray2;
    fn unpack_value_array_3(&mut self, arg0: &ValueArray3) -> (Value, Value, Value);
    fn pack_value_array_3(&mut self, arg0: Value, arg1: Value, arg2: Value) -> ValueArray3;
    fn u32_add(&mut self, arg0: u32, arg1: u32) -> u32;
    fn u8_and(&mut self, arg0: u8, arg1: u8) -> u8;
    fn value_reg(&mut self, arg0: Reg) -> ValueRegs;
    fn value_regs(&mut self, arg0: Reg, arg1: Reg) -> ValueRegs;
    fn value_regs_invalid(&mut self) -> ValueRegs;
    fn output_none(&mut self) -> InstOutput;
    fn output(&mut self, arg0: ValueRegs) -> InstOutput;
    fn output_pair(&mut self, arg0: ValueRegs, arg1: ValueRegs) -> InstOutput;
    fn output_builder_new(&mut self) -> InstOutputBuilder;
    fn output_builder_push(&mut self, arg0: &InstOutputBuilder, arg1: ValueRegs) -> Unit;
    fn output_builder_finish(&mut self, arg0: &InstOutputBuilder) -> InstOutput;
    fn temp_writable_reg(&mut self, arg0: Type) -> WritableReg;
    fn invalid_reg(&mut self) -> Reg;
    fn put_in_reg(&mut self, arg0: Value) -> Reg;
    fn put_in_regs(&mut self, arg0: Value) -> ValueRegs;
    fn value_regs_get(&mut self, arg0: ValueRegs, arg1: usize) -> Reg;
    fn u8_as_u64(&mut self, arg0: u8) -> u64;
    fn u16_as_u64(&mut self, arg0: u16) -> u64;
    fn u32_as_u64(&mut self, arg0: u32) -> u64;
    fn i64_as_u64(&mut self, arg0: i64) -> u64;
    fn u64_add(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_sub(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_and(&mut self, arg0: u64, arg1: u64) -> u64;
    fn ty_bits(&mut self, arg0: Type) -> u8;
    fn ty_bits_u16(&mut self, arg0: Type) -> u16;
    fn ty_bits_u64(&mut self, arg0: Type) -> u64;
    fn ty_mask(&mut self, arg0: Type) -> u64;
    fn ty_bytes(&mut self, arg0: Type) -> u16;
    fn lane_type(&mut self, arg0: Type) -> Type;
    fn fits_in_16(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_32_or_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_8_or_16(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_bool_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_bool_128(&mut self, arg0: Type) -> Option<Type>;
    fn ty_scalar_float(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec128(&mut self, arg0: Type) -> Option<Type>;
    fn not_i64x2(&mut self, arg0: Type) -> Option<()>;
    fn value_list_slice(&mut self, arg0: ValueList) -> ValueSlice;
    fn value_slice_empty(&mut self, arg0: ValueSlice) -> Option<()>;
    fn value_slice_unwrap(&mut self, arg0: ValueSlice) -> Option<(Value, ValueSlice)>;
    fn value_slice_len(&mut self, arg0: ValueSlice) -> usize;
    fn value_slice_get(&mut self, arg0: ValueSlice, arg1: usize) -> Value;
    fn writable_reg_to_reg(&mut self, arg0: WritableReg) -> Reg;
    fn u8_from_uimm8(&mut self, arg0: Uimm8) -> u8;
    fn u64_from_imm64(&mut self, arg0: Imm64) -> u64;
    fn nonzero_u64_from_imm64(&mut self, arg0: Imm64) -> Option<u64>;
    fn u64_from_ieee32(&mut self, arg0: Ieee32) -> u64;
    fn u64_from_ieee64(&mut self, arg0: Ieee64) -> u64;
    fn inst_results(&mut self, arg0: Inst) -> ValueSlice;
    fn first_result(&mut self, arg0: Inst) -> Option<Value>;
    fn inst_data(&mut self, arg0: Inst) -> InstructionData;
    fn value_type(&mut self, arg0: Value) -> Type;
    fn multi_lane(&mut self, arg0: Type) -> Option<(u8, u16)>;
    fn def_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn emit(&mut self, arg0: &MInst) -> Unit;
    fn emit_safepoint(&mut self, arg0: &MInst) -> Unit;
    fn trap_code_division_by_zero(&mut self) -> TrapCode;
    fn trap_code_integer_overflow(&mut self) -> TrapCode;
    fn trap_code_bad_conversion_to_integer(&mut self) -> TrapCode;
    fn avoid_div_traps(&mut self, arg0: Type) -> Option<()>;
    fn func_ref_data(&mut self, arg0: FuncRef) -> (SigRef, ExternalName, RelocDistance);
    fn symbol_value_data(
        &mut self,
        arg0: GlobalValue,
    ) -> Option<(ExternalName, RelocDistance, i64)>;
    fn reloc_distance_near(&mut self, arg0: RelocDistance) -> Option<()>;
    fn move_wide_const_from_u64(&mut self, arg0: u64) -> Option<MoveWideConst>;
    fn move_wide_const_from_negated_u64(&mut self, arg0: u64) -> Option<MoveWideConst>;
    fn imm_logic_from_u64(&mut self, arg0: u64, arg1: Type) -> Option<ImmLogic>;
    fn imm_logic_from_imm64(&mut self, arg0: Imm64, arg1: Type) -> Option<ImmLogic>;
    fn imm_shift_from_imm64(&mut self, arg0: Imm64, arg1: Type) -> Option<ImmShift>;
    fn imm_shift_from_u8(&mut self, arg0: u8) -> ImmShift;
    fn imm12_from_u64(&mut self, arg0: u64) -> Option<Imm12>;
    fn u8_into_uimm5(&mut self, arg0: u8) -> UImm5;
    fn u8_into_imm12(&mut self, arg0: u8) -> Imm12;
    fn u64_into_imm_logic(&mut self, arg0: Type, arg1: u64) -> ImmLogic;
    fn imm12_from_negated_u64(&mut self, arg0: u64) -> Option<Imm12>;
    fn lshl_from_imm64(&mut self, arg0: Imm64, arg1: Type) -> Option<ShiftOpAndAmt>;
    fn integral_ty(&mut self, arg0: Type) -> Option<Type>;
    fn extended_value_from_value(&mut self, arg0: Value) -> Option<ExtendedValue>;
    fn put_extended_in_reg(&mut self, arg0: &ExtendedValue) -> Reg;
    fn get_extended_op(&mut self, arg0: &ExtendedValue) -> ExtendOp;
    fn nzcv(&mut self, arg0: bool, arg1: bool, arg2: bool, arg3: bool) -> NZCV;
    fn cond_br_zero(&mut self, arg0: Reg) -> CondBrKind;
    fn cond_br_cond(&mut self, arg0: &Cond) -> CondBrKind;
    fn zero_reg(&mut self) -> Reg;
    fn writable_zero_reg(&mut self) -> WritableReg;
    fn load_constant64_full(&mut self, arg0: u64) -> Reg;
    fn sinkable_atomic_load(&mut self, arg0: Value) -> Option<SinkableAtomicLoad>;
    fn sink_atomic_load(&mut self, arg0: &SinkableAtomicLoad) -> Reg;
    fn zero_value_f32(&mut self, arg0: Ieee32) -> Option<Ieee32>;
    fn zero_value_f64(&mut self, arg0: Ieee64) -> Option<Ieee64>;
    fn float_cc_cmp_zero_to_vec_misc_op(&mut self, arg0: &FloatCC) -> VecMisc2;
    fn float_cc_cmp_zero_to_vec_misc_op_swap(&mut self, arg0: &FloatCC) -> VecMisc2;
    fn fcmp_zero_cond(&mut self, arg0: &FloatCC) -> Option<FloatCC>;
    fn fcmp_zero_cond_not_eq(&mut self, arg0: &FloatCC) -> Option<FloatCC>;
    fn zero_value(&mut self, arg0: Imm64) -> Option<Imm64>;
    fn int_cc_cmp_zero_to_vec_misc_op(&mut self, arg0: &IntCC) -> VecMisc2;
    fn int_cc_cmp_zero_to_vec_misc_op_swap(&mut self, arg0: &IntCC) -> VecMisc2;
    fn icmp_zero_cond(&mut self, arg0: &IntCC) -> Option<IntCC>;
    fn icmp_zero_cond_not_eq(&mut self, arg0: &IntCC) -> Option<IntCC>;
    fn safe_divisor_from_imm64(&mut self, arg0: Imm64) -> Option<u64>;
    fn shift_mask(&mut self, arg0: Type) -> ImmLogic;
    fn negate_imm_shift(&mut self, arg0: Type, arg1: ImmShift) -> ImmShift;
    fn rotr_mask(&mut self, arg0: Type) -> ImmLogic;
    fn rotr_opposite_amount(&mut self, arg0: Type, arg1: ImmShift) -> ImmShift;
}

/// Internal type SideEffectNoResult: defined at src/prelude.isle line 397.
#[derive(Clone, Debug)]
pub enum SideEffectNoResult {
    Inst { inst: MInst },
}

/// Internal type ProducesFlags: defined at src/prelude.isle line 419.
#[derive(Clone, Debug)]
pub enum ProducesFlags {
    ProducesFlagsSideEffect { inst: MInst },
    ProducesFlagsReturnsReg { inst: MInst, result: Reg },
    ProducesFlagsReturnsResultWithConsumer { inst: MInst, result: Reg },
}

/// Internal type ConsumesFlags: defined at src/prelude.isle line 430.
#[derive(Clone, Debug)]
pub enum ConsumesFlags {
    ConsumesFlagsReturnsResultWithProducer {
        inst: MInst,
        result: Reg,
    },
    ConsumesFlagsReturnsReg {
        inst: MInst,
        result: Reg,
    },
    ConsumesFlagsTwiceReturnsValueRegs {
        inst1: MInst,
        inst2: MInst,
        result: ValueRegs,
    },
    ConsumesFlagsFourTimesReturnsValueRegs {
        inst1: MInst,
        inst2: MInst,
        inst3: MInst,
        inst4: MInst,
        result: ValueRegs,
    },
}

/// Internal type MInst: defined at src/isa/aarch64/inst.isle line 2.
#[derive(Clone, Debug)]
pub enum MInst {
    Nop0,
    Nop4,
    AluRRR {
        alu_op: ALUOp,
        size: OperandSize,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
    },
    AluRRRR {
        alu_op: ALUOp3,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        ra: Reg,
    },
    AluRRImm12 {
        alu_op: ALUOp,
        size: OperandSize,
        rd: WritableReg,
        rn: Reg,
        imm12: Imm12,
    },
    AluRRImmLogic {
        alu_op: ALUOp,
        size: OperandSize,
        rd: WritableReg,
        rn: Reg,
        imml: ImmLogic,
    },
    AluRRImmShift {
        alu_op: ALUOp,
        size: OperandSize,
        rd: WritableReg,
        rn: Reg,
        immshift: ImmShift,
    },
    AluRRRShift {
        alu_op: ALUOp,
        size: OperandSize,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        shiftop: ShiftOpAndAmt,
    },
    AluRRRExtend {
        alu_op: ALUOp,
        size: OperandSize,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        extendop: ExtendOp,
    },
    BitRR {
        op: BitOp,
        size: OperandSize,
        rd: WritableReg,
        rn: Reg,
    },
    ULoad8 {
        rd: WritableReg,
        mem: AMode,
        flags: MemFlags,
    },
    SLoad8 {
        rd: WritableReg,
        mem: AMode,
        flags: MemFlags,
    },
    ULoad16 {
        rd: WritableReg,
        mem: AMode,
        flags: MemFlags,
    },
    SLoad16 {
        rd: WritableReg,
        mem: AMode,
        flags: MemFlags,
    },
    ULoad32 {
        rd: WritableReg,
        mem: AMode,
        flags: MemFlags,
    },
    SLoad32 {
        rd: WritableReg,
        mem: AMode,
        flags: MemFlags,
    },
    ULoad64 {
        rd: WritableReg,
        mem: AMode,
        flags: MemFlags,
    },
    Store8 {
        rd: Reg,
        mem: AMode,
        flags: MemFlags,
    },
    Store16 {
        rd: Reg,
        mem: AMode,
        flags: MemFlags,
    },
    Store32 {
        rd: Reg,
        mem: AMode,
        flags: MemFlags,
    },
    Store64 {
        rd: Reg,
        mem: AMode,
        flags: MemFlags,
    },
    StoreP64 {
        rt: Reg,
        rt2: Reg,
        mem: PairAMode,
        flags: MemFlags,
    },
    LoadP64 {
        rt: WritableReg,
        rt2: WritableReg,
        mem: PairAMode,
        flags: MemFlags,
    },
    Mov64 {
        rd: WritableReg,
        rm: Reg,
    },
    Mov32 {
        rd: WritableReg,
        rm: Reg,
    },
    MovZ {
        rd: WritableReg,
        imm: MoveWideConst,
        size: OperandSize,
    },
    MovN {
        rd: WritableReg,
        imm: MoveWideConst,
        size: OperandSize,
    },
    MovK {
        rd: WritableReg,
        imm: MoveWideConst,
        size: OperandSize,
    },
    Extend {
        rd: WritableReg,
        rn: Reg,
        signed: bool,
        from_bits: u8,
        to_bits: u8,
    },
    CSel {
        rd: WritableReg,
        cond: Cond,
        rn: Reg,
        rm: Reg,
    },
    CSet {
        rd: WritableReg,
        cond: Cond,
    },
    CSetm {
        rd: WritableReg,
        cond: Cond,
    },
    CCmpImm {
        size: OperandSize,
        rn: Reg,
        imm: UImm5,
        nzcv: NZCV,
        cond: Cond,
    },
    AtomicRMWLoop {
        ty: Type,
        op: AtomicRmwOp,
    },
    AtomicRMW {
        op: AtomicRMWOp,
        rs: Reg,
        rt: WritableReg,
        rn: Reg,
        ty: Type,
    },
    AtomicCAS {
        rs: WritableReg,
        rt: Reg,
        rn: Reg,
        ty: Type,
    },
    AtomicCASLoop {
        ty: Type,
    },
    LoadAcquire {
        access_ty: Type,
        rt: WritableReg,
        rn: Reg,
    },
    StoreRelease {
        access_ty: Type,
        rt: Reg,
        rn: Reg,
    },
    Fence,
    FpuMove64 {
        rd: WritableReg,
        rn: Reg,
    },
    FpuMove128 {
        rd: WritableReg,
        rn: Reg,
    },
    FpuMoveFromVec {
        rd: WritableReg,
        rn: Reg,
        idx: u8,
        size: VectorSize,
    },
    FpuExtend {
        rd: WritableReg,
        rn: Reg,
        size: ScalarSize,
    },
    FpuRR {
        fpu_op: FPUOp1,
        rd: WritableReg,
        rn: Reg,
    },
    FpuRRR {
        fpu_op: FPUOp2,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
    },
    FpuRRI {
        fpu_op: FPUOpRI,
        rd: WritableReg,
        rn: Reg,
    },
    FpuRRRR {
        fpu_op: FPUOp3,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        ra: Reg,
    },
    FpuCmp32 {
        rn: Reg,
        rm: Reg,
    },
    FpuCmp64 {
        rn: Reg,
        rm: Reg,
    },
    FpuLoad32 {
        rd: WritableReg,
        mem: AMode,
        flags: MemFlags,
    },
    FpuStore32 {
        rd: Reg,
        mem: AMode,
        flags: MemFlags,
    },
    FpuLoad64 {
        rd: WritableReg,
        mem: AMode,
        flags: MemFlags,
    },
    FpuStore64 {
        rd: Reg,
        mem: AMode,
        flags: MemFlags,
    },
    FpuLoad128 {
        rd: WritableReg,
        mem: AMode,
        flags: MemFlags,
    },
    FpuStore128 {
        rd: Reg,
        mem: AMode,
        flags: MemFlags,
    },
    FpuLoadP64 {
        rt: WritableReg,
        rt2: WritableReg,
        mem: PairAMode,
        flags: MemFlags,
    },
    FpuStoreP64 {
        rt: Reg,
        rt2: Reg,
        mem: PairAMode,
        flags: MemFlags,
    },
    FpuLoadP128 {
        rt: WritableReg,
        rt2: WritableReg,
        mem: PairAMode,
        flags: MemFlags,
    },
    FpuStoreP128 {
        rt: Reg,
        rt2: Reg,
        mem: PairAMode,
        flags: MemFlags,
    },
    LoadFpuConst64 {
        rd: WritableReg,
        const_data: u64,
    },
    LoadFpuConst128 {
        rd: WritableReg,
        const_data: u128,
    },
    FpuToInt {
        op: FpuToIntOp,
        rd: WritableReg,
        rn: Reg,
    },
    IntToFpu {
        op: IntToFpuOp,
        rd: WritableReg,
        rn: Reg,
    },
    FpuCSel32 {
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        cond: Cond,
    },
    FpuCSel64 {
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        cond: Cond,
    },
    FpuRound {
        op: FpuRoundMode,
        rd: WritableReg,
        rn: Reg,
    },
    MovToFpu {
        rd: WritableReg,
        rn: Reg,
        size: ScalarSize,
    },
    FpuMoveFPImm {
        rd: WritableReg,
        imm: ASIMDFPModImm,
        size: ScalarSize,
    },
    MovToVec {
        rd: WritableReg,
        rn: Reg,
        idx: u8,
        size: VectorSize,
    },
    MovFromVec {
        rd: WritableReg,
        rn: Reg,
        idx: u8,
        size: VectorSize,
    },
    MovFromVecSigned {
        rd: WritableReg,
        rn: Reg,
        idx: u8,
        size: VectorSize,
        scalar_size: OperandSize,
    },
    VecDup {
        rd: WritableReg,
        rn: Reg,
        size: VectorSize,
    },
    VecDupFromFpu {
        rd: WritableReg,
        rn: Reg,
        size: VectorSize,
    },
    VecDupFPImm {
        rd: WritableReg,
        imm: ASIMDFPModImm,
        size: VectorSize,
    },
    VecDupImm {
        rd: WritableReg,
        imm: ASIMDMovModImm,
        invert: bool,
        size: VectorSize,
    },
    VecExtend {
        t: VecExtendOp,
        rd: WritableReg,
        rn: Reg,
        high_half: bool,
    },
    VecMovElement {
        rd: WritableReg,
        rn: Reg,
        dest_idx: u8,
        src_idx: u8,
        size: VectorSize,
    },
    VecRRLong {
        op: VecRRLongOp,
        rd: WritableReg,
        rn: Reg,
        high_half: bool,
    },
    VecRRNarrow {
        op: VecRRNarrowOp,
        rd: WritableReg,
        rn: Reg,
        high_half: bool,
    },
    VecRRPair {
        op: VecPairOp,
        rd: WritableReg,
        rn: Reg,
    },
    VecRRRLong {
        alu_op: VecRRRLongOp,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        high_half: bool,
    },
    VecRRPairLong {
        op: VecRRPairLongOp,
        rd: WritableReg,
        rn: Reg,
    },
    VecRRR {
        alu_op: VecALUOp,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        size: VectorSize,
    },
    VecMisc {
        op: VecMisc2,
        rd: WritableReg,
        rn: Reg,
        size: VectorSize,
    },
    VecLanes {
        op: VecLanesOp,
        rd: WritableReg,
        rn: Reg,
        size: VectorSize,
    },
    VecShiftImm {
        op: VecShiftImmOp,
        rd: WritableReg,
        rn: Reg,
        size: VectorSize,
        imm: u8,
    },
    VecExtract {
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        imm4: u8,
    },
    VecTbl {
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        is_extension: bool,
    },
    VecTbl2 {
        rd: WritableReg,
        rn: Reg,
        rn2: Reg,
        rm: Reg,
        is_extension: bool,
    },
    VecLoadReplicate {
        rd: WritableReg,
        rn: Reg,
        size: VectorSize,
    },
    VecCSel {
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
        cond: Cond,
    },
    MovToNZCV {
        rn: Reg,
    },
    MovFromNZCV {
        rd: WritableReg,
    },
    Call {
        info: BoxCallInfo,
    },
    CallInd {
        info: BoxCallIndInfo,
    },
    Ret,
    EpiloguePlaceholder,
    Jump {
        dest: BranchTarget,
    },
    CondBr {
        taken: BranchTarget,
        not_taken: BranchTarget,
        kind: CondBrKind,
    },
    TrapIf {
        kind: CondBrKind,
        trap_code: TrapCode,
    },
    IndirectBr {
        rn: Reg,
        targets: VecMachLabel,
    },
    Brk,
    Udf {
        trap_code: TrapCode,
    },
    Adr {
        rd: WritableReg,
        off: i32,
    },
    Word4 {
        data: u32,
    },
    Word8 {
        data: u64,
    },
    JTSequence {
        info: BoxJTSequenceInfo,
        ridx: Reg,
        rtmp1: WritableReg,
        rtmp2: WritableReg,
    },
    LoadExtName {
        rd: WritableReg,
        name: BoxExternalName,
        offset: i64,
    },
    LoadAddr {
        rd: WritableReg,
        mem: AMode,
    },
    VirtualSPOffsetAdj {
        offset: i64,
    },
    EmitIsland {
        needed_space: CodeOffset,
    },
    ElfTlsGetAddr {
        symbol: ExternalName,
    },
    ValueLabelMarker {
        reg: Reg,
        label: ValueLabel,
    },
    Unwind {
        inst: UnwindInst,
    },
}

/// Internal type ALUOp: defined at src/isa/aarch64/inst.isle line 796.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum ALUOp {
    Add,
    Sub,
    Orr,
    OrrNot,
    And,
    AndS,
    AndNot,
    Eor,
    EorNot,
    AddS,
    SubS,
    SMulH,
    UMulH,
    SDiv,
    UDiv,
    RotR,
    Lsr,
    Asr,
    Lsl,
    Adc,
    AdcS,
    Sbc,
    SbcS,
}

/// Internal type ALUOp3: defined at src/isa/aarch64/inst.isle line 834.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum ALUOp3 {
    MAdd32,
    MAdd64,
    MSub32,
    MSub64,
}

/// Internal type BitOp: defined at src/isa/aarch64/inst.isle line 877.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum BitOp {
    RBit,
    Clz,
    Cls,
}

/// Internal type FPUOp1: defined at src/isa/aarch64/inst.isle line 944.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FPUOp1 {
    Abs32,
    Abs64,
    Neg32,
    Neg64,
    Sqrt32,
    Sqrt64,
    Cvt32To64,
    Cvt64To32,
}

/// Internal type FPUOp2: defined at src/isa/aarch64/inst.isle line 957.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FPUOp2 {
    Add32,
    Add64,
    Sub32,
    Sub64,
    Mul32,
    Mul64,
    Div32,
    Div64,
    Max32,
    Max64,
    Min32,
    Min64,
    Sqadd64,
    Uqadd64,
    Sqsub64,
    Uqsub64,
}

/// Internal type FPUOp3: defined at src/isa/aarch64/inst.isle line 982.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FPUOp3 {
    MAdd32,
    MAdd64,
}

/// Internal type FpuToIntOp: defined at src/isa/aarch64/inst.isle line 989.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FpuToIntOp {
    F32ToU32,
    F32ToI32,
    F32ToU64,
    F32ToI64,
    F64ToU32,
    F64ToI32,
    F64ToU64,
    F64ToI64,
}

/// Internal type IntToFpuOp: defined at src/isa/aarch64/inst.isle line 1002.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum IntToFpuOp {
    U32ToF32,
    I32ToF32,
    U32ToF64,
    I32ToF64,
    U64ToF32,
    I64ToF32,
    U64ToF64,
    I64ToF64,
}

/// Internal type FpuRoundMode: defined at src/isa/aarch64/inst.isle line 1016.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FpuRoundMode {
    Minus32,
    Minus64,
    Plus32,
    Plus64,
    Zero32,
    Zero64,
    Nearest32,
    Nearest64,
}

/// Internal type VecExtendOp: defined at src/isa/aarch64/inst.isle line 1029.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum VecExtendOp {
    Sxtl8,
    Sxtl16,
    Sxtl32,
    Uxtl8,
    Uxtl16,
    Uxtl32,
}

/// Internal type VecALUOp: defined at src/isa/aarch64/inst.isle line 1046.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum VecALUOp {
    Sqadd,
    Uqadd,
    Sqsub,
    Uqsub,
    Cmeq,
    Cmge,
    Cmgt,
    Cmhs,
    Cmhi,
    Fcmeq,
    Fcmgt,
    Fcmge,
    And,
    Bic,
    Orr,
    Eor,
    Bsl,
    Umaxp,
    Add,
    Sub,
    Mul,
    Sshl,
    Ushl,
    Umin,
    Smin,
    Umax,
    Smax,
    Urhadd,
    Fadd,
    Fsub,
    Fdiv,
    Fmax,
    Fmin,
    Fmul,
    Addp,
    Zip1,
    Sqrdmulh,
}

/// Internal type VecMisc2: defined at src/isa/aarch64/inst.isle line 1125.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum VecMisc2 {
    Not,
    Neg,
    Abs,
    Fabs,
    Fneg,
    Fsqrt,
    Rev64,
    Fcvtzs,
    Fcvtzu,
    Scvtf,
    Ucvtf,
    Frintn,
    Frintz,
    Frintm,
    Frintp,
    Cnt,
    Cmeq0,
    Cmge0,
    Cmgt0,
    Cmle0,
    Cmlt0,
    Fcmeq0,
    Fcmge0,
    Fcmgt0,
    Fcmle0,
    Fcmlt0,
}

/// Internal type VecRRLongOp: defined at src/isa/aarch64/inst.isle line 1182.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum VecRRLongOp {
    Fcvtl16,
    Fcvtl32,
    Shll8,
    Shll16,
    Shll32,
}

/// Internal type VecRRNarrowOp: defined at src/isa/aarch64/inst.isle line 1197.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum VecRRNarrowOp {
    Xtn16,
    Xtn32,
    Xtn64,
    Sqxtn16,
    Sqxtn32,
    Sqxtn64,
    Sqxtun16,
    Sqxtun32,
    Sqxtun64,
    Uqxtn16,
    Uqxtn32,
    Uqxtn64,
    Fcvtn32,
    Fcvtn64,
}

/// Internal type VecRRRLongOp: defined at src/isa/aarch64/inst.isle line 1229.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum VecRRRLongOp {
    Smull8,
    Smull16,
    Smull32,
    Umull8,
    Umull16,
    Umull32,
    Umlal8,
    Umlal16,
    Umlal32,
}

/// Internal type VecPairOp: defined at src/isa/aarch64/inst.isle line 1246.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum VecPairOp {
    Addp,
}

/// Internal type VecRRPairLongOp: defined at src/isa/aarch64/inst.isle line 1254.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum VecRRPairLongOp {
    Saddlp8,
    Saddlp16,
    Uaddlp8,
    Uaddlp16,
}

/// Internal type VecLanesOp: defined at src/isa/aarch64/inst.isle line 1265.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum VecLanesOp {
    Addv,
    Uminv,
}

/// Internal type VecShiftImmOp: defined at src/isa/aarch64/inst.isle line 1274.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum VecShiftImmOp {
    Shl,
    Ushr,
    Sshr,
}

/// Internal type AtomicRMWOp: defined at src/isa/aarch64/inst.isle line 1285.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum AtomicRMWOp {
    Add,
    Clr,
    Eor,
    Set,
    Smax,
    Smin,
    Umax,
    Umin,
}

// Generated as internal constructor for term output_reg.
pub fn constructor_output_reg<C: Context>(ctx: &mut C, arg0: Reg) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 86.
    let expr0_0 = C::value_reg(ctx, pattern0_0);
    let expr1_0 = C::output(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term output_value.
pub fn constructor_output_value<C: Context>(ctx: &mut C, arg0: Value) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 90.
    let expr0_0 = C::put_in_regs(ctx, pattern0_0);
    let expr1_0 = C::output(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term temp_reg.
pub fn constructor_temp_reg<C: Context>(ctx: &mut C, arg0: Type) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 110.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term lo_reg.
pub fn constructor_lo_reg<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 145.
    let expr0_0 = C::put_in_regs(ctx, pattern0_0);
    let expr1_0: usize = 0;
    let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term side_effect.
pub fn constructor_side_effect<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    if let &SideEffectNoResult::Inst {
        inst: ref pattern1_0,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 402.
        let expr0_0 = C::emit(ctx, pattern1_0);
        let expr1_0 = C::output_none(ctx);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term safepoint.
pub fn constructor_safepoint<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    if let &SideEffectNoResult::Inst {
        inst: ref pattern1_0,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 408.
        let expr0_0 = C::emit_safepoint(ctx, pattern1_0);
        let expr1_0 = C::output_none(ctx);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term produces_flags_get_reg.
pub fn constructor_produces_flags_get_reg<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlagsReturnsReg {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 446.
        return Some(pattern1_1);
    }
    return None;
}

// Generated as internal constructor for term produces_flags_ignore.
pub fn constructor_produces_flags_ignore<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &ProducesFlags::ProducesFlagsReturnsReg {
            inst: ref pattern1_0,
            result: pattern1_1,
        } => {
            // Rule at src/prelude.isle line 451.
            let expr0_0 = ProducesFlags::ProducesFlagsSideEffect {
                inst: pattern1_0.clone(),
            };
            return Some(expr0_0);
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref pattern1_0,
            result: pattern1_1,
        } => {
            // Rule at src/prelude.isle line 453.
            let expr0_0 = ProducesFlags::ProducesFlagsSideEffect {
                inst: pattern1_0.clone(),
            };
            return Some(expr0_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term consumes_flags_concat.
pub fn constructor_consumes_flags_concat<C: Context>(
    ctx: &mut C,
    arg0: &ConsumesFlags,
    arg1: &ConsumesFlags,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    if let &ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        if let &ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: ref pattern3_0,
            result: pattern3_1,
        } = pattern2_0
        {
            // Rule at src/prelude.isle line 460.
            let expr0_0 = C::value_regs(ctx, pattern1_1, pattern3_1);
            let expr1_0 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                inst1: pattern1_0.clone(),
                inst2: pattern3_0.clone(),
                result: expr0_0,
            };
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term with_flags.
pub fn constructor_with_flags<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &ProducesFlags::ProducesFlagsSideEffect {
            inst: ref pattern1_0,
        } => {
            let pattern2_0 = arg1;
            match pattern2_0 {
                &ConsumesFlags::ConsumesFlagsReturnsReg {
                    inst: ref pattern3_0,
                    result: pattern3_1,
                } => {
                    // Rule at src/prelude.isle line 485.
                    let expr0_0 = C::emit(ctx, pattern1_0);
                    let expr1_0 = C::emit(ctx, pattern3_0);
                    let expr2_0 = C::value_reg(ctx, pattern3_1);
                    return Some(expr2_0);
                }
                &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                    inst1: ref pattern3_0,
                    inst2: ref pattern3_1,
                    result: pattern3_2,
                } => {
                    // Rule at src/prelude.isle line 491.
                    let expr0_0 = C::emit(ctx, pattern1_0);
                    let expr1_0 = C::emit(ctx, pattern3_0);
                    let expr2_0 = C::emit(ctx, pattern3_1);
                    return Some(pattern3_2);
                }
                &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                    inst1: ref pattern3_0,
                    inst2: ref pattern3_1,
                    inst3: ref pattern3_2,
                    inst4: ref pattern3_3,
                    result: pattern3_4,
                } => {
                    // Rule at src/prelude.isle line 503.
                    let expr0_0 = C::emit(ctx, pattern1_0);
                    let expr1_0 = C::emit(ctx, pattern3_0);
                    let expr2_0 = C::emit(ctx, pattern3_1);
                    let expr3_0 = C::emit(ctx, pattern3_2);
                    let expr4_0 = C::emit(ctx, pattern3_3);
                    return Some(pattern3_4);
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref pattern1_0,
            result: pattern1_1,
        } => {
            let pattern2_0 = arg1;
            if let &ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
                inst: ref pattern3_0,
                result: pattern3_1,
            } = pattern2_0
            {
                // Rule at src/prelude.isle line 479.
                let expr0_0 = C::emit(ctx, pattern1_0);
                let expr1_0 = C::emit(ctx, pattern3_0);
                let expr2_0 = C::value_regs(ctx, pattern1_1, pattern3_1);
                return Some(expr2_0);
            }
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term with_flags_reg.
pub fn constructor_with_flags_reg<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/prelude.isle line 520.
    let expr0_0 = constructor_with_flags(ctx, pattern0_0, pattern1_0)?;
    let expr1_0: usize = 0;
    let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term operand_size.
pub fn constructor_operand_size<C: Context>(ctx: &mut C, arg0: Type) -> Option<OperandSize> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::fits_in_32(ctx, pattern0_0) {
        // Rule at src/isa/aarch64/inst.isle line 895.
        let expr0_0 = OperandSize::Size32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::fits_in_64(ctx, pattern0_0) {
        // Rule at src/isa/aarch64/inst.isle line 896.
        let expr0_0 = OperandSize::Size64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term vector_size.
pub fn constructor_vector_size<C: Context>(ctx: &mut C, arg0: Type) -> Option<VectorSize> {
    let pattern0_0 = arg0;
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        if pattern1_0 == 8 {
            if pattern1_1 == 16 {
                // Rule at src/isa/aarch64/inst.isle line 938.
                let expr0_0 = VectorSize::Size8x16;
                return Some(expr0_0);
            }
        }
        if pattern1_0 == 16 {
            if pattern1_1 == 8 {
                // Rule at src/isa/aarch64/inst.isle line 939.
                let expr0_0 = VectorSize::Size16x8;
                return Some(expr0_0);
            }
        }
        if pattern1_0 == 32 {
            if pattern1_1 == 4 {
                // Rule at src/isa/aarch64/inst.isle line 940.
                let expr0_0 = VectorSize::Size32x4;
                return Some(expr0_0);
            }
        }
        if pattern1_0 == 64 {
            if pattern1_1 == 2 {
                // Rule at src/isa/aarch64/inst.isle line 941.
                let expr0_0 = VectorSize::Size64x2;
                return Some(expr0_0);
            }
        }
    }
    return None;
}

// Generated as internal constructor for term movz.
pub fn constructor_movz<C: Context>(
    ctx: &mut C,
    arg0: MoveWideConst,
    arg1: &OperandSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1381.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::MovZ {
        rd: expr1_0,
        imm: pattern0_0,
        size: pattern1_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term movn.
pub fn constructor_movn<C: Context>(
    ctx: &mut C,
    arg0: MoveWideConst,
    arg1: &OperandSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1388.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::MovN {
        rd: expr1_0,
        imm: pattern0_0,
        size: pattern1_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term alu_rr_imm_logic.
pub fn constructor_alu_rr_imm_logic<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Reg,
    arg3: ImmLogic,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1395.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_operand_size(ctx, pattern1_0)?;
    let expr3_0 = MInst::AluRRImmLogic {
        alu_op: pattern0_0.clone(),
        size: expr2_0,
        rd: expr1_0,
        rn: pattern2_0,
        imml: pattern3_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term alu_rr_imm_shift.
pub fn constructor_alu_rr_imm_shift<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Reg,
    arg3: ImmShift,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1402.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_operand_size(ctx, pattern1_0)?;
    let expr3_0 = MInst::AluRRImmShift {
        alu_op: pattern0_0.clone(),
        size: expr2_0,
        rd: expr1_0,
        rn: pattern2_0,
        immshift: pattern3_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term alu_rrr.
pub fn constructor_alu_rrr<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1409.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_operand_size(ctx, pattern1_0)?;
    let expr3_0 = MInst::AluRRR {
        alu_op: pattern0_0.clone(),
        size: expr2_0,
        rd: expr1_0,
        rn: pattern2_0,
        rm: pattern3_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term vec_rrr.
pub fn constructor_vec_rrr<C: Context>(
    ctx: &mut C,
    arg0: &VecALUOp,
    arg1: Reg,
    arg2: Reg,
    arg3: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1416.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::VecRRR {
        alu_op: pattern0_0.clone(),
        rd: expr1_0,
        rn: pattern1_0,
        rm: pattern2_0,
        size: pattern3_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term vec_lanes.
pub fn constructor_vec_lanes<C: Context>(
    ctx: &mut C,
    arg0: &VecLanesOp,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1423.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::VecLanes {
        op: pattern0_0.clone(),
        rd: expr1_0,
        rn: pattern1_0,
        size: pattern2_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term vec_dup.
pub fn constructor_vec_dup<C: Context>(ctx: &mut C, arg0: Reg, arg1: &VectorSize) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1430.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::VecDup {
        rd: expr1_0,
        rn: pattern0_0,
        size: pattern1_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term alu_rr_imm12.
pub fn constructor_alu_rr_imm12<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Reg,
    arg3: Imm12,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1437.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_operand_size(ctx, pattern1_0)?;
    let expr3_0 = MInst::AluRRImm12 {
        alu_op: pattern0_0.clone(),
        size: expr2_0,
        rd: expr1_0,
        rn: pattern2_0,
        imm12: pattern3_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term alu_rrr_shift.
pub fn constructor_alu_rrr_shift<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Reg,
    arg3: Reg,
    arg4: ShiftOpAndAmt,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/aarch64/inst.isle line 1444.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_operand_size(ctx, pattern1_0)?;
    let expr3_0 = MInst::AluRRRShift {
        alu_op: pattern0_0.clone(),
        size: expr2_0,
        rd: expr1_0,
        rn: pattern2_0,
        rm: pattern3_0,
        shiftop: pattern4_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term alu_rrr_extend.
pub fn constructor_alu_rrr_extend<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Reg,
    arg3: Reg,
    arg4: &ExtendOp,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/aarch64/inst.isle line 1451.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_operand_size(ctx, pattern1_0)?;
    let expr3_0 = MInst::AluRRRExtend {
        alu_op: pattern0_0.clone(),
        size: expr2_0,
        rd: expr1_0,
        rn: pattern2_0,
        rm: pattern3_0,
        extendop: pattern4_0.clone(),
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term alu_rr_extend_reg.
pub fn constructor_alu_rr_extend_reg<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Reg,
    arg3: &ExtendedValue,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1459.
    let expr0_0 = C::put_extended_in_reg(ctx, pattern3_0);
    let expr1_0 = C::get_extended_op(ctx, pattern3_0);
    let expr2_0 =
        constructor_alu_rrr_extend(ctx, pattern0_0, pattern1_0, pattern2_0, expr0_0, &expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term alu_rrrr.
pub fn constructor_alu_rrrr<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp3,
    arg1: Reg,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1466.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::AluRRRR {
        alu_op: pattern0_0.clone(),
        rd: expr1_0,
        rn: pattern1_0,
        rm: pattern2_0,
        ra: pattern3_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term bit_rr.
pub fn constructor_bit_rr<C: Context>(
    ctx: &mut C,
    arg0: &BitOp,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1473.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_operand_size(ctx, pattern1_0)?;
    let expr3_0 = MInst::BitRR {
        op: pattern0_0.clone(),
        size: expr2_0,
        rd: expr1_0,
        rn: pattern2_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term add_with_flags_paired.
pub fn constructor_add_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1480.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = ALUOp::AddS;
    let expr3_0 = constructor_operand_size(ctx, pattern0_0)?;
    let expr4_0 = MInst::AluRRR {
        alu_op: expr2_0,
        size: expr3_0,
        rd: expr1_0,
        rn: pattern1_0,
        rm: pattern2_0,
    };
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    let expr6_0 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: expr4_0,
        result: expr5_0,
    };
    return Some(expr6_0);
}

// Generated as internal constructor for term adc_paired.
pub fn constructor_adc_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1488.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = ALUOp::Adc;
    let expr3_0 = constructor_operand_size(ctx, pattern0_0)?;
    let expr4_0 = MInst::AluRRR {
        alu_op: expr2_0,
        size: expr3_0,
        rd: expr1_0,
        rn: pattern1_0,
        rm: pattern2_0,
    };
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    let expr6_0 = ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
        inst: expr4_0,
        result: expr5_0,
    };
    return Some(expr6_0);
}

// Generated as internal constructor for term sub_with_flags_paired.
pub fn constructor_sub_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1496.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = ALUOp::SubS;
    let expr3_0 = constructor_operand_size(ctx, pattern0_0)?;
    let expr4_0 = MInst::AluRRR {
        alu_op: expr2_0,
        size: expr3_0,
        rd: expr1_0,
        rn: pattern1_0,
        rm: pattern2_0,
    };
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    let expr6_0 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: expr4_0,
        result: expr5_0,
    };
    return Some(expr6_0);
}

// Generated as internal constructor for term cmp64_imm.
pub fn constructor_cmp64_imm<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Imm12,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1503.
    let expr0_0 = ALUOp::SubS;
    let expr1_0 = OperandSize::Size64;
    let expr2_0 = C::writable_zero_reg(ctx);
    let expr3_0 = MInst::AluRRImm12 {
        alu_op: expr0_0,
        size: expr1_0,
        rd: expr2_0,
        rn: pattern0_0,
        imm12: pattern1_0,
    };
    let expr4_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr3_0 };
    return Some(expr4_0);
}

// Generated as internal constructor for term sbc_paired.
pub fn constructor_sbc_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1510.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = ALUOp::Sbc;
    let expr3_0 = constructor_operand_size(ctx, pattern0_0)?;
    let expr4_0 = MInst::AluRRR {
        alu_op: expr2_0,
        size: expr3_0,
        rd: expr1_0,
        rn: pattern1_0,
        rm: pattern2_0,
    };
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    let expr6_0 = ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
        inst: expr4_0,
        result: expr5_0,
    };
    return Some(expr6_0);
}

// Generated as internal constructor for term vec_misc.
pub fn constructor_vec_misc<C: Context>(
    ctx: &mut C,
    arg0: &VecMisc2,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1518.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::VecMisc {
        op: pattern0_0.clone(),
        rd: expr1_0,
        rn: pattern1_0,
        size: pattern2_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term vec_rrr_long.
pub fn constructor_vec_rrr_long<C: Context>(
    ctx: &mut C,
    arg0: &VecRRRLongOp,
    arg1: Reg,
    arg2: Reg,
    arg3: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1525.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::VecRRRLong {
        alu_op: pattern0_0.clone(),
        rd: expr1_0,
        rn: pattern1_0,
        rm: pattern2_0,
        high_half: pattern3_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term vec_rrrr_long.
pub fn constructor_vec_rrrr_long<C: Context>(
    ctx: &mut C,
    arg0: &VecRRRLongOp,
    arg1: Reg,
    arg2: Reg,
    arg3: Reg,
    arg4: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/aarch64/inst.isle line 1535.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::FpuMove128 {
        rd: expr1_0,
        rn: pattern1_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = MInst::VecRRRLong {
        alu_op: pattern0_0.clone(),
        rd: expr1_0,
        rn: pattern2_0,
        rm: pattern3_0,
        high_half: pattern4_0,
    };
    let expr5_0 = C::emit(ctx, &expr4_0);
    let expr6_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr6_0);
}

// Generated as internal constructor for term vec_rr_narrow.
pub fn constructor_vec_rr_narrow<C: Context>(
    ctx: &mut C,
    arg0: &VecRRNarrowOp,
    arg1: Reg,
    arg2: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1543.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::VecRRNarrow {
        op: pattern0_0.clone(),
        rd: expr1_0,
        rn: pattern1_0,
        high_half: pattern2_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term vec_rr_long.
pub fn constructor_vec_rr_long<C: Context>(
    ctx: &mut C,
    arg0: &VecRRLongOp,
    arg1: Reg,
    arg2: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1550.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::VecRRLong {
        op: pattern0_0.clone(),
        rd: expr1_0,
        rn: pattern1_0,
        high_half: pattern2_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term mov_to_fpu.
pub fn constructor_mov_to_fpu<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &ScalarSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1557.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::MovToFpu {
        rd: expr1_0,
        rn: pattern0_0,
        size: pattern1_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term mov_to_vec.
pub fn constructor_mov_to_vec<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: u8,
    arg3: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1564.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::FpuMove128 {
        rd: expr1_0,
        rn: pattern0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = MInst::MovToVec {
        rd: expr1_0,
        rn: pattern1_0,
        idx: pattern2_0,
        size: pattern3_0.clone(),
    };
    let expr5_0 = C::emit(ctx, &expr4_0);
    let expr6_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr6_0);
}

// Generated as internal constructor for term mov_from_vec.
pub fn constructor_mov_from_vec<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: u8,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1572.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::MovFromVec {
        rd: expr1_0,
        rn: pattern0_0,
        idx: pattern1_0,
        size: pattern2_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term mov_from_vec_signed.
pub fn constructor_mov_from_vec_signed<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: u8,
    arg2: &VectorSize,
    arg3: &OperandSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1579.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::MovFromVecSigned {
        rd: expr1_0,
        rn: pattern0_0,
        idx: pattern1_0,
        size: pattern2_0.clone(),
        scalar_size: pattern3_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term extend.
pub fn constructor_extend<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: bool,
    arg2: u8,
    arg3: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1586.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::Extend {
        rd: expr1_0,
        rn: pattern0_0,
        signed: pattern1_0,
        from_bits: pattern2_0,
        to_bits: pattern3_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term load_acquire.
pub fn constructor_load_acquire<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1593.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::LoadAcquire {
        access_ty: pattern0_0,
        rt: expr1_0,
        rn: pattern1_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term tst_imm.
pub fn constructor_tst_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: ImmLogic,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1603.
    let expr0_0 = ALUOp::AndS;
    let expr1_0 = constructor_operand_size(ctx, pattern0_0)?;
    let expr2_0 = C::writable_zero_reg(ctx);
    let expr3_0 = MInst::AluRRImmLogic {
        alu_op: expr0_0,
        size: expr1_0,
        rd: expr2_0,
        rn: pattern1_0,
        imml: pattern2_0,
    };
    let expr4_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr3_0 };
    return Some(expr4_0);
}

// Generated as internal constructor for term csel.
pub fn constructor_csel<C: Context>(
    ctx: &mut C,
    arg0: &Cond,
    arg1: Reg,
    arg2: Reg,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1617.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::CSel {
        rd: expr1_0,
        cond: pattern0_0.clone(),
        rn: pattern1_0,
        rm: pattern2_0,
    };
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    let expr4_0 = ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: expr2_0,
        result: expr3_0,
    };
    return Some(expr4_0);
}

// Generated as internal constructor for term add.
pub fn constructor_add<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1626.
    let expr0_0 = ALUOp::Add;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_imm.
pub fn constructor_add_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Imm12,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1629.
    let expr0_0 = ALUOp::Add;
    let expr1_0 = constructor_alu_rr_imm12(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_extend.
pub fn constructor_add_extend<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &ExtendedValue,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1632.
    let expr0_0 = ALUOp::Add;
    let expr1_0 = constructor_alu_rr_extend_reg(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_shift.
pub fn constructor_add_shift<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: ShiftOpAndAmt,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1635.
    let expr0_0 = ALUOp::Add;
    let expr1_0 = constructor_alu_rrr_shift(
        ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0, pattern3_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_vec.
pub fn constructor_add_vec<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1638.
    let expr0_0 = VecALUOp::Add;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub.
pub fn constructor_sub<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1643.
    let expr0_0 = ALUOp::Sub;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_imm.
pub fn constructor_sub_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Imm12,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1646.
    let expr0_0 = ALUOp::Sub;
    let expr1_0 = constructor_alu_rr_imm12(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_extend.
pub fn constructor_sub_extend<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &ExtendedValue,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1649.
    let expr0_0 = ALUOp::Sub;
    let expr1_0 = constructor_alu_rr_extend_reg(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_shift.
pub fn constructor_sub_shift<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: ShiftOpAndAmt,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1652.
    let expr0_0 = ALUOp::Sub;
    let expr1_0 = constructor_alu_rrr_shift(
        ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0, pattern3_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_vec.
pub fn constructor_sub_vec<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1655.
    let expr0_0 = VecALUOp::Sub;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term madd.
pub fn constructor_madd<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/aarch64/inst.isle line 1661.
        let expr0_0 = constructor_madd64(ctx, pattern2_0, pattern3_0, pattern4_0)?;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::fits_in_32(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/aarch64/inst.isle line 1660.
        let expr0_0 = constructor_madd32(ctx, pattern2_0, pattern3_0, pattern4_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term madd32.
pub fn constructor_madd32<C: Context>(ctx: &mut C, arg0: Reg, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1664.
    let expr0_0 = ALUOp3::MAdd32;
    let expr1_0 = constructor_alu_rrrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term madd64.
pub fn constructor_madd64<C: Context>(ctx: &mut C, arg0: Reg, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1667.
    let expr0_0 = ALUOp3::MAdd64;
    let expr1_0 = constructor_alu_rrrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term msub64.
pub fn constructor_msub64<C: Context>(ctx: &mut C, arg0: Reg, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1672.
    let expr0_0 = ALUOp3::MSub64;
    let expr1_0 = constructor_alu_rrrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term uqadd.
pub fn constructor_uqadd<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1676.
    let expr0_0 = VecALUOp::Uqadd;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sqadd.
pub fn constructor_sqadd<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1680.
    let expr0_0 = VecALUOp::Sqadd;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term uqsub.
pub fn constructor_uqsub<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1684.
    let expr0_0 = VecALUOp::Uqsub;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sqsub.
pub fn constructor_sqsub<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1688.
    let expr0_0 = VecALUOp::Sqsub;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term umulh.
pub fn constructor_umulh<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1692.
    let expr0_0 = ALUOp::UMulH;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term smulh.
pub fn constructor_smulh<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1696.
    let expr0_0 = ALUOp::SMulH;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul.
pub fn constructor_mul<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1700.
    let expr0_0 = VecALUOp::Mul;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term neg.
pub fn constructor_neg<C: Context>(ctx: &mut C, arg0: Reg, arg1: &VectorSize) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1704.
    let expr0_0 = VecMisc2::Neg;
    let expr1_0 = constructor_vec_misc(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term rev64.
pub fn constructor_rev64<C: Context>(ctx: &mut C, arg0: Reg, arg1: &VectorSize) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1708.
    let expr0_0 = VecMisc2::Rev64;
    let expr1_0 = constructor_vec_misc(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xtn64.
pub fn constructor_xtn64<C: Context>(ctx: &mut C, arg0: Reg, arg1: bool) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1712.
    let expr0_0 = VecRRNarrowOp::Xtn64;
    let expr1_0 = constructor_vec_rr_narrow(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term addp.
pub fn constructor_addp<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1716.
    let expr0_0 = VecALUOp::Addp;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term addv.
pub fn constructor_addv<C: Context>(ctx: &mut C, arg0: Reg, arg1: &VectorSize) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1720.
    let expr0_0 = VecLanesOp::Addv;
    let expr1_0 = constructor_vec_lanes(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term shll32.
pub fn constructor_shll32<C: Context>(ctx: &mut C, arg0: Reg, arg1: bool) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1724.
    let expr0_0 = VecRRLongOp::Shll32;
    let expr1_0 = constructor_vec_rr_long(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term umlal32.
pub fn constructor_umlal32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: Reg,
    arg3: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1728.
    let expr0_0 = VecRRRLongOp::Umlal32;
    let expr1_0 = constructor_vec_rrrr_long(
        ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0, pattern3_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term smull8.
pub fn constructor_smull8<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1732.
    let expr0_0 = VecRRRLongOp::Smull8;
    let expr1_0 = constructor_vec_rrr_long(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term umull8.
pub fn constructor_umull8<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1736.
    let expr0_0 = VecRRRLongOp::Umull8;
    let expr1_0 = constructor_vec_rrr_long(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term smull16.
pub fn constructor_smull16<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1740.
    let expr0_0 = VecRRRLongOp::Smull16;
    let expr1_0 = constructor_vec_rrr_long(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term umull16.
pub fn constructor_umull16<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1744.
    let expr0_0 = VecRRRLongOp::Umull16;
    let expr1_0 = constructor_vec_rrr_long(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term smull32.
pub fn constructor_smull32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1748.
    let expr0_0 = VecRRRLongOp::Smull32;
    let expr1_0 = constructor_vec_rrr_long(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term umull32.
pub fn constructor_umull32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: bool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1752.
    let expr0_0 = VecRRRLongOp::Umull32;
    let expr1_0 = constructor_vec_rrr_long(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term asr.
pub fn constructor_asr<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1756.
    let expr0_0 = ALUOp::Asr;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term asr_imm.
pub fn constructor_asr_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: ImmShift,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1759.
    let expr0_0 = ALUOp::Asr;
    let expr1_0 = constructor_alu_rr_imm_shift(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term lsr.
pub fn constructor_lsr<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1763.
    let expr0_0 = ALUOp::Lsr;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term lsr_imm.
pub fn constructor_lsr_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: ImmShift,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1766.
    let expr0_0 = ALUOp::Lsr;
    let expr1_0 = constructor_alu_rr_imm_shift(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term lsl.
pub fn constructor_lsl<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1770.
    let expr0_0 = ALUOp::Lsl;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term lsl_imm.
pub fn constructor_lsl_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: ImmShift,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1773.
    let expr0_0 = ALUOp::Lsl;
    let expr1_0 = constructor_alu_rr_imm_shift(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term a64_udiv.
pub fn constructor_a64_udiv<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1777.
    let expr0_0 = ALUOp::UDiv;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term a64_sdiv.
pub fn constructor_a64_sdiv<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1781.
    let expr0_0 = ALUOp::SDiv;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term not.
pub fn constructor_not<C: Context>(ctx: &mut C, arg0: Reg, arg1: &VectorSize) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1785.
    let expr0_0 = VecMisc2::Not;
    let expr1_0 = constructor_vec_misc(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term orr_not.
pub fn constructor_orr_not<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1790.
    let expr0_0 = ALUOp::OrrNot;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term orr_not_shift.
pub fn constructor_orr_not_shift<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: ShiftOpAndAmt,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 1793.
    let expr0_0 = ALUOp::OrrNot;
    let expr1_0 = constructor_alu_rrr_shift(
        ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0, pattern3_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term orr.
pub fn constructor_orr<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1798.
    let expr0_0 = ALUOp::Orr;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term orr_imm.
pub fn constructor_orr_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: ImmLogic,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1801.
    let expr0_0 = ALUOp::Orr;
    let expr1_0 = constructor_alu_rr_imm_logic(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term orr_vec.
pub fn constructor_orr_vec<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1804.
    let expr0_0 = VecALUOp::Orr;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term and_imm.
pub fn constructor_and_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: ImmLogic,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1809.
    let expr0_0 = ALUOp::And;
    let expr1_0 = constructor_alu_rr_imm_logic(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term and_vec.
pub fn constructor_and_vec<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1812.
    let expr0_0 = VecALUOp::And;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term eor_vec.
pub fn constructor_eor_vec<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1816.
    let expr0_0 = VecALUOp::Eor;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term bic_vec.
pub fn constructor_bic_vec<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1820.
    let expr0_0 = VecALUOp::Bic;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sshl.
pub fn constructor_sshl<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1824.
    let expr0_0 = VecALUOp::Sshl;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term ushl.
pub fn constructor_ushl<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1828.
    let expr0_0 = VecALUOp::Ushl;
    let expr1_0 = constructor_vec_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term a64_rotr.
pub fn constructor_a64_rotr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1833.
    let expr0_0 = ALUOp::RotR;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term a64_rotr_imm.
pub fn constructor_a64_rotr_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: ImmShift,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1836.
    let expr0_0 = ALUOp::RotR;
    let expr1_0 = constructor_alu_rr_imm_shift(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term rbit.
pub fn constructor_rbit<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1841.
    let expr0_0 = BitOp::RBit;
    let expr1_0 = constructor_bit_rr(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term a64_clz.
pub fn constructor_a64_clz<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1846.
    let expr0_0 = BitOp::Clz;
    let expr1_0 = constructor_bit_rr(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term a64_cls.
pub fn constructor_a64_cls<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1851.
    let expr0_0 = BitOp::Cls;
    let expr1_0 = constructor_bit_rr(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term eon.
pub fn constructor_eon<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg, arg2: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1856.
    let expr0_0 = ALUOp::EorNot;
    let expr1_0 = constructor_alu_rrr(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term vec_cnt.
pub fn constructor_vec_cnt<C: Context>(ctx: &mut C, arg0: Reg, arg1: &VectorSize) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 1861.
    let expr0_0 = VecMisc2::Cnt;
    let expr1_0 = constructor_vec_misc(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term imm.
pub fn constructor_imm<C: Context>(ctx: &mut C, arg0: Type, arg1: u64) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::integral_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let closure3 = || {
            let expr0_0: Type = I64;
            return Some(expr0_0);
        };
        if let Some(pattern3_0) = closure3() {
            if let Some(pattern4_0) = C::imm_logic_from_u64(ctx, pattern2_0, pattern3_0) {
                // Rule at src/isa/aarch64/inst.isle line 1876.
                let expr0_0: Type = I64;
                let expr1_0 = C::zero_reg(ctx);
                let expr2_0 = constructor_orr_imm(ctx, expr0_0, expr1_0, pattern4_0)?;
                return Some(expr2_0);
            }
        }
        if let Some(pattern3_0) = C::move_wide_const_from_u64(ctx, pattern2_0) {
            // Rule at src/isa/aarch64/inst.isle line 1868.
            let expr0_0 = OperandSize::Size64;
            let expr1_0 = constructor_movz(ctx, pattern3_0, &expr0_0)?;
            return Some(expr1_0);
        }
        if let Some(pattern3_0) = C::move_wide_const_from_negated_u64(ctx, pattern2_0) {
            // Rule at src/isa/aarch64/inst.isle line 1872.
            let expr0_0 = OperandSize::Size64;
            let expr1_0 = constructor_movn(ctx, pattern3_0, &expr0_0)?;
            return Some(expr1_0);
        }
        // Rule at src/isa/aarch64/inst.isle line 1883.
        let expr0_0 = C::load_constant64_full(ctx, pattern2_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_sext32.
pub fn constructor_put_in_reg_sext32<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if pattern1_0 == I32 {
        // Rule at src/isa/aarch64/inst.isle line 1894.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    if pattern1_0 == I64 {
        // Rule at src/isa/aarch64/inst.isle line 1895.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    if let Some(pattern2_0) = C::fits_in_32(ctx, pattern1_0) {
        // Rule at src/isa/aarch64/inst.isle line 1890.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0: bool = true;
        let expr2_0 = C::ty_bits(ctx, pattern2_0);
        let expr3_0: u8 = 32;
        let expr4_0 = constructor_extend(ctx, expr0_0, expr1_0, expr2_0, expr3_0)?;
        return Some(expr4_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_zext32.
pub fn constructor_put_in_reg_zext32<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if pattern1_0 == I32 {
        // Rule at src/isa/aarch64/inst.isle line 1903.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    if pattern1_0 == I64 {
        // Rule at src/isa/aarch64/inst.isle line 1904.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    if let Some(pattern2_0) = C::fits_in_32(ctx, pattern1_0) {
        // Rule at src/isa/aarch64/inst.isle line 1899.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0: bool = false;
        let expr2_0 = C::ty_bits(ctx, pattern2_0);
        let expr3_0: u8 = 32;
        let expr4_0 = constructor_extend(ctx, expr0_0, expr1_0, expr2_0, expr3_0)?;
        return Some(expr4_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_sext64.
pub fn constructor_put_in_reg_sext64<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if pattern1_0 == I64 {
        // Rule at src/isa/aarch64/inst.isle line 1912.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    if let Some(pattern2_0) = C::fits_in_32(ctx, pattern1_0) {
        // Rule at src/isa/aarch64/inst.isle line 1908.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0: bool = true;
        let expr2_0 = C::ty_bits(ctx, pattern2_0);
        let expr3_0: u8 = 64;
        let expr4_0 = constructor_extend(ctx, expr0_0, expr1_0, expr2_0, expr3_0)?;
        return Some(expr4_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_zext64.
pub fn constructor_put_in_reg_zext64<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if pattern1_0 == I64 {
        // Rule at src/isa/aarch64/inst.isle line 1920.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    if let Some(pattern2_0) = C::fits_in_32(ctx, pattern1_0) {
        // Rule at src/isa/aarch64/inst.isle line 1916.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0: bool = false;
        let expr2_0 = C::ty_bits(ctx, pattern2_0);
        let expr3_0: u8 = 64;
        let expr4_0 = constructor_extend(ctx, expr0_0, expr1_0, expr2_0, expr3_0)?;
        return Some(expr4_0);
    }
    return None;
}

// Generated as internal constructor for term trap_if_zero_divisor.
pub fn constructor_trap_if_zero_divisor<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/aarch64/inst.isle line 1925.
    let expr0_0 = C::cond_br_zero(ctx, pattern0_0);
    let expr1_0 = C::trap_code_division_by_zero(ctx);
    let expr2_0 = MInst::TrapIf {
        kind: expr0_0,
        trap_code: expr1_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    return Some(pattern0_0);
}

// Generated as internal constructor for term size_from_ty.
pub fn constructor_size_from_ty<C: Context>(ctx: &mut C, arg0: Type) -> Option<OperandSize> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/aarch64/inst.isle line 1931.
        let expr0_0 = OperandSize::Size64;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::fits_in_32(ctx, pattern0_0) {
        // Rule at src/isa/aarch64/inst.isle line 1930.
        let expr0_0 = OperandSize::Size32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term trap_if_div_overflow.
pub fn constructor_trap_if_div_overflow<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 1937.
    let expr0_0 = ALUOp::AddS;
    let expr1_0 = constructor_operand_size(ctx, pattern0_0)?;
    let expr2_0 = C::writable_zero_reg(ctx);
    let expr3_0: u8 = 1;
    let expr4_0 = C::u8_into_imm12(ctx, expr3_0);
    let expr5_0 = MInst::AluRRImm12 {
        alu_op: expr0_0,
        size: expr1_0,
        rd: expr2_0,
        rn: pattern2_0,
        imm12: expr4_0,
    };
    let expr6_0 = C::emit(ctx, &expr5_0);
    let expr7_0 = constructor_size_from_ty(ctx, pattern0_0)?;
    let expr8_0: u8 = 1;
    let expr9_0 = C::u8_into_uimm5(ctx, expr8_0);
    let expr10_0: bool = false;
    let expr11_0: bool = false;
    let expr12_0: bool = false;
    let expr13_0: bool = false;
    let expr14_0 = C::nzcv(ctx, expr10_0, expr11_0, expr12_0, expr13_0);
    let expr15_0 = Cond::Eq;
    let expr16_0 = MInst::CCmpImm {
        size: expr7_0,
        rn: pattern1_0,
        imm: expr9_0,
        nzcv: expr14_0,
        cond: expr15_0,
    };
    let expr17_0 = C::emit(ctx, &expr16_0);
    let expr18_0 = Cond::Vs;
    let expr19_0 = C::cond_br_cond(ctx, &expr18_0);
    let expr20_0 = C::trap_code_integer_overflow(ctx);
    let expr21_0 = MInst::TrapIf {
        kind: expr19_0,
        trap_code: expr20_0,
    };
    let expr22_0 = C::emit(ctx, &expr21_0);
    return Some(pattern1_0);
}

// Generated as internal constructor for term alu_rs_imm_logic_commutative.
pub fn constructor_alu_rs_imm_logic_commutative<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Value,
    arg3: Value,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    if let Some(pattern3_0) = C::def_inst(ctx, pattern2_0) {
        let pattern4_0 = C::inst_data(ctx, pattern3_0);
        match &pattern4_0 {
            &InstructionData::UnaryImm {
                opcode: ref pattern5_0,
                imm: pattern5_1,
            } => {
                if let &Opcode::Iconst = pattern5_0 {
                    let closure7 = || {
                        return Some(pattern1_0);
                    };
                    if let Some(pattern7_0) = closure7() {
                        if let Some(pattern8_0) =
                            C::imm_logic_from_imm64(ctx, pattern5_1, pattern7_0)
                        {
                            let pattern9_0 = arg3;
                            // Rule at src/isa/aarch64/inst.isle line 1982.
                            let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                            let expr1_0 = constructor_alu_rr_imm_logic(
                                ctx, pattern0_0, pattern1_0, expr0_0, pattern8_0,
                            )?;
                            return Some(expr1_0);
                        }
                    }
                }
            }
            &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } => {
                if let &Opcode::Ishl = pattern5_0 {
                    let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                    if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                        let pattern9_0 = C::inst_data(ctx, pattern8_0);
                        if let &InstructionData::UnaryImm {
                            opcode: ref pattern10_0,
                            imm: pattern10_1,
                        } = &pattern9_0
                        {
                            if let &Opcode::Iconst = pattern10_0 {
                                let closure12 = || {
                                    return Some(pattern1_0);
                                };
                                if let Some(pattern12_0) = closure12() {
                                    if let Some(pattern13_0) =
                                        C::lshl_from_imm64(ctx, pattern10_1, pattern12_0)
                                    {
                                        let pattern14_0 = arg3;
                                        // Rule at src/isa/aarch64/inst.isle line 1988.
                                        let expr0_0 = C::put_in_reg(ctx, pattern14_0);
                                        let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                        let expr2_0 = constructor_alu_rrr_shift(
                                            ctx,
                                            pattern0_0,
                                            pattern1_0,
                                            expr0_0,
                                            expr1_0,
                                            pattern13_0,
                                        )?;
                                        return Some(expr2_0);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            _ => {}
        }
    }
    let pattern3_0 = arg3;
    if let Some(pattern4_0) = C::def_inst(ctx, pattern3_0) {
        let pattern5_0 = C::inst_data(ctx, pattern4_0);
        match &pattern5_0 {
            &InstructionData::UnaryImm {
                opcode: ref pattern6_0,
                imm: pattern6_1,
            } => {
                if let &Opcode::Iconst = pattern6_0 {
                    let closure8 = || {
                        return Some(pattern1_0);
                    };
                    if let Some(pattern8_0) = closure8() {
                        if let Some(pattern9_0) =
                            C::imm_logic_from_imm64(ctx, pattern6_1, pattern8_0)
                        {
                            // Rule at src/isa/aarch64/inst.isle line 1980.
                            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                            let expr1_0 = constructor_alu_rr_imm_logic(
                                ctx, pattern0_0, pattern1_0, expr0_0, pattern9_0,
                            )?;
                            return Some(expr1_0);
                        }
                    }
                }
            }
            &InstructionData::Binary {
                opcode: ref pattern6_0,
                args: ref pattern6_1,
            } => {
                if let &Opcode::Ishl = pattern6_0 {
                    let (pattern8_0, pattern8_1) = C::unpack_value_array_2(ctx, pattern6_1);
                    if let Some(pattern9_0) = C::def_inst(ctx, pattern8_1) {
                        let pattern10_0 = C::inst_data(ctx, pattern9_0);
                        if let &InstructionData::UnaryImm {
                            opcode: ref pattern11_0,
                            imm: pattern11_1,
                        } = &pattern10_0
                        {
                            if let &Opcode::Iconst = pattern11_0 {
                                let closure13 = || {
                                    return Some(pattern1_0);
                                };
                                if let Some(pattern13_0) = closure13() {
                                    if let Some(pattern14_0) =
                                        C::lshl_from_imm64(ctx, pattern11_1, pattern13_0)
                                    {
                                        // Rule at src/isa/aarch64/inst.isle line 1986.
                                        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                        let expr1_0 = C::put_in_reg(ctx, pattern8_0);
                                        let expr2_0 = constructor_alu_rrr_shift(
                                            ctx,
                                            pattern0_0,
                                            pattern1_0,
                                            expr0_0,
                                            expr1_0,
                                            pattern14_0,
                                        )?;
                                        return Some(expr2_0);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            _ => {}
        }
    }
    // Rule at src/isa/aarch64/inst.isle line 1976.
    let expr0_0 = C::put_in_reg(ctx, pattern2_0);
    let expr1_0 = C::put_in_reg(ctx, pattern3_0);
    let expr2_0 = constructor_alu_rrr(ctx, pattern0_0, pattern1_0, expr0_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term alu_rs_imm_logic.
pub fn constructor_alu_rs_imm_logic<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Value,
    arg3: Value,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    if let Some(pattern4_0) = C::def_inst(ctx, pattern3_0) {
        let pattern5_0 = C::inst_data(ctx, pattern4_0);
        match &pattern5_0 {
            &InstructionData::UnaryImm {
                opcode: ref pattern6_0,
                imm: pattern6_1,
            } => {
                if let &Opcode::Iconst = pattern6_0 {
                    let closure8 = || {
                        return Some(pattern1_0);
                    };
                    if let Some(pattern8_0) = closure8() {
                        if let Some(pattern9_0) =
                            C::imm_logic_from_imm64(ctx, pattern6_1, pattern8_0)
                        {
                            // Rule at src/isa/aarch64/inst.isle line 1996.
                            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                            let expr1_0 = constructor_alu_rr_imm_logic(
                                ctx, pattern0_0, pattern1_0, expr0_0, pattern9_0,
                            )?;
                            return Some(expr1_0);
                        }
                    }
                }
            }
            &InstructionData::Binary {
                opcode: ref pattern6_0,
                args: ref pattern6_1,
            } => {
                if let &Opcode::Ishl = pattern6_0 {
                    let (pattern8_0, pattern8_1) = C::unpack_value_array_2(ctx, pattern6_1);
                    if let Some(pattern9_0) = C::def_inst(ctx, pattern8_1) {
                        let pattern10_0 = C::inst_data(ctx, pattern9_0);
                        if let &InstructionData::UnaryImm {
                            opcode: ref pattern11_0,
                            imm: pattern11_1,
                        } = &pattern10_0
                        {
                            if let &Opcode::Iconst = pattern11_0 {
                                let closure13 = || {
                                    return Some(pattern1_0);
                                };
                                if let Some(pattern13_0) = closure13() {
                                    if let Some(pattern14_0) =
                                        C::lshl_from_imm64(ctx, pattern11_1, pattern13_0)
                                    {
                                        // Rule at src/isa/aarch64/inst.isle line 1998.
                                        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                        let expr1_0 = C::put_in_reg(ctx, pattern8_0);
                                        let expr2_0 = constructor_alu_rrr_shift(
                                            ctx,
                                            pattern0_0,
                                            pattern1_0,
                                            expr0_0,
                                            expr1_0,
                                            pattern14_0,
                                        )?;
                                        return Some(expr2_0);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            _ => {}
        }
    }
    // Rule at src/isa/aarch64/inst.isle line 1994.
    let expr0_0 = C::put_in_reg(ctx, pattern2_0);
    let expr1_0 = C::put_in_reg(ctx, pattern3_0);
    let expr2_0 = constructor_alu_rrr(ctx, pattern0_0, pattern1_0, expr0_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term i128_alu_bitop.
pub fn constructor_i128_alu_bitop<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Value,
    arg3: Value,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/aarch64/inst.isle line 2006.
    let expr0_0 = C::put_in_regs(ctx, pattern2_0);
    let expr1_0: usize = 0;
    let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
    let expr3_0: usize = 1;
    let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
    let expr5_0 = C::put_in_regs(ctx, pattern3_0);
    let expr6_0: usize = 0;
    let expr7_0 = C::value_regs_get(ctx, expr5_0, expr6_0);
    let expr8_0: usize = 1;
    let expr9_0 = C::value_regs_get(ctx, expr5_0, expr8_0);
    let expr10_0 = constructor_alu_rrr(ctx, pattern0_0, pattern1_0, expr2_0, expr7_0)?;
    let expr11_0 = constructor_alu_rrr(ctx, pattern0_0, pattern1_0, expr4_0, expr9_0)?;
    let expr12_0 = C::value_regs(ctx, expr10_0, expr11_0);
    return Some(expr12_0);
}

// Generated as internal constructor for term float_cmp_zero.
pub fn constructor_float_cmp_zero<C: Context>(
    ctx: &mut C,
    arg0: &FloatCC,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 2046.
    let expr0_0 = C::float_cc_cmp_zero_to_vec_misc_op(ctx, pattern0_0);
    let expr1_0 = constructor_vec_misc(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term float_cmp_zero_swap.
pub fn constructor_float_cmp_zero_swap<C: Context>(
    ctx: &mut C,
    arg0: &FloatCC,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 2051.
    let expr0_0 = C::float_cc_cmp_zero_to_vec_misc_op_swap(ctx, pattern0_0);
    let expr1_0 = constructor_vec_misc(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fcmeq0.
pub fn constructor_fcmeq0<C: Context>(ctx: &mut C, arg0: Reg, arg1: &VectorSize) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 2056.
    let expr0_0 = VecMisc2::Fcmeq0;
    let expr1_0 = constructor_vec_misc(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term int_cmp_zero.
pub fn constructor_int_cmp_zero<C: Context>(
    ctx: &mut C,
    arg0: &IntCC,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 2082.
    let expr0_0 = C::int_cc_cmp_zero_to_vec_misc_op(ctx, pattern0_0);
    let expr1_0 = constructor_vec_misc(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term int_cmp_zero_swap.
pub fn constructor_int_cmp_zero_swap<C: Context>(
    ctx: &mut C,
    arg0: &IntCC,
    arg1: Reg,
    arg2: &VectorSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/inst.isle line 2087.
    let expr0_0 = C::int_cc_cmp_zero_to_vec_misc_op_swap(ctx, pattern0_0);
    let expr1_0 = constructor_vec_misc(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmeq0.
pub fn constructor_cmeq0<C: Context>(ctx: &mut C, arg0: Reg, arg1: &VectorSize) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/inst.isle line 2092.
    let expr0_0 = VecMisc2::Cmeq0;
    let expr1_0 = constructor_vec_misc(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term lower.
pub fn constructor_lower<C: Context>(ctx: &mut C, arg0: Inst) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::first_result(ctx, pattern0_0) {
        let pattern2_0 = C::value_type(ctx, pattern1_0);
        if pattern2_0 == I8 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                match pattern5_0 {
                    &Opcode::Bitrev => {
                        // Rule at src/isa/aarch64/lower.isle line 974.
                        let expr0_0: Type = I32;
                        let expr1_0: Type = I32;
                        let expr2_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr3_0 = constructor_rbit(ctx, expr1_0, expr2_0)?;
                        let expr4_0: u8 = 24;
                        let expr5_0 = C::imm_shift_from_u8(ctx, expr4_0);
                        let expr6_0 = constructor_lsr_imm(ctx, expr0_0, expr3_0, expr5_0)?;
                        let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                        return Some(expr7_0);
                    }
                    &Opcode::Clz => {
                        // Rule at src/isa/aarch64/lower.isle line 995.
                        let expr0_0: Type = I32;
                        let expr1_0: Type = I32;
                        let expr2_0 = constructor_put_in_reg_zext32(ctx, pattern5_1)?;
                        let expr3_0 = constructor_a64_clz(ctx, expr1_0, expr2_0)?;
                        let expr4_0: u8 = 24;
                        let expr5_0 = C::u8_into_imm12(ctx, expr4_0);
                        let expr6_0 = constructor_sub_imm(ctx, expr0_0, expr3_0, expr5_0)?;
                        let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                        return Some(expr7_0);
                    }
                    &Opcode::Cls => {
                        // Rule at src/isa/aarch64/lower.isle line 1042.
                        let expr0_0: Type = I32;
                        let expr1_0: Type = I32;
                        let expr2_0 = constructor_put_in_reg_zext32(ctx, pattern5_1)?;
                        let expr3_0 = constructor_a64_cls(ctx, expr1_0, expr2_0)?;
                        let expr4_0: u8 = 24;
                        let expr5_0 = C::u8_into_imm12(ctx, expr4_0);
                        let expr6_0 = constructor_sub_imm(ctx, expr0_0, expr3_0, expr5_0)?;
                        let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                        return Some(expr7_0);
                    }
                    &Opcode::Ctz => {
                        // Rule at src/isa/aarch64/lower.isle line 1025.
                        let expr0_0: Type = I32;
                        let expr1_0: Type = I32;
                        let expr2_0: Type = I32;
                        let expr3_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr4_0 = constructor_rbit(ctx, expr2_0, expr3_0)?;
                        let expr5_0: Type = I32;
                        let expr6_0: u64 = 8388608;
                        let expr7_0 = C::u64_into_imm_logic(ctx, expr5_0, expr6_0);
                        let expr8_0 = constructor_orr_imm(ctx, expr1_0, expr4_0, expr7_0)?;
                        let expr9_0 = constructor_a64_clz(ctx, expr0_0, expr8_0)?;
                        let expr10_0 = constructor_output_reg(ctx, expr9_0)?;
                        return Some(expr10_0);
                    }
                    &Opcode::Popcnt => {
                        // Rule at src/isa/aarch64/lower.isle line 1093.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0 = ScalarSize::Size32;
                        let expr2_0 = constructor_mov_to_fpu(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = VectorSize::Size8x8;
                        let expr4_0 = constructor_vec_cnt(ctx, expr2_0, &expr3_0)?;
                        let expr5_0: u8 = 0;
                        let expr6_0 = VectorSize::Size8x16;
                        let expr7_0 = constructor_mov_from_vec(ctx, expr4_0, expr5_0, &expr6_0)?;
                        let expr8_0 = constructor_output_reg(ctx, expr7_0)?;
                        return Some(expr8_0);
                    }
                    _ => {}
                }
            }
        }
        if pattern2_0 == I16 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                match pattern5_0 {
                    &Opcode::Bitrev => {
                        // Rule at src/isa/aarch64/lower.isle line 980.
                        let expr0_0: Type = I32;
                        let expr1_0: Type = I32;
                        let expr2_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr3_0 = constructor_rbit(ctx, expr1_0, expr2_0)?;
                        let expr4_0: u8 = 16;
                        let expr5_0 = C::imm_shift_from_u8(ctx, expr4_0);
                        let expr6_0 = constructor_lsr_imm(ctx, expr0_0, expr3_0, expr5_0)?;
                        let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                        return Some(expr7_0);
                    }
                    &Opcode::Clz => {
                        // Rule at src/isa/aarch64/lower.isle line 998.
                        let expr0_0: Type = I32;
                        let expr1_0: Type = I32;
                        let expr2_0 = constructor_put_in_reg_zext32(ctx, pattern5_1)?;
                        let expr3_0 = constructor_a64_clz(ctx, expr1_0, expr2_0)?;
                        let expr4_0: u8 = 16;
                        let expr5_0 = C::u8_into_imm12(ctx, expr4_0);
                        let expr6_0 = constructor_sub_imm(ctx, expr0_0, expr3_0, expr5_0)?;
                        let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                        return Some(expr7_0);
                    }
                    &Opcode::Cls => {
                        // Rule at src/isa/aarch64/lower.isle line 1045.
                        let expr0_0: Type = I32;
                        let expr1_0: Type = I32;
                        let expr2_0 = constructor_put_in_reg_zext32(ctx, pattern5_1)?;
                        let expr3_0 = constructor_a64_cls(ctx, expr1_0, expr2_0)?;
                        let expr4_0: u8 = 16;
                        let expr5_0 = C::u8_into_imm12(ctx, expr4_0);
                        let expr6_0 = constructor_sub_imm(ctx, expr0_0, expr3_0, expr5_0)?;
                        let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                        return Some(expr7_0);
                    }
                    &Opcode::Ctz => {
                        // Rule at src/isa/aarch64/lower.isle line 1028.
                        let expr0_0: Type = I32;
                        let expr1_0: Type = I32;
                        let expr2_0: Type = I32;
                        let expr3_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr4_0 = constructor_rbit(ctx, expr2_0, expr3_0)?;
                        let expr5_0: Type = I32;
                        let expr6_0: u64 = 32768;
                        let expr7_0 = C::u64_into_imm_logic(ctx, expr5_0, expr6_0);
                        let expr8_0 = constructor_orr_imm(ctx, expr1_0, expr4_0, expr7_0)?;
                        let expr9_0 = constructor_a64_clz(ctx, expr0_0, expr8_0)?;
                        let expr10_0 = constructor_output_reg(ctx, expr9_0)?;
                        return Some(expr10_0);
                    }
                    &Opcode::Popcnt => {
                        // Rule at src/isa/aarch64/lower.isle line 1099.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0 = ScalarSize::Size32;
                        let expr2_0 = constructor_mov_to_fpu(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = VectorSize::Size8x8;
                        let expr4_0 = constructor_vec_cnt(ctx, expr2_0, &expr3_0)?;
                        let expr5_0 = VectorSize::Size8x8;
                        let expr6_0 = constructor_addp(ctx, expr4_0, expr4_0, &expr5_0)?;
                        let expr7_0: u8 = 0;
                        let expr8_0 = VectorSize::Size8x16;
                        let expr9_0 = constructor_mov_from_vec(ctx, expr6_0, expr7_0, &expr8_0)?;
                        let expr10_0 = constructor_output_reg(ctx, expr9_0)?;
                        return Some(expr10_0);
                    }
                    _ => {}
                }
            }
        }
        if pattern2_0 == I32 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Rotl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::UnaryImm {
                                    opcode: ref pattern10_0,
                                    imm: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Iconst = pattern10_0 {
                                        let closure12 = || {
                                            let expr0_0: Type = I32;
                                            return Some(expr0_0);
                                        };
                                        if let Some(pattern12_0) = closure12() {
                                            if let Some(pattern13_0) = C::imm_shift_from_imm64(
                                                ctx,
                                                pattern10_1,
                                                pattern12_0,
                                            ) {
                                                // Rule at src/isa/aarch64/lower.isle line 865.
                                                let expr0_0: Type = I32;
                                                let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr2_0: Type = I32;
                                                let expr3_0 =
                                                    C::negate_imm_shift(ctx, expr2_0, pattern13_0);
                                                let expr4_0 = constructor_a64_rotr_imm(
                                                    ctx, expr0_0, expr1_0, expr3_0,
                                                )?;
                                                let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                                                return Some(expr5_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/aarch64/lower.isle line 855.
                            let expr0_0: Type = I32;
                            let expr1_0 = C::zero_reg(ctx);
                            let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr3_0 = constructor_sub(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0: Type = I32;
                            let expr5_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr6_0 = constructor_a64_rotr(ctx, expr4_0, expr5_0, expr3_0)?;
                            let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                            return Some(expr7_0);
                        }
                        &Opcode::Rotr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::UnaryImm {
                                    opcode: ref pattern10_0,
                                    imm: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Iconst = pattern10_0 {
                                        let closure12 = || {
                                            let expr0_0: Type = I32;
                                            return Some(expr0_0);
                                        };
                                        if let Some(pattern12_0) = closure12() {
                                            if let Some(pattern13_0) = C::imm_shift_from_imm64(
                                                ctx,
                                                pattern10_1,
                                                pattern12_0,
                                            ) {
                                                // Rule at src/isa/aarch64/lower.isle line 907.
                                                let expr0_0: Type = I32;
                                                let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr2_0 = constructor_a64_rotr_imm(
                                                    ctx,
                                                    expr0_0,
                                                    expr1_0,
                                                    pattern13_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/aarch64/lower.isle line 895.
                            let expr0_0: Type = I32;
                            let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr3_0 = constructor_a64_rotr(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Popcnt = pattern5_0 {
                        // Rule at src/isa/aarch64/lower.isle line 1105.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0 = ScalarSize::Size32;
                        let expr2_0 = constructor_mov_to_fpu(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = VectorSize::Size8x8;
                        let expr4_0 = constructor_vec_cnt(ctx, expr2_0, &expr3_0)?;
                        let expr5_0 = VectorSize::Size8x8;
                        let expr6_0 = constructor_addv(ctx, expr4_0, &expr5_0)?;
                        let expr7_0: u8 = 0;
                        let expr8_0 = VectorSize::Size8x16;
                        let expr9_0 = constructor_mov_from_vec(ctx, expr6_0, expr7_0, &expr8_0)?;
                        let expr10_0 = constructor_output_reg(ctx, expr9_0)?;
                        return Some(expr10_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I64 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Umulhi => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 367.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr3_0 = constructor_umulh(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Smulhi => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 355.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr3_0 = constructor_smulh(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 586.
                            let expr0_0 = ALUOp::And;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_alu_rs_imm_logic_commutative(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 599.
                            let expr0_0 = ALUOp::Orr;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_alu_rs_imm_logic_commutative(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 612.
                            let expr0_0 = ALUOp::Eor;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_alu_rs_imm_logic_commutative(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::BandNot => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 625.
                            let expr0_0 = ALUOp::AndNot;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_alu_rs_imm_logic(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::BorNot => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 638.
                            let expr0_0 = ALUOp::OrrNot;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_alu_rs_imm_logic(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::BxorNot => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 648.
                            let expr0_0 = ALUOp::EorNot;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_alu_rs_imm_logic(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Rotl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::UnaryImm {
                                    opcode: ref pattern10_0,
                                    imm: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Iconst = pattern10_0 {
                                        let closure12 = || {
                                            let expr0_0: Type = I64;
                                            return Some(expr0_0);
                                        };
                                        if let Some(pattern12_0) = closure12() {
                                            if let Some(pattern13_0) = C::imm_shift_from_imm64(
                                                ctx,
                                                pattern10_1,
                                                pattern12_0,
                                            ) {
                                                // Rule at src/isa/aarch64/lower.isle line 869.
                                                let expr0_0: Type = I64;
                                                let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr2_0: Type = I64;
                                                let expr3_0 =
                                                    C::negate_imm_shift(ctx, expr2_0, pattern13_0);
                                                let expr4_0 = constructor_a64_rotr_imm(
                                                    ctx, expr0_0, expr1_0, expr3_0,
                                                )?;
                                                let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                                                return Some(expr5_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/aarch64/lower.isle line 860.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::zero_reg(ctx);
                            let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr3_0 = constructor_sub(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0: Type = I64;
                            let expr5_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr6_0 = constructor_a64_rotr(ctx, expr4_0, expr5_0, expr3_0)?;
                            let expr7_0 = constructor_output_reg(ctx, expr6_0)?;
                            return Some(expr7_0);
                        }
                        &Opcode::Rotr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::UnaryImm {
                                    opcode: ref pattern10_0,
                                    imm: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Iconst = pattern10_0 {
                                        let closure12 = || {
                                            let expr0_0: Type = I64;
                                            return Some(expr0_0);
                                        };
                                        if let Some(pattern12_0) = closure12() {
                                            if let Some(pattern13_0) = C::imm_shift_from_imm64(
                                                ctx,
                                                pattern10_1,
                                                pattern12_0,
                                            ) {
                                                // Rule at src/isa/aarch64/lower.isle line 911.
                                                let expr0_0: Type = I64;
                                                let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr2_0 = constructor_a64_rotr_imm(
                                                    ctx,
                                                    expr0_0,
                                                    expr1_0,
                                                    pattern13_0,
                                                )?;
                                                let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/aarch64/lower.isle line 899.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr3_0 = constructor_a64_rotr(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 660.
                            let expr0_0 = ALUOp::Lsl;
                            let expr1_0: Type = I64;
                            let expr2_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr3_0 =
                                constructor_do_shift(ctx, &expr0_0, expr1_0, expr2_0, pattern7_1)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 744.
                            let expr0_0 = ALUOp::Lsr;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_put_in_reg_zext64(ctx, pattern7_0)?;
                            let expr3_0 =
                                constructor_do_shift(ctx, &expr0_0, expr1_0, expr2_0, pattern7_1)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 791.
                            let expr0_0 = ALUOp::Asr;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_put_in_reg_sext64(ctx, pattern7_0)?;
                            let expr3_0 =
                                constructor_do_shift(ctx, &expr0_0, expr1_0, expr2_0, pattern7_1)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Popcnt = pattern5_0 {
                        // Rule at src/isa/aarch64/lower.isle line 1111.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0 = ScalarSize::Size64;
                        let expr2_0 = constructor_mov_to_fpu(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = VectorSize::Size8x8;
                        let expr4_0 = constructor_vec_cnt(ctx, expr2_0, &expr3_0)?;
                        let expr5_0 = VectorSize::Size8x8;
                        let expr6_0 = constructor_addv(ctx, expr4_0, &expr5_0)?;
                        let expr7_0: u8 = 0;
                        let expr8_0 = VectorSize::Size8x16;
                        let expr9_0 = constructor_mov_from_vec(ctx, expr6_0, expr7_0, &expr8_0)?;
                        let expr10_0 = constructor_output_reg(ctx, expr9_0)?;
                        return Some(expr10_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I128 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Iadd => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 79.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = C::value_regs_get(ctx, expr5_0, expr6_0);
                            let expr8_0: usize = 1;
                            let expr9_0 = C::value_regs_get(ctx, expr5_0, expr8_0);
                            let expr10_0: Type = I64;
                            let expr11_0 =
                                constructor_add_with_flags_paired(ctx, expr10_0, expr2_0, expr7_0)?;
                            let expr12_0: Type = I64;
                            let expr13_0 = constructor_adc_paired(ctx, expr12_0, expr4_0, expr9_0)?;
                            let expr14_0 = constructor_with_flags(ctx, &expr11_0, &expr13_0)?;
                            let expr15_0 = C::output(ctx, expr14_0);
                            return Some(expr15_0);
                        }
                        &Opcode::Isub => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 129.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = C::value_regs_get(ctx, expr5_0, expr6_0);
                            let expr8_0: usize = 1;
                            let expr9_0 = C::value_regs_get(ctx, expr5_0, expr8_0);
                            let expr10_0: Type = I64;
                            let expr11_0 =
                                constructor_sub_with_flags_paired(ctx, expr10_0, expr2_0, expr7_0)?;
                            let expr12_0: Type = I64;
                            let expr13_0 = constructor_sbc_paired(ctx, expr12_0, expr4_0, expr9_0)?;
                            let expr14_0 = constructor_with_flags(ctx, &expr11_0, &expr13_0)?;
                            let expr15_0 = C::output(ctx, expr14_0);
                            return Some(expr15_0);
                        }
                        &Opcode::Imul => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 183.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = C::value_regs_get(ctx, expr5_0, expr6_0);
                            let expr8_0: usize = 1;
                            let expr9_0 = C::value_regs_get(ctx, expr5_0, expr8_0);
                            let expr10_0: Type = I64;
                            let expr11_0 = constructor_umulh(ctx, expr10_0, expr2_0, expr7_0)?;
                            let expr12_0 = constructor_madd64(ctx, expr2_0, expr9_0, expr11_0)?;
                            let expr13_0 = constructor_madd64(ctx, expr4_0, expr7_0, expr12_0)?;
                            let expr14_0 = C::zero_reg(ctx);
                            let expr15_0 = constructor_madd64(ctx, expr2_0, expr7_0, expr14_0)?;
                            let expr16_0 = C::value_regs(ctx, expr15_0, expr13_0);
                            let expr17_0 = C::output(ctx, expr16_0);
                            return Some(expr17_0);
                        }
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 589.
                            let expr0_0 = ALUOp::And;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_i128_alu_bitop(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = C::output(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 602.
                            let expr0_0 = ALUOp::Orr;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_i128_alu_bitop(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = C::output(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 615.
                            let expr0_0 = ALUOp::Eor;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_i128_alu_bitop(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = C::output(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::BandNot => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 628.
                            let expr0_0 = ALUOp::AndNot;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_i128_alu_bitop(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = C::output(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::BorNot => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 641.
                            let expr0_0 = ALUOp::OrrNot;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_i128_alu_bitop(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = C::output(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::BxorNot => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 651.
                            let expr0_0 = ALUOp::EorNot;
                            let expr1_0: Type = I64;
                            let expr2_0 = constructor_i128_alu_bitop(
                                ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                            )?;
                            let expr3_0 = C::output(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Rotl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 878.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr2_0: usize = 0;
                            let expr3_0 = C::value_regs_get(ctx, expr1_0, expr2_0);
                            let expr4_0: Type = I64;
                            let expr5_0: Type = I64;
                            let expr6_0: u64 = 128;
                            let expr7_0 = constructor_imm(ctx, expr5_0, expr6_0)?;
                            let expr8_0 = constructor_sub(ctx, expr4_0, expr7_0, expr3_0)?;
                            let expr9_0 = constructor_lower_shl128(ctx, expr0_0, expr3_0)?;
                            let expr10_0 = constructor_lower_ushr128(ctx, expr0_0, expr8_0)?;
                            let expr11_0: Type = I64;
                            let expr12_0: usize = 0;
                            let expr13_0 = C::value_regs_get(ctx, expr9_0, expr12_0);
                            let expr14_0: usize = 0;
                            let expr15_0 = C::value_regs_get(ctx, expr10_0, expr14_0);
                            let expr16_0 = constructor_orr(ctx, expr11_0, expr13_0, expr15_0)?;
                            let expr17_0: Type = I64;
                            let expr18_0: usize = 1;
                            let expr19_0 = C::value_regs_get(ctx, expr9_0, expr18_0);
                            let expr20_0: usize = 1;
                            let expr21_0 = C::value_regs_get(ctx, expr10_0, expr20_0);
                            let expr22_0 = constructor_orr(ctx, expr17_0, expr19_0, expr21_0)?;
                            let expr23_0 = C::value_regs(ctx, expr16_0, expr22_0);
                            let expr24_0 = C::output(ctx, expr23_0);
                            return Some(expr24_0);
                        }
                        &Opcode::Rotr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 959.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr2_0: usize = 0;
                            let expr3_0 = C::value_regs_get(ctx, expr1_0, expr2_0);
                            let expr4_0: Type = I64;
                            let expr5_0: Type = I64;
                            let expr6_0: u64 = 128;
                            let expr7_0 = constructor_imm(ctx, expr5_0, expr6_0)?;
                            let expr8_0 = constructor_sub(ctx, expr4_0, expr7_0, expr3_0)?;
                            let expr9_0 = constructor_lower_ushr128(ctx, expr0_0, expr3_0)?;
                            let expr10_0 = constructor_lower_shl128(ctx, expr0_0, expr8_0)?;
                            let expr11_0: Type = I64;
                            let expr12_0: usize = 1;
                            let expr13_0 = C::value_regs_get(ctx, expr9_0, expr12_0);
                            let expr14_0: usize = 1;
                            let expr15_0 = C::value_regs_get(ctx, expr10_0, expr14_0);
                            let expr16_0 = constructor_orr(ctx, expr11_0, expr13_0, expr15_0)?;
                            let expr17_0: Type = I64;
                            let expr18_0: usize = 0;
                            let expr19_0 = C::value_regs_get(ctx, expr9_0, expr18_0);
                            let expr20_0: usize = 0;
                            let expr21_0 = C::value_regs_get(ctx, expr10_0, expr20_0);
                            let expr22_0 = constructor_orr(ctx, expr17_0, expr19_0, expr21_0)?;
                            let expr23_0 = C::value_regs(ctx, expr22_0, expr16_0);
                            let expr24_0 = C::output(ctx, expr23_0);
                            return Some(expr24_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 664.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr2_0: usize = 0;
                            let expr3_0 = C::value_regs_get(ctx, expr1_0, expr2_0);
                            let expr4_0 = constructor_lower_shl128(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = C::output(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 748.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr2_0: usize = 0;
                            let expr3_0 = C::value_regs_get(ctx, expr1_0, expr2_0);
                            let expr4_0 = constructor_lower_ushr128(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = C::output(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 795.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr2_0: usize = 0;
                            let expr3_0 = C::value_regs_get(ctx, expr1_0, expr2_0);
                            let expr4_0 = constructor_lower_sshr128(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = C::output(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Bnot => {
                            // Rule at src/isa/aarch64/lower.isle line 569.
                            let expr0_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0: Type = I64;
                            let expr6_0 = C::zero_reg(ctx);
                            let expr7_0 = constructor_orr_not(ctx, expr5_0, expr6_0, expr2_0)?;
                            let expr8_0: Type = I64;
                            let expr9_0 = C::zero_reg(ctx);
                            let expr10_0 = constructor_orr_not(ctx, expr8_0, expr9_0, expr4_0)?;
                            let expr11_0 = C::value_regs(ctx, expr7_0, expr10_0);
                            let expr12_0 = C::output(ctx, expr11_0);
                            return Some(expr12_0);
                        }
                        &Opcode::Bitrev => {
                            // Rule at src/isa/aarch64/lower.isle line 983.
                            let expr0_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr1_0: Type = I64;
                            let expr2_0: usize = 0;
                            let expr3_0 = C::value_regs_get(ctx, expr0_0, expr2_0);
                            let expr4_0 = constructor_rbit(ctx, expr1_0, expr3_0)?;
                            let expr5_0: Type = I64;
                            let expr6_0: usize = 1;
                            let expr7_0 = C::value_regs_get(ctx, expr0_0, expr6_0);
                            let expr8_0 = constructor_rbit(ctx, expr5_0, expr7_0)?;
                            let expr9_0 = C::value_regs(ctx, expr8_0, expr4_0);
                            let expr10_0 = C::output(ctx, expr9_0);
                            return Some(expr10_0);
                        }
                        &Opcode::Clz => {
                            // Rule at src/isa/aarch64/lower.isle line 1001.
                            let expr0_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr1_0 = constructor_lower_clz128(ctx, expr0_0)?;
                            let expr2_0 = C::output(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                        &Opcode::Cls => {
                            // Rule at src/isa/aarch64/lower.isle line 1057.
                            let expr0_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0: Type = I64;
                            let expr6_0 = constructor_a64_cls(ctx, expr5_0, expr2_0)?;
                            let expr7_0: Type = I64;
                            let expr8_0 = constructor_a64_cls(ctx, expr7_0, expr4_0)?;
                            let expr9_0: Type = I64;
                            let expr10_0 = constructor_eon(ctx, expr9_0, expr4_0, expr2_0)?;
                            let expr11_0: Type = I64;
                            let expr12_0: u8 = 63;
                            let expr13_0 = C::imm_shift_from_u8(ctx, expr12_0);
                            let expr14_0 = constructor_lsr_imm(ctx, expr11_0, expr10_0, expr13_0)?;
                            let expr15_0 = constructor_madd64(ctx, expr6_0, expr14_0, expr14_0)?;
                            let expr16_0: u8 = 63;
                            let expr17_0 = C::u8_into_imm12(ctx, expr16_0);
                            let expr18_0 = constructor_cmp64_imm(ctx, expr8_0, expr17_0)?;
                            let expr19_0 = Cond::Eq;
                            let expr20_0 = C::zero_reg(ctx);
                            let expr21_0 = constructor_csel(ctx, &expr19_0, expr15_0, expr20_0)?;
                            let expr22_0 = constructor_with_flags_reg(ctx, &expr18_0, &expr21_0)?;
                            let expr23_0: Type = I64;
                            let expr24_0 = constructor_add(ctx, expr23_0, expr22_0, expr8_0)?;
                            let expr25_0: Type = I64;
                            let expr26_0: u64 = 0;
                            let expr27_0 = constructor_imm(ctx, expr25_0, expr26_0)?;
                            let expr28_0 = C::value_regs(ctx, expr24_0, expr27_0);
                            let expr29_0 = C::output(ctx, expr28_0);
                            return Some(expr29_0);
                        }
                        &Opcode::Ctz => {
                            // Rule at src/isa/aarch64/lower.isle line 1031.
                            let expr0_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr1_0: Type = I64;
                            let expr2_0: usize = 0;
                            let expr3_0 = C::value_regs_get(ctx, expr0_0, expr2_0);
                            let expr4_0 = constructor_rbit(ctx, expr1_0, expr3_0)?;
                            let expr5_0: Type = I64;
                            let expr6_0: usize = 1;
                            let expr7_0 = C::value_regs_get(ctx, expr0_0, expr6_0);
                            let expr8_0 = constructor_rbit(ctx, expr5_0, expr7_0)?;
                            let expr9_0 = C::value_regs(ctx, expr8_0, expr4_0);
                            let expr10_0 = constructor_lower_clz128(ctx, expr9_0)?;
                            let expr11_0 = C::output(ctx, expr10_0);
                            return Some(expr11_0);
                        }
                        &Opcode::Popcnt => {
                            // Rule at src/isa/aarch64/lower.isle line 1117.
                            let expr0_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0 = ScalarSize::Size64;
                            let expr4_0 = constructor_mov_to_fpu(ctx, expr2_0, &expr3_0)?;
                            let expr5_0: usize = 1;
                            let expr6_0 = C::value_regs_get(ctx, expr0_0, expr5_0);
                            let expr7_0: u8 = 1;
                            let expr8_0 = VectorSize::Size64x2;
                            let expr9_0 =
                                constructor_mov_to_vec(ctx, expr4_0, expr6_0, expr7_0, &expr8_0)?;
                            let expr10_0 = VectorSize::Size8x16;
                            let expr11_0 = constructor_vec_cnt(ctx, expr9_0, &expr10_0)?;
                            let expr12_0 = VectorSize::Size8x16;
                            let expr13_0 = constructor_addv(ctx, expr11_0, &expr12_0)?;
                            let expr14_0: u8 = 0;
                            let expr15_0 = VectorSize::Size8x16;
                            let expr16_0 =
                                constructor_mov_from_vec(ctx, expr13_0, expr14_0, &expr15_0)?;
                            let expr17_0: Type = I64;
                            let expr18_0: u64 = 0;
                            let expr19_0 = constructor_imm(ctx, expr17_0, expr18_0)?;
                            let expr20_0 = C::value_regs(ctx, expr16_0, expr19_0);
                            let expr21_0 = C::output(ctx, expr20_0);
                            return Some(expr21_0);
                        }
                        &Opcode::Uextend => {
                            if let Some(pattern7_0) = C::def_inst(ctx, pattern5_1) {
                                let pattern8_0 = C::inst_data(ctx, pattern7_0);
                                if let &InstructionData::BinaryImm8 {
                                    opcode: ref pattern9_0,
                                    arg: pattern9_1,
                                    imm: pattern9_2,
                                } = &pattern8_0
                                {
                                    if let &Opcode::Extractlane = pattern9_0 {
                                        let pattern11_0 = C::value_type(ctx, pattern9_1);
                                        let pattern12_0 = C::u8_from_uimm8(ctx, pattern9_2);
                                        // Rule at src/isa/aarch64/lower.isle line 499.
                                        let expr0_0 = C::put_in_reg(ctx, pattern9_1);
                                        let expr1_0 = constructor_vector_size(ctx, pattern11_0)?;
                                        let expr2_0 = constructor_mov_from_vec(
                                            ctx,
                                            expr0_0,
                                            pattern12_0,
                                            &expr1_0,
                                        )?;
                                        let expr3_0: Type = I64;
                                        let expr4_0: u64 = 0;
                                        let expr5_0 = constructor_imm(ctx, expr3_0, expr4_0)?;
                                        let expr6_0 = C::value_regs(ctx, expr2_0, expr5_0);
                                        let expr7_0 = C::output(ctx, expr6_0);
                                        return Some(expr7_0);
                                    }
                                }
                            }
                            // Rule at src/isa/aarch64/lower.isle line 494.
                            let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern5_1)?;
                            let expr1_0: Type = I64;
                            let expr2_0: u64 = 0;
                            let expr3_0 = constructor_imm(ctx, expr1_0, expr2_0)?;
                            let expr4_0 = C::value_regs(ctx, expr0_0, expr3_0);
                            let expr5_0 = C::output(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                        &Opcode::Sextend => {
                            if let Some(pattern7_0) = C::def_inst(ctx, pattern5_1) {
                                let pattern8_0 = C::inst_data(ctx, pattern7_0);
                                if let &InstructionData::BinaryImm8 {
                                    opcode: ref pattern9_0,
                                    arg: pattern9_1,
                                    imm: pattern9_2,
                                } = &pattern8_0
                                {
                                    if let &Opcode::Extractlane = pattern9_0 {
                                        let pattern11_0 = C::value_type(ctx, pattern9_1);
                                        if pattern11_0 == I64X2 {
                                            let pattern13_0 = C::u8_from_uimm8(ctx, pattern9_2);
                                            // Rule at src/isa/aarch64/lower.isle line 543.
                                            let expr0_0 = C::put_in_reg(ctx, pattern9_1);
                                            let expr1_0 = VectorSize::Size64x2;
                                            let expr2_0 = constructor_mov_from_vec(
                                                ctx,
                                                expr0_0,
                                                pattern13_0,
                                                &expr1_0,
                                            )?;
                                            let expr3_0: Type = I64;
                                            let expr4_0: u8 = 63;
                                            let expr5_0 = C::imm_shift_from_u8(ctx, expr4_0);
                                            let expr6_0 = constructor_asr_imm(
                                                ctx, expr3_0, expr2_0, expr5_0,
                                            )?;
                                            let expr7_0 = C::value_regs(ctx, expr2_0, expr6_0);
                                            let expr8_0 = C::output(ctx, expr7_0);
                                            return Some(expr8_0);
                                        }
                                        if let Some(()) = C::not_i64x2(ctx, pattern11_0) {
                                            let pattern13_0 = C::u8_from_uimm8(ctx, pattern9_2);
                                            // Rule at src/isa/aarch64/lower.isle line 532.
                                            let expr0_0 = C::put_in_reg(ctx, pattern9_1);
                                            let expr1_0 =
                                                constructor_vector_size(ctx, pattern11_0)?;
                                            let expr2_0: Type = I64;
                                            let expr3_0 = constructor_size_from_ty(ctx, expr2_0)?;
                                            let expr4_0 = constructor_mov_from_vec_signed(
                                                ctx,
                                                expr0_0,
                                                pattern13_0,
                                                &expr1_0,
                                                &expr3_0,
                                            )?;
                                            let expr5_0: Type = I64;
                                            let expr6_0: u8 = 63;
                                            let expr7_0 = C::imm_shift_from_u8(ctx, expr6_0);
                                            let expr8_0 = constructor_asr_imm(
                                                ctx, expr5_0, expr4_0, expr7_0,
                                            )?;
                                            let expr9_0 = C::value_regs(ctx, expr4_0, expr8_0);
                                            let expr10_0 = C::output(ctx, expr9_0);
                                            return Some(expr10_0);
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/aarch64/lower.isle line 522.
                            let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern5_1)?;
                            let expr1_0: Type = I64;
                            let expr2_0: u8 = 63;
                            let expr3_0 = C::imm_shift_from_u8(ctx, expr2_0);
                            let expr4_0 = constructor_asr_imm(ctx, expr1_0, expr0_0, expr3_0)?;
                            let expr5_0 = C::value_regs(ctx, expr0_0, expr4_0);
                            let expr6_0 = C::output(ctx, expr5_0);
                            return Some(expr6_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I8X16 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Popcnt = pattern5_0 {
                    // Rule at src/isa/aarch64/lower.isle line 1125.
                    let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                    let expr1_0 = VectorSize::Size8x16;
                    let expr2_0 = constructor_vec_cnt(ctx, expr0_0, &expr1_0)?;
                    let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                    return Some(expr3_0);
                }
            }
        }
        if pattern2_0 == I16X8 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Imul = pattern5_0 {
                    let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                    if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                        let pattern9_0 = C::inst_data(ctx, pattern8_0);
                        if let &InstructionData::Unary {
                            opcode: ref pattern10_0,
                            arg: pattern10_1,
                        } = &pattern9_0
                        {
                            match pattern10_0 {
                                &Opcode::SwidenLow => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I8X16 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::SwidenLow = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I8X16 {
                                                        // Rule at src/isa/aarch64/lower.isle line 282.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = false;
                                                        let expr3_0 = constructor_smull8(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                &Opcode::SwidenHigh => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I8X16 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::SwidenHigh = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I8X16 {
                                                        // Rule at src/isa/aarch64/lower.isle line 288.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = true;
                                                        let expr3_0 = constructor_smull8(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                &Opcode::UwidenLow => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I8X16 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::UwidenLow = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I8X16 {
                                                        // Rule at src/isa/aarch64/lower.isle line 294.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = false;
                                                        let expr3_0 = constructor_umull8(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                &Opcode::UwidenHigh => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I8X16 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::UwidenHigh = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I8X16 {
                                                        // Rule at src/isa/aarch64/lower.isle line 300.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = true;
                                                        let expr3_0 = constructor_umull8(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
            }
        }
        if pattern2_0 == I32X4 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Imul = pattern5_0 {
                    let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                    if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                        let pattern9_0 = C::inst_data(ctx, pattern8_0);
                        if let &InstructionData::Unary {
                            opcode: ref pattern10_0,
                            arg: pattern10_1,
                        } = &pattern9_0
                        {
                            match pattern10_0 {
                                &Opcode::SwidenLow => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I16X8 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::SwidenLow = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I16X8 {
                                                        // Rule at src/isa/aarch64/lower.isle line 306.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = false;
                                                        let expr3_0 = constructor_smull16(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                &Opcode::SwidenHigh => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I16X8 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::SwidenHigh = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I16X8 {
                                                        // Rule at src/isa/aarch64/lower.isle line 312.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = true;
                                                        let expr3_0 = constructor_smull16(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                &Opcode::UwidenLow => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I16X8 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::UwidenLow = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I16X8 {
                                                        // Rule at src/isa/aarch64/lower.isle line 318.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = false;
                                                        let expr3_0 = constructor_umull16(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                &Opcode::UwidenHigh => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I16X8 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::UwidenHigh = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I16X8 {
                                                        // Rule at src/isa/aarch64/lower.isle line 324.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = true;
                                                        let expr3_0 = constructor_umull16(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
            }
        }
        if pattern2_0 == I64X2 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Imul = pattern5_0 {
                    let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                    if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                        let pattern9_0 = C::inst_data(ctx, pattern8_0);
                        if let &InstructionData::Unary {
                            opcode: ref pattern10_0,
                            arg: pattern10_1,
                        } = &pattern9_0
                        {
                            match pattern10_0 {
                                &Opcode::SwidenLow => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I32X4 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::SwidenLow = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I32X4 {
                                                        // Rule at src/isa/aarch64/lower.isle line 330.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = false;
                                                        let expr3_0 = constructor_smull32(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                &Opcode::SwidenHigh => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I32X4 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::SwidenHigh = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I32X4 {
                                                        // Rule at src/isa/aarch64/lower.isle line 336.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = true;
                                                        let expr3_0 = constructor_smull32(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                &Opcode::UwidenLow => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I32X4 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::UwidenLow = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I32X4 {
                                                        // Rule at src/isa/aarch64/lower.isle line 342.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = false;
                                                        let expr3_0 = constructor_umull32(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                &Opcode::UwidenHigh => {
                                    let pattern12_0 = C::value_type(ctx, pattern10_1);
                                    if pattern12_0 == I32X4 {
                                        if let Some(pattern14_0) = C::def_inst(ctx, pattern7_1) {
                                            let pattern15_0 = C::inst_data(ctx, pattern14_0);
                                            if let &InstructionData::Unary {
                                                opcode: ref pattern16_0,
                                                arg: pattern16_1,
                                            } = &pattern15_0
                                            {
                                                if let &Opcode::UwidenHigh = pattern16_0 {
                                                    let pattern18_0 =
                                                        C::value_type(ctx, pattern16_1);
                                                    if pattern18_0 == I32X4 {
                                                        // Rule at src/isa/aarch64/lower.isle line 348.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern10_1);
                                                        let expr1_0 =
                                                            C::put_in_reg(ctx, pattern16_1);
                                                        let expr2_0: bool = true;
                                                        let expr3_0 = constructor_umull32(
                                                            ctx, expr0_0, expr1_0, expr2_0,
                                                        )?;
                                                        let expr4_0 =
                                                            constructor_output_reg(ctx, expr3_0)?;
                                                        return Some(expr4_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                    // Rule at src/isa/aarch64/lower.isle line 243.
                    let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                    let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                    let expr2_0 = VectorSize::Size32x4;
                    let expr3_0 = constructor_rev64(ctx, expr1_0, &expr2_0)?;
                    let expr4_0 = VectorSize::Size32x4;
                    let expr5_0 = constructor_mul(ctx, expr3_0, expr0_0, &expr4_0)?;
                    let expr6_0: bool = false;
                    let expr7_0 = constructor_xtn64(ctx, expr0_0, expr6_0)?;
                    let expr8_0 = VectorSize::Size32x4;
                    let expr9_0 = constructor_addp(ctx, expr5_0, expr5_0, &expr8_0)?;
                    let expr10_0: bool = false;
                    let expr11_0 = constructor_xtn64(ctx, expr1_0, expr10_0)?;
                    let expr12_0: bool = false;
                    let expr13_0 = constructor_shll32(ctx, expr9_0, expr12_0)?;
                    let expr14_0: bool = false;
                    let expr15_0 = constructor_umlal32(ctx, expr13_0, expr11_0, expr7_0, expr14_0)?;
                    let expr16_0 = constructor_output_reg(ctx, expr15_0)?;
                    return Some(expr16_0);
                }
            }
        }
        let pattern3_0 = C::inst_data(ctx, pattern0_0);
        match &pattern3_0 {
            &InstructionData::NullAry {
                opcode: ref pattern4_0,
            } => {
                if let &Opcode::Null = pattern4_0 {
                    // Rule at src/isa/aarch64/lower.isle line 22.
                    let expr0_0: u64 = 0;
                    let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                    let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                    return Some(expr2_0);
                }
            }
            &InstructionData::UnaryImm {
                opcode: ref pattern4_0,
                imm: pattern4_1,
            } => {
                if let &Opcode::Iconst = pattern4_0 {
                    let pattern6_0 = C::u64_from_imm64(ctx, pattern4_1);
                    // Rule at src/isa/aarch64/lower.isle line 9.
                    let expr0_0 = constructor_imm(ctx, pattern2_0, pattern6_0)?;
                    let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                    return Some(expr1_0);
                }
            }
            &InstructionData::UnaryBool {
                opcode: ref pattern4_0,
                imm: pattern4_1,
            } => {
                if let &Opcode::Bconst = pattern4_0 {
                    if pattern4_1 == true {
                        // Rule at src/isa/aarch64/lower.isle line 17.
                        let expr0_0: u64 = 1;
                        let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    if pattern4_1 == false {
                        // Rule at src/isa/aarch64/lower.isle line 14.
                        let expr0_0: u64 = 0;
                        let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
            }
            &InstructionData::Unary {
                opcode: ref pattern4_0,
                arg: pattern4_1,
            } => {
                match pattern4_0 {
                    &Opcode::Bitrev => {
                        // Rule at src/isa/aarch64/lower.isle line 989.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_rbit(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Clz => {
                        // Rule at src/isa/aarch64/lower.isle line 1004.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_a64_clz(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Cls => {
                        // Rule at src/isa/aarch64/lower.isle line 1071.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_a64_cls(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Ctz => {
                        // Rule at src/isa/aarch64/lower.isle line 1037.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_rbit(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = constructor_a64_clz(ctx, pattern2_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    _ => {}
                }
            }
            _ => {}
        }
        if let Some((pattern3_0, pattern3_1)) = C::multi_lane(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Iadd => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 75.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vector_size(ctx, pattern2_0)?;
                            let expr3_0 = constructor_add_vec(ctx, expr0_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Isub => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 125.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vector_size(ctx, pattern2_0)?;
                            let expr3_0 = constructor_sub_vec(ctx, expr0_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::FloatCompare {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                    cond: ref pattern5_2,
                } => {
                    if let &Opcode::Fcmp = pattern5_0 {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                            let pattern9_0 = C::inst_data(ctx, pattern8_0);
                            if let &InstructionData::Unary {
                                opcode: ref pattern10_0,
                                arg: pattern10_1,
                            } = &pattern9_0
                            {
                                if let &Opcode::Splat = pattern10_0 {
                                    if let Some(pattern12_0) = C::def_inst(ctx, pattern10_1) {
                                        let pattern13_0 = C::inst_data(ctx, pattern12_0);
                                        match &pattern13_0 {
                                            &InstructionData::UnaryIeee32 {
                                                opcode: ref pattern14_0,
                                                imm: pattern14_1,
                                            } => {
                                                if let &Opcode::F32const = pattern14_0 {
                                                    if let Some(pattern16_0) =
                                                        C::zero_value_f32(ctx, pattern14_1)
                                                    {
                                                        if let Some(pattern17_0) =
                                                            C::fcmp_zero_cond(ctx, pattern5_2)
                                                        {
                                                            // Rule at src/isa/aarch64/lower.isle line 1145.
                                                            let expr0_0 =
                                                                C::put_in_reg(ctx, pattern7_1);
                                                            let expr1_0 = constructor_vector_size(
                                                                ctx, pattern2_0,
                                                            )?;
                                                            let expr2_0 =
                                                                constructor_float_cmp_zero_swap(
                                                                    ctx,
                                                                    &pattern17_0,
                                                                    expr0_0,
                                                                    &expr1_0,
                                                                )?;
                                                            let expr3_0 =
                                                                C::value_reg(ctx, expr2_0);
                                                            let expr4_0 = C::output(ctx, expr3_0);
                                                            return Some(expr4_0);
                                                        }
                                                        if let Some(pattern17_0) =
                                                            C::fcmp_zero_cond_not_eq(
                                                                ctx, pattern5_2,
                                                            )
                                                        {
                                                            // Rule at src/isa/aarch64/lower.isle line 1140.
                                                            let expr0_0 =
                                                                C::put_in_reg(ctx, pattern7_1);
                                                            let expr1_0 = constructor_vector_size(
                                                                ctx, pattern2_0,
                                                            )?;
                                                            let expr2_0 = constructor_fcmeq0(
                                                                ctx, expr0_0, &expr1_0,
                                                            )?;
                                                            let expr3_0 = constructor_not(
                                                                ctx, expr2_0, &expr1_0,
                                                            )?;
                                                            let expr4_0 =
                                                                C::value_reg(ctx, expr3_0);
                                                            let expr5_0 = C::output(ctx, expr4_0);
                                                            return Some(expr5_0);
                                                        }
                                                    }
                                                }
                                            }
                                            &InstructionData::UnaryIeee64 {
                                                opcode: ref pattern14_0,
                                                imm: pattern14_1,
                                            } => {
                                                if let &Opcode::F64const = pattern14_0 {
                                                    if let Some(pattern16_0) =
                                                        C::zero_value_f64(ctx, pattern14_1)
                                                    {
                                                        if let Some(pattern17_0) =
                                                            C::fcmp_zero_cond(ctx, pattern5_2)
                                                        {
                                                            // Rule at src/isa/aarch64/lower.isle line 1167.
                                                            let expr0_0 =
                                                                C::put_in_reg(ctx, pattern7_1);
                                                            let expr1_0 = constructor_vector_size(
                                                                ctx, pattern2_0,
                                                            )?;
                                                            let expr2_0 =
                                                                constructor_float_cmp_zero_swap(
                                                                    ctx,
                                                                    &pattern17_0,
                                                                    expr0_0,
                                                                    &expr1_0,
                                                                )?;
                                                            let expr3_0 =
                                                                C::value_reg(ctx, expr2_0);
                                                            let expr4_0 = C::output(ctx, expr3_0);
                                                            return Some(expr4_0);
                                                        }
                                                        if let Some(pattern17_0) =
                                                            C::fcmp_zero_cond_not_eq(
                                                                ctx, pattern5_2,
                                                            )
                                                        {
                                                            // Rule at src/isa/aarch64/lower.isle line 1162.
                                                            let expr0_0 =
                                                                C::put_in_reg(ctx, pattern7_1);
                                                            let expr1_0 = constructor_vector_size(
                                                                ctx, pattern2_0,
                                                            )?;
                                                            let expr2_0 = constructor_fcmeq0(
                                                                ctx, expr0_0, &expr1_0,
                                                            )?;
                                                            let expr3_0 = constructor_not(
                                                                ctx, expr2_0, &expr1_0,
                                                            )?;
                                                            let expr4_0 =
                                                                C::value_reg(ctx, expr3_0);
                                                            let expr5_0 = C::output(ctx, expr4_0);
                                                            return Some(expr5_0);
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                }
                            }
                        }
                        if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                            let pattern9_0 = C::inst_data(ctx, pattern8_0);
                            if let &InstructionData::Unary {
                                opcode: ref pattern10_0,
                                arg: pattern10_1,
                            } = &pattern9_0
                            {
                                if let &Opcode::Splat = pattern10_0 {
                                    if let Some(pattern12_0) = C::def_inst(ctx, pattern10_1) {
                                        let pattern13_0 = C::inst_data(ctx, pattern12_0);
                                        match &pattern13_0 {
                                            &InstructionData::UnaryIeee32 {
                                                opcode: ref pattern14_0,
                                                imm: pattern14_1,
                                            } => {
                                                if let &Opcode::F32const = pattern14_0 {
                                                    if let Some(pattern16_0) =
                                                        C::zero_value_f32(ctx, pattern14_1)
                                                    {
                                                        if let Some(pattern17_0) =
                                                            C::fcmp_zero_cond(ctx, pattern5_2)
                                                        {
                                                            // Rule at src/isa/aarch64/lower.isle line 1135.
                                                            let expr0_0 =
                                                                C::put_in_reg(ctx, pattern7_0);
                                                            let expr1_0 = constructor_vector_size(
                                                                ctx, pattern2_0,
                                                            )?;
                                                            let expr2_0 =
                                                                constructor_float_cmp_zero(
                                                                    ctx,
                                                                    &pattern17_0,
                                                                    expr0_0,
                                                                    &expr1_0,
                                                                )?;
                                                            let expr3_0 =
                                                                C::value_reg(ctx, expr2_0);
                                                            let expr4_0 = C::output(ctx, expr3_0);
                                                            return Some(expr4_0);
                                                        }
                                                        if let Some(pattern17_0) =
                                                            C::fcmp_zero_cond_not_eq(
                                                                ctx, pattern5_2,
                                                            )
                                                        {
                                                            // Rule at src/isa/aarch64/lower.isle line 1130.
                                                            let expr0_0 =
                                                                C::put_in_reg(ctx, pattern7_0);
                                                            let expr1_0 = constructor_vector_size(
                                                                ctx, pattern2_0,
                                                            )?;
                                                            let expr2_0 = constructor_fcmeq0(
                                                                ctx, expr0_0, &expr1_0,
                                                            )?;
                                                            let expr3_0 = constructor_not(
                                                                ctx, expr2_0, &expr1_0,
                                                            )?;
                                                            let expr4_0 =
                                                                C::value_reg(ctx, expr3_0);
                                                            let expr5_0 = C::output(ctx, expr4_0);
                                                            return Some(expr5_0);
                                                        }
                                                    }
                                                }
                                            }
                                            &InstructionData::UnaryIeee64 {
                                                opcode: ref pattern14_0,
                                                imm: pattern14_1,
                                            } => {
                                                if let &Opcode::F64const = pattern14_0 {
                                                    if let Some(pattern16_0) =
                                                        C::zero_value_f64(ctx, pattern14_1)
                                                    {
                                                        if let Some(pattern17_0) =
                                                            C::fcmp_zero_cond(ctx, pattern5_2)
                                                        {
                                                            // Rule at src/isa/aarch64/lower.isle line 1157.
                                                            let expr0_0 =
                                                                C::put_in_reg(ctx, pattern7_0);
                                                            let expr1_0 = constructor_vector_size(
                                                                ctx, pattern2_0,
                                                            )?;
                                                            let expr2_0 =
                                                                constructor_float_cmp_zero(
                                                                    ctx,
                                                                    &pattern17_0,
                                                                    expr0_0,
                                                                    &expr1_0,
                                                                )?;
                                                            let expr3_0 =
                                                                C::value_reg(ctx, expr2_0);
                                                            let expr4_0 = C::output(ctx, expr3_0);
                                                            return Some(expr4_0);
                                                        }
                                                        if let Some(pattern17_0) =
                                                            C::fcmp_zero_cond_not_eq(
                                                                ctx, pattern5_2,
                                                            )
                                                        {
                                                            // Rule at src/isa/aarch64/lower.isle line 1152.
                                                            let expr0_0 =
                                                                C::put_in_reg(ctx, pattern7_0);
                                                            let expr1_0 = constructor_vector_size(
                                                                ctx, pattern2_0,
                                                            )?;
                                                            let expr2_0 = constructor_fcmeq0(
                                                                ctx, expr0_0, &expr1_0,
                                                            )?;
                                                            let expr3_0 = constructor_not(
                                                                ctx, expr2_0, &expr1_0,
                                                            )?;
                                                            let expr4_0 =
                                                                C::value_reg(ctx, expr3_0);
                                                            let expr5_0 = C::output(ctx, expr4_0);
                                                            return Some(expr5_0);
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                &InstructionData::IntCompare {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                    cond: ref pattern5_2,
                } => {
                    if let &Opcode::Icmp = pattern5_0 {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                            let pattern9_0 = C::inst_data(ctx, pattern8_0);
                            if let &InstructionData::Unary {
                                opcode: ref pattern10_0,
                                arg: pattern10_1,
                            } = &pattern9_0
                            {
                                if let &Opcode::Splat = pattern10_0 {
                                    if let Some(pattern12_0) = C::def_inst(ctx, pattern10_1) {
                                        let pattern13_0 = C::inst_data(ctx, pattern12_0);
                                        if let &InstructionData::UnaryImm {
                                            opcode: ref pattern14_0,
                                            imm: pattern14_1,
                                        } = &pattern13_0
                                        {
                                            if let &Opcode::Iconst = pattern14_0 {
                                                if let Some(pattern16_0) =
                                                    C::zero_value(ctx, pattern14_1)
                                                {
                                                    if let Some(pattern17_0) =
                                                        C::icmp_zero_cond(ctx, pattern5_2)
                                                    {
                                                        // Rule at src/isa/aarch64/lower.isle line 1189.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern7_1);
                                                        let expr1_0 = constructor_vector_size(
                                                            ctx, pattern2_0,
                                                        )?;
                                                        let expr2_0 =
                                                            constructor_int_cmp_zero_swap(
                                                                ctx,
                                                                &pattern17_0,
                                                                expr0_0,
                                                                &expr1_0,
                                                            )?;
                                                        let expr3_0 = C::value_reg(ctx, expr2_0);
                                                        let expr4_0 = C::output(ctx, expr3_0);
                                                        return Some(expr4_0);
                                                    }
                                                    if let Some(pattern17_0) =
                                                        C::icmp_zero_cond_not_eq(ctx, pattern5_2)
                                                    {
                                                        // Rule at src/isa/aarch64/lower.isle line 1184.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern7_1);
                                                        let expr1_0 = constructor_vector_size(
                                                            ctx, pattern2_0,
                                                        )?;
                                                        let expr2_0 = constructor_cmeq0(
                                                            ctx, expr0_0, &expr1_0,
                                                        )?;
                                                        let expr3_0 = constructor_not(
                                                            ctx, expr2_0, &expr1_0,
                                                        )?;
                                                        let expr4_0 = C::value_reg(ctx, expr3_0);
                                                        let expr5_0 = C::output(ctx, expr4_0);
                                                        return Some(expr5_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                            let pattern9_0 = C::inst_data(ctx, pattern8_0);
                            if let &InstructionData::Unary {
                                opcode: ref pattern10_0,
                                arg: pattern10_1,
                            } = &pattern9_0
                            {
                                if let &Opcode::Splat = pattern10_0 {
                                    if let Some(pattern12_0) = C::def_inst(ctx, pattern10_1) {
                                        let pattern13_0 = C::inst_data(ctx, pattern12_0);
                                        if let &InstructionData::UnaryImm {
                                            opcode: ref pattern14_0,
                                            imm: pattern14_1,
                                        } = &pattern13_0
                                        {
                                            if let &Opcode::Iconst = pattern14_0 {
                                                if let Some(pattern16_0) =
                                                    C::zero_value(ctx, pattern14_1)
                                                {
                                                    if let Some(pattern17_0) =
                                                        C::icmp_zero_cond(ctx, pattern5_2)
                                                    {
                                                        // Rule at src/isa/aarch64/lower.isle line 1179.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern7_0);
                                                        let expr1_0 = constructor_vector_size(
                                                            ctx, pattern2_0,
                                                        )?;
                                                        let expr2_0 = constructor_int_cmp_zero(
                                                            ctx,
                                                            &pattern17_0,
                                                            expr0_0,
                                                            &expr1_0,
                                                        )?;
                                                        let expr3_0 = C::value_reg(ctx, expr2_0);
                                                        let expr4_0 = C::output(ctx, expr3_0);
                                                        return Some(expr4_0);
                                                    }
                                                    if let Some(pattern17_0) =
                                                        C::icmp_zero_cond_not_eq(ctx, pattern5_2)
                                                    {
                                                        // Rule at src/isa/aarch64/lower.isle line 1174.
                                                        let expr0_0 =
                                                            C::put_in_reg(ctx, pattern7_0);
                                                        let expr1_0 = constructor_vector_size(
                                                            ctx, pattern2_0,
                                                        )?;
                                                        let expr2_0 = constructor_cmeq0(
                                                            ctx, expr0_0, &expr1_0,
                                                        )?;
                                                        let expr3_0 = constructor_not(
                                                            ctx, expr2_0, &expr1_0,
                                                        )?;
                                                        let expr4_0 = C::value_reg(ctx, expr3_0);
                                                        let expr5_0 = C::output(ctx, expr4_0);
                                                        return Some(expr5_0);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::fits_in_16(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } = &pattern4_0
            {
                match pattern5_0 {
                    &Opcode::Rotl => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                            let pattern9_0 = C::inst_data(ctx, pattern8_0);
                            if let &InstructionData::UnaryImm {
                                opcode: ref pattern10_0,
                                imm: pattern10_1,
                            } = &pattern9_0
                            {
                                if let &Opcode::Iconst = pattern10_0 {
                                    let closure12 = || {
                                        return Some(pattern3_0);
                                    };
                                    if let Some(pattern12_0) = closure12() {
                                        if let Some(pattern13_0) =
                                            C::imm_shift_from_imm64(ctx, pattern10_1, pattern12_0)
                                        {
                                            // Rule at src/isa/aarch64/lower.isle line 843.
                                            let expr0_0 =
                                                constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                                            let expr1_0 =
                                                C::negate_imm_shift(ctx, pattern3_0, pattern13_0);
                                            let expr2_0 = constructor_small_rotr_imm(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                        }
                        // Rule at src/isa/aarch64/lower.isle line 838.
                        let expr0_0: Type = I32;
                        let expr1_0 = C::zero_reg(ctx);
                        let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr3_0 = constructor_sub(ctx, expr0_0, expr1_0, expr2_0)?;
                        let expr4_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                        let expr5_0 = constructor_small_rotr(ctx, pattern3_0, expr4_0, expr3_0)?;
                        let expr6_0 = constructor_output_reg(ctx, expr5_0)?;
                        return Some(expr6_0);
                    }
                    &Opcode::Rotr => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                            let pattern9_0 = C::inst_data(ctx, pattern8_0);
                            if let &InstructionData::UnaryImm {
                                opcode: ref pattern10_0,
                                imm: pattern10_1,
                            } = &pattern9_0
                            {
                                if let &Opcode::Iconst = pattern10_0 {
                                    let closure12 = || {
                                        return Some(pattern3_0);
                                    };
                                    if let Some(pattern12_0) = closure12() {
                                        if let Some(pattern13_0) =
                                            C::imm_shift_from_imm64(ctx, pattern10_1, pattern12_0)
                                        {
                                            // Rule at src/isa/aarch64/lower.isle line 903.
                                            let expr0_0 =
                                                constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                                            let expr1_0 = constructor_small_rotr_imm(
                                                ctx,
                                                pattern3_0,
                                                expr0_0,
                                                pattern13_0,
                                            )?;
                                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                            return Some(expr2_0);
                                        }
                                    }
                                }
                            }
                        }
                        // Rule at src/isa/aarch64/lower.isle line 891.
                        let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                        let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr2_0 = constructor_small_rotr(ctx, pattern3_0, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    _ => {}
                }
            }
        }
        if let Some(pattern3_0) = C::fits_in_32(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } = &pattern4_0
            {
                match pattern5_0 {
                    &Opcode::Umulhi => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 370.
                        let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_reg_zext64(ctx, pattern7_1)?;
                        let expr2_0 = C::zero_reg(ctx);
                        let expr3_0 = constructor_madd64(ctx, expr0_0, expr1_0, expr2_0)?;
                        let expr4_0: Type = I64;
                        let expr5_0 = C::ty_bits(ctx, pattern3_0);
                        let expr6_0 = C::imm_shift_from_u8(ctx, expr5_0);
                        let expr7_0 = constructor_lsr_imm(ctx, expr4_0, expr3_0, expr6_0)?;
                        let expr8_0 = constructor_output_reg(ctx, expr7_0)?;
                        return Some(expr8_0);
                    }
                    &Opcode::Smulhi => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 358.
                        let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_reg_sext64(ctx, pattern7_1)?;
                        let expr2_0 = C::zero_reg(ctx);
                        let expr3_0 = constructor_madd64(ctx, expr0_0, expr1_0, expr2_0)?;
                        let expr4_0: Type = I64;
                        let expr5_0 = C::ty_bits(ctx, pattern3_0);
                        let expr6_0 = C::imm_shift_from_u8(ctx, expr5_0);
                        let expr7_0 = constructor_asr_imm(ctx, expr4_0, expr3_0, expr6_0)?;
                        let expr8_0 = constructor_output_reg(ctx, expr7_0)?;
                        return Some(expr8_0);
                    }
                    &Opcode::Band => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 583.
                        let expr0_0 = ALUOp::And;
                        let expr1_0 = constructor_alu_rs_imm_logic_commutative(
                            ctx, &expr0_0, pattern3_0, pattern7_0, pattern7_1,
                        )?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Bor => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 596.
                        let expr0_0 = ALUOp::Orr;
                        let expr1_0 = constructor_alu_rs_imm_logic_commutative(
                            ctx, &expr0_0, pattern3_0, pattern7_0, pattern7_1,
                        )?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::Bxor => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 609.
                        let expr0_0 = ALUOp::Eor;
                        let expr1_0 = constructor_alu_rs_imm_logic_commutative(
                            ctx, &expr0_0, pattern3_0, pattern7_0, pattern7_1,
                        )?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::BandNot => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 622.
                        let expr0_0 = ALUOp::AndNot;
                        let expr1_0 = constructor_alu_rs_imm_logic(
                            ctx, &expr0_0, pattern3_0, pattern7_0, pattern7_1,
                        )?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::BorNot => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 635.
                        let expr0_0 = ALUOp::OrrNot;
                        let expr1_0 = constructor_alu_rs_imm_logic(
                            ctx, &expr0_0, pattern3_0, pattern7_0, pattern7_1,
                        )?;
                        let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                    &Opcode::BxorNot => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 645.
                        let expr0_0 = ALUOp::EorNot;
                        let expr1_0: Type = I32;
                        let expr2_0 = constructor_alu_rs_imm_logic(
                            ctx, &expr0_0, expr1_0, pattern7_0, pattern7_1,
                        )?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Ishl => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 656.
                        let expr0_0 = ALUOp::Lsl;
                        let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                        let expr2_0 =
                            constructor_do_shift(ctx, &expr0_0, pattern3_0, expr1_0, pattern7_1)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Ushr => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 740.
                        let expr0_0 = ALUOp::Lsr;
                        let expr1_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                        let expr2_0 =
                            constructor_do_shift(ctx, &expr0_0, pattern3_0, expr1_0, pattern7_1)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Sshr => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/aarch64/lower.isle line 787.
                        let expr0_0 = ALUOp::Asr;
                        let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern7_0)?;
                        let expr2_0 =
                            constructor_do_shift(ctx, &expr0_0, pattern3_0, expr1_0, pattern7_1)?;
                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    _ => {}
                }
            }
        }
        if let Some(pattern3_0) = C::fits_in_64(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Iadd => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                match &pattern9_0 {
                                    &InstructionData::UnaryImm {
                                        opcode: ref pattern10_0,
                                        imm: pattern10_1,
                                    } => {
                                        if let &Opcode::Iconst = pattern10_0 {
                                            let pattern12_0 = C::u64_from_imm64(ctx, pattern10_1);
                                            if let Some(pattern13_0) =
                                                C::imm12_from_u64(ctx, pattern12_0)
                                            {
                                                // Rule at src/isa/aarch64/lower.isle line 37.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 = constructor_add_imm(
                                                    ctx,
                                                    pattern3_0,
                                                    expr0_0,
                                                    pattern13_0,
                                                )?;
                                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                                return Some(expr2_0);
                                            }
                                            if let Some(pattern13_0) =
                                                C::imm12_from_negated_u64(ctx, pattern12_0)
                                            {
                                                // Rule at src/isa/aarch64/lower.isle line 45.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 = constructor_sub_imm(
                                                    ctx,
                                                    pattern3_0,
                                                    expr0_0,
                                                    pattern13_0,
                                                )?;
                                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                                return Some(expr2_0);
                                            }
                                        }
                                    }
                                    &InstructionData::Binary {
                                        opcode: ref pattern10_0,
                                        args: ref pattern10_1,
                                    } => {
                                        match pattern10_0 {
                                            &Opcode::Imul => {
                                                let (pattern12_0, pattern12_1) =
                                                    C::unpack_value_array_2(ctx, pattern10_1);
                                                // Rule at src/isa/aarch64/lower.isle line 70.
                                                let expr0_0 = C::put_in_reg(ctx, pattern12_0);
                                                let expr1_0 = C::put_in_reg(ctx, pattern12_1);
                                                let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr3_0 = constructor_madd(
                                                    ctx, pattern3_0, expr0_0, expr1_0, expr2_0,
                                                )?;
                                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                                return Some(expr4_0);
                                            }
                                            &Opcode::Ishl => {
                                                let (pattern12_0, pattern12_1) =
                                                    C::unpack_value_array_2(ctx, pattern10_1);
                                                if let Some(pattern13_0) =
                                                    C::def_inst(ctx, pattern12_1)
                                                {
                                                    let pattern14_0 =
                                                        C::inst_data(ctx, pattern13_0);
                                                    if let &InstructionData::UnaryImm {
                                                        opcode: ref pattern15_0,
                                                        imm: pattern15_1,
                                                    } = &pattern14_0
                                                    {
                                                        if let &Opcode::Iconst = pattern15_0 {
                                                            let closure17 = || {
                                                                return Some(pattern3_0);
                                                            };
                                                            if let Some(pattern17_0) = closure17() {
                                                                if let Some(pattern18_0) =
                                                                    C::lshl_from_imm64(
                                                                        ctx,
                                                                        pattern15_1,
                                                                        pattern17_0,
                                                                    )
                                                                {
                                                                    // Rule at src/isa/aarch64/lower.isle line 62.
                                                                    let expr0_0 = C::put_in_reg(
                                                                        ctx, pattern7_1,
                                                                    );
                                                                    let expr1_0 = C::put_in_reg(
                                                                        ctx,
                                                                        pattern12_0,
                                                                    );
                                                                    let expr2_0 =
                                                                        constructor_add_shift(
                                                                            ctx,
                                                                            pattern3_0,
                                                                            expr0_0,
                                                                            expr1_0,
                                                                            pattern18_0,
                                                                        )?;
                                                                    let expr3_0 =
                                                                        constructor_output_reg(
                                                                            ctx, expr2_0,
                                                                        )?;
                                                                    return Some(expr3_0);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                    _ => {}
                                }
                            }
                            if let Some(pattern8_0) = C::extended_value_from_value(ctx, pattern7_0)
                            {
                                // Rule at src/isa/aarch64/lower.isle line 53.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_add_extend(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                match &pattern9_0 {
                                    &InstructionData::UnaryImm {
                                        opcode: ref pattern10_0,
                                        imm: pattern10_1,
                                    } => {
                                        if let &Opcode::Iconst = pattern10_0 {
                                            let pattern12_0 = C::u64_from_imm64(ctx, pattern10_1);
                                            if let Some(pattern13_0) =
                                                C::imm12_from_u64(ctx, pattern12_0)
                                            {
                                                // Rule at src/isa/aarch64/lower.isle line 34.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 = constructor_add_imm(
                                                    ctx,
                                                    pattern3_0,
                                                    expr0_0,
                                                    pattern13_0,
                                                )?;
                                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                                return Some(expr2_0);
                                            }
                                            if let Some(pattern13_0) =
                                                C::imm12_from_negated_u64(ctx, pattern12_0)
                                            {
                                                // Rule at src/isa/aarch64/lower.isle line 42.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 = constructor_sub_imm(
                                                    ctx,
                                                    pattern3_0,
                                                    expr0_0,
                                                    pattern13_0,
                                                )?;
                                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                                return Some(expr2_0);
                                            }
                                        }
                                    }
                                    &InstructionData::Binary {
                                        opcode: ref pattern10_0,
                                        args: ref pattern10_1,
                                    } => {
                                        match pattern10_0 {
                                            &Opcode::Imul => {
                                                let (pattern12_0, pattern12_1) =
                                                    C::unpack_value_array_2(ctx, pattern10_1);
                                                // Rule at src/isa/aarch64/lower.isle line 67.
                                                let expr0_0 = C::put_in_reg(ctx, pattern12_0);
                                                let expr1_0 = C::put_in_reg(ctx, pattern12_1);
                                                let expr2_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr3_0 = constructor_madd(
                                                    ctx, pattern3_0, expr0_0, expr1_0, expr2_0,
                                                )?;
                                                let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                                return Some(expr4_0);
                                            }
                                            &Opcode::Ishl => {
                                                let (pattern12_0, pattern12_1) =
                                                    C::unpack_value_array_2(ctx, pattern10_1);
                                                if let Some(pattern13_0) =
                                                    C::def_inst(ctx, pattern12_1)
                                                {
                                                    let pattern14_0 =
                                                        C::inst_data(ctx, pattern13_0);
                                                    if let &InstructionData::UnaryImm {
                                                        opcode: ref pattern15_0,
                                                        imm: pattern15_1,
                                                    } = &pattern14_0
                                                    {
                                                        if let &Opcode::Iconst = pattern15_0 {
                                                            let closure17 = || {
                                                                return Some(pattern3_0);
                                                            };
                                                            if let Some(pattern17_0) = closure17() {
                                                                if let Some(pattern18_0) =
                                                                    C::lshl_from_imm64(
                                                                        ctx,
                                                                        pattern15_1,
                                                                        pattern17_0,
                                                                    )
                                                                {
                                                                    // Rule at src/isa/aarch64/lower.isle line 58.
                                                                    let expr0_0 = C::put_in_reg(
                                                                        ctx, pattern7_0,
                                                                    );
                                                                    let expr1_0 = C::put_in_reg(
                                                                        ctx,
                                                                        pattern12_0,
                                                                    );
                                                                    let expr2_0 =
                                                                        constructor_add_shift(
                                                                            ctx,
                                                                            pattern3_0,
                                                                            expr0_0,
                                                                            expr1_0,
                                                                            pattern18_0,
                                                                        )?;
                                                                    let expr3_0 =
                                                                        constructor_output_reg(
                                                                            ctx, expr2_0,
                                                                        )?;
                                                                    return Some(expr3_0);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                    _ => {}
                                }
                            }
                            if let Some(pattern8_0) = C::extended_value_from_value(ctx, pattern7_1)
                            {
                                // Rule at src/isa/aarch64/lower.isle line 50.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_add_extend(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            // Rule at src/isa/aarch64/lower.isle line 30.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_add(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Isub => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                match &pattern9_0 {
                                    &InstructionData::UnaryImm {
                                        opcode: ref pattern10_0,
                                        imm: pattern10_1,
                                    } => {
                                        if let &Opcode::Iconst = pattern10_0 {
                                            let pattern12_0 = C::u64_from_imm64(ctx, pattern10_1);
                                            if let Some(pattern13_0) =
                                                C::imm12_from_u64(ctx, pattern12_0)
                                            {
                                                // Rule at src/isa/aarch64/lower.isle line 105.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 = constructor_sub_imm(
                                                    ctx,
                                                    pattern3_0,
                                                    expr0_0,
                                                    pattern13_0,
                                                )?;
                                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                                return Some(expr2_0);
                                            }
                                            if let Some(pattern13_0) =
                                                C::imm12_from_negated_u64(ctx, pattern12_0)
                                            {
                                                // Rule at src/isa/aarch64/lower.isle line 110.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 = constructor_add_imm(
                                                    ctx,
                                                    pattern3_0,
                                                    expr0_0,
                                                    pattern13_0,
                                                )?;
                                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                                return Some(expr2_0);
                                            }
                                        }
                                    }
                                    &InstructionData::Binary {
                                        opcode: ref pattern10_0,
                                        args: ref pattern10_1,
                                    } => {
                                        if let &Opcode::Ishl = pattern10_0 {
                                            let (pattern12_0, pattern12_1) =
                                                C::unpack_value_array_2(ctx, pattern10_1);
                                            if let Some(pattern13_0) = C::def_inst(ctx, pattern12_1)
                                            {
                                                let pattern14_0 = C::inst_data(ctx, pattern13_0);
                                                if let &InstructionData::UnaryImm {
                                                    opcode: ref pattern15_0,
                                                    imm: pattern15_1,
                                                } = &pattern14_0
                                                {
                                                    if let &Opcode::Iconst = pattern15_0 {
                                                        let closure17 = || {
                                                            return Some(pattern3_0);
                                                        };
                                                        if let Some(pattern17_0) = closure17() {
                                                            if let Some(pattern18_0) =
                                                                C::lshl_from_imm64(
                                                                    ctx,
                                                                    pattern15_1,
                                                                    pattern17_0,
                                                                )
                                                            {
                                                                // Rule at src/isa/aarch64/lower.isle line 120.
                                                                let expr0_0 =
                                                                    C::put_in_reg(ctx, pattern7_0);
                                                                let expr1_0 =
                                                                    C::put_in_reg(ctx, pattern12_0);
                                                                let expr2_0 =
                                                                    constructor_sub_shift(
                                                                        ctx,
                                                                        pattern3_0,
                                                                        expr0_0,
                                                                        expr1_0,
                                                                        pattern18_0,
                                                                    )?;
                                                                let expr3_0 =
                                                                    constructor_output_reg(
                                                                        ctx, expr2_0,
                                                                    )?;
                                                                return Some(expr3_0);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    _ => {}
                                }
                            }
                            if let Some(pattern8_0) = C::extended_value_from_value(ctx, pattern7_1)
                            {
                                // Rule at src/isa/aarch64/lower.isle line 115.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_sub_extend(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            // Rule at src/isa/aarch64/lower.isle line 101.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_sub(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Imul => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 179.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = C::zero_reg(ctx);
                            let expr3_0 =
                                constructor_madd(ctx, pattern3_0, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Udiv => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 384.
                            let expr0_0: Type = I64;
                            let expr1_0 = constructor_put_in_reg_zext64(ctx, pattern7_0)?;
                            let expr2_0 = constructor_put_nonzero_in_reg_zext64(ctx, pattern7_1)?;
                            let expr3_0 = constructor_a64_udiv(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Sdiv => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::UnaryImm {
                                    opcode: ref pattern10_0,
                                    imm: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Iconst = pattern10_0 {
                                        if let Some(pattern12_0) =
                                            C::safe_divisor_from_imm64(ctx, pattern10_1)
                                        {
                                            // Rule at src/isa/aarch64/lower.isle line 430.
                                            let expr0_0: Type = I64;
                                            let expr1_0 =
                                                constructor_put_in_reg_sext64(ctx, pattern7_0)?;
                                            let expr2_0 =
                                                constructor_imm(ctx, pattern3_0, pattern12_0)?;
                                            let expr3_0 = constructor_a64_sdiv(
                                                ctx, expr0_0, expr1_0, expr2_0,
                                            )?;
                                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                            return Some(expr4_0);
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/aarch64/lower.isle line 417.
                            let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_nonzero_in_reg_sext64(ctx, pattern7_1)?;
                            let expr2_0 = constructor_trap_if_div_overflow(
                                ctx, pattern3_0, expr0_0, expr1_0,
                            )?;
                            let expr3_0: Type = I64;
                            let expr4_0 = constructor_a64_sdiv(ctx, expr3_0, expr2_0, expr1_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        &Opcode::Urem => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 458.
                            let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_nonzero_in_reg_zext64(ctx, pattern7_1)?;
                            let expr2_0: Type = I64;
                            let expr3_0 = constructor_a64_udiv(ctx, expr2_0, expr0_0, expr1_0)?;
                            let expr4_0 = constructor_msub64(ctx, expr3_0, expr1_0, expr0_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        &Opcode::Srem => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 465.
                            let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_nonzero_in_reg_sext64(ctx, pattern7_1)?;
                            let expr2_0: Type = I64;
                            let expr3_0 = constructor_a64_sdiv(ctx, expr2_0, expr0_0, expr1_0)?;
                            let expr4_0 = constructor_msub64(ctx, expr3_0, expr1_0, expr0_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ineg => {
                            // Rule at src/isa/aarch64/lower.isle line 169.
                            let expr0_0 = C::zero_reg(ctx);
                            let expr1_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr2_0 = constructor_sub(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bnot => {
                            if let Some(pattern7_0) = C::def_inst(ctx, pattern5_1) {
                                let pattern8_0 = C::inst_data(ctx, pattern7_0);
                                if let &InstructionData::Binary {
                                    opcode: ref pattern9_0,
                                    args: ref pattern9_1,
                                } = &pattern8_0
                                {
                                    if let &Opcode::Ishl = pattern9_0 {
                                        let (pattern11_0, pattern11_1) =
                                            C::unpack_value_array_2(ctx, pattern9_1);
                                        if let Some(pattern12_0) = C::def_inst(ctx, pattern11_1) {
                                            let pattern13_0 = C::inst_data(ctx, pattern12_0);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref pattern14_0,
                                                imm: pattern14_1,
                                            } = &pattern13_0
                                            {
                                                if let &Opcode::Iconst = pattern14_0 {
                                                    let closure16 = || {
                                                        return Some(pattern3_0);
                                                    };
                                                    if let Some(pattern16_0) = closure16() {
                                                        if let Some(pattern17_0) =
                                                            C::lshl_from_imm64(
                                                                ctx,
                                                                pattern14_1,
                                                                pattern16_0,
                                                            )
                                                        {
                                                            // Rule at src/isa/aarch64/lower.isle line 564.
                                                            let expr0_0 = C::zero_reg(ctx);
                                                            let expr1_0 =
                                                                C::put_in_reg(ctx, pattern11_0);
                                                            let expr2_0 =
                                                                constructor_orr_not_shift(
                                                                    ctx,
                                                                    pattern3_0,
                                                                    expr0_0,
                                                                    expr1_0,
                                                                    pattern17_0,
                                                                )?;
                                                            let expr3_0 = constructor_output_reg(
                                                                ctx, expr2_0,
                                                            )?;
                                                            return Some(expr3_0);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/aarch64/lower.isle line 559.
                            let expr0_0 = C::zero_reg(ctx);
                            let expr1_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr2_0 = constructor_orr_not(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Uextend => {
                            if let Some(pattern7_0) = C::def_inst(ctx, pattern5_1) {
                                let pattern8_0 = C::inst_data(ctx, pattern7_0);
                                if let &InstructionData::BinaryImm8 {
                                    opcode: ref pattern9_0,
                                    arg: pattern9_1,
                                    imm: pattern9_2,
                                } = &pattern8_0
                                {
                                    if let &Opcode::Extractlane = pattern9_0 {
                                        let pattern11_0 = C::value_type(ctx, pattern9_1);
                                        let pattern12_0 = C::u8_from_uimm8(ctx, pattern9_2);
                                        // Rule at src/isa/aarch64/lower.isle line 481.
                                        let expr0_0 = C::put_in_reg(ctx, pattern9_1);
                                        let expr1_0 = constructor_vector_size(ctx, pattern11_0)?;
                                        let expr2_0 = constructor_mov_from_vec(
                                            ctx,
                                            expr0_0,
                                            pattern12_0,
                                            &expr1_0,
                                        )?;
                                        let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                                        return Some(expr3_0);
                                    }
                                }
                            }
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::sinkable_atomic_load(ctx, pattern5_1) {
                                // Rule at src/isa/aarch64/lower.isle line 488.
                                let expr0_0 = C::sink_atomic_load(ctx, &pattern8_0);
                                let expr1_0 = constructor_load_acquire(ctx, pattern7_0, expr0_0)?;
                                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            // Rule at src/isa/aarch64/lower.isle line 476.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0: bool = false;
                            let expr2_0 = C::ty_bits(ctx, pattern7_0);
                            let expr3_0 = C::ty_bits(ctx, pattern3_0);
                            let expr4_0 =
                                constructor_extend(ctx, expr0_0, expr1_0, expr2_0, expr3_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        &Opcode::Sextend => {
                            if let Some(pattern7_0) = C::def_inst(ctx, pattern5_1) {
                                let pattern8_0 = C::inst_data(ctx, pattern7_0);
                                if let &InstructionData::BinaryImm8 {
                                    opcode: ref pattern9_0,
                                    arg: pattern9_1,
                                    imm: pattern9_2,
                                } = &pattern8_0
                                {
                                    if let &Opcode::Extractlane = pattern9_0 {
                                        let pattern11_0 = C::value_type(ctx, pattern9_1);
                                        let pattern12_0 = C::u8_from_uimm8(ctx, pattern9_2);
                                        // Rule at src/isa/aarch64/lower.isle line 513.
                                        let expr0_0 = C::put_in_reg(ctx, pattern9_1);
                                        let expr1_0 = constructor_vector_size(ctx, pattern11_0)?;
                                        let expr2_0 = constructor_size_from_ty(ctx, pattern3_0)?;
                                        let expr3_0 = constructor_mov_from_vec_signed(
                                            ctx,
                                            expr0_0,
                                            pattern12_0,
                                            &expr1_0,
                                            &expr2_0,
                                        )?;
                                        let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                                        return Some(expr4_0);
                                    }
                                }
                            }
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 508.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0: bool = true;
                            let expr2_0 = C::ty_bits(ctx, pattern7_0);
                            let expr3_0 = C::ty_bits(ctx, pattern3_0);
                            let expr4_0 =
                                constructor_extend(ctx, expr0_0, expr1_0, expr2_0, expr3_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::ty_vec128(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::UaddSat => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 148.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr3_0 = constructor_uqadd(ctx, expr0_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::SaddSat => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 153.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr3_0 = constructor_sqadd(ctx, expr0_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::UsubSat => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 158.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr3_0 = constructor_uqsub(ctx, expr0_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::SsubSat => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 163.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr3_0 = constructor_sqsub(ctx, expr0_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 591.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr3_0 = constructor_and_vec(ctx, expr0_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 604.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr3_0 = constructor_orr_vec(ctx, expr0_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 617.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr3_0 = constructor_eor_vec(ctx, expr0_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::BandNot => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 630.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr3_0 = constructor_bic_vec(ctx, expr0_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 694.
                            let expr0_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_vec_dup(ctx, expr1_0, &expr0_0)?;
                            let expr3_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr4_0 = constructor_sshl(ctx, expr3_0, expr2_0, &expr0_0)?;
                            let expr5_0 = constructor_output_reg(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 752.
                            let expr0_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr1_0: Type = I32;
                            let expr2_0 = C::zero_reg(ctx);
                            let expr3_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr4_0 = constructor_sub(ctx, expr1_0, expr2_0, expr3_0)?;
                            let expr5_0 = constructor_vec_dup(ctx, expr4_0, &expr0_0)?;
                            let expr6_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr7_0 = constructor_ushl(ctx, expr6_0, expr5_0, &expr0_0)?;
                            let expr8_0 = constructor_output_reg(ctx, expr7_0)?;
                            return Some(expr8_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/aarch64/lower.isle line 801.
                            let expr0_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr1_0: Type = I32;
                            let expr2_0 = C::zero_reg(ctx);
                            let expr3_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr4_0 = constructor_sub(ctx, expr1_0, expr2_0, expr3_0)?;
                            let expr5_0 = constructor_vec_dup(ctx, expr4_0, &expr0_0)?;
                            let expr6_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr7_0 = constructor_sshl(ctx, expr6_0, expr5_0, &expr0_0)?;
                            let expr8_0 = constructor_output_reg(ctx, expr7_0)?;
                            return Some(expr8_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ineg => {
                            // Rule at src/isa/aarch64/lower.isle line 173.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr2_0 = constructor_neg(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bnot => {
                            // Rule at src/isa/aarch64/lower.isle line 578.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_vector_size(ctx, pattern3_0)?;
                            let expr2_0 = constructor_not(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_reg(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
            if let Some(()) = C::not_i64x2(ctx, pattern3_0) {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Binary {
                    opcode: ref pattern6_0,
                    args: ref pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Imul = pattern6_0 {
                        let (pattern8_0, pattern8_1) = C::unpack_value_array_2(ctx, pattern6_1);
                        // Rule at src/isa/aarch64/lower.isle line 211.
                        let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                        let expr2_0 = constructor_vector_size(ctx, pattern3_0)?;
                        let expr3_0 = constructor_mul(ctx, expr0_0, expr1_0, &expr2_0)?;
                        let expr4_0 = constructor_output_reg(ctx, expr3_0)?;
                        return Some(expr4_0);
                    }
                }
            }
        }
    }
    return None;
}

// Generated as internal constructor for term put_nonzero_in_reg_zext64.
pub fn constructor_put_nonzero_in_reg_zext64<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::def_inst(ctx, pattern0_0) {
        let pattern3_0 = C::inst_data(ctx, pattern2_0);
        if let &InstructionData::UnaryImm {
            opcode: ref pattern4_0,
            imm: pattern4_1,
        } = &pattern3_0
        {
            if let &Opcode::Iconst = pattern4_0 {
                if let Some(pattern6_0) = C::nonzero_u64_from_imm64(ctx, pattern4_1) {
                    // Rule at src/isa/aarch64/lower.isle line 394.
                    let expr0_0 = constructor_imm(ctx, pattern1_0, pattern6_0)?;
                    return Some(expr0_0);
                }
            }
        }
    }
    // Rule at src/isa/aarch64/lower.isle line 389.
    let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern0_0)?;
    let expr1_0 = constructor_trap_if_zero_divisor(ctx, expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term put_nonzero_in_reg_sext64.
pub fn constructor_put_nonzero_in_reg_sext64<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::def_inst(ctx, pattern0_0) {
        let pattern3_0 = C::inst_data(ctx, pattern2_0);
        if let &InstructionData::UnaryImm {
            opcode: ref pattern4_0,
            imm: pattern4_1,
        } = &pattern3_0
        {
            if let &Opcode::Iconst = pattern4_0 {
                if let Some(pattern6_0) = C::nonzero_u64_from_imm64(ctx, pattern4_1) {
                    // Rule at src/isa/aarch64/lower.isle line 440.
                    let expr0_0 = constructor_imm(ctx, pattern1_0, pattern6_0)?;
                    return Some(expr0_0);
                }
            }
        }
    }
    // Rule at src/isa/aarch64/lower.isle line 435.
    let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern0_0)?;
    let expr1_0 = constructor_trap_if_zero_divisor(ctx, expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term lower_shl128.
pub fn constructor_lower_shl128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: Reg,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/lower.isle line 677.
    let expr0_0: usize = 0;
    let expr1_0 = C::value_regs_get(ctx, pattern0_0, expr0_0);
    let expr2_0: usize = 1;
    let expr3_0 = C::value_regs_get(ctx, pattern0_0, expr2_0);
    let expr4_0: Type = I64;
    let expr5_0 = constructor_lsl(ctx, expr4_0, expr1_0, pattern1_0)?;
    let expr6_0: Type = I64;
    let expr7_0 = constructor_lsl(ctx, expr6_0, expr3_0, pattern1_0)?;
    let expr8_0: Type = I32;
    let expr9_0 = C::zero_reg(ctx);
    let expr10_0 = constructor_orr_not(ctx, expr8_0, expr9_0, pattern1_0)?;
    let expr11_0: Type = I64;
    let expr12_0: Type = I64;
    let expr13_0: u8 = 1;
    let expr14_0 = C::imm_shift_from_u8(ctx, expr13_0);
    let expr15_0 = constructor_lsr_imm(ctx, expr12_0, expr1_0, expr14_0)?;
    let expr16_0 = constructor_lsr(ctx, expr11_0, expr15_0, expr10_0)?;
    let expr17_0: Type = I64;
    let expr18_0 = constructor_orr(ctx, expr17_0, expr7_0, expr16_0)?;
    let expr19_0: Type = I64;
    let expr20_0: Type = I64;
    let expr21_0: u64 = 64;
    let expr22_0 = C::u64_into_imm_logic(ctx, expr20_0, expr21_0);
    let expr23_0 = constructor_tst_imm(ctx, expr19_0, pattern1_0, expr22_0)?;
    let expr24_0 = Cond::Ne;
    let expr25_0 = C::zero_reg(ctx);
    let expr26_0 = constructor_csel(ctx, &expr24_0, expr25_0, expr5_0)?;
    let expr27_0 = Cond::Ne;
    let expr28_0 = constructor_csel(ctx, &expr27_0, expr5_0, expr18_0)?;
    let expr29_0 = constructor_consumes_flags_concat(ctx, &expr26_0, &expr28_0)?;
    let expr30_0 = constructor_with_flags(ctx, &expr23_0, &expr29_0)?;
    return Some(expr30_0);
}

// Generated as internal constructor for term do_shift.
pub fn constructor_do_shift<C: Context>(
    ctx: &mut C,
    arg0: &ALUOp,
    arg1: Type,
    arg2: Reg,
    arg3: Value,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    if let Some(pattern4_0) = C::def_inst(ctx, pattern3_0) {
        let pattern5_0 = C::inst_data(ctx, pattern4_0);
        if let &InstructionData::UnaryImm {
            opcode: ref pattern6_0,
            imm: pattern6_1,
        } = &pattern5_0
        {
            if let &Opcode::Iconst = pattern6_0 {
                let closure8 = || {
                    return Some(pattern1_0);
                };
                if let Some(pattern8_0) = closure8() {
                    if let Some(pattern9_0) = C::imm_shift_from_imm64(ctx, pattern6_1, pattern8_0) {
                        // Rule at src/isa/aarch64/lower.isle line 734.
                        let expr0_0 = constructor_alu_rr_imm_shift(
                            ctx, pattern0_0, pattern1_0, pattern2_0, pattern9_0,
                        )?;
                        return Some(expr0_0);
                    }
                }
            }
        }
    }
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I32 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/aarch64/lower.isle line 725.
        let expr0_0: Type = I32;
        let expr1_0 = C::put_in_regs(ctx, pattern4_0);
        let expr2_0: usize = 0;
        let expr3_0 = C::value_regs_get(ctx, expr1_0, expr2_0);
        let expr4_0 = constructor_alu_rrr(ctx, pattern0_0, expr0_0, pattern3_0, expr3_0)?;
        return Some(expr4_0);
    }
    if pattern1_0 == I64 {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/aarch64/lower.isle line 726.
        let expr0_0: Type = I64;
        let expr1_0 = C::put_in_regs(ctx, pattern4_0);
        let expr2_0: usize = 0;
        let expr3_0 = C::value_regs_get(ctx, expr1_0, expr2_0);
        let expr4_0 = constructor_alu_rrr(ctx, pattern0_0, expr0_0, pattern3_0, expr3_0)?;
        return Some(expr4_0);
    }
    if let Some(pattern2_0) = C::fits_in_16(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/aarch64/lower.isle line 716.
        let expr0_0 = C::put_in_regs(ctx, pattern4_0);
        let expr1_0: usize = 0;
        let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
        let expr3_0: Type = I32;
        let expr4_0 = C::shift_mask(ctx, pattern2_0);
        let expr5_0 = constructor_and_imm(ctx, expr3_0, expr2_0, expr4_0)?;
        let expr6_0: Type = I32;
        let expr7_0 = constructor_alu_rrr(ctx, pattern0_0, expr6_0, pattern3_0, expr5_0)?;
        return Some(expr7_0);
    }
    return None;
}

// Generated as internal constructor for term lower_ushr128.
pub fn constructor_lower_ushr128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: Reg,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/lower.isle line 767.
    let expr0_0: usize = 0;
    let expr1_0 = C::value_regs_get(ctx, pattern0_0, expr0_0);
    let expr2_0: usize = 1;
    let expr3_0 = C::value_regs_get(ctx, pattern0_0, expr2_0);
    let expr4_0: Type = I64;
    let expr5_0 = constructor_lsr(ctx, expr4_0, expr1_0, pattern1_0)?;
    let expr6_0: Type = I64;
    let expr7_0 = constructor_lsr(ctx, expr6_0, expr3_0, pattern1_0)?;
    let expr8_0: Type = I32;
    let expr9_0 = C::zero_reg(ctx);
    let expr10_0 = constructor_orr_not(ctx, expr8_0, expr9_0, pattern1_0)?;
    let expr11_0: Type = I64;
    let expr12_0: Type = I64;
    let expr13_0: u8 = 1;
    let expr14_0 = C::imm_shift_from_u8(ctx, expr13_0);
    let expr15_0 = constructor_lsl_imm(ctx, expr12_0, expr3_0, expr14_0)?;
    let expr16_0 = constructor_lsl(ctx, expr11_0, expr15_0, expr10_0)?;
    let expr17_0: Type = I64;
    let expr18_0 = constructor_orr(ctx, expr17_0, expr5_0, expr16_0)?;
    let expr19_0: Type = I64;
    let expr20_0: Type = I64;
    let expr21_0: u64 = 64;
    let expr22_0 = C::u64_into_imm_logic(ctx, expr20_0, expr21_0);
    let expr23_0 = constructor_tst_imm(ctx, expr19_0, pattern1_0, expr22_0)?;
    let expr24_0 = Cond::Ne;
    let expr25_0 = constructor_csel(ctx, &expr24_0, expr7_0, expr18_0)?;
    let expr26_0 = Cond::Ne;
    let expr27_0 = C::zero_reg(ctx);
    let expr28_0 = constructor_csel(ctx, &expr26_0, expr27_0, expr7_0)?;
    let expr29_0 = constructor_consumes_flags_concat(ctx, &expr25_0, &expr28_0)?;
    let expr30_0 = constructor_with_flags(ctx, &expr23_0, &expr29_0)?;
    return Some(expr30_0);
}

// Generated as internal constructor for term lower_sshr128.
pub fn constructor_lower_sshr128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: Reg,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/aarch64/lower.isle line 817.
    let expr0_0: usize = 0;
    let expr1_0 = C::value_regs_get(ctx, pattern0_0, expr0_0);
    let expr2_0: usize = 1;
    let expr3_0 = C::value_regs_get(ctx, pattern0_0, expr2_0);
    let expr4_0: Type = I64;
    let expr5_0 = constructor_lsr(ctx, expr4_0, expr1_0, pattern1_0)?;
    let expr6_0: Type = I64;
    let expr7_0 = constructor_asr(ctx, expr6_0, expr3_0, pattern1_0)?;
    let expr8_0: Type = I32;
    let expr9_0 = C::zero_reg(ctx);
    let expr10_0 = constructor_orr_not(ctx, expr8_0, expr9_0, pattern1_0)?;
    let expr11_0: Type = I64;
    let expr12_0: Type = I64;
    let expr13_0: u8 = 1;
    let expr14_0 = C::imm_shift_from_u8(ctx, expr13_0);
    let expr15_0 = constructor_lsl_imm(ctx, expr12_0, expr3_0, expr14_0)?;
    let expr16_0 = constructor_lsl(ctx, expr11_0, expr15_0, expr10_0)?;
    let expr17_0: Type = I64;
    let expr18_0: u8 = 63;
    let expr19_0 = C::imm_shift_from_u8(ctx, expr18_0);
    let expr20_0 = constructor_asr_imm(ctx, expr17_0, expr3_0, expr19_0)?;
    let expr21_0: Type = I64;
    let expr22_0 = constructor_orr(ctx, expr21_0, expr5_0, expr16_0)?;
    let expr23_0: Type = I64;
    let expr24_0: Type = I64;
    let expr25_0: u64 = 64;
    let expr26_0 = C::u64_into_imm_logic(ctx, expr24_0, expr25_0);
    let expr27_0 = constructor_tst_imm(ctx, expr23_0, pattern1_0, expr26_0)?;
    let expr28_0 = Cond::Ne;
    let expr29_0 = constructor_csel(ctx, &expr28_0, expr7_0, expr22_0)?;
    let expr30_0 = Cond::Ne;
    let expr31_0 = constructor_csel(ctx, &expr30_0, expr20_0, expr7_0)?;
    let expr32_0 = constructor_consumes_flags_concat(ctx, &expr29_0, &expr31_0)?;
    let expr33_0 = constructor_with_flags(ctx, &expr27_0, &expr32_0)?;
    return Some(expr33_0);
}

// Generated as internal constructor for term small_rotr.
pub fn constructor_small_rotr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/lower.isle line 927.
    let expr0_0: Type = I32;
    let expr1_0 = C::rotr_mask(ctx, pattern0_0);
    let expr2_0 = constructor_and_imm(ctx, expr0_0, pattern2_0, expr1_0)?;
    let expr3_0: Type = I32;
    let expr4_0 = C::ty_bits(ctx, pattern0_0);
    let expr5_0 = C::u8_into_imm12(ctx, expr4_0);
    let expr6_0 = constructor_sub_imm(ctx, expr3_0, expr2_0, expr5_0)?;
    let expr7_0: Type = I32;
    let expr8_0 = C::zero_reg(ctx);
    let expr9_0 = constructor_sub(ctx, expr7_0, expr8_0, expr6_0)?;
    let expr10_0: Type = I32;
    let expr11_0 = constructor_lsr(ctx, expr10_0, pattern1_0, expr2_0)?;
    let expr12_0: Type = I32;
    let expr13_0 = constructor_lsl(ctx, expr12_0, pattern1_0, expr9_0)?;
    let expr14_0: Type = I32;
    let expr15_0 = constructor_orr(ctx, expr14_0, expr13_0, expr11_0)?;
    return Some(expr15_0);
}

// Generated as internal constructor for term small_rotr_imm.
pub fn constructor_small_rotr_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: ImmShift,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/aarch64/lower.isle line 948.
    let expr0_0: Type = I32;
    let expr1_0 = constructor_lsr_imm(ctx, expr0_0, pattern1_0, pattern2_0)?;
    let expr2_0: Type = I32;
    let expr3_0 = C::rotr_opposite_amount(ctx, pattern0_0, pattern2_0);
    let expr4_0 = constructor_lsl_imm(ctx, expr2_0, pattern1_0, expr3_0)?;
    let expr5_0: Type = I32;
    let expr6_0 = constructor_orr(ctx, expr5_0, expr4_0, expr1_0)?;
    return Some(expr6_0);
}

// Generated as internal constructor for term lower_clz128.
pub fn constructor_lower_clz128<C: Context>(ctx: &mut C, arg0: ValueRegs) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    // Rule at src/isa/aarch64/lower.isle line 1013.
    let expr0_0: Type = I64;
    let expr1_0: usize = 1;
    let expr2_0 = C::value_regs_get(ctx, pattern0_0, expr1_0);
    let expr3_0 = constructor_a64_clz(ctx, expr0_0, expr2_0)?;
    let expr4_0: Type = I64;
    let expr5_0: usize = 0;
    let expr6_0 = C::value_regs_get(ctx, pattern0_0, expr5_0);
    let expr7_0 = constructor_a64_clz(ctx, expr4_0, expr6_0)?;
    let expr8_0: Type = I64;
    let expr9_0: u8 = 6;
    let expr10_0 = C::imm_shift_from_u8(ctx, expr9_0);
    let expr11_0 = constructor_lsr_imm(ctx, expr8_0, expr3_0, expr10_0)?;
    let expr12_0 = constructor_madd64(ctx, expr7_0, expr11_0, expr3_0)?;
    let expr13_0: Type = I64;
    let expr14_0: u64 = 0;
    let expr15_0 = constructor_imm(ctx, expr13_0, expr14_0)?;
    let expr16_0 = C::value_regs(ctx, expr12_0, expr15_0);
    return Some(expr16_0);
}
