// GENERATED BY ISLE. DO NOT EDIT!
//
// Generated automatically from the instruction-selection DSL code in:
// - src/clif.isle
// - src/prelude.isle
// - src/isa/s390x/inst.isle
// - src/isa/s390x/lower.isle

#![allow(dead_code, unreachable_code, unreachable_patterns)]
#![allow(unused_imports, unused_variables, non_snake_case)]
#![allow(irrefutable_let_patterns)]

use super::*; // Pulls in all external types.

/// Context during lowering: an implementation of this trait
/// must be provided with all external constructors and extractors.
/// A mutable borrow is passed along through all lowering logic.
pub trait Context {
    fn unpack_value_array_2(&mut self, arg0: &ValueArray2) -> (Value, Value);
    fn pack_value_array_2(&mut self, arg0: Value, arg1: Value) -> ValueArray2;
    fn unpack_value_array_3(&mut self, arg0: &ValueArray3) -> (Value, Value, Value);
    fn pack_value_array_3(&mut self, arg0: Value, arg1: Value, arg2: Value) -> ValueArray3;
    fn u32_add(&mut self, arg0: u32, arg1: u32) -> u32;
    fn u8_and(&mut self, arg0: u8, arg1: u8) -> u8;
    fn value_reg(&mut self, arg0: Reg) -> ValueRegs;
    fn value_regs(&mut self, arg0: Reg, arg1: Reg) -> ValueRegs;
    fn value_regs_invalid(&mut self) -> ValueRegs;
    fn temp_writable_reg(&mut self, arg0: Type) -> WritableReg;
    fn invalid_reg(&mut self) -> Reg;
    fn put_in_reg(&mut self, arg0: Value) -> Reg;
    fn put_in_regs(&mut self, arg0: Value) -> ValueRegs;
    fn value_regs_get(&mut self, arg0: ValueRegs, arg1: usize) -> Reg;
    fn u8_as_u64(&mut self, arg0: u8) -> u64;
    fn u16_as_u64(&mut self, arg0: u16) -> u64;
    fn u32_as_u64(&mut self, arg0: u32) -> u64;
    fn ty_bits(&mut self, arg0: Type) -> u8;
    fn ty_bits_u16(&mut self, arg0: Type) -> u16;
    fn ty_bytes(&mut self, arg0: Type) -> u16;
    fn lane_type(&mut self, arg0: Type) -> Type;
    fn fits_in_16(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_32_or_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_8_or_16(&mut self, arg0: Type) -> Option<Type>;
    fn vec128(&mut self, arg0: Type) -> Option<Type>;
    fn not_i64x2(&mut self, arg0: Type) -> Option<()>;
    fn value_list_slice(&mut self, arg0: ValueList) -> ValueSlice;
    fn unwrap_head_value_list_1(&mut self, arg0: ValueList) -> (Value, ValueSlice);
    fn unwrap_head_value_list_2(&mut self, arg0: ValueList) -> (Value, Value, ValueSlice);
    fn writable_reg_to_reg(&mut self, arg0: WritableReg) -> Reg;
    fn u8_from_uimm8(&mut self, arg0: Uimm8) -> u8;
    fn u64_from_imm64(&mut self, arg0: Imm64) -> u64;
    fn nonzero_u64_from_imm64(&mut self, arg0: Imm64) -> Option<u64>;
    fn u64_from_ieee32(&mut self, arg0: Ieee32) -> u64;
    fn u64_from_ieee64(&mut self, arg0: Ieee64) -> u64;
    fn inst_results(&mut self, arg0: Inst) -> ValueSlice;
    fn first_result(&mut self, arg0: Inst) -> Option<Value>;
    fn inst_data(&mut self, arg0: Inst) -> InstructionData;
    fn value_type(&mut self, arg0: Value) -> Type;
    fn multi_lane(&mut self, arg0: Type) -> Option<(u8, u16)>;
    fn def_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn emit(&mut self, arg0: &MInst) -> Unit;
    fn emit_safepoint(&mut self, arg0: &MInst) -> Unit;
    fn trap_code_division_by_zero(&mut self) -> TrapCode;
    fn trap_code_integer_overflow(&mut self) -> TrapCode;
    fn trap_code_bad_conversion_to_integer(&mut self) -> TrapCode;
    fn avoid_div_traps(&mut self, arg0: Type) -> Option<()>;
    fn mie2_enabled(&mut self, arg0: Type) -> Option<()>;
    fn mie2_disabled(&mut self, arg0: Type) -> Option<()>;
    fn vxrs_ext2_enabled(&mut self, arg0: Type) -> Option<()>;
    fn vxrs_ext2_disabled(&mut self, arg0: Type) -> Option<()>;
    fn allow_div_traps(&mut self, arg0: Type) -> Option<()>;
    fn symbol_value_data(&mut self, arg0: Inst) -> Option<(BoxExternalName, RelocDistance, i64)>;
    fn call_target_data(&mut self, arg0: Inst) -> Option<(BoxExternalName, RelocDistance)>;
    fn writable_gpr(&mut self, arg0: u8) -> WritableReg;
    fn zero_reg(&mut self) -> Reg;
    fn gpr32_ty(&mut self, arg0: Type) -> Option<Type>;
    fn gpr64_ty(&mut self, arg0: Type) -> Option<Type>;
    fn uimm32shifted(&mut self, arg0: u32, arg1: u8) -> UImm32Shifted;
    fn uimm16shifted(&mut self, arg0: u16, arg1: u8) -> UImm16Shifted;
    fn i64_nonequal(&mut self, arg0: i64, arg1: i64) -> Option<i64>;
    fn u8_as_u16(&mut self, arg0: u8) -> u16;
    fn u64_as_u32(&mut self, arg0: u64) -> u32;
    fn u64_as_i16(&mut self, arg0: u64) -> i16;
    fn u64_nonzero_hipart(&mut self, arg0: u64) -> Option<u64>;
    fn u64_nonzero_lopart(&mut self, arg0: u64) -> Option<u64>;
    fn i32_from_u64(&mut self, arg0: u64) -> Option<i32>;
    fn i16_from_u64(&mut self, arg0: u64) -> Option<i16>;
    fn uimm32shifted_from_u64(&mut self, arg0: u64) -> Option<UImm32Shifted>;
    fn uimm16shifted_from_u64(&mut self, arg0: u64) -> Option<UImm16Shifted>;
    fn u64_from_value(&mut self, arg0: Value) -> Option<u64>;
    fn u32_from_value(&mut self, arg0: Value) -> Option<u32>;
    fn u8_from_value(&mut self, arg0: Value) -> Option<u8>;
    fn u64_from_signed_value(&mut self, arg0: Value) -> Option<u64>;
    fn i64_from_value(&mut self, arg0: Value) -> Option<i64>;
    fn i32_from_value(&mut self, arg0: Value) -> Option<i32>;
    fn i16_from_value(&mut self, arg0: Value) -> Option<i16>;
    fn i16_from_swapped_value(&mut self, arg0: Value) -> Option<i16>;
    fn i64_from_negated_value(&mut self, arg0: Value) -> Option<i64>;
    fn i32_from_negated_value(&mut self, arg0: Value) -> Option<i32>;
    fn i16_from_negated_value(&mut self, arg0: Value) -> Option<i16>;
    fn uimm16shifted_from_value(&mut self, arg0: Value) -> Option<UImm16Shifted>;
    fn uimm32shifted_from_value(&mut self, arg0: Value) -> Option<UImm32Shifted>;
    fn uimm16shifted_from_inverted_value(&mut self, arg0: Value) -> Option<UImm16Shifted>;
    fn uimm32shifted_from_inverted_value(&mut self, arg0: Value) -> Option<UImm32Shifted>;
    fn mask_amt_imm(&mut self, arg0: Type, arg1: i64) -> u8;
    fn mask_as_cond(&mut self, arg0: u8) -> Cond;
    fn intcc_as_cond(&mut self, arg0: &IntCC) -> Cond;
    fn floatcc_as_cond(&mut self, arg0: &FloatCC) -> Cond;
    fn invert_cond(&mut self, arg0: &Cond) -> Cond;
    fn signed(&mut self, arg0: &IntCC) -> Option<()>;
    fn unsigned(&mut self, arg0: &IntCC) -> Option<()>;
    fn vec_length_minus1(&mut self, arg0: &VecMachLabel) -> u32;
    fn vec_element(&mut self, arg0: &VecMachLabel, arg1: u8) -> MachLabel;
    fn reloc_distance_near(&mut self, arg0: &RelocDistance) -> Option<()>;
    fn zero_offset(&mut self) -> Offset32;
    fn i64_from_offset(&mut self, arg0: Offset32) -> i64;
    fn littleendian(&mut self, arg0: MemFlags) -> Option<()>;
    fn bigendian(&mut self, arg0: MemFlags) -> Option<()>;
    fn memflags_trusted(&mut self) -> MemFlags;
    fn memarg_reg_plus_reg(&mut self, arg0: Reg, arg1: Reg, arg2: MemFlags) -> MemArg;
    fn memarg_reg_plus_off(&mut self, arg0: Reg, arg1: i64, arg2: MemFlags) -> MemArg;
    fn memarg_symbol(&mut self, arg0: BoxExternalName, arg1: i32, arg2: MemFlags) -> MemArg;
    fn memarg_symbol_offset_sum(&mut self, arg0: i64, arg1: i64) -> Option<i32>;
    fn abi_stackslot_addr(&mut self, arg0: WritableReg, arg1: StackSlot, arg2: Offset32) -> MInst;
    fn sinkable_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn sink_inst(&mut self, arg0: Inst) -> Unit;
}

/// Internal type SideEffectNoResult: defined at src/prelude.isle line 307.
#[derive(Clone, Debug)]
pub enum SideEffectNoResult {
    Inst { inst: MInst },
}

/// Internal type ProducesFlags: defined at src/prelude.isle line 326.
#[derive(Clone, Debug)]
pub enum ProducesFlags {
    ProducesFlags { inst: MInst, result: Reg },
}

/// Internal type ConsumesFlags: defined at src/prelude.isle line 329.
#[derive(Clone, Debug)]
pub enum ConsumesFlags {
    ConsumesFlags { inst: MInst, result: Reg },
}

/// Internal type MInst: defined at src/isa/s390x/inst.isle line 2.
#[derive(Clone, Debug)]
pub enum MInst {
    Nop0,
    Nop2,
    AluRRR {
        alu_op: ALUOp,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
    },
    AluRRSImm16 {
        alu_op: ALUOp,
        rd: WritableReg,
        rn: Reg,
        imm: i16,
    },
    AluRR {
        alu_op: ALUOp,
        rd: WritableReg,
        rm: Reg,
    },
    AluRX {
        alu_op: ALUOp,
        rd: WritableReg,
        mem: MemArg,
    },
    AluRSImm16 {
        alu_op: ALUOp,
        rd: WritableReg,
        imm: i16,
    },
    AluRSImm32 {
        alu_op: ALUOp,
        rd: WritableReg,
        imm: i32,
    },
    AluRUImm32 {
        alu_op: ALUOp,
        rd: WritableReg,
        imm: u32,
    },
    AluRUImm16Shifted {
        alu_op: ALUOp,
        rd: WritableReg,
        imm: UImm16Shifted,
    },
    AluRUImm32Shifted {
        alu_op: ALUOp,
        rd: WritableReg,
        imm: UImm32Shifted,
    },
    SMulWide {
        rn: Reg,
        rm: Reg,
    },
    UMulWide {
        rn: Reg,
    },
    SDivMod32 {
        rn: Reg,
    },
    SDivMod64 {
        rn: Reg,
    },
    UDivMod32 {
        rn: Reg,
    },
    UDivMod64 {
        rn: Reg,
    },
    Flogr {
        rn: Reg,
    },
    ShiftRR {
        shift_op: ShiftOp,
        rd: WritableReg,
        rn: Reg,
        shift_imm: u8,
        shift_reg: Reg,
    },
    UnaryRR {
        op: UnaryOp,
        rd: WritableReg,
        rn: Reg,
    },
    CmpRR {
        op: CmpOp,
        rn: Reg,
        rm: Reg,
    },
    CmpRX {
        op: CmpOp,
        rn: Reg,
        mem: MemArg,
    },
    CmpRSImm16 {
        op: CmpOp,
        rn: Reg,
        imm: i16,
    },
    CmpRSImm32 {
        op: CmpOp,
        rn: Reg,
        imm: i32,
    },
    CmpRUImm32 {
        op: CmpOp,
        rn: Reg,
        imm: u32,
    },
    CmpTrapRR {
        op: CmpOp,
        rn: Reg,
        rm: Reg,
        cond: Cond,
        trap_code: TrapCode,
    },
    CmpTrapRSImm16 {
        op: CmpOp,
        rn: Reg,
        imm: i16,
        cond: Cond,
        trap_code: TrapCode,
    },
    CmpTrapRUImm16 {
        op: CmpOp,
        rn: Reg,
        imm: u16,
        cond: Cond,
        trap_code: TrapCode,
    },
    AtomicRmw {
        alu_op: ALUOp,
        rd: WritableReg,
        rn: Reg,
        mem: MemArg,
    },
    AtomicCas32 {
        rd: WritableReg,
        rn: Reg,
        mem: MemArg,
    },
    AtomicCas64 {
        rd: WritableReg,
        rn: Reg,
        mem: MemArg,
    },
    Fence,
    Load32 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load32ZExt8 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load32SExt8 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load32ZExt16 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load32SExt16 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64ZExt8 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64SExt8 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64ZExt16 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64SExt16 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64ZExt32 {
        rd: WritableReg,
        mem: MemArg,
    },
    Load64SExt32 {
        rd: WritableReg,
        mem: MemArg,
    },
    LoadRev16 {
        rd: WritableReg,
        mem: MemArg,
    },
    LoadRev32 {
        rd: WritableReg,
        mem: MemArg,
    },
    LoadRev64 {
        rd: WritableReg,
        mem: MemArg,
    },
    Store8 {
        rd: Reg,
        mem: MemArg,
    },
    Store16 {
        rd: Reg,
        mem: MemArg,
    },
    Store32 {
        rd: Reg,
        mem: MemArg,
    },
    Store64 {
        rd: Reg,
        mem: MemArg,
    },
    StoreImm8 {
        imm: u8,
        mem: MemArg,
    },
    StoreImm16 {
        imm: i16,
        mem: MemArg,
    },
    StoreImm32SExt16 {
        imm: i16,
        mem: MemArg,
    },
    StoreImm64SExt16 {
        imm: i16,
        mem: MemArg,
    },
    StoreRev16 {
        rd: Reg,
        mem: MemArg,
    },
    StoreRev32 {
        rd: Reg,
        mem: MemArg,
    },
    StoreRev64 {
        rd: Reg,
        mem: MemArg,
    },
    LoadMultiple64 {
        rt: WritableReg,
        rt2: WritableReg,
        mem: MemArg,
    },
    StoreMultiple64 {
        rt: Reg,
        rt2: Reg,
        mem: MemArg,
    },
    Mov32 {
        rd: WritableReg,
        rm: Reg,
    },
    Mov64 {
        rd: WritableReg,
        rm: Reg,
    },
    Mov32Imm {
        rd: WritableReg,
        imm: u32,
    },
    Mov32SImm16 {
        rd: WritableReg,
        imm: i16,
    },
    Mov64SImm16 {
        rd: WritableReg,
        imm: i16,
    },
    Mov64SImm32 {
        rd: WritableReg,
        imm: i32,
    },
    Mov64UImm16Shifted {
        rd: WritableReg,
        imm: UImm16Shifted,
    },
    Mov64UImm32Shifted {
        rd: WritableReg,
        imm: UImm32Shifted,
    },
    Insert64UImm16Shifted {
        rd: WritableReg,
        imm: UImm16Shifted,
    },
    Insert64UImm32Shifted {
        rd: WritableReg,
        imm: UImm32Shifted,
    },
    Extend {
        rd: WritableReg,
        rn: Reg,
        signed: bool,
        from_bits: u8,
        to_bits: u8,
    },
    CMov32 {
        rd: WritableReg,
        cond: Cond,
        rm: Reg,
    },
    CMov64 {
        rd: WritableReg,
        cond: Cond,
        rm: Reg,
    },
    CMov32SImm16 {
        rd: WritableReg,
        cond: Cond,
        imm: i16,
    },
    CMov64SImm16 {
        rd: WritableReg,
        cond: Cond,
        imm: i16,
    },
    FpuMove32 {
        rd: WritableReg,
        rn: Reg,
    },
    FpuMove64 {
        rd: WritableReg,
        rn: Reg,
    },
    FpuCMov32 {
        rd: WritableReg,
        cond: Cond,
        rm: Reg,
    },
    FpuCMov64 {
        rd: WritableReg,
        cond: Cond,
        rm: Reg,
    },
    MovToFpr {
        rd: WritableReg,
        rn: Reg,
    },
    MovFromFpr {
        rd: WritableReg,
        rn: Reg,
    },
    FpuRR {
        fpu_op: FPUOp1,
        rd: WritableReg,
        rn: Reg,
    },
    FpuRRR {
        fpu_op: FPUOp2,
        rd: WritableReg,
        rm: Reg,
    },
    FpuRRRR {
        fpu_op: FPUOp3,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
    },
    FpuCopysign {
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
    },
    FpuCmp32 {
        rn: Reg,
        rm: Reg,
    },
    FpuCmp64 {
        rn: Reg,
        rm: Reg,
    },
    FpuLoad32 {
        rd: WritableReg,
        mem: MemArg,
    },
    FpuStore32 {
        rd: Reg,
        mem: MemArg,
    },
    FpuLoad64 {
        rd: WritableReg,
        mem: MemArg,
    },
    FpuStore64 {
        rd: Reg,
        mem: MemArg,
    },
    FpuLoadRev32 {
        rd: WritableReg,
        mem: MemArg,
    },
    FpuStoreRev32 {
        rd: Reg,
        mem: MemArg,
    },
    FpuLoadRev64 {
        rd: WritableReg,
        mem: MemArg,
    },
    FpuStoreRev64 {
        rd: Reg,
        mem: MemArg,
    },
    LoadFpuConst32 {
        rd: WritableReg,
        const_data: u32,
    },
    LoadFpuConst64 {
        rd: WritableReg,
        const_data: u64,
    },
    FpuToInt {
        op: FpuToIntOp,
        rd: WritableReg,
        rn: Reg,
    },
    IntToFpu {
        op: IntToFpuOp,
        rd: WritableReg,
        rn: Reg,
    },
    FpuRound {
        op: FpuRoundMode,
        rd: WritableReg,
        rn: Reg,
    },
    FpuVecRRR {
        fpu_op: FPUOp2,
        rd: WritableReg,
        rn: Reg,
        rm: Reg,
    },
    Call {
        link: WritableReg,
        info: BoxCallInfo,
    },
    CallInd {
        link: WritableReg,
        info: BoxCallIndInfo,
    },
    Ret {
        link: Reg,
    },
    EpiloguePlaceholder,
    Jump {
        dest: MachLabel,
    },
    CondBr {
        taken: MachLabel,
        not_taken: MachLabel,
        cond: Cond,
    },
    TrapIf {
        cond: Cond,
        trap_code: TrapCode,
    },
    OneWayCondBr {
        target: MachLabel,
        cond: Cond,
    },
    IndirectBr {
        rn: Reg,
        targets: VecMachLabel,
    },
    Debugtrap,
    Trap {
        trap_code: TrapCode,
    },
    JTSequence {
        ridx: Reg,
        targets: VecMachLabel,
    },
    LoadExtNameFar {
        rd: WritableReg,
        name: BoxExternalName,
        offset: i64,
    },
    LoadAddr {
        rd: WritableReg,
        mem: MemArg,
    },
    VirtualSPOffsetAdj {
        offset: i64,
    },
    ValueLabelMarker {
        reg: Reg,
        label: ValueLabel,
    },
    Unwind {
        inst: UnwindInst,
    },
}

/// Internal type ALUOp: defined at src/isa/s390x/inst.isle line 684.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum ALUOp {
    Add32,
    Add32Ext16,
    Add64,
    Add64Ext16,
    Add64Ext32,
    AddLogical32,
    AddLogical64,
    AddLogical64Ext32,
    Sub32,
    Sub32Ext16,
    Sub64,
    Sub64Ext16,
    Sub64Ext32,
    SubLogical32,
    SubLogical64,
    SubLogical64Ext32,
    Mul32,
    Mul32Ext16,
    Mul64,
    Mul64Ext16,
    Mul64Ext32,
    And32,
    And64,
    Orr32,
    Orr64,
    Xor32,
    Xor64,
    AndNot32,
    AndNot64,
    OrrNot32,
    OrrNot64,
    XorNot32,
    XorNot64,
}

/// Internal type UnaryOp: defined at src/isa/s390x/inst.isle line 725.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum UnaryOp {
    Abs32,
    Abs64,
    Abs64Ext32,
    Neg32,
    Neg64,
    Neg64Ext32,
    PopcntByte,
    PopcntReg,
}

/// Internal type ShiftOp: defined at src/isa/s390x/inst.isle line 738.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum ShiftOp {
    RotL32,
    RotL64,
    LShL32,
    LShL64,
    LShR32,
    LShR64,
    AShR32,
    AShR64,
}

/// Internal type CmpOp: defined at src/isa/s390x/inst.isle line 751.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum CmpOp {
    CmpS32,
    CmpS32Ext16,
    CmpS64,
    CmpS64Ext16,
    CmpS64Ext32,
    CmpL32,
    CmpL32Ext16,
    CmpL64,
    CmpL64Ext16,
    CmpL64Ext32,
}

/// Internal type FPUOp1: defined at src/isa/s390x/inst.isle line 766.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FPUOp1 {
    Abs32,
    Abs64,
    Neg32,
    Neg64,
    NegAbs32,
    NegAbs64,
    Sqrt32,
    Sqrt64,
    Cvt32To64,
    Cvt64To32,
}

/// Internal type FPUOp2: defined at src/isa/s390x/inst.isle line 781.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FPUOp2 {
    Add32,
    Add64,
    Sub32,
    Sub64,
    Mul32,
    Mul64,
    Div32,
    Div64,
    Max32,
    Max64,
    Min32,
    Min64,
}

/// Internal type FPUOp3: defined at src/isa/s390x/inst.isle line 798.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FPUOp3 {
    MAdd32,
    MAdd64,
    MSub32,
    MSub64,
}

/// Internal type FpuToIntOp: defined at src/isa/s390x/inst.isle line 807.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FpuToIntOp {
    F32ToU32,
    F32ToI32,
    F32ToU64,
    F32ToI64,
    F64ToU32,
    F64ToI32,
    F64ToU64,
    F64ToI64,
}

/// Internal type IntToFpuOp: defined at src/isa/s390x/inst.isle line 820.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum IntToFpuOp {
    U32ToF32,
    I32ToF32,
    U32ToF64,
    I32ToF64,
    U64ToF32,
    I64ToF32,
    U64ToF64,
    I64ToF64,
}

/// Internal type FpuRoundMode: defined at src/isa/s390x/inst.isle line 834.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum FpuRoundMode {
    Minus32,
    Minus64,
    Plus32,
    Plus64,
    Zero32,
    Zero64,
    Nearest32,
    Nearest64,
}

/// Internal type WritableRegPair: defined at src/isa/s390x/inst.isle line 1240.
#[derive(Clone, Debug)]
pub enum WritableRegPair {
    WritableRegPair { hi: WritableReg, lo: WritableReg },
}

/// Internal type RegPair: defined at src/isa/s390x/inst.isle line 1262.
#[derive(Clone, Debug)]
pub enum RegPair {
    RegPair { hi: Reg, lo: Reg },
}

/// Internal type ProducesBool: defined at src/isa/s390x/inst.isle line 2187.
#[derive(Clone, Debug)]
pub enum ProducesBool {
    ProducesBool { producer: ProducesFlags, cond: Cond },
}

// Generated as internal constructor for term temp_reg.
pub fn constructor_temp_reg<C: Context>(ctx: &mut C, arg0: Type) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 73.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term lo_reg.
pub fn constructor_lo_reg<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 108.
    let expr0_0 = C::put_in_regs(ctx, pattern0_0);
    let expr1_0: usize = 0;
    let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term value_regs_none.
pub fn constructor_value_regs_none<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    if let &SideEffectNoResult::Inst {
        inst: ref pattern1_0,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 312.
        let expr0_0 = C::emit(ctx, &pattern1_0);
        let expr1_0 = C::value_regs_invalid(ctx);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term safepoint.
pub fn constructor_safepoint<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    if let &SideEffectNoResult::Inst {
        inst: ref pattern1_0,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 318.
        let expr0_0 = C::emit_safepoint(ctx, &pattern1_0);
        let expr1_0 = C::value_regs_invalid(ctx);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term with_flags.
pub fn constructor_with_flags<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlags {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        if let &ConsumesFlags::ConsumesFlags {
            inst: ref pattern3_0,
            result: pattern3_1,
        } = pattern2_0
        {
            // Rule at src/prelude.isle line 339.
            let expr0_0 = C::emit(ctx, &pattern1_0);
            let expr1_0 = C::emit(ctx, &pattern3_0);
            let expr2_0 = C::value_regs(ctx, pattern1_1, pattern3_1);
            return Some(expr2_0);
        }
    }
    return None;
}

// Generated as internal constructor for term with_flags_1.
pub fn constructor_with_flags_1<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlags {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        if let &ConsumesFlags::ConsumesFlags {
            inst: ref pattern3_0,
            result: pattern3_1,
        } = pattern2_0
        {
            // Rule at src/prelude.isle line 347.
            let expr0_0 = C::emit(ctx, &pattern1_0);
            let expr1_0 = C::emit(ctx, &pattern3_0);
            return Some(pattern3_1);
        }
    }
    return None;
}

// Generated as internal constructor for term with_flags_2.
pub fn constructor_with_flags_2<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
    arg2: &ConsumesFlags,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlags {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        if let &ConsumesFlags::ConsumesFlags {
            inst: ref pattern3_0,
            result: pattern3_1,
        } = pattern2_0
        {
            let pattern4_0 = arg2;
            if let &ConsumesFlags::ConsumesFlags {
                inst: ref pattern5_0,
                result: pattern5_1,
            } = pattern4_0
            {
                // Rule at src/prelude.isle line 357.
                let expr0_0 = C::emit(ctx, &pattern1_0);
                let expr1_0 = C::emit(ctx, &pattern5_0);
                let expr2_0 = C::emit(ctx, &pattern3_0);
                let expr3_0 = C::value_regs(ctx, pattern3_1, pattern5_1);
                return Some(expr3_0);
            }
        }
    }
    return None;
}

// Generated as internal constructor for term mask_amt_reg.
pub fn constructor_mask_amt_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 1009.
        let expr0_0: i64 = -1;
        let expr1_0 = C::mask_amt_imm(ctx, pattern1_0, expr0_0);
        let expr2_0 = C::u8_as_u16(ctx, expr1_0);
        let expr3_0: u8 = 0;
        let expr4_0 = C::uimm16shifted(ctx, expr2_0, expr3_0);
        let expr5_0 = constructor_and_uimm16shifted(ctx, pattern1_0, pattern2_0, expr4_0)?;
        return Some(expr5_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 1012.
        return Some(pattern2_0);
    }
    return None;
}

// Generated as internal constructor for term lower_address.
pub fn constructor_lower_address<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Offset32,
) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(pattern2_0) = C::def_inst(ctx, pattern1_0) {
        let pattern3_0 = C::inst_data(ctx, pattern2_0);
        if let &InstructionData::Binary {
            opcode: ref pattern4_0,
            args: ref pattern4_1,
        } = &pattern3_0
        {
            if let &Opcode::Iadd = &pattern4_0 {
                let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, &pattern4_1);
                let pattern7_0 = arg2;
                let pattern8_0 = C::i64_from_offset(ctx, pattern7_0);
                if pattern8_0 == 0 {
                    // Rule at src/isa/s390x/inst.isle line 1104.
                    let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                    let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                    let expr2_0 = C::memarg_reg_plus_reg(ctx, expr0_0, expr1_0, pattern0_0);
                    return Some(expr2_0);
                }
            }
        }
        if let Some((pattern3_0, pattern3_1, pattern3_2)) = C::symbol_value_data(ctx, pattern2_0) {
            if let Some(()) = C::reloc_distance_near(ctx, &pattern3_1) {
                let pattern5_0 = arg2;
                let pattern6_0 = C::i64_from_offset(ctx, pattern5_0);
                let closure7 = || {
                    return Some(pattern3_2);
                };
                if let Some(pattern7_0) = closure7() {
                    if let Some(pattern8_0) =
                        C::memarg_symbol_offset_sum(ctx, pattern6_0, pattern7_0)
                    {
                        // Rule at src/isa/s390x/inst.isle line 1107.
                        let expr0_0 = C::memarg_symbol(ctx, pattern3_0, pattern8_0, pattern0_0);
                        return Some(expr0_0);
                    }
                }
            }
        }
    }
    let pattern2_0 = arg2;
    let pattern3_0 = C::i64_from_offset(ctx, pattern2_0);
    // Rule at src/isa/s390x/inst.isle line 1101.
    let expr0_0 = C::put_in_reg(ctx, pattern1_0);
    let expr1_0 = C::memarg_reg_plus_off(ctx, expr0_0, pattern3_0, pattern0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term stack_addr_impl.
pub fn constructor_stack_addr_impl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: StackSlot,
    arg2: Offset32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1134.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::abi_stackslot_addr(ctx, expr0_0, pattern1_0, pattern2_0);
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term sink_load.
pub fn constructor_sink_load<C: Context>(ctx: &mut C, arg0: Inst) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    if let &InstructionData::Load {
        opcode: ref pattern2_0,
        arg: pattern2_1,
        flags: pattern2_2,
        offset: pattern2_3,
    } = &pattern1_0
    {
        if let &Opcode::Load = &pattern2_0 {
            // Rule at src/isa/s390x/inst.isle line 1204.
            let expr0_0 = C::sink_inst(ctx, pattern0_0);
            let expr1_0 = constructor_lower_address(ctx, pattern2_2, pattern2_1, pattern2_3)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term sink_sload16.
pub fn constructor_sink_sload16<C: Context>(ctx: &mut C, arg0: Inst) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    if let &InstructionData::Load {
        opcode: ref pattern2_0,
        arg: pattern2_1,
        flags: pattern2_2,
        offset: pattern2_3,
    } = &pattern1_0
    {
        if let &Opcode::Sload16 = &pattern2_0 {
            // Rule at src/isa/s390x/inst.isle line 1211.
            let expr0_0 = C::sink_inst(ctx, pattern0_0);
            let expr1_0 = constructor_lower_address(ctx, pattern2_2, pattern2_1, pattern2_3)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term sink_sload32.
pub fn constructor_sink_sload32<C: Context>(ctx: &mut C, arg0: Inst) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    if let &InstructionData::Load {
        opcode: ref pattern2_0,
        arg: pattern2_1,
        flags: pattern2_2,
        offset: pattern2_3,
    } = &pattern1_0
    {
        if let &Opcode::Sload32 = &pattern2_0 {
            // Rule at src/isa/s390x/inst.isle line 1218.
            let expr0_0 = C::sink_inst(ctx, pattern0_0);
            let expr1_0 = constructor_lower_address(ctx, pattern2_2, pattern2_1, pattern2_3)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term sink_uload16.
pub fn constructor_sink_uload16<C: Context>(ctx: &mut C, arg0: Inst) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    if let &InstructionData::Load {
        opcode: ref pattern2_0,
        arg: pattern2_1,
        flags: pattern2_2,
        offset: pattern2_3,
    } = &pattern1_0
    {
        if let &Opcode::Uload16 = &pattern2_0 {
            // Rule at src/isa/s390x/inst.isle line 1225.
            let expr0_0 = C::sink_inst(ctx, pattern0_0);
            let expr1_0 = constructor_lower_address(ctx, pattern2_2, pattern2_1, pattern2_3)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term sink_uload32.
pub fn constructor_sink_uload32<C: Context>(ctx: &mut C, arg0: Inst) -> Option<MemArg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    if let &InstructionData::Load {
        opcode: ref pattern2_0,
        arg: pattern2_1,
        flags: pattern2_2,
        offset: pattern2_3,
    } = &pattern1_0
    {
        if let &Opcode::Uload32 = &pattern2_0 {
            // Rule at src/isa/s390x/inst.isle line 1232.
            let expr0_0 = C::sink_inst(ctx, pattern0_0);
            let expr1_0 = constructor_lower_address(ctx, pattern2_2, pattern2_1, pattern2_3)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term temp_writable_regpair.
pub fn constructor_temp_writable_regpair<C: Context>(ctx: &mut C) -> Option<WritableRegPair> {
    // Rule at src/isa/s390x/inst.isle line 1245.
    let expr0_0: u8 = 0;
    let expr1_0 = C::writable_gpr(ctx, expr0_0);
    let expr2_0: u8 = 1;
    let expr3_0 = C::writable_gpr(ctx, expr2_0);
    let expr4_0 = WritableRegPair::WritableRegPair {
        hi: expr1_0,
        lo: expr3_0,
    };
    return Some(expr4_0);
}

// Generated as internal constructor for term copy_writable_regpair.
pub fn constructor_copy_writable_regpair<C: Context>(
    ctx: &mut C,
    arg0: &RegPair,
) -> Option<WritableRegPair> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1251.
    let expr0_0 = constructor_temp_writable_regpair(ctx)?;
    return Some(expr0_0);
}

// Generated as internal constructor for term writable_regpair_hi.
pub fn constructor_writable_regpair_hi<C: Context>(
    ctx: &mut C,
    arg0: &WritableRegPair,
) -> Option<WritableReg> {
    let pattern0_0 = arg0;
    if let &WritableRegPair::WritableRegPair {
        hi: pattern1_0,
        lo: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1255.
        return Some(pattern1_0);
    }
    return None;
}

// Generated as internal constructor for term writable_regpair_lo.
pub fn constructor_writable_regpair_lo<C: Context>(
    ctx: &mut C,
    arg0: &WritableRegPair,
) -> Option<WritableReg> {
    let pattern0_0 = arg0;
    if let &WritableRegPair::WritableRegPair {
        hi: pattern1_0,
        lo: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1259.
        return Some(pattern1_1);
    }
    return None;
}

// Generated as internal constructor for term writable_regpair_to_regpair.
pub fn constructor_writable_regpair_to_regpair<C: Context>(
    ctx: &mut C,
    arg0: &WritableRegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    if let &WritableRegPair::WritableRegPair {
        hi: pattern1_0,
        lo: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1266.
        let expr0_0 = C::writable_reg_to_reg(ctx, pattern1_0);
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern1_1);
        let expr2_0 = RegPair::RegPair {
            hi: expr0_0,
            lo: expr1_0,
        };
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term uninitialized_regpair.
pub fn constructor_uninitialized_regpair<C: Context>(ctx: &mut C) -> Option<RegPair> {
    // Rule at src/isa/s390x/inst.isle line 1271.
    let expr0_0 = constructor_temp_writable_regpair(ctx)?;
    let expr1_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term regpair_hi.
pub fn constructor_regpair_hi<C: Context>(ctx: &mut C, arg0: &RegPair) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &RegPair::RegPair {
        hi: pattern1_0,
        lo: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1276.
        return Some(pattern1_0);
    }
    return None;
}

// Generated as internal constructor for term regpair_lo.
pub fn constructor_regpair_lo<C: Context>(ctx: &mut C, arg0: &RegPair) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &RegPair::RegPair {
        hi: pattern1_0,
        lo: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1280.
        return Some(pattern1_1);
    }
    return None;
}

// Generated as internal constructor for term alu_rrr.
pub fn constructor_alu_rrr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1287.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::AluRRR {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
        rm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_rrsimm16.
pub fn constructor_alu_rrsimm16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: i16,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1294.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::AluRRSImm16 {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_rr.
pub fn constructor_alu_rr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1301.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRR {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        rm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_rx.
pub fn constructor_alu_rx<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1308.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRX {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        mem: pattern3_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_rsimm16.
pub fn constructor_alu_rsimm16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: i16,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1315.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRSImm16 {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_rsimm32.
pub fn constructor_alu_rsimm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: i32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1322.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRSImm32 {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_ruimm32.
pub fn constructor_alu_ruimm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: u32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1329.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRUImm32 {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_ruimm16shifted.
pub fn constructor_alu_ruimm16shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: UImm16Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1336.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRUImm16Shifted {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term alu_ruimm32shifted.
pub fn constructor_alu_ruimm32shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: UImm32Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1343.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::AluRUImm32Shifted {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        imm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term smul_wide.
pub fn constructor_smul_wide<C: Context>(ctx: &mut C, arg0: Reg, arg1: Reg) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1350.
    let expr0_0 = constructor_temp_writable_regpair(ctx)?;
    let expr1_0 = MInst::SMulWide {
        rn: pattern0_0,
        rm: pattern1_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term umul_wide.
pub fn constructor_umul_wide<C: Context>(ctx: &mut C, arg0: Reg, arg1: Reg) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1357.
    let expr0_0 = constructor_temp_writable_regpair(ctx)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = MInst::Mov64 {
        rd: expr1_0,
        rm: pattern1_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = MInst::UMulWide { rn: pattern0_0 };
    let expr5_0 = C::emit(ctx, &expr4_0);
    let expr6_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr6_0);
}

// Generated as internal constructor for term sdivmod32.
pub fn constructor_sdivmod32<C: Context>(
    ctx: &mut C,
    arg0: &RegPair,
    arg1: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1365.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern0_0)?;
    let expr1_0 = MInst::SDivMod32 { rn: pattern1_0 };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term sdivmod64.
pub fn constructor_sdivmod64<C: Context>(
    ctx: &mut C,
    arg0: &RegPair,
    arg1: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1372.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern0_0)?;
    let expr1_0 = MInst::SDivMod64 { rn: pattern1_0 };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term udivmod32.
pub fn constructor_udivmod32<C: Context>(
    ctx: &mut C,
    arg0: &RegPair,
    arg1: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1379.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern0_0)?;
    let expr1_0 = MInst::UDivMod32 { rn: pattern1_0 };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term udivmod64.
pub fn constructor_udivmod64<C: Context>(
    ctx: &mut C,
    arg0: &RegPair,
    arg1: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1386.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern0_0)?;
    let expr1_0 = MInst::UDivMod64 { rn: pattern1_0 };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term shift_rr.
pub fn constructor_shift_rr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ShiftOp,
    arg2: Reg,
    arg3: u8,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 1393.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::ShiftRR {
        shift_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
        shift_imm: pattern3_0,
        shift_reg: pattern4_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term unary_rr.
pub fn constructor_unary_rr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &UnaryOp,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1400.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::UnaryRR {
        op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term cmp_rr.
pub fn constructor_cmp_rr<C: Context>(
    ctx: &mut C,
    arg0: &CmpOp,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1407.
    let expr0_0 = MInst::CmpRR {
        op: pattern0_0.clone(),
        rn: pattern1_0,
        rm: pattern2_0,
    };
    let expr1_0 = C::invalid_reg(ctx);
    let expr2_0 = ProducesFlags::ProducesFlags {
        inst: expr0_0,
        result: expr1_0,
    };
    return Some(expr2_0);
}

// Generated as internal constructor for term cmp_rx.
pub fn constructor_cmp_rx<C: Context>(
    ctx: &mut C,
    arg0: &CmpOp,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1413.
    let expr0_0 = MInst::CmpRX {
        op: pattern0_0.clone(),
        rn: pattern1_0,
        mem: pattern2_0.clone(),
    };
    let expr1_0 = C::invalid_reg(ctx);
    let expr2_0 = ProducesFlags::ProducesFlags {
        inst: expr0_0,
        result: expr1_0,
    };
    return Some(expr2_0);
}

// Generated as internal constructor for term cmp_rsimm16.
pub fn constructor_cmp_rsimm16<C: Context>(
    ctx: &mut C,
    arg0: &CmpOp,
    arg1: Reg,
    arg2: i16,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1419.
    let expr0_0 = MInst::CmpRSImm16 {
        op: pattern0_0.clone(),
        rn: pattern1_0,
        imm: pattern2_0,
    };
    let expr1_0 = C::invalid_reg(ctx);
    let expr2_0 = ProducesFlags::ProducesFlags {
        inst: expr0_0,
        result: expr1_0,
    };
    return Some(expr2_0);
}

// Generated as internal constructor for term cmp_rsimm32.
pub fn constructor_cmp_rsimm32<C: Context>(
    ctx: &mut C,
    arg0: &CmpOp,
    arg1: Reg,
    arg2: i32,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1425.
    let expr0_0 = MInst::CmpRSImm32 {
        op: pattern0_0.clone(),
        rn: pattern1_0,
        imm: pattern2_0,
    };
    let expr1_0 = C::invalid_reg(ctx);
    let expr2_0 = ProducesFlags::ProducesFlags {
        inst: expr0_0,
        result: expr1_0,
    };
    return Some(expr2_0);
}

// Generated as internal constructor for term cmp_ruimm32.
pub fn constructor_cmp_ruimm32<C: Context>(
    ctx: &mut C,
    arg0: &CmpOp,
    arg1: Reg,
    arg2: u32,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1431.
    let expr0_0 = MInst::CmpRUImm32 {
        op: pattern0_0.clone(),
        rn: pattern1_0,
        imm: pattern2_0,
    };
    let expr1_0 = C::invalid_reg(ctx);
    let expr2_0 = ProducesFlags::ProducesFlags {
        inst: expr0_0,
        result: expr1_0,
    };
    return Some(expr2_0);
}

// Generated as internal constructor for term atomic_rmw_impl.
pub fn constructor_atomic_rmw_impl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ALUOp,
    arg2: Reg,
    arg3: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1437.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::AtomicRmw {
        alu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
        mem: pattern3_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term atomic_cas32.
pub fn constructor_atomic_cas32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1444.
    let expr0_0: Type = I32;
    let expr1_0 = constructor_copy_writable_reg(ctx, expr0_0, pattern0_0)?;
    let expr2_0 = MInst::AtomicCas32 {
        rd: expr1_0,
        rn: pattern1_0,
        mem: pattern2_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term atomic_cas64.
pub fn constructor_atomic_cas64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1451.
    let expr0_0: Type = I64;
    let expr1_0 = constructor_copy_writable_reg(ctx, expr0_0, pattern0_0)?;
    let expr2_0 = MInst::AtomicCas64 {
        rd: expr1_0,
        rn: pattern1_0,
        mem: pattern2_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fence_impl.
pub fn constructor_fence_impl<C: Context>(ctx: &mut C) -> Option<SideEffectNoResult> {
    // Rule at src/isa/s390x/inst.isle line 1458.
    let expr0_0 = MInst::Fence;
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term load32.
pub fn constructor_load32<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1463.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::Load32 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term load64.
pub fn constructor_load64<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1470.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::Load64 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term loadrev16.
pub fn constructor_loadrev16<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1477.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::LoadRev16 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term loadrev32.
pub fn constructor_loadrev32<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1484.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::LoadRev32 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term loadrev64.
pub fn constructor_loadrev64<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1491.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::LoadRev64 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term store8.
pub fn constructor_store8<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1498.
    let expr0_0 = MInst::Store8 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store16.
pub fn constructor_store16<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1503.
    let expr0_0 = MInst::Store16 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store32.
pub fn constructor_store32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1508.
    let expr0_0 = MInst::Store32 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store64.
pub fn constructor_store64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1513.
    let expr0_0 = MInst::Store64 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store8_imm.
pub fn constructor_store8_imm<C: Context>(
    ctx: &mut C,
    arg0: u8,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1518.
    let expr0_0 = MInst::StoreImm8 {
        imm: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store16_imm.
pub fn constructor_store16_imm<C: Context>(
    ctx: &mut C,
    arg0: i16,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1523.
    let expr0_0 = MInst::StoreImm16 {
        imm: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store32_simm16.
pub fn constructor_store32_simm16<C: Context>(
    ctx: &mut C,
    arg0: i16,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1528.
    let expr0_0 = MInst::StoreImm32SExt16 {
        imm: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term store64_simm16.
pub fn constructor_store64_simm16<C: Context>(
    ctx: &mut C,
    arg0: i16,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1533.
    let expr0_0 = MInst::StoreImm64SExt16 {
        imm: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term storerev16.
pub fn constructor_storerev16<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1538.
    let expr0_0 = MInst::StoreRev16 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term storerev32.
pub fn constructor_storerev32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1543.
    let expr0_0 = MInst::StoreRev32 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term storerev64.
pub fn constructor_storerev64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1548.
    let expr0_0 = MInst::StoreRev64 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_rr.
pub fn constructor_fpu_rr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FPUOp1,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1553.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::FpuRR {
        fpu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpu_rrr.
pub fn constructor_fpu_rrr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FPUOp2,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1560.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::FpuRRR {
        fpu_op: pattern1_0.clone(),
        rd: expr0_0,
        rm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpu_rrrr.
pub fn constructor_fpu_rrrr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FPUOp3,
    arg2: Reg,
    arg3: Reg,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 1567.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern2_0)?;
    let expr1_0 = MInst::FpuRRRR {
        fpu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern3_0,
        rm: pattern4_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpu_copysign.
pub fn constructor_fpu_copysign<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1574.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::FpuCopysign {
        rd: expr0_0,
        rn: pattern1_0,
        rm: pattern2_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpu_cmp32.
pub fn constructor_fpu_cmp32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1581.
    let expr0_0 = MInst::FpuCmp32 {
        rn: pattern0_0,
        rm: pattern1_0,
    };
    let expr1_0 = C::invalid_reg(ctx);
    let expr2_0 = ProducesFlags::ProducesFlags {
        inst: expr0_0,
        result: expr1_0,
    };
    return Some(expr2_0);
}

// Generated as internal constructor for term fpu_cmp64.
pub fn constructor_fpu_cmp64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1587.
    let expr0_0 = MInst::FpuCmp64 {
        rn: pattern0_0,
        rm: pattern1_0,
    };
    let expr1_0 = C::invalid_reg(ctx);
    let expr2_0 = ProducesFlags::ProducesFlags {
        inst: expr0_0,
        result: expr1_0,
    };
    return Some(expr2_0);
}

// Generated as internal constructor for term fpu_to_int.
pub fn constructor_fpu_to_int<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FpuToIntOp,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1593.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::FpuToInt {
        op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
    };
    let expr2_0 = C::writable_reg_to_reg(ctx, expr0_0);
    let expr3_0 = ProducesFlags::ProducesFlags {
        inst: expr1_0,
        result: expr2_0,
    };
    return Some(expr3_0);
}

// Generated as internal constructor for term int_to_fpu.
pub fn constructor_int_to_fpu<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &IntToFpuOp,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1600.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::IntToFpu {
        op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpu_round.
pub fn constructor_fpu_round<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FpuRoundMode,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1607.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::FpuRound {
        op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term fpuvec_rrr.
pub fn constructor_fpuvec_rrr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &FPUOp2,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 1614.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::FpuVecRRR {
        fpu_op: pattern1_0.clone(),
        rd: expr0_0,
        rn: pattern2_0,
        rm: pattern3_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term mov_to_fpr.
pub fn constructor_mov_to_fpr<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1621.
    let expr0_0: Type = F64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::MovToFpr {
        rd: expr1_0,
        rn: pattern0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term mov_from_fpr.
pub fn constructor_mov_from_fpr<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1628.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::MovFromFpr {
        rd: expr1_0,
        rn: pattern0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fpu_load32.
pub fn constructor_fpu_load32<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1635.
    let expr0_0: Type = F32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::FpuLoad32 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fpu_load64.
pub fn constructor_fpu_load64<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1642.
    let expr0_0: Type = F64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::FpuLoad64 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fpu_loadrev32.
pub fn constructor_fpu_loadrev32<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1649.
    let expr0_0: Type = F32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::FpuLoadRev32 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fpu_loadrev64.
pub fn constructor_fpu_loadrev64<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1656.
    let expr0_0: Type = F64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::FpuLoadRev64 {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term fpu_store32.
pub fn constructor_fpu_store32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1663.
    let expr0_0 = MInst::FpuStore32 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_store64.
pub fn constructor_fpu_store64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1668.
    let expr0_0 = MInst::FpuStore64 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_storerev32.
pub fn constructor_fpu_storerev32<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1673.
    let expr0_0 = MInst::FpuStoreRev32 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_storerev64.
pub fn constructor_fpu_storerev64<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &MemArg,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1678.
    let expr0_0 = MInst::FpuStoreRev64 {
        rd: pattern0_0,
        mem: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term load_ext_name_far.
pub fn constructor_load_ext_name_far<C: Context>(
    ctx: &mut C,
    arg0: BoxExternalName,
    arg1: i64,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1683.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::LoadExtNameFar {
        rd: expr1_0,
        name: pattern0_0,
        offset: pattern1_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term load_addr.
pub fn constructor_load_addr<C: Context>(ctx: &mut C, arg0: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1690.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::LoadAddr {
        rd: expr1_0,
        mem: pattern0_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term jump_impl.
pub fn constructor_jump_impl<C: Context>(
    ctx: &mut C,
    arg0: MachLabel,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 1697.
    let expr0_0 = MInst::Jump { dest: pattern0_0 };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term cond_br.
pub fn constructor_cond_br<C: Context>(
    ctx: &mut C,
    arg0: MachLabel,
    arg1: MachLabel,
    arg2: &Cond,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1702.
    let expr0_0 = MInst::CondBr {
        taken: pattern0_0,
        not_taken: pattern1_0,
        cond: pattern2_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term oneway_cond_br.
pub fn constructor_oneway_cond_br<C: Context>(
    ctx: &mut C,
    arg0: MachLabel,
    arg1: &Cond,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1707.
    let expr0_0 = MInst::OneWayCondBr {
        target: pattern0_0,
        cond: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term jt_sequence.
pub fn constructor_jt_sequence<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &VecMachLabel,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1712.
    let expr0_0 = MInst::JTSequence {
        ridx: pattern0_0,
        targets: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term drop_flags.
pub fn constructor_drop_flags<C: Context>(ctx: &mut C, arg0: &ProducesFlags) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlags {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 1717.
        let expr0_0 = C::emit(ctx, &pattern1_0);
        return Some(pattern1_1);
    }
    return None;
}

// Generated as internal constructor for term emit_mov.
pub fn constructor_emit_mov<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: WritableReg,
    arg2: Reg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1733.
        let expr0_0 = MInst::FpuMove32 {
            rd: pattern2_0,
            rn: pattern3_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1736.
        let expr0_0 = MInst::FpuMove64 {
            rd: pattern2_0,
            rn: pattern3_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1727.
        let expr0_0 = MInst::Mov32 {
            rd: pattern2_0,
            rm: pattern3_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1730.
        let expr0_0 = MInst::Mov64 {
            rd: pattern2_0,
            rm: pattern3_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term copy_writable_reg.
pub fn constructor_copy_writable_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
) -> Option<WritableReg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1741.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = constructor_emit_mov(ctx, pattern0_0, expr0_0, pattern1_0)?;
    return Some(expr0_0);
}

// Generated as internal constructor for term copy_reg.
pub fn constructor_copy_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1748.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term emit_imm.
pub fn constructor_emit_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: WritableReg,
    arg2: u64,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1803.
        let expr0_0 = C::u64_as_u32(ctx, pattern3_0);
        let expr1_0 = MInst::LoadFpuConst32 {
            rd: pattern2_0,
            const_data: expr0_0,
        };
        let expr2_0 = C::emit(ctx, &expr1_0);
        return Some(expr2_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1808.
        let expr0_0 = MInst::LoadFpuConst64 {
            rd: pattern2_0,
            const_data: pattern3_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if let Some(pattern1_0) = C::fits_in_16(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1757.
        let expr0_0 = C::u64_as_i16(ctx, pattern3_0);
        let expr1_0 = MInst::Mov32SImm16 {
            rd: pattern2_0,
            imm: expr0_0,
        };
        let expr2_0 = C::emit(ctx, &expr1_0);
        return Some(expr2_0);
    }
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        if let Some(pattern4_0) = C::i16_from_u64(ctx, pattern3_0) {
            // Rule at src/isa/s390x/inst.isle line 1761.
            let expr0_0 = MInst::Mov32SImm16 {
                rd: pattern2_0,
                imm: pattern4_0,
            };
            let expr1_0 = C::emit(ctx, &expr0_0);
            return Some(expr1_0);
        }
        // Rule at src/isa/s390x/inst.isle line 1765.
        let expr0_0 = C::u64_as_u32(ctx, pattern3_0);
        let expr1_0 = MInst::Mov32Imm {
            rd: pattern2_0,
            imm: expr0_0,
        };
        let expr2_0 = C::emit(ctx, &expr1_0);
        return Some(expr2_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        if let Some(pattern4_0) = C::u64_nonzero_hipart(ctx, pattern3_0) {
            if let Some(pattern5_0) = C::u64_nonzero_lopart(ctx, pattern3_0) {
                // Rule at src/isa/s390x/inst.isle line 1785.
                let expr0_0 = constructor_emit_imm(ctx, pattern1_0, pattern2_0, pattern4_0)?;
                let expr1_0 = constructor_emit_insert_imm(ctx, pattern2_0, pattern5_0)?;
                return Some(expr1_0);
            }
        }
        if let Some(pattern4_0) = C::i16_from_u64(ctx, pattern3_0) {
            // Rule at src/isa/s390x/inst.isle line 1769.
            let expr0_0 = MInst::Mov64SImm16 {
                rd: pattern2_0,
                imm: pattern4_0,
            };
            let expr1_0 = C::emit(ctx, &expr0_0);
            return Some(expr1_0);
        }
        if let Some(pattern4_0) = C::i32_from_u64(ctx, pattern3_0) {
            // Rule at src/isa/s390x/inst.isle line 1773.
            let expr0_0 = MInst::Mov64SImm32 {
                rd: pattern2_0,
                imm: pattern4_0,
            };
            let expr1_0 = C::emit(ctx, &expr0_0);
            return Some(expr1_0);
        }
        if let Some(pattern4_0) = C::uimm32shifted_from_u64(ctx, pattern3_0) {
            // Rule at src/isa/s390x/inst.isle line 1781.
            let expr0_0 = MInst::Mov64UImm32Shifted {
                rd: pattern2_0,
                imm: pattern4_0,
            };
            let expr1_0 = C::emit(ctx, &expr0_0);
            return Some(expr1_0);
        }
        if let Some(pattern4_0) = C::uimm16shifted_from_u64(ctx, pattern3_0) {
            // Rule at src/isa/s390x/inst.isle line 1777.
            let expr0_0 = MInst::Mov64UImm16Shifted {
                rd: pattern2_0,
                imm: pattern4_0,
            };
            let expr1_0 = C::emit(ctx, &expr0_0);
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term emit_insert_imm.
pub fn constructor_emit_insert_imm<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: u64,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(pattern2_0) = C::uimm32shifted_from_u64(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 1798.
        let expr0_0 = MInst::Insert64UImm32Shifted {
            rd: pattern0_0,
            imm: pattern2_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::uimm16shifted_from_u64(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 1794.
        let expr0_0 = MInst::Insert64UImm16Shifted {
            rd: pattern0_0,
            imm: pattern2_0,
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term imm.
pub fn constructor_imm<C: Context>(ctx: &mut C, arg0: Type, arg1: u64) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1813.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = constructor_emit_imm(ctx, pattern0_0, expr0_0, pattern1_0)?;
    let expr2_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term imm_regpair_lo.
pub fn constructor_imm_regpair_lo<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: u64,
    arg2: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1821.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern2_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_imm(ctx, pattern0_0, expr1_0, pattern1_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term imm_regpair_hi.
pub fn constructor_imm_regpair_hi<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: u64,
    arg2: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1829.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern2_0)?;
    let expr1_0 = constructor_writable_regpair_hi(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_imm(ctx, pattern0_0, expr1_0, pattern1_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term ty_ext32.
pub fn constructor_ty_ext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<Type> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 1839.
        let expr0_0: Type = I32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 1840.
        let expr0_0: Type = I32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 1841.
        let expr0_0: Type = I32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 1842.
        let expr0_0: Type = I64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term ty_ext64.
pub fn constructor_ty_ext64<C: Context>(ctx: &mut C, arg0: Type) -> Option<Type> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 1846.
        let expr0_0: Type = I64;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 1847.
        let expr0_0: Type = I64;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 1848.
        let expr0_0: Type = I64;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 1849.
        let expr0_0: Type = I64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term emit_zext32_reg.
pub fn constructor_emit_zext32_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: Reg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1854.
    let expr0_0: bool = false;
    let expr1_0 = C::ty_bits(ctx, pattern1_0);
    let expr2_0: u8 = 32;
    let expr3_0 = MInst::Extend {
        rd: pattern0_0,
        rn: pattern2_0,
        signed: expr0_0,
        from_bits: expr1_0,
        to_bits: expr2_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term emit_sext32_reg.
pub fn constructor_emit_sext32_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: Reg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1860.
    let expr0_0: bool = true;
    let expr1_0 = C::ty_bits(ctx, pattern1_0);
    let expr2_0: u8 = 32;
    let expr3_0 = MInst::Extend {
        rd: pattern0_0,
        rn: pattern2_0,
        signed: expr0_0,
        from_bits: expr1_0,
        to_bits: expr2_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term emit_zext64_reg.
pub fn constructor_emit_zext64_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: Reg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1866.
    let expr0_0: bool = false;
    let expr1_0 = C::ty_bits(ctx, pattern1_0);
    let expr2_0: u8 = 64;
    let expr3_0 = MInst::Extend {
        rd: pattern0_0,
        rn: pattern2_0,
        signed: expr0_0,
        from_bits: expr1_0,
        to_bits: expr2_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term emit_sext64_reg.
pub fn constructor_emit_sext64_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: Reg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 1872.
    let expr0_0: bool = true;
    let expr1_0 = C::ty_bits(ctx, pattern1_0);
    let expr2_0: u8 = 64;
    let expr3_0 = MInst::Extend {
        rd: pattern0_0,
        rn: pattern2_0,
        signed: expr0_0,
        from_bits: expr1_0,
        to_bits: expr2_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term zext32_reg.
pub fn constructor_zext32_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1878.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_zext32_reg(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term sext32_reg.
pub fn constructor_sext32_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1886.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_sext32_reg(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term zext64_reg.
pub fn constructor_zext64_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1894.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_zext64_reg(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term sext64_reg.
pub fn constructor_sext64_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1902.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_sext64_reg(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term emit_zext32_mem.
pub fn constructor_emit_zext32_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: &MemArg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1910.
        let expr0_0 = MInst::Load32ZExt8 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1911.
        let expr0_0 = MInst::Load32ZExt16 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_sext32_mem.
pub fn constructor_emit_sext32_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: &MemArg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1915.
        let expr0_0 = MInst::Load32SExt8 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1916.
        let expr0_0 = MInst::Load32SExt16 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_zext64_mem.
pub fn constructor_emit_zext64_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: &MemArg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1920.
        let expr0_0 = MInst::Load64ZExt8 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1921.
        let expr0_0 = MInst::Load64ZExt16 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I32 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1922.
        let expr0_0 = MInst::Load64ZExt32 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_sext64_mem.
pub fn constructor_emit_sext64_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Type,
    arg2: &MemArg,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if pattern1_0 == I8 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1926.
        let expr0_0 = MInst::Load64SExt8 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I16 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1927.
        let expr0_0 = MInst::Load64SExt16 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    if pattern1_0 == I32 {
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 1928.
        let expr0_0 = MInst::Load64SExt32 {
            rd: pattern0_0,
            mem: pattern3_0.clone(),
        };
        let expr1_0 = C::emit(ctx, &expr0_0);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term zext32_mem.
pub fn constructor_zext32_mem<C: Context>(ctx: &mut C, arg0: Type, arg1: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1932.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_zext32_mem(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term sext32_mem.
pub fn constructor_sext32_mem<C: Context>(ctx: &mut C, arg0: Type, arg1: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1939.
    let expr0_0: Type = I32;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_sext32_mem(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term zext64_mem.
pub fn constructor_zext64_mem<C: Context>(ctx: &mut C, arg0: Type, arg1: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1946.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_zext64_mem(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term sext64_mem.
pub fn constructor_sext64_mem<C: Context>(ctx: &mut C, arg0: Type, arg1: &MemArg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 1953.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = constructor_emit_sext64_mem(ctx, expr1_0, pattern0_0, pattern1_0)?;
    let expr3_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term emit_put_in_reg_zext32.
pub fn constructor_emit_put_in_reg_zext32<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Value,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::u64_from_value(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 1961.
        let expr0_0 = constructor_ty_ext32(ctx, pattern2_0)?;
        let expr1_0 = constructor_emit_imm(ctx, expr0_0, pattern0_0, pattern3_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::fits_in_16(ctx, pattern2_0) {
        if let Some(pattern4_0) = C::sinkable_inst(ctx, pattern1_0) {
            let pattern5_0 = C::inst_data(ctx, pattern4_0);
            if let &InstructionData::Load {
                opcode: ref pattern6_0,
                arg: pattern6_1,
                flags: pattern6_2,
                offset: pattern6_3,
            } = &pattern5_0
            {
                if let &Opcode::Load = &pattern6_0 {
                    if let Some(()) = C::bigendian(ctx, pattern6_2) {
                        // Rule at src/isa/s390x/inst.isle line 1963.
                        let expr0_0 = constructor_sink_load(ctx, pattern4_0)?;
                        let expr1_0 =
                            constructor_emit_zext32_mem(ctx, pattern0_0, pattern3_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 1965.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_zext32_reg(ctx, pattern0_0, pattern3_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern2_0) {
        // Rule at src/isa/s390x/inst.isle line 1967.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_mov(ctx, pattern3_0, pattern0_0, expr0_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_put_in_reg_sext32.
pub fn constructor_emit_put_in_reg_sext32<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Value,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::u64_from_signed_value(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 1972.
        let expr0_0 = constructor_ty_ext32(ctx, pattern2_0)?;
        let expr1_0 = constructor_emit_imm(ctx, expr0_0, pattern0_0, pattern3_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::fits_in_16(ctx, pattern2_0) {
        if let Some(pattern4_0) = C::sinkable_inst(ctx, pattern1_0) {
            let pattern5_0 = C::inst_data(ctx, pattern4_0);
            if let &InstructionData::Load {
                opcode: ref pattern6_0,
                arg: pattern6_1,
                flags: pattern6_2,
                offset: pattern6_3,
            } = &pattern5_0
            {
                if let &Opcode::Load = &pattern6_0 {
                    if let Some(()) = C::bigendian(ctx, pattern6_2) {
                        // Rule at src/isa/s390x/inst.isle line 1974.
                        let expr0_0 = constructor_sink_load(ctx, pattern4_0)?;
                        let expr1_0 =
                            constructor_emit_sext32_mem(ctx, pattern0_0, pattern3_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 1976.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_sext32_reg(ctx, pattern0_0, pattern3_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern2_0) {
        // Rule at src/isa/s390x/inst.isle line 1978.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_mov(ctx, pattern3_0, pattern0_0, expr0_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_put_in_reg_zext64.
pub fn constructor_emit_put_in_reg_zext64<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Value,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::u64_from_value(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 1983.
        let expr0_0 = constructor_ty_ext64(ctx, pattern2_0)?;
        let expr1_0 = constructor_emit_imm(ctx, expr0_0, pattern0_0, pattern3_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::gpr32_ty(ctx, pattern2_0) {
        if let Some(pattern4_0) = C::sinkable_inst(ctx, pattern1_0) {
            let pattern5_0 = C::inst_data(ctx, pattern4_0);
            if let &InstructionData::Load {
                opcode: ref pattern6_0,
                arg: pattern6_1,
                flags: pattern6_2,
                offset: pattern6_3,
            } = &pattern5_0
            {
                if let &Opcode::Load = &pattern6_0 {
                    if let Some(()) = C::bigendian(ctx, pattern6_2) {
                        // Rule at src/isa/s390x/inst.isle line 1985.
                        let expr0_0 = constructor_sink_load(ctx, pattern4_0)?;
                        let expr1_0 =
                            constructor_emit_zext64_mem(ctx, pattern0_0, pattern3_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 1987.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_zext64_reg(ctx, pattern0_0, pattern3_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::gpr64_ty(ctx, pattern2_0) {
        // Rule at src/isa/s390x/inst.isle line 1989.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_mov(ctx, pattern3_0, pattern0_0, expr0_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_put_in_reg_sext64.
pub fn constructor_emit_put_in_reg_sext64<C: Context>(
    ctx: &mut C,
    arg0: WritableReg,
    arg1: Value,
) -> Option<Unit> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::u64_from_signed_value(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 1994.
        let expr0_0 = constructor_ty_ext64(ctx, pattern2_0)?;
        let expr1_0 = constructor_emit_imm(ctx, expr0_0, pattern0_0, pattern3_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::gpr32_ty(ctx, pattern2_0) {
        if let Some(pattern4_0) = C::sinkable_inst(ctx, pattern1_0) {
            let pattern5_0 = C::inst_data(ctx, pattern4_0);
            if let &InstructionData::Load {
                opcode: ref pattern6_0,
                arg: pattern6_1,
                flags: pattern6_2,
                offset: pattern6_3,
            } = &pattern5_0
            {
                if let &Opcode::Load = &pattern6_0 {
                    if let Some(()) = C::bigendian(ctx, pattern6_2) {
                        // Rule at src/isa/s390x/inst.isle line 1996.
                        let expr0_0 = constructor_sink_load(ctx, pattern4_0)?;
                        let expr1_0 =
                            constructor_emit_sext64_mem(ctx, pattern0_0, pattern3_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 1998.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_sext64_reg(ctx, pattern0_0, pattern3_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern3_0) = C::gpr64_ty(ctx, pattern2_0) {
        // Rule at src/isa/s390x/inst.isle line 2000.
        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
        let expr1_0 = constructor_emit_mov(ctx, pattern3_0, pattern0_0, expr0_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_zext32.
pub fn constructor_put_in_reg_zext32<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::u64_from_value(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2005.
        let expr0_0 = constructor_ty_ext32(ctx, pattern1_0)?;
        let expr1_0 = constructor_imm(ctx, expr0_0, pattern2_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::fits_in_16(ctx, pattern1_0) {
        if let Some(pattern3_0) = C::sinkable_inst(ctx, pattern0_0) {
            let pattern4_0 = C::inst_data(ctx, pattern3_0);
            if let &InstructionData::Load {
                opcode: ref pattern5_0,
                arg: pattern5_1,
                flags: pattern5_2,
                offset: pattern5_3,
            } = &pattern4_0
            {
                if let &Opcode::Load = &pattern5_0 {
                    if let Some(()) = C::bigendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/inst.isle line 2007.
                        let expr0_0 = constructor_sink_load(ctx, pattern3_0)?;
                        let expr1_0 = constructor_zext32_mem(ctx, pattern2_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2009.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0 = constructor_zext32_reg(ctx, pattern2_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::ty_32_or_64(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2011.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_sext32.
pub fn constructor_put_in_reg_sext32<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::u64_from_signed_value(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2016.
        let expr0_0 = constructor_ty_ext32(ctx, pattern1_0)?;
        let expr1_0 = constructor_imm(ctx, expr0_0, pattern2_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::fits_in_16(ctx, pattern1_0) {
        if let Some(pattern3_0) = C::sinkable_inst(ctx, pattern0_0) {
            let pattern4_0 = C::inst_data(ctx, pattern3_0);
            if let &InstructionData::Load {
                opcode: ref pattern5_0,
                arg: pattern5_1,
                flags: pattern5_2,
                offset: pattern5_3,
            } = &pattern4_0
            {
                if let &Opcode::Load = &pattern5_0 {
                    if let Some(()) = C::bigendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/inst.isle line 2018.
                        let expr0_0 = constructor_sink_load(ctx, pattern3_0)?;
                        let expr1_0 = constructor_sext32_mem(ctx, pattern2_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2020.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0 = constructor_sext32_reg(ctx, pattern2_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::ty_32_or_64(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2022.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_zext64.
pub fn constructor_put_in_reg_zext64<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::u64_from_value(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2027.
        let expr0_0 = constructor_ty_ext64(ctx, pattern1_0)?;
        let expr1_0 = constructor_imm(ctx, expr0_0, pattern2_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::gpr32_ty(ctx, pattern1_0) {
        if let Some(pattern3_0) = C::sinkable_inst(ctx, pattern0_0) {
            let pattern4_0 = C::inst_data(ctx, pattern3_0);
            if let &InstructionData::Load {
                opcode: ref pattern5_0,
                arg: pattern5_1,
                flags: pattern5_2,
                offset: pattern5_3,
            } = &pattern4_0
            {
                if let &Opcode::Load = &pattern5_0 {
                    if let Some(()) = C::bigendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/inst.isle line 2029.
                        let expr0_0 = constructor_sink_load(ctx, pattern3_0)?;
                        let expr1_0 = constructor_zext64_mem(ctx, pattern2_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2031.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0 = constructor_zext64_reg(ctx, pattern2_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::gpr64_ty(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2033.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_reg_sext64.
pub fn constructor_put_in_reg_sext64<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::u64_from_signed_value(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2038.
        let expr0_0 = constructor_ty_ext64(ctx, pattern1_0)?;
        let expr1_0 = constructor_imm(ctx, expr0_0, pattern2_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::gpr32_ty(ctx, pattern1_0) {
        if let Some(pattern3_0) = C::sinkable_inst(ctx, pattern0_0) {
            let pattern4_0 = C::inst_data(ctx, pattern3_0);
            if let &InstructionData::Load {
                opcode: ref pattern5_0,
                arg: pattern5_1,
                flags: pattern5_2,
                offset: pattern5_3,
            } = &pattern4_0
            {
                if let &Opcode::Load = &pattern5_0 {
                    if let Some(()) = C::bigendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/inst.isle line 2040.
                        let expr0_0 = constructor_sink_load(ctx, pattern3_0)?;
                        let expr1_0 = constructor_sext64_mem(ctx, pattern2_0, &expr0_0)?;
                        return Some(expr1_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/inst.isle line 2042.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        let expr1_0 = constructor_sext64_reg(ctx, pattern2_0, expr0_0)?;
        return Some(expr1_0);
    }
    if let Some(pattern2_0) = C::gpr64_ty(ctx, pattern1_0) {
        // Rule at src/isa/s390x/inst.isle line 2044.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term put_in_regpair_lo_zext32.
pub fn constructor_put_in_regpair_lo_zext32<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2050.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern1_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_put_in_reg_zext32(ctx, expr1_0, pattern0_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term put_in_regpair_lo_sext32.
pub fn constructor_put_in_regpair_lo_sext32<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2058.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern1_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_put_in_reg_sext32(ctx, expr1_0, pattern0_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term put_in_regpair_lo_zext64.
pub fn constructor_put_in_regpair_lo_zext64<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2066.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern1_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_put_in_reg_zext64(ctx, expr1_0, pattern0_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term put_in_regpair_lo_sext64.
pub fn constructor_put_in_regpair_lo_sext64<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2074.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern1_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_put_in_reg_sext64(ctx, expr1_0, pattern0_0)?;
    let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term emit_cmov_imm.
pub fn constructor_emit_cmov_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: WritableReg,
    arg2: &Cond,
    arg3: i16,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2084.
        let expr0_0 = MInst::CMov32SImm16 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            imm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlags {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2087.
        let expr0_0 = MInst::CMov64SImm16 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            imm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlags {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term cmov_imm.
pub fn constructor_cmov_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Cond,
    arg2: i16,
    arg3: Reg,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 2093.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern3_0)?;
    let expr1_0 = constructor_emit_cmov_imm(ctx, pattern0_0, expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmov_imm_regpair_lo.
pub fn constructor_cmov_imm_regpair_lo<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ProducesFlags,
    arg2: &Cond,
    arg3: i16,
    arg4: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2100.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern4_0)?;
    let expr1_0 = constructor_writable_regpair_lo(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_cmov_imm(ctx, pattern0_0, expr1_0, pattern2_0, pattern3_0)?;
    let expr3_0 = constructor_with_flags_1(ctx, pattern1_0, &expr2_0)?;
    let expr4_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term cmov_imm_regpair_hi.
pub fn constructor_cmov_imm_regpair_hi<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ProducesFlags,
    arg2: &Cond,
    arg3: i16,
    arg4: &RegPair,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2109.
    let expr0_0 = constructor_copy_writable_regpair(ctx, pattern4_0)?;
    let expr1_0 = constructor_writable_regpair_hi(ctx, &expr0_0)?;
    let expr2_0 = constructor_emit_cmov_imm(ctx, pattern0_0, expr1_0, pattern2_0, pattern3_0)?;
    let expr3_0 = constructor_with_flags_1(ctx, pattern1_0, &expr2_0)?;
    let expr4_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term emit_cmov_reg.
pub fn constructor_emit_cmov_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: WritableReg,
    arg2: &Cond,
    arg3: Reg,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2123.
        let expr0_0 = MInst::FpuCMov32 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            rm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlags {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2126.
        let expr0_0 = MInst::FpuCMov64 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            rm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlags {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2117.
        let expr0_0 = MInst::CMov32 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            rm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlags {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2120.
        let expr0_0 = MInst::CMov64 {
            rd: pattern2_0,
            cond: pattern3_0.clone(),
            rm: pattern4_0,
        };
        let expr1_0 = C::writable_reg_to_reg(ctx, pattern2_0);
        let expr2_0 = ConsumesFlags::ConsumesFlags {
            inst: expr0_0,
            result: expr1_0,
        };
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term cmov_reg.
pub fn constructor_cmov_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Cond,
    arg2: Reg,
    arg3: Reg,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 2132.
    let expr0_0 = constructor_copy_writable_reg(ctx, pattern0_0, pattern3_0)?;
    let expr1_0 = constructor_emit_cmov_reg(ctx, pattern0_0, expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term trap_if.
pub fn constructor_trap_if<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &Cond,
    arg2: &TrapCode,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlags {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2140.
        let expr0_0 = C::emit(ctx, &pattern1_0);
        let expr1_0 = MInst::TrapIf {
            cond: pattern2_0.clone(),
            trap_code: pattern3_0.clone(),
        };
        let expr2_0 = C::emit(ctx, &expr1_0);
        return Some(pattern1_1);
    }
    return None;
}

// Generated as internal constructor for term icmps_reg_and_trap.
pub fn constructor_icmps_reg_and_trap<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: &Cond,
    arg4: &TrapCode,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2146.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = MInst::CmpTrapRR {
        op: expr0_0,
        rn: pattern1_0,
        rm: pattern2_0,
        cond: pattern3_0.clone(),
        trap_code: pattern4_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::invalid_reg(ctx);
    return Some(expr3_0);
}

// Generated as internal constructor for term icmps_simm16_and_trap.
pub fn constructor_icmps_simm16_and_trap<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i16,
    arg3: &Cond,
    arg4: &TrapCode,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2152.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = MInst::CmpTrapRSImm16 {
        op: expr0_0,
        rn: pattern1_0,
        imm: pattern2_0,
        cond: pattern3_0.clone(),
        trap_code: pattern4_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::invalid_reg(ctx);
    return Some(expr3_0);
}

// Generated as internal constructor for term icmpu_reg_and_trap.
pub fn constructor_icmpu_reg_and_trap<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: &Cond,
    arg4: &TrapCode,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2158.
    let expr0_0 = constructor_cmpop_cmpu(ctx, pattern0_0)?;
    let expr1_0 = MInst::CmpTrapRR {
        op: expr0_0,
        rn: pattern1_0,
        rm: pattern2_0,
        cond: pattern3_0.clone(),
        trap_code: pattern4_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::invalid_reg(ctx);
    return Some(expr3_0);
}

// Generated as internal constructor for term icmpu_uimm16_and_trap.
pub fn constructor_icmpu_uimm16_and_trap<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u16,
    arg3: &Cond,
    arg4: &TrapCode,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/s390x/inst.isle line 2164.
    let expr0_0 = constructor_cmpop_cmpu(ctx, pattern0_0)?;
    let expr1_0 = MInst::CmpTrapRUImm16 {
        op: expr0_0,
        rn: pattern1_0,
        imm: pattern2_0,
        cond: pattern3_0.clone(),
        trap_code: pattern4_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::invalid_reg(ctx);
    return Some(expr3_0);
}

// Generated as internal constructor for term trap_impl.
pub fn constructor_trap_impl<C: Context>(
    ctx: &mut C,
    arg0: &TrapCode,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 2170.
    let expr0_0 = MInst::Trap {
        trap_code: pattern0_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term trap_if_impl.
pub fn constructor_trap_if_impl<C: Context>(
    ctx: &mut C,
    arg0: &Cond,
    arg1: &TrapCode,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2174.
    let expr0_0 = MInst::TrapIf {
        cond: pattern0_0.clone(),
        trap_code: pattern1_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term debugtrap_impl.
pub fn constructor_debugtrap_impl<C: Context>(ctx: &mut C) -> Option<SideEffectNoResult> {
    // Rule at src/isa/s390x/inst.isle line 2178.
    let expr0_0 = MInst::Debugtrap;
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term bool.
pub fn constructor_bool<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &Cond,
) -> Option<ProducesBool> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2189.
    let expr0_0 = ProducesBool::ProducesBool {
        producer: pattern0_0.clone(),
        cond: pattern1_0.clone(),
    };
    return Some(expr0_0);
}

// Generated as internal constructor for term invert_bool.
pub fn constructor_invert_bool<C: Context>(
    ctx: &mut C,
    arg0: &ProducesBool,
) -> Option<ProducesBool> {
    let pattern0_0 = arg0;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern1_0,
        cond: ref pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 2193.
        let expr0_0 = C::invert_cond(ctx, &pattern1_1);
        let expr1_0 = constructor_bool(ctx, &pattern1_0, &expr0_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term emit_producer.
pub fn constructor_emit_producer<C: Context>(ctx: &mut C, arg0: &ProducesFlags) -> Option<Unit> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlags {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 2202.
        let expr0_0 = C::emit(ctx, &pattern1_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term emit_consumer.
pub fn constructor_emit_consumer<C: Context>(ctx: &mut C, arg0: &ConsumesFlags) -> Option<Unit> {
    let pattern0_0 = arg0;
    if let &ConsumesFlags::ConsumesFlags {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/isa/s390x/inst.isle line 2204.
        let expr0_0 = C::emit(ctx, &pattern1_0);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term select_bool_reg.
pub fn constructor_select_bool_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ProducesBool,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern2_0,
        cond: ref pattern2_1,
    } = pattern1_0
    {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2208.
        let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
        let expr1_0 = constructor_emit_producer(ctx, &pattern2_0)?;
        let expr2_0 = constructor_emit_mov(ctx, pattern0_0, expr0_0, pattern4_0)?;
        let expr3_0 = constructor_emit_cmov_reg(ctx, pattern0_0, expr0_0, &pattern2_1, pattern3_0)?;
        let expr4_0 = constructor_emit_consumer(ctx, &expr3_0)?;
        let expr5_0 = C::writable_reg_to_reg(ctx, expr0_0);
        return Some(expr5_0);
    }
    return None;
}

// Generated as internal constructor for term select_bool_imm.
pub fn constructor_select_bool_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ProducesBool,
    arg2: i16,
    arg3: u64,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern2_0,
        cond: ref pattern2_1,
    } = pattern1_0
    {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/inst.isle line 2217.
        let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
        let expr1_0 = constructor_emit_producer(ctx, &pattern2_0)?;
        let expr2_0 = constructor_emit_imm(ctx, pattern0_0, expr0_0, pattern4_0)?;
        let expr3_0 = constructor_emit_cmov_imm(ctx, pattern0_0, expr0_0, &pattern2_1, pattern3_0)?;
        let expr4_0 = constructor_emit_consumer(ctx, &expr3_0)?;
        let expr5_0 = C::writable_reg_to_reg(ctx, expr0_0);
        return Some(expr5_0);
    }
    return None;
}

// Generated as internal constructor for term lower_bool.
pub fn constructor_lower_bool<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ProducesBool,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == B1 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2227.
        let expr0_0: Type = B1;
        let expr1_0: i16 = 1;
        let expr2_0: u64 = 0;
        let expr3_0 = constructor_select_bool_imm(ctx, expr0_0, pattern2_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    if pattern0_0 == B8 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2228.
        let expr0_0: Type = B8;
        let expr1_0: i16 = -1;
        let expr2_0: u64 = 0;
        let expr3_0 = constructor_select_bool_imm(ctx, expr0_0, pattern2_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    if pattern0_0 == B16 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2229.
        let expr0_0: Type = B16;
        let expr1_0: i16 = -1;
        let expr2_0: u64 = 0;
        let expr3_0 = constructor_select_bool_imm(ctx, expr0_0, pattern2_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    if pattern0_0 == B32 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2230.
        let expr0_0: Type = B32;
        let expr1_0: i16 = -1;
        let expr2_0: u64 = 0;
        let expr3_0 = constructor_select_bool_imm(ctx, expr0_0, pattern2_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    if pattern0_0 == B64 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2231.
        let expr0_0: Type = B64;
        let expr1_0: i16 = -1;
        let expr2_0: u64 = 0;
        let expr3_0 = constructor_select_bool_imm(ctx, expr0_0, pattern2_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    return None;
}

// Generated as internal constructor for term cond_br_bool.
pub fn constructor_cond_br_bool<C: Context>(
    ctx: &mut C,
    arg0: &ProducesBool,
    arg1: MachLabel,
    arg2: MachLabel,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern1_0,
        cond: ref pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2235.
        let expr0_0 = constructor_emit_producer(ctx, &pattern1_0)?;
        let expr1_0 = constructor_cond_br(ctx, pattern2_0, pattern3_0, &pattern1_1)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term oneway_cond_br_bool.
pub fn constructor_oneway_cond_br_bool<C: Context>(
    ctx: &mut C,
    arg0: &ProducesBool,
    arg1: MachLabel,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern1_0,
        cond: ref pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2241.
        let expr0_0 = constructor_emit_producer(ctx, &pattern1_0)?;
        let expr1_0 = constructor_oneway_cond_br(ctx, pattern2_0, &pattern1_1)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term trap_if_bool.
pub fn constructor_trap_if_bool<C: Context>(
    ctx: &mut C,
    arg0: &ProducesBool,
    arg1: &TrapCode,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let &ProducesBool::ProducesBool {
        producer: ref pattern1_0,
        cond: ref pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2247.
        let expr0_0 = constructor_emit_producer(ctx, &pattern1_0)?;
        let expr1_0 = constructor_trap_if_impl(ctx, &pattern1_1, pattern2_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term clz_reg.
pub fn constructor_clz_reg<C: Context>(ctx: &mut C, arg0: i16, arg1: Reg) -> Option<RegPair> {
    let pattern0_0 = arg0;
    if pattern0_0 == 64 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2258.
        let expr0_0 = constructor_temp_writable_regpair(ctx)?;
        let expr1_0 = MInst::Flogr { rn: pattern2_0 };
        let expr2_0 = C::emit(ctx, &expr1_0);
        let expr3_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
        return Some(expr3_0);
    }
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2267.
    let expr0_0 = constructor_temp_writable_regpair(ctx)?;
    let expr1_0 = MInst::Flogr { rn: pattern1_0 };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = constructor_writable_regpair_hi(ctx, &expr0_0)?;
    let expr4_0 = IntCC::Equal;
    let expr5_0 = C::intcc_as_cond(ctx, &expr4_0);
    let expr6_0 = MInst::CMov64SImm16 {
        rd: expr3_0,
        cond: expr5_0,
        imm: pattern0_0,
    };
    let expr7_0 = C::emit(ctx, &expr6_0);
    let expr8_0 = constructor_writable_regpair_to_regpair(ctx, &expr0_0)?;
    return Some(expr8_0);
}

// Generated as internal constructor for term aluop_add.
pub fn constructor_aluop_add<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 2278.
        let expr0_0 = ALUOp::Add32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2279.
        let expr0_0 = ALUOp::Add32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2280.
        let expr0_0 = ALUOp::Add32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2281.
        let expr0_0 = ALUOp::Add64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_add_sext16.
pub fn constructor_aluop_add_sext16<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2284.
        let expr0_0 = ALUOp::Add32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2285.
        let expr0_0 = ALUOp::Add32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2286.
        let expr0_0 = ALUOp::Add64Ext16;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_add_sext32.
pub fn constructor_aluop_add_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2289.
        let expr0_0 = ALUOp::Add64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term add_reg.
pub fn constructor_add_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2292.
    let expr0_0 = constructor_aluop_add(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_reg_sext32.
pub fn constructor_add_reg_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2295.
    let expr0_0 = constructor_aluop_add_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_simm16.
pub fn constructor_add_simm16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i16,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2298.
    let expr0_0 = constructor_aluop_add(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrsimm16(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_simm32.
pub fn constructor_add_simm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2301.
    let expr0_0 = constructor_aluop_add(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rsimm32(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_mem.
pub fn constructor_add_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2304.
    let expr0_0 = constructor_aluop_add(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_mem_sext16.
pub fn constructor_add_mem_sext16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2307.
    let expr0_0 = constructor_aluop_add_sext16(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_mem_sext32.
pub fn constructor_add_mem_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2310.
    let expr0_0 = constructor_aluop_add_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_add_logical.
pub fn constructor_aluop_add_logical<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2316.
        let expr0_0 = ALUOp::AddLogical32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2317.
        let expr0_0 = ALUOp::AddLogical64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_add_logical_zext32.
pub fn constructor_aluop_add_logical_zext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2320.
        let expr0_0 = ALUOp::AddLogical64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term add_logical_reg.
pub fn constructor_add_logical_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2323.
    let expr0_0 = constructor_aluop_add_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_logical_reg_zext32.
pub fn constructor_add_logical_reg_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2326.
    let expr0_0 = constructor_aluop_add_logical_zext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_logical_zimm32.
pub fn constructor_add_logical_zimm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2329.
    let expr0_0 = constructor_aluop_add_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_ruimm32(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_logical_mem.
pub fn constructor_add_logical_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2332.
    let expr0_0 = constructor_aluop_add_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_logical_mem_zext32.
pub fn constructor_add_logical_mem_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2335.
    let expr0_0 = constructor_aluop_add_logical_zext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_sub.
pub fn constructor_aluop_sub<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 2341.
        let expr0_0 = ALUOp::Sub32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2342.
        let expr0_0 = ALUOp::Sub32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2343.
        let expr0_0 = ALUOp::Sub32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2344.
        let expr0_0 = ALUOp::Sub64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_sub_sext16.
pub fn constructor_aluop_sub_sext16<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2347.
        let expr0_0 = ALUOp::Sub32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2348.
        let expr0_0 = ALUOp::Sub32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2349.
        let expr0_0 = ALUOp::Sub64Ext16;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_sub_sext32.
pub fn constructor_aluop_sub_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2352.
        let expr0_0 = ALUOp::Sub64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sub_reg.
pub fn constructor_sub_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2355.
    let expr0_0 = constructor_aluop_sub(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_reg_sext32.
pub fn constructor_sub_reg_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2358.
    let expr0_0 = constructor_aluop_sub_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_mem.
pub fn constructor_sub_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2361.
    let expr0_0 = constructor_aluop_sub(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_mem_sext16.
pub fn constructor_sub_mem_sext16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2364.
    let expr0_0 = constructor_aluop_sub_sext16(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_mem_sext32.
pub fn constructor_sub_mem_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2367.
    let expr0_0 = constructor_aluop_sub_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_sub_logical.
pub fn constructor_aluop_sub_logical<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2373.
        let expr0_0 = ALUOp::SubLogical32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2374.
        let expr0_0 = ALUOp::SubLogical64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_sub_logical_zext32.
pub fn constructor_aluop_sub_logical_zext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2377.
        let expr0_0 = ALUOp::SubLogical64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sub_logical_reg.
pub fn constructor_sub_logical_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2380.
    let expr0_0 = constructor_aluop_sub_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_logical_reg_zext32.
pub fn constructor_sub_logical_reg_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2383.
    let expr0_0 = constructor_aluop_sub_logical_zext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_logical_zimm32.
pub fn constructor_sub_logical_zimm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2386.
    let expr0_0 = constructor_aluop_sub_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_ruimm32(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_logical_mem.
pub fn constructor_sub_logical_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2389.
    let expr0_0 = constructor_aluop_sub_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_logical_mem_zext32.
pub fn constructor_sub_logical_mem_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2392.
    let expr0_0 = constructor_aluop_sub_logical(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_mul.
pub fn constructor_aluop_mul<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 2398.
        let expr0_0 = ALUOp::Mul32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2399.
        let expr0_0 = ALUOp::Mul32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2400.
        let expr0_0 = ALUOp::Mul32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2401.
        let expr0_0 = ALUOp::Mul64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_mul_sext16.
pub fn constructor_aluop_mul_sext16<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2404.
        let expr0_0 = ALUOp::Mul32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2405.
        let expr0_0 = ALUOp::Mul32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2406.
        let expr0_0 = ALUOp::Mul64Ext16;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_mul_sext32.
pub fn constructor_aluop_mul_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2409.
        let expr0_0 = ALUOp::Mul64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term mul_reg.
pub fn constructor_mul_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2412.
    let expr0_0 = constructor_aluop_mul(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_reg_sext32.
pub fn constructor_mul_reg_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2415.
    let expr0_0 = constructor_aluop_mul_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_simm16.
pub fn constructor_mul_simm16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i16,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2418.
    let expr0_0 = constructor_aluop_mul(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rsimm16(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_simm32.
pub fn constructor_mul_simm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i32,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2421.
    let expr0_0 = constructor_aluop_mul(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rsimm32(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_mem.
pub fn constructor_mul_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2424.
    let expr0_0 = constructor_aluop_mul(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_mem_sext16.
pub fn constructor_mul_mem_sext16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2427.
    let expr0_0 = constructor_aluop_mul_sext16(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_mem_sext32.
pub fn constructor_mul_mem_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2430.
    let expr0_0 = constructor_aluop_mul_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term udivmod.
pub fn constructor_udivmod<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &RegPair,
    arg2: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2436.
        let expr0_0 = constructor_udivmod32(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2437.
        let expr0_0 = constructor_udivmod64(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sdivmod.
pub fn constructor_sdivmod<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &RegPair,
    arg2: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2443.
        let expr0_0 = constructor_sdivmod32(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2444.
        let expr0_0 = constructor_sdivmod64(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_and.
pub fn constructor_aluop_and<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2450.
        let expr0_0 = ALUOp::And32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2451.
        let expr0_0 = ALUOp::And64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term and_reg.
pub fn constructor_and_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2454.
    let expr0_0 = constructor_aluop_and(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term and_uimm16shifted.
pub fn constructor_and_uimm16shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: UImm16Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2457.
    let expr0_0 = constructor_aluop_and(ctx, pattern0_0)?;
    let expr1_0 =
        constructor_alu_ruimm16shifted(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term and_uimm32shifted.
pub fn constructor_and_uimm32shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: UImm32Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2460.
    let expr0_0 = constructor_aluop_and(ctx, pattern0_0)?;
    let expr1_0 =
        constructor_alu_ruimm32shifted(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term and_mem.
pub fn constructor_and_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2463.
    let expr0_0 = constructor_aluop_and(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_or.
pub fn constructor_aluop_or<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2469.
        let expr0_0 = ALUOp::Orr32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2470.
        let expr0_0 = ALUOp::Orr64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term or_reg.
pub fn constructor_or_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2473.
    let expr0_0 = constructor_aluop_or(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term or_uimm16shifted.
pub fn constructor_or_uimm16shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: UImm16Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2476.
    let expr0_0 = constructor_aluop_or(ctx, pattern0_0)?;
    let expr1_0 =
        constructor_alu_ruimm16shifted(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term or_uimm32shifted.
pub fn constructor_or_uimm32shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: UImm32Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2479.
    let expr0_0 = constructor_aluop_or(ctx, pattern0_0)?;
    let expr1_0 =
        constructor_alu_ruimm32shifted(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term or_mem.
pub fn constructor_or_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2482.
    let expr0_0 = constructor_aluop_or(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_xor.
pub fn constructor_aluop_xor<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2488.
        let expr0_0 = ALUOp::Xor32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2489.
        let expr0_0 = ALUOp::Xor64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term xor_reg.
pub fn constructor_xor_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2492.
    let expr0_0 = constructor_aluop_xor(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xor_uimm32shifted.
pub fn constructor_xor_uimm32shifted<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: UImm32Shifted,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2495.
    let expr0_0 = constructor_aluop_xor(ctx, pattern0_0)?;
    let expr1_0 =
        constructor_alu_ruimm32shifted(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xor_mem.
pub fn constructor_xor_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2498.
    let expr0_0 = constructor_aluop_xor(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rx(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term not_reg.
pub fn constructor_not_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2504.
        let expr0_0: u32 = 4294967295;
        let expr1_0: u8 = 0;
        let expr2_0 = C::uimm32shifted(ctx, expr0_0, expr1_0);
        let expr3_0 = constructor_xor_uimm32shifted(ctx, pattern1_0, pattern2_0, expr2_0)?;
        return Some(expr3_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/inst.isle line 2506.
        let expr0_0: u32 = 4294967295;
        let expr1_0: u8 = 0;
        let expr2_0 = C::uimm32shifted(ctx, expr0_0, expr1_0);
        let expr3_0 = constructor_xor_uimm32shifted(ctx, pattern1_0, pattern2_0, expr2_0)?;
        let expr4_0: u32 = 4294967295;
        let expr5_0: u8 = 32;
        let expr6_0 = C::uimm32shifted(ctx, expr4_0, expr5_0);
        let expr7_0 = constructor_xor_uimm32shifted(ctx, pattern1_0, expr3_0, expr6_0)?;
        return Some(expr7_0);
    }
    return None;
}

// Generated as internal constructor for term aluop_and_not.
pub fn constructor_aluop_and_not<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2515.
        let expr0_0 = ALUOp::AndNot32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2516.
        let expr0_0 = ALUOp::AndNot64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term and_not_reg.
pub fn constructor_and_not_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2519.
    let expr0_0 = constructor_aluop_and_not(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_or_not.
pub fn constructor_aluop_or_not<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2525.
        let expr0_0 = ALUOp::OrrNot32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2526.
        let expr0_0 = ALUOp::OrrNot64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term or_not_reg.
pub fn constructor_or_not_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2529.
    let expr0_0 = constructor_aluop_or_not(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term aluop_xor_not.
pub fn constructor_aluop_xor_not<C: Context>(ctx: &mut C, arg0: Type) -> Option<ALUOp> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2535.
        let expr0_0 = ALUOp::XorNot32;
        return Some(expr0_0);
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        // Rule at src/isa/s390x/inst.isle line 2536.
        let expr0_0 = ALUOp::XorNot64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term xor_not_reg.
pub fn constructor_xor_not_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2539.
    let expr0_0 = constructor_aluop_xor_not(ctx, pattern0_0)?;
    let expr1_0 = constructor_alu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term unaryop_abs.
pub fn constructor_unaryop_abs<C: Context>(ctx: &mut C, arg0: Type) -> Option<UnaryOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2545.
        let expr0_0 = UnaryOp::Abs32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2546.
        let expr0_0 = UnaryOp::Abs64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term unaryop_abs_sext32.
pub fn constructor_unaryop_abs_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<UnaryOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2549.
        let expr0_0 = UnaryOp::Abs64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term abs_reg.
pub fn constructor_abs_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2552.
    let expr0_0 = constructor_unaryop_abs(ctx, pattern0_0)?;
    let expr1_0 = constructor_unary_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term abs_reg_sext32.
pub fn constructor_abs_reg_sext32<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2555.
    let expr0_0 = constructor_unaryop_abs_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_unary_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term unaryop_neg.
pub fn constructor_unaryop_neg<C: Context>(ctx: &mut C, arg0: Type) -> Option<UnaryOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 2561.
        let expr0_0 = UnaryOp::Neg32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2562.
        let expr0_0 = UnaryOp::Neg32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2563.
        let expr0_0 = UnaryOp::Neg32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2564.
        let expr0_0 = UnaryOp::Neg64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term unaryop_neg_sext32.
pub fn constructor_unaryop_neg_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<UnaryOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2567.
        let expr0_0 = UnaryOp::Neg64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term neg_reg.
pub fn constructor_neg_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2570.
    let expr0_0 = constructor_unaryop_neg(ctx, pattern0_0)?;
    let expr1_0 = constructor_unary_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term neg_reg_sext32.
pub fn constructor_neg_reg_sext32<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2573.
    let expr0_0 = constructor_unaryop_neg_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_unary_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term shiftop_rot.
pub fn constructor_shiftop_rot<C: Context>(ctx: &mut C, arg0: Type) -> Option<ShiftOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2579.
        let expr0_0 = ShiftOp::RotL32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2580.
        let expr0_0 = ShiftOp::RotL64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term rot_reg.
pub fn constructor_rot_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2583.
    let expr0_0 = constructor_shiftop_rot(ctx, pattern0_0)?;
    let expr1_0: u8 = 0;
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, expr1_0, pattern2_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term rot_imm.
pub fn constructor_rot_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2587.
    let expr0_0 = constructor_shiftop_rot(ctx, pattern0_0)?;
    let expr1_0 = C::zero_reg(ctx);
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term shiftop_lshl.
pub fn constructor_shiftop_lshl<C: Context>(ctx: &mut C, arg0: Type) -> Option<ShiftOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/inst.isle line 2594.
        let expr0_0 = ShiftOp::LShL32;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/inst.isle line 2595.
        let expr0_0 = ShiftOp::LShL32;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2596.
        let expr0_0 = ShiftOp::LShL32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2597.
        let expr0_0 = ShiftOp::LShL64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term lshl_reg.
pub fn constructor_lshl_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2600.
    let expr0_0 = constructor_shiftop_lshl(ctx, pattern0_0)?;
    let expr1_0: u8 = 0;
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, expr1_0, pattern2_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term lshl_imm.
pub fn constructor_lshl_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2604.
    let expr0_0 = constructor_shiftop_lshl(ctx, pattern0_0)?;
    let expr1_0 = C::zero_reg(ctx);
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term shiftop_lshr.
pub fn constructor_shiftop_lshr<C: Context>(ctx: &mut C, arg0: Type) -> Option<ShiftOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2611.
        let expr0_0 = ShiftOp::LShR32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2612.
        let expr0_0 = ShiftOp::LShR64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term lshr_reg.
pub fn constructor_lshr_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2615.
    let expr0_0 = constructor_shiftop_lshr(ctx, pattern0_0)?;
    let expr1_0: u8 = 0;
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, expr1_0, pattern2_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term lshr_imm.
pub fn constructor_lshr_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2619.
    let expr0_0 = constructor_shiftop_lshr(ctx, pattern0_0)?;
    let expr1_0 = C::zero_reg(ctx);
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term shiftop_ashr.
pub fn constructor_shiftop_ashr<C: Context>(ctx: &mut C, arg0: Type) -> Option<ShiftOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2626.
        let expr0_0 = ShiftOp::AShR32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2627.
        let expr0_0 = ShiftOp::AShR64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term ashr_reg.
pub fn constructor_ashr_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2630.
    let expr0_0 = constructor_shiftop_ashr(ctx, pattern0_0)?;
    let expr1_0: u8 = 0;
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, expr1_0, pattern2_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term ashr_imm.
pub fn constructor_ashr_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2634.
    let expr0_0 = constructor_shiftop_ashr(ctx, pattern0_0)?;
    let expr1_0 = C::zero_reg(ctx);
    let expr2_0 = constructor_shift_rr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0, expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term popcnt_byte.
pub fn constructor_popcnt_byte<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 2641.
    let expr0_0: Type = I64;
    let expr1_0 = UnaryOp::PopcntByte;
    let expr2_0 = constructor_unary_rr(ctx, expr0_0, &expr1_0, pattern0_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term popcnt_reg.
pub fn constructor_popcnt_reg<C: Context>(ctx: &mut C, arg0: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/inst.isle line 2644.
    let expr0_0: Type = I64;
    let expr1_0 = UnaryOp::PopcntReg;
    let expr2_0 = constructor_unary_rr(ctx, expr0_0, &expr1_0, pattern0_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term atomic_rmw_and.
pub fn constructor_atomic_rmw_and<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2650.
        let expr0_0: Type = I32;
        let expr1_0 = ALUOp::And32;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2651.
        let expr0_0: Type = I64;
        let expr1_0 = ALUOp::And64;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_or.
pub fn constructor_atomic_rmw_or<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2654.
        let expr0_0: Type = I32;
        let expr1_0 = ALUOp::Orr32;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2655.
        let expr0_0: Type = I64;
        let expr1_0 = ALUOp::Orr64;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_xor.
pub fn constructor_atomic_rmw_xor<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2658.
        let expr0_0: Type = I32;
        let expr1_0 = ALUOp::Xor32;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2659.
        let expr0_0: Type = I64;
        let expr1_0 = ALUOp::Xor64;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term atomic_rmw_add.
pub fn constructor_atomic_rmw_add<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2662.
        let expr0_0: Type = I32;
        let expr1_0 = ALUOp::Add32;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2663.
        let expr0_0: Type = I64;
        let expr1_0 = ALUOp::Add64;
        let expr2_0 = constructor_atomic_rmw_impl(ctx, expr0_0, &expr1_0, pattern2_0, pattern3_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term fpuop2_add.
pub fn constructor_fpuop2_add<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2669.
        let expr0_0 = FPUOp2::Add32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2670.
        let expr0_0 = FPUOp2::Add64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fadd_reg.
pub fn constructor_fadd_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2673.
    let expr0_0 = constructor_fpuop2_add(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop2_sub.
pub fn constructor_fpuop2_sub<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2679.
        let expr0_0 = FPUOp2::Sub32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2680.
        let expr0_0 = FPUOp2::Sub64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fsub_reg.
pub fn constructor_fsub_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2683.
    let expr0_0 = constructor_fpuop2_sub(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop2_mul.
pub fn constructor_fpuop2_mul<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2689.
        let expr0_0 = FPUOp2::Mul32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2690.
        let expr0_0 = FPUOp2::Mul64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fmul_reg.
pub fn constructor_fmul_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2693.
    let expr0_0 = constructor_fpuop2_mul(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop2_div.
pub fn constructor_fpuop2_div<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2699.
        let expr0_0 = FPUOp2::Div32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2700.
        let expr0_0 = FPUOp2::Div64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fdiv_reg.
pub fn constructor_fdiv_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2703.
    let expr0_0 = constructor_fpuop2_div(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop2_min.
pub fn constructor_fpuop2_min<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2709.
        let expr0_0 = FPUOp2::Min32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2710.
        let expr0_0 = FPUOp2::Min64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fmin_reg.
pub fn constructor_fmin_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2713.
    let expr0_0 = constructor_fpuop2_min(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpuvec_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop2_max.
pub fn constructor_fpuop2_max<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp2> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2719.
        let expr0_0 = FPUOp2::Max32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2720.
        let expr0_0 = FPUOp2::Max64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fmax_reg.
pub fn constructor_fmax_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2723.
    let expr0_0 = constructor_fpuop2_max(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpuvec_rrr(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop3_fma.
pub fn constructor_fpuop3_fma<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp3> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2729.
        let expr0_0 = FPUOp3::MAdd32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2730.
        let expr0_0 = FPUOp3::MAdd64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fma_reg.
pub fn constructor_fma_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
    arg3: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/inst.isle line 2733.
    let expr0_0 = constructor_fpuop3_fma(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rrrr(
        ctx, pattern0_0, &expr0_0, pattern3_0, pattern1_0, pattern2_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop1_sqrt.
pub fn constructor_fpuop1_sqrt<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp1> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2739.
        let expr0_0 = FPUOp1::Sqrt32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2740.
        let expr0_0 = FPUOp1::Sqrt64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sqrt_reg.
pub fn constructor_sqrt_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2743.
    let expr0_0 = constructor_fpuop1_sqrt(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop1_neg.
pub fn constructor_fpuop1_neg<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp1> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2749.
        let expr0_0 = FPUOp1::Neg32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2750.
        let expr0_0 = FPUOp1::Neg64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fneg_reg.
pub fn constructor_fneg_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2753.
    let expr0_0 = constructor_fpuop1_neg(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop1_abs.
pub fn constructor_fpuop1_abs<C: Context>(ctx: &mut C, arg0: Type) -> Option<FPUOp1> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2759.
        let expr0_0 = FPUOp1::Abs32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2760.
        let expr0_0 = FPUOp1::Abs64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term fabs_reg.
pub fn constructor_fabs_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2763.
    let expr0_0 = constructor_fpuop1_abs(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_rr(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuroundmode_ceil.
pub fn constructor_fpuroundmode_ceil<C: Context>(ctx: &mut C, arg0: Type) -> Option<FpuRoundMode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2769.
        let expr0_0 = FpuRoundMode::Plus32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2770.
        let expr0_0 = FpuRoundMode::Plus64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term ceil_reg.
pub fn constructor_ceil_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2773.
    let expr0_0 = constructor_fpuroundmode_ceil(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_round(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuroundmode_floor.
pub fn constructor_fpuroundmode_floor<C: Context>(ctx: &mut C, arg0: Type) -> Option<FpuRoundMode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2779.
        let expr0_0 = FpuRoundMode::Minus32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2780.
        let expr0_0 = FpuRoundMode::Minus64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term floor_reg.
pub fn constructor_floor_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2783.
    let expr0_0 = constructor_fpuroundmode_floor(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_round(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuroundmode_trunc.
pub fn constructor_fpuroundmode_trunc<C: Context>(ctx: &mut C, arg0: Type) -> Option<FpuRoundMode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2789.
        let expr0_0 = FpuRoundMode::Zero32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2790.
        let expr0_0 = FpuRoundMode::Zero64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term trunc_reg.
pub fn constructor_trunc_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2793.
    let expr0_0 = constructor_fpuroundmode_trunc(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_round(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuroundmode_nearest.
pub fn constructor_fpuroundmode_nearest<C: Context>(
    ctx: &mut C,
    arg0: Type,
) -> Option<FpuRoundMode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        // Rule at src/isa/s390x/inst.isle line 2799.
        let expr0_0 = FpuRoundMode::Nearest32;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        // Rule at src/isa/s390x/inst.isle line 2800.
        let expr0_0 = FpuRoundMode::Nearest64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term nearest_reg.
pub fn constructor_nearest_reg<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/s390x/inst.isle line 2803.
    let expr0_0 = constructor_fpuroundmode_nearest(ctx, pattern0_0)?;
    let expr1_0 = constructor_fpu_round(ctx, pattern0_0, &expr0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop1_promote.
pub fn constructor_fpuop1_promote<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<FPUOp1> {
    let pattern0_0 = arg0;
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        if pattern2_0 == F32 {
            // Rule at src/isa/s390x/inst.isle line 2809.
            let expr0_0 = FPUOp1::Cvt32To64;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fpromote_reg.
pub fn constructor_fpromote_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2812.
    let expr0_0 = constructor_fpuop1_promote(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_fpu_rr(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpuop1_demote.
pub fn constructor_fpuop1_demote<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<FPUOp1> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        if pattern2_0 == F64 {
            // Rule at src/isa/s390x/inst.isle line 2819.
            let expr0_0 = FPUOp1::Cvt64To32;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fdemote_reg.
pub fn constructor_fdemote_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2822.
    let expr0_0 = constructor_fpuop1_demote(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_fpu_rr(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term uint_to_fpu_op.
pub fn constructor_uint_to_fpu_op<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<IntToFpuOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        if pattern2_0 == I32 {
            // Rule at src/isa/s390x/inst.isle line 2829.
            let expr0_0 = IntToFpuOp::U32ToF32;
            return Some(expr0_0);
        }
        if pattern2_0 == I64 {
            // Rule at src/isa/s390x/inst.isle line 2831.
            let expr0_0 = IntToFpuOp::U64ToF32;
            return Some(expr0_0);
        }
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        if pattern2_0 == I32 {
            // Rule at src/isa/s390x/inst.isle line 2830.
            let expr0_0 = IntToFpuOp::U32ToF64;
            return Some(expr0_0);
        }
        if pattern2_0 == I64 {
            // Rule at src/isa/s390x/inst.isle line 2832.
            let expr0_0 = IntToFpuOp::U64ToF64;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fcvt_from_uint_reg.
pub fn constructor_fcvt_from_uint_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2835.
    let expr0_0 = constructor_uint_to_fpu_op(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_int_to_fpu(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sint_to_fpu_op.
pub fn constructor_sint_to_fpu_op<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<IntToFpuOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        if pattern2_0 == I32 {
            // Rule at src/isa/s390x/inst.isle line 2842.
            let expr0_0 = IntToFpuOp::I32ToF32;
            return Some(expr0_0);
        }
        if pattern2_0 == I64 {
            // Rule at src/isa/s390x/inst.isle line 2844.
            let expr0_0 = IntToFpuOp::I64ToF32;
            return Some(expr0_0);
        }
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        if pattern2_0 == I32 {
            // Rule at src/isa/s390x/inst.isle line 2843.
            let expr0_0 = IntToFpuOp::I32ToF64;
            return Some(expr0_0);
        }
        if pattern2_0 == I64 {
            // Rule at src/isa/s390x/inst.isle line 2845.
            let expr0_0 = IntToFpuOp::I64ToF64;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fcvt_from_sint_reg.
pub fn constructor_fcvt_from_sint_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2848.
    let expr0_0 = constructor_sint_to_fpu_op(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_int_to_fpu(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_to_uint_op.
pub fn constructor_fpu_to_uint_op<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<FpuToIntOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        if pattern2_0 == F32 {
            // Rule at src/isa/s390x/inst.isle line 2855.
            let expr0_0 = FpuToIntOp::F32ToU32;
            return Some(expr0_0);
        }
        if pattern2_0 == F64 {
            // Rule at src/isa/s390x/inst.isle line 2856.
            let expr0_0 = FpuToIntOp::F64ToU32;
            return Some(expr0_0);
        }
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        if pattern2_0 == F32 {
            // Rule at src/isa/s390x/inst.isle line 2857.
            let expr0_0 = FpuToIntOp::F32ToU64;
            return Some(expr0_0);
        }
        if pattern2_0 == F64 {
            // Rule at src/isa/s390x/inst.isle line 2858.
            let expr0_0 = FpuToIntOp::F64ToU64;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fcvt_to_uint_reg_with_flags.
pub fn constructor_fcvt_to_uint_reg_with_flags<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2861.
    let expr0_0 = constructor_fpu_to_uint_op(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_fpu_to_int(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fcvt_to_uint_reg.
pub fn constructor_fcvt_to_uint_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2865.
    let expr0_0 = constructor_fcvt_to_uint_reg_with_flags(ctx, pattern0_0, pattern1_0, pattern2_0)?;
    let expr1_0 = constructor_drop_flags(ctx, &expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fpu_to_sint_op.
pub fn constructor_fpu_to_sint_op<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
) -> Option<FpuToIntOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        if pattern2_0 == F32 {
            // Rule at src/isa/s390x/inst.isle line 2872.
            let expr0_0 = FpuToIntOp::F32ToI32;
            return Some(expr0_0);
        }
        if pattern2_0 == F64 {
            // Rule at src/isa/s390x/inst.isle line 2873.
            let expr0_0 = FpuToIntOp::F64ToI32;
            return Some(expr0_0);
        }
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        if pattern2_0 == F32 {
            // Rule at src/isa/s390x/inst.isle line 2874.
            let expr0_0 = FpuToIntOp::F32ToI64;
            return Some(expr0_0);
        }
        if pattern2_0 == F64 {
            // Rule at src/isa/s390x/inst.isle line 2875.
            let expr0_0 = FpuToIntOp::F64ToI64;
            return Some(expr0_0);
        }
    }
    return None;
}

// Generated as internal constructor for term fcvt_to_sint_reg_with_flags.
pub fn constructor_fcvt_to_sint_reg_with_flags<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2878.
    let expr0_0 = constructor_fpu_to_sint_op(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_fpu_to_int(ctx, pattern0_0, &expr0_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fcvt_to_sint_reg.
pub fn constructor_fcvt_to_sint_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2882.
    let expr0_0 = constructor_fcvt_to_sint_reg_with_flags(ctx, pattern0_0, pattern1_0, pattern2_0)?;
    let expr1_0 = constructor_drop_flags(ctx, &expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmpop_cmps.
pub fn constructor_cmpop_cmps<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2889.
        let expr0_0 = CmpOp::CmpS32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2890.
        let expr0_0 = CmpOp::CmpS64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term cmpop_cmps_sext16.
pub fn constructor_cmpop_cmps_sext16<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2893.
        let expr0_0 = CmpOp::CmpS32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2894.
        let expr0_0 = CmpOp::CmpS64Ext16;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term cmpop_cmps_sext32.
pub fn constructor_cmpop_cmps_sext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2897.
        let expr0_0 = CmpOp::CmpS64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term icmps_reg.
pub fn constructor_icmps_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2900.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rr(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_reg_sext32.
pub fn constructor_icmps_reg_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2903.
    let expr0_0 = constructor_cmpop_cmps_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rr(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_simm16.
pub fn constructor_icmps_simm16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i16,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2906.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rsimm16(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_simm32.
pub fn constructor_icmps_simm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: i32,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2909.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rsimm32(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_mem.
pub fn constructor_icmps_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2912.
    let expr0_0 = constructor_cmpop_cmps(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_mem_sext16.
pub fn constructor_icmps_mem_sext16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2915.
    let expr0_0 = constructor_cmpop_cmps_sext16(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmps_mem_sext32.
pub fn constructor_icmps_mem_sext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2918.
    let expr0_0 = constructor_cmpop_cmps_sext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmpop_cmpu.
pub fn constructor_cmpop_cmpu<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2924.
        let expr0_0 = CmpOp::CmpL32;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2925.
        let expr0_0 = CmpOp::CmpL64;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term cmpop_cmpu_zext16.
pub fn constructor_cmpop_cmpu_zext16<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/inst.isle line 2928.
        let expr0_0 = CmpOp::CmpL32Ext16;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2929.
        let expr0_0 = CmpOp::CmpL64Ext16;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term cmpop_cmpu_zext32.
pub fn constructor_cmpop_cmpu_zext32<C: Context>(ctx: &mut C, arg0: Type) -> Option<CmpOp> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/inst.isle line 2932.
        let expr0_0 = CmpOp::CmpL64Ext32;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term icmpu_reg.
pub fn constructor_icmpu_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2935.
    let expr0_0 = constructor_cmpop_cmpu(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rr(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmpu_reg_zext32.
pub fn constructor_icmpu_reg_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2938.
    let expr0_0 = constructor_cmpop_cmpu_zext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rr(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmpu_uimm32.
pub fn constructor_icmpu_uimm32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: u32,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2941.
    let expr0_0 = constructor_cmpop_cmpu(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_ruimm32(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmpu_mem.
pub fn constructor_icmpu_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2944.
    let expr0_0 = constructor_cmpop_cmpu(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmpu_mem_zext16.
pub fn constructor_icmpu_mem_zext16<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2947.
    let expr0_0 = constructor_cmpop_cmpu_zext16(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term icmpu_mem_zext32.
pub fn constructor_icmpu_mem_zext32<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &MemArg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/s390x/inst.isle line 2950.
    let expr0_0 = constructor_cmpop_cmpu_zext32(ctx, pattern0_0)?;
    let expr1_0 = constructor_cmp_rx(ctx, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term fcmp_reg.
pub fn constructor_fcmp_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2956.
        let expr0_0 = constructor_fpu_cmp32(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/inst.isle line 2957.
        let expr0_0 = constructor_fpu_cmp64(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term lower.
pub fn constructor_lower<C: Context>(ctx: &mut C, arg0: Inst) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    match &pattern1_0 {
        &InstructionData::NullAry {
            opcode: ref pattern2_0,
        } => {
            match &pattern2_0 {
                &Opcode::Debugtrap => {
                    // Rule at src/isa/s390x/lower.isle line 1892.
                    let expr0_0 = constructor_debugtrap_impl(ctx)?;
                    let expr1_0 = constructor_value_regs_none(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                &Opcode::Nop => {
                    // Rule at src/isa/s390x/lower.isle line 47.
                    let expr0_0 = C::invalid_reg(ctx);
                    let expr1_0 = C::value_reg(ctx, expr0_0);
                    return Some(expr1_0);
                }
                &Opcode::Fence => {
                    // Rule at src/isa/s390x/lower.isle line 1605.
                    let expr0_0 = constructor_fence_impl(ctx)?;
                    let expr1_0 = constructor_value_regs_none(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                _ => {}
            }
        }
        &InstructionData::FuncAddr {
            opcode: ref pattern2_0,
            func_ref: pattern2_1,
        } => {
            if let &Opcode::FuncAddr = &pattern2_0 {
                if let Some((pattern4_0, pattern4_1)) = C::call_target_data(ctx, pattern0_0) {
                    if let Some(()) = C::reloc_distance_near(ctx, &pattern4_1) {
                        // Rule at src/isa/s390x/lower.isle line 1159.
                        let expr0_0: i32 = 0;
                        let expr1_0 = C::memflags_trusted(ctx);
                        let expr2_0 = C::memarg_symbol(ctx, pattern4_0, expr0_0, expr1_0);
                        let expr3_0 = constructor_load_addr(ctx, &expr2_0)?;
                        let expr4_0 = C::value_reg(ctx, expr3_0);
                        return Some(expr4_0);
                    }
                    // Rule at src/isa/s390x/lower.isle line 1164.
                    let expr0_0: i64 = 0;
                    let expr1_0 = constructor_load_ext_name_far(ctx, pattern4_0, expr0_0)?;
                    let expr2_0 = C::value_reg(ctx, expr1_0);
                    return Some(expr2_0);
                }
            }
        }
        &InstructionData::UnaryGlobalValue {
            opcode: ref pattern2_0,
            global_value: pattern2_1,
        } => {
            if let &Opcode::SymbolValue = &pattern2_0 {
                if let Some((pattern4_0, pattern4_1, pattern4_2)) =
                    C::symbol_value_data(ctx, pattern0_0)
                {
                    if let Some(()) = C::reloc_distance_near(ctx, &pattern4_1) {
                        let pattern6_0 = 0;
                        if let Some(pattern7_0) =
                            C::memarg_symbol_offset_sum(ctx, pattern4_2, pattern6_0)
                        {
                            // Rule at src/isa/s390x/lower.isle line 1172.
                            let expr0_0 = C::memflags_trusted(ctx);
                            let expr1_0 = C::memarg_symbol(ctx, pattern4_0, pattern7_0, expr0_0);
                            let expr2_0 = constructor_load_addr(ctx, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                    }
                    // Rule at src/isa/s390x/lower.isle line 1178.
                    let expr0_0 = constructor_load_ext_name_far(ctx, pattern4_0, pattern4_2)?;
                    let expr1_0 = C::value_reg(ctx, expr0_0);
                    return Some(expr1_0);
                }
            }
        }
        &InstructionData::UnaryIeee32 {
            opcode: ref pattern2_0,
            imm: pattern2_1,
        } => {
            if let &Opcode::F32const = &pattern2_0 {
                let pattern4_0 = C::u64_from_ieee32(ctx, pattern2_1);
                // Rule at src/isa/s390x/lower.isle line 29.
                let expr0_0: Type = F32;
                let expr1_0 = constructor_imm(ctx, expr0_0, pattern4_0)?;
                let expr2_0 = C::value_reg(ctx, expr1_0);
                return Some(expr2_0);
            }
        }
        &InstructionData::UnaryIeee64 {
            opcode: ref pattern2_0,
            imm: pattern2_1,
        } => {
            if let &Opcode::F64const = &pattern2_0 {
                let pattern4_0 = C::u64_from_ieee64(ctx, pattern2_1);
                // Rule at src/isa/s390x/lower.isle line 35.
                let expr0_0: Type = F64;
                let expr1_0 = constructor_imm(ctx, expr0_0, pattern4_0)?;
                let expr2_0 = C::value_reg(ctx, expr1_0);
                return Some(expr2_0);
            }
        }
        &InstructionData::Trap {
            opcode: ref pattern2_0,
            code: ref pattern2_1,
        } => {
            match &pattern2_0 {
                &Opcode::Trap => {
                    // Rule at src/isa/s390x/lower.isle line 1862.
                    let expr0_0 = constructor_trap_impl(ctx, &pattern2_1)?;
                    let expr1_0 = constructor_safepoint(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                &Opcode::ResumableTrap => {
                    // Rule at src/isa/s390x/lower.isle line 1868.
                    let expr0_0 = constructor_trap_impl(ctx, &pattern2_1)?;
                    let expr1_0 = constructor_safepoint(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                _ => {}
            }
        }
        &InstructionData::StoreNoOffset {
            opcode: ref pattern2_0,
            args: ref pattern2_1,
            flags: pattern2_2,
        } => {
            if let &Opcode::AtomicStore = &pattern2_0 {
                let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, &pattern2_1);
                let pattern5_0 = C::value_type(ctx, pattern4_0);
                if pattern5_0 == I8 {
                    // Rule at src/isa/s390x/lower.isle line 1586.
                    let expr0_0 = C::zero_offset(ctx);
                    let expr1_0 =
                        constructor_istore8_impl(ctx, pattern2_2, pattern4_0, pattern4_1, expr0_0)?;
                    let expr2_0 = constructor_atomic_store_impl(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
                if pattern5_0 == I16 {
                    // Rule at src/isa/s390x/lower.isle line 1590.
                    let expr0_0 = C::zero_offset(ctx);
                    let expr1_0 = constructor_istore16_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, expr0_0,
                    )?;
                    let expr2_0 = constructor_atomic_store_impl(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
                if pattern5_0 == I32 {
                    // Rule at src/isa/s390x/lower.isle line 1594.
                    let expr0_0 = C::zero_offset(ctx);
                    let expr1_0 = constructor_istore32_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, expr0_0,
                    )?;
                    let expr2_0 = constructor_atomic_store_impl(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
                if pattern5_0 == I64 {
                    // Rule at src/isa/s390x/lower.isle line 1598.
                    let expr0_0 = C::zero_offset(ctx);
                    let expr1_0 = constructor_istore64_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, expr0_0,
                    )?;
                    let expr2_0 = constructor_atomic_store_impl(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
            }
        }
        &InstructionData::Store {
            opcode: ref pattern2_0,
            args: ref pattern2_1,
            flags: pattern2_2,
            offset: pattern2_3,
        } => {
            match &pattern2_0 {
                &Opcode::Store => {
                    let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, &pattern2_1);
                    let pattern5_0 = C::value_type(ctx, pattern4_0);
                    if pattern5_0 == I8 {
                        // Rule at src/isa/s390x/lower.isle line 1358.
                        let expr0_0 = constructor_istore8_impl(
                            ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                        )?;
                        let expr1_0 = constructor_value_regs_none(ctx, &expr0_0)?;
                        return Some(expr1_0);
                    }
                    if pattern5_0 == I16 {
                        // Rule at src/isa/s390x/lower.isle line 1362.
                        let expr0_0 = constructor_istore16_impl(
                            ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                        )?;
                        let expr1_0 = constructor_value_regs_none(ctx, &expr0_0)?;
                        return Some(expr1_0);
                    }
                    if pattern5_0 == I32 {
                        // Rule at src/isa/s390x/lower.isle line 1366.
                        let expr0_0 = constructor_istore32_impl(
                            ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                        )?;
                        let expr1_0 = constructor_value_regs_none(ctx, &expr0_0)?;
                        return Some(expr1_0);
                    }
                    if pattern5_0 == I64 {
                        // Rule at src/isa/s390x/lower.isle line 1370.
                        let expr0_0 = constructor_istore64_impl(
                            ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                        )?;
                        let expr1_0 = constructor_value_regs_none(ctx, &expr0_0)?;
                        return Some(expr1_0);
                    }
                    if pattern5_0 == R64 {
                        // Rule at src/isa/s390x/lower.isle line 1374.
                        let expr0_0 = constructor_istore64_impl(
                            ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                        )?;
                        let expr1_0 = constructor_value_regs_none(ctx, &expr0_0)?;
                        return Some(expr1_0);
                    }
                    if pattern5_0 == F32 {
                        if let Some(()) = C::bigendian(ctx, pattern2_2) {
                            // Rule at src/isa/s390x/lower.isle line 1378.
                            let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern2_2, pattern4_1, pattern2_3)?;
                            let expr2_0 = constructor_fpu_store32(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_value_regs_none(ctx, &expr2_0)?;
                            return Some(expr3_0);
                        }
                        if let Some(()) = C::vxrs_ext2_enabled(ctx, pattern5_0) {
                            if let Some(()) = C::littleendian(ctx, pattern2_2) {
                                // Rule at src/isa/s390x/lower.isle line 1384.
                                let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern2_2, pattern4_1, pattern2_3,
                                )?;
                                let expr2_0 = constructor_fpu_storerev32(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_value_regs_none(ctx, &expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                        if let Some(()) = C::vxrs_ext2_disabled(ctx, pattern5_0) {
                            if let Some(()) = C::littleendian(ctx, pattern2_2) {
                                // Rule at src/isa/s390x/lower.isle line 1390.
                                let expr0_0: Type = I64;
                                let expr1_0 = C::put_in_reg(ctx, pattern4_0);
                                let expr2_0 = constructor_mov_from_fpr(ctx, expr1_0)?;
                                let expr3_0: u8 = 32;
                                let expr4_0 = constructor_lshr_imm(ctx, expr0_0, expr2_0, expr3_0)?;
                                let expr5_0 = constructor_lower_address(
                                    ctx, pattern2_2, pattern4_1, pattern2_3,
                                )?;
                                let expr6_0 = constructor_storerev32(ctx, expr4_0, &expr5_0)?;
                                let expr7_0 = constructor_value_regs_none(ctx, &expr6_0)?;
                                return Some(expr7_0);
                            }
                        }
                    }
                    if pattern5_0 == F64 {
                        if let Some(()) = C::bigendian(ctx, pattern2_2) {
                            // Rule at src/isa/s390x/lower.isle line 1396.
                            let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern2_2, pattern4_1, pattern2_3)?;
                            let expr2_0 = constructor_fpu_store64(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_value_regs_none(ctx, &expr2_0)?;
                            return Some(expr3_0);
                        }
                        if let Some(()) = C::vxrs_ext2_enabled(ctx, pattern5_0) {
                            if let Some(()) = C::littleendian(ctx, pattern2_2) {
                                // Rule at src/isa/s390x/lower.isle line 1402.
                                let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern2_2, pattern4_1, pattern2_3,
                                )?;
                                let expr2_0 = constructor_fpu_storerev64(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_value_regs_none(ctx, &expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                        if let Some(()) = C::vxrs_ext2_disabled(ctx, pattern5_0) {
                            if let Some(()) = C::littleendian(ctx, pattern2_2) {
                                // Rule at src/isa/s390x/lower.isle line 1408.
                                let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                                let expr1_0 = constructor_mov_from_fpr(ctx, expr0_0)?;
                                let expr2_0 = constructor_lower_address(
                                    ctx, pattern2_2, pattern4_1, pattern2_3,
                                )?;
                                let expr3_0 = constructor_storerev64(ctx, expr1_0, &expr2_0)?;
                                let expr4_0 = constructor_value_regs_none(ctx, &expr3_0)?;
                                return Some(expr4_0);
                            }
                        }
                    }
                }
                &Opcode::Istore8 => {
                    let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, &pattern2_1);
                    // Rule at src/isa/s390x/lower.isle line 1417.
                    let expr0_0 = constructor_istore8_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                    )?;
                    let expr1_0 = constructor_value_regs_none(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                &Opcode::Istore16 => {
                    let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, &pattern2_1);
                    // Rule at src/isa/s390x/lower.isle line 1435.
                    let expr0_0 = constructor_istore16_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                    )?;
                    let expr1_0 = constructor_value_regs_none(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                &Opcode::Istore32 => {
                    let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, &pattern2_1);
                    // Rule at src/isa/s390x/lower.isle line 1461.
                    let expr0_0 = constructor_istore32_impl(
                        ctx, pattern2_2, pattern4_0, pattern4_1, pattern2_3,
                    )?;
                    let expr1_0 = constructor_value_regs_none(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                _ => {}
            }
        }
        &InstructionData::Unary {
            opcode: ref pattern2_0,
            arg: pattern2_1,
        } => {
            match &pattern2_0 {
                &Opcode::Copy => {
                    // Rule at src/isa/s390x/lower.isle line 53.
                    let expr0_0 = C::put_in_reg(ctx, pattern2_1);
                    let expr1_0 = C::value_reg(ctx, expr0_0);
                    return Some(expr1_0);
                }
                &Opcode::Breduce => {
                    // Rule at src/isa/s390x/lower.isle line 752.
                    let expr0_0 = C::put_in_reg(ctx, pattern2_1);
                    let expr1_0 = C::value_reg(ctx, expr0_0);
                    return Some(expr1_0);
                }
                &Opcode::Ireduce => {
                    // Rule at src/isa/s390x/lower.isle line 596.
                    let expr0_0 = C::put_in_reg(ctx, pattern2_1);
                    let expr1_0 = C::value_reg(ctx, expr0_0);
                    return Some(expr1_0);
                }
                _ => {}
            }
        }
        &InstructionData::IntCondTrap {
            opcode: ref pattern2_0,
            arg: pattern2_1,
            cond: ref pattern2_2,
            code: ref pattern2_3,
        } => {
            if let &Opcode::Trapif = &pattern2_0 {
                if let Some(pattern4_0) = C::def_inst(ctx, pattern2_1) {
                    let pattern5_0 = C::inst_data(ctx, pattern4_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern6_0,
                        args: ref pattern6_1,
                    } = &pattern5_0
                    {
                        match &pattern6_0 {
                            &Opcode::Ifcmp => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, &pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 1904.
                                let expr0_0: bool = false;
                                let expr1_0 = constructor_icmp_val(
                                    ctx,
                                    expr0_0,
                                    &pattern2_2,
                                    pattern8_0,
                                    pattern8_1,
                                )?;
                                let expr2_0 = constructor_trap_if_bool(ctx, &expr1_0, &pattern2_3)?;
                                let expr3_0 = constructor_safepoint(ctx, &expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::IaddIfcout => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, &pattern6_1);
                                if let &IntCC::UnsignedGreaterThan = &pattern2_2 {
                                    // Rule at src/isa/s390x/lower.isle line 1929.
                                    let expr0_0: u8 = 3;
                                    let expr1_0 = C::mask_as_cond(ctx, expr0_0);
                                    let expr2_0 =
                                        constructor_trap_if_impl(ctx, &expr1_0, &pattern2_3)?;
                                    let expr3_0 = constructor_value_regs_none(ctx, &expr2_0)?;
                                    return Some(expr3_0);
                                }
                            }
                            _ => {}
                        }
                    }
                }
            }
        }
        &InstructionData::CondTrap {
            opcode: ref pattern2_0,
            arg: pattern2_1,
            code: ref pattern2_2,
        } => {
            match &pattern2_0 {
                &Opcode::Trapz => {
                    // Rule at src/isa/s390x/lower.isle line 1874.
                    let expr0_0 = constructor_value_nonzero(ctx, pattern2_1)?;
                    let expr1_0 = constructor_invert_bool(ctx, &expr0_0)?;
                    let expr2_0 = constructor_trap_if_bool(ctx, &expr1_0, &pattern2_2)?;
                    let expr3_0 = constructor_safepoint(ctx, &expr2_0)?;
                    return Some(expr3_0);
                }
                &Opcode::Trapnz => {
                    // Rule at src/isa/s390x/lower.isle line 1880.
                    let expr0_0 = constructor_value_nonzero(ctx, pattern2_1)?;
                    let expr1_0 = constructor_trap_if_bool(ctx, &expr0_0, &pattern2_2)?;
                    let expr2_0 = constructor_safepoint(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
                &Opcode::ResumableTrapnz => {
                    // Rule at src/isa/s390x/lower.isle line 1886.
                    let expr0_0 = constructor_value_nonzero(ctx, pattern2_1)?;
                    let expr1_0 = constructor_trap_if_bool(ctx, &expr0_0, &pattern2_2)?;
                    let expr2_0 = constructor_safepoint(ctx, &expr1_0)?;
                    return Some(expr2_0);
                }
                _ => {}
            }
        }
        _ => {}
    }
    if let Some(pattern1_0) = C::first_result(ctx, pattern0_0) {
        let pattern2_0 = C::value_type(ctx, pattern1_0);
        if pattern2_0 == B1 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                match &pattern5_0 {
                    &Opcode::IsNull => {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == R64 {
                            // Rule at src/isa/s390x/lower.isle line 1740.
                            let expr0_0: Type = B1;
                            let expr1_0: Type = I64;
                            let expr2_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr3_0: i16 = 0;
                            let expr4_0 = constructor_icmps_simm16(ctx, expr1_0, expr2_0, expr3_0)?;
                            let expr5_0 = IntCC::Equal;
                            let expr6_0 = C::intcc_as_cond(ctx, &expr5_0);
                            let expr7_0 = constructor_bool(ctx, &expr4_0, &expr6_0)?;
                            let expr8_0 = constructor_lower_bool(ctx, expr0_0, &expr7_0)?;
                            let expr9_0 = C::value_reg(ctx, expr8_0);
                            return Some(expr9_0);
                        }
                    }
                    &Opcode::IsInvalid => {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == R64 {
                            // Rule at src/isa/s390x/lower.isle line 1746.
                            let expr0_0: Type = B1;
                            let expr1_0: Type = I64;
                            let expr2_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr3_0: i16 = -1;
                            let expr4_0 = constructor_icmps_simm16(ctx, expr1_0, expr2_0, expr3_0)?;
                            let expr5_0 = IntCC::Equal;
                            let expr6_0 = C::intcc_as_cond(ctx, &expr5_0);
                            let expr7_0 = constructor_bool(ctx, &expr4_0, &expr6_0)?;
                            let expr8_0 = constructor_lower_bool(ctx, expr0_0, &expr7_0)?;
                            let expr9_0 = C::value_reg(ctx, expr8_0);
                            return Some(expr9_0);
                        }
                    }
                    _ => {}
                }
            }
        }
        if pattern2_0 == I8 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Popcnt = &pattern5_0 {
                        // Rule at src/isa/s390x/lower.isle line 884.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0 = constructor_popcnt_byte(ctx, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                }
                &InstructionData::LoadNoOffset {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicLoad = &pattern5_0 {
                        // Rule at src/isa/s390x/lower.isle line 1549.
                        let expr0_0: Type = I8;
                        let expr1_0 = C::zero_offset(ctx);
                        let expr2_0 =
                            constructor_lower_address(ctx, pattern5_2, pattern5_1, expr1_0)?;
                        let expr3_0 = constructor_zext32_mem(ctx, expr0_0, &expr2_0)?;
                        let expr4_0 = C::value_reg(ctx, expr3_0);
                        return Some(expr4_0);
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = &pattern5_0 {
                        // Rule at src/isa/s390x/lower.isle line 1186.
                        let expr0_0: Type = I8;
                        let expr1_0 =
                            constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                        let expr2_0 = constructor_zext32_mem(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = C::value_reg(ctx, expr2_0);
                        return Some(expr3_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I16 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::LoadNoOffset {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicLoad = &pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1557.
                            let expr0_0 = C::zero_offset(ctx);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr0_0)?;
                            let expr2_0 = constructor_loadrev16(ctx, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1553.
                            let expr0_0: Type = I16;
                            let expr1_0 = C::zero_offset(ctx);
                            let expr2_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr1_0)?;
                            let expr3_0 = constructor_zext32_mem(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = &pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1194.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_loadrev16(ctx, &expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1190.
                            let expr0_0: Type = I16;
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr2_0 = constructor_zext32_mem(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I32 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Umulhi => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 252.
                            let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_reg_zext64(ctx, pattern7_1)?;
                            let expr2_0: Type = I64;
                            let expr3_0 = constructor_mul_reg(ctx, expr2_0, expr0_0, expr1_0)?;
                            let expr4_0: Type = I64;
                            let expr5_0: u8 = 32;
                            let expr6_0 = constructor_lshr_imm(ctx, expr4_0, expr3_0, expr5_0)?;
                            let expr7_0 = C::value_reg(ctx, expr6_0);
                            return Some(expr7_0);
                        }
                        &Opcode::Smulhi => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 274.
                            let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_reg_sext64(ctx, pattern7_1)?;
                            let expr2_0: Type = I64;
                            let expr3_0 = constructor_mul_reg(ctx, expr2_0, expr0_0, expr1_0)?;
                            let expr4_0: Type = I64;
                            let expr5_0: u8 = 32;
                            let expr6_0 = constructor_ashr_imm(ctx, expr4_0, expr3_0, expr5_0)?;
                            let expr7_0 = C::value_reg(ctx, expr6_0);
                            return Some(expr7_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::AtomicCas {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicCas = &pattern5_0 {
                        let (pattern7_0, pattern7_1, pattern7_2) =
                            C::unpack_value_array_3(ctx, &pattern5_1);
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1534.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_2);
                            let expr2_0 = C::zero_offset(ctx);
                            let expr3_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern7_0, expr2_0)?;
                            let expr4_0 =
                                constructor_atomic_cas32(ctx, expr0_0, expr1_0, &expr3_0)?;
                            let expr5_0 = C::value_reg(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bitcast = &pattern5_0 {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == F32 {
                            // Rule at src/isa/s390x/lower.isle line 1145.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr2_0 = constructor_mov_from_fpr(ctx, expr1_0)?;
                            let expr3_0: u8 = 32;
                            let expr4_0 = constructor_lshr_imm(ctx, expr0_0, expr2_0, expr3_0)?;
                            let expr5_0 = C::value_reg(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                    }
                }
                &InstructionData::LoadNoOffset {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicLoad = &pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1565.
                            let expr0_0 = C::zero_offset(ctx);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr0_0)?;
                            let expr2_0 = constructor_loadrev32(ctx, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1561.
                            let expr0_0 = C::zero_offset(ctx);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr0_0)?;
                            let expr2_0 = constructor_load32(ctx, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = &pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1202.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_loadrev32(ctx, &expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1198.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_load32(ctx, &expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I64 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Umulhi => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 259.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_umul_wide(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = I64;
                            let expr4_0 = constructor_regpair_hi(ctx, &expr2_0)?;
                            let expr5_0 = constructor_copy_reg(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = C::value_reg(ctx, expr5_0);
                            return Some(expr6_0);
                        }
                        &Opcode::Smulhi => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 281.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_smul_wide(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = I64;
                            let expr4_0 = constructor_regpair_hi(ctx, &expr2_0)?;
                            let expr5_0 = constructor_copy_reg(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = C::value_reg(ctx, expr5_0);
                            return Some(expr6_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::AtomicCas {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicCas = &pattern5_0 {
                        let (pattern7_0, pattern7_1, pattern7_2) =
                            C::unpack_value_array_3(ctx, &pattern5_1);
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1539.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_2);
                            let expr2_0 = C::zero_offset(ctx);
                            let expr3_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern7_0, expr2_0)?;
                            let expr4_0 =
                                constructor_atomic_cas64(ctx, expr0_0, expr1_0, &expr3_0)?;
                            let expr5_0 = C::value_reg(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bitcast = &pattern5_0 {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == F64 {
                            // Rule at src/isa/s390x/lower.isle line 1135.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_mov_from_fpr(ctx, expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                }
                &InstructionData::LoadNoOffset {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                } => {
                    if let &Opcode::AtomicLoad = &pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1573.
                            let expr0_0 = C::zero_offset(ctx);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr0_0)?;
                            let expr2_0 = constructor_loadrev64(ctx, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1569.
                            let expr0_0 = C::zero_offset(ctx);
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, expr0_0)?;
                            let expr2_0 = constructor_load64(ctx, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = &pattern5_0 {
                        if let Some(()) = C::littleendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1210.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_loadrev64(ctx, &expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1206.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_load64(ctx, &expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == R64 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Load {
                opcode: ref pattern5_0,
                arg: pattern5_1,
                flags: pattern5_2,
                offset: pattern5_3,
            } = &pattern4_0
            {
                if let &Opcode::Load = &pattern5_0 {
                    if let Some(()) = C::littleendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/lower.isle line 1218.
                        let expr0_0 =
                            constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                        let expr1_0 = constructor_loadrev64(ctx, &expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    if let Some(()) = C::bigendian(ctx, pattern5_2) {
                        // Rule at src/isa/s390x/lower.isle line 1214.
                        let expr0_0 =
                            constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                        let expr1_0 = constructor_load64(ctx, &expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                }
            }
        }
        if pattern2_0 == F32 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bitcast = &pattern5_0 {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == I32 {
                            // Rule at src/isa/s390x/lower.isle line 1140.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr2_0: u8 = 32;
                            let expr3_0 = constructor_lshl_imm(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0 = constructor_mov_to_fpr(ctx, expr3_0)?;
                            let expr5_0 = C::value_reg(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = &pattern5_0 {
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1222.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_fpu_load32(ctx, &expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == F64 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bitcast = &pattern5_0 {
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if pattern7_0 == I64 {
                            // Rule at src/isa/s390x/lower.isle line 1131.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_mov_to_fpr(ctx, expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    if let &Opcode::Load = &pattern5_0 {
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            // Rule at src/isa/s390x/lower.isle line 1237.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr1_0 = constructor_fpu_load64(ctx, &expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                }
                _ => {}
            }
        }
        let pattern3_0 = C::inst_data(ctx, pattern0_0);
        match &pattern3_0 {
            &InstructionData::NullAry {
                opcode: ref pattern4_0,
            } => {
                if let &Opcode::Null = &pattern4_0 {
                    // Rule at src/isa/s390x/lower.isle line 41.
                    let expr0_0: u64 = 0;
                    let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                    let expr2_0 = C::value_reg(ctx, expr1_0);
                    return Some(expr2_0);
                }
            }
            &InstructionData::UnaryImm {
                opcode: ref pattern4_0,
                imm: pattern4_1,
            } => {
                if let &Opcode::Iconst = &pattern4_0 {
                    let pattern6_0 = C::u64_from_imm64(ctx, pattern4_1);
                    // Rule at src/isa/s390x/lower.isle line 15.
                    let expr0_0 = constructor_imm(ctx, pattern2_0, pattern6_0)?;
                    let expr1_0 = C::value_reg(ctx, expr0_0);
                    return Some(expr1_0);
                }
            }
            &InstructionData::StackLoad {
                opcode: ref pattern4_0,
                stack_slot: pattern4_1,
                offset: pattern4_2,
            } => {
                if let &Opcode::StackAddr = &pattern4_0 {
                    // Rule at src/isa/s390x/lower.isle line 1152.
                    let expr0_0 =
                        constructor_stack_addr_impl(ctx, pattern2_0, pattern4_1, pattern4_2)?;
                    let expr1_0 = C::value_reg(ctx, expr0_0);
                    return Some(expr1_0);
                }
            }
            &InstructionData::UnaryBool {
                opcode: ref pattern4_0,
                imm: pattern4_1,
            } => {
                if let &Opcode::Bconst = &pattern4_0 {
                    if pattern4_1 == true {
                        // Rule at src/isa/s390x/lower.isle line 23.
                        let expr0_0: u64 = 1;
                        let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    if pattern4_1 == false {
                        // Rule at src/isa/s390x/lower.isle line 21.
                        let expr0_0: u64 = 0;
                        let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                }
            }
            &InstructionData::Binary {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
            } => {
                match &pattern4_0 {
                    &Opcode::Fadd => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, &pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 920.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fadd_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = C::value_reg(ctx, expr2_0);
                        return Some(expr3_0);
                    }
                    &Opcode::Fsub => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, &pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 927.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fsub_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = C::value_reg(ctx, expr2_0);
                        return Some(expr3_0);
                    }
                    &Opcode::Fmul => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, &pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 934.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fmul_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = C::value_reg(ctx, expr2_0);
                        return Some(expr3_0);
                    }
                    &Opcode::Fdiv => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, &pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 941.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fdiv_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = C::value_reg(ctx, expr2_0);
                        return Some(expr3_0);
                    }
                    &Opcode::Fcopysign => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, &pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 962.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fpu_copysign(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = C::value_reg(ctx, expr2_0);
                        return Some(expr3_0);
                    }
                    &Opcode::Fmin => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, &pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 948.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fmin_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = C::value_reg(ctx, expr2_0);
                        return Some(expr3_0);
                    }
                    &Opcode::Fmax => {
                        let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, &pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 955.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = constructor_fmax_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = C::value_reg(ctx, expr2_0);
                        return Some(expr3_0);
                    }
                    _ => {}
                }
            }
            &InstructionData::FloatCompare {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
                cond: ref pattern4_2,
            } => {
                if let &Opcode::Fcmp = &pattern4_0 {
                    let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, &pattern4_1);
                    // Rule at src/isa/s390x/lower.isle line 1727.
                    let expr0_0 = constructor_fcmp_val(ctx, &pattern4_2, pattern6_0, pattern6_1)?;
                    let expr1_0 = constructor_lower_bool(ctx, pattern2_0, &expr0_0)?;
                    let expr2_0 = C::value_reg(ctx, expr1_0);
                    return Some(expr2_0);
                }
            }
            &InstructionData::IntCompare {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
                cond: ref pattern4_2,
            } => {
                if let &Opcode::Icmp = &pattern4_0 {
                    let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, &pattern4_1);
                    // Rule at src/isa/s390x/lower.isle line 1638.
                    let expr0_0: bool = true;
                    let expr1_0 =
                        constructor_icmp_val(ctx, expr0_0, &pattern4_2, pattern6_0, pattern6_1)?;
                    let expr2_0 = constructor_lower_bool(ctx, pattern2_0, &expr1_0)?;
                    let expr3_0 = C::value_reg(ctx, expr2_0);
                    return Some(expr3_0);
                }
            }
            &InstructionData::Ternary {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
            } => {
                match &pattern4_0 {
                    &Opcode::Select => {
                        let (pattern6_0, pattern6_1, pattern6_2) =
                            C::unpack_value_array_3(ctx, &pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 1769.
                        let expr0_0 = constructor_value_nonzero(ctx, pattern6_0)?;
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = C::put_in_reg(ctx, pattern6_2);
                        let expr3_0 = constructor_select_bool_reg(
                            ctx, pattern2_0, &expr0_0, expr1_0, expr2_0,
                        )?;
                        let expr4_0 = C::value_reg(ctx, expr3_0);
                        return Some(expr4_0);
                    }
                    &Opcode::Fma => {
                        let (pattern6_0, pattern6_1, pattern6_2) =
                            C::unpack_value_array_3(ctx, &pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 969.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr2_0 = C::put_in_reg(ctx, pattern6_2);
                        let expr3_0 =
                            constructor_fma_reg(ctx, pattern2_0, expr0_0, expr1_0, expr2_0)?;
                        let expr4_0 = C::value_reg(ctx, expr3_0);
                        return Some(expr4_0);
                    }
                    _ => {}
                }
            }
            &InstructionData::IntSelect {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
                cond: ref pattern4_2,
            } => {
                if let &Opcode::SelectifSpectreGuard = &pattern4_0 {
                    let (pattern6_0, pattern6_1, pattern6_2) =
                        C::unpack_value_array_3(ctx, &pattern4_1);
                    if let Some(pattern7_0) = C::def_inst(ctx, pattern6_0) {
                        let pattern8_0 = C::inst_data(ctx, pattern7_0);
                        if let &InstructionData::Binary {
                            opcode: ref pattern9_0,
                            args: ref pattern9_1,
                        } = &pattern8_0
                        {
                            if let &Opcode::Ifcmp = &pattern9_0 {
                                let (pattern11_0, pattern11_1) =
                                    C::unpack_value_array_2(ctx, &pattern9_1);
                                // Rule at src/isa/s390x/lower.isle line 1781.
                                let expr0_0: bool = false;
                                let expr1_0 = constructor_icmp_val(
                                    ctx,
                                    expr0_0,
                                    &pattern4_2,
                                    pattern11_0,
                                    pattern11_1,
                                )?;
                                let expr2_0 = C::put_in_reg(ctx, pattern6_1);
                                let expr3_0 = C::put_in_reg(ctx, pattern6_2);
                                let expr4_0 = constructor_select_bool_reg(
                                    ctx, pattern2_0, &expr1_0, expr2_0, expr3_0,
                                )?;
                                let expr5_0 = C::value_reg(ctx, expr4_0);
                                return Some(expr5_0);
                            }
                        }
                    }
                }
            }
            &InstructionData::Unary {
                opcode: ref pattern4_0,
                arg: pattern4_1,
            } => {
                match &pattern4_0 {
                    &Opcode::Sqrt => {
                        // Rule at src/isa/s390x/lower.isle line 976.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_sqrt_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    &Opcode::Fneg => {
                        // Rule at src/isa/s390x/lower.isle line 983.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_fneg_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    &Opcode::Fabs => {
                        // Rule at src/isa/s390x/lower.isle line 990.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_fabs_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    &Opcode::Ceil => {
                        // Rule at src/isa/s390x/lower.isle line 997.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_ceil_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    &Opcode::Floor => {
                        // Rule at src/isa/s390x/lower.isle line 1004.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_floor_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    &Opcode::Trunc => {
                        // Rule at src/isa/s390x/lower.isle line 1011.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_trunc_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    &Opcode::Nearest => {
                        // Rule at src/isa/s390x/lower.isle line 1018.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 = constructor_nearest_reg(ctx, pattern2_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    &Opcode::Bextend => {
                        // Rule at src/isa/s390x/lower.isle line 760.
                        let expr0_0 = constructor_cast_bool(ctx, pattern2_0, pattern4_1)?;
                        let expr1_0 = C::value_reg(ctx, expr0_0);
                        return Some(expr1_0);
                    }
                    &Opcode::Bmask => {
                        // Rule at src/isa/s390x/lower.isle line 762.
                        let expr0_0 = constructor_cast_bool(ctx, pattern2_0, pattern4_1)?;
                        let expr1_0 = C::value_reg(ctx, expr0_0);
                        return Some(expr1_0);
                    }
                    &Opcode::Fpromote => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 1025.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 =
                            constructor_fpromote_reg(ctx, pattern2_0, pattern6_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    &Opcode::Fdemote => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 1032.
                        let expr0_0 = C::put_in_reg(ctx, pattern4_1);
                        let expr1_0 =
                            constructor_fdemote_reg(ctx, pattern2_0, pattern6_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    &Opcode::FcvtFromUint => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 1039.
                        let expr0_0 = constructor_ty_ext32(ctx, pattern6_0)?;
                        let expr1_0 = constructor_put_in_reg_zext32(ctx, pattern4_1)?;
                        let expr2_0 =
                            constructor_fcvt_from_uint_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = C::value_reg(ctx, expr2_0);
                        return Some(expr3_0);
                    }
                    &Opcode::FcvtFromSint => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        // Rule at src/isa/s390x/lower.isle line 1047.
                        let expr0_0 = constructor_ty_ext32(ctx, pattern6_0)?;
                        let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern4_1)?;
                        let expr2_0 =
                            constructor_fcvt_from_sint_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
                        let expr3_0 = C::value_reg(ctx, expr2_0);
                        return Some(expr3_0);
                    }
                    _ => {}
                }
            }
            _ => {}
        }
        if let Some(()) = C::mie2_enabled(ctx, pattern2_0) {
            if let Some(pattern4_0) = C::fits_in_64(ctx, pattern2_0) {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                match &pattern5_0 {
                    &InstructionData::Binary {
                        opcode: ref pattern6_0,
                        args: ref pattern6_1,
                    } => {
                        match &pattern6_0 {
                            &Opcode::BandNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, &pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 702.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_and_not_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::BorNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, &pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 713.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_or_not_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::BxorNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, &pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 724.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_xor_not_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            _ => {}
                        }
                    }
                    &InstructionData::Ternary {
                        opcode: ref pattern6_0,
                        args: ref pattern6_1,
                    } => {
                        if let &Opcode::Bitselect = &pattern6_0 {
                            let (pattern8_0, pattern8_1, pattern8_2) =
                                C::unpack_value_array_3(ctx, &pattern6_1);
                            // Rule at src/isa/s390x/lower.isle line 735.
                            let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                            let expr2_0 = constructor_and_reg(ctx, pattern4_0, expr1_0, expr0_0)?;
                            let expr3_0 = C::put_in_reg(ctx, pattern8_2);
                            let expr4_0 =
                                constructor_and_not_reg(ctx, pattern4_0, expr3_0, expr0_0)?;
                            let expr5_0 = constructor_or_reg(ctx, pattern4_0, expr4_0, expr2_0)?;
                            let expr6_0 = C::value_reg(ctx, expr5_0);
                            return Some(expr6_0);
                        }
                    }
                    &InstructionData::Unary {
                        opcode: ref pattern6_0,
                        arg: pattern6_1,
                    } => {
                        match &pattern6_0 {
                            &Opcode::Bnot => {
                                // Rule at src/isa/s390x/lower.isle line 625.
                                let expr0_0 = C::put_in_reg(ctx, pattern6_1);
                                let expr1_0 =
                                    constructor_or_not_reg(ctx, pattern4_0, expr0_0, expr0_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            &Opcode::Popcnt => {
                                // Rule at src/isa/s390x/lower.isle line 889.
                                let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern6_1)?;
                                let expr1_0 = constructor_popcnt_reg(ctx, expr0_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            _ => {}
                        }
                    }
                    _ => {}
                }
            }
        }
        if let Some(()) = C::mie2_disabled(ctx, pattern2_0) {
            if pattern2_0 == I16 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Popcnt = &pattern6_0 {
                        // Rule at src/isa/s390x/lower.isle line 898.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr1_0 = constructor_popcnt_byte(ctx, expr0_0)?;
                        let expr2_0: Type = I32;
                        let expr3_0: Type = I32;
                        let expr4_0: u8 = 8;
                        let expr5_0 = constructor_lshl_imm(ctx, expr3_0, expr1_0, expr4_0)?;
                        let expr6_0 = constructor_add_reg(ctx, expr2_0, expr1_0, expr5_0)?;
                        let expr7_0: Type = I32;
                        let expr8_0: u8 = 8;
                        let expr9_0 = constructor_lshr_imm(ctx, expr7_0, expr6_0, expr8_0)?;
                        let expr10_0 = C::value_reg(ctx, expr9_0);
                        return Some(expr10_0);
                    }
                }
            }
            if pattern2_0 == I32 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Popcnt = &pattern6_0 {
                        // Rule at src/isa/s390x/lower.isle line 903.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr1_0 = constructor_popcnt_byte(ctx, expr0_0)?;
                        let expr2_0: Type = I32;
                        let expr3_0: Type = I32;
                        let expr4_0: u8 = 16;
                        let expr5_0 = constructor_lshl_imm(ctx, expr3_0, expr1_0, expr4_0)?;
                        let expr6_0 = constructor_add_reg(ctx, expr2_0, expr1_0, expr5_0)?;
                        let expr7_0: Type = I32;
                        let expr8_0: Type = I32;
                        let expr9_0: u8 = 8;
                        let expr10_0 = constructor_lshl_imm(ctx, expr8_0, expr6_0, expr9_0)?;
                        let expr11_0 = constructor_add_reg(ctx, expr7_0, expr6_0, expr10_0)?;
                        let expr12_0: Type = I32;
                        let expr13_0: u8 = 24;
                        let expr14_0 = constructor_lshr_imm(ctx, expr12_0, expr11_0, expr13_0)?;
                        let expr15_0 = C::value_reg(ctx, expr14_0);
                        return Some(expr15_0);
                    }
                }
            }
            if pattern2_0 == I64 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Popcnt = &pattern6_0 {
                        // Rule at src/isa/s390x/lower.isle line 909.
                        let expr0_0 = C::put_in_reg(ctx, pattern6_1);
                        let expr1_0 = constructor_popcnt_byte(ctx, expr0_0)?;
                        let expr2_0: Type = I64;
                        let expr3_0: Type = I64;
                        let expr4_0: u8 = 32;
                        let expr5_0 = constructor_lshl_imm(ctx, expr3_0, expr1_0, expr4_0)?;
                        let expr6_0 = constructor_add_reg(ctx, expr2_0, expr1_0, expr5_0)?;
                        let expr7_0: Type = I64;
                        let expr8_0: Type = I64;
                        let expr9_0: u8 = 16;
                        let expr10_0 = constructor_lshl_imm(ctx, expr8_0, expr6_0, expr9_0)?;
                        let expr11_0 = constructor_add_reg(ctx, expr7_0, expr6_0, expr10_0)?;
                        let expr12_0: Type = I64;
                        let expr13_0: Type = I64;
                        let expr14_0: u8 = 8;
                        let expr15_0 = constructor_lshl_imm(ctx, expr13_0, expr11_0, expr14_0)?;
                        let expr16_0 = constructor_add_reg(ctx, expr12_0, expr11_0, expr15_0)?;
                        let expr17_0: Type = I64;
                        let expr18_0: u8 = 56;
                        let expr19_0 = constructor_lshr_imm(ctx, expr17_0, expr16_0, expr18_0)?;
                        let expr20_0 = C::value_reg(ctx, expr19_0);
                        return Some(expr20_0);
                    }
                }
            }
            if let Some(pattern4_0) = C::fits_in_64(ctx, pattern2_0) {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                match &pattern5_0 {
                    &InstructionData::Binary {
                        opcode: ref pattern6_0,
                        args: ref pattern6_1,
                    } => {
                        match &pattern6_0 {
                            &Opcode::BandNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, &pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 706.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_and_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = constructor_not_reg(ctx, pattern4_0, expr2_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            &Opcode::BorNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, &pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 717.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_or_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = constructor_not_reg(ctx, pattern4_0, expr2_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            &Opcode::BxorNot => {
                                let (pattern8_0, pattern8_1) =
                                    C::unpack_value_array_2(ctx, &pattern6_1);
                                // Rule at src/isa/s390x/lower.isle line 728.
                                let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                                let expr2_0 =
                                    constructor_xor_reg(ctx, pattern4_0, expr0_0, expr1_0)?;
                                let expr3_0 = constructor_not_reg(ctx, pattern4_0, expr2_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            _ => {}
                        }
                    }
                    &InstructionData::Ternary {
                        opcode: ref pattern6_0,
                        args: ref pattern6_1,
                    } => {
                        if let &Opcode::Bitselect = &pattern6_0 {
                            let (pattern8_0, pattern8_1, pattern8_2) =
                                C::unpack_value_array_3(ctx, &pattern6_1);
                            // Rule at src/isa/s390x/lower.isle line 742.
                            let expr0_0 = C::put_in_reg(ctx, pattern8_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern8_1);
                            let expr2_0 = constructor_and_reg(ctx, pattern4_0, expr1_0, expr0_0)?;
                            let expr3_0 = C::put_in_reg(ctx, pattern8_2);
                            let expr4_0 = constructor_and_reg(ctx, pattern4_0, expr3_0, expr0_0)?;
                            let expr5_0 = constructor_not_reg(ctx, pattern4_0, expr4_0)?;
                            let expr6_0 = constructor_or_reg(ctx, pattern4_0, expr5_0, expr2_0)?;
                            let expr7_0 = C::value_reg(ctx, expr6_0);
                            return Some(expr7_0);
                        }
                    }
                    &InstructionData::Unary {
                        opcode: ref pattern6_0,
                        arg: pattern6_1,
                    } => {
                        if let &Opcode::Bnot = &pattern6_0 {
                            // Rule at src/isa/s390x/lower.isle line 630.
                            let expr0_0 = C::put_in_reg(ctx, pattern6_1);
                            let expr1_0 = constructor_not_reg(ctx, pattern4_0, expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                    _ => {}
                }
            }
        }
        if let Some(()) = C::vxrs_ext2_enabled(ctx, pattern2_0) {
            if pattern2_0 == F32 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Load {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                    flags: pattern6_2,
                    offset: pattern6_3,
                } = &pattern5_0
                {
                    if let &Opcode::Load = &pattern6_0 {
                        if let Some(()) = C::littleendian(ctx, pattern6_2) {
                            // Rule at src/isa/s390x/lower.isle line 1226.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern6_2, pattern6_1, pattern6_3)?;
                            let expr1_0 = constructor_fpu_loadrev32(ctx, &expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                }
            }
            if pattern2_0 == F64 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Load {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                    flags: pattern6_2,
                    offset: pattern6_3,
                } = &pattern5_0
                {
                    if let &Opcode::Load = &pattern6_0 {
                        if let Some(()) = C::littleendian(ctx, pattern6_2) {
                            // Rule at src/isa/s390x/lower.isle line 1241.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern6_2, pattern6_1, pattern6_3)?;
                            let expr1_0 = constructor_fpu_loadrev64(ctx, &expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                }
            }
        }
        if let Some(()) = C::vxrs_ext2_disabled(ctx, pattern2_0) {
            if pattern2_0 == F32 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Load {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                    flags: pattern6_2,
                    offset: pattern6_3,
                } = &pattern5_0
                {
                    if let &Opcode::Load = &pattern6_0 {
                        if let Some(()) = C::littleendian(ctx, pattern6_2) {
                            // Rule at src/isa/s390x/lower.isle line 1231.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern6_2, pattern6_1, pattern6_3)?;
                            let expr1_0 = constructor_loadrev32(ctx, &expr0_0)?;
                            let expr2_0: Type = I64;
                            let expr3_0: u8 = 32;
                            let expr4_0 = constructor_lshl_imm(ctx, expr2_0, expr1_0, expr3_0)?;
                            let expr5_0 = constructor_mov_to_fpr(ctx, expr4_0)?;
                            let expr6_0 = C::value_reg(ctx, expr5_0);
                            return Some(expr6_0);
                        }
                    }
                }
            }
            if pattern2_0 == F64 {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Load {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                    flags: pattern6_2,
                    offset: pattern6_3,
                } = &pattern5_0
                {
                    if let &Opcode::Load = &pattern6_0 {
                        if let Some(()) = C::littleendian(ctx, pattern6_2) {
                            // Rule at src/isa/s390x/lower.isle line 1246.
                            let expr0_0 =
                                constructor_lower_address(ctx, pattern6_2, pattern6_1, pattern6_3)?;
                            let expr1_0 = constructor_loadrev64(ctx, &expr0_0)?;
                            let expr2_0 = constructor_mov_to_fpr(ctx, expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                    }
                }
            }
        }
        if let Some(pattern3_0) = C::fits_in_16(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Bint = &pattern5_0 {
                    // Rule at src/isa/s390x/lower.isle line 796.
                    let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                    let expr1_0: u16 = 1;
                    let expr2_0: u8 = 0;
                    let expr3_0 = C::uimm16shifted(ctx, expr1_0, expr2_0);
                    let expr4_0 = constructor_and_uimm16shifted(ctx, pattern3_0, expr0_0, expr3_0)?;
                    let expr5_0 = C::value_reg(ctx, expr4_0);
                    return Some(expr5_0);
                }
            }
        }
        if let Some(pattern3_0) = C::fits_in_32(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Bint = &pattern5_0 {
                    // Rule at src/isa/s390x/lower.isle line 800.
                    let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                    let expr1_0: u32 = 1;
                    let expr2_0: u8 = 0;
                    let expr3_0 = C::uimm32shifted(ctx, expr1_0, expr2_0);
                    let expr4_0 = constructor_and_uimm32shifted(ctx, pattern3_0, expr0_0, expr3_0)?;
                    let expr5_0 = C::value_reg(ctx, expr4_0);
                    return Some(expr5_0);
                }
            }
        }
        if let Some(pattern3_0) = C::fits_in_64(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Iadd => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::i16_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 72.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_add_simm16(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::i32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 76.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_add_simm32(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Sextend = &pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 66.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_add_reg_sext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = C::value_reg(ctx, expr2_0);
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    match &pattern10_0 {
                                        &Opcode::Sload16 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 94.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_sload16(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_add_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                        &Opcode::Sload32 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 98.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_sload32(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_add_mem_sext32(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if pattern8_0 == I16 {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 88.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 82.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::i16_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 70.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_add_simm16(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::i32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 74.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_add_simm32(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Sextend = &pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 64.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_add_reg_sext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = C::value_reg(ctx, expr2_0);
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    match &pattern10_0 {
                                        &Opcode::Sload16 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 92.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload16(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_add_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                        &Opcode::Sload32 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 96.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload32(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_add_mem_sext32(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if pattern8_0 == I16 {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 86.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 80.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 60.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_add_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Isub => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::i16_from_negated_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 113.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_add_simm16(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::i32_from_negated_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 115.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_add_simm32(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Sextend = &pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 109.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_sub_reg_sext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = C::value_reg(ctx, expr2_0);
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    match &pattern10_0 {
                                        &Opcode::Sload16 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 127.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload16(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_sub_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                        &Opcode::Sload32 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 129.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload32(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_sub_mem_sext32(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if pattern8_0 == I16 {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 123.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_sub_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 119.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_sub_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 105.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_sub_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Imul => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::i16_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 212.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_mul_simm16(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::i32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 216.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_mul_simm32(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Sextend = &pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 206.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_mul_reg_sext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = C::value_reg(ctx, expr2_0);
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    match &pattern10_0 {
                                        &Opcode::Sload16 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 234.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_sload16(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_mul_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                        &Opcode::Sload32 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 238.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_sload32(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_mul_mem_sext32(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if pattern8_0 == I16 {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 228.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_mul_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 222.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_mul_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::i16_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 210.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_mul_simm16(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::i32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 214.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_mul_simm32(ctx, pattern3_0, expr0_0, pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Sextend = &pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 204.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_mul_reg_sext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 = C::value_reg(ctx, expr2_0);
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    match &pattern10_0 {
                                        &Opcode::Sload16 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 232.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload16(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_mul_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                        &Opcode::Sload32 => {
                                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                                // Rule at src/isa/s390x/lower.isle line 236.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_sload32(ctx, pattern8_0)?;
                                                let expr2_0 = constructor_mul_mem_sext32(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if pattern8_0 == I16 {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 226.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_mul_mem_sext16(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 220.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_mul_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 200.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_mul_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Udiv => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 303.
                            let expr0_0 = constructor_zero_divisor_check_needed(ctx, pattern7_1)?;
                            let expr1_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr2_0: u64 = 0;
                            let expr3_0 = constructor_uninitialized_regpair(ctx)?;
                            let expr4_0 =
                                constructor_imm_regpair_hi(ctx, expr1_0, expr2_0, &expr3_0)?;
                            let expr5_0 =
                                constructor_put_in_regpair_lo_zext32(ctx, pattern7_0, &expr4_0)?;
                            let expr6_0 = constructor_put_in_reg_zext32(ctx, pattern7_1)?;
                            let expr7_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr8_0 = constructor_maybe_trap_if_zero_divisor(
                                ctx, expr0_0, expr7_0, expr6_0,
                            )?;
                            let expr9_0 = constructor_udivmod(ctx, expr7_0, &expr5_0, expr6_0)?;
                            let expr10_0 = constructor_regpair_lo(ctx, &expr9_0)?;
                            let expr11_0 = constructor_copy_reg(ctx, pattern3_0, expr10_0)?;
                            let expr12_0 = C::value_reg(ctx, expr11_0);
                            return Some(expr12_0);
                        }
                        &Opcode::Sdiv => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 375.
                            let expr0_0 = constructor_zero_divisor_check_needed(ctx, pattern7_1)?;
                            let expr1_0 = constructor_div_overflow_check_needed(ctx, pattern7_1)?;
                            let expr2_0 = constructor_uninitialized_regpair(ctx)?;
                            let expr3_0 =
                                constructor_put_in_regpair_lo_sext64(ctx, pattern7_0, &expr2_0)?;
                            let expr4_0 = constructor_put_in_reg_sext32(ctx, pattern7_1)?;
                            let expr5_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr6_0 = constructor_maybe_trap_if_zero_divisor(
                                ctx, expr0_0, expr5_0, expr4_0,
                            )?;
                            let expr7_0 = constructor_maybe_trap_if_sdiv_overflow(
                                ctx, expr1_0, expr5_0, pattern3_0, &expr3_0, expr4_0,
                            )?;
                            let expr8_0 = constructor_sdivmod(ctx, expr5_0, &expr3_0, expr4_0)?;
                            let expr9_0 = constructor_regpair_lo(ctx, &expr8_0)?;
                            let expr10_0 = constructor_copy_reg(ctx, pattern3_0, expr9_0)?;
                            let expr11_0 = C::value_reg(ctx, expr10_0);
                            return Some(expr11_0);
                        }
                        &Opcode::Urem => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 326.
                            let expr0_0 = constructor_zero_divisor_check_needed(ctx, pattern7_1)?;
                            let expr1_0: u64 = 0;
                            let expr2_0 = constructor_uninitialized_regpair(ctx)?;
                            let expr3_0 =
                                constructor_imm_regpair_hi(ctx, pattern3_0, expr1_0, &expr2_0)?;
                            let expr4_0 =
                                constructor_put_in_regpair_lo_zext32(ctx, pattern7_0, &expr3_0)?;
                            let expr5_0 = constructor_put_in_reg_zext32(ctx, pattern7_1)?;
                            let expr6_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr7_0 = constructor_maybe_trap_if_zero_divisor(
                                ctx, expr0_0, expr6_0, expr5_0,
                            )?;
                            let expr8_0 = constructor_udivmod(ctx, expr6_0, &expr4_0, expr5_0)?;
                            let expr9_0 = constructor_regpair_hi(ctx, &expr8_0)?;
                            let expr10_0 = constructor_copy_reg(ctx, pattern3_0, expr9_0)?;
                            let expr11_0 = C::value_reg(ctx, expr10_0);
                            return Some(expr11_0);
                        }
                        &Opcode::Srem => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 398.
                            let expr0_0 = constructor_zero_divisor_check_needed(ctx, pattern7_1)?;
                            let expr1_0 = constructor_div_overflow_check_needed(ctx, pattern7_1)?;
                            let expr2_0 = constructor_uninitialized_regpair(ctx)?;
                            let expr3_0 =
                                constructor_put_in_regpair_lo_sext64(ctx, pattern7_0, &expr2_0)?;
                            let expr4_0 = constructor_put_in_reg_sext32(ctx, pattern7_1)?;
                            let expr5_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr6_0 = constructor_maybe_trap_if_zero_divisor(
                                ctx, expr0_0, expr5_0, expr4_0,
                            )?;
                            let expr7_0 = constructor_maybe_avoid_srem_overflow(
                                ctx, expr1_0, expr5_0, &expr3_0, expr4_0,
                            )?;
                            let expr8_0 = constructor_sdivmod(ctx, expr5_0, &expr7_0, expr4_0)?;
                            let expr9_0 = constructor_regpair_hi(ctx, &expr8_0)?;
                            let expr10_0 = constructor_copy_reg(ctx, pattern3_0, expr9_0)?;
                            let expr11_0 = C::value_reg(ctx, expr10_0);
                            return Some(expr11_0);
                        }
                        &Opcode::IaddIfcout => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::u32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 170.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_add_logical_zimm32(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_value_regs_ifcout(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Uextend = &pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 164.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_add_logical_reg_zext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 =
                                                constructor_value_regs_ifcout(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_0) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Uload32 = &pattern10_0 {
                                        if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                            // Rule at src/isa/s390x/lower.isle line 182.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                            let expr1_0 =
                                                constructor_sink_uload32(ctx, pattern8_0)?;
                                            let expr2_0 = constructor_add_logical_mem_zext32(
                                                ctx, pattern3_0, expr0_0, &expr1_0,
                                            )?;
                                            let expr3_0 =
                                                constructor_value_regs_ifcout(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 176.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_logical_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 =
                                                    constructor_value_regs_ifcout(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::u32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 168.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_add_logical_zimm32(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = constructor_value_regs_ifcout(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Uextend = &pattern10_0 {
                                        let pattern12_0 = C::value_type(ctx, pattern10_1);
                                        if pattern12_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 162.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                            let expr1_0 = C::put_in_reg(ctx, pattern10_1);
                                            let expr2_0 = constructor_add_logical_reg_zext32(
                                                ctx, pattern3_0, expr0_0, expr1_0,
                                            )?;
                                            let expr3_0 =
                                                constructor_value_regs_ifcout(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::Load {
                                    opcode: ref pattern10_0,
                                    arg: pattern10_1,
                                    flags: pattern10_2,
                                    offset: pattern10_3,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Uload32 = &pattern10_0 {
                                        if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                            // Rule at src/isa/s390x/lower.isle line 180.
                                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                            let expr1_0 =
                                                constructor_sink_uload32(ctx, pattern8_0)?;
                                            let expr2_0 = constructor_add_logical_mem_zext32(
                                                ctx, pattern3_0, expr0_0, &expr1_0,
                                            )?;
                                            let expr3_0 =
                                                constructor_value_regs_ifcout(ctx, expr2_0)?;
                                            return Some(expr3_0);
                                        }
                                    }
                                }
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 174.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_add_logical_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 =
                                                    constructor_value_regs_ifcout(ctx, expr2_0)?;
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 158.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 =
                                constructor_add_logical_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_value_regs_ifcout(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 653.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_and_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) =
                                C::uimm32shifted_from_inverted_value(ctx, pattern7_0)
                            {
                                // Rule at src/isa/s390x/lower.isle line 647.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_and_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) =
                                C::uimm16shifted_from_inverted_value(ctx, pattern7_0)
                            {
                                // Rule at src/isa/s390x/lower.isle line 643.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_and_uimm16shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 651.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_and_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) =
                                C::uimm32shifted_from_inverted_value(ctx, pattern7_1)
                            {
                                // Rule at src/isa/s390x/lower.isle line 645.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_and_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) =
                                C::uimm16shifted_from_inverted_value(ctx, pattern7_1)
                            {
                                // Rule at src/isa/s390x/lower.isle line 641.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_and_uimm16shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 637.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_and_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 676.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_or_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::uimm32shifted_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 670.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_or_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::uimm16shifted_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 666.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_or_uimm16shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 674.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_or_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::uimm32shifted_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 668.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_or_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::uimm16shifted_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 664.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_or_uimm16shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 660.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_or_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            let pattern8_0 = C::value_type(ctx, pattern7_0);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 695.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_xor_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::uimm32shifted_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/s390x/lower.isle line 689.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = constructor_xor_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            if let Some(pattern9_0) = C::ty_32_or_64(ctx, pattern8_0) {
                                if let Some(pattern10_0) = C::sinkable_inst(ctx, pattern7_1) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Load {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                        flags: pattern12_2,
                                        offset: pattern12_3,
                                    } = &pattern11_0
                                    {
                                        if let &Opcode::Load = &pattern12_0 {
                                            if let Some(()) = C::bigendian(ctx, pattern12_2) {
                                                // Rule at src/isa/s390x/lower.isle line 693.
                                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                                let expr1_0 =
                                                    constructor_sink_load(ctx, pattern10_0)?;
                                                let expr2_0 = constructor_xor_mem(
                                                    ctx, pattern3_0, expr0_0, &expr1_0,
                                                )?;
                                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                                return Some(expr3_0);
                                            }
                                        }
                                    }
                                }
                            }
                            if let Some(pattern8_0) = C::uimm32shifted_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 687.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = constructor_xor_uimm32shifted(
                                    ctx, pattern3_0, expr0_0, pattern8_0,
                                )?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 683.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_xor_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 482.
                                let expr0_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr2_0 =
                                    constructor_lshl_imm(ctx, pattern3_0, expr1_0, expr0_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 477.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr3_0 = constructor_lshl_reg(ctx, pattern3_0, expr2_0, expr1_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 498.
                                let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                                let expr1_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr2_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                                let expr3_0 = constructor_lshr_imm(ctx, expr2_0, expr0_0, expr1_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 491.
                            let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr1_0)?;
                            let expr3_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr4_0 = constructor_lshr_reg(ctx, expr3_0, expr0_0, expr2_0)?;
                            let expr5_0 = C::value_reg(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 515.
                                let expr0_0 = constructor_put_in_reg_sext32(ctx, pattern7_0)?;
                                let expr1_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr2_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                                let expr3_0 = constructor_ashr_imm(ctx, expr2_0, expr0_0, expr1_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 508.
                            let expr0_0 = constructor_put_in_reg_sext32(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr1_0)?;
                            let expr3_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr4_0 = constructor_ashr_reg(ctx, expr3_0, expr0_0, expr2_0)?;
                            let expr5_0 = C::value_reg(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Ineg => {
                            if let Some(pattern7_0) = C::def_inst(ctx, pattern5_1) {
                                let pattern8_0 = C::inst_data(ctx, pattern7_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern9_0,
                                    arg: pattern9_1,
                                } = &pattern8_0
                                {
                                    if let &Opcode::Sextend = &pattern9_0 {
                                        let pattern11_0 = C::value_type(ctx, pattern9_1);
                                        if pattern11_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 193.
                                            let expr0_0 = C::put_in_reg(ctx, pattern9_1);
                                            let expr1_0 = constructor_neg_reg_sext32(
                                                ctx, pattern3_0, expr0_0,
                                            )?;
                                            let expr2_0 = C::value_reg(ctx, expr1_0);
                                            return Some(expr2_0);
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 189.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_neg_reg(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                        &Opcode::Iabs => {
                            if let Some(pattern7_0) = C::def_inst(ctx, pattern5_1) {
                                let pattern8_0 = C::inst_data(ctx, pattern7_0);
                                if let &InstructionData::Unary {
                                    opcode: ref pattern9_0,
                                    arg: pattern9_1,
                                } = &pattern8_0
                                {
                                    if let &Opcode::Sextend = &pattern9_0 {
                                        let pattern11_0 = C::value_type(ctx, pattern9_1);
                                        if pattern11_0 == I32 {
                                            // Rule at src/isa/s390x/lower.isle line 141.
                                            let expr0_0 = C::put_in_reg(ctx, pattern9_1);
                                            let expr1_0 = constructor_abs_reg_sext32(
                                                ctx, pattern3_0, expr0_0,
                                            )?;
                                            let expr2_0 = C::value_reg(ctx, expr1_0);
                                            return Some(expr2_0);
                                        }
                                    }
                                }
                            }
                            // Rule at src/isa/s390x/lower.isle line 137.
                            let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                            let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern5_1)?;
                            let expr2_0 = constructor_abs_reg(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Clz => {
                            // Rule at src/isa/s390x/lower.isle line 821.
                            let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern5_1)?;
                            let expr1_0: i16 = 64;
                            let expr2_0 = constructor_clz_reg(ctx, expr1_0, expr0_0)?;
                            let expr3_0 = constructor_regpair_hi(ctx, &expr2_0)?;
                            let expr4_0 = constructor_clz_offset(ctx, pattern3_0, expr3_0)?;
                            let expr5_0 = C::value_reg(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                        &Opcode::Cls => {
                            // Rule at src/isa/s390x/lower.isle line 836.
                            let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern5_1)?;
                            let expr1_0: Type = I64;
                            let expr2_0: u8 = 63;
                            let expr3_0 = constructor_ashr_imm(ctx, expr1_0, expr0_0, expr2_0)?;
                            let expr4_0: Type = I64;
                            let expr5_0 = constructor_xor_reg(ctx, expr4_0, expr0_0, expr3_0)?;
                            let expr6_0: i16 = 64;
                            let expr7_0 = constructor_clz_reg(ctx, expr6_0, expr5_0)?;
                            let expr8_0 = constructor_regpair_hi(ctx, &expr7_0)?;
                            let expr9_0 = constructor_clz_offset(ctx, pattern3_0, expr8_0)?;
                            let expr10_0 = C::value_reg(ctx, expr9_0);
                            return Some(expr10_0);
                        }
                        &Opcode::Bint => {
                            // Rule at src/isa/s390x/lower.isle line 804.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0: u64 = 1;
                            let expr2_0 = constructor_imm(ctx, pattern3_0, expr1_0)?;
                            let expr3_0 = constructor_and_reg(ctx, pattern3_0, expr0_0, expr2_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Rotl => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 528.
                                let expr0_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr2_0 =
                                    constructor_rot_imm(ctx, pattern3_0, expr1_0, expr0_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 524.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = constructor_rot_reg(ctx, pattern3_0, expr0_0, expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Rotr => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::i64_from_negated_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 566.
                                let expr0_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr2_0 =
                                    constructor_rot_imm(ctx, pattern3_0, expr1_0, expr0_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/s390x/lower.isle line 560.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = constructor_neg_reg(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr3_0 = constructor_rot_reg(ctx, pattern3_0, expr2_0, expr1_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::AtomicRmw {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                    flags: pattern5_2,
                    op: ref pattern5_3,
                } => {
                    if let &Opcode::AtomicRmw = &pattern5_0 {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, &pattern5_1);
                        if let Some(()) = C::bigendian(ctx, pattern5_2) {
                            match &pattern5_3 {
                                &AtomicRmwOp::Add => {
                                    // Rule at src/isa/s390x/lower.isle line 1519.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = C::zero_offset(ctx);
                                    let expr2_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr1_0,
                                    )?;
                                    let expr3_0 = constructor_atomic_rmw_add(
                                        ctx, pattern3_0, expr0_0, &expr2_0,
                                    )?;
                                    let expr4_0 = C::value_reg(ctx, expr3_0);
                                    return Some(expr4_0);
                                }
                                &AtomicRmwOp::And => {
                                    // Rule at src/isa/s390x/lower.isle line 1501.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = C::zero_offset(ctx);
                                    let expr2_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr1_0,
                                    )?;
                                    let expr3_0 = constructor_atomic_rmw_and(
                                        ctx, pattern3_0, expr0_0, &expr2_0,
                                    )?;
                                    let expr4_0 = C::value_reg(ctx, expr3_0);
                                    return Some(expr4_0);
                                }
                                &AtomicRmwOp::Or => {
                                    // Rule at src/isa/s390x/lower.isle line 1507.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = C::zero_offset(ctx);
                                    let expr2_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr1_0,
                                    )?;
                                    let expr3_0 = constructor_atomic_rmw_or(
                                        ctx, pattern3_0, expr0_0, &expr2_0,
                                    )?;
                                    let expr4_0 = C::value_reg(ctx, expr3_0);
                                    return Some(expr4_0);
                                }
                                &AtomicRmwOp::Sub => {
                                    // Rule at src/isa/s390x/lower.isle line 1525.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = constructor_neg_reg(ctx, pattern3_0, expr0_0)?;
                                    let expr2_0 = C::zero_offset(ctx);
                                    let expr3_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr2_0,
                                    )?;
                                    let expr4_0 = constructor_atomic_rmw_add(
                                        ctx, pattern3_0, expr1_0, &expr3_0,
                                    )?;
                                    let expr5_0 = C::value_reg(ctx, expr4_0);
                                    return Some(expr5_0);
                                }
                                &AtomicRmwOp::Xor => {
                                    // Rule at src/isa/s390x/lower.isle line 1513.
                                    let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                    let expr1_0 = C::zero_offset(ctx);
                                    let expr2_0 = constructor_lower_address(
                                        ctx, pattern5_2, pattern7_0, expr1_0,
                                    )?;
                                    let expr3_0 = constructor_atomic_rmw_xor(
                                        ctx, pattern3_0, expr0_0, &expr2_0,
                                    )?;
                                    let expr4_0 = C::value_reg(ctx, expr3_0);
                                    return Some(expr4_0);
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::FcvtToUint => {
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 1057.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_fcmp_reg(ctx, pattern7_0, expr0_0, expr0_0)?;
                            let expr2_0 = FloatCC::Unordered;
                            let expr3_0 = C::floatcc_as_cond(ctx, &expr2_0);
                            let expr4_0 = C::trap_code_bad_conversion_to_integer(ctx);
                            let expr5_0 = constructor_trap_if(ctx, &expr1_0, &expr3_0, &expr4_0)?;
                            let expr6_0 = constructor_fcvt_to_uint_reg_with_flags(
                                ctx, pattern3_0, pattern7_0, expr0_0,
                            )?;
                            let expr7_0 = FloatCC::Unordered;
                            let expr8_0 = C::floatcc_as_cond(ctx, &expr7_0);
                            let expr9_0 = C::trap_code_integer_overflow(ctx);
                            let expr10_0 = constructor_trap_if(ctx, &expr6_0, &expr8_0, &expr9_0)?;
                            let expr11_0 = C::value_reg(ctx, expr10_0);
                            return Some(expr11_0);
                        }
                        &Opcode::FcvtToUintSat => {
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 1098.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 =
                                constructor_fcvt_to_uint_reg(ctx, pattern3_0, pattern7_0, expr0_0)?;
                            let expr2_0 = constructor_fcmp_reg(ctx, pattern7_0, expr0_0, expr0_0)?;
                            let expr3_0 = FloatCC::Unordered;
                            let expr4_0 = C::floatcc_as_cond(ctx, &expr3_0);
                            let expr5_0: i16 = 0;
                            let expr6_0 =
                                constructor_cmov_imm(ctx, pattern3_0, &expr4_0, expr5_0, expr1_0)?;
                            let expr7_0 = constructor_with_flags_1(ctx, &expr2_0, &expr6_0)?;
                            let expr8_0 = C::value_reg(ctx, expr7_0);
                            return Some(expr8_0);
                        }
                        &Opcode::FcvtToSint => {
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 1078.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 = constructor_fcmp_reg(ctx, pattern7_0, expr0_0, expr0_0)?;
                            let expr2_0 = FloatCC::Unordered;
                            let expr3_0 = C::floatcc_as_cond(ctx, &expr2_0);
                            let expr4_0 = C::trap_code_bad_conversion_to_integer(ctx);
                            let expr5_0 = constructor_trap_if(ctx, &expr1_0, &expr3_0, &expr4_0)?;
                            let expr6_0 = constructor_fcvt_to_sint_reg_with_flags(
                                ctx, pattern3_0, pattern7_0, expr0_0,
                            )?;
                            let expr7_0 = FloatCC::Unordered;
                            let expr8_0 = C::floatcc_as_cond(ctx, &expr7_0);
                            let expr9_0 = C::trap_code_integer_overflow(ctx);
                            let expr10_0 = constructor_trap_if(ctx, &expr6_0, &expr8_0, &expr9_0)?;
                            let expr11_0 = C::value_reg(ctx, expr10_0);
                            return Some(expr11_0);
                        }
                        &Opcode::FcvtToSintSat => {
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            // Rule at src/isa/s390x/lower.isle line 1115.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0 =
                                constructor_fcvt_to_sint_reg(ctx, pattern3_0, pattern7_0, expr0_0)?;
                            let expr2_0 = constructor_fcmp_reg(ctx, pattern7_0, expr0_0, expr0_0)?;
                            let expr3_0 = FloatCC::Unordered;
                            let expr4_0 = C::floatcc_as_cond(ctx, &expr3_0);
                            let expr5_0: i16 = 0;
                            let expr6_0 =
                                constructor_cmov_imm(ctx, pattern3_0, &expr4_0, expr5_0, expr1_0)?;
                            let expr7_0 = constructor_with_flags_1(ctx, &expr2_0, &expr6_0)?;
                            let expr8_0 = C::value_reg(ctx, expr7_0);
                            return Some(expr8_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::ty_8_or_16(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } = &pattern4_0
            {
                match &pattern5_0 {
                    &Opcode::Umulhi => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, &pattern5_1);
                        // Rule at src/isa/s390x/lower.isle line 245.
                        let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_reg_zext32(ctx, pattern7_1)?;
                        let expr2_0: Type = I32;
                        let expr3_0 = constructor_mul_reg(ctx, expr2_0, expr0_0, expr1_0)?;
                        let expr4_0: Type = I32;
                        let expr5_0 = C::ty_bits(ctx, pattern3_0);
                        let expr6_0 = constructor_lshr_imm(ctx, expr4_0, expr3_0, expr5_0)?;
                        let expr7_0 = C::value_reg(ctx, expr6_0);
                        return Some(expr7_0);
                    }
                    &Opcode::Smulhi => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, &pattern5_1);
                        // Rule at src/isa/s390x/lower.isle line 267.
                        let expr0_0 = constructor_put_in_reg_sext32(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern7_1)?;
                        let expr2_0: Type = I32;
                        let expr3_0 = constructor_mul_reg(ctx, expr2_0, expr0_0, expr1_0)?;
                        let expr4_0: Type = I32;
                        let expr5_0 = C::ty_bits(ctx, pattern3_0);
                        let expr6_0 = constructor_ashr_imm(ctx, expr4_0, expr3_0, expr5_0)?;
                        let expr7_0 = C::value_reg(ctx, expr6_0);
                        return Some(expr7_0);
                    }
                    &Opcode::Rotl => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, &pattern5_1);
                        if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                            if let Some(pattern9_0) = C::i64_from_negated_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 546.
                                let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                                let expr1_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                                let expr2_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr3_0 = C::mask_amt_imm(ctx, pattern3_0, pattern9_0);
                                let expr4_0 = constructor_lshl_imm(ctx, expr1_0, expr0_0, expr2_0)?;
                                let expr5_0 = constructor_lshr_imm(ctx, expr1_0, expr0_0, expr3_0)?;
                                let expr6_0 =
                                    constructor_or_reg(ctx, pattern3_0, expr4_0, expr5_0)?;
                                let expr7_0 = C::value_reg(ctx, expr6_0);
                                return Some(expr7_0);
                            }
                        }
                        // Rule at src/isa/s390x/lower.isle line 534.
                        let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                        let expr1_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                        let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr3_0 = constructor_neg_reg(ctx, pattern3_0, expr2_0)?;
                        let expr4_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr2_0)?;
                        let expr5_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr3_0)?;
                        let expr6_0 = constructor_lshl_reg(ctx, expr1_0, expr0_0, expr4_0)?;
                        let expr7_0 = constructor_lshr_reg(ctx, expr1_0, expr0_0, expr5_0)?;
                        let expr8_0 = constructor_or_reg(ctx, pattern3_0, expr6_0, expr7_0)?;
                        let expr9_0 = C::value_reg(ctx, expr8_0);
                        return Some(expr9_0);
                    }
                    &Opcode::Rotr => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, &pattern5_1);
                        if let Some(pattern8_0) = C::i64_from_value(ctx, pattern7_1) {
                            if let Some(pattern9_0) = C::i64_from_negated_value(ctx, pattern7_1) {
                                // Rule at src/isa/s390x/lower.isle line 584.
                                let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                                let expr1_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                                let expr2_0 = C::mask_amt_imm(ctx, pattern3_0, pattern8_0);
                                let expr3_0 = C::mask_amt_imm(ctx, pattern3_0, pattern9_0);
                                let expr4_0 = constructor_lshl_imm(ctx, expr1_0, expr0_0, expr3_0)?;
                                let expr5_0 = constructor_lshr_imm(ctx, expr1_0, expr0_0, expr2_0)?;
                                let expr6_0 =
                                    constructor_or_reg(ctx, pattern3_0, expr4_0, expr5_0)?;
                                let expr7_0 = C::value_reg(ctx, expr6_0);
                                return Some(expr7_0);
                            }
                        }
                        // Rule at src/isa/s390x/lower.isle line 572.
                        let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern7_0)?;
                        let expr1_0 = constructor_ty_ext32(ctx, pattern3_0)?;
                        let expr2_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr3_0 = constructor_neg_reg(ctx, pattern3_0, expr2_0)?;
                        let expr4_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr2_0)?;
                        let expr5_0 = constructor_mask_amt_reg(ctx, pattern3_0, expr3_0)?;
                        let expr6_0 = constructor_lshl_reg(ctx, expr1_0, expr0_0, expr5_0)?;
                        let expr7_0 = constructor_lshr_reg(ctx, expr1_0, expr0_0, expr4_0)?;
                        let expr8_0 = constructor_or_reg(ctx, pattern3_0, expr6_0, expr7_0)?;
                        let expr9_0 = C::value_reg(ctx, expr8_0);
                        return Some(expr9_0);
                    }
                    _ => {}
                }
            }
        }
        if let Some(pattern3_0) = C::gpr32_ty(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Ctz => {
                            // Rule at src/isa/s390x/lower.isle line 859.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr2_0 = constructor_ctz_guardbit(ctx, pattern3_0)?;
                            let expr3_0 =
                                constructor_or_uimm16shifted(ctx, expr0_0, expr1_0, expr2_0)?;
                            let expr4_0: Type = I64;
                            let expr5_0: Type = I64;
                            let expr6_0 = constructor_neg_reg(ctx, expr5_0, expr3_0)?;
                            let expr7_0 = constructor_and_reg(ctx, expr4_0, expr3_0, expr6_0)?;
                            let expr8_0: i16 = 64;
                            let expr9_0 = constructor_clz_reg(ctx, expr8_0, expr7_0)?;
                            let expr10_0: u64 = 63;
                            let expr11_0 = constructor_imm(ctx, pattern3_0, expr10_0)?;
                            let expr12_0 = constructor_regpair_hi(ctx, &expr9_0)?;
                            let expr13_0 =
                                constructor_sub_reg(ctx, pattern3_0, expr11_0, expr12_0)?;
                            let expr14_0 = C::value_reg(ctx, expr13_0);
                            return Some(expr14_0);
                        }
                        &Opcode::Uextend => {
                            // Rule at src/isa/s390x/lower.isle line 603.
                            let expr0_0 = constructor_put_in_reg_zext32(ctx, pattern5_1)?;
                            let expr1_0 = C::value_reg(ctx, expr0_0);
                            return Some(expr1_0);
                        }
                        &Opcode::Sextend => {
                            // Rule at src/isa/s390x/lower.isle line 614.
                            let expr0_0 = constructor_put_in_reg_sext32(ctx, pattern5_1)?;
                            let expr1_0 = C::value_reg(ctx, expr0_0);
                            return Some(expr1_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    match &pattern5_0 {
                        &Opcode::Uload8 => {
                            // Rule at src/isa/s390x/lower.isle line 1255.
                            let expr0_0: Type = I8;
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr2_0 = constructor_zext32_mem(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Sload8 => {
                            // Rule at src/isa/s390x/lower.isle line 1266.
                            let expr0_0: Type = I8;
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr2_0 = constructor_sext32_mem(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Uload16 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1282.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev16(ctx, &expr0_0)?;
                                let expr2_0: Type = I16;
                                let expr3_0 = constructor_zext32_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1277.
                                let expr0_0: Type = I16;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_zext32_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                        }
                        &Opcode::Sload16 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1307.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev16(ctx, &expr0_0)?;
                                let expr2_0: Type = I16;
                                let expr3_0 = constructor_sext32_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1302.
                                let expr0_0: Type = I16;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_sext32_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::gpr64_ty(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Ctz => {
                            // Rule at src/isa/s390x/lower.isle line 874.
                            let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                            let expr1_0: Type = I64;
                            let expr2_0: Type = I64;
                            let expr3_0 = constructor_neg_reg(ctx, expr2_0, expr0_0)?;
                            let expr4_0 = constructor_and_reg(ctx, expr1_0, expr0_0, expr3_0)?;
                            let expr5_0: i16 = -1;
                            let expr6_0 = constructor_clz_reg(ctx, expr5_0, expr4_0)?;
                            let expr7_0: Type = I64;
                            let expr8_0: Type = I64;
                            let expr9_0: u64 = 63;
                            let expr10_0 = constructor_imm(ctx, expr8_0, expr9_0)?;
                            let expr11_0 = constructor_regpair_hi(ctx, &expr6_0)?;
                            let expr12_0 = constructor_sub_reg(ctx, expr7_0, expr10_0, expr11_0)?;
                            let expr13_0 = C::value_reg(ctx, expr12_0);
                            return Some(expr13_0);
                        }
                        &Opcode::Uextend => {
                            // Rule at src/isa/s390x/lower.isle line 607.
                            let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern5_1)?;
                            let expr1_0 = C::value_reg(ctx, expr0_0);
                            return Some(expr1_0);
                        }
                        &Opcode::Sextend => {
                            // Rule at src/isa/s390x/lower.isle line 618.
                            let expr0_0 = constructor_put_in_reg_sext64(ctx, pattern5_1)?;
                            let expr1_0 = C::value_reg(ctx, expr0_0);
                            return Some(expr1_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Load {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    flags: pattern5_2,
                    offset: pattern5_3,
                } => {
                    match &pattern5_0 {
                        &Opcode::Uload8 => {
                            // Rule at src/isa/s390x/lower.isle line 1259.
                            let expr0_0: Type = I8;
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr2_0 = constructor_zext64_mem(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Sload8 => {
                            // Rule at src/isa/s390x/lower.isle line 1270.
                            let expr0_0: Type = I8;
                            let expr1_0 =
                                constructor_lower_address(ctx, pattern5_2, pattern5_1, pattern5_3)?;
                            let expr2_0 = constructor_sext64_mem(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Uload16 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1293.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev16(ctx, &expr0_0)?;
                                let expr2_0: Type = I16;
                                let expr3_0 = constructor_zext64_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1288.
                                let expr0_0: Type = I16;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_zext64_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                        }
                        &Opcode::Sload16 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1318.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev16(ctx, &expr0_0)?;
                                let expr2_0: Type = I16;
                                let expr3_0 = constructor_sext64_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1313.
                                let expr0_0: Type = I16;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_sext64_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                        }
                        &Opcode::Uload32 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1332.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev32(ctx, &expr0_0)?;
                                let expr2_0: Type = I32;
                                let expr3_0 = constructor_zext64_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1327.
                                let expr0_0: Type = I32;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_zext64_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                        }
                        &Opcode::Sload32 => {
                            if let Some(()) = C::littleendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1346.
                                let expr0_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr1_0 = constructor_loadrev32(ctx, &expr0_0)?;
                                let expr2_0: Type = I32;
                                let expr3_0 = constructor_sext64_reg(ctx, expr2_0, expr1_0)?;
                                let expr4_0 = C::value_reg(ctx, expr3_0);
                                return Some(expr4_0);
                            }
                            if let Some(()) = C::bigendian(ctx, pattern5_2) {
                                // Rule at src/isa/s390x/lower.isle line 1341.
                                let expr0_0: Type = I32;
                                let expr1_0 = constructor_lower_address(
                                    ctx, pattern5_2, pattern5_1, pattern5_3,
                                )?;
                                let expr2_0 = constructor_sext64_mem(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
    }
    return None;
}

// Generated as internal constructor for term lower_branch.
pub fn constructor_lower_branch<C: Context>(
    ctx: &mut C,
    arg0: Inst,
    arg1: &VecMachLabel,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    match &pattern1_0 {
        &InstructionData::BranchTable {
            opcode: ref pattern2_0,
            arg: pattern2_1,
            destination: pattern2_2,
            table: pattern2_3,
        } => {
            if let &Opcode::BrTable = &pattern2_0 {
                let pattern4_0 = arg1;
                // Rule at src/isa/s390x/lower.isle line 1799.
                let expr0_0 = constructor_put_in_reg_zext64(ctx, pattern2_1)?;
                let expr1_0: Type = I64;
                let expr2_0 = C::vec_length_minus1(ctx, pattern4_0);
                let expr3_0 = constructor_icmpu_uimm32(ctx, expr1_0, expr0_0, expr2_0)?;
                let expr4_0 = IntCC::UnsignedGreaterThanOrEqual;
                let expr5_0 = C::intcc_as_cond(ctx, &expr4_0);
                let expr6_0 = constructor_bool(ctx, &expr3_0, &expr5_0)?;
                let expr7_0: u8 = 0;
                let expr8_0 = C::vec_element(ctx, pattern4_0, expr7_0);
                let expr9_0 = constructor_oneway_cond_br_bool(ctx, &expr6_0, expr8_0)?;
                let expr10_0 = constructor_value_regs_none(ctx, &expr9_0)?;
                let expr11_0: Type = I64;
                let expr12_0: u8 = 2;
                let expr13_0 = constructor_lshl_imm(ctx, expr11_0, expr0_0, expr12_0)?;
                let expr14_0 = constructor_jt_sequence(ctx, expr13_0, pattern4_0)?;
                let expr15_0 = constructor_value_regs_none(ctx, &expr14_0)?;
                return Some(expr15_0);
            }
        }
        &InstructionData::Branch {
            opcode: ref pattern2_0,
            args: pattern2_1,
            destination: pattern2_2,
        } => {
            match &pattern2_0 {
                &Opcode::Brz => {
                    let (pattern4_0, pattern4_1) = C::unwrap_head_value_list_1(ctx, pattern2_1);
                    let pattern5_0 = arg1;
                    // Rule at src/isa/s390x/lower.isle line 1832.
                    let expr0_0 = constructor_value_nonzero(ctx, pattern4_0)?;
                    let expr1_0 = constructor_invert_bool(ctx, &expr0_0)?;
                    let expr2_0: u8 = 0;
                    let expr3_0 = C::vec_element(ctx, pattern5_0, expr2_0);
                    let expr4_0: u8 = 1;
                    let expr5_0 = C::vec_element(ctx, pattern5_0, expr4_0);
                    let expr6_0 = constructor_cond_br_bool(ctx, &expr1_0, expr3_0, expr5_0)?;
                    let expr7_0 = constructor_value_regs_none(ctx, &expr6_0)?;
                    return Some(expr7_0);
                }
                &Opcode::Brnz => {
                    let (pattern4_0, pattern4_1) = C::unwrap_head_value_list_1(ctx, pattern2_1);
                    let pattern5_0 = arg1;
                    // Rule at src/isa/s390x/lower.isle line 1843.
                    let expr0_0 = constructor_value_nonzero(ctx, pattern4_0)?;
                    let expr1_0: u8 = 0;
                    let expr2_0 = C::vec_element(ctx, pattern5_0, expr1_0);
                    let expr3_0: u8 = 1;
                    let expr4_0 = C::vec_element(ctx, pattern5_0, expr3_0);
                    let expr5_0 = constructor_cond_br_bool(ctx, &expr0_0, expr2_0, expr4_0)?;
                    let expr6_0 = constructor_value_regs_none(ctx, &expr5_0)?;
                    return Some(expr6_0);
                }
                _ => {}
            }
        }
        &InstructionData::Jump {
            opcode: ref pattern2_0,
            args: pattern2_1,
            destination: pattern2_2,
        } => {
            if let &Opcode::Jump = &pattern2_0 {
                let pattern4_0 = C::value_list_slice(ctx, pattern2_1);
                let pattern5_0 = arg1;
                // Rule at src/isa/s390x/lower.isle line 1791.
                let expr0_0: u8 = 0;
                let expr1_0 = C::vec_element(ctx, pattern5_0, expr0_0);
                let expr2_0 = constructor_jump_impl(ctx, expr1_0)?;
                let expr3_0 = constructor_value_regs_none(ctx, &expr2_0)?;
                return Some(expr3_0);
            }
        }
        &InstructionData::BranchInt {
            opcode: ref pattern2_0,
            args: pattern2_1,
            cond: ref pattern2_2,
            destination: pattern2_3,
        } => {
            if let &Opcode::Brif = &pattern2_0 {
                let (pattern4_0, pattern4_1) = C::unwrap_head_value_list_1(ctx, pattern2_1);
                if let Some(pattern5_0) = C::def_inst(ctx, pattern4_0) {
                    let pattern6_0 = C::inst_data(ctx, pattern5_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern7_0,
                        args: ref pattern7_1,
                    } = &pattern6_0
                    {
                        if let &Opcode::Ifcmp = &pattern7_0 {
                            let (pattern9_0, pattern9_1) =
                                C::unpack_value_array_2(ctx, &pattern7_1);
                            let pattern10_0 = arg1;
                            // Rule at src/isa/s390x/lower.isle line 1854.
                            let expr0_0: bool = false;
                            let expr1_0 = constructor_icmp_val(
                                ctx,
                                expr0_0,
                                &pattern2_2,
                                pattern9_0,
                                pattern9_1,
                            )?;
                            let expr2_0: u8 = 0;
                            let expr3_0 = C::vec_element(ctx, pattern10_0, expr2_0);
                            let expr4_0: u8 = 1;
                            let expr5_0 = C::vec_element(ctx, pattern10_0, expr4_0);
                            let expr6_0 =
                                constructor_cond_br_bool(ctx, &expr1_0, expr3_0, expr5_0)?;
                            let expr7_0 = constructor_value_regs_none(ctx, &expr6_0)?;
                            return Some(expr7_0);
                        }
                    }
                }
            }
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term value_regs_ifcout.
pub fn constructor_value_regs_ifcout<C: Context>(ctx: &mut C, arg0: Reg) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/lower.isle line 154.
    let expr0_0: Type = I64;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = C::writable_reg_to_reg(ctx, expr1_0);
    let expr3_0 = C::value_regs(ctx, pattern0_0, expr2_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term zero_divisor_check_needed.
pub fn constructor_zero_divisor_check_needed<C: Context>(ctx: &mut C, arg0: Value) -> Option<bool> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::i64_from_value(ctx, pattern0_0) {
        let pattern2_0 = 0;
        if let Some(pattern3_0) = C::i64_nonequal(ctx, pattern1_0, pattern2_0) {
            // Rule at src/isa/s390x/lower.isle line 344.
            let expr0_0: bool = false;
            return Some(expr0_0);
        }
    }
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(()) = C::allow_div_traps(ctx, pattern1_0) {
        // Rule at src/isa/s390x/lower.isle line 345.
        let expr0_0: bool = false;
        return Some(expr0_0);
    }
    // Rule at src/isa/s390x/lower.isle line 346.
    let expr0_0: bool = true;
    return Some(expr0_0);
}

// Generated as internal constructor for term maybe_trap_if_zero_divisor.
pub fn constructor_maybe_trap_if_zero_divisor<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Type,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == true {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/lower.isle line 352.
        let expr0_0: i16 = 0;
        let expr1_0 = IntCC::Equal;
        let expr2_0 = C::intcc_as_cond(ctx, &expr1_0);
        let expr3_0 = C::trap_code_division_by_zero(ctx);
        let expr4_0 = constructor_icmps_simm16_and_trap(
            ctx, pattern2_0, pattern3_0, expr0_0, &expr2_0, &expr3_0,
        )?;
        return Some(expr4_0);
    }
    if pattern0_0 == false {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/s390x/lower.isle line 351.
        let expr0_0 = C::invalid_reg(ctx);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term div_overflow_check_needed.
pub fn constructor_div_overflow_check_needed<C: Context>(ctx: &mut C, arg0: Value) -> Option<bool> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::i64_from_value(ctx, pattern0_0) {
        let pattern2_0 = -1;
        if let Some(pattern3_0) = C::i64_nonequal(ctx, pattern1_0, pattern2_0) {
            // Rule at src/isa/s390x/lower.isle line 425.
            let expr0_0: bool = false;
            return Some(expr0_0);
        }
    }
    // Rule at src/isa/s390x/lower.isle line 426.
    let expr0_0: bool = true;
    return Some(expr0_0);
}

// Generated as internal constructor for term maybe_trap_if_sdiv_overflow.
pub fn constructor_maybe_trap_if_sdiv_overflow<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Type,
    arg2: Type,
    arg3: &RegPair,
    arg4: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == true {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/s390x/lower.isle line 439.
        let expr0_0 = constructor_int_max(ctx, pattern3_0)?;
        let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
        let expr2_0 = constructor_regpair_lo(ctx, pattern4_0)?;
        let expr3_0 = constructor_xor_reg(ctx, pattern2_0, expr1_0, expr2_0)?;
        let expr4_0 = constructor_and_reg(ctx, pattern2_0, expr3_0, pattern5_0)?;
        let expr5_0: i16 = -1;
        let expr6_0 = IntCC::Equal;
        let expr7_0 = C::intcc_as_cond(ctx, &expr6_0);
        let expr8_0 = C::trap_code_integer_overflow(ctx);
        let expr9_0 = constructor_icmps_simm16_and_trap(
            ctx, pattern2_0, expr4_0, expr5_0, &expr7_0, &expr8_0,
        )?;
        return Some(expr9_0);
    }
    if pattern0_0 == false {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/s390x/lower.isle line 438.
        let expr0_0 = C::invalid_reg(ctx);
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term int_max.
pub fn constructor_int_max<C: Context>(ctx: &mut C, arg0: Type) -> Option<u64> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/lower.isle line 447.
        let expr0_0: u64 = 127;
        return Some(expr0_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/lower.isle line 448.
        let expr0_0: u64 = 32767;
        return Some(expr0_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/lower.isle line 449.
        let expr0_0: u64 = 2147483647;
        return Some(expr0_0);
    }
    if pattern0_0 == I64 {
        // Rule at src/isa/s390x/lower.isle line 450.
        let expr0_0: u64 = 9223372036854775807;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term maybe_avoid_srem_overflow.
pub fn constructor_maybe_avoid_srem_overflow<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Type,
    arg2: &RegPair,
    arg3: Reg,
) -> Option<RegPair> {
    let pattern0_0 = arg0;
    if pattern0_0 == true {
        let pattern2_0 = arg1;
        if pattern2_0 == I32 {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 468.
            return Some(pattern4_0.clone());
        }
        if pattern2_0 == I64 {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 469.
            let expr0_0: Type = I64;
            let expr1_0: Type = I64;
            let expr2_0: i16 = -1;
            let expr3_0 = constructor_icmps_simm16(ctx, expr1_0, pattern5_0, expr2_0)?;
            let expr4_0 = IntCC::Equal;
            let expr5_0 = C::intcc_as_cond(ctx, &expr4_0);
            let expr6_0: i16 = 0;
            let expr7_0 = constructor_cmov_imm_regpair_lo(
                ctx, expr0_0, &expr3_0, &expr5_0, expr6_0, pattern4_0,
            )?;
            return Some(expr7_0);
        }
    }
    if pattern0_0 == false {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 467.
        return Some(pattern3_0.clone());
    }
    return None;
}

// Generated as internal constructor for term cast_bool.
pub fn constructor_cast_bool<C: Context>(ctx: &mut C, arg0: Type, arg1: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == B1 {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B1 {
            // Rule at src/isa/s390x/lower.isle line 766.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
        if pattern3_0 == B8 {
            // Rule at src/isa/s390x/lower.isle line 767.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if pattern0_0 == B8 {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B8 {
            // Rule at src/isa/s390x/lower.isle line 768.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if pattern0_0 == I8 {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B8 {
            // Rule at src/isa/s390x/lower.isle line 769.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if let Some(pattern1_0) = C::fits_in_16(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B16 {
            // Rule at src/isa/s390x/lower.isle line 770.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if let Some(pattern1_0) = C::fits_in_32(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B32 {
            // Rule at src/isa/s390x/lower.isle line 771.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if let Some(pattern1_0) = C::fits_in_64(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B64 {
            // Rule at src/isa/s390x/lower.isle line 772.
            let expr0_0 = C::put_in_reg(ctx, pattern2_0);
            return Some(expr0_0);
        }
    }
    if let Some(pattern1_0) = C::gpr32_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B1 {
            // Rule at src/isa/s390x/lower.isle line 775.
            let expr0_0: Type = I32;
            let expr1_0: Type = I32;
            let expr2_0 = C::put_in_reg(ctx, pattern2_0);
            let expr3_0: u8 = 31;
            let expr4_0 = constructor_lshl_imm(ctx, expr1_0, expr2_0, expr3_0)?;
            let expr5_0: u8 = 31;
            let expr6_0 = constructor_ashr_imm(ctx, expr0_0, expr4_0, expr5_0)?;
            return Some(expr6_0);
        }
        if pattern3_0 == B8 {
            // Rule at src/isa/s390x/lower.isle line 781.
            let expr0_0: Type = I8;
            let expr1_0 = C::put_in_reg(ctx, pattern2_0);
            let expr2_0 = constructor_sext32_reg(ctx, expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
        if pattern3_0 == B16 {
            // Rule at src/isa/s390x/lower.isle line 783.
            let expr0_0: Type = I16;
            let expr1_0 = C::put_in_reg(ctx, pattern2_0);
            let expr2_0 = constructor_sext32_reg(ctx, expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
    }
    if let Some(pattern1_0) = C::gpr64_ty(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if pattern3_0 == B1 {
            // Rule at src/isa/s390x/lower.isle line 777.
            let expr0_0: Type = I64;
            let expr1_0: Type = I64;
            let expr2_0 = C::put_in_reg(ctx, pattern2_0);
            let expr3_0: u8 = 63;
            let expr4_0 = constructor_lshl_imm(ctx, expr1_0, expr2_0, expr3_0)?;
            let expr5_0: u8 = 63;
            let expr6_0 = constructor_ashr_imm(ctx, expr0_0, expr4_0, expr5_0)?;
            return Some(expr6_0);
        }
        if pattern3_0 == B8 {
            // Rule at src/isa/s390x/lower.isle line 785.
            let expr0_0: Type = I8;
            let expr1_0 = C::put_in_reg(ctx, pattern2_0);
            let expr2_0 = constructor_sext64_reg(ctx, expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
        if pattern3_0 == B16 {
            // Rule at src/isa/s390x/lower.isle line 787.
            let expr0_0: Type = I16;
            let expr1_0 = C::put_in_reg(ctx, pattern2_0);
            let expr2_0 = constructor_sext64_reg(ctx, expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
        if pattern3_0 == B32 {
            // Rule at src/isa/s390x/lower.isle line 789.
            let expr0_0: Type = I32;
            let expr1_0 = C::put_in_reg(ctx, pattern2_0);
            let expr2_0 = constructor_sext64_reg(ctx, expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
    }
    return None;
}

// Generated as internal constructor for term clz_offset.
pub fn constructor_clz_offset<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/lower.isle line 814.
        let expr0_0: Type = I8;
        let expr1_0: i16 = -56;
        let expr2_0 = constructor_add_simm16(ctx, expr0_0, pattern2_0, expr1_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I16 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/lower.isle line 815.
        let expr0_0: Type = I16;
        let expr1_0: i16 = -48;
        let expr2_0 = constructor_add_simm16(ctx, expr0_0, pattern2_0, expr1_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/lower.isle line 816.
        let expr0_0: Type = I32;
        let expr1_0: i16 = -32;
        let expr2_0 = constructor_add_simm16(ctx, expr0_0, pattern2_0, expr1_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        // Rule at src/isa/s390x/lower.isle line 817.
        let expr0_0: Type = I64;
        let expr1_0 = constructor_copy_reg(ctx, expr0_0, pattern2_0)?;
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term ctz_guardbit.
pub fn constructor_ctz_guardbit<C: Context>(ctx: &mut C, arg0: Type) -> Option<UImm16Shifted> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8 {
        // Rule at src/isa/s390x/lower.isle line 866.
        let expr0_0: u16 = 256;
        let expr1_0: u8 = 0;
        let expr2_0 = C::uimm16shifted(ctx, expr0_0, expr1_0);
        return Some(expr2_0);
    }
    if pattern0_0 == I16 {
        // Rule at src/isa/s390x/lower.isle line 867.
        let expr0_0: u16 = 1;
        let expr1_0: u8 = 16;
        let expr2_0 = C::uimm16shifted(ctx, expr0_0, expr1_0);
        return Some(expr2_0);
    }
    if pattern0_0 == I32 {
        // Rule at src/isa/s390x/lower.isle line 868.
        let expr0_0: u16 = 1;
        let expr1_0: u8 = 32;
        let expr2_0 = C::uimm16shifted(ctx, expr0_0, expr1_0);
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term istore8_impl.
pub fn constructor_istore8_impl<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(pattern2_0) = C::u8_from_value(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1428.
        let expr0_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr1_0 = constructor_store8_imm(ctx, pattern2_0, &expr0_0)?;
        return Some(expr1_0);
    }
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/s390x/lower.isle line 1424.
    let expr0_0 = C::put_in_reg(ctx, pattern1_0);
    let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern2_0, pattern3_0)?;
    let expr2_0 = constructor_store8(ctx, expr0_0, &expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term istore16_impl.
pub fn constructor_istore16_impl<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let Some(()) = C::littleendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if let Some(pattern3_0) = C::i16_from_swapped_value(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 1454.
            let expr0_0 = constructor_lower_address(ctx, pattern0_0, pattern4_0, pattern5_0)?;
            let expr1_0 = constructor_store16_imm(ctx, pattern3_0, &expr0_0)?;
            return Some(expr1_0);
        }
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1446.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_storerev16(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    if let Some(()) = C::bigendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if let Some(pattern3_0) = C::i16_from_value(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 1450.
            let expr0_0 = constructor_lower_address(ctx, pattern0_0, pattern4_0, pattern5_0)?;
            let expr1_0 = constructor_store16_imm(ctx, pattern3_0, &expr0_0)?;
            return Some(expr1_0);
        }
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1442.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_store16(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term istore32_impl.
pub fn constructor_istore32_impl<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let Some(()) = C::littleendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1476.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_storerev32(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    if let Some(()) = C::bigendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if let Some(pattern3_0) = C::i16_from_value(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 1472.
            let expr0_0 = constructor_lower_address(ctx, pattern0_0, pattern4_0, pattern5_0)?;
            let expr1_0 = constructor_store32_simm16(ctx, pattern3_0, &expr0_0)?;
            return Some(expr1_0);
        }
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1468.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_store32(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term istore64_impl.
pub fn constructor_istore64_impl<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    if let Some(()) = C::littleendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1494.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_storerev64(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    if let Some(()) = C::bigendian(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if let Some(pattern3_0) = C::i16_from_value(ctx, pattern2_0) {
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/s390x/lower.isle line 1490.
            let expr0_0 = constructor_lower_address(ctx, pattern0_0, pattern4_0, pattern5_0)?;
            let expr1_0 = constructor_store64_simm16(ctx, pattern3_0, &expr0_0)?;
            return Some(expr1_0);
        }
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1486.
        let expr0_0 = C::put_in_reg(ctx, pattern2_0);
        let expr1_0 = constructor_lower_address(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr2_0 = constructor_store64(ctx, expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term atomic_store_impl.
pub fn constructor_atomic_store_impl<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    // Rule at src/isa/s390x/lower.isle line 1581.
    let expr0_0 = constructor_value_regs_none(ctx, pattern0_0)?;
    let expr1_0 = constructor_fence_impl(ctx)?;
    let expr2_0 = constructor_value_regs_none(ctx, &expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term icmp_val.
pub fn constructor_icmp_val<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: &IntCC,
    arg2: Value,
    arg3: Value,
) -> Option<ProducesBool> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(()) = C::signed(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1648.
        let expr0_0 = constructor_icmps_val(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr1_0 = C::intcc_as_cond(ctx, pattern1_0);
        let expr2_0 = constructor_bool(ctx, &expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    if let Some(()) = C::unsigned(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/s390x/lower.isle line 1651.
        let expr0_0 = constructor_icmpu_val(ctx, pattern0_0, pattern3_0, pattern4_0)?;
        let expr1_0 = C::intcc_as_cond(ctx, pattern1_0);
        let expr2_0 = constructor_bool(ctx, &expr0_0, &expr1_0)?;
        return Some(expr2_0);
    }
    return None;
}

// Generated as internal constructor for term icmps_val.
pub fn constructor_icmps_val<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Value,
    arg2: Value,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    if pattern0_0 == true {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if let Some(pattern4_0) = C::fits_in_64(ctx, pattern3_0) {
            let pattern5_0 = arg2;
            if let Some(pattern6_0) = C::sinkable_inst(ctx, pattern5_0) {
                let pattern7_0 = C::inst_data(ctx, pattern6_0);
                if let &InstructionData::Load {
                    opcode: ref pattern8_0,
                    arg: pattern8_1,
                    flags: pattern8_2,
                    offset: pattern8_3,
                } = &pattern7_0
                {
                    match &pattern8_0 {
                        &Opcode::Sload16 => {
                            if let Some(()) = C::bigendian(ctx, pattern8_2) {
                                // Rule at src/isa/s390x/lower.isle line 1681.
                                let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                let expr1_0 = constructor_sink_sload16(ctx, pattern6_0)?;
                                let expr2_0 = constructor_icmps_mem_sext16(
                                    ctx, pattern4_0, expr0_0, &expr1_0,
                                )?;
                                return Some(expr2_0);
                            }
                        }
                        &Opcode::Sload32 => {
                            if let Some(()) = C::bigendian(ctx, pattern8_2) {
                                // Rule at src/isa/s390x/lower.isle line 1683.
                                let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                let expr1_0 = constructor_sink_sload32(ctx, pattern6_0)?;
                                let expr2_0 = constructor_icmps_mem_sext32(
                                    ctx, pattern4_0, expr0_0, &expr1_0,
                                )?;
                                return Some(expr2_0);
                            }
                        }
                        _ => {}
                    }
                }
            }
            let pattern6_0 = C::value_type(ctx, pattern5_0);
            if pattern6_0 == I16 {
                if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern5_0) {
                    let pattern9_0 = C::inst_data(ctx, pattern8_0);
                    if let &InstructionData::Load {
                        opcode: ref pattern10_0,
                        arg: pattern10_1,
                        flags: pattern10_2,
                        offset: pattern10_3,
                    } = &pattern9_0
                    {
                        if let &Opcode::Load = &pattern10_0 {
                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                // Rule at src/isa/s390x/lower.isle line 1677.
                                let expr0_0 = constructor_ty_ext32(ctx, pattern4_0)?;
                                let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern2_0)?;
                                let expr2_0 = constructor_sink_load(ctx, pattern8_0)?;
                                let expr3_0 =
                                    constructor_icmps_mem_sext16(ctx, expr0_0, expr1_0, &expr2_0)?;
                                return Some(expr3_0);
                            }
                        }
                    }
                }
            }
            if let Some(pattern7_0) = C::ty_32_or_64(ctx, pattern6_0) {
                if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern5_0) {
                    let pattern9_0 = C::inst_data(ctx, pattern8_0);
                    if let &InstructionData::Load {
                        opcode: ref pattern10_0,
                        arg: pattern10_1,
                        flags: pattern10_2,
                        offset: pattern10_3,
                    } = &pattern9_0
                    {
                        if let &Opcode::Load = &pattern10_0 {
                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                // Rule at src/isa/s390x/lower.isle line 1673.
                                let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                let expr1_0 = constructor_sink_load(ctx, pattern8_0)?;
                                let expr2_0 =
                                    constructor_icmps_mem(ctx, pattern4_0, expr0_0, &expr1_0)?;
                                return Some(expr2_0);
                            }
                        }
                    }
                }
            }
        }
    }
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::fits_in_64(ctx, pattern2_0) {
        let pattern4_0 = arg2;
        if let Some(pattern5_0) = C::i16_from_value(ctx, pattern4_0) {
            // Rule at src/isa/s390x/lower.isle line 1667.
            let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
            let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern1_0)?;
            let expr2_0 = constructor_icmps_simm16(ctx, expr0_0, expr1_0, pattern5_0)?;
            return Some(expr2_0);
        }
        if let Some(pattern5_0) = C::i32_from_value(ctx, pattern4_0) {
            // Rule at src/isa/s390x/lower.isle line 1669.
            let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
            let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern1_0)?;
            let expr2_0 = constructor_icmps_simm32(ctx, expr0_0, expr1_0, pattern5_0)?;
            return Some(expr2_0);
        }
        if let Some(pattern5_0) = C::def_inst(ctx, pattern4_0) {
            let pattern6_0 = C::inst_data(ctx, pattern5_0);
            if let &InstructionData::Unary {
                opcode: ref pattern7_0,
                arg: pattern7_1,
            } = &pattern6_0
            {
                if let &Opcode::Sextend = &pattern7_0 {
                    let pattern9_0 = C::value_type(ctx, pattern7_1);
                    if pattern9_0 == I32 {
                        // Rule at src/isa/s390x/lower.isle line 1663.
                        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr2_0 =
                            constructor_icmps_reg_sext32(ctx, pattern3_0, expr0_0, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/lower.isle line 1659.
        let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
        let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern1_0)?;
        let expr2_0 = constructor_put_in_reg_sext32(ctx, pattern4_0)?;
        let expr3_0 = constructor_icmps_reg(ctx, expr0_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    return None;
}

// Generated as internal constructor for term icmpu_val.
pub fn constructor_icmpu_val<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Value,
    arg2: Value,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    if pattern0_0 == true {
        let pattern2_0 = arg1;
        let pattern3_0 = C::value_type(ctx, pattern2_0);
        if let Some(pattern4_0) = C::fits_in_64(ctx, pattern3_0) {
            let pattern5_0 = arg2;
            if let Some(pattern6_0) = C::sinkable_inst(ctx, pattern5_0) {
                let pattern7_0 = C::inst_data(ctx, pattern6_0);
                if let &InstructionData::Load {
                    opcode: ref pattern8_0,
                    arg: pattern8_1,
                    flags: pattern8_2,
                    offset: pattern8_3,
                } = &pattern7_0
                {
                    match &pattern8_0 {
                        &Opcode::Uload16 => {
                            if let Some(pattern10_0) = C::def_inst(ctx, pattern8_1) {
                                if let Some((pattern11_0, pattern11_1, pattern11_2)) =
                                    C::symbol_value_data(ctx, pattern10_0)
                                {
                                    if let Some(()) = C::reloc_distance_near(ctx, &pattern11_1) {
                                        let pattern13_0 = C::i64_from_offset(ctx, pattern8_3);
                                        let closure14 = || {
                                            return Some(pattern11_2);
                                        };
                                        if let Some(pattern14_0) = closure14() {
                                            if let Some(pattern15_0) = C::memarg_symbol_offset_sum(
                                                ctx,
                                                pattern13_0,
                                                pattern14_0,
                                            ) {
                                                let pattern16_0 = C::inst_data(ctx, pattern6_0);
                                                if let &InstructionData::Load {
                                                    opcode: ref pattern17_0,
                                                    arg: pattern17_1,
                                                    flags: pattern17_2,
                                                    offset: pattern17_3,
                                                } = &pattern16_0
                                                {
                                                    if let &Opcode::Uload16 = &pattern17_0 {
                                                        if let Some(()) =
                                                            C::bigendian(ctx, pattern17_2)
                                                        {
                                                            // Rule at src/isa/s390x/lower.isle line 1716.
                                                            let expr0_0 =
                                                                C::put_in_reg(ctx, pattern2_0);
                                                            let expr1_0 = constructor_sink_uload16(
                                                                ctx, pattern6_0,
                                                            )?;
                                                            let expr2_0 =
                                                                constructor_icmpu_mem_zext16(
                                                                    ctx, pattern4_0, expr0_0,
                                                                    &expr1_0,
                                                                )?;
                                                            return Some(expr2_0);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        &Opcode::Uload32 => {
                            if let Some(()) = C::bigendian(ctx, pattern8_2) {
                                // Rule at src/isa/s390x/lower.isle line 1719.
                                let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                let expr1_0 = constructor_sink_uload32(ctx, pattern6_0)?;
                                let expr2_0 = constructor_icmpu_mem_zext32(
                                    ctx, pattern4_0, expr0_0, &expr1_0,
                                )?;
                                return Some(expr2_0);
                            }
                        }
                        _ => {}
                    }
                }
            }
            let pattern6_0 = C::value_type(ctx, pattern5_0);
            if pattern6_0 == I16 {
                if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern5_0) {
                    let pattern9_0 = C::inst_data(ctx, pattern8_0);
                    if let &InstructionData::Load {
                        opcode: ref pattern10_0,
                        arg: pattern10_1,
                        flags: pattern10_2,
                        offset: pattern10_3,
                    } = &pattern9_0
                    {
                        if let &Opcode::Load = &pattern10_0 {
                            if let Some(pattern12_0) = C::def_inst(ctx, pattern10_1) {
                                if let Some((pattern13_0, pattern13_1, pattern13_2)) =
                                    C::symbol_value_data(ctx, pattern12_0)
                                {
                                    if let Some(()) = C::reloc_distance_near(ctx, &pattern13_1) {
                                        let pattern15_0 = C::i64_from_offset(ctx, pattern10_3);
                                        let closure16 = || {
                                            return Some(pattern13_2);
                                        };
                                        if let Some(pattern16_0) = closure16() {
                                            if let Some(pattern17_0) = C::memarg_symbol_offset_sum(
                                                ctx,
                                                pattern15_0,
                                                pattern16_0,
                                            ) {
                                                let pattern18_0 = C::inst_data(ctx, pattern8_0);
                                                if let &InstructionData::Load {
                                                    opcode: ref pattern19_0,
                                                    arg: pattern19_1,
                                                    flags: pattern19_2,
                                                    offset: pattern19_3,
                                                } = &pattern18_0
                                                {
                                                    if let &Opcode::Load = &pattern19_0 {
                                                        if let Some(()) =
                                                            C::bigendian(ctx, pattern19_2)
                                                        {
                                                            // Rule at src/isa/s390x/lower.isle line 1709.
                                                            let expr0_0 = constructor_ty_ext32(
                                                                ctx, pattern4_0,
                                                            )?;
                                                            let expr1_0 =
                                                                constructor_put_in_reg_zext32(
                                                                    ctx, pattern2_0,
                                                                )?;
                                                            let expr2_0 = constructor_sink_load(
                                                                ctx, pattern8_0,
                                                            )?;
                                                            let expr3_0 =
                                                                constructor_icmpu_mem_zext16(
                                                                    ctx, expr0_0, expr1_0, &expr2_0,
                                                                )?;
                                                            return Some(expr3_0);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if let Some(pattern7_0) = C::ty_32_or_64(ctx, pattern6_0) {
                if let Some(pattern8_0) = C::sinkable_inst(ctx, pattern5_0) {
                    let pattern9_0 = C::inst_data(ctx, pattern8_0);
                    if let &InstructionData::Load {
                        opcode: ref pattern10_0,
                        arg: pattern10_1,
                        flags: pattern10_2,
                        offset: pattern10_3,
                    } = &pattern9_0
                    {
                        if let &Opcode::Load = &pattern10_0 {
                            if let Some(()) = C::bigendian(ctx, pattern10_2) {
                                // Rule at src/isa/s390x/lower.isle line 1703.
                                let expr0_0 = C::put_in_reg(ctx, pattern2_0);
                                let expr1_0 = constructor_sink_load(ctx, pattern8_0)?;
                                let expr2_0 =
                                    constructor_icmpu_mem(ctx, pattern4_0, expr0_0, &expr1_0)?;
                                return Some(expr2_0);
                            }
                        }
                    }
                }
            }
        }
    }
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    if let Some(pattern3_0) = C::fits_in_64(ctx, pattern2_0) {
        let pattern4_0 = arg2;
        if let Some(pattern5_0) = C::u32_from_value(ctx, pattern4_0) {
            // Rule at src/isa/s390x/lower.isle line 1699.
            let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
            let expr1_0 = constructor_put_in_reg_zext32(ctx, pattern1_0)?;
            let expr2_0 = constructor_icmpu_uimm32(ctx, expr0_0, expr1_0, pattern5_0)?;
            return Some(expr2_0);
        }
        if let Some(pattern5_0) = C::def_inst(ctx, pattern4_0) {
            let pattern6_0 = C::inst_data(ctx, pattern5_0);
            if let &InstructionData::Unary {
                opcode: ref pattern7_0,
                arg: pattern7_1,
            } = &pattern6_0
            {
                if let &Opcode::Uextend = &pattern7_0 {
                    let pattern9_0 = C::value_type(ctx, pattern7_1);
                    if pattern9_0 == I32 {
                        // Rule at src/isa/s390x/lower.isle line 1695.
                        let expr0_0 = C::put_in_reg(ctx, pattern1_0);
                        let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                        let expr2_0 =
                            constructor_icmpu_reg_zext32(ctx, pattern3_0, expr0_0, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
            }
        }
        // Rule at src/isa/s390x/lower.isle line 1691.
        let expr0_0 = constructor_ty_ext32(ctx, pattern3_0)?;
        let expr1_0 = constructor_put_in_reg_zext32(ctx, pattern1_0)?;
        let expr2_0 = constructor_put_in_reg_zext32(ctx, pattern4_0)?;
        let expr3_0 = constructor_icmpu_reg(ctx, expr0_0, expr1_0, expr2_0)?;
        return Some(expr3_0);
    }
    return None;
}

// Generated as internal constructor for term fcmp_val.
pub fn constructor_fcmp_val<C: Context>(
    ctx: &mut C,
    arg0: &FloatCC,
    arg1: Value,
    arg2: Value,
) -> Option<ProducesBool> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = C::value_type(ctx, pattern1_0);
    let pattern3_0 = arg2;
    // Rule at src/isa/s390x/lower.isle line 1732.
    let expr0_0 = C::put_in_reg(ctx, pattern1_0);
    let expr1_0 = C::put_in_reg(ctx, pattern3_0);
    let expr2_0 = constructor_fcmp_reg(ctx, pattern2_0, expr0_0, expr1_0)?;
    let expr3_0 = C::floatcc_as_cond(ctx, pattern0_0);
    let expr4_0 = constructor_bool(ctx, &expr2_0, &expr3_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term value_nonzero.
pub fn constructor_value_nonzero<C: Context>(ctx: &mut C, arg0: Value) -> Option<ProducesBool> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::def_inst(ctx, pattern0_0) {
        let pattern2_0 = C::inst_data(ctx, pattern1_0);
        match &pattern2_0 {
            &InstructionData::FloatCompare {
                opcode: ref pattern3_0,
                args: ref pattern3_1,
                cond: ref pattern3_2,
            } => {
                if let &Opcode::Fcmp = &pattern3_0 {
                    let (pattern5_0, pattern5_1) = C::unpack_value_array_2(ctx, &pattern3_1);
                    // Rule at src/isa/s390x/lower.isle line 1760.
                    let expr0_0 = constructor_fcmp_val(ctx, &pattern3_2, pattern5_0, pattern5_1)?;
                    return Some(expr0_0);
                }
            }
            &InstructionData::IntCompare {
                opcode: ref pattern3_0,
                args: ref pattern3_1,
                cond: ref pattern3_2,
            } => {
                if let &Opcode::Icmp = &pattern3_0 {
                    let (pattern5_0, pattern5_1) = C::unpack_value_array_2(ctx, &pattern3_1);
                    // Rule at src/isa/s390x/lower.isle line 1759.
                    let expr0_0: bool = false;
                    let expr1_0 =
                        constructor_icmp_val(ctx, expr0_0, &pattern3_2, pattern5_0, pattern5_1)?;
                    return Some(expr1_0);
                }
            }
            &InstructionData::Unary {
                opcode: ref pattern3_0,
                arg: pattern3_1,
            } => {
                if let &Opcode::Bint = &pattern3_0 {
                    // Rule at src/isa/s390x/lower.isle line 1758.
                    let expr0_0 = constructor_value_nonzero(ctx, pattern3_1)?;
                    return Some(expr0_0);
                }
            }
            _ => {}
        }
    }
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if let Some(pattern2_0) = C::gpr32_ty(ctx, pattern1_0) {
        // Rule at src/isa/s390x/lower.isle line 1761.
        let expr0_0: Type = I32;
        let expr1_0 = constructor_put_in_reg_sext32(ctx, pattern0_0)?;
        let expr2_0: i16 = 0;
        let expr3_0 = constructor_icmps_simm16(ctx, expr0_0, expr1_0, expr2_0)?;
        let expr4_0 = IntCC::NotEqual;
        let expr5_0 = C::intcc_as_cond(ctx, &expr4_0);
        let expr6_0 = constructor_bool(ctx, &expr3_0, &expr5_0)?;
        return Some(expr6_0);
    }
    if let Some(pattern2_0) = C::gpr64_ty(ctx, pattern1_0) {
        // Rule at src/isa/s390x/lower.isle line 1764.
        let expr0_0: Type = I64;
        let expr1_0 = C::put_in_reg(ctx, pattern0_0);
        let expr2_0: i16 = 0;
        let expr3_0 = constructor_icmps_simm16(ctx, expr0_0, expr1_0, expr2_0)?;
        let expr4_0 = IntCC::NotEqual;
        let expr5_0 = C::intcc_as_cond(ctx, &expr4_0);
        let expr6_0 = constructor_bool(ctx, &expr3_0, &expr5_0)?;
        return Some(expr6_0);
    }
    return None;
}
