// GENERATED BY ISLE. DO NOT EDIT!
//
// Generated automatically from the instruction-selection DSL code in:
// - src/clif.isle
// - src/prelude.isle
// - src/isa/x64/inst.isle
// - src/isa/x64/lower.isle

#![allow(dead_code, unreachable_code, unreachable_patterns)]
#![allow(unused_imports, unused_variables, non_snake_case)]
#![allow(irrefutable_let_patterns)]

use super::*; // Pulls in all external types.

/// Context during lowering: an implementation of this trait
/// must be provided with all external constructors and extractors.
/// A mutable borrow is passed along through all lowering logic.
pub trait Context {
    fn unpack_value_array_2(&mut self, arg0: &ValueArray2) -> (Value, Value);
    fn pack_value_array_2(&mut self, arg0: Value, arg1: Value) -> ValueArray2;
    fn unpack_value_array_3(&mut self, arg0: &ValueArray3) -> (Value, Value, Value);
    fn pack_value_array_3(&mut self, arg0: Value, arg1: Value, arg2: Value) -> ValueArray3;
    fn value_reg(&mut self, arg0: Reg) -> ValueRegs;
    fn value_regs(&mut self, arg0: Reg, arg1: Reg) -> ValueRegs;
    fn temp_writable_reg(&mut self, arg0: Type) -> WritableReg;
    fn invalid_reg(&mut self) -> Reg;
    fn put_in_reg(&mut self, arg0: Value) -> Reg;
    fn put_in_regs(&mut self, arg0: Value) -> ValueRegs;
    fn value_regs_get(&mut self, arg0: ValueRegs, arg1: usize) -> Reg;
    fn u8_as_u64(&mut self, arg0: u8) -> u64;
    fn u16_as_u64(&mut self, arg0: u16) -> u64;
    fn u32_as_u64(&mut self, arg0: u32) -> u64;
    fn ty_bits(&mut self, arg0: Type) -> u8;
    fn ty_bits_u16(&mut self, arg0: Type) -> u16;
    fn fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_32_or_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_8_or_16(&mut self, arg0: Type) -> Option<Type>;
    fn vec128(&mut self, arg0: Type) -> Option<Type>;
    fn not_i64x2(&mut self, arg0: Type) -> Option<()>;
    fn value_list_slice(&mut self, arg0: ValueList) -> ValueSlice;
    fn unwrap_head_value_list_1(&mut self, arg0: ValueList) -> (Value, ValueSlice);
    fn unwrap_head_value_list_2(&mut self, arg0: ValueList) -> (Value, Value, ValueSlice);
    fn writable_reg_to_reg(&mut self, arg0: WritableReg) -> Reg;
    fn u8_from_uimm8(&mut self, arg0: Uimm8) -> u8;
    fn u64_from_imm64(&mut self, arg0: Imm64) -> u64;
    fn u64_from_ieee32(&mut self, arg0: Ieee32) -> u64;
    fn u64_from_ieee64(&mut self, arg0: Ieee64) -> u64;
    fn inst_results(&mut self, arg0: Inst) -> ValueSlice;
    fn first_result(&mut self, arg0: Inst) -> Option<Value>;
    fn inst_data(&mut self, arg0: Inst) -> InstructionData;
    fn value_type(&mut self, arg0: Value) -> Type;
    fn ty_bits_mask(&mut self, arg0: Type) -> u64;
    fn multi_lane(&mut self, arg0: Type) -> Option<(u8, u16)>;
    fn def_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn operand_size_of_type_32_64(&mut self, arg0: Type) -> OperandSize;
    fn raw_operand_size_of_type(&mut self, arg0: Type) -> OperandSize;
    fn put_in_reg_mem(&mut self, arg0: Value) -> RegMem;
    fn encode_fcmp_imm(&mut self, arg0: &FcmpImm) -> u8;
    fn xmm0(&mut self) -> WritableReg;
    fn avx512vl_enabled(&mut self, arg0: Type) -> Option<()>;
    fn avx512dq_enabled(&mut self, arg0: Type) -> Option<()>;
    fn avx512f_enabled(&mut self, arg0: Type) -> Option<()>;
    fn imm8_from_value(&mut self, arg0: Value) -> Option<Imm8Reg>;
    fn mask_imm8_const(&mut self, arg0: &Imm8Reg, arg1: u64) -> Imm8Reg;
    fn simm32_from_value(&mut self, arg0: Value) -> Option<RegMemImm>;
    fn simm32_from_imm64(&mut self, arg0: Imm64) -> Option<RegMemImm>;
    fn sinkable_load(&mut self, arg0: Value) -> Option<SinkableLoad>;
    fn sink_load(&mut self, arg0: &SinkableLoad) -> RegMemImm;
    fn ext_mode(&mut self, arg0: u16, arg1: u16) -> ExtMode;
    fn emit(&mut self, arg0: &MInst) -> Unit;
    fn nonzero_u64_fits_in_u32(&mut self, arg0: u64) -> Option<u64>;
    fn sse_insertps_lane_imm(&mut self, arg0: u8) -> u8;
}

/// Internal type ProducesFlags: defined at src/prelude.isle line 255.
#[derive(Clone, Debug)]
pub enum ProducesFlags {
    ProducesFlags { inst: MInst, result: Reg },
}

/// Internal type ConsumesFlags: defined at src/prelude.isle line 258.
#[derive(Clone, Debug)]
pub enum ConsumesFlags {
    ConsumesFlags { inst: MInst, result: Reg },
}

/// Internal type ExtendKind: defined at src/isa/x64/inst.isle line 416.
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
pub enum ExtendKind {
    Sign,
    Zero,
}

// Generated as internal constructor for term temp_reg.
pub fn constructor_temp_reg<C: Context>(ctx: &mut C, arg0: Type) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 60.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term lo_reg.
pub fn constructor_lo_reg<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 95.
    let expr0_0 = C::put_in_regs(ctx, pattern0_0);
    let expr1_0: usize = 0;
    let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term with_flags.
pub fn constructor_with_flags<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlags {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        if let &ConsumesFlags::ConsumesFlags {
            inst: ref pattern3_0,
            result: pattern3_1,
        } = pattern2_0
        {
            // Rule at src/prelude.isle line 268.
            let expr0_0 = C::emit(ctx, &pattern1_0);
            let expr1_0 = C::emit(ctx, &pattern3_0);
            let expr2_0 = C::value_regs(ctx, pattern1_1, pattern3_1);
            return Some(expr2_0);
        }
    }
    return None;
}

// Generated as internal constructor for term with_flags_1.
pub fn constructor_with_flags_1<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlags {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        if let &ConsumesFlags::ConsumesFlags {
            inst: ref pattern3_0,
            result: pattern3_1,
        } = pattern2_0
        {
            // Rule at src/prelude.isle line 276.
            let expr0_0 = C::emit(ctx, &pattern1_0);
            let expr1_0 = C::emit(ctx, &pattern3_0);
            return Some(pattern3_1);
        }
    }
    return None;
}

// Generated as internal constructor for term with_flags_2.
pub fn constructor_with_flags_2<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
    arg2: &ConsumesFlags,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlags {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        if let &ConsumesFlags::ConsumesFlags {
            inst: ref pattern3_0,
            result: pattern3_1,
        } = pattern2_0
        {
            let pattern4_0 = arg2;
            if let &ConsumesFlags::ConsumesFlags {
                inst: ref pattern5_0,
                result: pattern5_1,
            } = pattern4_0
            {
                // Rule at src/prelude.isle line 286.
                let expr0_0 = C::emit(ctx, &pattern1_0);
                let expr1_0 = C::emit(ctx, &pattern3_0);
                let expr2_0 = C::emit(ctx, &pattern5_0);
                let expr3_0 = C::value_regs(ctx, pattern3_1, pattern5_1);
                return Some(expr3_0);
            }
        }
    }
    return None;
}

// Generated as internal constructor for term operand_size_bits.
pub fn constructor_operand_size_bits<C: Context>(ctx: &mut C, arg0: &OperandSize) -> Option<u16> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &OperandSize::Size8 => {
            // Rule at src/isa/x64/inst.isle line 90.
            let expr0_0: u16 = 8;
            return Some(expr0_0);
        }
        &OperandSize::Size16 => {
            // Rule at src/isa/x64/inst.isle line 91.
            let expr0_0: u16 = 16;
            return Some(expr0_0);
        }
        &OperandSize::Size32 => {
            // Rule at src/isa/x64/inst.isle line 92.
            let expr0_0: u16 = 32;
            return Some(expr0_0);
        }
        &OperandSize::Size64 => {
            // Rule at src/isa/x64/inst.isle line 93.
            let expr0_0: u16 = 64;
            return Some(expr0_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term extend_to_reg.
pub fn constructor_extend_to_reg<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: Type,
    arg2: &ExtendKind,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    let pattern2_0 = arg1;
    if pattern2_0 == pattern1_0 {
        let pattern4_0 = arg2;
        // Rule at src/isa/x64/inst.isle line 428.
        let expr0_0 = C::put_in_reg(ctx, pattern0_0);
        return Some(expr0_0);
    }
    let pattern3_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 431.
    let expr0_0 = C::ty_bits_u16(ctx, pattern1_0);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern2_0);
    let expr2_0 = constructor_operand_size_bits(ctx, &expr1_0)?;
    let expr3_0 = C::ext_mode(ctx, expr0_0, expr2_0);
    let expr4_0 = C::put_in_reg_mem(ctx, pattern0_0);
    let expr5_0 = constructor_extend(ctx, pattern3_0, pattern2_0, &expr3_0, &expr4_0)?;
    return Some(expr5_0);
}

// Generated as internal constructor for term extend.
pub fn constructor_extend<C: Context>(
    ctx: &mut C,
    arg0: &ExtendKind,
    arg1: Type,
    arg2: &ExtMode,
    arg3: &RegMem,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &ExtendKind::Sign => {
            let pattern2_0 = arg1;
            let pattern3_0 = arg2;
            let pattern4_0 = arg3;
            // Rule at src/isa/x64/inst.isle line 451.
            let expr0_0 = constructor_movsx(ctx, pattern2_0, pattern3_0, pattern4_0)?;
            return Some(expr0_0);
        }
        &ExtendKind::Zero => {
            let pattern2_0 = arg1;
            let pattern3_0 = arg2;
            let pattern4_0 = arg3;
            // Rule at src/isa/x64/inst.isle line 447.
            let expr0_0 = constructor_movzx(ctx, pattern2_0, pattern3_0, pattern4_0)?;
            return Some(expr0_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term sse_xor_op.
pub fn constructor_sse_xor_op<C: Context>(ctx: &mut C, arg0: Type) -> Option<SseOpcode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32X4 {
        // Rule at src/isa/x64/inst.isle line 458.
        let expr0_0 = SseOpcode::Xorps;
        return Some(expr0_0);
    }
    if pattern0_0 == F64X2 {
        // Rule at src/isa/x64/inst.isle line 459.
        let expr0_0 = SseOpcode::Xorpd;
        return Some(expr0_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        // Rule at src/isa/x64/inst.isle line 460.
        let expr0_0 = SseOpcode::Pxor;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sse_xor.
pub fn constructor_sse_xor<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMem,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 464.
    let expr0_0 = constructor_sse_xor_op(ctx, pattern0_0)?;
    let expr1_0 = constructor_xmm_rm_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sse_cmp_op.
pub fn constructor_sse_cmp_op<C: Context>(ctx: &mut C, arg0: Type) -> Option<SseOpcode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32X4 {
        // Rule at src/isa/x64/inst.isle line 473.
        let expr0_0 = SseOpcode::Cmpps;
        return Some(expr0_0);
    }
    if pattern0_0 == F64X2 {
        // Rule at src/isa/x64/inst.isle line 474.
        let expr0_0 = SseOpcode::Cmppd;
        return Some(expr0_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        if pattern1_0 == 8 {
            if pattern1_1 == 16 {
                // Rule at src/isa/x64/inst.isle line 469.
                let expr0_0 = SseOpcode::Pcmpeqb;
                return Some(expr0_0);
            }
        }
        if pattern1_0 == 16 {
            if pattern1_1 == 8 {
                // Rule at src/isa/x64/inst.isle line 470.
                let expr0_0 = SseOpcode::Pcmpeqw;
                return Some(expr0_0);
            }
        }
        if pattern1_0 == 32 {
            if pattern1_1 == 4 {
                // Rule at src/isa/x64/inst.isle line 471.
                let expr0_0 = SseOpcode::Pcmpeqd;
                return Some(expr0_0);
            }
        }
        if pattern1_0 == 64 {
            if pattern1_1 == 2 {
                // Rule at src/isa/x64/inst.isle line 472.
                let expr0_0 = SseOpcode::Pcmpeqq;
                return Some(expr0_0);
            }
        }
    }
    return None;
}

// Generated as internal constructor for term vector_all_ones.
pub fn constructor_vector_all_ones<C: Context>(ctx: &mut C, arg0: Type) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 488.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
    let expr2_0: Type = I32X4;
    let expr3_0 = constructor_sse_cmp_op(ctx, expr2_0)?;
    let expr4_0 = RegMem::Reg { reg: expr1_0 };
    let expr5_0 = MInst::XmmRmR {
        op: expr3_0,
        src1: expr1_0,
        src2: expr4_0,
        dst: expr0_0,
    };
    let expr6_0 = C::emit(ctx, &expr5_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term alu_rmi_r.
pub fn constructor_alu_rmi_r<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &AluRmiROpcode,
    arg2: Reg,
    arg3: &RegMemImm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 512.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = MInst::AluRmiR {
        size: expr1_0,
        op: pattern1_0.clone(),
        src1: pattern2_0,
        src2: pattern3_0.clone(),
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term add.
pub fn constructor_add<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 520.
    let expr0_0 = AluRmiROpcode::Add;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_with_flags.
pub fn constructor_add_with_flags<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 528.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = AluRmiROpcode::Add;
    let expr3_0 = MInst::AluRmiR {
        size: expr1_0,
        op: expr2_0,
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr4_0 = C::writable_reg_to_reg(ctx, expr0_0);
    let expr5_0 = ProducesFlags::ProducesFlags {
        inst: expr3_0,
        result: expr4_0,
    };
    return Some(expr5_0);
}

// Generated as internal constructor for term adc.
pub fn constructor_adc<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 539.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = AluRmiROpcode::Adc;
    let expr3_0 = MInst::AluRmiR {
        size: expr1_0,
        op: expr2_0,
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr4_0 = C::writable_reg_to_reg(ctx, expr0_0);
    let expr5_0 = ConsumesFlags::ConsumesFlags {
        inst: expr3_0,
        result: expr4_0,
    };
    return Some(expr5_0);
}

// Generated as internal constructor for term sub.
pub fn constructor_sub<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 550.
    let expr0_0 = AluRmiROpcode::Sub;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_with_flags.
pub fn constructor_sub_with_flags<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 558.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = AluRmiROpcode::Sub;
    let expr3_0 = MInst::AluRmiR {
        size: expr1_0,
        op: expr2_0,
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr4_0 = C::writable_reg_to_reg(ctx, expr0_0);
    let expr5_0 = ProducesFlags::ProducesFlags {
        inst: expr3_0,
        result: expr4_0,
    };
    return Some(expr5_0);
}

// Generated as internal constructor for term sbb.
pub fn constructor_sbb<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 569.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = AluRmiROpcode::Sbb;
    let expr3_0 = MInst::AluRmiR {
        size: expr1_0,
        op: expr2_0,
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr4_0 = C::writable_reg_to_reg(ctx, expr0_0);
    let expr5_0 = ConsumesFlags::ConsumesFlags {
        inst: expr3_0,
        result: expr4_0,
    };
    return Some(expr5_0);
}

// Generated as internal constructor for term mul.
pub fn constructor_mul<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 580.
    let expr0_0 = AluRmiROpcode::Mul;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term m_and.
pub fn constructor_m_and<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 591.
    let expr0_0 = AluRmiROpcode::And;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term or.
pub fn constructor_or<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 599.
    let expr0_0 = AluRmiROpcode::Or;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xor.
pub fn constructor_xor<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 607.
    let expr0_0 = AluRmiROpcode::Xor;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term imm.
pub fn constructor_imm<C: Context>(ctx: &mut C, arg0: Type, arg1: u64) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        if let Some(pattern3_0) = C::nonzero_u64_fits_in_u32(ctx, pattern2_0) {
            // Rule at src/isa/x64/inst.isle line 636.
            let expr0_0: Type = I64;
            let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
            let expr2_0 = OperandSize::Size32;
            let expr3_0 = MInst::Imm {
                dst_size: expr2_0,
                simm64: pattern3_0,
                dst: expr1_0,
            };
            let expr4_0 = C::emit(ctx, &expr3_0);
            let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
            return Some(expr5_0);
        }
    }
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        if pattern2_0 == 0 {
            // Rule at src/isa/x64/inst.isle line 665.
            let expr0_0: Type = F32;
            let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
            let expr2_0 = C::writable_reg_to_reg(ctx, expr1_0);
            let expr3_0 = SseOpcode::Xorps;
            let expr4_0 = RegMem::Reg { reg: expr2_0 };
            let expr5_0 = MInst::XmmRmR {
                op: expr3_0,
                src1: expr2_0,
                src2: expr4_0,
                dst: expr1_0,
            };
            let expr6_0 = C::emit(ctx, &expr5_0);
            return Some(expr2_0);
        }
        // Rule at src/isa/x64/inst.isle line 624.
        let expr0_0: Type = F32;
        let expr1_0 = SseOpcode::Movd;
        let expr2_0: Type = I32;
        let expr3_0 = constructor_imm(ctx, expr2_0, pattern2_0)?;
        let expr4_0 = RegMem::Reg { reg: expr3_0 };
        let expr5_0 = OperandSize::Size32;
        let expr6_0 = constructor_gpr_to_xmm(ctx, expr0_0, &expr1_0, &expr4_0, &expr5_0)?;
        return Some(expr6_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        if pattern2_0 == 0 {
            // Rule at src/isa/x64/inst.isle line 677.
            let expr0_0: Type = F64;
            let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
            let expr2_0 = C::writable_reg_to_reg(ctx, expr1_0);
            let expr3_0 = SseOpcode::Xorpd;
            let expr4_0 = RegMem::Reg { reg: expr2_0 };
            let expr5_0 = MInst::XmmRmR {
                op: expr3_0,
                src1: expr2_0,
                src2: expr4_0,
                dst: expr1_0,
            };
            let expr6_0 = C::emit(ctx, &expr5_0);
            return Some(expr2_0);
        }
        // Rule at src/isa/x64/inst.isle line 628.
        let expr0_0: Type = F64;
        let expr1_0 = SseOpcode::Movq;
        let expr2_0: Type = I64;
        let expr3_0 = constructor_imm(ctx, expr2_0, pattern2_0)?;
        let expr4_0 = RegMem::Reg { reg: expr3_0 };
        let expr5_0 = OperandSize::Size64;
        let expr6_0 = constructor_gpr_to_xmm(ctx, expr0_0, &expr1_0, &expr4_0, &expr5_0)?;
        return Some(expr6_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if pattern2_0 == 0 {
            // Rule at src/isa/x64/inst.isle line 655.
            let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
            let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
            let expr2_0 = constructor_sse_xor_op(ctx, pattern0_0)?;
            let expr3_0 = RegMem::Reg { reg: expr1_0 };
            let expr4_0 = MInst::XmmRmR {
                op: expr2_0,
                src1: expr1_0,
                src2: expr3_0,
                dst: expr0_0,
            };
            let expr5_0 = C::emit(ctx, &expr4_0);
            return Some(expr1_0);
        }
    }
    let pattern1_0 = arg1;
    if pattern1_0 == 0 {
        // Rule at src/isa/x64/inst.isle line 642.
        let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
        let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
        let expr2_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
        let expr3_0 = AluRmiROpcode::Xor;
        let expr4_0 = RegMemImm::Reg { reg: expr1_0 };
        let expr5_0 = MInst::AluRmiR {
            size: expr2_0,
            op: expr3_0,
            src1: expr1_0,
            src2: expr4_0,
            dst: expr0_0,
        };
        let expr6_0 = C::emit(ctx, &expr5_0);
        return Some(expr1_0);
    }
    // Rule at src/isa/x64/inst.isle line 617.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = MInst::Imm {
        dst_size: expr1_0,
        simm64: pattern1_0,
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term shift_r.
pub fn constructor_shift_r<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ShiftKind,
    arg2: Reg,
    arg3: &Imm8Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 690.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::raw_operand_size_of_type(ctx, pattern0_0);
    let expr2_0 = MInst::ShiftR {
        size: expr1_0,
        kind: pattern1_0.clone(),
        src: pattern2_0,
        num_bits: pattern3_0.clone(),
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term m_rotl.
pub fn constructor_m_rotl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &Imm8Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 701.
    let expr0_0 = ShiftKind::RotateLeft;
    let expr1_0 = constructor_shift_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term shl.
pub fn constructor_shl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &Imm8Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 706.
    let expr0_0 = ShiftKind::ShiftLeft;
    let expr1_0 = constructor_shift_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term shr.
pub fn constructor_shr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &Imm8Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 711.
    let expr0_0 = ShiftKind::ShiftRightLogical;
    let expr1_0 = constructor_shift_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sar.
pub fn constructor_sar<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &Imm8Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 716.
    let expr0_0 = ShiftKind::ShiftRightArithmetic;
    let expr1_0 = constructor_shift_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmp_rmi_r.
pub fn constructor_cmp_rmi_r<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &CmpOpcode,
    arg2: &RegMemImm,
    arg3: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 721.
    let expr0_0 = MInst::CmpRmiR {
        size: pattern0_0.clone(),
        opcode: pattern1_0.clone(),
        src: pattern2_0.clone(),
        dst: pattern3_0,
    };
    let expr1_0 = C::invalid_reg(ctx);
    let expr2_0 = ProducesFlags::ProducesFlags {
        inst: expr0_0,
        result: expr1_0,
    };
    return Some(expr2_0);
}

// Generated as internal constructor for term cmp.
pub fn constructor_cmp<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &RegMemImm,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 730.
    let expr0_0 = CmpOpcode::Cmp;
    let expr1_0 = constructor_cmp_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term test.
pub fn constructor_test<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &RegMemImm,
    arg2: Reg,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 735.
    let expr0_0 = CmpOpcode::Test;
    let expr1_0 = constructor_cmp_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmove.
pub fn constructor_cmove<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &RegMem,
    arg3: Reg,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 740.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = MInst::Cmove {
        size: expr1_0,
        cc: pattern1_0.clone(),
        consequent: pattern2_0.clone(),
        alternative: pattern3_0,
        dst: expr0_0,
    };
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    let expr4_0 = ConsumesFlags::ConsumesFlags {
        inst: expr2_0,
        result: expr3_0,
    };
    return Some(expr4_0);
}

// Generated as internal constructor for term movzx.
pub fn constructor_movzx<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ExtMode,
    arg2: &RegMem,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 748.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::MovzxRmR {
        ext_mode: pattern1_0.clone(),
        src: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term movsx.
pub fn constructor_movsx<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ExtMode,
    arg2: &RegMem,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 755.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::MovsxRmR {
        ext_mode: pattern1_0.clone(),
        src: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term xmm_rm_r.
pub fn constructor_xmm_rm_r<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SseOpcode,
    arg2: Reg,
    arg3: &RegMem,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 762.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::XmmRmR {
        op: pattern1_0.clone(),
        src1: pattern2_0,
        src2: pattern3_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term paddb.
pub fn constructor_paddb<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 769.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Paddb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddw.
pub fn constructor_paddw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 774.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Paddw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddd.
pub fn constructor_paddd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 779.
    let expr0_0: Type = I32X4;
    let expr1_0 = SseOpcode::Paddd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddq.
pub fn constructor_paddq<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 784.
    let expr0_0: Type = I64X2;
    let expr1_0 = SseOpcode::Paddq;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddsb.
pub fn constructor_paddsb<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 789.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Paddsb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddsw.
pub fn constructor_paddsw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 794.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Paddsw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddusb.
pub fn constructor_paddusb<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 799.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Paddusb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddusw.
pub fn constructor_paddusw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 804.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Paddusw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubb.
pub fn constructor_psubb<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 809.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Psubb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubw.
pub fn constructor_psubw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 814.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Psubw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubd.
pub fn constructor_psubd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 819.
    let expr0_0: Type = I32X4;
    let expr1_0 = SseOpcode::Psubd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubq.
pub fn constructor_psubq<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 824.
    let expr0_0: Type = I64X2;
    let expr1_0 = SseOpcode::Psubq;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubsb.
pub fn constructor_psubsb<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 829.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Psubsb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubsw.
pub fn constructor_psubsw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 834.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Psubsw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubusb.
pub fn constructor_psubusb<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 839.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Psubusb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubusw.
pub fn constructor_psubusw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 844.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Psubusw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pavgb.
pub fn constructor_pavgb<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 849.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pavgb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pavgw.
pub fn constructor_pavgw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 854.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pavgw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pand.
pub fn constructor_pand<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 859.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Pand;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term andps.
pub fn constructor_andps<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 864.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Andps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term andpd.
pub fn constructor_andpd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 869.
    let expr0_0: Type = F64X2;
    let expr1_0 = SseOpcode::Andpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term por.
pub fn constructor_por<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 874.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Por;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term orps.
pub fn constructor_orps<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 879.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Orps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term orpd.
pub fn constructor_orpd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 884.
    let expr0_0: Type = F64X2;
    let expr1_0 = SseOpcode::Orpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pxor.
pub fn constructor_pxor<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 889.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pxor;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term xorps.
pub fn constructor_xorps<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 894.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Xorps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term xorpd.
pub fn constructor_xorpd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 899.
    let expr0_0: Type = F64X2;
    let expr1_0 = SseOpcode::Xorpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmullw.
pub fn constructor_pmullw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 904.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pmullw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmulld.
pub fn constructor_pmulld<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 909.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pmulld;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmulhw.
pub fn constructor_pmulhw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 914.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pmulhw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmulhuw.
pub fn constructor_pmulhuw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 919.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pmulhuw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmuldq.
pub fn constructor_pmuldq<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 924.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pmuldq;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmuludq.
pub fn constructor_pmuludq<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 929.
    let expr0_0: Type = I64X2;
    let expr1_0 = SseOpcode::Pmuludq;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term punpckhwd.
pub fn constructor_punpckhwd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 934.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Punpckhwd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term punpcklwd.
pub fn constructor_punpcklwd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 939.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Punpcklwd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term andnps.
pub fn constructor_andnps<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 944.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Andnps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term andnpd.
pub fn constructor_andnpd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 949.
    let expr0_0: Type = F64X2;
    let expr1_0 = SseOpcode::Andnpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pandn.
pub fn constructor_pandn<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 954.
    let expr0_0: Type = F64X2;
    let expr1_0 = SseOpcode::Pandn;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term blendvpd.
pub fn constructor_blendvpd<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &RegMem,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 959.
    let expr0_0 = C::xmm0(ctx);
    let expr1_0 = SseOpcode::Movapd;
    let expr2_0 = RegMem::Reg { reg: pattern2_0 };
    let expr3_0 = MInst::XmmUnaryRmR {
        op: expr1_0,
        src: expr2_0,
        dst: expr0_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0: Type = F64X2;
    let expr6_0 = SseOpcode::Blendvpd;
    let expr7_0 = constructor_xmm_rm_r(ctx, expr5_0, &expr6_0, pattern0_0, pattern1_0)?;
    return Some(expr7_0);
}

// Generated as internal constructor for term movsd.
pub fn constructor_movsd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 971.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Movsd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term movlhps.
pub fn constructor_movlhps<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 976.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Movlhps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxsb.
pub fn constructor_pmaxsb<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 981.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxsb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxsw.
pub fn constructor_pmaxsw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 986.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxsw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxsd.
pub fn constructor_pmaxsd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 991.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxsd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminsb.
pub fn constructor_pminsb<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 996.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminsb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminsw.
pub fn constructor_pminsw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1001.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminsw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminsd.
pub fn constructor_pminsd<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1006.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminsd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxub.
pub fn constructor_pmaxub<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1011.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxub;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxuw.
pub fn constructor_pmaxuw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1016.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxuw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxud.
pub fn constructor_pmaxud<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1021.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxud;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminub.
pub fn constructor_pminub<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1026.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminub;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminuw.
pub fn constructor_pminuw<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1031.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminuw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminud.
pub fn constructor_pminud<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1036.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminud;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term xmm_rm_r_imm.
pub fn constructor_xmm_rm_r_imm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Reg,
    arg2: &RegMem,
    arg3: u8,
    arg4: &OperandSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/x64/inst.isle line 1041.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::XmmRmRImm {
        op: pattern0_0.clone(),
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr1_0,
        imm: pattern3_0,
        size: pattern4_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term palignr.
pub fn constructor_palignr<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &RegMem,
    arg2: u8,
    arg3: &OperandSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1053.
    let expr0_0 = SseOpcode::Palignr;
    let expr1_0 = constructor_xmm_rm_r_imm(
        ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0, pattern3_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pshufd.
pub fn constructor_pshufd<C: Context>(
    ctx: &mut C,
    arg0: &RegMem,
    arg1: u8,
    arg2: &OperandSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1062.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = C::writable_reg_to_reg(ctx, expr1_0);
    let expr3_0 = SseOpcode::Pshufd;
    let expr4_0 = MInst::XmmRmRImm {
        op: expr3_0,
        src1: expr2_0,
        src2: pattern0_0.clone(),
        dst: expr1_0,
        imm: pattern1_0,
        size: pattern2_0.clone(),
    };
    let expr5_0 = C::emit(ctx, &expr4_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term xmm_unary_rm_r.
pub fn constructor_xmm_unary_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &RegMem,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1075.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::XmmUnaryRmR {
        op: pattern0_0.clone(),
        src: pattern1_0.clone(),
        dst: expr1_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term pmovsxbw.
pub fn constructor_pmovsxbw<C: Context>(ctx: &mut C, arg0: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1082.
    let expr0_0 = SseOpcode::Pmovsxbw;
    let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pmovzxbw.
pub fn constructor_pmovzxbw<C: Context>(ctx: &mut C, arg0: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1087.
    let expr0_0 = SseOpcode::Pmovzxbw;
    let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pabsb.
pub fn constructor_pabsb<C: Context>(ctx: &mut C, arg0: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1092.
    let expr0_0 = SseOpcode::Pabsb;
    let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pabsw.
pub fn constructor_pabsw<C: Context>(ctx: &mut C, arg0: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1097.
    let expr0_0 = SseOpcode::Pabsw;
    let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pabsd.
pub fn constructor_pabsd<C: Context>(ctx: &mut C, arg0: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1102.
    let expr0_0 = SseOpcode::Pabsd;
    let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xmm_unary_rm_r_evex.
pub fn constructor_xmm_unary_rm_r_evex<C: Context>(
    ctx: &mut C,
    arg0: &Avx512Opcode,
    arg1: &RegMem,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1107.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::XmmUnaryRmREvex {
        op: pattern0_0.clone(),
        src: pattern1_0.clone(),
        dst: expr1_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term vpabsq.
pub fn constructor_vpabsq<C: Context>(ctx: &mut C, arg0: &RegMem) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1114.
    let expr0_0 = Avx512Opcode::Vpabsq;
    let expr1_0 = constructor_xmm_unary_rm_r_evex(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xmm_rm_r_evex.
pub fn constructor_xmm_rm_r_evex<C: Context>(
    ctx: &mut C,
    arg0: &Avx512Opcode,
    arg1: &RegMem,
    arg2: Reg,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1119.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::XmmRmREvex {
        op: pattern0_0.clone(),
        src1: pattern1_0.clone(),
        src2: pattern2_0,
        dst: expr1_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term vpmullq.
pub fn constructor_vpmullq<C: Context>(ctx: &mut C, arg0: &RegMem, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1131.
    let expr0_0 = Avx512Opcode::Vpmullq;
    let expr1_0 = constructor_xmm_rm_r_evex(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xmm_rmi_reg.
pub fn constructor_xmm_rmi_reg<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Reg,
    arg2: &RegMemImm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1138.
    let expr0_0: Type = I8X16;
    let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
    let expr2_0 = MInst::XmmRmiReg {
        opcode: pattern0_0.clone(),
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr1_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr1_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term psllq.
pub fn constructor_psllq<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMemImm) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1148.
    let expr0_0 = SseOpcode::Psllq;
    let expr1_0 = constructor_xmm_rmi_reg(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term psrld.
pub fn constructor_psrld<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMemImm) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1153.
    let expr0_0 = SseOpcode::Psrld;
    let expr1_0 = constructor_xmm_rmi_reg(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term psrlq.
pub fn constructor_psrlq<C: Context>(ctx: &mut C, arg0: Reg, arg1: &RegMemImm) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1158.
    let expr0_0 = SseOpcode::Psrlq;
    let expr1_0 = constructor_xmm_rmi_reg(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_hi.
pub fn constructor_mul_hi<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: bool,
    arg2: Reg,
    arg3: &RegMem,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1165.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr2_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr3_0 = MInst::MulHi {
        size: expr2_0,
        signed: pattern1_0,
        src1: pattern2_0,
        src2: pattern3_0.clone(),
        dst_lo: expr0_0,
        dst_hi: expr1_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_reg_to_reg(ctx, expr0_0);
    let expr6_0 = C::writable_reg_to_reg(ctx, expr1_0);
    let expr7_0 = C::value_regs(ctx, expr5_0, expr6_0);
    return Some(expr7_0);
}

// Generated as internal constructor for term mulhi_u.
pub fn constructor_mulhi_u<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMem,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1181.
    let expr0_0: bool = false;
    let expr1_0 = constructor_mul_hi(ctx, pattern0_0, expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmpps.
pub fn constructor_cmpps<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &RegMem,
    arg2: &FcmpImm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1186.
    let expr0_0 = SseOpcode::Cmpps;
    let expr1_0 = C::encode_fcmp_imm(ctx, pattern2_0);
    let expr2_0 = OperandSize::Size32;
    let expr3_0 =
        constructor_xmm_rm_r_imm(ctx, &expr0_0, pattern0_0, pattern1_0, expr1_0, &expr2_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term cmppd.
pub fn constructor_cmppd<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &RegMem,
    arg2: &FcmpImm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1199.
    let expr0_0 = SseOpcode::Cmppd;
    let expr1_0 = C::encode_fcmp_imm(ctx, pattern2_0);
    let expr2_0 = OperandSize::Size32;
    let expr3_0 =
        constructor_xmm_rm_r_imm(ctx, &expr0_0, pattern0_0, pattern1_0, expr1_0, &expr2_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term gpr_to_xmm.
pub fn constructor_gpr_to_xmm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SseOpcode,
    arg2: &RegMem,
    arg3: &OperandSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1208.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = MInst::GprToXmm {
        op: pattern1_0.clone(),
        src: pattern2_0.clone(),
        dst: expr0_0,
        src_size: pattern3_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term pinsrb.
pub fn constructor_pinsrb<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &RegMem,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1215.
    let expr0_0 = SseOpcode::Pinsrb;
    let expr1_0 = OperandSize::Size32;
    let expr2_0 =
        constructor_xmm_rm_r_imm(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0, &expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pinsrw.
pub fn constructor_pinsrw<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &RegMem,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1220.
    let expr0_0 = SseOpcode::Pinsrw;
    let expr1_0 = OperandSize::Size32;
    let expr2_0 =
        constructor_xmm_rm_r_imm(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0, &expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pinsrd.
pub fn constructor_pinsrd<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &RegMem,
    arg2: u8,
    arg3: &OperandSize,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1225.
    let expr0_0 = SseOpcode::Pinsrd;
    let expr1_0 = constructor_xmm_rm_r_imm(
        ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0, pattern3_0,
    )?;
    return Some(expr1_0);
}

// Generated as internal constructor for term insertps.
pub fn constructor_insertps<C: Context>(
    ctx: &mut C,
    arg0: Reg,
    arg1: &RegMem,
    arg2: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1230.
    let expr0_0 = SseOpcode::Insertps;
    let expr1_0 = OperandSize::Size32;
    let expr2_0 =
        constructor_xmm_rm_r_imm(ctx, &expr0_0, pattern0_0, pattern1_0, pattern2_0, &expr1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term not.
pub fn constructor_not<C: Context>(ctx: &mut C, arg0: Type, arg1: Reg) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1235.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = MInst::Not {
        size: expr1_0,
        src: pattern1_0,
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term lower.
pub fn constructor_lower<C: Context>(ctx: &mut C, arg0: Inst) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    match &pattern1_0 {
        &InstructionData::UnaryIeee32 {
            opcode: ref pattern2_0,
            imm: pattern2_1,
        } => {
            if let &Opcode::F32const = &pattern2_0 {
                let pattern4_0 = C::u64_from_ieee32(ctx, pattern2_1);
                // Rule at src/isa/x64/lower.isle line 46.
                let expr0_0: Type = F32;
                let expr1_0 = constructor_imm(ctx, expr0_0, pattern4_0)?;
                let expr2_0 = C::value_reg(ctx, expr1_0);
                return Some(expr2_0);
            }
        }
        &InstructionData::UnaryIeee64 {
            opcode: ref pattern2_0,
            imm: pattern2_1,
        } => {
            if let &Opcode::F64const = &pattern2_0 {
                let pattern4_0 = C::u64_from_ieee64(ctx, pattern2_1);
                // Rule at src/isa/x64/lower.isle line 51.
                let expr0_0: Type = F64;
                let expr1_0 = constructor_imm(ctx, expr0_0, pattern4_0)?;
                let expr2_0 = C::value_reg(ctx, expr1_0);
                return Some(expr2_0);
            }
        }
        &InstructionData::TernaryImm8 {
            opcode: ref pattern2_0,
            args: ref pattern2_1,
            imm: pattern2_2,
        } => {
            if let &Opcode::Insertlane = &pattern2_0 {
                let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, &pattern2_1);
                let pattern5_0 = C::value_type(ctx, pattern4_0);
                let pattern6_0 = C::u8_from_uimm8(ctx, pattern2_2);
                // Rule at src/isa/x64/lower.isle line 1049.
                let expr0_0 = C::put_in_reg(ctx, pattern4_0);
                let expr1_0 = C::put_in_reg_mem(ctx, pattern4_1);
                let expr2_0 =
                    constructor_vec_insert_lane(ctx, pattern5_0, expr0_0, &expr1_0, pattern6_0)?;
                let expr3_0 = C::value_reg(ctx, expr2_0);
                return Some(expr3_0);
            }
        }
        _ => {}
    }
    if let Some(pattern1_0) = C::first_result(ctx, pattern0_0) {
        let pattern2_0 = C::value_type(ctx, pattern1_0);
        if pattern2_0 == B128 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::UnaryBool {
                    opcode: ref pattern5_0,
                    imm: pattern5_1,
                } => {
                    if let &Opcode::Bconst = &pattern5_0 {
                        if pattern5_1 == true {
                            // Rule at src/isa/x64/lower.isle line 39.
                            let expr0_0: Type = B64;
                            let expr1_0: u64 = 1;
                            let expr2_0 = constructor_imm(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = B64;
                            let expr4_0: u64 = 0;
                            let expr5_0 = constructor_imm(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = C::value_regs(ctx, expr2_0, expr5_0);
                            return Some(expr6_0);
                        }
                        if pattern5_1 == false {
                            // Rule at src/isa/x64/lower.isle line 34.
                            let expr0_0: Type = B64;
                            let expr1_0: u64 = 0;
                            let expr2_0 = constructor_imm(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = B64;
                            let expr4_0: u64 = 0;
                            let expr5_0 = constructor_imm(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = C::value_regs(ctx, expr2_0, expr5_0);
                            return Some(expr6_0);
                        }
                    }
                }
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 388.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = constructor_lo_reg(ctx, pattern7_1)?;
                            let expr6_0: Type = I64;
                            let expr7_0 = RegMemImm::Reg { reg: expr5_0 };
                            let expr8_0 = constructor_m_and(ctx, expr6_0, expr2_0, &expr7_0)?;
                            let expr9_0 = C::value_regs(ctx, expr8_0, expr4_0);
                            return Some(expr9_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 466.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = constructor_lo_reg(ctx, pattern7_1)?;
                            let expr6_0: Type = I64;
                            let expr7_0 = RegMemImm::Reg { reg: expr5_0 };
                            let expr8_0 = constructor_or(ctx, expr6_0, expr2_0, &expr7_0)?;
                            let expr9_0 = C::value_regs(ctx, expr8_0, expr4_0);
                            return Some(expr9_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 532.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = constructor_lo_reg(ctx, pattern7_1)?;
                            let expr6_0: Type = I64;
                            let expr7_0 = RegMemImm::Reg { reg: expr5_0 };
                            let expr8_0 = constructor_xor(ctx, expr6_0, expr2_0, &expr7_0)?;
                            let expr9_0 = C::value_regs(ctx, expr8_0, expr4_0);
                            return Some(expr9_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bnot = &pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 1039.
                        let expr0_0 = constructor_i128_not(ctx, pattern5_1)?;
                        return Some(expr0_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I128 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::UnaryImm {
                    opcode: ref pattern5_0,
                    imm: pattern5_1,
                } => {
                    if let &Opcode::Iconst = &pattern5_0 {
                        let pattern7_0 = C::u64_from_imm64(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 15.
                        let expr0_0: Type = I64;
                        let expr1_0 = constructor_imm(ctx, expr0_0, pattern7_0)?;
                        let expr2_0: Type = I64;
                        let expr3_0: u64 = 0;
                        let expr4_0 = constructor_imm(ctx, expr2_0, expr3_0)?;
                        let expr5_0 = C::value_regs(ctx, expr1_0, expr4_0);
                        return Some(expr5_0);
                    }
                }
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Iadd => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 117.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = C::value_regs_get(ctx, expr5_0, expr6_0);
                            let expr8_0: usize = 1;
                            let expr9_0 = C::value_regs_get(ctx, expr5_0, expr8_0);
                            let expr10_0: Type = I64;
                            let expr11_0 = RegMemImm::Reg { reg: expr7_0 };
                            let expr12_0 =
                                constructor_add_with_flags(ctx, expr10_0, expr2_0, &expr11_0)?;
                            let expr13_0: Type = I64;
                            let expr14_0 = RegMemImm::Reg { reg: expr9_0 };
                            let expr15_0 = constructor_adc(ctx, expr13_0, expr4_0, &expr14_0)?;
                            let expr16_0 = constructor_with_flags(ctx, &expr12_0, &expr15_0)?;
                            return Some(expr16_0);
                        }
                        &Opcode::Isub => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 286.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = C::value_regs_get(ctx, expr5_0, expr6_0);
                            let expr8_0: usize = 1;
                            let expr9_0 = C::value_regs_get(ctx, expr5_0, expr8_0);
                            let expr10_0: Type = I64;
                            let expr11_0 = RegMemImm::Reg { reg: expr7_0 };
                            let expr12_0 =
                                constructor_sub_with_flags(ctx, expr10_0, expr2_0, &expr11_0)?;
                            let expr13_0: Type = I64;
                            let expr14_0 = RegMemImm::Reg { reg: expr9_0 };
                            let expr15_0 = constructor_sbb(ctx, expr13_0, expr4_0, &expr14_0)?;
                            let expr16_0 = constructor_with_flags(ctx, &expr12_0, &expr15_0)?;
                            return Some(expr16_0);
                        }
                        &Opcode::Imul => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 727.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = C::value_regs_get(ctx, expr5_0, expr6_0);
                            let expr8_0: usize = 1;
                            let expr9_0 = C::value_regs_get(ctx, expr5_0, expr8_0);
                            let expr10_0: Type = I64;
                            let expr11_0 = RegMemImm::Reg { reg: expr9_0 };
                            let expr12_0 = constructor_mul(ctx, expr10_0, expr2_0, &expr11_0)?;
                            let expr13_0: Type = I64;
                            let expr14_0 = RegMemImm::Reg { reg: expr7_0 };
                            let expr15_0 = constructor_mul(ctx, expr13_0, expr4_0, &expr14_0)?;
                            let expr16_0: Type = I64;
                            let expr17_0 = RegMemImm::Reg { reg: expr15_0 };
                            let expr18_0 = constructor_add(ctx, expr16_0, expr12_0, &expr17_0)?;
                            let expr19_0: Type = I64;
                            let expr20_0 = RegMem::Reg { reg: expr7_0 };
                            let expr21_0 = constructor_mulhi_u(ctx, expr19_0, expr2_0, &expr20_0)?;
                            let expr22_0: usize = 0;
                            let expr23_0 = C::value_regs_get(ctx, expr21_0, expr22_0);
                            let expr24_0: usize = 1;
                            let expr25_0 = C::value_regs_get(ctx, expr21_0, expr24_0);
                            let expr26_0: Type = I64;
                            let expr27_0 = RegMemImm::Reg { reg: expr25_0 };
                            let expr28_0 = constructor_add(ctx, expr26_0, expr18_0, &expr27_0)?;
                            let expr29_0 = C::value_regs(ctx, expr23_0, expr28_0);
                            return Some(expr29_0);
                        }
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 378.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = C::value_regs_get(ctx, expr5_0, expr6_0);
                            let expr8_0: usize = 1;
                            let expr9_0 = C::value_regs_get(ctx, expr5_0, expr8_0);
                            let expr10_0: Type = I64;
                            let expr11_0 = RegMemImm::Reg { reg: expr7_0 };
                            let expr12_0 = constructor_m_and(ctx, expr10_0, expr2_0, &expr11_0)?;
                            let expr13_0: Type = I64;
                            let expr14_0 = RegMemImm::Reg { reg: expr9_0 };
                            let expr15_0 = constructor_m_and(ctx, expr13_0, expr4_0, &expr14_0)?;
                            let expr16_0 = C::value_regs(ctx, expr12_0, expr15_0);
                            return Some(expr16_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 463.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr2_0 = constructor_or_i128(ctx, expr0_0, expr1_0)?;
                            return Some(expr2_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 522.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                            let expr3_0: usize = 1;
                            let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = C::value_regs_get(ctx, expr5_0, expr6_0);
                            let expr8_0: usize = 1;
                            let expr9_0 = C::value_regs_get(ctx, expr5_0, expr8_0);
                            let expr10_0: Type = I64;
                            let expr11_0 = RegMemImm::Reg { reg: expr7_0 };
                            let expr12_0 = constructor_xor(ctx, expr10_0, expr2_0, &expr11_0)?;
                            let expr13_0: Type = I64;
                            let expr14_0 = RegMemImm::Reg { reg: expr9_0 };
                            let expr15_0 = constructor_xor(ctx, expr13_0, expr4_0, &expr14_0)?;
                            let expr16_0 = C::value_regs(ctx, expr12_0, expr15_0);
                            return Some(expr16_0);
                        }
                        &Opcode::Rotl => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 660.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0 = constructor_lo_reg(ctx, pattern7_1)?;
                            let expr2_0 = constructor_shl_i128(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = I64;
                            let expr4_0: Type = I64;
                            let expr5_0: u64 = 128;
                            let expr6_0 = constructor_imm(ctx, expr4_0, expr5_0)?;
                            let expr7_0 = RegMemImm::Reg { reg: expr1_0 };
                            let expr8_0 = constructor_sub(ctx, expr3_0, expr6_0, &expr7_0)?;
                            let expr9_0 = constructor_shr_i128(ctx, expr0_0, expr8_0)?;
                            let expr10_0 = constructor_or_i128(ctx, expr2_0, expr9_0)?;
                            return Some(expr10_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 582.
                            let expr0_0 = constructor_lo_reg(ctx, pattern7_1)?;
                            let expr1_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr2_0 = constructor_shl_i128(ctx, expr1_0, expr0_0)?;
                            return Some(expr2_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 628.
                            let expr0_0 = constructor_lo_reg(ctx, pattern7_1)?;
                            let expr1_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr2_0 = constructor_shr_i128(ctx, expr1_0, expr0_0)?;
                            return Some(expr2_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bnot = &pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 1036.
                        let expr0_0 = constructor_i128_not(ctx, pattern5_1)?;
                        return Some(expr0_0);
                    }
                }
                &InstructionData::BinaryImm64 {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    imm: pattern5_2,
                } => {
                    if let &Opcode::IaddImm = &pattern5_0 {
                        let pattern7_0 = C::u64_from_imm64(ctx, pattern5_2);
                        // Rule at src/isa/x64/lower.isle line 232.
                        let expr0_0 = C::put_in_regs(ctx, pattern5_1);
                        let expr1_0: usize = 0;
                        let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
                        let expr3_0: usize = 1;
                        let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
                        let expr5_0: Type = I64;
                        let expr6_0 = constructor_imm(ctx, expr5_0, pattern7_0)?;
                        let expr7_0: Type = I64;
                        let expr8_0 = RegMemImm::Reg { reg: expr6_0 };
                        let expr9_0 = constructor_add_with_flags(ctx, expr7_0, expr2_0, &expr8_0)?;
                        let expr10_0: Type = I64;
                        let expr11_0: u32 = 0;
                        let expr12_0 = RegMemImm::Imm { simm32: expr11_0 };
                        let expr13_0 = constructor_adc(ctx, expr10_0, expr4_0, &expr12_0)?;
                        let expr14_0 = constructor_with_flags(ctx, &expr9_0, &expr13_0)?;
                        return Some(expr14_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I8X16 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Imin => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1117.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pminsb(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Umin => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1139.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pminub(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Imax => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1106.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pmaxsb(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Umax => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1128.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pmaxub(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Iabs = &pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 982.
                        let expr0_0 = C::put_in_reg_mem(ctx, pattern5_1);
                        let expr1_0 = constructor_pabsb(ctx, &expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I16X8 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Imin => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1120.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pminsw(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Umin => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1142.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pminuw(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Imax => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1109.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pmaxsw(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Umax => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1131.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pmaxuw(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Iabs = &pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 985.
                        let expr0_0 = C::put_in_reg_mem(ctx, pattern5_1);
                        let expr1_0 = constructor_pabsw(ctx, &expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I32X4 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Imin => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1123.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pminsd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Umin => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1145.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pminud(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Imax => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1112.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pmaxsd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Umax => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1134.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pmaxud(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Iabs = &pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 988.
                        let expr0_0 = C::put_in_reg_mem(ctx, pattern5_1);
                        let expr1_0 = constructor_pabsd(ctx, &expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I64X2 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Iabs = &pattern5_0 {
                    // Rule at src/isa/x64/lower.isle line 1002.
                    let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                    let expr1_0: Type = I64X2;
                    let expr2_0: u64 = 0;
                    let expr3_0 = constructor_imm(ctx, expr1_0, expr2_0)?;
                    let expr4_0 = RegMem::Reg { reg: expr0_0 };
                    let expr5_0 = constructor_psubq(ctx, expr3_0, &expr4_0)?;
                    let expr6_0 = RegMem::Reg { reg: expr0_0 };
                    let expr7_0 = constructor_blendvpd(ctx, expr5_0, &expr6_0, expr5_0)?;
                    let expr8_0 = C::value_reg(ctx, expr7_0);
                    return Some(expr8_0);
                }
            }
        }
        if pattern2_0 == F32X4 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 363.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_andps(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 439.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_orps(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::BandNot => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 971.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_0);
                            let expr2_0 = constructor_andnps(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Fabs = &pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 1010.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0: Type = F32X4;
                        let expr2_0 = constructor_vector_all_ones(ctx, expr1_0)?;
                        let expr3_0: u32 = 1;
                        let expr4_0 = RegMemImm::Imm { simm32: expr3_0 };
                        let expr5_0 = constructor_psrld(ctx, expr2_0, &expr4_0)?;
                        let expr6_0 = RegMem::Reg { reg: expr5_0 };
                        let expr7_0 = constructor_andps(ctx, expr0_0, &expr6_0)?;
                        let expr8_0 = C::value_reg(ctx, expr7_0);
                        return Some(expr8_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == F64X2 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 367.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_andpd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 443.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_orpd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::BandNot => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 974.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_0);
                            let expr2_0 = constructor_andnpd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Fabs = &pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 1015.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0: Type = F64X2;
                        let expr2_0 = constructor_vector_all_ones(ctx, expr1_0)?;
                        let expr3_0: u32 = 1;
                        let expr4_0 = RegMemImm::Imm { simm32: expr3_0 };
                        let expr5_0 = constructor_psrlq(ctx, expr2_0, &expr4_0)?;
                        let expr6_0 = RegMem::Reg { reg: expr5_0 };
                        let expr7_0 = constructor_andpd(ctx, expr0_0, &expr6_0)?;
                        let expr8_0 = C::value_reg(ctx, expr7_0);
                        return Some(expr8_0);
                    }
                }
                _ => {}
            }
        }
        let pattern3_0 = C::inst_data(ctx, pattern0_0);
        if let &InstructionData::NullAry {
            opcode: ref pattern4_0,
        } = &pattern3_0
        {
            if let &Opcode::Null = &pattern4_0 {
                // Rule at src/isa/x64/lower.isle line 56.
                let expr0_0: u64 = 0;
                let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                let expr2_0 = C::value_reg(ctx, expr1_0);
                return Some(expr2_0);
            }
        }
        if let Some(()) = C::avx512vl_enabled(ctx, pattern2_0) {
            if let Some(()) = C::avx512dq_enabled(ctx, pattern2_0) {
                if let Some((pattern5_0, pattern5_1)) = C::multi_lane(ctx, pattern2_0) {
                    if pattern5_0 == 64 {
                        if pattern5_1 == 2 {
                            let pattern8_0 = C::inst_data(ctx, pattern0_0);
                            if let &InstructionData::Binary {
                                opcode: ref pattern9_0,
                                args: ref pattern9_1,
                            } = &pattern8_0
                            {
                                if let &Opcode::Imul = &pattern9_0 {
                                    let (pattern11_0, pattern11_1) =
                                        C::unpack_value_array_2(ctx, &pattern9_1);
                                    // Rule at src/isa/x64/lower.isle line 762.
                                    let expr0_0 = C::put_in_reg_mem(ctx, pattern11_0);
                                    let expr1_0 = C::put_in_reg(ctx, pattern11_1);
                                    let expr2_0 = constructor_vpmullq(ctx, &expr0_0, expr1_0)?;
                                    let expr3_0 = C::value_reg(ctx, expr2_0);
                                    return Some(expr3_0);
                                }
                            }
                        }
                    }
                }
            }
            if let Some(()) = C::avx512f_enabled(ctx, pattern2_0) {
                if pattern2_0 == I64X2 {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Unary {
                        opcode: ref pattern7_0,
                        arg: pattern7_1,
                    } = &pattern6_0
                    {
                        if let &Opcode::Iabs = &pattern7_0 {
                            // Rule at src/isa/x64/lower.isle line 992.
                            let expr0_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr1_0 = constructor_vpabsq(ctx, &expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                }
            }
        }
        if let Some((pattern3_0, pattern3_1)) = C::multi_lane(ctx, pattern2_0) {
            if pattern3_0 == 8 {
                if pattern3_1 == 16 {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern7_0,
                        args: ref pattern7_1,
                    } = &pattern6_0
                    {
                        match &pattern7_0 {
                            &Opcode::AvgRound => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 670.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_pavgb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::UaddSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 144.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_paddusb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::SaddSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 132.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_paddsb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::UsubSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 313.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_psubusb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::SsubSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 301.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_psubsb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::Iadd => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 96.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_paddb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::Isub => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 265.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_psubb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            _ => {}
                        }
                    }
                }
            }
            if pattern3_0 == 16 {
                if pattern3_1 == 8 {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern7_0,
                        args: ref pattern7_1,
                    } = &pattern6_0
                    {
                        match &pattern7_0 {
                            &Opcode::AvgRound => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 674.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_pavgw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::UaddSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 149.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_paddusw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::SaddSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 137.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_paddsw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::UsubSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 318.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_psubusw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::SsubSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 306.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_psubsw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::Iadd => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 101.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_paddw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::Isub => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 270.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_psubw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::Imul => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                if let Some(pattern10_0) = C::def_inst(ctx, pattern9_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Unary {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                    } = &pattern11_0
                                    {
                                        match &pattern12_0 {
                                            &Opcode::SwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 8 {
                                                        if pattern15_1 == 16 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenLow =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 8 {
                                                                                if pattern23_1 == 16
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 850.
                                                                                    let expr0_0 = C::put_in_reg_mem(ctx, pattern12_1);
                                                                                    let expr1_0 = constructor_pmovsxbw(ctx, &expr0_0)?;
                                                                                    let expr2_0 = C::put_in_reg_mem(ctx, pattern20_1);
                                                                                    let expr3_0 = constructor_pmovsxbw(ctx, &expr2_0)?;
                                                                                    let expr4_0 = RegMem::Reg {
                                                                                        reg: expr3_0,
                                                                                    };
                                                                                    let expr5_0 = constructor_pmullw(ctx, expr1_0, &expr4_0)?;
                                                                                    let expr6_0 = C::value_reg(ctx, expr5_0);
                                                                                    return Some(
                                                                                        expr6_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::SwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 8 {
                                                        if pattern15_1 == 16 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenHigh =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 8 {
                                                                                if pattern23_1 == 16
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 810.
                                                                                    let expr0_0 = C::put_in_reg(ctx, pattern12_1);
                                                                                    let expr1_0 = RegMem::Reg {
                                                                                        reg: expr0_0,
                                                                                    };
                                                                                    let expr2_0: u8 = 8;
                                                                                    let expr3_0 = OperandSize::Size32;
                                                                                    let expr4_0 = constructor_palignr(ctx, expr0_0, &expr1_0, expr2_0, &expr3_0)?;
                                                                                    let expr5_0 = RegMem::Reg {
                                                                                        reg: expr4_0,
                                                                                    };
                                                                                    let expr6_0 = constructor_pmovsxbw(ctx, &expr5_0)?;
                                                                                    let expr7_0 = C::put_in_reg(ctx, pattern20_1);
                                                                                    let expr8_0 = RegMem::Reg {
                                                                                        reg: expr7_0,
                                                                                    };
                                                                                    let expr9_0: u8 = 8;
                                                                                    let expr10_0 = OperandSize::Size32;
                                                                                    let expr11_0 = constructor_palignr(ctx, expr7_0, &expr8_0, expr9_0, &expr10_0)?;
                                                                                    let expr12_0 = RegMem::Reg {
                                                                                        reg: expr11_0,
                                                                                    };
                                                                                    let expr13_0 = constructor_pmovsxbw(ctx, &expr12_0)?;
                                                                                    let expr14_0 = RegMem::Reg {
                                                                                        reg: expr13_0,
                                                                                    };
                                                                                    let expr15_0 = constructor_pmullw(ctx, expr6_0, &expr14_0)?;
                                                                                    let expr16_0 = C::value_reg(ctx, expr15_0);
                                                                                    return Some(
                                                                                        expr16_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 8 {
                                                        if pattern15_1 == 16 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenLow =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 8 {
                                                                                if pattern23_1 == 16
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 926.
                                                                                    let expr0_0 = C::put_in_reg_mem(ctx, pattern12_1);
                                                                                    let expr1_0 = constructor_pmovzxbw(ctx, &expr0_0)?;
                                                                                    let expr2_0 = C::put_in_reg_mem(ctx, pattern20_1);
                                                                                    let expr3_0 = constructor_pmovzxbw(ctx, &expr2_0)?;
                                                                                    let expr4_0 = RegMem::Reg {
                                                                                        reg: expr3_0,
                                                                                    };
                                                                                    let expr5_0 = constructor_pmullw(ctx, expr1_0, &expr4_0)?;
                                                                                    let expr6_0 = C::value_reg(ctx, expr5_0);
                                                                                    return Some(
                                                                                        expr6_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 8 {
                                                        if pattern15_1 == 16 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenHigh =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 8 {
                                                                                if pattern23_1 == 16
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 886.
                                                                                    let expr0_0 = C::put_in_reg(ctx, pattern12_1);
                                                                                    let expr1_0 = RegMem::Reg {
                                                                                        reg: expr0_0,
                                                                                    };
                                                                                    let expr2_0: u8 = 8;
                                                                                    let expr3_0 = OperandSize::Size32;
                                                                                    let expr4_0 = constructor_palignr(ctx, expr0_0, &expr1_0, expr2_0, &expr3_0)?;
                                                                                    let expr5_0 = RegMem::Reg {
                                                                                        reg: expr4_0,
                                                                                    };
                                                                                    let expr6_0 = constructor_pmovzxbw(ctx, &expr5_0)?;
                                                                                    let expr7_0 = C::put_in_reg(ctx, pattern20_1);
                                                                                    let expr8_0 = RegMem::Reg {
                                                                                        reg: expr7_0,
                                                                                    };
                                                                                    let expr9_0: u8 = 8;
                                                                                    let expr10_0 = OperandSize::Size32;
                                                                                    let expr11_0 = constructor_palignr(ctx, expr7_0, &expr8_0, expr9_0, &expr10_0)?;
                                                                                    let expr12_0 = RegMem::Reg {
                                                                                        reg: expr11_0,
                                                                                    };
                                                                                    let expr13_0 = constructor_pmovzxbw(ctx, &expr12_0)?;
                                                                                    let expr14_0 = RegMem::Reg {
                                                                                        reg: expr13_0,
                                                                                    };
                                                                                    let expr15_0 = constructor_pmullw(ctx, expr6_0, &expr14_0)?;
                                                                                    let expr16_0 = C::value_reg(ctx, expr15_0);
                                                                                    return Some(
                                                                                        expr16_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                }
                                // Rule at src/isa/x64/lower.isle line 754.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_pmullw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            _ => {}
                        }
                    }
                }
            }
            if pattern3_0 == 32 {
                if pattern3_1 == 4 {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern7_0,
                        args: ref pattern7_1,
                    } = &pattern6_0
                    {
                        match &pattern7_0 {
                            &Opcode::Iadd => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 106.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_paddd(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::Isub => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 275.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_psubd(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::Imul => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                if let Some(pattern10_0) = C::def_inst(ctx, pattern9_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Unary {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                    } = &pattern11_0
                                    {
                                        match &pattern12_0 {
                                            &Opcode::SwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 16 {
                                                        if pattern15_1 == 8 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenLow =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 16 {
                                                                                if pattern23_1 == 8
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 860.
                                                                                    let expr0_0 = C::put_in_reg(ctx, pattern12_1);
                                                                                    let expr1_0 = C::put_in_reg(ctx, pattern20_1);
                                                                                    let expr2_0 = RegMem::Reg {
                                                                                        reg: expr1_0,
                                                                                    };
                                                                                    let expr3_0 = constructor_pmullw(ctx, expr0_0, &expr2_0)?;
                                                                                    let expr4_0 = RegMem::Reg {
                                                                                        reg: expr1_0,
                                                                                    };
                                                                                    let expr5_0 = constructor_pmulhw(ctx, expr0_0, &expr4_0)?;
                                                                                    let expr6_0 = RegMem::Reg {
                                                                                        reg: expr5_0,
                                                                                    };
                                                                                    let expr7_0 = constructor_punpcklwd(ctx, expr3_0, &expr6_0)?;
                                                                                    let expr8_0 = C::value_reg(ctx, expr7_0);
                                                                                    return Some(
                                                                                        expr8_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::SwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 16 {
                                                        if pattern15_1 == 8 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenHigh =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 16 {
                                                                                if pattern23_1 == 8
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 824.
                                                                                    let expr0_0 = C::put_in_reg(ctx, pattern12_1);
                                                                                    let expr1_0 = C::put_in_reg(ctx, pattern20_1);
                                                                                    let expr2_0 = RegMem::Reg {
                                                                                        reg: expr1_0,
                                                                                    };
                                                                                    let expr3_0 = constructor_pmullw(ctx, expr0_0, &expr2_0)?;
                                                                                    let expr4_0 = RegMem::Reg {
                                                                                        reg: expr1_0,
                                                                                    };
                                                                                    let expr5_0 = constructor_pmulhw(ctx, expr0_0, &expr4_0)?;
                                                                                    let expr6_0 = RegMem::Reg {
                                                                                        reg: expr5_0,
                                                                                    };
                                                                                    let expr7_0 = constructor_punpckhwd(ctx, expr3_0, &expr6_0)?;
                                                                                    let expr8_0 = C::value_reg(ctx, expr7_0);
                                                                                    return Some(
                                                                                        expr8_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 16 {
                                                        if pattern15_1 == 8 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenLow =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 16 {
                                                                                if pattern23_1 == 8
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 936.
                                                                                    let expr0_0 = C::put_in_reg(ctx, pattern12_1);
                                                                                    let expr1_0 = C::put_in_reg(ctx, pattern20_1);
                                                                                    let expr2_0 = RegMem::Reg {
                                                                                        reg: expr1_0,
                                                                                    };
                                                                                    let expr3_0 = constructor_pmullw(ctx, expr0_0, &expr2_0)?;
                                                                                    let expr4_0 = RegMem::Reg {
                                                                                        reg: expr1_0,
                                                                                    };
                                                                                    let expr5_0 = constructor_pmulhuw(ctx, expr0_0, &expr4_0)?;
                                                                                    let expr6_0 = RegMem::Reg {
                                                                                        reg: expr5_0,
                                                                                    };
                                                                                    let expr7_0 = constructor_punpcklwd(ctx, expr3_0, &expr6_0)?;
                                                                                    let expr8_0 = C::value_reg(ctx, expr7_0);
                                                                                    return Some(
                                                                                        expr8_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 16 {
                                                        if pattern15_1 == 8 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenHigh =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 16 {
                                                                                if pattern23_1 == 8
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 900.
                                                                                    let expr0_0 = C::put_in_reg(ctx, pattern12_1);
                                                                                    let expr1_0 = C::put_in_reg(ctx, pattern20_1);
                                                                                    let expr2_0 = RegMem::Reg {
                                                                                        reg: expr1_0,
                                                                                    };
                                                                                    let expr3_0 = constructor_pmullw(ctx, expr0_0, &expr2_0)?;
                                                                                    let expr4_0 = RegMem::Reg {
                                                                                        reg: expr1_0,
                                                                                    };
                                                                                    let expr5_0 = constructor_pmulhuw(ctx, expr0_0, &expr4_0)?;
                                                                                    let expr6_0 = RegMem::Reg {
                                                                                        reg: expr5_0,
                                                                                    };
                                                                                    let expr7_0 = constructor_punpckhwd(ctx, expr3_0, &expr6_0)?;
                                                                                    let expr8_0 = C::value_reg(ctx, expr7_0);
                                                                                    return Some(
                                                                                        expr8_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                }
                                // Rule at src/isa/x64/lower.isle line 757.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_pmulld(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            _ => {}
                        }
                    }
                }
            }
            if pattern3_0 == 64 {
                if pattern3_1 == 2 {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern7_0,
                        args: ref pattern7_1,
                    } = &pattern6_0
                    {
                        match &pattern7_0 {
                            &Opcode::Iadd => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 111.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_paddq(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::Isub => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 280.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg_mem(ctx, pattern9_1);
                                let expr2_0 = constructor_psubq(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            &Opcode::Imul => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, &pattern7_1);
                                if let Some(pattern10_0) = C::def_inst(ctx, pattern9_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Unary {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                    } = &pattern11_0
                                    {
                                        match &pattern12_0 {
                                            &Opcode::SwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 32 {
                                                        if pattern15_1 == 4 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenLow =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 32 {
                                                                                if pattern23_1 == 4
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 872.
                                                                                    let expr0_0 = C::put_in_reg_mem(ctx, pattern12_1);
                                                                                    let expr1_0: u8 = 80;
                                                                                    let expr2_0 = OperandSize::Size32;
                                                                                    let expr3_0 = constructor_pshufd(ctx, &expr0_0, expr1_0, &expr2_0)?;
                                                                                    let expr4_0 = C::put_in_reg_mem(ctx, pattern20_1);
                                                                                    let expr5_0: u8 = 80;
                                                                                    let expr6_0 = OperandSize::Size32;
                                                                                    let expr7_0 = constructor_pshufd(ctx, &expr4_0, expr5_0, &expr6_0)?;
                                                                                    let expr8_0 = RegMem::Reg {
                                                                                        reg: expr7_0,
                                                                                    };
                                                                                    let expr9_0 = constructor_pmuldq(ctx, expr3_0, &expr8_0)?;
                                                                                    let expr10_0 = C::value_reg(ctx, expr9_0);
                                                                                    return Some(
                                                                                        expr10_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::SwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 32 {
                                                        if pattern15_1 == 4 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenHigh =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 32 {
                                                                                if pattern23_1 == 4
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 836.
                                                                                    let expr0_0 = C::put_in_reg_mem(ctx, pattern12_1);
                                                                                    let expr1_0: u8 = 250;
                                                                                    let expr2_0 = OperandSize::Size32;
                                                                                    let expr3_0 = constructor_pshufd(ctx, &expr0_0, expr1_0, &expr2_0)?;
                                                                                    let expr4_0 = C::put_in_reg_mem(ctx, pattern20_1);
                                                                                    let expr5_0: u8 = 250;
                                                                                    let expr6_0 = OperandSize::Size32;
                                                                                    let expr7_0 = constructor_pshufd(ctx, &expr4_0, expr5_0, &expr6_0)?;
                                                                                    let expr8_0 = RegMem::Reg {
                                                                                        reg: expr7_0,
                                                                                    };
                                                                                    let expr9_0 = constructor_pmuldq(ctx, expr3_0, &expr8_0)?;
                                                                                    let expr10_0 = C::value_reg(ctx, expr9_0);
                                                                                    return Some(
                                                                                        expr10_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 32 {
                                                        if pattern15_1 == 4 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenLow =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 32 {
                                                                                if pattern23_1 == 4
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 948.
                                                                                    let expr0_0 = C::put_in_reg_mem(ctx, pattern12_1);
                                                                                    let expr1_0: u8 = 80;
                                                                                    let expr2_0 = OperandSize::Size32;
                                                                                    let expr3_0 = constructor_pshufd(ctx, &expr0_0, expr1_0, &expr2_0)?;
                                                                                    let expr4_0 = C::put_in_reg_mem(ctx, pattern20_1);
                                                                                    let expr5_0: u8 = 80;
                                                                                    let expr6_0 = OperandSize::Size32;
                                                                                    let expr7_0 = constructor_pshufd(ctx, &expr4_0, expr5_0, &expr6_0)?;
                                                                                    let expr8_0 = RegMem::Reg {
                                                                                        reg: expr7_0,
                                                                                    };
                                                                                    let expr9_0 = constructor_pmuludq(ctx, expr3_0, &expr8_0)?;
                                                                                    let expr10_0 = C::value_reg(ctx, expr9_0);
                                                                                    return Some(
                                                                                        expr10_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 32 {
                                                        if pattern15_1 == 4 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenHigh =
                                                                        &pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 32 {
                                                                                if pattern23_1 == 4
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 912.
                                                                                    let expr0_0 = C::put_in_reg_mem(ctx, pattern12_1);
                                                                                    let expr1_0: u8 = 250;
                                                                                    let expr2_0 = OperandSize::Size32;
                                                                                    let expr3_0 = constructor_pshufd(ctx, &expr0_0, expr1_0, &expr2_0)?;
                                                                                    let expr4_0 = C::put_in_reg_mem(ctx, pattern20_1);
                                                                                    let expr5_0: u8 = 250;
                                                                                    let expr6_0 = OperandSize::Size32;
                                                                                    let expr7_0 = constructor_pshufd(ctx, &expr4_0, expr5_0, &expr6_0)?;
                                                                                    let expr8_0 = RegMem::Reg {
                                                                                        reg: expr7_0,
                                                                                    };
                                                                                    let expr9_0 = constructor_pmuludq(ctx, expr3_0, &expr8_0)?;
                                                                                    let expr10_0 = C::value_reg(ctx, expr9_0);
                                                                                    return Some(
                                                                                        expr10_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                }
                                // Rule at src/isa/x64/lower.isle line 788.
                                let expr0_0 = C::put_in_reg(ctx, pattern9_0);
                                let expr1_0 = C::put_in_reg(ctx, pattern9_1);
                                let expr2_0: u32 = 32;
                                let expr3_0 = RegMemImm::Imm { simm32: expr2_0 };
                                let expr4_0 = constructor_psrlq(ctx, expr0_0, &expr3_0)?;
                                let expr5_0 = RegMem::Reg { reg: expr1_0 };
                                let expr6_0 = constructor_pmuludq(ctx, expr4_0, &expr5_0)?;
                                let expr7_0: u32 = 32;
                                let expr8_0 = RegMemImm::Imm { simm32: expr7_0 };
                                let expr9_0 = constructor_psrlq(ctx, expr1_0, &expr8_0)?;
                                let expr10_0 = RegMem::Reg { reg: expr9_0 };
                                let expr11_0 = constructor_pmuludq(ctx, expr0_0, &expr10_0)?;
                                let expr12_0 = RegMem::Reg { reg: expr11_0 };
                                let expr13_0 = constructor_paddq(ctx, expr6_0, &expr12_0)?;
                                let expr14_0: u32 = 32;
                                let expr15_0 = RegMemImm::Imm { simm32: expr14_0 };
                                let expr16_0 = constructor_psllq(ctx, expr13_0, &expr15_0)?;
                                let expr17_0 = RegMem::Reg { reg: expr1_0 };
                                let expr18_0 = constructor_pmuludq(ctx, expr0_0, &expr17_0)?;
                                let expr19_0 = RegMem::Reg { reg: expr16_0 };
                                let expr20_0 = constructor_paddq(ctx, expr18_0, &expr19_0)?;
                                let expr21_0 = C::value_reg(ctx, expr20_0);
                                return Some(expr21_0);
                            }
                            _ => {}
                        }
                    }
                }
            }
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 371.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_pand(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 447.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_por(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 517.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_1);
                            let expr2_0 = constructor_sse_xor(ctx, pattern2_0, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::BandNot => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 977.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr1_0 = C::put_in_reg_mem(ctx, pattern7_0);
                            let expr2_0 = constructor_pandn(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::value_reg(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bnot = &pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 1044.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0 = constructor_vector_all_ones(ctx, pattern2_0)?;
                        let expr2_0 = RegMem::Reg { reg: expr1_0 };
                        let expr3_0 = constructor_sse_xor(ctx, pattern2_0, expr0_0, &expr2_0)?;
                        let expr4_0 = C::value_reg(ctx, expr3_0);
                        return Some(expr4_0);
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::fits_in_64(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::UnaryImm {
                    opcode: ref pattern5_0,
                    imm: pattern5_1,
                } => {
                    if let &Opcode::Iconst = &pattern5_0 {
                        let pattern7_0 = C::u64_from_imm64(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 10.
                        let expr0_0 = constructor_imm(ctx, pattern3_0, pattern7_0)?;
                        let expr1_0 = C::value_reg(ctx, expr0_0);
                        return Some(expr1_0);
                    }
                }
                &InstructionData::UnaryBool {
                    opcode: ref pattern5_0,
                    imm: pattern5_1,
                } => {
                    if let &Opcode::Bconst = &pattern5_0 {
                        if pattern5_1 == true {
                            // Rule at src/isa/x64/lower.isle line 28.
                            let expr0_0: u64 = 1;
                            let expr1_0 = constructor_imm(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                        if pattern5_1 == false {
                            // Rule at src/isa/x64/lower.isle line 24.
                            let expr0_0: u64 = 0;
                            let expr1_0 = constructor_imm(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = C::value_reg(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                    }
                }
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match &pattern5_0 {
                        &Opcode::Iadd => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 76.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_add(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 88.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 72.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_add(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 82.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 64.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = RegMemImm::Reg { reg: expr1_0 };
                            let expr3_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr2_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                        &Opcode::Isub => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 252.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_sub(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 257.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 = constructor_sub(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 245.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = RegMemImm::Reg { reg: expr1_0 };
                            let expr3_0 = constructor_sub(ctx, pattern3_0, expr0_0, &expr2_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                        &Opcode::Imul => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 694.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_mul(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 706.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 = constructor_mul(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 690.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_mul(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 700.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 = constructor_mul(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 683.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = RegMemImm::Reg { reg: expr1_0 };
                            let expr3_0 = constructor_mul(ctx, pattern3_0, expr0_0, &expr2_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                        &Opcode::IaddIfcout => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 183.
                                let expr0_0: Type = I64;
                                let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
                                let expr2_0 = C::writable_reg_to_reg(ctx, expr1_0);
                                let expr3_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr4_0 =
                                    constructor_add(ctx, pattern3_0, expr3_0, &pattern8_0)?;
                                let expr5_0 = C::value_regs(ctx, expr4_0, expr2_0);
                                return Some(expr5_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 199.
                                let expr0_0: Type = I64;
                                let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
                                let expr2_0 = C::writable_reg_to_reg(ctx, expr1_0);
                                let expr3_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr4_0 = C::sink_load(ctx, &pattern8_0);
                                let expr5_0 = constructor_add(ctx, pattern3_0, expr3_0, &expr4_0)?;
                                let expr6_0 = C::value_regs(ctx, expr5_0, expr2_0);
                                return Some(expr6_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 177.
                                let expr0_0: Type = I64;
                                let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
                                let expr2_0 = C::writable_reg_to_reg(ctx, expr1_0);
                                let expr3_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr4_0 =
                                    constructor_add(ctx, pattern3_0, expr3_0, &pattern8_0)?;
                                let expr5_0 = C::value_regs(ctx, expr4_0, expr2_0);
                                return Some(expr5_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 191.
                                let expr0_0: Type = I64;
                                let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
                                let expr2_0 = C::writable_reg_to_reg(ctx, expr1_0);
                                let expr3_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr4_0 = C::sink_load(ctx, &pattern8_0);
                                let expr5_0 = constructor_add(ctx, pattern3_0, expr3_0, &expr4_0)?;
                                let expr6_0 = C::value_regs(ctx, expr5_0, expr2_0);
                                return Some(expr6_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 167.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::temp_writable_reg(ctx, expr0_0);
                            let expr2_0 = C::writable_reg_to_reg(ctx, expr1_0);
                            let expr3_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr4_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr5_0 = RegMemImm::Reg { reg: expr4_0 };
                            let expr6_0 = constructor_add(ctx, pattern3_0, expr3_0, &expr5_0)?;
                            let expr7_0 = C::value_regs(ctx, expr6_0, expr2_0);
                            return Some(expr7_0);
                        }
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 355.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_m_and(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 341.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 =
                                    constructor_m_and(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 349.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_m_and(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 335.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 =
                                    constructor_m_and(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 328.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = RegMemImm::Reg { reg: expr1_0 };
                            let expr3_0 = constructor_m_and(ctx, pattern3_0, expr0_0, &expr2_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 431.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_or(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 417.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 = constructor_or(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 425.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_or(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 411.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 = constructor_or(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 404.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = RegMemImm::Reg { reg: expr1_0 };
                            let expr3_0 = constructor_or(ctx, pattern3_0, expr0_0, &expr2_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 509.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 =
                                    constructor_xor(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 495.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_1);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 = constructor_xor(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 503.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_xor(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 489.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 = C::sink_load(ctx, &pattern8_0);
                                let expr2_0 = constructor_xor(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 482.
                            let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr1_0 = C::put_in_reg(ctx, pattern7_1);
                            let expr2_0 = RegMemImm::Reg { reg: expr1_0 };
                            let expr3_0 = constructor_xor(ctx, pattern3_0, expr0_0, &expr2_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::imm8_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 553.
                                let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                                let expr1_0 =
                                    constructor_shl(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::value_reg(ctx, expr1_0);
                                return Some(expr2_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 547.
                            let expr0_0 = constructor_lo_reg(ctx, pattern7_1)?;
                            let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                            let expr2_0 = Imm8Reg::Reg { reg: expr0_0 };
                            let expr3_0 = constructor_shl(ctx, pattern3_0, expr1_0, &expr2_0)?;
                            let expr4_0 = C::value_reg(ctx, expr3_0);
                            return Some(expr4_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) =
                                C::unpack_value_array_2(ctx, &pattern5_1);
                            if let Some(pattern8_0) = C::imm8_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 599.
                                let expr0_0 = ExtendKind::Zero;
                                let expr1_0 = constructor_extend_to_reg(
                                    ctx, pattern7_0, pattern3_0, &expr0_0,
                                )?;
                                let expr2_0 =
                                    constructor_shr(ctx, pattern3_0, expr1_0, &pattern8_0)?;
                                let expr3_0 = C::value_reg(ctx, expr2_0);
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 592.
                            let expr0_0 = ExtendKind::Zero;
                            let expr1_0 =
                                constructor_extend_to_reg(ctx, pattern7_0, pattern3_0, &expr0_0)?;
                            let expr2_0 = constructor_lo_reg(ctx, pattern7_1)?;
                            let expr3_0 = Imm8Reg::Reg { reg: expr2_0 };
                            let expr4_0 = constructor_shr(ctx, pattern3_0, expr1_0, &expr3_0)?;
                            let expr5_0 = C::value_reg(ctx, expr4_0);
                            return Some(expr5_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bnot = &pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 1023.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0 = constructor_not(ctx, pattern3_0, expr0_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                }
                &InstructionData::BinaryImm64 {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    imm: pattern5_2,
                } => {
                    if let &Opcode::IaddImm = &pattern5_0 {
                        let pattern7_0 = C::u64_from_imm64(ctx, pattern5_2);
                        // Rule at src/isa/x64/lower.isle line 218.
                        let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                        let expr1_0 = constructor_imm(ctx, pattern3_0, pattern7_0)?;
                        let expr2_0 = RegMemImm::Reg { reg: expr1_0 };
                        let expr3_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr2_0)?;
                        let expr4_0 = C::value_reg(ctx, expr3_0);
                        return Some(expr4_0);
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Rotl = &pattern5_0 {
                    let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, &pattern5_1);
                    if let Some(pattern8_0) = C::imm8_from_value(ctx, pattern7_1) {
                        // Rule at src/isa/x64/lower.isle line 655.
                        let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                        let expr1_0 = constructor_m_rotl(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                        let expr2_0 = C::value_reg(ctx, expr1_0);
                        return Some(expr2_0);
                    }
                    // Rule at src/isa/x64/lower.isle line 649.
                    let expr0_0 = constructor_lo_reg(ctx, pattern7_1)?;
                    let expr1_0 = C::put_in_reg(ctx, pattern7_0);
                    let expr2_0 = Imm8Reg::Reg { reg: expr0_0 };
                    let expr3_0 = constructor_m_rotl(ctx, pattern3_0, expr1_0, &expr2_0)?;
                    let expr4_0 = C::value_reg(ctx, expr3_0);
                    return Some(expr4_0);
                }
            }
        }
        if let Some(pattern3_0) = C::ty_8_or_16(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Rotl = &pattern5_0 {
                    let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, &pattern5_1);
                    if let Some(pattern8_0) = C::imm8_from_value(ctx, pattern7_1) {
                        // Rule at src/isa/x64/lower.isle line 643.
                        let expr0_0 = C::put_in_reg(ctx, pattern7_0);
                        let expr1_0 = C::ty_bits_mask(ctx, pattern3_0);
                        let expr2_0 = C::mask_imm8_const(ctx, &pattern8_0, expr1_0);
                        let expr3_0 = constructor_m_rotl(ctx, pattern3_0, expr0_0, &expr2_0)?;
                        let expr4_0 = C::value_reg(ctx, expr3_0);
                        return Some(expr4_0);
                    }
                    // Rule at src/isa/x64/lower.isle line 639.
                    let expr0_0: Type = I32;
                    let expr1_0 = ExtendKind::Zero;
                    let expr2_0 = constructor_extend_to_reg(ctx, pattern7_1, expr0_0, &expr1_0)?;
                    let expr3_0 = C::put_in_reg(ctx, pattern7_0);
                    let expr4_0 = Imm8Reg::Reg { reg: expr2_0 };
                    let expr5_0 = constructor_m_rotl(ctx, pattern3_0, expr3_0, &expr4_0)?;
                    let expr6_0 = C::value_reg(ctx, expr5_0);
                    return Some(expr6_0);
                }
            }
        }
    }
    return None;
}

// Generated as internal constructor for term or_i128.
pub fn constructor_or_i128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: ValueRegs,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/lower.isle line 455.
    let expr0_0: usize = 0;
    let expr1_0 = C::value_regs_get(ctx, pattern0_0, expr0_0);
    let expr2_0: usize = 1;
    let expr3_0 = C::value_regs_get(ctx, pattern0_0, expr2_0);
    let expr4_0: usize = 0;
    let expr5_0 = C::value_regs_get(ctx, pattern1_0, expr4_0);
    let expr6_0: usize = 1;
    let expr7_0 = C::value_regs_get(ctx, pattern1_0, expr6_0);
    let expr8_0: Type = I64;
    let expr9_0 = RegMemImm::Reg { reg: expr5_0 };
    let expr10_0 = constructor_or(ctx, expr8_0, expr1_0, &expr9_0)?;
    let expr11_0: Type = I64;
    let expr12_0 = RegMemImm::Reg { reg: expr7_0 };
    let expr13_0 = constructor_or(ctx, expr11_0, expr3_0, &expr12_0)?;
    let expr14_0 = C::value_regs(ctx, expr10_0, expr13_0);
    return Some(expr14_0);
}

// Generated as internal constructor for term shl_i128.
pub fn constructor_shl_i128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: Reg,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/lower.isle line 559.
    let expr0_0: usize = 0;
    let expr1_0 = C::value_regs_get(ctx, pattern0_0, expr0_0);
    let expr2_0: usize = 1;
    let expr3_0 = C::value_regs_get(ctx, pattern0_0, expr2_0);
    let expr4_0: Type = I64;
    let expr5_0 = Imm8Reg::Reg { reg: pattern1_0 };
    let expr6_0 = constructor_shl(ctx, expr4_0, expr1_0, &expr5_0)?;
    let expr7_0: Type = I64;
    let expr8_0 = Imm8Reg::Reg { reg: pattern1_0 };
    let expr9_0 = constructor_shl(ctx, expr7_0, expr3_0, &expr8_0)?;
    let expr10_0: Type = I64;
    let expr11_0: Type = I64;
    let expr12_0: Type = I64;
    let expr13_0: u64 = 64;
    let expr14_0 = constructor_imm(ctx, expr12_0, expr13_0)?;
    let expr15_0 = RegMemImm::Reg { reg: pattern1_0 };
    let expr16_0 = constructor_sub(ctx, expr11_0, expr14_0, &expr15_0)?;
    let expr17_0 = Imm8Reg::Reg { reg: expr16_0 };
    let expr18_0 = constructor_shr(ctx, expr10_0, expr1_0, &expr17_0)?;
    let expr19_0: Type = I64;
    let expr20_0: u64 = 0;
    let expr21_0 = constructor_imm(ctx, expr19_0, expr20_0)?;
    let expr22_0 = OperandSize::Size64;
    let expr23_0: u32 = 127;
    let expr24_0 = RegMemImm::Imm { simm32: expr23_0 };
    let expr25_0 = constructor_test(ctx, &expr22_0, &expr24_0, pattern1_0)?;
    let expr26_0: Type = I64;
    let expr27_0 = CC::Z;
    let expr28_0 = RegMem::Reg { reg: expr21_0 };
    let expr29_0 = constructor_cmove(ctx, expr26_0, &expr27_0, &expr28_0, expr18_0)?;
    let expr30_0 = constructor_with_flags_1(ctx, &expr25_0, &expr29_0)?;
    let expr31_0: Type = I64;
    let expr32_0 = RegMemImm::Reg { reg: expr9_0 };
    let expr33_0 = constructor_or(ctx, expr31_0, expr30_0, &expr32_0)?;
    let expr34_0 = OperandSize::Size64;
    let expr35_0: u32 = 64;
    let expr36_0 = RegMemImm::Imm { simm32: expr35_0 };
    let expr37_0 = constructor_test(ctx, &expr34_0, &expr36_0, pattern1_0)?;
    let expr38_0: Type = I64;
    let expr39_0 = CC::Z;
    let expr40_0 = RegMem::Reg { reg: expr6_0 };
    let expr41_0 = constructor_cmove(ctx, expr38_0, &expr39_0, &expr40_0, expr21_0)?;
    let expr42_0: Type = I64;
    let expr43_0 = CC::Z;
    let expr44_0 = RegMem::Reg { reg: expr33_0 };
    let expr45_0 = constructor_cmove(ctx, expr42_0, &expr43_0, &expr44_0, expr6_0)?;
    let expr46_0 = constructor_with_flags_2(ctx, &expr37_0, &expr41_0, &expr45_0)?;
    return Some(expr46_0);
}

// Generated as internal constructor for term shr_i128.
pub fn constructor_shr_i128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: Reg,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/lower.isle line 606.
    let expr0_0: usize = 0;
    let expr1_0 = C::value_regs_get(ctx, pattern0_0, expr0_0);
    let expr2_0: usize = 1;
    let expr3_0 = C::value_regs_get(ctx, pattern0_0, expr2_0);
    let expr4_0: Type = I64;
    let expr5_0 = Imm8Reg::Reg { reg: pattern1_0 };
    let expr6_0 = constructor_shr(ctx, expr4_0, expr1_0, &expr5_0)?;
    let expr7_0: Type = I64;
    let expr8_0 = Imm8Reg::Reg { reg: pattern1_0 };
    let expr9_0 = constructor_shr(ctx, expr7_0, expr3_0, &expr8_0)?;
    let expr10_0: Type = I64;
    let expr11_0: Type = I64;
    let expr12_0: Type = I64;
    let expr13_0: u64 = 64;
    let expr14_0 = constructor_imm(ctx, expr12_0, expr13_0)?;
    let expr15_0 = RegMemImm::Reg { reg: pattern1_0 };
    let expr16_0 = constructor_sub(ctx, expr11_0, expr14_0, &expr15_0)?;
    let expr17_0 = Imm8Reg::Reg { reg: expr16_0 };
    let expr18_0 = constructor_shl(ctx, expr10_0, expr3_0, &expr17_0)?;
    let expr19_0 = OperandSize::Size64;
    let expr20_0: u32 = 127;
    let expr21_0 = RegMemImm::Imm { simm32: expr20_0 };
    let expr22_0 = constructor_test(ctx, &expr19_0, &expr21_0, pattern1_0)?;
    let expr23_0: Type = I64;
    let expr24_0 = CC::Z;
    let expr25_0: Type = I64;
    let expr26_0: u64 = 0;
    let expr27_0 = constructor_imm(ctx, expr25_0, expr26_0)?;
    let expr28_0 = RegMem::Reg { reg: expr27_0 };
    let expr29_0 = constructor_cmove(ctx, expr23_0, &expr24_0, &expr28_0, expr18_0)?;
    let expr30_0 = constructor_with_flags_1(ctx, &expr22_0, &expr29_0)?;
    let expr31_0: Type = I64;
    let expr32_0 = RegMemImm::Reg { reg: expr6_0 };
    let expr33_0 = constructor_or(ctx, expr31_0, expr30_0, &expr32_0)?;
    let expr34_0 = OperandSize::Size64;
    let expr35_0: u32 = 64;
    let expr36_0 = RegMemImm::Imm { simm32: expr35_0 };
    let expr37_0 = constructor_test(ctx, &expr34_0, &expr36_0, pattern1_0)?;
    let expr38_0: Type = I64;
    let expr39_0 = CC::Z;
    let expr40_0 = RegMem::Reg { reg: expr33_0 };
    let expr41_0 = constructor_cmove(ctx, expr38_0, &expr39_0, &expr40_0, expr9_0)?;
    let expr42_0: Type = I64;
    let expr43_0 = CC::Z;
    let expr44_0 = RegMem::Reg { reg: expr9_0 };
    let expr45_0: Type = I64;
    let expr46_0: u64 = 0;
    let expr47_0 = constructor_imm(ctx, expr45_0, expr46_0)?;
    let expr48_0 = constructor_cmove(ctx, expr42_0, &expr43_0, &expr44_0, expr47_0)?;
    let expr49_0 = constructor_with_flags_2(ctx, &expr37_0, &expr41_0, &expr48_0)?;
    return Some(expr49_0);
}

// Generated as internal constructor for term i128_not.
pub fn constructor_i128_not<C: Context>(ctx: &mut C, arg0: Value) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/lower.isle line 1029.
    let expr0_0 = C::put_in_regs(ctx, pattern0_0);
    let expr1_0: usize = 0;
    let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
    let expr3_0: usize = 1;
    let expr4_0 = C::value_regs_get(ctx, expr0_0, expr3_0);
    let expr5_0: Type = I64;
    let expr6_0 = constructor_not(ctx, expr5_0, expr2_0)?;
    let expr7_0: Type = I64;
    let expr8_0 = constructor_not(ctx, expr7_0, expr4_0)?;
    let expr9_0 = C::value_regs(ctx, expr6_0, expr8_0);
    return Some(expr9_0);
}

// Generated as internal constructor for term vec_insert_lane.
pub fn constructor_vec_insert_lane<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Reg,
    arg2: &RegMem,
    arg3: u8,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8X16 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1060.
        let expr0_0 = constructor_pinsrb(ctx, pattern2_0, pattern3_0, pattern4_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == I16X8 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1063.
        let expr0_0 = constructor_pinsrw(ctx, pattern2_0, pattern3_0, pattern4_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == I32X4 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1066.
        let expr0_0 = OperandSize::Size32;
        let expr1_0 = constructor_pinsrd(ctx, pattern2_0, pattern3_0, pattern4_0, &expr0_0)?;
        return Some(expr1_0);
    }
    if pattern0_0 == I64X2 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1069.
        let expr0_0 = OperandSize::Size64;
        let expr1_0 = constructor_pinsrd(ctx, pattern2_0, pattern3_0, pattern4_0, &expr0_0)?;
        return Some(expr1_0);
    }
    if pattern0_0 == F32X4 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1072.
        let expr0_0 = C::sse_insertps_lane_imm(ctx, pattern4_0);
        let expr1_0 = constructor_insertps(ctx, pattern2_0, pattern3_0, expr0_0)?;
        return Some(expr1_0);
    }
    if pattern0_0 == F64X2 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        if let &RegMem::Reg { reg: pattern4_0 } = pattern3_0 {
            let pattern5_0 = arg3;
            if pattern5_0 == 0 {
                // Rule at src/isa/x64/lower.isle line 1093.
                let expr0_0 = RegMem::Reg { reg: pattern4_0 };
                let expr1_0 = constructor_movsd(ctx, pattern2_0, &expr0_0)?;
                return Some(expr1_0);
            }
        }
        let pattern4_0 = arg3;
        if pattern4_0 == 0 {
            // Rule at src/isa/x64/lower.isle line 1094.
            let expr0_0 = SseOpcode::Movsd;
            let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern3_0)?;
            let expr2_0 = RegMem::Reg { reg: expr1_0 };
            let expr3_0 = constructor_movsd(ctx, pattern2_0, &expr2_0)?;
            return Some(expr3_0);
        }
        if pattern4_0 == 1 {
            // Rule at src/isa/x64/lower.isle line 1102.
            let expr0_0 = constructor_movlhps(ctx, pattern2_0, pattern3_0)?;
            return Some(expr0_0);
        }
    }
    return None;
}
