use once_cell::sync::Lazy;

#[allow(dead_code)]
#[derive(serde_derive::Deserialize)]
pub struct Environment {
    current_dir: String,
    global_vars: Vec<toml::Value>,
    return_val: toml::Value,
}

pub static PATHS: Lazy<directories::ProjectDirs> = Lazy::new(|| 
    match directories::ProjectDirs::from("com", "", "crab") {
        None => {
            println!("Unable to write to home directory, maybe you don't have permissions?");
            std::process::exit(1);
        }
        Some(v) => {
            if !v.config_dir().join("env.toml").exists() {
                std::fs::write(
                    v.config_dir().join("crates/env.toml"),
                    include_str!("env.toml"),
                )
                .unwrap();
            }
            v
        }
    }
);

pub static ENV: Lazy<Environment> = Lazy::new(|| Environment {
    current_dir: String::new(),
    global_vars: Vec::new(),
    return_val: toml::Value::Boolean(false),
});
pub static ENV_PATH: Lazy<std::path::PathBuf> = Lazy::new(|| PATHS.config_dir().join("env.toml"));

pub static CRATES_PATH: Lazy<std::path::PathBuf> = Lazy::new(|| PATHS.config_dir().join("crates"));

pub static CRATES: Lazy<std::collections::HashSet<String>> = Lazy::new(|| {
    let mut crates = std::collections::HashSet::new();
    let config = match CRATES_PATH.read_dir() {
        Ok(p) => p,
        Err(e) => {
            std::fs::create_dir_all(CRATES_PATH.as_path()).expect(&e.to_string());
            std::process::exit(1);
        }
    };

    for folder in config {
        if folder.is_err() {
            break;
        }
        if folder.as_ref().unwrap().file_type().unwrap().is_dir() {
            crates.insert(folder.unwrap().file_name().to_string_lossy().to_string());
        }
    }

    crates
});
