#[derive(serde_derive::Deserialize)]
pub struct Environment {
    current_dir: String,
    global_vars: Vec<toml::Value>,
    return_val: toml::Value, 
}

lazy_static::lazy_static! {
    pub static ref PATHS: directories::ProjectDirs = match directories::ProjectDirs::from("com", "", "crab") {
        None => {
            println!("Unable to write to home directory, maybe you don't have permissions?");
            std::process::exit(1);
        }
        Some(v) => {
            if !PATHS.config_dir().join("env.toml").exists() {
                std::fs::write(ENV_PATH.as_path(), include_str!("env.toml")).unwrap();
            }
            v
        }
    };

    pub static ref ENV: Box<Environment> = Box::new(Environment { current_dir: String::new(), global_vars: Vec::new(), return_val: toml::Value::Boolean(false) });
    pub static ref ENV_PATH: std::path::PathBuf = PATHS.config_dir().join("env.toml");
        
    pub static ref CRATES_PATH: std::path::PathBuf = PATHS.config_dir().join("crates");
    pub static ref CRATES: std::collections::HashSet<String> = {
        let mut crates = std::collections::HashSet::new();
        let config = match CRATES_PATH.read_dir() {
            Ok(p) => p,
            Err(e) => {
                std::fs::create_dir_all(CRATES_PATH.as_path()).expect(&e.to_string());
                std::process::exit(1);
            }
        };
        
        for folder in config {
            if folder.is_err() { break; }
            if folder.as_ref().unwrap().file_type().unwrap().is_dir() {
                crates.insert(folder.unwrap().file_name().to_string_lossy().to_string());
            }
        }
        
        crates
    };
}