use cqrs_es2::IEventStore;

use static_assertions::assert_impl_all;

use postgres::{
    Client,
    NoTls,
};

use cqrs_es2_sql::{
    get_snapshot_cqrs,
    SnapshotEventStore,
};

use super::common_one::*;

assert_impl_all!(
    SnapshotEventStore::<TestAggregate>: IEventStore::<TestAggregate>
);

fn test_snapshot_store() -> SnapshotEventStore<TestAggregate> {
    let conn = Client::connect(CONNECTION_STRING, NoTls).unwrap();
    SnapshotEventStore::<TestAggregate>::new(conn)
}

#[test]
fn commit_and_load_events_snapshot_store() {
    let mut event_store = test_snapshot_store();
    let id = uuid::Uuid::new_v4().to_string();
    assert_eq!(0, event_store.load(id.as_str()).len());
    let context = event_store.load_aggregate(id.as_str());

    event_store
        .commit(
            vec![
                TestEvent::Created(Created {
                    id: "test_event_A".to_string(),
                }),
                TestEvent::Tested(Tested {
                    test_name: "test A".to_string(),
                }),
            ],
            context,
            metadata(),
        )
        .unwrap();

    assert_eq!(2, event_store.load(id.as_str()).len());
    let context = event_store.load_aggregate(id.as_str());

    event_store
        .commit(
            vec![TestEvent::Tested(Tested {
                test_name: "test B".to_string(),
            })],
            context,
            metadata(),
        )
        .unwrap();
    assert_eq!(3, event_store.load(id.as_str()).len());
}
