pub static INSERT_EVENT: &str = "
INSERT INTO
    events
    (
        aggregate_type, 
        aggregate_id,
        sequence,
        payload, 
        metadata
    )
VALUES
    (
        $1,
        $2,
        $3,
        $4,
        $5
    );
";

pub static SELECT_EVENTS: &str = "
SELECT
    aggregate_type,
    aggregate_id, 
    sequence,
    payload,
    metadata
FROM
    events
WHERE
    aggregate_type = $1
    AND
    aggregate_id = $2
ORDER BY 
    sequence;
";

pub static INSERT_SNAPSHOT: &str = "
INSERT INTO
    snapshots 
    (
        aggregate_type,
        aggregate_id, 
        last_sequence,
        payload
    )
VALUES
    (
        $1,
        $2,
        $3,
        $4
    );
";

pub static UPDATE_SNAPSHOT: &str = "
UPDATE
    snapshots
SET
    last_sequence= $3,
    payload= $4
WHERE
    aggregate_type= $1
    AND
    aggregate_id= $2;
";

pub static SELECT_SNAPSHOT: &str = "
SELECT
    aggregate_type, 
    aggregate_id,
    last_sequence,
    payload
FROM
    snapshots
WHERE
    aggregate_type = $1
    AND
    aggregate_id = $2;
";
