#![forbid(unsafe_code)]
#![deny(missing_docs)]
#![deny(clippy::all)]
// #![warn(clippy::pedantic)]

//! # cqrs-es2-sql
//!
//! **A Postgres implementation of the `EventStore` trait in
//! cqrs-es2.**
//!
//! [![Publish](https://github.com/brgirgis/cqrs-es2-sql/actions/workflows/crates-io.yml/badge.svg)](https://github.com/brgirgis/cqrs-es2-sql/actions/workflows/crates-io.yml)
//! [![Test](https://github.com/brgirgis/cqrs-es2-sql/actions/workflows/rust-ci.yml/badge.svg)](https://github.com/brgirgis/cqrs-es2-sql/actions/workflows/rust-ci.yml)
//! [![Crates.io](https://img.shields.io/crates/v/cqrs-es2-sql)](https://crates.io/crates/cqrs-es2-sql)
//! [![docs](https://img.shields.io/badge/API-docs-blue.svg)](https://docs.rs/cqrs-es2-sql)
//!
//! ## Installation
//!
//! ```toml
//! [dependencies]
//! cqrs-es2 = "^0.2"
//! serde = { version = "^1.0.127", features = ["derive"] }
//! serde_json = "^1.0.66"
//! cqrs-es2-sql = "0.2.3"
//! postgres = { version = "^0.19.1", features = ["with-serde_json-1"] }
//! ```
pub use crate::{
    framework::*,
    queries::*,
    stores::*,
};

// query constants
mod sql;

mod stores;

mod queries;

mod framework;
