use cqrs_es2::{
    CqrsFramework,
    IAggregate,
    IQueryProcessor,
};
use postgres::Client;

use crate::stores::SnapshotEventStore;

/// A convenience type for creating a CqrsFramework backed by
/// SnapshotSqlStore and using a simple metadata supplier with
/// time of commit.
pub type SnapshotCqrs<A> = CqrsFramework<A, SnapshotEventStore<A>>;

/// A convenience function for creating a CqrsFramework using a
/// snapshot store
pub fn get_snapshot_cqrs<A: IAggregate>(
    conn: Client,
    query_processor: Vec<Box<dyn IQueryProcessor<A>>>,
) -> SnapshotCqrs<A> {
    CqrsFramework::new(
        SnapshotEventStore::new(conn),
        query_processor,
    )
}
