use postgres::Client;

use cqrs_es2::{
    CqrsFramework,
    IAggregate,
    IQueryProcessor,
};

use crate::stores::EventStore;

/// A convenience type for creating a CqrsFramework backed by
/// EventStore and using a simple metadata supplier with time of
/// commit.
pub type Cqrs<A> = CqrsFramework<A, EventStore<A>>;

/// A convenience function for creating a CqrsFramework
pub fn get_cqrs<A: IAggregate>(
    conn: Client,
    query_processor: Vec<Box<dyn IQueryProcessor<A>>>,
) -> Cqrs<A> {
    let store = EventStore::new(conn);
    CqrsFramework::new(store, query_processor)
}
