# cqrs-es2-sql

**A SQL implementation of the cqrs-es2 stores.**

[![Publish](https://github.com/brgirgis/cqrs-es2-sql/actions/workflows/crates-io.yml/badge.svg)](https://github.com/brgirgis/cqrs-es2-sql/actions/workflows/crates-io.yml)
[![Test](https://github.com/brgirgis/cqrs-es2-sql/actions/workflows/rust-ci.yml/badge.svg)](https://github.com/brgirgis/cqrs-es2-sql/actions/workflows/rust-ci.yml)
[![Crates.io](https://img.shields.io/crates/v/cqrs-es2-sql)](https://crates.io/crates/cqrs-es2-sql)
[![docs](https://img.shields.io/badge/API-docs-blue.svg)](https://docs.rs/cqrs-es2-sql)

---

## Installation

```toml
[dependencies]
cqrs-es2 = "^0.3"
serde = { version = "^1.0.127", features = ["derive"] }
serde_json = "^1.0.66"
cqrs-es2-sql = "0.1.0"
postgres = { version = "^0.19.1", features = ["with-serde_json-1"] }
```

## Usage

```rust
use postgres::{Client, NoTls};
use cqrs_es2_sql::postgres_cqrs;

let connection = Client::connect("postgresql://demo_user:demo_pass@localhost:5432/demo", NoTls).unwrap();
let cqrs = postgres_cqrs(connection, vec![Box::new(my_query)])
```

## Change log

### `v0.1.0`

- Move from deprecated repo
- Consolidate store implementations
- Use `cqrs-es2` version 0.4.0

## TODO

- Some additional framework around `GenericQueryRepository` to simplify event replay.

## Demo

A demo application [is available here](https://github.com/brgirgis/cqrs-restful-demo).
