# cplex-sys

[![cplex-sys crate](https://img.shields.io/crates/v/cplex-sys.svg)](https://crates.io/crates/cplex-sys)

## Introduction

`cplex-sys` is a crate for the [Rust][Rust] programming language
providing low-level access to the [ILOG CPLEX][Cplex] optimization
suite.

The API bindings are automatically generated from the C header files
on your system.

## Author

Frank Fischer <frank-fischer@shadow-soft.de>

## License

Licensed under MIT.

## Build

Add the following line to your `Cargo.toml`.

    [dependencies]
    cplex-sys = "^0.8"
    
The build script required the environment variable `CPLEX_HOME` to be
set to the path of your Cplex installation, e.g.

    export CPLEX_HOME=/path/to/CPLEX_Studio201/cplex
    
## Documentation

The [API reference][API] documentation.
    
## Remarks

The following versions of Cplex and and `cplex-sys` are known to work.

- `cplex-sys` 0.3 and Cplex 12.7
- `cplex-sys` 0.4 and Cplex 12.8
- `cplex-sys` 0.5 and Cplex 12.8
- `cplex-sys` 0.6 and Cplex 12.9, 12.10
- `cplex-sys` 0.7 and Cplex 12.10
- `cplex-sys` 0.8 and Cplex 12.10, 20.1.0

[Rust]: https://www.rust-lang.org
[Cplex]: https://www.ibm.com/us-en/marketplace/ibm-ilog-cplex
[API]: http://fifr.spdns.de/doc/cplex_sys
