# Создание нового проекта

Теперь, когда Вы изучили основные возможности фреймворка RTIC, Вы можете
попробовать его использовать на Вашем оборудовании следуя этим инструкциям.

1. Создайте экземпляр из шаблона [`cortex-m-quickstart`].

[`cortex-m-quickstart`]: https://github.com/rust-embedded/cortex-m-quickstart#cortex-m-quickstart

``` console
$ # например используя `cargo-generate`
$ cargo generate \
    --git https://github.com/rust-embedded/cortex-m-quickstart \
    --name app

$ # следуйте остальным инструкциям
```

2. Добавьте крейт доступа к периферии (PAC), сгенерированный с помощью[`svd2rust`]
   **v0.14.x**, или крейт отладочной платы, у которой в зависимостях один из таких PAC'ов.
   Убедитесь, что опция `rt` крейта включена.

[`svd2rust`]: https://crates.io/crates/svd2rust

В этом примере я буду использовать крейт устройства [`lm3s6965`].
Эта библиотека не имеет Cargo-опции `rt`; эта опция всегда включена.

[`lm3s6965`]: https://crates.io/crates/lm3s6965

Этот крейт устройства предоставляет линковочный скрипт с макетом памяти
целевого устройства, поэтому `memory.x` и `build.rs` нужно удалить.

``` console
$ cargo add lm3s6965 --vers 0.1.3

$ rm memory.x build.rs
```

3. Добавьте крейт `cortex-m-rtic` как зависимость.

``` console
$ cargo add cortex-m-rtic --allow-prerelease
```

4. Напишите свою RTIC программу.

Здесь я буду использовать пример `init` из крейта `cortex-m-rtic`.

Примеры находтся в папке `examples`, а содержание `init.rs` показано здесь:

``` console
{{#include ../../../../examples/init.rs}}
```

Пример `init` использует устройство `lm3s6965`. Не забудьте настроить аргумент `device`
в атрибуте макроса app так, чтобы он соответствовал пути к PAC-крейту, если он отличается,
а также добавить перифериб и другие аргументы если необходимо.
Несмотря на то, что в программе могут использоваться псевдонимы типов,
здесь необходимо указать полный путь (из корня крейта). Для многих устройств,
есть общий подход в крейтах реализации HAL (с псевдонимом `hal`) и крейтах поддержки
отладочных плат реекспортиорвать PAC как `pac`, что приводит нас к образцу, аналогичному
приведенному ниже:

```rust
use abcd123_hal as hal;
//...

#[rtic::app(device = crate::hal::pac, peripherals = true, monotonic = rtic::cyccnt::CYCCNT)]
mod app { /*...*/ }
```

Пример `init` также зависит от крейта `panic-semihosting`:

``` console
$ cargo add panic-semihosting
```

5. Соберите его, загрузите в микроконтроллер и запустите.

``` console
$ # ПРИМЕЧАНИЕ: Я раскомментировал опцию `runner` в `.cargo/config`
$ cargo run
{{#include ../../../../ci/expected/init.run}}
```
