# Inspecting generated code

`#[rtic::app]` is a procedural macro that produces support code. If for some
reason you need to inspect the code generated by this macro you have two
options:

You can inspect the file `rtic-expansion.rs` inside the `target` directory. This
file contains the expansion of the `#[rtic::app]` item (not your whole program!)
of the *last built* (via `cargo build` or `cargo check`) RTIC application. The
expanded code is not pretty printed by default, so you'll want to run `rustfmt`
on it before you read it.

``` console
$ cargo build --example foo

$ rustfmt target/rtic-expansion.rs

tail target/rtic-expansion.rs
```

``` rust
#[doc = r" Implementation details"]
mod app {
    #[doc = r" Always include the device crate which contains the vector table"]
    use lm3s6965 as _;
    #[no_mangle]
    unsafe extern "C" fn main() -> ! {
        rtic::export::interrupt::disable();
        let mut core: rtic::export::Peripherals = core::mem::transmute(());
        core.SCB.scr.modify(|r| r | 1 << 1);
        rtic::export::interrupt::enable();
        loop {
            rtic::export::wfi()
        }
    }
}
```

Or, you can use the [`cargo-expand`] sub-command. This sub-command will expand
*all* the macros, including the `#[rtic::app]` attribute, and modules in your
crate and print the output to the console.

[`cargo-expand`]: https://crates.io/crates/cargo-expand

``` console
# produces the same output as before
cargo expand --example smallest | tail
```
