# Миграция с RTFM на RTIC

В этом разделе описано, как обновить приложение, написанное на RTFM v0.5.x на RTIC той же версии.
Это необходимо из-за переименования фреймворка в соответствии с [RFC #33].

**Примечание:** Между RTFM v0.5.3 и RTIC v0.5.3 нет разниц в коде, это исключительно изменение имен.

[RFC #33]: https://github.com/rtic-rs/rfcs/pull/33

## `Cargo.toml`

Во-первых, зависимость `cortex-m-rtfm` должна быть изменена на `cortex-m-rtic`.

``` toml
[dependencies]
# измените это
cortex-m-rtfm = "0.5.3"

# на это
cortex-m-rtic = "0.5.3"
```

## Изменения в коде

Единственное изменение в коде, которое нужно сделать - поменять все ссылки на `rtfm`,
чтобы они указывали на `rtic`:

``` rust
//
// Измените это
//

#[rtfm::app(/* .. */, monotonic = rtfm::cyccnt::CYCCNT)]
const APP: () = {
    // ...

};

//
// На это
//

#[rtic::app(/* .. */, monotonic = rtic::cyccnt::CYCCNT)]
const APP: () = {
    // ...

};
```
