//! Tests that a crate can still build with all warnings enabled.
//!
//! The code generated by the `cortex-m-rt` macros might need to manually
//! `#[allow]` some of them (even though Rust does that by default for a few
//! warnings too).

#![no_std]
#![no_main]
#![deny(warnings, missing_docs, rust_2018_idioms)]

extern crate cortex_m_rt;
extern crate panic_halt;

use cortex_m_rt::{entry, exception, interrupt, pre_init, ExceptionFrame};

#[allow(non_camel_case_types)]
enum interrupt {
    INT,
}

extern "C" {
    fn INT();
}

union Vector {
    #[allow(dead_code)]
    handler: unsafe extern "C" fn(),
}

#[link_section = ".vector_table.interrupts"]
#[no_mangle]
#[used]
static __INTERRUPTS: [Vector; 1] = [Vector { handler: INT }];

/// Dummy interrupt.
#[interrupt]
fn INT() {}

#[exception]
fn HardFault(_eh: &ExceptionFrame) -> ! {
    loop {}
}

#[entry]
fn main() -> ! {
    loop {}
}

#[pre_init]
unsafe fn pre_init() {}
