# EMANE XML Files
* Table of Contents
{:toc}

## Overview
Introduction to the XML files generated by CORE used to drive EMANE for
a given node.

[EMANE Demo 0](https://github.com/adjacentlink/emane-tutorial/wiki/Demonstration-0)
may provide more helpful details.

## Run Demo
1. Select `Open...` within the GUI
1. Load `emane-demo-files.xml`
1. Click ![Start Button](../static/gui/start.gif)
1. After startup completes, double click n1 to bring up the nodes terminal

## Example Demo
We will take a look at the files generated in the example demo provided. In this
case we are running the RF Pipe model.

### Generated Files

|Name|Description|
|---|---|
|\<node name>-platform.xml|configuration file for the emulator instances|
|\<interface name>-nem.xml|configuration for creating a NEM|
|\<interface name>-mac.xml|configuration for defining a NEMs MAC layer|
|\<interface name>-phy.xml|configuration for defining a NEMs PHY layer|
|\<interface name>-trans-virtual.xml|configuration when a virtual transport is being used|
|\<interface name>-trans.xml|configuration when a raw transport is being used|

### Listing File
Below are the files within n1 after starting the demo session.

```shell
root@n1:/tmp/pycore.46777/n1.conf# ls
eth0-mac.xml  eth0-trans-virtual.xml  n1-platform.xml       var.log
eth0-nem.xml  ipforward.sh            quaggaboot.sh         var.run
eth0-phy.xml  n1-emane.log            usr.local.etc.quagga  var.run.quagga
```

### Platform XML
The root configuration file used to run EMANE for a node is the platform xml file.
In this demo we are looking at `n1-platform.xml`.

* lists all configuration values set for the platform
* The unique nem id given for each interface that EMANE will create for this node
* The path to the file(s) used for definition for a given nem

```shell
root@n1:/tmp/pycore.46777/n1.conf# cat n1-platform.xml
<?xml version='1.0' encoding='UTF-8'?>
<!DOCTYPE platform SYSTEM "file:///usr/share/emane/dtd/platform.dtd">
<platform>
  <param name="antennaprofilemanifesturi" value=""/>
  <param name="controlportendpoint" value="0.0.0.0:47000"/>
  <param name="eventservicedevice" value="ctrl0"/>
  <param name="eventservicegroup" value="224.1.2.8:45703"/>
  <param name="eventservicettl" value="1"/>
  <param name="otamanagerchannelenable" value="1"/>
  <param name="otamanagerdevice" value="ctrl0"/>
  <param name="otamanagergroup" value="224.1.2.8:45702"/>
  <param name="otamanagerloopback" value="0"/>
  <param name="otamanagermtu" value="0"/>
  <param name="otamanagerpartcheckthreshold" value="2"/>
  <param name="otamanagerparttimeoutthreshold" value="5"/>
  <param name="otamanagerttl" value="1"/>
  <param name="stats.event.maxeventcountrows" value="0"/>
  <param name="stats.ota.maxeventcountrows" value="0"/>
  <param name="stats.ota.maxpacketcountrows" value="0"/>
  <nem id="1" name="tap1.0.f" definition="eth0-nem.xml">
    <transport definition="eth0-trans-virtual.xml">
      <param name="device" value="eth0"/>
    </transport>
  </nem>
</platform>
```

### NEM XML
The nem definition will contain reference to the transport, mac, and phy xml
definitions being used for a given nem.

```shell
root@n1:/tmp/pycore.46777/n1.conf# cat eth0-nem.xml
<?xml version='1.0' encoding='UTF-8'?>
<!DOCTYPE nem SYSTEM "file:///usr/share/emane/dtd/nem.dtd">
<nem name="emane_rfpipe NEM">
  <transport definition="eth0-trans-virtual.xml"/>
  <mac definition="eth0-mac.xml"/>
  <phy definition="eth0-phy.xml"/>
</nem>
```

### MAC XML
MAC layer configuration settings would be found in this file. CORE will write
out all values, even if the value is a default value.

```shell
root@n1:/tmp/pycore.46777/n1.conf# cat eth0-mac.xml
<?xml version='1.0' encoding='UTF-8'?>
<!DOCTYPE mac SYSTEM "file:///usr/share/emane/dtd/mac.dtd">
<mac name="emane_rfpipe MAC" library="rfpipemaclayer">
  <param name="datarate" value="1000000"/>
  <param name="delay" value="0.000000"/>
  <param name="enablepromiscuousmode" value="0"/>
  <param name="flowcontrolenable" value="0"/>
  <param name="flowcontroltokens" value="10"/>
  <param name="jitter" value="0.000000"/>
  <param name="neighbormetricdeletetime" value="60.000000"/>
  <param name="pcrcurveuri" value="/usr/share/emane/xml/models/mac/rfpipe/rfpipepcr.xml"/>
  <param name="radiometricenable" value="0"/>
  <param name="radiometricreportinterval" value="1.000000"/>
</mac>
```

### PHY XML
PHY layer configuration settings would be found in this file. CORE will write
out all values, even if the value is a default value.

```shell
root@n1:/tmp/pycore.46777/n1.conf# cat eth0-phy.xml
<?xml version='1.0' encoding='UTF-8'?>
<!DOCTYPE phy SYSTEM "file:///usr/share/emane/dtd/phy.dtd">
<phy name="emane_rfpipe PHY">
  <param name="bandwidth" value="1000000"/>
  <param name="fading.model" value="none"/>
  <param name="fading.nakagami.distance0" value="100.000000"/>
  <param name="fading.nakagami.distance1" value="250.000000"/>
  <param name="fading.nakagami.m0" value="0.750000"/>
  <param name="fading.nakagami.m1" value="1.000000"/>
  <param name="fading.nakagami.m2" value="200.000000"/>
  <param name="fixedantennagain" value="0.000000"/>
  <param name="fixedantennagainenable" value="1"/>
  <param name="frequency" value="2347000000"/>
  <param name="frequencyofinterest" value="2347000000"/>
  <param name="noisebinsize" value="20"/>
  <param name="noisemaxclampenable" value="0"/>
  <param name="noisemaxmessagepropagation" value="200000"/>
  <param name="noisemaxsegmentduration" value="1000000"/>
  <param name="noisemaxsegmentoffset" value="300000"/>
  <param name="noisemode" value="none"/>
  <param name="propagationmodel" value="2ray"/>
  <param name="subid" value="1"/>
  <param name="systemnoisefigure" value="4.000000"/>
  <param name="timesyncthreshold" value="10000"/>
  <param name="txpower" value="0.000000"/>
</phy>
```

### Transport XML
```shell
root@n1:/tmp/pycore.46777/n1.conf# cat eth0-trans-virtual.xml
<?xml version='1.0' encoding='UTF-8'?>
<!DOCTYPE transport SYSTEM "file:///usr/share/emane/dtd/transport.dtd">
<transport name="Virtual Transport" library="transvirtual">
  <param name="bitrate" value="0"/>
  <param name="devicepath" value="/dev/net/tun"/>
</transport>
```
