# coreclr-hosting-shared

[![CI](https://github.com/OpenByteDev/coreclr-hosting-shared/actions/workflows/ci.yml/badge.svg)](https://github.com/OpenByteDev/coreclr-hosting-shared/actions/workflows/ci.yml)
[![crates.io](https://img.shields.io/crates/v/coreclr-hosting-shared.svg)](https://crates.io/crates/coreclr-hosting-shared)
[![Documentation](https://docs.rs/coreclr-hosting-shared/badge.svg)](https://docs.rs/coreclr-hosting-shared)
[![dependency status](https://deps.rs/repo/github/openbytedev/coreclr-hosting-shared/status.svg)](https://deps.rs/repo/github/openbytedev/coreclr-hosting-shared)
[![MIT](https://img.shields.io/crates/l/coreclr-hosting-shared.svg)](https://github.com/OpenByteDev/coreclr-hosting-shared/blob/master/LICENSE)

<!-- cargo-sync-readme start -->

Shared bindings for the [coreclr hosting components](https://github.com/dotnet/runtime/blob/main/docs/design/features/native-hosting.md).

### Related crates
- [nethost-sys](https://crates.io/crates/nethost-sys) - bindings and downloader for the nethost library.
- [hostfxr-sys](https://crates.io/crates/hostfxr-sys) - bindings for the hostfxr library.
- [netcorehost](https://crates.io/crates/netcorehost) - rusty wrapper over the nethost and hostfxr libraries.

### Additional Information
- [Hosting layer APIs](https://github.com/dotnet/core-setup/blob/master/Documentation/design-docs/hosting-layer-apis.md)
- [Native hosting](https://github.com/dotnet/core-setup/blob/master/Documentation/design-docs/native-hosting.md#runtime-properties)
- [Write a custom .NET Core host to control the .NET runtime from your native code](https://docs.microsoft.com/en-us/dotnet/core/tutorials/netcore-hosting)

### License
Licensed under the MIT license ([LICENSE](https://github.com/OpenByteDev/netcorehost/blob/master/LICENSE) or <https://opensource.org/licenses/MIT>)

<!-- cargo-sync-readme end -->
