use core_mqtt_sys::MQTTStatus_t;
// should be replace with use cortex_m::interrupt::Mutex;
use std::cell::Cell;
use std::collections::VecDeque;
use std::sync::{Arc, Mutex};

enum MQTT_status {
    MQTTSuccess = 0,      /* Function completed successfully. */
    MQTTBadParameter,     /* At least one parameter was invalid. */
    MQTTNoMemory,         /* A provided buffer was too small. */
    MQTTSendFailed,       /* The transport send function failed. */
    MQTTRecvFailed,       /* The transport receive function failed. */
    MQTTBadResponse,      /* An invalid packet was received from the server. */
    MQTTServerRefused,    /* The server refused a CONNECT or SUBSCRIBE. */
    MQTTNoDataAvailable,  /* No data available from the transport interface. */
    MQTTIllegalState,     /* An illegal state in the state record. */
    MQTTStateCollision,   /* A collision with an existing state record entry. */
    MQTTKeepAliveTimeout, /* Timeout while waiting for PINGRESP. */
}

/*  Thread Unsafe Functions
An MQTT agent task that manages an MQTT connection and calls coreMQTT APIs.
The APIs used by this task are not thread safe, and each agent task should use
a unique MQTTAgentContext_t (multiple agent tasks may be used to handle multiple
simultaneous MQTT connections, but each must have a unique context).
This task is expected to invoke MQTTAgent_CommandLoop to process commands
from other tasks to call coreMQTT APIs.
*/
pub fn MQTTAgent_Init() -> ffi::MQTTStatus {
    unsafe {
        todo!("MQTT_Init");
        let status: ffi::MQTTStatus = ffi::MQTTStatus_MQTTSuccess;
    }
    if let status = ffi::MQTTStatus_MQTTSuccess {
        todo!("incomingCallback");
        todo!("pIncomingPacketContext");
        todo!("pMsgInterface");
    }

    ffi::MQTTStatus_MQTTSuccess
}
pub fn MQTTAgent_CommandLoop() -> ffi::MQTTStatus {
    unsafe {
        todo!("processCommand -> MQTT_ProcessLoop");
        let status: ffi::MQTTStatus = ffi::MQTTStatus_MQTTSuccess;
    }

    ffi::MQTTStatus_MQTTSuccess
}
pub fn MQTTAgent_ResumeSession(sessionPresent: bool) -> ffi::MQTTStatus {
    if sessionPresent {
        todo!("clearPendingAcknowledgments & resendPublishes -> MQTT_Publish");
    } else {
        todo!("clearPendingAcknowledgments");
    }

    ffi::MQTTStatus_MQTTSuccess
}
pub fn MQTTAgent_CancelAll() -> ffi::MQTTStatus {
    /* Cancel all operations waiting in the queue. */
    /* Cancel any operations awaiting an acknowledgment. */
    ffi::MQTTStatus_MQTTSuccess
}

/*  Thread Safe Functions
 Application tasks that want to perform MQTT operations with thread safety.
 These tasks are any task that is not an MQTT agent task.
 The APIs used by application tasks are thread safe,
 and send commands that are processed by an MQTT agent task in MQTTAgent_CommandLoop.
 These APIs can accept several structures used by either the command or completion callback,
 and these structures MUST remain in scope until the associated command has been completed,
 including MQTTPublishInfo_t, MQTTAgentSubscribeArgs_t, MQTTAgentConnectArgs_t,
 and MQTTAgentCommandContext_t.
 The APIs are asynchronous, so will return as soon as the command has been sent;
 they will not wait for the command to be processed.
*/
pub fn MQTTAgent_Subscribe() -> ffi::MQTTStatus {
    unsafe {
        todo!("createAndAddCommand( SUBSCRIBE, ");
        todo!("addCommandToQueue");
        let status: ffi::MQTTStatus = ffi::MQTTStatus_MQTTSuccess;
    }
    ffi::MQTTStatus_MQTTSuccess
}
pub fn MQTTAgent_Unsubscribe() -> ffi::MQTTStatus {
    unsafe {
        todo!("createAndAddCommand( UNSUBSCRIBE, ");
        todo!("addCommandToQueue");
        let status: ffi::MQTTStatus = ffi::MQTTStatus_MQTTSuccess;
    }
    ffi::MQTTStatus_MQTTSuccess
}
pub fn MQTTAgent_Publish(i: &Arc<Mutex<VecDeque<i32>>>) -> ffi::MQTTStatus {
    unsafe {
        // todo!("createAndAddCommand( PUBLISH, ");
        // todo!("addCommandToQueue");
        let status: ffi::MQTTStatus = ffi::MQTTStatus_MQTTSuccess;
    }
    // *i += 1;
    i.lock().unwrap().push_back(1);
    ffi::MQTTStatus_MQTTSuccess
}
pub fn MQTTAgent_ProcessLoop(i: &Arc<Mutex<VecDeque<i32>>>) -> ffi::MQTTStatus {
    unsafe {
        // todo!("createAndAddCommand( PROCESSLOOP, ");
        // todo!("Call MQTT_ProcessLoop()");
        let status: ffi::MQTTStatus = ffi::MQTTStatus_MQTTSuccess;
    }
    // *i = 100;
    // *i.lock().unwrap() = 10;
    let task_queue = &mut *i.lock().unwrap();
    while task_queue.pop_front() != None {
        println!("next");
    }
    ffi::MQTTStatus_MQTTSuccess
}
pub fn MQTTAgent_Ping() -> ffi::MQTTStatus {
    unsafe {
        todo!("createAndAddCommand( PING, ");
        todo!("addCommandToQueue");
        let status: ffi::MQTTStatus = ffi::MQTTStatus_MQTTSuccess;
    }
    ffi::MQTTStatus_MQTTSuccess
}
pub fn MQTTAgent_Connect() -> ffi::MQTTStatus {
    unsafe {
        todo!("createAndAddCommand( CONNECT, ");
        todo!("addCommandToQueue");
        let status: ffi::MQTTStatus = ffi::MQTTStatus_MQTTSuccess;
    }
    ffi::MQTTStatus_MQTTSuccess
}
pub fn MQTTAgent_Disconnect() -> ffi::MQTTStatus {
    unsafe {
        todo!("createAndAddCommand( DISCONNECT, ");
        todo!("addCommandToQueue");
        let status: ffi::MQTTStatus = ffi::MQTTStatus_MQTTSuccess;
    }
    ffi::MQTTStatus_MQTTSuccess
}
pub fn MQTTAgent_Terminate() -> ffi::MQTTStatus {
    unsafe {
        todo!("createAndAddCommand( TERMINATE, ");
        todo!("addCommandToQueue");
        let status: ffi::MQTTStatus = ffi::MQTTStatus_MQTTSuccess;
    }
    ffi::MQTTStatus_MQTTSuccess
}
#[cfg(test)]
mod tests {
    use crate::agent;
    use std::{collections::VecDeque, ffi::CString, sync::Arc, sync::Mutex};

    use core_mqtt_sys::MQTT_Publish;
    #[test]
    fn macth_topic() {
        let topic = "topic/match/1";
        let filter = "topic/#";
        let mut ret: bool = false;
        let r = &mut ret as *mut bool;
        let t = CString::new(topic).expect("CString::new failed");
        let tlen: u16 = topic.len().try_into().unwrap();
        let f = CString::new(filter).expect("CString::new failed");
        let flen: u16 = filter.len().try_into().unwrap();

        // core mqtt client library already checked, so it's safe eventually.
        unsafe {
            let status: ffi::MQTTConnectionStatus =
                ffi::MQTT_MatchTopic(t.as_ptr(), tlen, f.as_ptr(), flen, r);
            assert_eq!(status, ffi::MQTTStatus_MQTTSuccess);
        }
        assert_eq!(ret, true);
    }
    #[test]
    fn task_queue() {
        // let message = Mutex::new(Cell::new(0));
        let message = Arc::new(Mutex::new(VecDeque::new()));
        // let mut message = 0;
        // let message_ref = &mut message;
        agent::MQTTAgent_Publish(&message);
        agent::MQTTAgent_Publish(&message);
        agent::MQTTAgent_Publish(&message);
        agent::MQTTAgent_ProcessLoop(&message);
        assert_eq!(*message.lock().unwrap(), []);
    }
}
